//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Motion capture macro Ver 0.1r011201a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
// sample motion object (chain definition)
/*
#local T_chain =
texture {
 pigment { color < 0.8, 0.6, 0.6 > }
 finish { metallic ambient 0.1 diffuse 0.4 reflection 0.25 specular 1 }
}
//
#local Tr = 5; #local Tw = 1;
#local Chain_seg1 = torus { Tr, Tw rotate -90*x clipped_by { plane { y, 0 } rotate 90*z } }
#local Chain_Seg2 = cylinder { < Tr, 0, 0 >, < -Tr, 0, 0 >, Tw open }
//
#local Chain_seg = 
union {
 object { Chain_seg1 translate  Tr*x }
 object { Chain_seg1 rotate 180*z translate -Tr*x }
 object { Chain_Seg2 translate  Tr*y }
 object { Chain_Seg2 translate -Tr*y }
}
*/
//**********************************************************************************
// sample motion functions
/*
#macro Motion_function(Tp,Mv,Mh,Func_type)
 #switch (Func_type)
  #case(1) #local Mv=radians(60); #local Mh=0; #break // straight line
  #case(2) #local Mv=-cos(Tp); #local Mh=pi/4; #break // sin
  #case(3) #local Mv= sin(Tp); #local Mh=pi/4; #break // cos
  #case(4) #local Mv=Tp; #local Mh=0; #break          // circle
  #case(5) #local Pr=2/9; #local Mv=Pr/pow(1+pow(Pr*Tp,2),3/2)+Mv; #local Mh=0; #break
 #end
#end
*/
//----------------------------------------------------------------------------------
// sample motion object
/*
#macro Motion_obj(Obj_type,Tcnt)
 #switch(Obj_type)
 #case(0)
  object { Chain_seg texture { T_chain } rotate 360*Tcnt*x }
 #break
 #end
#end
*/
//**********************************************************************************
// catch of motion
#macro Catch_motion(Obj_type,Pv,Ds,Pm,Func_type)
#local Ts=Pm.x; #local Cp=Pm.t-1e-14;
#local Te=Pm.x*(1-Cp)+Pm.y*Cp; //#local Te=Pm.x*(1-Pm.t)+Pm.y*Pm.t;
#if(Pm.z>1) #local Ta=(Pm.y-Pm.x)/(Pm.z-1); #else local Ta=(Pm.y-Pm.x); #end #local Mv=0; #local Mh=0;
 Motion_function(Ts,Mv,Mh,Func_type)
 #while(Ts<Te)
 #local Pv=Pv+<Ds*sin(Mv)*cos(Mh),Ds*cos(Mv),Ds*sin(Mv)*sin(Mh)>; // polar coordinates
 Motion_function(Ts+Ta,Mv,Mh,Func_type)
 #local Ts=Ts+Ta; #end
 #local Tcnt=(Ts-Pm.x)/(Pm.y-Pm.x);
 object { Motion_obj(Obj_type,Tcnt) rotate(90-degrees(Mv))*z rotate(-degrees(Mh))*y translate Pv }
#end
//----------------------------------------------------------------------------------
//Catch_motion(0,<80,-120,160>,20+6,<-pi,pi,16, 0/15>,3)
//Catch_motion(0,<80,-120,160>,20+6,<-pi,pi,16,10/15>,3)
/*
#local Fn=16; #local Cp=0; #while(Cp<=10/(Fn-1))
 Catch_motion(0,<80,-120,160>,20+6,<-pi,pi,Fn,Cp>,3)
#local Cp=Cp+1/(Fn-1); #end 
*/
//**********************************************************************************
// locus of motion
#macro Locus_motion(Obj_type,Pv,Sv,V1,Func_type)
#local Ts=V1.x; #local Te=V1.y; #local Ta=V1.z;
#local Ds=Sv*Ta; #local Mv=0; #local Mh=0;
 #while(Ts<Te)
 Motion_function(Ts,Mv,Mh,Func_type)
 #local Tcnt=(Ts-V1.x)/(V1.y-V1.x); //#local Fn=(V1.y-V1.x+V1.z)/V1.z;
 object { Motion_obj(Obj_type,Tcnt) rotate(90-degrees(Mv))*z rotate(-degrees(Mh))*y translate Pv }
 #local Pv=Pv+<Ds*sin(Mv)*cos(Mh),Ds*cos(Mv),Ds*sin(Mv)*sin(Mh)>; // polar coordinates
 #local Ts=Ts+Ta; #end
#end
//----------------------------------------------------------------------------------
//Locus_motion(0,< -80,-50,0>,(20-2)/0.6,<0,6,0.6>,1)
//Locus_motion(0,< 0,-60,-10>,(20+2)/0.6,<0,6,0.6>,2)
//Locus_motion(0,<80,-120,160>,(20+6)*15/(2*pi),pi*<-1,1,2/15>,3)
//Locus_motion(0,<60,10,0>,(20+4)*8/pi,pi*<-1,1,1/8>,4)
//Locus_motion(0,<-60,-50,0>,(20-2)*2,<0,5,1/2>,5)
//**********************************************************************************
#macro Parabola_function(Sa,Sv,Gaccel,Tp,Pv)
 #local Pv=<Sv*cos(radians(Sa))*Tp,Sv*sin(radians(Sa))*Tp-Gaccel/2*pow(Tp,2),0>;
#end
//----------------------------------------------------------------------------------
#macro RtoSpherical_coordinates(Pv)
 #local RR=vlength(Pv); #local Rh=vlength(<Pv.x,0,Pv.z>);
 #if(Rh!=0) 
  #if(Pv.z/Rh>=0) #local Sg=1; #else #local Sg=-1; #end
  #local HH=Sg*acos(Pv.x/Rh);
 #else #local HH=0; #end
 #if(RR!=0)
  #if(Pv.y/RR>=0) #local Sg=1; #else #local Sg=-1; #end 
  #local VV=Sg*acos(Rh/RR);
 #else #local VV=0; #end
 #local Pv=<RR,HH,VV>;
#end
//----------------------------------------------------------------------------------
// locus of parabolic motion (Gaccel=9.8) & uniform velocity motion (Gaccel=0)
#macro Parabolic_motion(Obj_type,S1,Gaccel,V1)
#local Sa=S1.x; #local Sv=S1.y;
#local Ts=V1.x; #local Te=V1.y; #local Ta=V1.z; #local Pv=<0,0,0>; 
 Parabola_function(Sa,Sv,Gaccel,Ts,Pv) #local P1=Pv;
 #while(Ts<Te)
 Parabola_function(Sa,Sv,Gaccel,Ts+Ta,Pv) #local P2=Pv;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv)
 #local Tcnt=(Ts-V1.x)/(V1.y-V1.x);
 object { Motion_obj(Obj_type,Tcnt) rotate degrees(Pv.z)*z rotate -degrees(Pv.y)*y translate P1 }
 #local P1=P2;
 #local Ts=Ts+Ta; #end
#end
//----------------------------------------------------------------------------------
//union { Parabolic_motion(0,<0,20-2>,0,<0,10,1>) translate -80*x } //(Gaccel=0)
//union { Parabolic_motion(0,<0,26>,9.8,<0,10,0.8>) translate <-60,60,0> } //(Gaccel=9.8) 
//union { Parabolic_motion(0,<60,40>,9.8,<0,10,1>) scale 0.8 translate -80*x }
//**********************************************************************************
// capture of motion
#macro Motion_capture(Class,Obj_type,Pv,Ds,V1,Func_type)
#switch (Class)
  #case(0) Parabolic_motion(Obj_type,Pv,Ds,V1) #break
  #case(1) Locus_motion(Obj_type,Pv,Ds,V1,Func_type) #break
  #case(2) Catch_motion(Obj_type,Pv,Ds,V1,Func_type) #break
 #end
#end
//----------------------------------------------------------------------------------
//Motion_capture(0,0,<-90,8>,9.8,<0,10,1>,0) // parabolic motion
//Motion_capture(1,0,<-80,-50,0>,(20-2)/0.6,<0,6,0.6>,1) // locus of motion
//Motion_capture(2,0,<-80,-20,0>,30,<-pi,pi,16,2/15>,2)  // catch of motion
//**********************************************************************************