//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Picture frame generate type 0.1a000214a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
#macro Picture_frame(PFsize,Map_file)
#local Pf_width = PFsize.x; #local Pf_height = PFsize.y;
// file type choice
#local File_type = substr(Map_file,strlen(Map_file)-2,3)
#if(strcmp(File_type,"bmp")=0) #local P_file = pigment { image_map { sys Map_file once map_type 0 interpolate 2 } } #end
#if(strcmp(File_type,"jpg")=0) #local P_file = pigment { image_map{ jpeg Map_file once map_type 0 interpolate 2 } } #end
#if(strcmp(File_type,"png")=0) #local P_file = pigment { image_map { png Map_file once map_type 0 interpolate 2 } } #end

// definition
#local Scale_pf = 4;

// texture
#ifndef (T_pictureframe) #local T_pictureframe =
 texture {
  pigment { wood
            turbulence 0.04
            octaves 3
            scale < 0.05, 0.05, 1 > 
            color_map { [ 0.1 rgb < 0.48, 0.32, 0.12 > ]
                        [ 0.9 rgb < 0.32, 0.20, 0.08 > ] } } } #end
// frame
#local Frame_org =
//difference {
 prism {
 linear_sweep
 bezier_spline 0,1,56
 <-2.01,0><-2.01,0><-2,-0.21><-2,-0.21>
 <-2,-0.21><-2,-0.21><-1.81,-0.21><-1.81,-0.21>
 <-1.81,-0.21><-1.81,-0.21><-1.81,-0.4><-1.81,-0.4>
 <-1.81,-0.4><-1.81,-0.4><-2.01,-0.4><-2.01,-0.4>
 <-2.01,-0.4><-2.01,-0.4><-2,-0.6><-2,-0.6>
 <-2,-0.6><-2,-0.6><-1.81,-0.6><-1.81,-0.6>
 <-1.81,-0.6><-1.81,-0.6><-1.81,-0.79><-1.81,-0.79>
 <-1.81,-0.79><-1.81,-0.79><-2,-0.79><-2,-0.79>
 <-2,-0.79><-2,-0.79><-2,-1><-2,-1>
 <-2,-1><-2,-1><-1.547,-0.972><-1.32,-0.9>
 <-1.32,-0.9><-1.093,-0.828><-1.016,-0.704><-0.79,-0.63>
 <-0.79,-0.63><-0.564,-0.556><0,-0.5><0,-0.5>
 <0,-0.5><0,-0.5><0,0><0,0>
 <0,0><0,0><-2.01,0><-2.01,0>
 scale < 1, 24, 1 >*Scale_pf //}
 //box { < -Scale_pf*5/4, -Scale_pf*5/4, -Scale_pf*5/4 >, < Scale_pf*5/4, Scale_pf*5/4, Scale_pf*5/4 > rotate 45*z }
 //box { < -Scale_pf*5/4, -Scale_pf*5/4, -Scale_pf*5/4 >, < Scale_pf*5/4, Scale_pf*5/4, Scale_pf*5/4 > rotate 45*z translate 24*Scale_pf*y }
 translate < 0, -24*Scale_pf/2, 0 >
}
//
#local Frame_seg =
union {
 object { Frame_org scale < 1,Pf_height+(1-Pf_height)/6,1 > translate -40*Pf_width*x }
 object { Frame_org scale < 1,Pf_height+(1-Pf_height)/6,1 > rotate 180*z translate 40*Pf_width*x }
 object { Frame_org scale < 1,Pf_width+(1-Pf_width)/6,1 > rotate -90*z translate 40*Pf_height*y }
 object { Frame_org scale < 1,Pf_width+(1-Pf_width)/6,1 > rotate  90*z translate -40*Pf_height*y }
 texture { T_pictureframe }
}

// image maping file
#ifndef (P_file) #local P_file =
  pigment { wood
            turbulence 0.06
            octaves 3
            scale < 0.01, 0.01, 0.5 > 
            color_map { [ 0.1 rgb < 0.60, 0.44, 0.24 > ]
                        [ 0.9 rgb < 0.44, 0.32, 0.20 > ] }
            rotate 30*z
            translate -10*x } #end 
// picture 
#local Scale_pic = 2;
#local Picture_seg = 
object {
 plane { z,0 clipped_by { box { < -1, -1, -1 >,< 1, 1, 1 > } } } 
 texture { pigment { P_file /*image_map { png Map_file once map_type 0 interpolate 2 }*/ }
           scale < Scale_pic, Scale_pic, 1 > 
           translate < -Scale_pic/2, -Scale_pic/2, 0 > }
 scale < 40*Pf_width, 40*Pf_height, 1 >
 translate -(1e-14)*z
}

// glass
#if(strcmp(Map_file,"mirror")=0)
 #local T_glass = texture { pigment { color rgb 1 } finish { ambient 0 diffuse 0 reflection 0.98 } }
#else
 #local T_glass = texture {
 pigment { color rgbt 1 }
 finish { ambient 0 diffuse 0 reflection 0.1 phong 0.3 phong_size 60 specular 0.1 roughness 0.001 } }
#end
#local Thick_g = 0.1;
#local Glass_seg =
box { < -1, -1, -1 >,< 1, 1, 1 >
 texture { T_glass }
 interior { ior 1.45 }
 scale < 40*Pf_width, 40*Pf_height, Thick_g >
 translate -(Thick_g+1e-5)*z
}

// picture frame generate
union { object { Frame_seg } object { Picture_seg } object { Glass_seg } }

#end
//----------------------------------------------------------------------------------
//object { Picture_frame((1+sqrt(5))/2,1,"sample.png") scale 0.8 }
//**********************************************************************************


