// Persistence Of Vision raytracer version 3.5 beta
// Living room with a dining area Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"

global_settings { assumed_gamma 2.2 }

camera { location < 10, 40, -200 >
         look_at 0
         angle 20 }

light_source{ < 100, 500, -800 > color rgb 1 fade_distance 1000 fade_power 1 }
light_source{ <-100, 500, -800 > color rgb 0.5 shadowless }

  
//**********************************************************************************
coordinate_color( 120, 0.7, 0.3, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
// water definition
coordinate_color(360,0.00,0.85,1,2)
coordinate_color(180,0.12,0.60,1,3)
coordinate_color(150,0.18,0.25,1,4)
coordinate_color(150,0.25,0.15,1,5)
#local P_water =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.10 color rgb <R2,G2,B2> color rgb <R3,G3,B3> ]
                       [0.1,0.50 color rgb <R3,G3,B3> color rgb <R4,G4,B4> ]
                       [0.5,1.00 color rgb <R4,G4,B4> color rgb <R5,G5,B5> ] }
           scale <6,4,6>
 }
//
coordinate_color(120,1,0.5,1,1)
#local T_water =
texture {
 pigment { color rgb <R1,G1,B1> filter 0.9 }
 pigment { P_water transmit 0.7 }
 normal { ripples 0.75 frequency 10 }
 finish { reflection 0.3 }
}
//----------------------------------------------------------------------------------
union {
 plane { y,100 texture { T_water scale 46 } interior { ior 1.02 caustics 0.04 } }
 plane { y,0 pigment { color rgb 1 } normal { bumps 0.3 scale 24 } }
 scale 0.8 rotate 30*y translate (-100-20)*y
}
//**********************************************************************************
#include "Blossom.def.inc"
//----------------------------------------------------------------------------------
#local Obj_seg = object { Blossom_seg scale 0.3 }
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
#macro Line_function(Tp,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px=20*Tp; #local Py=0; #local Pz=40*sin(Tp); #break // sin
 #end
#end
//----------------------------------------------------------------------------------
union { Space_arrange(pi*<-1.6,0.8,1/5>,1) rotate 26*y translate <0,-60,100> }
//**********************************************************************************
// picture frame definition
coordinate_color(0,0.6,0.5,1,1 )
coordinate_color(0,0.6,0.4,1,2 )
#local T_pictureframe =
 texture {
  pigment { wood
            turbulence 0.04
            octaves 3
            scale < 0.05, 0.05, 1 > 
            color_map { [ 0.1 rgb < R1, G1, B1 > ]
                        [ 0.9 rgb < R2, G2, B2 > ] } } 
}
//----------------------------------------------------------------------------------
#include "Picture_frame.gen.inc"
//----------------------------------------------------------------------------------
object { Picture_frame(<4/3,1>,"fruit.jpg") scale 0.5 translate <-36,-10,150> }
//**********************************************************************************
#include "Glass.def.inc"
//**********************************************************************************
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Pr=0.5*sin(pi*Se)+0.5*pow(Se,2)+0.5;
          #local Px=2*Pr*cos(Ss); #local Py=2*Se; #local Pz=2*Pr*sin(Ss); #break //glass

 #case(1) #local Rr=206*cos(sqrt(Se));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=-1.6*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //pine

 #case(2) #local Rr=8+exp(1.2*pow(cos(Ss),0.8));
          #local Px=0.9*Rr*sin(Se)*cos(Ss); #local Py=0.9*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //peich
 
 #case(3) #local Rr=10*cos(sqrt(Se));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=1.2*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //berry
 
 #case(8) #local Rr=6*pow(Se,1.05);
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //apple
 
 #case(9) #local Rr=max(2.5*0.85,2.5*abs(cos(Se)));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=1.2*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //lemon
 #end
#end
//**********************************************************************************
// tumbler glass definition
coordinate_color( 270, 0.9, 0.6, 3, 1 )
#local T_tumbler =
 texture {
  pigment { ripples
            color_map { [ 0.0 rgbf < R2, G2, B2, 0.8 > ]
                        [ 0.5 rgbf < R3, G3, B3, 0.8 > ]
                        [ 1.0 rgbf < R1, G1, B1, 0.8 > ] } scale 4 }
  finish { ambient 0.1 diffuse 0.1 reflection 0.3 specular 1 roughness 0.001 }
}
#local Glass_seg = Surface_tri4m(pi*< -1, 1, 1/18 >,pi*< -1/3.8, 1/2.2, 1/12 >,0)
#local Tumbler_obj = object { Glass_seg texture { T_tumbler } interior { ior 1.4 } }
//----------------------------------------------------------------------------------
coordinate_color( 151, 0.36, 0.99, 3, 1 )
#local T_glass =
 texture {
  pigment { color rgbf < R1, G1, B1, 0.75 > }
  finish { ambient 0.1 diffuse 0.1 reflection 0.25 specular 1.0 roughness 0.001 }
}
#local Glass_obj = object { Glass_seg texture { T_glass } interior { ior 1.45 } }
//**********************************************************************************
// pine definition
#include "Grass_blade.gen.inc"
//
coordinate_color( 90, 1.0, 0.4, 1, 1 )
coordinate_color( 90, 1.0, 0.6, 1, 2 )
coordinate_color( 90, 1.0, 0.8, 1, 3 )
#local T_grass = 
  texture {
   pigment { gradient z
             color_map { [ 0.0 rgb <R1,G1,B1> ]
                         [ 0.5 rgb <R2,G2,B2> ]
                         [ 1.0 rgb <R3,G3,B3> ] }
             scale 6/10 }
  }
// parameter (Grass_length,Grass_width,Grass_slop,Grass_count)
#local Pine_leaf =
union {
 union { Grass_gen(6,14,60,5) }
 union { Grass_gen(5,14,50,5) rotate 360/5*1/3*y }
 union { Grass_gen(4,14,40,5) rotate 360/5*2/3*y }
 union { Grass_gen(4,14,30,5) }
 union { Grass_gen(4,14,20,5) rotate 360/5*1/2*y }
 //
 union { Grass_gen(3,14,3,14) }
 union { Grass_gen(3,14,6,14) rotate 360/14*1/3*y }
 union { Grass_gen(3,14,4,14) rotate 360/14*2/3*y }
 union { Grass_gen(3.6,14,7,9) }
 union { Grass_gen(3.8,14,7,9) rotate 360/9*1/3*y }
 union { Grass_gen(4.0,14,7,9) rotate 360/9*2/3*y }
}
//----------------------------------------------------------------------------------
coordinate_color(-20, 1.0, 0.7, 1, 1 )
coordinate_color(  0, 1.0, 0.7, 1, 2 )
coordinate_color( 20, 1.0, 0.7, 1, 3 )
#local T_pine =
 texture {
  pigment { marble
            turbulence 0.5
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 0.5 rgb < R2, G2, B2 > ]
                        [ 1.0 rgb < R3, G3, B3 > ] } rotate 90*z scale 26 }
 normal { marble
          slope_map { [ 0.00 <0.5, 1> ]
                      [ 0.25 <1.0, 0> ]
                      [ 0.50 <0.5,-1> ]
                      [ 0.75 <0.0, 0> ]
                      [ 1.00 <0.5, 1> ] } scale 1.2 }
 }
//----------------------------------------------------------------------------------
#local Pine_botom = sphere { 0, 100 texture { T_pine } }
//----------------------------------------------------------------------------------
//
#local Br=16;
#local Obj_seg =
union {
 sphere { 0, Br  translate -Br/6*x }
 sphere { 0, Br/2 translate Br*0.7*y }
 sphere { 0, Br translate  Br/6*x }
 torus { Br, Br/4 pigment { color rgb <R1,G1,B1> } scale <1,0.5,1> }
 torus { Br, Br/2 clipped_by { plane { x,0 } } scale <1,0.7,1> rotate  75*z }
 torus { Br, Br/2 clipped_by { plane { x,0 } } scale <1,0.7,1> rotate 105*z }
 texture { T_pine }
 scale <1,1,0.3>
 rotate <0,90,-5>
}
//----------------------------------------------------------------------------------
#local Pine_obj =
union {
 object { Pine_leaf scale 8*1.2 translate 6*y }
 torus { 50,20 texture { T_grass } translate 54*y }
 object { Normal_tri4u(pi*<1,3,1/11>,pi*<1.3,1.85,1/11>,1) translate -182*y }
 object { Pine_botom translate -200*y }
}
//**********************************************************************************
// peich definition
coordinate_color( -60, 1.0, 0.64, 1, 1 )
coordinate_color(  10, 1.0,  0.8, 1, 2 )
coordinate_color(  30, 1.0,  0.9, 1, 3 )
#local T_peich =
 texture {
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 0.5 rgbt < R2, G2, B2, 0.2 > ]
                        [ 1.0 rgbt < R3, G3, B3, 0.3 > ] } rotate 90*z scale 28 }
  normal { bumps 0.3 scale 0.1 }
  finish { ambient 0.3 reflection 0.1 brilliance 0.9 diffuse 0.6 }
 }
#local Peich_seg = Smooth_tri2m(pi*< -1, 1, 1/8 >,pi*< -1, 1, 1/28 >,2)
#local Peich_obj = object { Peich_seg texture { T_peich } }
//**********************************************************************************
// berry definition
#include "Leaf_typeA.def.inc"
coordinate_color( 70, 1.0, 0.4, 1, 1 )
#local P_leaf =
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.00 rgb  < R1, G1, B1 > ]
                        [ 0.99 rgbt < B1, R1, G1, 0.2 > ]
                        [ 1.00 rgbt < G1, B1, R1, 0.3 > ] } rotate 90*z scale <0.1,1,0.1> }
//----------------------------------------------------------------------------------
coordinate_color( 270, 0.4, 0.7, 1, 1 )
#local P_calyx = 
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb  < R1, G1, B1 > ]
                        [ 0.5 rgbt < B1, R1, G1, 0.2 > ]
                        [ 1.0 rgbt < G1, B1, R1, 0.3 > ] } rotate 90*z scale 2 }
//
#local Tr=30; #local Lw=1; #local Ra1=-70; #local Ra2=70; #local Ox=Tr; #local Oz=0;
#local Calyx_seg =
 torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y }
 translate Tr*z rotate -90*x
}
//
#local Berry_calyx =
union {
 object { Calyx_seg }
 object { Calyx_seg rotate 180*z translate < Tr*cos(radians(Ra2))*2,(Tr-Tr*sin(radians(Ra2)))*2,0> }
 object { Calyx_seg rotate 180*z translate <-Tr*cos(radians(Ra2))*2,(Tr-Tr*sin(radians(Ra2)))*2,0> }
 cone { 0, Lw*2.5, <0,-6,0>, Lw }
 scale < 0.5,1,1 >
 translate 6*y
}
//----------------------------------------------------------------------------------
coordinate_color(  0, 1.0, 0.64, 1, 1 )
coordinate_color( 70, 1.0, 0.8,  1, 2 )
coordinate_color( 90, 1.0, 0.9,  1, 3 )
#local T_berry =
 texture {
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb  < R1, G1, B1 > ]
                        [ 0.5 rgbt < R2, G2, B2, 0.2 > ]
                        [ 1.0 rgbt < R3, G3, B3, 0.3 > ] } rotate 90*z scale 7*4 }
  normal { bumps 0.3 scale 0.1 }
  finish { diffuse 0.6 reflection 0.1 brilliance 0.9 }
 }
#local Berry_seg = Smooth_tri2m(pi*<1,3,1/8>,pi*<1,1.99,1/12>,3)
//----------------------------------------------------------------------------------
#local Berry_obj =
union {
 object { Berry_seg texture { T_berry } scale 4 }
 object { Berry_calyx pigment { P_calyx } rotate 20*z translate 9*y }
 object { Leaf_seg pigment { P_leaf } rotate -20*y scale 2 translate 2*y }
}
//**********************************************************************************
// apple definition
coordinate_color( -30, 0.6, 0.4, 1, 1 )
#local P_calyx = pigment { color rgbt < R1, G1, B1, 0.2 > }
#local Tr=60; #local Lw=1; #local Ra1=-180; #local Ra2=-160+180; #local Ox=Tr; #local Oz=0;
#local Apple_calyx =
union {
 torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y } }
 cone { 0, Lw, <0,0,5>, Lw*2 rotate Ra2*y translate <-Tr*cos(radians(Ra2)),0,Tr*sin(radians(Ra2))> }
 translate < Ox, 0, Oz >
 rotate -90*x
}
//----------------------------------------------------------------------------------
coordinate_color( -30, 1.0, 0.5, 1, 1 )
coordinate_color( -10, 0.9, 0.6, 1, 2 )
#local T_apple =
 texture { 
  pigment { ripples
            turbulence 0.2
            color_map { [ 0.0 rgbf < R1, G1, B1, 0.0 > ]
                        [ 0.5 rgbf < R2, G2, B2, 0.1 > ] 
                        [ 1.0 rgbf < R1, G1, B1, 0.0 > ] } scale 0.1 }
 normal { bumps 0.1 scale 0.1 }
 finish { ambient 0.4 diffuse 0.5 reflection 0.3 phong 0.2 brilliance 0.5 }
}
#local Apple_seg = Smooth_tri2m(pi*<-1, 1, 1/24 >,pi*< 0, 0.95, 1/24 >,8)
//----------------------------------------------------------------------------------
coordinate_color( 60, 0.9, 0.78, 1, 3 )
#local Apple_obj =
union {
 object { Apple_seg texture { T_apple } scale 4 }
 difference {
  sphere { 0,4.3 texture { T_apple } scale <1,0.28,1> translate -78*y }
  cone { -80*y,4,-77.2*y,0 pigment { color rgb < R3, G3, B3 > } } }
 object { Apple_calyx pigment { P_calyx } translate 2*y }
}
//**********************************************************************************
// lemon definition
coordinate_color( 30, 0.99, 0.6, 3, 1 )
#local T_lemon =
 texture {
  pigment { ripples
            color_map { [ 0.00 rgb < R2, G2, B2 > ]
                        [ 0.01 rgb < R1, G1, B1 > ]
                        [ 1.00 rgb < R1, G1, B1 > ] } 
            scale 2 }
 finish { ambient 0.3 reflection 0.4 specular 0.8 roughness 0.001 }
 normal { bumps 0.4 scale 0.08 }
}
#local Lemon_seg = Surface_tri4m(pi*< -1, 1, 1/12 >,pi*< 0, 1, 1/18 >,9)
#local Lemon_obj = object { Lemon_seg texture { T_lemon } }
//**********************************************************************************
#include"Dining_set.def.inc"
//----------------------------------------------------------------------------------
// living dining set
#local Th=12+4+0.5;
union {
 union {
  object { General_glass scale 0.05 translate < -7, Th, -15 > }
  object { Tea_glass scale 0.04 translate < 8, Th, -15 > }
  object { Glass_obj scale 1 translate < 0, Th+1.9, 0 > }
  object { Tumbler_obj scale 1 translate < 6, Th+1.9, 6 > }
  //object { Pine_obj scale 0.02 rotate < 30, 30, 30 > translate < -6, Th+8*2/3, -8 > }
  object { Peich_obj scale 0.2 rotate < 0, -100+170, 210 > translate < 4, Th+2, 2 > }
  object { Berry_obj scale 0.06 rotate < -30, -30, 45 > translate < 0, Th+2, -10 > }
  object { Apple_obj scale 0.045 translate < -2, Th+4.65*4.5/6, -6 > }
  object { Lemon_obj scale 0.7 rotate < -20, 0, 90 > translate < 1, Th+1.47, -6 > }
  object { Table_seg }
  object { Chair_seg translate < 20, 0, 8 > }
  object { Chair_seg translate < 20, 0,-8 > }
  object { Chair_seg translate < 20, 0,-8 > rotate 180*y }
  object { Chair_seg translate < 20, 0, 8 > rotate 180*y }
  rotate 30*y
 }
 union {
  object { Sofa_seg rotate 30*y translate < 15, 0, 80 > }
  object { Stool_seg rotate -10*y translate < 0, 0, 50 > }
 }
 translate <1,-13,-20>
}
//**********************************************************************************
coordinate_color(120,1,0.5,1,1)
#local P_text = pigment { color rgb <R1,G1,B1> }
//
object { Text_doll pigment { P_text } rotate <-20,30,0> translate <20,-35,800> }
object { Text_house pigment { P_text } rotate <-20,30,0> translate <40,-35,600> }
//**********************************************************************************
#include "Motion_capture.mcr.inc"
//----------------------------------------------------------------------------------
#macro Motion_obj(Obj_type,Tcnt)
 #switch(Obj_type)
 #case(1)
  object { Pine_obj scale 0.02*2.4/(Tcnt*2+1) rotate -360*Tcnt*x }
 #break
 #end
#end
//----------------------------------------------------------------------------------
// locus of parabolic motion
union { Parabolic_motion(1,<18.6,55.2>,9.8,<0,5,1>) rotate 72*y translate <-46,0,154> }
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Lc=< 10, 40, -200 >; #local La=< 0, 0, 0 >; #local Ag=20+4.2;
#local Sz=0.5; #local Lz=-vlength(Lc-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+4.8; #local Ty=Vx+5; #local Tz=Sz*Lz;
#local Rx=degrees(atan2((Lc.y-La.y),sqrt(pow((Lc.x-La.x),2)+pow((Lc.z-La.z),2))));
#local Ry=180+degrees(atan2((Lc.x-La.x),(Lc.z-La.z))); #local Rz=0;
//object { Sealing scale 0.12 translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > translate La }
//----------------------------------------------------------------------------------





