// Persistence Of Vision raytracer version 3.5 beta
// Fruit Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { location < 0, 0, -200 >
         look_at < 0, 0, 0 >
         angle 40 }

light_source { < 0, 0,-500 > color 1 *1.2 }
light_source { < 0, 500, 0 > color 1 *0.5 fade_distance 500 fade_power 1 }
light_source { < 500, 0, 0 > color 1 *0.5 }

//**********************************************************************************
coordinate_color( 120, 0.7, 0.3, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
// sky
coordinate_color( 120, 0.7, 0.3, 3, 1 )
sky_sphere {
 pigment { bozo
           turbulence 0.7
           octaves 6
           omega 0.7
           lambda 2
           color_map { [ 0.0, 0.7 color rgb < R2, G2, B2 > color rgb < R1, G1, B1 > ]
                       [ 0.7, 0.9 color rgb < R1, G1, B1 > color rgb < R3, G3, B3 > ]
                       [ 0.9, 1.0 color rgb < R3, G3, B3 > color rgb < R2, G2, B2 > ] }
           rotate -60*y }
}
//**********************************************************************************
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Pr=0.5*sin(pi*Se)+0.5*pow(Se,2)+0.5;
          #local Px=2*Pr*cos(Ss); #local Py=2*Se; #local Pz=2*Pr*sin(Ss); #break //glass

 #case(1) #local Rr=206*cos(sqrt(Se));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=-1.6*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //pine

 #case(2) #local Rr=8+exp(1.2*pow(cos(Ss),0.8));
          #local Px=0.9*Rr*sin(Se)*cos(Ss); #local Py=0.9*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //peich
 
 #case(3) #local Rr=10*cos(sqrt(Se));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=1.2*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //berry
 
 #case(8) #local Rr=6*pow(Se,1.05);
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //apple
 
 #case(9) #local Rr=max(2.5*0.85,2.5*abs(cos(Se)));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=1.2*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break //lemon
 #end
#end
//**********************************************************************************
// glass definition (initialize)
coordinate_color( 270, 0.9, 0.6, 3, 1 )
#local T_glass =
 texture {
  pigment { ripples
            color_map { [ 0.0 rgbf < R2, G2, B2, 0.8 > ]
                        [ 0.5 rgbf < R3, G3, B3, 0.8 > ]
                        [ 1.0 rgbf < R1, G1, B1, 0.8 > ] } 
            scale 4 }
  finish { ambient 0.1 diffuse 0.1 reflection 0.3 specular 1 roughness 0.001 }
}
#local Glass_obj = object { Surface_tri4m(pi*< -1, 1, 1/18 >,pi*< -1/3.8, 1/2.2, 1/12 >,0) }
// glass
object { Glass_obj texture { T_glass } interior { ior 1.4 } scale 10 translate < 30, -20, 10 > }
//**********************************************************************************
// pine definition
#include "Grass_blade.gen.inc"
//
coordinate_color( 90, 1.0, 0.4, 1, 1 )
coordinate_color( 90, 1.0, 0.6, 1, 2 )
coordinate_color( 90, 1.0, 0.8, 1, 3 )
#local T_grass = 
  texture {
   pigment { gradient z
             color_map { [ 0.0 rgb <R1,G1,B1> ]
                         [ 0.5 rgb <R2,G2,B2> ]
                         [ 1.0 rgb <R3,G3,B3> ] }
             scale 6/10 }
  }
// parameter (Grass_length,Grass_width,Grass_slop,Grass_count)
#local Pine_leaf =
union {
 union { Grass_gen(6,14,60,5) }
 union { Grass_gen(5,14,50,5) rotate 360/5*1/3*y }
 union { Grass_gen(4,14,40,5) rotate 360/5*2/3*y }
 union { Grass_gen(4,14,30,5) }
 union { Grass_gen(4,14,20,5) rotate 360/5*1/2*y }
 //
 union { Grass_gen(3,14,3,14) }
 union { Grass_gen(3,14,6,14) rotate 360/14*1/3*y }
 union { Grass_gen(3,14,4,14) rotate 360/14*2/3*y }
 union { Grass_gen(3.6,14,7,9) }
 union { Grass_gen(3.8,14,7,9) rotate 360/9*1/3*y }
 union { Grass_gen(4.0,14,7,9) rotate 360/9*2/3*y }
}
//----------------------------------------------------------------------------------
// pine
coordinate_color(-20, 1.0, 0.7, 1, 1 )
coordinate_color(  0, 1.0, 0.7, 1, 2 )
coordinate_color( 20, 1.0, 0.7, 1, 3 )
#local P_pine =
  pigment { marble
            turbulence 0.5
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 0.5 rgb < R2, G2, B2 > ]
                        [ 1.0 rgb < R3, G3, B3 > ] } rotate 90*z scale 26 }
#local N_pine =
 normal { marble
          slope_map { [ 0.00 <0.5, 1> ]
                      [ 0.25 <1.0, 0> ]
                      [ 0.50 <0.5,-1> ]
                      [ 0.75 <0.0, 0> ]
                      [ 1.00 <0.5, 1> ] } scale 1.2 }
//----------------------------------------------------------------------------------
#local Pine_botom = sphere { 0, 100 pigment { P_pine } normal { N_pine } }
//----------------------------------------------------------------------------------
//
coordinate_color( 60, 0.8, 0.7, 1, 4 )
#local Br=16;
#local Obj_seg =
union {
 sphere { 0, Br  translate -Br/6*x }
 sphere { 0, Br/2 translate Br*0.7*y }
 sphere { 0, Br translate  Br/6*x }
 torus { Br, Br/4 pigment { color rgb <R1,G1,B1> } scale <1,0.5,1> }
 torus { Br, Br/2 clipped_by { plane { x,0 } } scale <1,0.7,1> rotate  75*z }
 torus { Br, Br/2 clipped_by { plane { x,0 } } scale <1,0.7,1> rotate 105*z }
 pigment{ P_pine } normal { N_pine }
 scale <1,1,0.3>
 rotate <0,90,-5>
}
//----------------------------------------------------------------------------------
#local Pine_obj =
union {
 object { Pine_leaf scale 8*1.2 }
 object { Normal_tri4u(pi*<1,3,1/11>,pi*<1.3,1.85,1/11>,1) translate -182*y }
 object { Pine_botom translate -200*y }
}
//
object { Pine_obj scale 0.3 rotate < 30,30,30 > translate < -80,0,160 > }
//**********************************************************************************
// peich definition
coordinate_color( -60, 1.0, 0.64, 1, 1 )
coordinate_color(  10, 1.0, 0.8, 1, 2 )
coordinate_color(  30, 1.0, 0.9, 1, 3 )
#local T_peich =
 texture {
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 0.5 rgbt < R2, G2, B2, 0.2 > ]
                        [ 1.0 rgbt < R3, G3, B3, 0.3 > ] } rotate 90*z scale 7*4 }
  normal { bumps 0.3 scale 0.1 }
  finish { ambient 0.3 reflection 0.1 brilliance 0.9 diffuse 0.6 }
 }
#local Peich_obj = object { Smooth_tri2m(pi*< -1, 1, 1/8 >,pi*< -1, 1, 1/28 >,2) }
// peich
object { Peich_obj texture { T_peich } scale 2 rotate < 0, 40, 210 > translate < 40, -20, -20 > }
//**********************************************************************************
// berry definition
#include "Leaf_typeA.def.inc"
coordinate_color( 70, 1.0, 0.4, 1, 1 )
#local P_leaf =
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.00 rgb  < R1, G1, B1 > ]
                        [ 0.99 rgbt < B1, R1, G1, 0.2 > ]
                        [ 1.00 rgbt < G1, B1, R1, 0.3 > ] } rotate 90*z scale <0.1,1,0.1> }
//----------------------------------------------------------------------------------
coordinate_color( 270, 0.4, 0.7, 1, 1 )
#local P_calyx = 
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb  < R1, G1, B1 > ]
                        [ 0.5 rgbt < B1, R1, G1, 0.2 > ]
                        [ 1.0 rgbt < G1, B1, R1, 0.3 > ] } rotate 90*z scale 2 }
//
#local Tr=30; #local Lw=1; #local Ra1=-70; #local Ra2=70; #local Ox=Tr; #local Oz=0;
#local Calyx_seg =
 torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y }
 translate Tr*z rotate -90*x
}
//
#local Berry_calyx =
union {
 object { Calyx_seg }
 object { Calyx_seg rotate 180*z translate < Tr*cos(radians(Ra2))*2,(Tr-Tr*sin(radians(Ra2)))*2,0> }
 object { Calyx_seg rotate 180*z translate <-Tr*cos(radians(Ra2))*2,(Tr-Tr*sin(radians(Ra2)))*2,0> }
 cone { 0, Lw*2.5, <0,-6,0>, Lw }
 scale < 0.5,1,1 >
 translate 6*y
}
//----------------------------------------------------------------------------------
coordinate_color(  0, 1.0, 0.64, 1, 1 )
coordinate_color( 70, 1.0, 0.8,  1, 2 )
coordinate_color( 90, 1.0, 0.9,  1, 3 )
#local T_berry =
 texture {
  pigment { wrinkles
            turbulence 0.4
            color_map { [ 0.0 rgb  < R1, G1, B1 > ]
                        [ 0.5 rgbt < R2, G2, B2, 0.2 > ]
                        [ 1.0 rgbt < R3, G3, B3, 0.3 > ] } rotate 90*z scale 7*4 }
  normal { bumps 0.3 scale 0.1 }
  finish { diffuse 0.6 reflection 0.1 brilliance 0.9 }
 }
#local Berry_seg = Smooth_tri2m(pi*<1,3,1/8>,pi*<1,1.99,1/12>,3)
//----------------------------------------------------------------------------------
union {
 object { Berry_seg texture { T_berry } scale 4 }
 object { Berry_calyx pigment { P_calyx } rotate 20*z translate 9*y }
 object { Leaf_seg pigment { P_leaf } rotate -20*y scale 2 translate 2*y }
 scale 0.6 rotate < -30, -30, 45 > translate < 0, -20, -40 >
}
//**********************************************************************************
// apple definition
coordinate_color( -30, 0.6, 0.4, 1, 1 )
#local P_calyx = pigment { color rgbt < R1, G1, B1, 0.2 > }
#local Tr=60; #local Lw=1; #local Ra1=-180; #local Ra2=-160+180; #local Ox=Tr; #local Oz=0;
#local Apple_calyx =
union {
 torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y } }
 cone { 0, Lw, <0,0,5>, Lw*2 rotate Ra2*y translate <-Tr*cos(radians(Ra2)),0,Tr*sin(radians(Ra2))> }
 translate < Ox, 0, Oz >
 rotate -90*x
}
//----------------------------------------------------------------------------------
coordinate_color( -30, 1.0, 0.5, 1, 1 )
coordinate_color( -10, 0.9, 0.6, 1, 2 )
#local T_apple =
 texture { 
  pigment { ripples
            turbulence 0.2
            color_map { [ 0.0 rgbf < R1, G1, B1, 0.0 > ]
                        [ 0.5 rgbf < R2, G2, B2, 0.1 > ] 
                        [ 1.0 rgbf < R1, G1, B1, 0.0 > ] } scale 0.1 }
 normal { bumps 0.1 scale 0.1 }
 finish { ambient 0.4 diffuse 0.5 reflection 0.3 phong 0.2 brilliance 0.5 }
}
#local Apple_seg = Smooth_tri2m(pi*<-1, 1, 1/24 >,pi*< 0, 0.99, 1/24 >,8)
//----------------------------------------------------------------------------------
union {
 object { Apple_seg texture { T_apple } scale 4 }
 object { Apple_calyx pigment { P_calyx } translate 2*y }
 scale 0.6 translate < -10, 10, 80 >
}
//**********************************************************************************
// lemon definition
coordinate_color( 30, 0.99, 0.6, 3, 1 )
#local T_lemon =
 texture {
  pigment { ripples
            color_map { [ 0.00 rgb < R2, G2, B2 > ]
                        [ 0.01 rgb < R1, G1, B1 > ]
                        [ 1.00 rgb < R1, G1, B1 > ] } 
            scale 2 }
 finish { ambient 0.3 reflection 0.4 specular 0.8 roughness 0.001 }
 normal { bumps 0.4 scale 0.08 }
}
#local Lemon_obj = object { Surface_tri4m(pi*< -1, 1, 1/12 >,pi*< 0, 1, 1/18 >,9) }
// lemon
object { Lemon_obj texture { T_lemon } scale 8 rotate < -20, 0, 90 > translate < 10, -20, 40 > }
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Lc=< 0, 0, -200 >; #local La=< 0, 0, 0 >; #local Ag=40+2;
#local Sz=0.5; #local Lz=-vlength(Lc-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+4; #local Ty=Vx+5; #local Tz=Sz*Lz;
#local Rx=degrees(atan2((Lc.y-La.y),sqrt(pow((Lc.x-La.x),2)+pow((Lc.z-La.z),2))));
#local Ry=180+degrees(atan2((Lc.x-La.x),(Lc.z-La.z))); #local Rz=0;
//object { Sealing scale 0.3 translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > translate La }
//----------------------------------------------------------------------------------
