/* *****************************************
    Gilberto Ficara's IRTC Entry
    "World Construction Kit"
    28/02/2002
    
    (include file)
    
    **************************************** */

/* Macro to make paint cans */

#macro picture_can(imagemap_name,cap_color)

#declare can_metal_01 = texture { T_Chrome_4E normal { bumps .2 scale .01 } };

#declare can_rad = 1.5;
#declare cap_rad = can_rad - 0.35;
#declare bot_border_angle = 0.125;

union {

    union {    
    
        cylinder {
            <0,3.01,0>, <0,3.35,0>, cap_rad / 2                 /*  Central part of the cap  */
        }
    
        cylinder {
            <0,3.01,0>, <0,3.1,0>, cap_rad                      /*  Base of the cap  */
        }
    
    
        difference {
            cylinder { <0,3.01,0>, <0,3.2,0>, cap_rad }         /*  Border of the cap  */
            cylinder { <0,3,0>, <0,3.5,0>, cap_rad - 0.15 }
        }

    
        union {
        
            difference {
                cylinder { <0,3.2,0>, <0,3.3,0>, cap_rad + 0.1 }
                cylinder { <0,3,0>, <0,3.5,0>, cap_rad - 0.15 }
            }
                                                            /*  Upper part of the border  */
            torus {
                #declare sup_border_01 = can_rad-0.25;
                #declare sup_border_01_angle = 0.05;
                sup_border_01 - (sup_border_01_angle/2), sup_border_01_angle
                translate <0,3.25,0>
            }
        }
    
        pigment { color rgb cap_color }
        
        finish {
            ambient 0.1
            diffuse 2
            brilliance 9.0
            metallic 0.8
            specular 0.3
            roughness 0.5
            reflection 0.2
            phong 1
        }
    }
    
    
    /* external top border */

    union {
    
        #declare border_size = 0.07;
    
        difference {
            cylinder { <0,3,0>, <0,3.2,0>, can_rad }
            cylinder { <0,2.9,0>, <0,3.4,0>, can_rad - border_size }
        }
    
        torus {
            can_rad - border_size, border_size
            translate <0,3.2 - border_size / 4,0>
        }
    
        pigment { color rgb <0.8,0.8,0.8> }
        texture { can_metal_01 }
    }
    
    
    /* the can itself, here goes the imagemap texture */
    
    cylinder {
        <0,0,0>, <0,3,0>, can_rad
    
        pigment {                    
            image_map {
                png imagemap_name
                map_type 2 // cylindrical
            }
        scale <1,3,1>
        }
    
        finish {
            ambient 0.5
            diffuse 2
            brilliance 5.0
            metallic 0.2
            specular 0.1
            roughness 0.1
            reflection 0.1
        }    
    }


    /* the bottom of the can, rounded, sexy */

    union {
    
        difference {
            torus { can_rad - bot_border_angle, bot_border_angle }
            box { <-2,0,-2>, <2, 1, 2> }
        }
    
        cylinder { <0,0,0>, <0,-0.05,0>, can_rad - (bot_border_angle*0.3) }
    
        pigment { color rgb <0.8,0.8,0.8> }
        texture { can_metal_01 }  
    }
    
    translate <0,0.125,0>    
    scale 0.08

}

#end