/*  ********************************************************
    Pencil macro for PovRay
    ********************************************************
    
    Copyleft by Gilberto Ficara,
    <g.ficara@linuxpratico.com>
    http://velenux.oltrelinux.com
   
    This file is distributed under the GNU GPL license.
    Free Software rocks.
   
   
    Use:
    
    #include "pen.inc"

    #declare myPen01 = pen(a,b,c)

    // a = color type: 0 for user defined, 1 for random
    // b = pen type: 0 for circular wood, 1 for circular plastic,
    //               2 for hexagonal plastic, 3 for circular wood
    // c = if a=0, c can be anything (I use only 0, normally), else
    //             c must be a color vector (e.g.: <0.9,0.1,0.1>)

    object {
        myPen01
        rotate x*90
        translate <0,0.15,0>
    }
    
*/

#include "woods.inc"

#declare myPenWood = texture { T_Wood10 scale 0.05 rotate x*2 };
#declare rRandSeed = seed(0);
#declare gRandSeed = seed(12345);
#declare bRandSeed = seed(31337); // hehe. I'm stoopid.

#macro pen(colorType, penType, colorVec)

#if(colorType=1) 
    #local penColor = <1*rand(rRandSeed), 1*rand(gRandSeed), 1*rand(bRandSeed)>;
#else
    #local penColor = colorVec;
#end

union {
    cone {
        <0,0,0>, 0.02
        <0,0.3,0>, 0.12
        
        pigment { color rgb penColor }
        finish { phong 0.8 }
    }
    
    #switch(penType)
        #case(0)                                // full wood, circular shape
        
            cone {
                <0,0.301,0>, 0.12
                <0,1,0>, 0.3
        
                texture { myPenWood }
            }


            cylinder {
                <0,1.001,0>,
                <0,7,0>, 0.3
                
                texture { myPenWood }
            }

            cylinder {
                <0,7.001,0>,
                <0,7.003,0>, 0.12
                
                pigment { color rgb penColor }
            }
            
        #break
            
        #case(1)                                // plastic body, circular shape
            cone {
                <0,0.301,0>, 0.12
                <0,1,0>, 0.3
        
                texture { myPenWood }
            }

            merge {
                
                cylinder {
                    <0,1.001,0>,
                    <0,7,0>, 0.3
                }
                
                superellipsoid {
                    <1, 0.3>
                    scale 0.299
                    rotate x*90
                    translate <0,7-0.2,0>
                }
                
                pigment { color rgb penColor }
                finish { reflection 0.15 phong 1 }
                
            }
            
        #break
        
        #case(2)                                // plastic body, hexagonal shape
            intersection {
                union {
                    cone {
                        <0,0.301,0>, 0.12
                        <0,1,0>, 0.3
        
                        texture { myPenWood }
                    }
                    union {
                
                        cylinder {
                            <0,1.001,0>,
                            <0,6.9,0>, 0.3

                            pigment { color rgb penColor }
                            finish { reflection 0.05 phong 1 roughness 0.3 }
                            
                        }
                        
                        cylinder {
                            <0,6.9001,0>,
                            <0,7,0>, 0.3
                            
                            texture { myPenWood }
                        }
                                        
                        cylinder {
                            <0,7.001,0>,
                            <0,7.003,0>, 0.12
                
                            pigment { color rgb penColor }
                        }
                    }
                    
                }
                
                prism {
                    linear_sweep
                    linear_spline
                    -0.1,
                    7.1,
                    7,
                    <0,0.31>, <0.26,0.16>, <0.26,-0.16>, <0,-0.31>, <-0.26, -0.16>, <-0.26,0.16>, <0,0.31>
                    pigment { color rgb penColor }
                    finish { reflection 0.05 phong 1 roughness 0.3 }
                }
            }
        #break
        
        #case(3)                                // full wood, hexagonal shape
            intersection {
                union {
                    cone {
                        <0,0.301,0>, 0.12
                        <0,1,0>, 0.3
        
                        texture { myPenWood }
                    }
                    cylinder {
                        <0,1.001,0>,
                        <0,7,0>, 0.3
                
                        texture { myPenWood }
                    }

                    cylinder {
                        <0,7.001,0>,
                        <0,7.003,0>, 0.12
                    
                        pigment { color rgb penColor }
                    }
                }
                
                prism {
                    linear_sweep
                    linear_spline
                    -0.1,
                    7.1,
                    7,
                    <0,0.31>, <0.26,0.16>, <0.26,-0.16>, <0,-0.31>, <-0.26, -0.16>, <-0.26,0.16>, <0,0.31>
                    
                    texture { myPenWood }
                }
            }
        #break

        // add more cases here, if U want
           
    #end
            
}

        
#end
