////////////////////////////////////////////////////////
// Trees and Bushes
////////////////////////////////////////////////////////

// Include splinetree 

#include "splinetree.inc"

// Define Leafs and branch texture

#declare maple1 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "../images/maple1.tga"
				once
			}
		}
		finish {
			ambient 0.0
			diffuse 0.5
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare maple2 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "../images/maple2.tga"
				once
			}
		}
		finish {
			ambient 0.0
			diffuse 0.5
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare standard_branch = texture {
	pigment {
		bozo
		color_map {
			[ 0 rgb <0.75, 0.75, 0.7>*0.2 ]
			[ 0.5 rgb <0.75, 0.75, 0.7>*0.2 ]
			[ 0.5 rgb <0.75, 0.70, 0.65>*0.5 ]
			[ 1 rgb <0.75, 0.70, 0.65>*0.5 ]
		}
		scale <1,4,1>*0.02
	}
	finish {
		ambient 0.0
		diffuse 0.5
		specular 0.0
		roughness 0.1
            crand .1
	}
	normal {
		crackle 3
		turbulence 0.5
		scale <1,4,1>*0.02
	}
}

////////////////////////////////////////////////////////
// Shadow Tree
////////////////////////////////////////////////////////

#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[6] {4,3,3,3,3,4}
init_rand (479,936,167)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.5, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.004, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <-0.05,0.2,0.05>;

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,4,4>
	rotate <90,0,0>
	translate <50,-5,-1>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 2;

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,4,4>
	rotate <90,0,0>
	translate <-20,25,-1>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <2,2,2>
	rotate <90,0,0>
	translate <-15,-5,-1>
}

// Call the macro
splinetree(0,0)

#declare divisions = array[6] {5,4,4,4,4,5}

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,4,4>
	rotate <90,0,90>
	translate <25,50,-1>
}

// Call the macro
splinetree(0,0)

/////////////////////////////////////////////////////////
// Bushes
/////////////////////////////////////////////////////////

#declare recursionmax = 5; // Defines the complexity of the tree
#declare divisions = array[5] {5,4,3,3,3}
init_rand (48,148,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.8, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.6, 0.5)
init_branchl (.5, 0.1, .2)
init_branchw (0.05, 0.003, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.35)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,3)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <0,-0.1,0>;

// Variables for leaves
#declare leafarray = array[2] {maple1,maple2}
#declare leafprob = array[2] {.5,.5}
#declare leafscale = array[2] {.05,.05}
#declare leafnoise = array[2] {.8,.8}

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,0>
	translate <10.2,-2,-1.5>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,180>
	translate <6.35,-2,-1.5>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,90>
	translate <2.5,-2,-1.5>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,145>
	translate <25.2,-2,-1.5>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,225>
	translate <29.2,-2,-1.5>
}

// Call the macro
splinetree(0,0)

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <4,3,4>
	rotate <90,0,300>
	translate <33.2,-2,-1.5>
}

// Call the macro
splinetree(0,0)
