////// ribbed column

#declare RibCol =
union {
	cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1>}
    cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1> rotate <0,30,0>}
    cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1> rotate <0,60,0>}
    cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1> rotate <0,90,0>}
    cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1> rotate <0,120,0>}
    cylinder {<0,0,0>,<0,18.75,0>,1 scale <0.5,1,1> rotate <0,150,0>}
    torus {1,0.25 translate <0,19,0> texture { ShinyGold }}
    }

#declare SeaHorse =
union {
	sphere_sweep {
    b_spline
    36,
    <-8, 7, 0>, 0.5
    <-7, 6, 0>, 0.4
    <-4, 7, 0>, 0.5
    <-2.5, 8, 0>, 1.8
    <-1, 10, 0>, 1.8
    <0,9.75,0>,1.7
    <1,9,0>,1.3
    <1.6,8,0>,1.5
    <1.8,7,0>,1.4
    <1.75,6,0>,1.5
    <1.6,5,0>,1.6
    <1.2,4,0>,1.7
    <0.8,3,0>,1.85
    <0.5,2,0>,2.0
    <0.4,1,0>,2.5
    <0.2,0,0>,2.7
	<0.4,-1,0>,2.5
	<0.5,-2,0>,2.4
	<0.7,-3,0>,2.3
	<1,-4,0>,2.2
	<1.2,-5,0>,1.8
	<1.6,-6,0>,1.5
	<1.8,-7,0>,1.4
	<2,-8,0>,1.3
	<2.1,-9,0>,1.2
	<1.8,-10,0>,1.1
	<1.1,-11,0>,1
	<0,-11.5,0>,0.9
	<-1,-11.8,0>,0.8
	<-2,-11.7,0>,0.7
	<-2.9,-11,0>,0.6
	<-2.8,-10,0>,0.5
	<-2.4,-9,0>,0.4
	<-1,-8.6,0>,0.3
	<0,-9,0>,0.2
	<-0.2,-10,0>,0.1
    tolerance 0.1
 	texture { SeaStone scale 2 }
		}
 	sphere {<-2.5,9.5,-0.7>,0.8 texture { pigment { rgb 0.1 } finish { Dull2 }}}
	sphere {<-2.5,9.5,0.7>,0.8 texture { pigment { rgb 0.1 } finish { Dull2 }}}
	scale 0.5
	translate <-2.7,6.5,0>
	}

#local spxCoord = seed(354209);
#local spyCoord = seed(583823);
#local spyRot = seed(684834);
#local spCount1 = 0;

#declare Splatter =
	blob {
 	threshold 0.6
#while (spCount1 < 500)
 	sphere { <0.25, 0, 0>, 0.1, 1 
	translate <rand(spxCoord)*4,rand(spyCoord)*0.5,0>
	rotate <0,rand(spyRot)*360,0>
		}
	#local spCount1 = spCount1 + 1;
#end
	translate <25,1,0>
	}

#local spBend = 1;
#local spmaxHeight = 25;
#local spxRot = seed(795695);
#local spzRot = seed(543093);
#local spCount2 = 0;

#declare Fount =
	blob {
 	threshold 0.6
#while (spCount2 < 5000)
	#local yH = rand(spyCoord)*spmaxHeight;
 	sphere { <0.125, 0, 0>, 0.075, 1 
	translate <0,yH,0>
	rotate <rand(spxRot)*6,0,0>
	rotate <0,rand(spyCoord)*360,0>
	rotate <0,0,-yH*(90/spmaxHeight)*spBend>
		}
	#local spCount2 = spCount2 + 1;
#end
	rotate <0,0,-40>
	translate <6.25,9.5,0>
	}

#declare Fount1 =
union {
	object { Fount }
	object { Splatter translate <0,-2.275,0>}
	pigment { rgbt <1,1,1,0.95> }
	finish { ambient 0.05 diffuse 0.2 reflection  { 0.35 } specular 1 roughness 0.000001 }
	interior { ior 1.33 fade_distance 15 fade_power 1.5 }
	}

////


#declare TBitty =
intersection {
	torus {2,0.25}
	box {<0,-0.25,0>,<2.255,0.25,2.255>}
	translate <-4,0.1,-4>
	rotate <0,-90,0> 
	}

#declare SeaStatue =
union {
  union {
    object { RibCol texture { BlueStone }}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> texture {BlueStone}}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> rotate <0,30,0> texture {BlueStone}}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> rotate <0,60,0> texture {BlueStone}}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> rotate <0,90,0> texture {BlueStone}}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> rotate <0,120,0> texture {BlueStone}}
	sphere {<0,20,0>,1.5 scale <0.5,1,1> rotate <0,150,0> texture {BlueStone}}
	pigment { rgb 1 }
	finish { Shiny_Metal }
	  }
	difference {
	  union {
	   	box {<-4,-50,-4>,<4,0.25,4> texture { DarkStone }}
	   	cylinder {<-4,0.1,-4>,<4,0.1,-4>,0.25}
	   	cylinder {<-4,0.1,4>,<4,0.1,4>,0.25 rotate <0,90,0> }
	   	cylinder {<4,0.1,-4>,<4,0.1,4>,0.25 rotate <0,180,0> }
	   	cylinder {<4,0.1,4>,<4,0.1,-4>,0.25  rotate <0,270,0>}
	   	pigment { rgb 1 }
		finish { Shiny_Metal }
	      }
	   cylinder {<-4,-50,-4>,<-4,0.55,-4>,2 rotate <0,0,0>}
	   cylinder {<-4,-50,-4>,<-4,0.55,-4>,2 rotate <0,90,0>}
	   cylinder {<-4,-50,-4>,<-4,0.55,-4>,2 rotate <0,180,0>}
	   cylinder {<-4,-50,-4>,<-4,0.55,-4>,2 rotate <0,270,0>}
	   texture { DarkStone }
	    }
   union {
	sphere {<-2.0,0.1,-4>,0.325}
	sphere {<2.0,0.1,-4>,0.325}
	sphere {<-2.0,0.1,-4>,0.325 rotate <0,90,0>}
	sphere {<2.0,0.1,-4>,0.325 rotate <0,90,0>}
	sphere {<-2.0,0.1,-4>,0.325 rotate <0,-90,0>}
	sphere {<2.0,0.1,-4>,0.325 rotate <0,-90,0>}
	sphere {<-2.0,0.1,-4>,0.325 rotate <0,180,0>}
	sphere {<2.0,0.1,-4>,0.325 rotate <0,180,0>}
	object { TBitty }
	object { TBitty  rotate <0,90,0> }
	object { TBitty  rotate <0,-90,0> }
	object { TBitty  rotate <0,180,0> }
	pigment { rgb 1 }
	finish { Shiny_Metal }
	   }
	torus {1,0.25 translate <0,0.5,0> pigment { rgb <1,1,0>} finish {Shiny_Metal}}

	box {<-1,-50,-4.5>,<1,0,4.5> texture { DarkStone }}
	box {<-4.5,-50,-1>,<4.5,0,1> texture { DarkStone }}

	object {SeaHorse}
	object {SeaHorse rotate <0,90,0>}   
	object {SeaHorse rotate <0,-90,0>}
	object {SeaHorse rotate <0,180,0>}
	object {SeaHorse scale 0.7 rotate <0,45,0> translate <0,10,0>}
	object {SeaHorse scale 0.7 rotate <0,135,0> translate <0,10,0>} 
	object {SeaHorse scale 0.7 rotate <0,-45,0> translate <0,10,0>}
	object {SeaHorse scale 0.7 rotate <0,-135,0> translate <0,10,0>}

	object { Fount1 }
	object { Fount1 rotate <0,90,0> }
	object { Fount1 rotate <0,-90,0> }
	object { Fount1 rotate <0,180,0> }

	scale 2
	rotate <0,-45,0>
	}
