//spaceship for sci-fi take on links image.
//by tek

#declare fShipDiffuse = 1.0/fBmod;

/*
//scene controls

#declare fBmod = 1;


//includes

#include "rad_def.inc"


//global set up

global_settings {
	max_trace_level 5//20
	radiosity {
    //Rad_Settings(Radiosity_Default, off, off)
    Rad_Settings(Radiosity_Debug, on, on)
    //Rad_Settings(Radiosity_Fast, on, on)
    //Rad_Settings(Radiosity_Normal, off, off)
    //Rad_Settings(Radiosity_2Bounce, off, off)
    //Rad_Settings(Radiosity_Final, off, off)

    //Rad_Settings(Radiosity_OutdoorLQ, off, off)
    //Rad_Settings(Radiosity_OutdoorHQ, off, off)
    //Rad_Settings(Radiosity_OutdoorLight, off, off)
    //Rad_Settings(Radiosity_IndoorLQ, off, off)
    //Rad_Settings(Radiosity_IndoorHQ, off, off)
	}
}

#default { finish { diffuse 1/fBmod ambient 0 } }
*/

#declare gvShipDim = <4, 18, 4>; //not a bounding box, just a basis


//textures

#declare normPanels =
	normal {
		crackle
		metric 100
		//form <-1,0,1>
		scale 2
		slope_map {
			[-0.1 <-0.2,1>]
			[0.05 <0.1,1>]
			[0.05 <0.1,0>]
		}
	}

#declare pPanels =
	pigment {
		/*crackle
		metric 100
		//form <-1,0,1>
		scale 2
		colour_map {
			//drybrush style
			[0.0	rgb 0.85]
			[0.05*/	rgb 1.0/*]
			[1.0	rgb 0.85]
		}*/
	}	

#declare tWing =
	texture {
		pigment {
			image_map {
				png "linkship-wing.png"
			}
			translate -0.5
			rotate <0,90,0>
			scale 1*gvShipDim.y*1.1
		}
		finish {
			specular 1
			reflection { 0.0, 0.1 }
			conserve_energy
			diffuse fShipDiffuse
			brilliance 0.5
		}
	}

#declare tWingBack =
	texture {
		pigment {
			rgb 1//<1,0,0.3>
		}
		finish {
			specular 1
			diffuse fShipDiffuse
			brilliance 0.5
		}
	}

#declare tFin =
	texture {
		pigment {
			pPanels
		}
		finish {
			specular 1
			reflection { 0.0, 0.1 }
			conserve_energy
			diffuse fShipDiffuse
			brilliance 0.5
		}
	}

#declare tFinBack =
	texture {
		pigment {
			rgb 1//<1,0,0.3>
		}
		finish {
			specular 1
			diffuse fShipDiffuse
			brilliance 0.5
		}
	}

#declare tBody =
	texture {
		pigment {
			pPanels
		}
		finish {
			specular 1
			reflection { 0.0, 0.1 }
			conserve_energy
			diffuse fShipDiffuse
			brilliance 0.5
		}
	}

#declare tEngine =
	texture {
		pigment { rgb <1,0.9,0.7> }
		finish {
			specular 2
			roughness 0.03
			metallic 1
			reflection { 1 metallic 0.5 }
			conserve_energy
			diffuse 0.4*fShipDiffuse
			brilliance 2
		}
	}




//objects
#declare gfEngineRad = 0.35;
#declare gvEnginePosition = <gfEngineRad+0.2,0.8,0>;

#declare oEngineHousing =
	//difference {
		sphere {
			0, 0.5
			scale <gvShipDim.x*0.5,1.5,gvShipDim.z*0.9>
			rotate <0,0,45>
			translate gvEnginePosition + <-0.1,-0.2,0>
		}
		/*sphere {
			0, 0.5
			scale <gvShipDim.x*0.4,2,gvShipDim.z>
			scale 0.8
			rotate <0,0,45>
			translate <1,1,0>*0.6 - 1.0*z
			texture { tBodyBack }
		}
	}*/

#declare oEngineCutOut =
	cylinder {
		//could do as a repelling blob with narrow area of influence.
		0, -8*z, gfEngineRad*1.3
		translate gvEnginePosition// - gfEngineRad*<0.08,0.08,0>
	}

#declare oEngine =
	merge {
		#local nSegs = 24;
		#local fEngineRadOut = gfEngineRad+0.05;
		#local fOutAng = 15;
		#local fPlateLength = 0.4;
		#local fPlateThick = 0.03;
		#local fCutIn = 0.008;
		
		#local fAng = 360/nSegs;
		#local nSeg = 0;
		#while ( nSeg < nSegs )
			
			//a plate forming the outlet
			intersection {
				plane { y, fPlateThick/2	rotate -fOutAng*x	translate fEngineRadOut*y }
				plane { -y, fPlateThick/2	rotate -fOutAng*x	translate fEngineRadOut*y }
				plane { z, 0							rotate -fOutAng*x	translate fEngineRadOut*y	}
				plane { -z, 0 rotate -0*x translate -fPlateLength*z	rotate -fOutAng*x	translate fEngineRadOut*y }

				plane	{ vnormalize(y+z), -fCutIn  translate <0,fPlateThick/2,0>							rotate -fOutAng*x	translate fEngineRadOut*y }
				plane	{ vnormalize(y-z), -fCutIn translate <0,fPlateThick/2,-fPlateLength>	rotate -fOutAng*x	translate fEngineRadOut*y }

				#local fTrig = sin(radians(fAng/2))*(fEngineRadOut+fPlateThick/2);
				plane {
					#local vFaceNorm = vrotate( y, -fOutAng*x );
					#local vEdgeNorm = vrotate( x, -fAng*z/2 );
					vnormalize(vFaceNorm + vEdgeNorm), -fCutIn
					translate <fTrig,fEngineRadOut+fPlateThick/2,0>
				}
				plane {
					#local vFaceNorm = vrotate( y, -fOutAng*x );
					#local vEdgeNorm = vrotate( -x, fAng*z/2 );
					vnormalize(vFaceNorm + vEdgeNorm), -fCutIn
					translate <-fTrig,fEngineRadOut+fPlateThick/2,0>
				}

				plane { x, 0							rotate -fAng*z/2	}
				plane { -x, 0							rotate fAng*z/2	}
				
				rotate nSeg*fAng*z
			}
			
		
			#local nSeg = nSeg + 1;
		#end //while
		
		translate gvEnginePosition - gvShipDim.z*0.3*z
		                                              
		                                              
		texture { tEngine }
	}


#declare oShip =
	merge {
		#local fWingCurve = gvShipDim.y/2+1;//+0.2;
		#local fD = fWingCurve - gvShipDim.z - sqrt(fWingCurve*fWingCurve - gvShipDim.y*gvShipDim.y/4);
		#if ( fD > 0 )
		difference {
		#else
		intersection {
		#end
			sphere {
				0, 1
				scale <0.1, fWingCurve, fWingCurve>
				translate -(fWingCurve-gvShipDim.z/2)*z
			}
			merge {
				sphere { 0, 1 }
				plane { z, 0 }
				scale <40, gvShipDim.y/sqrt(2), fD/(1-1/sqrt(2))> //right amount to give height and length.
				translate -(fD/(1-1/sqrt(2)) + gvShipDim.z/2)*z

				texture { tWingBack }
			}
			translate (fD/(1-1/sqrt(2)) + gvShipDim.z/2)*z
			rotate <-5,0,0>
			translate -(fD/(1-1/sqrt(2)) + gvShipDim.z/2)*z
				
			texture { tWing }
		}

		#local fFinCurve = gvShipDim.x*0.85;
		#local fFinSpan = gvShipDim.x*1.7;
		#local fD = fFinCurve - gvShipDim.z*0.7 - sqrt(fFinCurve*fFinCurve - fFinSpan*fFinSpan/4);
		#if ( fD > 0 )
		difference {
		#else
		intersection {
		#end
			sphere {
				0, 1
				scale <fFinCurve, 0.04, fFinCurve>
				translate -(fFinCurve-gvShipDim.z*0.7/2)*z
				
				texture { tFin }
			}
			merge {
				sphere { 0, 1 }
				plane { z, 0 }
				scale <fFinSpan/sqrt(2), 40, fD/(1-1/sqrt(2))> //right amount to give height and length.
				translate -(fD/(1-1/sqrt(2)) + gvShipDim.z*0.7/2)*z

				texture { tFinBack }
			}
			//translate (fD/(1-1/sqrt(2)) + gvShipDim.z*0.7/2)*z
			//rotate <-8,0,0>
			//translate -(fD/(1-1/sqrt(2)) + gvShipDim.z*0.7/2)*z
		}


		//body
		//blob maybe?
		difference { //repulsive blob
			merge {
				//body
				sphere {
					0, 0.5
					scale <gvShipDim.x,2,gvShipDim.z+2>
					translate <0,0,0>
				}
	
				//engine housing
				object { oEngineHousing }
				object { oEngineHousing scale <-1,1,1> }
	//			sphere {
	//				0, 0.5
	//				scale <gvShipDim.x*0.4,2,gvShipDim.z>
	//				rotate <0,0,45>
	//				translate <1,1,0>*0.6
	//			}
	//			sphere {
	//				0, 0.5
	//				scale <gvShipDim.x*0.4,2,gvShipDim.z>
	//				rotate <0,0,-45>
	//				translate <-1,1,0>*0.6
	//			}
	
				//hold
				intersection {
					merge {
						sphere {
							0, 0.5
							scale <gvShipDim.x*0.8,1,gvShipDim.z+1.8>
						}
						plane {
							y, 0
						}
					}
					sphere {
						0, 0.5
						scale <gvShipDim.x*0.8,3,gvShipDim.z+1.8>
					}
				}
			}//merge
			merge {
				object { oEngineCutOut }
				object { oEngineCutOut scale <-1,1,1> }
			}

			texture { tBody }
		} //difference (body)
		
		//engines
		object { oEngine }
		object { oEngine scale <-1,1,1> }

	} // merge
	

/*	
//the scene

camera {
	//orthographic
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*(image_width/image_dim)*gvShipDim.y*1.1
	up				y*(image_height/image_dim)*gvShipDim.y*1.1
	direction	z*0.8*gvShipDim.y*1.1
	
	location <-3,1,-2>*4
	look_at gvEnginePosition.y*y+gvEnginePosition.x*x-1.3*z
	//location -100*x
	//look_at 0
}

light_source {
	<-1,3,-2>*10000
	rgb fBmod*0.7
}

sky_sphere {
	pigment {
		rgb <0.35,0.4,0.6>
	}
}

plane {
	y, -20
	pigment { rgb 0.6
	}
}

object {
	oShip
}*/
