// File: marbles.pov
// Author: Matthew Welch

#version 3.5;

global_settings {
    assumed_gamma 2.4
    //radiosity { }
}

#default {finish {ambient 0 diffuse 1}}

#declare ViewAngle = -30;

camera {
    // main angle
    location < 0, 12, -24 >
    look_at < 0, 0, 0 >
    // tatami mat closeup
    //location < 0, 4, -13 >
    //look_at < 0, 0, -7>

    //angle 5    
    angle 35
}

light_source {
  <1000, 3000, -1000>
  color rgb 1
  //media_attenuation on
  //area_light 40*x, 40*y, 4, 4
  //adaptive 1
  //circular
  //orient
}
//light_source { < 1000, 3000, -1000 > rgb 0.6 shadowless }

light_source { < 0, -1000, -500 > rgb 0.3 shadowless }

sky_sphere {
  pigment { color rgb < 0.4, 0.6, 0.8 > }//< 0.0, 0.4, 0.8 > }
}

/////////////////////////////////////////////////////////////////////
// 
// Glint on the sun
//
/////////////////////////////////////////////////////////////////////

#declare camera_location = < 0, 12, -24 > ; 
#declare camera_look_at = < 0, 0, 0 > ; 
#declare effect_location = < 0.15, 0.85, -0.2 >;
#declare effect_type = "Sparkle"
#declare effect_scale = 0.2;
#declare effect_brightness = 0.85;
#include "LENS.INC"

/////////////////////////////////////////////////////////////////////
// 
// Blacktop and chalk
//
/////////////////////////////////////////////////////////////////////

#declare Level1Cutoff = 0.65;
#declare CrackleScale = 0.2;
#declare CrackleTranslate = 5*y;
#declare BlacktopColor = rgb 0.25;

#declare Level1Normal = normal {
  crackle
  slope_map {
    [ Level1Cutoff < 0, 0 > ]
    [ Level1Cutoff < 0, 1 > ]
    [ 1.0 < 1, 0 > ]
  }
  bump_size 0.8
}

#declare Level2Normal = normal {
  crackle
  bump_size 1.5
  scale 0.05
}

#declare BlacktopNormal = normal {
  crackle
  normal_map {
    [ Level1Cutoff Level2Normal ]
    [ Level1Cutoff Level1Normal ]
  }
  scale CrackleScale
  translate CrackleTranslate
}

#declare StoneColors = pigment {
  crackle solid
  color_map {
    [ 0.0 rgb < 0.3, 0.1, 0.1 > ]
    [ 0.4 rgb < 0.5, 0.5, 0.5 > ]
    [ 0.6 rgb < 0.4, 0.4, 0.5 > ]
    [ 1.0 rgb < 0.6, 0.4, 0.2 > ]
  }
}

#declare BlacktopTex = texture {
  pigment {
    //color BlacktopColor
    crackle
    pigment_map {
      [ Level1Cutoff BlacktopColor ]
      [ Level1Cutoff StoneColors ]
    }
    scale CrackleScale
    translate CrackleTranslate
  }
  finish {
    specular 0.15
    roughness 0.1
  }
  normal { BlacktopNormal }
}

#declare ChalkCircleTex = texture {
  pigment {
    bumps
    color_map {
      [ 0.4 rgb 1 ]
      [ 0.8 BlacktopColor ]
    }
    scale 0.005
  }
  normal { BlacktopNormal }
}

#declare MarbleCircleGroundTex = texture {
  cylindrical
  turbulence 0.1
  scale 8
  texture_map {
    [ 0.001 BlacktopTex ]
    [ 0.01 ChalkCircleTex ]
    [ 0.02 ChalkCircleTex ]
    [ 0.03 BlacktopTex ]
  }
}

plane {
  y, 0
  texture { MarbleCircleGroundTex }
}

/////////////////////////////////////////////////////////////////////
// 
// Parking Space Lines
//
/////////////////////////////////////////////////////////////////////

#declare WearScale = 0.1;

#declare LineColor = pigment {
  spotted
  color_map {
    [ 0 rgb < 0.8, 0.7, 0.2 > ]
    [ 1 rgb < 0.8, 0.6, 0.3 > ]
  }
  scale 1/WearScale
}

#declare Transparent = pigment {
  color rgbt < 0.8, 0.6, 0.3, 1 >
}

union {
  box { < -36, 0, 0 >, < 36, 0.02, 3 > }
  box { < -1.5, 0, 0 >, < 1.5, 0.02, 36 > }
  texture {
    pigment {
      spotted
      pigment_map {
        [ 0.2 Transparent ]
        [ 0.4 LineColor ]
      }
      scale WearScale
    }
    normal { Level2Normal }
  }
  rotate -30*y
  translate < -6, 0, 16 >
}

/////////////////////////////////////////////////////////////////////
// 
// Marbles
//
/////////////////////////////////////////////////////////////////////

#macro Marble(rad, image, dist, rot, incline, tod)
sphere {
  0, rad
  texture {
    pigment { image_map { png image map_type 1 } }
    finish {
      specular 0.9
      roughness 0.001
    }
  }
  rotate tod*y
  rotate incline*x
  translate < 0, rad, dist >
  rotate rot*y
}
#end

//Marble (0.35000, "sun.png", 0, 0, 0, 0 ) // the scaled size of the sun is actually 0.91080
Marble (0.34888, "mercury.png", 1.000, 225, 0, 0 ) // the distance should be 0.778
Marble (0.38954, "venus.png", 1.556, 350, 177.4, 0 )
Marble (0.39190, "earth.png", 2.333, 90, 23.4, 90 )
Marble (0.36372, "mars.png", 3.111, 240, 25.2, 0 )
Marble (0.50000, "jupiter.png", 3.889, 180, -30, 0 ) // incline is supposed to be 3.1
Marble (0.49236, "saturn.png", 4.667, 305, 26.7, 0 )
Marble (0.45398, "uranus.png", 5.444, 135, 97.9, 0 )
Marble (0.45258, "neptune.png", 6.222, 30, 29.6, 180 )
Marble (0.31564, "pluto.png", 7, 215, 122.5, 0 )

// Saturns "rings"
union {
  sphere { 0, 0.25 scale < 1.5, 0.2, 0.5 > translate 0.8*x }
  sphere { 0, 0.25 scale < 1.5, 0.2, 0.5 > translate -0.8*x }
  translate 5.4*z
  rotate 312.5*y
  texture {
    pigment { color rgb < 0.5, 0.4, 0.3 > }//< 0.5, 0.4, 0.4 > }
  }
}

// media sun
/*sphere {
  0, 0.35
  translate 0.35*y
  hollow
  texture {
    pigment { color rgbt 1 }
    finish {
      specular 0.9
      roughness 0.001
    }
  }
  interior {
  //  ior 1.5
    media {
      scattering { 1, rgb < 1.0, 0.8, 0.1 > }
      emission < 1.0, 0.8, 0.1 >
      intervals 5 samples 1,5
      density { crackle scale 0.5 }
    }
  }
}*/

// spiky sun
#declare SpikySunSize = 0.50;

sphere {
  0, SpikySunSize
  translate SpikySunSize*y
  hollow
  texture {
    pigment { color rgbt < 1.0, 0.8, 0.0, 0.8 > }
    finish {
      specular 0.9
      roughness 0.001
      //reflection rgb < 1.0, 0.8, 0.0 >*0.2
    }
  }
  interior {
    ior 1.5
  }
}

#declare n1 = (sqrt(5)-1)/2;
#declare n2 = (sqrt(5)+1)/2;
#declare InnerRad = 0.15;

union {
  cone { < 0, 0, 0 >, InnerRad, < -n2, 0, -n1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -n2, 0, n1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -1, -1, -1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -1, -1, 1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -1, 1, -1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -1, 1, 1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -n1, -n2, 0 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < -n1, n2, 0 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 0, -n1, -n2 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 0, -n1, n2 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 0, n1, -n2 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 0, n1, n2 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < n1, -n2, 0 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < n1, n2, 0 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 1, -1, -1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 1, -1, 1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 1, 1, -1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < 1, 1, 1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < n2, 0, -n1 >, 0.0 }
  cone { < 0, 0, 0 >, InnerRad, < n2, 0, n1 >, 0.0 }
  scale 0.4 //0.57735
  texture {
    pigment { 
      spherical
      color_map {
        [ 0 rgb < 1.0, 1.0, 0.0 > ]
        [ 1 rgb < 1.0, 0.2, 0.0 > ]
      }
    }
  }
  scale SpikySunSize
  translate SpikySunSize*y
}
