/*
   ----------------    Worlds Within Worlds-IRTC Competition    ------------------------ 
   ----------------                meadow.pov                   ------------------------
   ----------------             28.February 2001                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.5;

#declare PHOT       = 2;  // photons 0=out; 1=save photons; 2=load photons
                
global_settings {
        assumed_gamma 1
        max_trace_level 80
        adc_bailout 0.003
        #if (PHOT > 0)
                photons {
                        count 6000000  
                        //expand_thresholds 0.2,40      
                        autostop 0
                        #if (PHOT = 1)
                                save_file "meadow.ph"
                        #else
                                load_file "meadow.ph"
                        #end                        
                }
        #end  
}        

#declare amb        = 0;
#declare cam_blur   = 0;
#declare fish_media = 2; 
#declare reflect    = 1;
#declare refl       = 0.78;
#declare diff       = 0.36;
#declare pl_diff    = 0.6; 

#declare grass      = 1;
#declare dive       = 1; 
#declare fish       = 1;  
#declare maina      = 1;
#declare maint      = 1;
#declare plants     = 1;

//_____________________________________________________________________________________

camera {
        ultra_wide_angle
        location <0,-3.3,-30>
        right x*2
        sky <-0.12,1,0> 
        look_at <0,0.5,8> 
        angle 120
        #if (cam_blur = 1)
                normal {
                        bozo 0.024
                        scale 0.3
                        turbulence 1 lambda 4 omega 0.5
                }
        #end                                     
}

//camera {ultra_wide_angle location <0,80,0> right x look_at <0,0,0> angle 60}

#if (PHOT != 2)
        light_source {
                <-10000,15000,-5000>,
                <1,0.836,0.567>*33
        }
#end 

#declare Gamma = 2.2;

sky_sphere {pigment {color rgb <0.3,0.5,0.8>}}                              

#declare hfscalx = 70;
#declare hfscaly = 10;
#declare hfscalz = 70;

#include "hfgrass.inc"        
               
#declare lake_mat=      
material {     
        texture {
                pigment {rgbt <1,1,1,1.02>}
                #if (PHOT = 1)
                        normal {
                                average
                                normal_map {
                                        [1 crackle 0.5/1.4*2*2 scale 0.5*2*0.15*2 turbulence 0.2]
                                        [1 ripples 2/1.4*2*2 scale 100*2*0.15*2 frequency 300 turbulence 0.2]
                                }
                        }        
                #else
                        normal {
                                average
                                normal_map {
                                        [1 crackle 2/1.4 scale 0.15 turbulence 0.2]
                                        [1 ripples 8/1.4 scale 30 frequency 300 turbulence 0.2]
                                }
                        }                
                #end
                finish { 
                        ambient 0 
                        diffuse 0.1//  0 
                        specular 1//*0.4 
                        roughness 0.012 
                        reflection {0.03,1 fresnel on}                          
                        conserve_energy  
                }
        }   
        interior { 
                ior 1.334
                media {absorption rgb <0.2834,0.04343,0.0092>*0.21}
                //media {emission rgb <0.002,0.008,0.01> intervals 15 ratio 0.9 samples 1,10 density {color 0.08}}
        }
}        

#if (PHOT = 1)
        #declare scal = 1;
#else
        #declare scal = 2;
#end
       
box {<-30*scal,-10.01,-40>,<30*scal,3,30>
        material {lake_mat}
        photons {
                target 0.5
                refraction on
                reflection on
                collect off
        }
        hollow
}

fog {
        distance 12
        color rgbt <0.04,0.1,0.12,0.14>        
        turbulence 0.8
        turb_depth 0.3
        fog_type 2
        fog_offset 9.98
        fog_alt 10.01
}

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#if (fish = 1)
        #include "fishd.inc" 
#end

#if (dive = 1)
        #include "diver.inc"
        object {diver translate <1.50785-1.5,-2.94772+0.55,-28.154-0.4+3.6>}
        #include "bubbles.inc"
        object {bubbles translate <1.50785-1.07,-2.94772+0.86+0.8,-28.154-0.4+3.6>}
        object {bubbles rotate y*90 translate <1.50785-1.07-0.33,-2.94772+0.86+0.8+0.8,-28.154-0.4+3.6>}
#end

#if (maina = 1)
        #declare tree1 = union {#include "meadow_tree1.inc" scale 0.018125} 
        object {tree1 rotate y*100 rotate <3.42501-25,0,2.8641> translate <1.50785-0.1,-2.94772-0.0145,-28.154>}       
        #include "ship2.inc"
#end
                        
#if (maint = 1) 
        light_group {
                light_source {
                        <-10000,15000,-5000>             
                        color rgb <0.4,1,1.3>*2.5      
                        area_light
                        <800,0,0> <0,800,800> 
                        5,5
                        adaptive 0      
                        jitter           
                        circular                     
                }
                light_source {
                        <0,-3.3,-30> 
                        color rgb <0.7,1,1.15>*0.7 
                        shadowless
                }
                #include "flower6.inc"
                object {veg14 rotate y*-110 rotate x*17 translate <0,-3.3,-30>-(<0,-3.3,-30>-<36,-27,8>)*0.0036 photons {collect off}}        
                #include "butterfly.inc"
                object {ConvObject scale 0.32 rotate y*-60 rotate x*-30 translate <0,-3.3,-30>-(<6.6,-1.5,-28.6>-<36,-12,8>)*0.0036 photons {collect off}}
                global_lights off
        }        
#end

#if (plants = 1)
        #include "uwgrass2.inc" 
        #include "veg2.inc"     

        #include "uwgrass3.inc" 
        #include "veg3.inc"

        #include "flower1.inc" 
        #include "veg4.inc" 

        #include "flower3.inc" 
        #include "veg5.inc"    

        #include "grass3.inc" 
        #include "veg6.inc"     

        #include "grass4.inc" 
        #include "veg7.inc"   

        #include "grass5.inc" 
        #include "veg8.inc" 

        #include "flower4.inc" 
        #include "veg9.inc"

        #include "flower5.inc" 
        #include "veg10.inc"  

        #include "grass6.inc" 
        #include "veg11.inc" 

        #include "tree3.inc" 
        #include "veg12.inc" 

        #include "grass7.inc" 
        #include "veg13.inc"       
        
        #include "grass9.inc"                                    
        #include "veg14.inc" 

        #include "grass8.inc" 
        #include "veg15.inc"                 
#end


    