// Persistence of Vision Ray Tracer Scene Description File
// File: worlds_buffer.pov
// Vers: 3.5                               
// Desc: Worlds Within Worlds                                  
// Date: Feb 2002
// Auth: Jim Charter


        union {        //buffer frame                 

                #declare p_dents_buffer =  pigment { dents pigment_map {[0 rgb .80][1 rgb .87] } scale .05 turbulence 0.2 rotate 90*rand(R) } 
                #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } }     
                
                
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .9, 12.5, .9) 
                             - fn_dents_buffer ( x,y,z ).red*.15
                  } 
                  contained_by { box { < -1.9, -13, -1.9 > < 1.9, 13, 1.9 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale < 1, 1, .96 > 
                  texture { t_metal_frame } 
                  translate < 0, 12.5, 19 >            
                }
                isosurface {    //bearings
                    function { f_torus(x, y, z, 1.0, 0.6) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } }   
                    accuracy 0.01  max_gradient 1.8 
                    rotate x*90
                    texture { t_metal_frame } 
                    translate < -.5, 20, 19 >  
                }
                 
                #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } }     
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .9, 12.5, .9) 
                             - fn_dents_buffer ( x,y,z ).red*.15
                  } 
                  contained_by { box { < -1.9, -13, -1.9 > < 1.9, 13, 1.9 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale < 1, 1, .96 > 
                  texture { t_metal_frame } 
                  translate < 0, 12.5, 0 >            
                } 
                isosurface {    //bearings
                    function { f_torus(x, y, z, 1.0, 0.6) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } }
                    accuracy 0.01  max_gradient 1.8   
                    rotate x*90
                    texture { t_metal_frame } 
                    translate < -.5, 20, -.4 >   
                } 
                isosurface {    //bearings
                    function { f_torus(x, y, z, 1.0, 0.6) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } } 
                    accuracy 0.01  max_gradient 1.8  
                    rotate x*90
                    texture { t_metal_frame } 
                    translate < -.5, 20,  .6 >   
                }                
                
                #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } }     
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .9, 12.5, .9) 
                             - fn_dents_buffer ( x,y,z ).red*.15
                  } 
                  contained_by { box { < -1.9, -13, -1.9 > < 1.9, 13, 1.9 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale < 1, 1, .96 > 
                  texture { t_metal_frame } 
                  translate < 0, 12.5, -19 >            
                } 
                isosurface {       //bearings
                    function { f_torus(x, y, z, 1.0, 0.6) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } }
                    accuracy 0.01  max_gradient 1.8   
                    rotate x*90
                    texture { t_metal_frame } 
                    translate < -.5, 20, -19 >   
                }
                                                  
                box { < -.9, 0, -.9 > < .9, 15, .9 > rotate z*5 translate < 6, 0,  19 > }
                box { < -.9, 0, -.9 > < .9, 15, .9 > rotate z*5 translate < 6, 0,  -0 > }  
                box { < -.9, 0, -.9 > < .9, 15, .9 > rotate z*5 translate < 6, 0, -19 > }  

                box { < -2.2, 0, -.9 > < 2.2, 1.8, .9 >  translate < 3, 13.1,  19 > }  //rotate z*5
                box { < -2.2, 0, -.9 > < 2.2, 1.8, .9 >  translate < 3, 13.1,  -0 > }  //rotate z*5
                box { < -2.2, 0, -.9 > < 2.2, 1.8, .9 >  translate < 3, 13.1, -19 > }  //rotate z*5

                translate < 2, 0, -8 >
                texture { t_metal_frame }
        }

         //chests 
        #declare p_dents_buffer =  pigment { dents pigment_map {[0 rgb .9][1 rgb .80] } scale .40 turbulence 1.2 rotate 45 }        
        #declare p_wrinkles_buffer =  pigment { wrinkles pigment_map {[0 rgb .90][.5 rgb 1][1 rgb 1] } scale 5 turbulence 2.5 rotate 45 }   
        #declare p_granite_buffer =  pigment { granite pigment_map {[0 rgb .90][1 rgb 1] } scale 7 turbulence 5 rotate 45 }   
        
        #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 80*rand(R) } }    
        #local fn_wrinkles_buffer = function { pigment { p_wrinkles_buffer rotate 90*rand(R) } }                          
        #local fn_granite_buffer = function { pigment { p_granite_buffer rotate 90*rand(R) } }                          

        isosurface {     
                function { f_rounded_box (x,y,z ,0.1, 4, 5, 8.55)
                           - fn_granite_buffer ( x,y,z ).red*.10 
                           - fn_wrinkles_buffer ( x,y,z ).red*.15
                           - fn_dents_buffer ( x,y,z ).red*.15                               
                           
                         
                } 
                contained_by { box { < -5, -6, -10 > <  5, 6, 10 > }  } 
                accuracy 0.01  max_gradient 1.8 
                scale < .95, .95, .95 > 
                texture { t_metal_chest }  
                translate < 5, 5, 1.5 >            
        }
        #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } } 
        #local fn_wrinkles_buffer = function { pigment { p_wrinkles_buffer rotate 90*rand(R) } }  
        #local fn_granite_buffer = function { pigment { p_wrinkles_buffer rotate 90*rand(R) } }                                      
        isosurface {     
          function { f_rounded_box (x,y,z ,0.1, 4, 5, 8.55)                    
                    - fn_granite_buffer ( x,y,z ).red*.10 
                    - fn_wrinkles_buffer ( x,y,z ).red*.15
                    - fn_dents_buffer ( x,y,z ).red*.15          
          } 
          contained_by { box { < -5, -6, -10 > <  5, 6, 10 > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale < .95, .95, .95 > 
          texture { t_metal_chest } 
          translate < 5, 5, -17.5 >            
        }
        #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } } 
        #local fn_wrinkles_buffer = function { pigment { p_wrinkles_buffer rotate 90*rand(R) } }  
        #local fn_granite_buffer = function { pigment { p_wrinkles_buffer rotate 90*rand(R) } }                                                
        isosurface {     
          function { f_rounded_box (x,y,z ,0.1, 4, 5, 8.55)
                    - fn_granite_buffer ( x,y,z ).red*.10                     
                    - fn_wrinkles_buffer ( x,y,z ).red*.15
                    - fn_dents_buffer ( x,y,z ).red*.15
          } 
          contained_by { box { < -5, -6, -10 > <  5, 6, 10 > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale < .95, .95, .95 > 
          texture { t_metal_chest } 
          translate < 5, 5, -36.5 >            
        }
        #declare handle =
                isosurface {    //handle
                    function { f_torus(x, y, z,  .3, 0.2) }
                    contained_by { box { -0.6, 0.6 } }
                    accuracy 0.01  max_gradient 1.8   
                    scale <.5,.5,1>*1.25
                    texture { T_Chrome_3A } 
                       
                } 
        object { handle translate < 0.75, 8, 7 > }   
        object { handle translate < 0.75, 8, -4 > }
        object { handle translate < 0.75, 8, -12 > }   
        object { handle translate < 0.75, 8, -23 > }  
        object { handle translate < 0.75, 8, -31 > }   
        object { handle translate < 0.75, 8, -42 > }      
        
        
            
         //buffer axle and buffer brushes
        #declare p_radial =
         
                pigment { radial frequency 144 turbulence .025 
                                pigment_map {   [  0 rgb CHSV2RGB ( <  15, .8, .8 > ) ]
                                                [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) ] 
                                                [  1 rgb CHSV2RGB ( <  15, .8, .8 > ) ] 
                                }
                }
        #declare p_gradient =
         
                pigment { gradient y frequency 10 turbulence .225 
                                pigment_map {   [  0 rgb CHSV2RGB ( <  15, .8, .8 > ) ]
                                                [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) ] 
                                                [  1 rgb CHSV2RGB ( <  15, .8, .8 > ) ] 
                                }
                }
              
      
        #local fn_radial_buffer = function {  pigment { average pigment_map { [ .5 p_radial ][ .5 p_gradient ] }  } }   
     
     
        isosurface {     
          function { sqrt(x^2 + z^2) - .5   } 
          contained_by { box { < -1, 0, -1 > <  1, -24, 1  > }  } 
          accuracy 0.01  max_gradient 1.8          
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }

        isosurface {     
          function { sqrt(x^2 + z^2) - .65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8 
          translate y*15.5
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }              
        isosurface {     
          function { sqrt(x^2 + z^2) - .9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8 
          translate y*15.5
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.4 } //- fn_radial_buffer ( x,y,z ).red*.35  } 
          contained_by { box { < -10, -.45, -10 > <  10, .45, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*15.5
          texture { t_buffer2  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.4 }  
          contained_by { box { < -10, -.45, -10 > <  10, .45, 10  > }  } 
          accuracy 0.01  max_gradient 1.8
          scale 1.075   
          translate y*15.5
          texture { t_buffer2t   }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }
             
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*13
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }      
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.2   } 
          contained_by { box { < -5, -.50, -5 > <  5, .50, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*13
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.9  } //- fn_radial_buffer ( x,y,z ).red*.35   } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*13
          texture { t_buffer3  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }    
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.9  }  
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale 1.075  
          translate y*13
          texture { t_buffer3t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        } 
        
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*10
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                        
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.0   } 
          contained_by { box { < -5, -.50, -5 > <  5, .50, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*10
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.6 } //- fn_radial_buffer ( x,y,z ).red*.35   } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*10
          texture { t_buffer3  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }    
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.6 } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale 1.075  
          translate y*10
          texture { t_buffer3t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }
        
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*7
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                        
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.2   } 
          contained_by { box { < -5, -.50, -5 > <  5, .50, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*7
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.0 } //- fn_radial_buffer ( x,y,z ).red*.35  } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*7
          texture { t_buffer3  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }    
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.0 }  
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale 1.075  
          translate y*7
          texture { t_buffer3t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }    
                
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*4
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }         
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*4
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.4 } //- fn_radial_buffer ( x,y,z ).red*.35   } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*4
          texture { t_buffer2  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.4 }  
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8
          scale 1.075   
          translate y*4
          texture { t_buffer2t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        } 
                    
//====right sidr of bar ==================================================================================                        
        isosurface {     
          function { sqrt(x^2 + z^2) - .5   } 
          contained_by { box { < -1, 0, -1 > <  1,  24, 1  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale < 1, 1, .98 > 
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                   
        
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-4
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }         
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-4
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.5 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*-4
          texture { t_buffer4  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }            
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.5 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale 1.075  
          translate y*-4
          texture { t_buffer4t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        } 
                
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-8
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }         
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-8
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.5 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*-8
          texture { t_buffer5  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }             
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.5 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8
          scale 1.075   
          translate y*-8
          texture { t_buffer5t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }             
                            
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-12
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }         
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-12
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.6 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*-12
          texture { t_buffer4  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        } 
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.6 } 
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8
          scale 1.075   
          translate y*-12
          texture { t_buffer4t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        } 
                 
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.65   } 
          contained_by { box { < -5, -.90, -5 > <  5, .90, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-16
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }         
        isosurface {     
          function { sqrt(x^2 + z^2) - 0.9   } 
          contained_by { box { < -5, -.5, -5 > <  5, .5, 5  > }  } 
          accuracy 0.01  max_gradient 1.8  
          translate y*-16
          texture { t_metal_axle }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                           
        }           
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.6 }  
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*-16
          texture { t_buffer2  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                                       
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.6 }  
          contained_by { box { < -10, -.40, -10 > <  10, .40, 10  > }  } 
          accuracy 0.01  max_gradient 1.8
          scale 1.075   
          translate y*-16
          texture { t_buffer2t  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                                       
                              
      
        isosurface {     //cone shape
          function { sqrt(x^2 + z^2) - y }  
          contained_by { box { < -10, 0, -10 > <  10, .80, 10  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale 1.2  
          translate y*-24
          texture { t_metal_axle  }  
          rotate x*90                                                      
          translate < 1.0, 20, -8 >                          
        }                                       
                                                      
   //exhaust                  
        #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } }  
        isosurface {     
          function { sqrt(x^2 + z^2) - 1.2 - fn_dents_buffer ( x,y,z ).red*.15  } 
          contained_by { box { < -3, 0, -3 > <  3, -30, 3  > }  } 
          accuracy 0.01  max_gradient 1.8 
          scale < 1, 1, .98 > 
          texture { t_metal_exhaust }  
          rotate x*90                                                      
          translate < 4.0, 17, -11 >                          
        }

        #local mouth = 
        union {

                isosurface {     
                  function { sqrt(x^2 + z^2) - .1 }  
                  contained_by { box { < -1, -2, -1 > <  1, 2, 1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < -1, 0, 1 >                          
                }
                isosurface {     
                  function { sqrt(x^2 + z^2) - .1 }  
                  contained_by { box { < -1, -2, -1 > <  1, 2, 1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < -1, 0,-1 >                          
                }                  
                isosurface {     
                  function { sqrt(x^2 + z^2) - .1 }  
                  contained_by { box { < -1, -2, -1 > <  1, 2, 1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0, 1 >                          
                }                  
                isosurface {     
                  function { sqrt(x^2 + z^2) - .1 }  
                  contained_by { box { < -1, -2, -1 > <  1, 2, 1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0, -1 >                          
                }
                isosurface {     
                  function { x }  
                  contained_by { box { < -2, -2, -.1 > <  1, 2, .1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0, -1 >                          
                }
                isosurface {     
                  function { x }  
                  contained_by { box { < -2, -2, -.1 > <  1, 2, .1  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0,  1 >                          
                }
                isosurface {     
                  function { x }  
                  contained_by { box { < -2, -2, -2 > <  -2.2,  2, 0  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0,  1 >                          
                }                                                                                
                isosurface {     
                  function { x }  
                  contained_by { box { < -0.2, -2, -2 > <  -0.0,  1, 0  > }  } 
                  accuracy 0.01  max_gradient 1.8   
                  translate < 1, 0,  1 >
                                        
                }    
        }
                  
        object { mouth                  
                  rotate z*70                                                                     
                  translate < 1.0, 18, -12 > 
                  texture { t_metal_exhaust  }      
        } 
        object { mouth                  
                  rotate z*70                                                                     
                  translate < 1.0, 18, -16 > 
                  texture { t_metal_exhaust  }      
        }          
        object { mouth                  
                  rotate z*70                                                                     
                  translate < 1.0, 18, -20 > 
                  texture { t_metal_exhaust  }      
        }
        object { mouth                  
                  rotate z*70                                                                     
                  translate < 1.0, 18, -24 > 
                  texture { t_metal_exhaust  }      
        }   
        object { mouth                  
                  rotate z*70                                                                     
                  translate < 1.0, 18, -31 > 
                  texture { t_metal_exhaust  }      
        }          
        
        //under exhaust 
        union {
                #local fn_dents_buffer = function { pigment { p_dents_buffer rotate 90*rand(R) } } 
                isosurface {     
                  function { sqrt(x^2 + z^2) -  .4 - fn_dents_buffer ( x,y,z ).red*.15  } 
                  contained_by { box { < -3, 2, -3 > <  3, -16, 3  > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale < 1, 1, .98 >                   
                  rotate x*90                                                      
                                          
                }              
                isosurface {     
                  function { sqrt(x^2 + z^2) - 1.8 - fn_dents_buffer ( x,y,z ).red*.15  } 
                  contained_by { box { < -3, -1, -3 > <  3, -14, 3  > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale < 1, 1, .98 > 
                  rotate x*90                                                      
                                        
                }        
                isosurface {     
                    function { f_torus(x, y, z, 1.55, 0.2) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } }   
                    accuracy 0.01  max_gradient 1.8 
                    rotate x*90
                    translate z*-2 
                }
                isosurface {     
                    function { f_torus(x, y, z, 1.55, 0.2) - fn_dents_buffer ( x,y,z ).red*.15}
                    contained_by { box { -2.2, 2.2 } }   
                    accuracy 0.01  max_gradient 1.8 
                    rotate x*90 
                    translate z*-14
                } 
                translate < 4.0, 14, -10 >
                texture { t_metal_exhaust }    
        }                        
        //back pan
                
        isosurface {     
                  function { x }  
                  contained_by { box { < -.1, -9, -20 > <  .1, 9, 20  > }  } 
                  accuracy 0.01  max_gradient 1.8
                  rotate z*5   
                  translate < 8, 17, -7 >
                  texture { t_metal_frame_back }                           
        }     

        //top shelf 
#local p_wood =          
    pigment {
        wood turbulence 0.04
        scale 0.15
        color_map {
            [0.15 color rgb  .47 ]
            [0.25 color rgb  .475 ]
            [1.00 color rgb  .47 ]
        }
        scale <1,1,5>
    }        
        
#local p_onion =        
    pigment {
        onion
        turbulence 0.2125
        colour_map {
            [0.225 colour rgb  .47]
            [0.350 colour rgb  .475]
            [1.000 colour rgb  .47]
        }
        scale <0.225, 0.20, 1.15*5>
    }        
        #local fn_onion = function { pigment { p_onion } } 
        #local fn_wood = function { pigment { p_wood } }  
        union {                
                isosurface {     
                          function { y - fn_wood ( x,y,z ).red*.05 - fn_onion ( x,y,z ).red*.05 }  
                          contained_by { box { < -2, -.2, -23.5 > <  2, .2, 23.5  > }  } 
                          accuracy 0.01  max_gradient 1.8
                          texture { t_wood_shelf translate z*-20}     
                } 
                isosurface {     
                          function { f_rounded_box(x,y,z,.01,.1,.8,47) - fn_wood ( x,y,z ).red*.05 - fn_onion ( x,y,z ).red*.05 }  
                          contained_by { box { < -.3, -.4, -23.5 > <  .3, .4, 23.5  > }  } 
                          accuracy 0.01  max_gradient 1.8
                          translate < -2, .2, 0 >
                          texture { t_wood_shelf translate z*-50}     
                    
                }
                isosurface {     
                          function { f_rounded_box(x,y,z,.01,.1,.8,47) - fn_wood ( x,y,z ).red*.05 - fn_onion ( x,y,z ).red*.05}  
                          contained_by { box { < -.3, -.4, -23.5 > <  .3, .4, 23.5  > }  } 
                          accuracy 0.01  max_gradient 1.8
                          translate < 2, .2, 0 >
                          texture { t_wood_shelf translate z*-40}     
                    
                }                
                isosurface {     
                          function { f_rounded_box(x,y,z,.01,3,.8,.1) - fn_wood ( x,y,z ).red*.05 - fn_onion ( x,y,z ).red*.05}  
                          contained_by { box { < -2, -.4, -.5 > <  2, .4, .5  > }  } 
                          accuracy 0.01  max_gradient 1.8
                          translate < -0, .2, 23.5 >
                          texture { t_wood_shelf translate z*-90}     
                    
                }                    
                isosurface {     
                          function { f_rounded_box(x,y,z,.01,3,.8,.1) - fn_wood ( x,y,z ).red*.05 - fn_onion ( x,y,z ).red*.05}  
                          contained_by { box { < -2, -.4, -.5 > <  2, .4, .5  > }  } 
                          accuracy 0.01  max_gradient 1.8
                          translate < -0, .2, -23.5 >
                          texture { t_wood_shelf translate z*-90}     
                    
                }                       
                
                rotate z*30   
                translate < 2, 26.0, -8 >
                                  
        }     
//switch boxes    
        union {
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .5, .75, .5) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                   
                             
                } 
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .58, .155, .1 ) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                  texture { pigment  { Grey45  } } 
                              
                }
                translate < 1, 15, -25.4 >
                texture { t_switchbox } 
                
        } 
        union {        
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .5, .75, .5) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                   
                             
                } 
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .56, .155, .1 ) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                  texture { pigment  { Black } } 
                              
                }
                translate < 1, 15, -28.4 >
                texture { t_switchbox } 
                
        }
        union {        
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .5, .75, .5) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                   
                             
                } 
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.05, .56, .155, .1 ) 
                             
                  } 
                  contained_by { box { < -1.0, -1.5, -1.0 > < 1.0, 1.5, 1.0 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.4
                  texture { pigment  { Black } }
                              
                }
                translate < 1, 15,  9.2 > 
                texture { t_switchbox }
                
        } 
        
// boxes     
         
                isosurface {     
                  function { f_rounded_box (x,y,z ,0.075, 2.0, .75, 2.0) 
                             
                  } 
                  contained_by { box { < -2.1, -1.0, -2.1 > <  2.1,  1.0,  2.1 > }  } 
                  accuracy 0.01  max_gradient 1.8 
                  scale 1.2
                  rotate y*3  
                  translate < 4.5, 10.85, 3 >
                  texture { t_metalbox } 
                           
                }                        

                isosurface {     
                  function { f_rounded_box (x,y,z ,0.125, 3.0, 1.8, 3.0) - f_rounded_box (x,y,z ,0.075, 2.9, 2.0, 2.9) 
                             
                  } 
                  contained_by { box { < -3.1, -2.1, -3.1 > <  3.1,  2.1,  3.1 > }  } 
                  accuracy 0.01  
                  max_gradient 2.633 
                  //evaluate 1, 1.2, 0.99   
                  scale 1.2
                  rotate y*-7
                  translate < 5, 12.5, -34 >
                  texture { t_cardbox } 
                             
                }                        
 
//spare buffers 

        isosurface {     
          function { sqrt(x^2 + z^2) - 2.6  - fn_radial_buffer ( x,y,z ).red*.025   } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*10
          texture { t_buffer4  }                                                                
          translate < 4.0, .43, -16 >  
        }
        isosurface {     
          function { sqrt(x^2 + z^2) - 2.0  - fn_radial_buffer ( x,y,z ).red*.025   } 
          contained_by { box { < -10, -.43, -10 > <  10, .43, 10  > }  } 
          accuracy 0.01  max_gradient 1.8   
          translate y*10
          texture { t_buffer4  }                                                                
          translate < 4.5, .43, -20 >  
        }                             