// Persistence of Vision Ray Tracer Include File
// File: SKS_HexLight.inc
// Vers: 3.1
// Desc: "Intestinal Parasites Playing Poker" light fixture
// Date: 01/17/2002
// Auth: Copyright  2002 by Sherry K. Shaw

//**********************************************************
// Glass texture & interior
//**********************************************************
#declare GLASS_TEX =
texture {
  pigment {
    color rgbft < 1.0, 0.2, 0.0, 0.3, 0.3 >
  }
  finish {
    ambient 0.4
    diffuse 0.8
    specular 1
    roughness 0.5
  }
  normal {
    bumps 0.1
    scale 0.05
  }
}

#declare GLASS_INT =
interior {
  ior 1.75
}

//**********************************************************
// Lead texture
//**********************************************************
#declare LEAD_TEX =
texture {
  pigment {
    color rgb < 0.6, 0.6, 0.6 >
  }
  finish {
    ambient 0.3
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.70
    roughness 1/60
    reflection 0.25
  }
  normal {
    bumps 0.1
    scale 0.1
  }
}

//**********************************************************
// Lamp parts
//**********************************************************
// Note:  The thickness of the upper panes is slightly "fudged," since it doesn't take
// into account the angle at which the panes are set, but real stained glass isn't
// utterly uniform either, is it?

// X & Z coordinates of hexagon corners
#declare XI = array[6]  
#declare ZI = array[6]
#declare XO = array[6]  
#declare ZO = array[6]

#declare HexRad = 14 ;        // Radius of lower hexagon
#declare SideHt = 6 ;         // Height of lower hexagon
#declare TopHt = 6 ;          // Height of upper hexagon
#declare Thickness = 0.25 ;   // Glass thickness

#declare Ix = 0 ;

// Get coordinates of corners
#while ( Ix < 6 )
  #declare XI[Ix] = ( HexRad - Thickness ) * ( sin ( radians ( ( Ix * 60 ) + 30 ) ) ) ;
  #declare ZI[Ix] = ( HexRad - Thickness ) * ( cos ( radians ( ( Ix * 60 ) + 30 ) ) ) ;
  #declare XO[Ix] = HexRad * ( sin ( radians ( ( Ix * 60 ) + 30 ) ) ) ;
  #declare ZO[Ix] = HexRad * ( cos ( radians ( ( Ix * 60 ) + 30 ) ) ) ;
  #declare Ix = Ix + 1 ;
#end

// Points in the lamp body mesh
// (For all but the top, "pt" + "clock" position + "L" or "U" (lower/upper level) +
// "I" or "O" (inner/outer surface, so "pt01LI" = 1 o'clock, lower level, inner surface)
#declare pt01LI = < XI[0], 0, ZI[0] > ;
#declare pt03LI = < XI[1], 0, ZI[1] > ;
#declare pt05LI = < XI[2], 0, ZI[2] > ;
#declare pt07LI = < XI[3], 0, ZI[3] > ;
#declare pt09LI = < XI[4], 0, ZI[4] > ;
#declare pt11LI = < XI[5], 0, ZI[5] > ;
#declare pt01UI = < XI[0], SideHt, ZI[0] > ;
#declare pt03UI = < XI[1], SideHt, ZI[1] > ;
#declare pt05UI = < XI[2], SideHt, ZI[2] > ;
#declare pt07UI = < XI[3], SideHt, ZI[3] > ;
#declare pt09UI = < XI[4], SideHt, ZI[4] > ;
#declare pt11UI = < XI[5], SideHt, ZI[5] > ;
#declare pt01LO = < XO[0], 0, ZO[0] > ;
#declare pt03LO = < XO[1], 0, ZO[1] > ;
#declare pt05LO = < XO[2], 0, ZO[2] > ;
#declare pt07LO = < XO[3], 0, ZO[3] > ;
#declare pt09LO = < XO[4], 0, ZO[4] > ;
#declare pt11LO = < XO[5], 0, ZO[5] > ;
#declare pt01UO = < XO[0], SideHt, ZO[0] > ;
#declare pt03UO = < XO[1], SideHt, ZO[1] > ;
#declare pt05UO = < XO[2], SideHt, ZO[2] > ;
#declare pt07UO = < XO[3], SideHt, ZO[3] > ;
#declare pt09UO = < XO[4], SideHt, ZO[4] > ;
#declare pt11UO = < XO[5], SideHt, ZO[5] > ;
#declare ptTopI = < 0, ( SideHt + TopHt - Thickness ), 0 > ;
#declare ptTopO = < 0, ( SideHt + TopHt ), 0 > ;

// The lamp body
#declare LAMP_BODY_OBJ =
mesh {
   triangle { pt01UI, ptTopI, pt11UI }  // Top, center rear, inner
   triangle { pt03UI, ptTopI, pt01UI }  // Top, right rear, inner
   triangle { pt05UI, ptTopI, pt03UI }  // Top, right front, inner
   triangle { pt07UI, ptTopI, pt05UI }  // Top, center front, inner
   triangle { pt09UI, ptTopI, pt07UI }  // Top, left front, inner
   triangle { pt11UI, ptTopI, pt09UI }  // Top, left rear, inner
   triangle { pt01LI, pt11LI, pt01UI }  // Inner, center rear, lower
   triangle { pt01UI, pt11LI, pt11UI }  // Inner, center rear, upper
   triangle { pt03LI, pt01LI, pt03UI }  // Inner, right rear, lower
   triangle { pt03UI, pt01LI, pt01UI }  // Inner, right rear, upper
   triangle { pt05LI, pt03LI, pt05UI }  // Inner, right front, lower
   triangle { pt05UI, pt03LI, pt03UI }  // Inner, right front, upper
   triangle { pt07LI, pt05LI, pt07UI }  // Inner, center front, lower
   triangle { pt07UI, pt05LI, pt05UI }  // Inner, center front, upper
   triangle { pt09LI, pt07LI, pt09UI }  // Inner, left front, lower
   triangle { pt09UI, pt07LI, pt07UI }  // Inner, left front, upper
   triangle { pt11LI, pt09LI, pt11UI }  // Inner, left rear, lower
   triangle { pt11UI, pt09LI, pt09UI }  // Inner, left rear, upper
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, center rear, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, center rear, outer
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, right rear, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, right rear, outer
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, right front, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, right front, outer
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, center front, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, center front, outer
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, left front, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, left front, outer
   triangle { pt01LI, pt11LI, pt01LO }  // Bottom, left rear, inner
   triangle { pt01LO, pt11LI, pt11LO }  // Bottom, left rear, outer
   triangle { pt01LO, pt11LO, pt01UO }  // Outer, center rear, lower
   triangle { pt01UO, pt11LO, pt11UO }  // Outer, center rear, upper
   triangle { pt03LO, pt01LO, pt03UO }  // Outer, right rear, lower
   triangle { pt03UO, pt01LO, pt01UO }  // Outer, right rear, upper
   triangle { pt05LO, pt03LO, pt05UO }  // Outer, right front, lower
   triangle { pt05UO, pt03LO, pt03UO }  // Outer, right front, upper
   triangle { pt07LO, pt05LO, pt07UO }  // Outer, center front, lower
   triangle { pt07UO, pt05LO, pt05UO }  // Outer, center front, upper
   triangle { pt09LO, pt07LO, pt09UO }  // Outer, left front, lower
   triangle { pt09UO, pt07LO, pt07UO }  // Outer, left front, upper
   triangle { pt11LO, pt09LO, pt11UO }  // Outer, left rear, lower
   triangle { pt11UO, pt09LO, pt09UO }  // Outer, left rear, upper
   triangle { pt01UO, ptTopO, pt11UO }  // Top, center rear, outer
   triangle { pt03UO, ptTopO, pt01UO }  // Top, right rear, outer
   triangle { pt05UO, ptTopO, pt03UO }  // Top, right front, outer
   triangle { pt07UO, ptTopO, pt05UO }  // Top, center front, outer
   triangle { pt09UO, ptTopO, pt07UO }  // Top, left front, outer
   triangle { pt11UO, pt09LO, pt09UO }  // Top, left rear, outer
}

// The knob on top
#declare LAMP_TOP_OBJ =
sphere {
  < 0, 0, 0 > 1
  scale < 2, 1, 2 >
}

// Leading for the glass
#declare ptLampB = array[6]
#declare ptLampT = array[6]
#declare Ix = 0 ;

#while ( Ix < 6 )
  #declare ptLampB[Ix] = < ( ( XI[Ix] + XO[Ix] ) * 0.5 ), 0, ( ( ZI[Ix] + ZO[Ix] ) * 0.5 ) > ;
  #declare ptLampT[Ix] = < ( ( XI[Ix] + XO[Ix] ) * 0.5 ), SideHt, ( ( ZI[Ix] + ZO[Ix] ) * 0.5 ) > ;
  #declare Ix = Ix + 1 ;
#end

#declare ptLampTop = < 0, ( SideHt + TopHt + ( Thickness * 0.5) ), 0 > ;

#declare LEAD_BOTTOM_FRAME_OBJ =
union {
  cylinder {
    ptLampB[0], ptLampB[1], Thickness
  }
  cylinder {
    ptLampB[1], ptLampB[2], Thickness
  }
  cylinder {
    ptLampB[2], ptLampB[3], Thickness
  }
  cylinder {
    ptLampB[3], ptLampB[4], Thickness
  }
  cylinder {
    ptLampB[4], ptLampB[5], Thickness
  }
  cylinder {
    ptLampB[5], ptLampB[0], Thickness
  }
  sphere {
    ptLampB[0], Thickness
  }
  sphere {
    ptLampB[1], Thickness
  }
  sphere {
    ptLampB[2], Thickness
  }
  sphere {
    ptLampB[3], Thickness
  }
  sphere {
    ptLampB[4], Thickness
  }
  sphere {
    ptLampB[5], Thickness
  }
}

#declare LEAD_SIDE_FRAME_OBJ =
union {
  cylinder {
    ptLampB[0], ptLampT[0], Thickness
  }
  cylinder {
    ptLampB[1], ptLampT[1], Thickness
  }
  cylinder {
    ptLampB[2], ptLampT[2], Thickness
  }
  cylinder {
    ptLampB[3], ptLampT[3], Thickness
  }
  cylinder {
    ptLampB[4], ptLampT[4], Thickness
  }
  cylinder {
    ptLampB[5], ptLampT[5], Thickness
  }
}

#declare LEAD_UPPER_FRAME_OBJ =
union {
  cylinder {
    ptLampT[0], ptLampT[1], Thickness
  }
  cylinder {
    ptLampT[1], ptLampT[2], Thickness
  }
  cylinder {
    ptLampT[2], ptLampT[3], Thickness
  }
  cylinder {
    ptLampT[3], ptLampT[4], Thickness
  }
  cylinder {
    ptLampT[4], ptLampT[5], Thickness
  }
  cylinder {
    ptLampT[5], ptLampT[0], Thickness
  }
  sphere {
    ptLampT[0], Thickness
  }
  sphere {
    ptLampT[1], Thickness
  }
  sphere {
    ptLampT[2], Thickness
  }
  sphere {
    ptLampT[3], Thickness
  }
  sphere {
    ptLampT[4], Thickness
  }
  sphere {
    ptLampT[5], Thickness
  }
}

#declare LEAD_TOP_FRAME_OBJ =
union {
  cylinder {
    ptLampT[0], ptLampTop, Thickness
  }
  cylinder {
    ptLampT[1], ptLampTop, Thickness
  }
  cylinder {
    ptLampT[2], ptLampTop, Thickness
  }
  cylinder {
    ptLampT[3], ptLampTop, Thickness
  }
  cylinder {
    ptLampT[4], ptLampTop, Thickness
  }
  cylinder {
    ptLampT[5], ptLampTop, Thickness
  }
  cylinder {    // (Really ought to be a torus...)
    < 0, ( SideHt + TopHt - ( Thickness * 2 ) ), 0 >, < 0, ( SideHt + TopHt ), 0 >, 1.5
  }
}

#declare LEAD_OBJ =
union {
  object {
    LEAD_BOTTOM_FRAME_OBJ
  }
  object {
    LEAD_SIDE_FRAME_OBJ
  }
  object {
    LEAD_UPPER_FRAME_OBJ
  }
  object {
    LEAD_TOP_FRAME_OBJ
  }
  texture {
    LEAD_TEX
  }
}

//**********************************************************
// The whole lamp
//**********************************************************
#declare LAMP_OBJ =
union {
  union {
    object {
      LAMP_BODY_OBJ
    }
    object {
      LAMP_TOP_OBJ
      translate < 0, ( SideHt + TopHt + 0.8 ), 0 >
    }
    texture {
      GLASS_TEX
    }
    interior {
      GLASS_INT
    }
  }
  object {
    LEAD_OBJ
  }
  light_source {               // This was set rather low so the scene wouldn't be
    < 0, 2, 0 >                // quite so shadowy...
    color rgb < 1.0, 1.0, 1.0 >
  }
}









