// Persistence of Vision Ray Tracer Scene Description File
// File: w_bowl.pov
// Vers: 3.5
// Desc: A worldbowl...
// Date: 13.2.02
// Auth: Tim Nikias Wenclawiak

/*Worldbowl

Sitting lonely at his desk, Nick marvelled at the
complexity of the world he could see in the bowl.
And he wondered, if one can grasp "real life"
at all, if such a tiny environment can't be
fully understood...

*/

global_settings{
 assumed_gamma 1
 max_trace_level 80
 ambient_light <1,1,1>*.01
 }

//Normal-map for the camera to add my signature
//Note: You can't switch it on without having the normal-map, thus its
//      off in ZIP...
#declare Watermark=off;
#declare Watermark_Size=1024; //800 or 1024

//An assortment of my Macros needed for this scene
#include "bowlmacs.inc"

/*******************  Background  *******************/
//Actually everything outside the room (clouds, moon, even its lightsource)
#declare Ocean =on;
#declare Clouds=on;
#declare Moon=on;
#declare Moon_Rotation = <80,35,0>;
#include "real_sky.inc"

/*******************  Room  *******************/
//The walls and the basic furniture
#declare Table=on;
#declare Room=on;
#declare Window=on;
#declare Poster=on;
#declare Ceiling_Light=off;
#include "room.inc"

/*******************  World-Bowl  *******************/
//Detail-Settings
#declare HF_Detail=1500; //"pixels" on earth-heightfield
#declare Spot_AreaLights=1; //1=pointlight, >1=Arealight
//Don't change these!
#declare Bowl_Position = <6.5,6,7>;
#declare Bowl_Rotation = <0,35,0>;

#declare Light=on;
#declare Ocean = on;
#declare Earth = on;
#declare Glass_Bowl = on;
#declare Atmosphere = off;
#declare Clouds=on;
#declare Bowlbase=on;
#declare Cable=on;
#declare Lightarm=on;
#include "bowl.inc"

/*******************  Various Items  *******************/

#declare Flowers=on;
#declare Notebook=on;
#declare Pencil=on;
#include "items.inc"

/*******************  Camera  *******************/
camera{
 location <-1,9,4> look_at <6.5,7.5,10>
 #if (Watermark)
  #if (Watermark_Size=800) normal{bump_map{tga "art_800.tga" bump_size .3} translate <.375,-.5,0>} #end
  #if (Watermark_Size=1024) normal{bump_map{tga "art_1024.tga" bump_size .3} translate <.4,-.5,0>} #end
 #end
 }

