//crack between wall and ceiling
//top / detail alignment

//wardrobe
//by tek


//scene controls

#declare fBmod = 0.7;//0.7;//0.55;

//#declare FAST=1;


#ifdef ( FAST )

#declare boFastTrees = on;
#declare boFocalBlur = off;
#declare boSnowSpray = off;

#else

#declare boFastTrees = off;
#declare boFocalBlur = on;
#declare boSnowSpray = on;

#end

//includes

#include "rad_def.inc"
#include "shapes.inc"

//#ifndef (FAST)
//	#include "Fir.inc"
//#end

//global set up

global_settings {
	assumed_gamma 2.2
	max_trace_level 8//20
	radiosity {
    //Rad_Settings(Radiosity_Default, off, off)
#ifdef (FAST)
    Rad_Settings(Radiosity_Debug, off, off)
#else
    Rad_Settings(Radiosity_Fast, on, on)
#end
    //Rad_Settings(Radiosity_Normal, off, off)
    //Rad_Settings(Radiosity_2Bounce, off, off)
    //Rad_Settings(Radiosity_Final, off, off)

    //Rad_Settings(Radiosity_OutdoorLQ, off, off)
    //Rad_Settings(Radiosity_OutdoorHQ, off, off)
    //Rad_Settings(Radiosity_OutdoorLight, off, off)
    //Rad_Settings(Radiosity_IndoorLQ, off, off)
    //Rad_Settings(Radiosity_IndoorHQ, off, off)

    recursion_limit 4
	}
}

#default { finish { diffuse 1/fBmod ambient 0 } }





//some object parameters

#declare gvRoomDim = <5, 2.5, 4>;//2.5>;
#declare gvRoomHalfDim = gvRoomDim / 2;

#declare gfWindowSide = -1;

//textures

#default { pigment { rgb 1 } } //dev

#declare pSpotsOnSpots =
	pigment {
		spotted
		scale 0.1
		pigment_map {
			[0
				spotted
				turbulence 0.4
				scale 0.03
				colour_map {
					[0 rgb 0.0]
					[1 rgb 0.3]
				}
			]
			[1
				spotted
				turbulence 0.4
				scale 0.03
				colour_map {
					[0 rgb 0.7]
					[1 rgb 1.0]
				}
			]
		} 
	}

#declare pSpottedGradient =
	pigment {
		gradient y
		pigment_map {
			[0
				spotted
				turbulence 0.7
				scale 0.02
				colour_map {
					[0 rgb 0]
					[1 rgb 0.4]
				}
			]
			[1
				spotted
				turbulence 0.7
				scale 0.02
				colour_map {
					[0 rgb 0.4]
					[1 rgb 1]
				}
			]
		}
	}
	
#declare f_SpottedGradient =
	function {
		pigment { pSpottedGradient }
	}

#declare f_TreeSpots =
	function {
		pigment {
			spotted
			turbulence 0.4//0.7
			octaves 3
			scale 0.02
			colour_map {
				[0 rgb 0]
				[1 rgb 1]
			}
		}
	}


#declare tCeilingPaint =
	texture {
		pigment { rgb <1,0.99,0.97> }///2+0.5 }
	}

#declare tWallpaper =
	texture {
		pigment {
			quilted
			rotate z*45
			scale <0.08/sqrt(2),0.1,10000>
			rotate y*45
			pigment_map {
				[0.5 rgb <0.98,0.93,0.73>]///2+0.45]
				[0.5 rgb <0.9,0.5,0.3>]
			} 
		}
	}

//dark sanded but not polished wooden floorboards	
#declare tFloorBoards =
	texture {
		pigment {
			wood
			turbulence 0.3
			scale 0.1
			rotate <12,88,0>
			pigment_map {
				[0.3	rgb <0.14,0.08,0.03>]
				[0.3	rgb <0.18,0.13,0.10>]
			}
		}
		finish {
			reflection 0.1
			diffuse 0.9/fBmod
		}
		normal {
			wood 0.3
			turbulence 0.3
			scale 0.1
			rotate <12,88,0>
		}
	}
	
#declare tCarpet =
	texture {
		pigment {
			rgb <0.5,0.48,0.4>//<0.5,0.5,0.4>
		}
		normal {
			spotted 1.0
			scale 0.004
			slope_map {
				[0.0	<1,-1>]
				[0.5	<0,-1>]
				[0.5	<0,1>]
				[1.0	<1,1>]
			}
		}
	}

#declare tCeiling = tCeilingPaint;

#declare tWalls = tWallpaper; //tWallpaperAndSkirting;

#declare tFloor = tCarpet;

#declare tBrassRust =
	texture {
		pigment {
			rgb <0.5,0.4,0.1>
		}
		finish {
			brilliance 0.5
			diffuse 0.9/fBmod
			reflection {
				0.1
				metallic 0.8
			}
		}
	}
	
#declare tSteel =
	texture {
		pigment {
			rgb <0.7,0.83,1>
		}
		finish {
			diffuse 0.1/fBmod
			reflection {
				0.7, 1.1
				metallic 0.3
			}
		}
	}
	
#declare tOldMetal = //brassy steely rusty thing
	texture {
		pigment_pattern {
			pSpotsOnSpots
		}
		
		texture_map {
			[0.4
				tBrassRust
			]
			[0.5
				tSteel
			]
		}
	}

#declare rsWoody = seed(30027);
	
#declare tWoody =
	#local nVariations = 10;
	texture {
		pigment {
			wood
			scale <1/5,1,1/5>
			warp {
				turbulence 0.05
				octaves 5
			}
			scale <5,1,5>
			scale nVariations*0.014//0.008
			rotate <82,0,-8>
			translate <-0.08,-1.3,0.0>
			warp {
					repeat x*0.25
					offset z*0.05
					flip x
	 		}
			pigment_map {
/*				[0.46	rgb <0.14,0.08,0.03>+0.05]
				[0.46	rgb <0.18,0.13,0.10>+0.05]*/
				#local nVariation = 0;
				#while ( nVariation < nVariations )
					#local fRatioDelta = 1 / (nVariations - 1);

					#local fVariance = rand(rsWoody)*0.1;
					
					[fRatioDelta*(nVariation + fVariance + 0.0)
						rgb <0.14,0.08,0.03>+0.05 + <rand(rsWoody),rand(rsWoody),rand(rsWoody)>*0.03+ <1,0.5,0.25>*rand(rsWoody)*0.05
					]
					
					#local fVariance = rand(rsWoody)*0.1;
					
					[fRatioDelta*(nVariation - fVariance + 0.5)
						rgb <0.14,0.08,0.03>+0.05 + <rand(rsWoody),rand(rsWoody),rand(rsWoody)>*0.03 + <1,0.5,0.25>*rand(rsWoody)*0.05
					]
					
					#local fVariance = rand(rsWoody)*0.1;
					
					[fRatioDelta*(nVariation + fVariance + 0.5)
						rgb <0.18,0.13,0.10>+0.05 + <rand(rsWoody),rand(rsWoody),rand(rsWoody)>*0.03 + <1,0.5,0.25>*rand(rsWoody)*0.05
					]
					
					#local fVariance = rand(rsWoody)*0.1;
					
					[fRatioDelta*(nVariation - fVariance + 1.0)
						rgb <0.18,0.13,0.10>+0.05 + <rand(rsWoody),rand(rsWoody),rand(rsWoody)>*0.03 + <1,0.5,0.25>*rand(rsWoody)*0.05
					]
				
					#local nVariation = nVariation + 1;
				#end //while
			}
		}
		finish {
			reflection 0.06
			diffuse 0.94/fBmod//1.1/fBmod
			#ifdef ( FAST )
				crand 0.15
			#end
		}
		#ifndef ( FAST )
			normal {
				/*average
				normal_map {
					[1
						dents 1.2
						scale 0.02//0.008
					]
					[1
						granite 0.3//wrinkles 0.3
						scale 0.01
					]
				}*/
				spotted 1
				scale 0.001
			}
		#end //ifndef fast
	}

#declare tLightWood =
	texture {
		pigment {
			gradient -z
			turbulence 0.1
			scale 0.01
			rotate <0,-10,0>
			colour_map {
				[0 rgb <0.9,0.7,0.5> - 0.1]
				[1 rgb <0.95,0.90,0.8> - 0.1]
			}
		}
	}

#declare tMaple =
	texture {
		pigment {	
			agate
			agate_turb 0.5
			
			rotate <10,0,0>
			scale 0.5
			
/*			gradient -z
			scale 1
			warp {
				turbulence 0.7
				octaves 4
			}
			scale 1/1

			rotate <10,0,0>
			scale 0.1*/

			colour_map {
				[0 rgb <0.5,0.3,0.1>]
				[1 rgb <0.2,0.06,0.0>]
			}			
			//todo: tone down when put under coloured varnish.
		}
	}

#declare mVarnish =
	material {
		texture {
			pigment {
				rgbt <0,0,0,1>//rgbf <1.0,0.92,0.8,0.9>
			}
			finish {
				reflection {
					1,1//0.1, 0.35
					fresnel
					metallic 1
				}
				conserve_energy
			}
			normal {
/*				average 1
				normal_map {
					[1
						bump_map {
							png "scratchmap.png"
							once
							interpolate 2
							bump_size 2//5
						}
					]
					[1*/
						spotted 0.2//0.07
						//scale <1,20,1>
						scale 0.005
					/*]
				}*/
			}
			//no_bump_scale
		}
		interior {
			ior 1.3
		}
	}
	
//spec/ref map: do glaze as extra layer, with !=1 transmit and conserve_energy.

/*
#declare tChestnut =
	texture {
		pigment{
			wood
			turbulence 0.3
			octaves 3
			scale 0.03
			rotate <45,-30,0>
			pigment_map {
				[0.6	rgb <0.7, 0.42, 0.04>]
				[0.6	rgb <0.4, 0.16, 0.0>]
			}
		}
		finish {
			diffuse 0.75/fBmod
			reflection 0.15
			specular 0.8 roughness 0.03
		}
	}

#declare tBeech =
	texture {
		pigment {
			wood
			turbulence 0.1
			octaves 3
			scale 0.01
			rotate <10,-80,0>
			pigment_map {
				[0.5	rgb <0.8, 0.65, 0.25>]
				[0.5	rgb <0.6, 0.5, 0.25>]
			}
		}
		finish {
			reflection 0.05
			diffuse 0.95/fBmod
		}
	}
*/	


//objects



#declare gvWardrobeDim = <1,2.2,0.5>;
#declare gvWardrobeHalfDim = gvWardrobeDim/2;

#declare gfWardrobeDoorThickness = 0.03;
#declare gfWardrobeDoorDesignThickness = 0.0059;
#declare gfWardrobeBackThickness = gfWardrobeDoorThickness;
#declare gfWardrobePanelThickness = 0.02;
#declare gfWardrobeBaseHeight = 0.2;
#declare gfWardrobeRailHeight = 1.8;
#declare gfWardrobeRailRad = 0.015;
#declare gfWardrobeTopHeight = 0.2;
#declare gfWardrobeTopmThickness = 0.06;
#declare gfWardrobeTopInset = 0.02;
#declare gfWardrobeTopHoleRad = 0.05;
#declare gfWardrobeTopAngle = 20;

#declare gvWardrobeInnerHalfDim = gvWardrobeHalfDim - <gfWardrobePanelThickness,0,gfWardrobeDoorThickness>;

#declare gfWardrobeWallGap = 0.02;



//hole to narnia

#declare fConePointOffset = 1;
#declare fConeNudgeRight = 0.07;
#declare oHoleU =
	intersection {
		//simple unit pyramid point at <0,0,0> base in z axis
		plane { < 1,0,-1>, 0 }
		plane { <-1,0,-1>, 0 }
		plane { <0, 1,-1>, 0 }
		plane { <0,-1,-1>, 0 }
		
		//scale to fit back of wardrobe
		scale <gvWardrobeInnerHalfDim.x/2 - fConeNudgeRight/2, gvWardrobeHalfDim.y - (gfWardrobeTopHeight + gfWardrobeBaseHeight)/2, gvWardrobeInnerHalfDim.z + fConePointOffset>
		
		//and put it there
		translate <gvWardrobeInnerHalfDim.x/2 + fConeNudgeRight/2, gvWardrobeHalfDim.y + (gfWardrobeBaseHeight - gfWardrobeTopHeight)/2, -fConePointOffset>
	}

#declare oHole =
	object {
		oHoleU
		
		material {
			texture { tMaple }
		}
	}
//hole


#declare oBackPlane =
	plane {
		z, gvWardrobeHalfDim.z + gfWardrobeWallGap + 0.11
	}


//details

//main parts



#declare oTopPlane =
	plane {
		y, 0
		rotate <0,0,gfWardrobeTopAngle>
		translate <0,gfWardrobeTopHeight,0>
	}

#declare oTopHole =
	cylinder {
		-z,z,gfWardrobeTopHoleRad
		inverse
		translate <-gfWardrobeTopHoleRad*0.8,gfWardrobeTopHeight-gfWardrobeTopHoleRad*0.6,0>
	}
	
#declare oTopBevelling =
	/*plane {
		<0,-1,-1>, 0
		rotate <0,0,gfWardrobeTopAngle>
		translate <0,gfWardrobeTopHeight,0>
	}*/
	merge {
		cylinder {
			<-100,0,gfWardrobeTopInset/3>, <100,0,gfWardrobeTopInset/3>, gfWardrobeTopInset/3
		}
		difference {
			box {
				<-100, -gfWardrobeTopInset, gfWardrobeTopInset/3>, <100, 0, gfWardrobeTopInset*1.001>
			}
			cylinder {
				<-100, -gfWardrobeTopInset, gfWardrobeTopInset/3>, <100, -gfWardrobeTopInset, gfWardrobeTopInset/3>, gfWardrobeTopInset/3
			}
		}

		rotate <0,0,gfWardrobeTopAngle>
		translate <0,gfWardrobeTopHeight,0>
	}

#declare oWardrobeTop =
	merge {
		intersection {
			box { <-gvWardrobeHalfDim.x, 0, 0>, <gvWardrobeHalfDim.x, gfWardrobeTopHeight, gfWardrobeTopmThickness> }
			merge {
				object { oTopBevelling }
				object { oTopBevelling scale <-1,1,1> }
				plane { -z, -gfWardrobeTopInset }
			}
			object { oTopPlane }
			object { oTopPlane scale <-1,1,1> }
			object { oTopHole }
			object { oTopHole scale <-1,1,1> }

			translate -gfWardrobeTopInset*z
		}
		box {
			<-gvWardrobeHalfDim.x,0,gfWardrobeTopmThickness-gfWardrobeTopInset>, <gvWardrobeHalfDim.x,gfWardrobePanelThickness,gvWardrobeDim.z>
			//pigment { rgb 1 }
		}
		
		material { texture { tMaple } translate 7 }
		material { mVarnish }
	}


#declare oWardrobeDoor =
	//left door
	merge {
		//box {
		object {
			Round_Box( 
				<0, -(gvWardrobeHalfDim.y - gfWardrobeBaseHeight), -gfWardrobeDoorThickness + gfWardrobeDoorDesignThickness>, <gvWardrobeInnerHalfDim.x,gvWardrobeHalfDim.y - gfWardrobeTopHeight, 0>
			, min(gfWardrobeDoorThickness/4-0.0001,0.012), on)
		}
		intersection {
			height_field {
				png "front design.png"
				smooth
			}
			plane {
				-y, -0.0001
			}
			
			rotate <-90,0,0>
			scale <gvWardrobeInnerHalfDim.x, gvWardrobeDim.y - gfWardrobeTopHeight - gfWardrobeBaseHeight, gfWardrobeDoorDesignThickness + 0.001>
			translate <0,-(gvWardrobeHalfDim.y - gfWardrobeBaseHeight), (-gfWardrobeDoorThickness + gfWardrobeDoorDesignThickness) + 0.001>

			texture { tLightWood }
		}
	}

#declare oWardrobeBack =
	box {
		//left side
		-<1,gvWardrobeHalfDim.y,0>, <1,gvWardrobeHalfDim.y - gfWardrobeTopHeight,1>
		scale <gvWardrobeInnerHalfDim.x, 1, gfWardrobeBackThickness>
		material { texture { tMaple } translate 9 }
		material { mVarnish }
	}

#declare oWardrobeSide =
	box {
		//left side
		-<0,gvWardrobeHalfDim.y,1>, <1,gvWardrobeHalfDim.y - gfWardrobeTopHeight,1>
		scale <gfWardrobePanelThickness, 1, gvWardrobeInnerHalfDim.z>
		material { texture { tMaple } translate 2 }
		material { mVarnish }
	}

#declare oWardrobeBottom =
	box {
		-<1,0,1>, 1
		scale <gvWardrobeInnerHalfDim.x, gfWardrobeBaseHeight, gvWardrobeInnerHalfDim.z>
		material { texture { tMaple } translate 47 }
		material { mVarnish }
	}

#declare oWardrobeRail =
	cylinder {
		<-gvWardrobeInnerHalfDim.x, 0, 0>, <gvWardrobeInnerHalfDim.x, 0, 0>, gfWardrobeRailRad

		texture { tOldMetal }
	}
	
#declare oCoatHanger =
	#declare fHangarThickness = 0.0225;
	//40cm span, 4cm displacement. => rad^2 = (rad-0.04)^2 + 0.4^2
	//or, a=atan(40,4), b=180-2a. rad = 0.2/sin(b)
	#declare fHangerInRad = 0.2 / sin( pi - 2*atan2(20,4) );
	#declare fHangerOrigin = 0.094;
	#declare fMoo = (0.02 - 0.001) - gfWardrobeRailRad;
	union {
		//hook
		merge {
			intersection {
				plane { -y, 0 }
				torus { 0.02, 0.001 rotate <90,0,0> }
			}
			cylinder { <0.02, 0, 0>, <0.02, -0.013, 0>, 0.001 }
			cylinder { <-0.02, 0, 0>, <-0.02, -0.013, 0>, 0.001 }
			intersection {
				plane { y, 0 }
				plane { -x, 0 rotate <0,0,60> }
				torus { 0.02, 0.001 rotate <90,0,0> }
				translate <-0.04,-0.013,0>
			}
			cylinder {
				<0.02,0,0>, <0.02,-0.02,0>, 0.001
				rotate <0,0,-30>
				translate <-0.04,-0.013,0>
			}
			rotate <0,0,30>
			translate -fMoo*y
			
			texture {
				tSteel
			}
		}
		//main bit
		intersection {
			difference {
				torus {
					fHangerInRad+fHangarThickness/2, fHangarThickness/2
					rotate <90,0,0>
					translate <0,-fHangerInRad + 0.04,0>
				}
				merge {
					cylinder {
						<-0.175,fHangarThickness+0.009,-1>, <-0.175,fHangarThickness+0.009,1>, 0.005
					}
					cylinder {
						<0.175,fHangarThickness+0.009,-1>, <0.175,fHangarThickness+0.009,1>, 0.005
					}
				}
			}
			plane { -x, 0.20 }
			plane { x, 0.20 }
			plane { -z, 0.005 }
			plane { z, 0.005 }
			plane { -y, 0.01 }
			texture {
				pigment { rgb <1,0.83,0.6> }
			}
			
			translate <0,-fHangerOrigin,0>
		}
	}

//full object

#declare oWardrobe =
	merge {
		difference {
			object { oWardrobeBack translate <0,0,gvWardrobeInnerHalfDim.z> }
			object { oHole translate -gvWardrobeHalfDim.y*y }
		}
		object { oWardrobeSide translate <-gvWardrobeHalfDim.x,0,0> }
		object { oWardrobeSide scale <-1,1,1> translate <gvWardrobeHalfDim.x,0,0> }
		object { oWardrobeTop translate <0,gvWardrobeHalfDim.y - gfWardrobeTopHeight,-gvWardrobeHalfDim.z> }
		object { oWardrobeBottom translate <0,-gvWardrobeHalfDim.y,0> }
		object {
			oWardrobeDoor
			rotate <0,0,0>
			translate <-gvWardrobeInnerHalfDim.x,0,-gvWardrobeInnerHalfDim.z>
			material { texture { tMaple } translate 0 }
			material {
				mVarnish
//				scale <gvWardrobeInnerHalfDim.x,gvWardrobeDim.y - gfWardrobeTopHeight - gfWardrobeBaseHeight,1>
			}
		}
		object {
			oWardrobeDoor
			scale <-1,1,1>
			rotate <0,-128,0>
			translate <gvWardrobeInnerHalfDim.x,0,-gvWardrobeInnerHalfDim.z>
			material { texture { tMaple } translate 14 }
			material {
				mVarnish
//				scale <gvWardrobeInnerHalfDim.x,gvWardrobeDim.y - gfWardrobeTopHeight - gfWardrobeBaseHeight,1>
			}
		}
  	object { oWardrobeRail translate <0,gfWardrobeRailHeight-gvWardrobeHalfDim.y,0> }
				
		object { oCoatHanger	rotate <0,275,0>		translate <-0.10,gfWardrobeRailHeight-gvWardrobeHalfDim.y,0> }
		object { oCoatHanger	rotate <0,271,0>		translate <0.05,gfWardrobeRailHeight-gvWardrobeHalfDim.y,0> }
		object { oCoatHanger	rotate <0,260,0>		translate <0.15,gfWardrobeRailHeight-gvWardrobeHalfDim.y,0> }
		object { oCoatHanger	rotate <0,273,0>		translate <gvWardrobeInnerHalfDim.x - 0.04,gfWardrobeRailHeight-gvWardrobeHalfDim.y,0> }
		
		translate y*gvWardrobeHalfDim.y
	}
//end of oWardrobe


//the room

#declare oRoom =
	//merge {
	difference {
		box {
			-gvRoomHalfDim - 0.1*<1,1,1>, gvRoomHalfDim + 0.1*<1,1,1>
			pigment { rgb <0.48,0.17,0.03> } //make it brickey in case I want to put stuff outside the window.
		}
		intersection {
			plane {
				-y, gvRoomHalfDim.y
				texture {
					tFloor
				}
			}
			plane {
				y, gvRoomHalfDim.y
				texture {
					tCeiling
				}
			}
			plane {
				x, gvRoomHalfDim.x
				texture {
					tWalls
				}
			}
			plane {
				-z, gvRoomHalfDim.z
				texture {
					tWalls
				}
			}
			plane {
				z, gvRoomHalfDim.z
				texture {
					tWalls
				}
			}
			merge {
				box { <gfWindowSide*(gvRoomHalfDim.x-1), -0.5, -1.2>, <gfWindowSide*(gvRoomHalfDim.x + 1), 1, 1.2> } //window
				plane {
					-x, gvRoomHalfDim.x
					texture {
						tWalls
					}
				}
			}


			//hide a strange bright patch on the wall. If you work out what caused it please mail ne! (tek@evilsuperbrain.com)
			merge {
				cylinder {
					<-gvRoomHalfDim.x,gvRoomHalfDim.y-0.01,gvRoomHalfDim.z-0.01>, <gvRoomHalfDim.x,gvRoomHalfDim.y-0.01,gvRoomHalfDim.z-0.01>, 0.01
				}
				plane {
					z, gvRoomHalfDim.z-0.01
				}
				plane {
					y, gvRoomHalfDim.y-0.01
				}
				texture {
					tCeiling
				}
			}

		} //intersection
		

/*		intersection {
			merge {
				box {	-gvRoomHalfDim - y, gvRoomHalfDim + y } //room
				box { <gfWindowSide*(gvRoomHalfDim.x-1), -0.5, -1.2>, <gfWindowSide*(gvRoomHalfDim.x + 1), 1, 1.2> } //window
//				box {} //door way

				texture {
					tWalls
				}
			}
			plane {
				-y, gvRoomHalfDim.y
				texture {
					tFloor
				}
			}
			plane {
				y, gvRoomHalfDim.y
				texture {
					tCeiling
				}
			}
//			plane {
//				z+y, 0
//				translate <0,gvRoomHalfDim.y,gvRoomHalfDim.z> - <0,1,1>*0.002
//				texture {
//					tCeiling
//				}
			}
		}*/ //intersection
		//} //difference
		
		//view for radiosity:		
		/*sphere {
			0, 1
			
			bounded_by { box { -<0.5,1,1>, <0.5,1,1> translate gfWindowSide*0.5*x scale 1.1 } }
		
			hollow on
		
			scale gvRoomHalfDim.z	
			translate <gfWindowSide*gvRoomHalfDim.x,gvRoomHalfDim.y,0>
			
			finish {
				diffuse 0
				ambient 1
			}
			
			pigment {
				gradient y
				scale 2
				translate -y
				pigment_map {
					[0.0 rgb <0.3,0.15,0.05>*0.7]
					[0.5 rgb <0.3,0.15,0.05>*0.7]
					[0.5 rgb 3]//7*fBmod]
					[1.0 rgb <0.3,0.7,1>*1]
				}
			}
		}*/


		translate <0,gvRoomHalfDim.y,0> //put floor at 0.
		translate <0,0,-gvRoomHalfDim.z + gvWardrobeHalfDim.z + gfWardrobeWallGap> //move wall up against wardrobe. That's a novel way to do it :)
		
	} //difference
//end of oRoom


//narnia

//component objects

#declare f_ConeY =
	function(x,y,z, fBaseRad, fTopRad, fHeight) {
		//distance from a vetical line offset by linear interpolation between radii
		sqrt( x*x + z*z ) -
		(fBaseRad + (y/fHeight)*(fTopRad - fBaseRad))
	}

#declare oLoTree =
//	#if (boFastTrees)
		union {
			//trunk
			cone {
				0, 0.2, 4*y, 0
				
				pigment { rgb <0.2,0.16,0.1> }
				finish {
					diffuse 1
				}
			}
			
			//leaves
			cone {
				0, 1.5, 4*y, 0
				
				hollow on			
				
				pigment {
					//mottled gradient
					pigment_pattern {
						gradient y
						pigment_map {
							[0
								spotted
								turbulence 0.7
								scale 0.02
								colour_map {
									[0 rgb 0]
									[1 rgb 0.4]
								}
							]
							[1
								spotted
								turbulence 0.7
								scale 0.02
								colour_map {
									[0 rgb 0.4]
									[1 rgb 1]
								}
							]
						}
					}
					scale 4
					
					pigment_map {
						[0.3	rgb <0.1,0.5,0.2> transmit 1]
						[0.32	rgb <0.1,0.5,0.2>*0.3+<0.03,0,0> transmit 0]
						[0.4	rgb <0.1,0.5,0.2> transmit 0]
						[0.6	rgb <1,1,1.05> transmit 0]
					}
				} //pigment
				finish {
					diffuse 1
				}
			} //cone
		} //merge
//	#else //if boFastTrees

#declare oHiTree =
/*		object {
			oFir
		}*/
		union {
			//trunk
			cone {
				0, 0.2, 4*y, 0
				
				pigment { rgb <0.2,0.16,0.1> }
				finish {
					diffuse 1
				}
			}
			//leaves
//			cone {
				//0, 1.5, 4*y, 0
			isosurface {
				//cone perturbed by the same thing as used on the pigment.
				function {
					f_ConeY(x,y,z, 1.5,0,4) +
					//(2.5)*(1-y/4)*(0.8 - (f_SpottedGradient(x/4,y/4,z/4).red - 0.4*y/4)/0.4)
					//simplify:
					(f_TreeSpots(x/4,y/4,z/4).red - 0.5)*0.4
				}
				max_gradient 2
				//accuracy 0.01
				contained_by { box { <-2,0,-2>, <2,4.3,2> } }
				//all_intersections
				
				hollow on			
				
				pigment {
					//mottled gradient
					pigment_pattern {
						pSpottedGradient
					}
					scale 4
					
					pigment_map {
						[0.3	rgb <0.1,0.5,0.2> transmit 1]
						[0.32	rgb <0.1,0.5,0.2>*0.3+<0.03,0,0> transmit 0]
						[0.4	rgb <0.1,0.5,0.2> transmit 0]
						[0.6	rgb <1,1,1.05> transmit 0]
					}
				} //pigment
				finish {
					diffuse 1/fBmod
				}
			} //isocone thing
		} //merge
//	#end //if boFastTrees else
//end of oTree
	

#declare oSnowyGroundLoDetail =
	box {
		-<1,1,0>, <1,0,1>
		scale <10,1,40>
		translate <0,0,1>
		
		pigment { rgb <1,1,1.1> }
		finish { diffuse 1 }
	}

#declare f_Ramp =
	function (x) {
		sin(max(min(x,pi/2),-pi/2))
	}

#declare oSnow =
	isosurface {
		function {
			y + //plane
			(sin(x)*sin(z)*sin((x+z/2)/sqrt(5))*sin((z/2-x)/sqrt(5)))/2 //hills
			//- 4*(1 - 1/(z*z/100+1)) //curve up slightly to give nice depth on trees. 
			-(f_Ramp((z-11)*1)+1)*2/2
		}
		max_gradient 5//1
		contained_by {
			box { <-40,-1,0-2>, <40,20,100> }
		}
		
		scale 1.5
		translate <gvWardrobeInnerHalfDim.x/2,gfWardrobeBaseHeight - 0.05, gvWardrobeHalfDim.z>// + gfWardrobeWallGap + 0.11)>
	}


#declare oSprayTarget =
	merge {
		object { oSnow }
		difference {
			difference {
				object { oBackPlane }
				plane { z, gvWardrobeHalfDim.z }
			}
			object { oHoleU }
		}
		intersection {
			plane { y, gfWardrobeBaseHeight }
			plane { z, gvWardrobeHalfDim.z }
		}
	}


#if ( boSnowSpray )

	#declare oSnowSpray =
		blob {
		//merge {
			#local vSprayDir = <0.15,-6,-1>;
			#local vSprayDirRange = <0.3,0,0.6>;
			#local fSprayRadius = 1.0;
			#local fParticleSizeMin = 0.02; //shrink in the distance
			#local fParticleSizeMax = 0.02;
			#local rsPos = seed(1111);
			#local rsDir = seed(111);
			
			#local nParticle = 0;
			#while ( nParticle < 8000 )
	
				//random pos within door area, distribution drops off towards edges (for LOD outside and drop off inside)
				#local fRad = rand(rsPos);
				#local fRad = pow(fRad, 1) * fSprayRadius;
				#local fAng = rand(rsPos) * 2 * pi;
				#local vPos = <cos(fAng),0,sin(fAng)>*fRad + <gvWardrobeInnerHalfDim.x/2,gfWardrobeBaseHeight, gvWardrobeHalfDim.z>;//+0.3>;
				#local vDir = vSprayDir + vSprayDirRange*2*(<rand(rsDir),rand(rsDir),rand(rsDir)> - 0.5);
				#local vNorm = <0,0,0>;
				
				#local vPos = trace( oSprayTarget, vPos - vDir*100, vDir, vNorm );
				
				sphere { vPos, fParticleSizeMin + (fParticleSizeMax - fParticleSizeMin)*(1 - fRad/fSprayRadius), 1 }
				
			
				#local nParticle = nParticle+1;
			#end //while
		}
#end //if ( boSnowSpray )

#declare oFootprintRight =
	//oriented to lie flat, maybe rotate when placed to match ground normal.
	intersection {
		height_field {
			png "footprint.png"
			smooth
		}
		height_field {
			png "footprint.png"
			smooth
			translate <0,-0.1,0> //flat square occurs this far up.
			scale <1,2000,1> //make the footprint very deep, to avoid a nasty flat square that happens if it's too shallow.
		}
		
		translate <-0.5,0,-0.5>

		rotate <0,0,180> //turn to face down
		rotate <0,17,0>
		translate <0,0.05,0> //push out of ground a bit
		translate <0.5,0,0> //offset to the right because it's an easy way to do so.
	}
	
#declare oFootprintLeft =
	object {
		oFootprintRight
		scale <-1,1,1>
	}

#declare rsFootPrint = seed(111);
	
#macro m_FootPrintsSpline( sSpline )

	#declare fPaceLength = 0.25;
	#declare vFootprintScale = <0.075,0.015,0.15>;
	
	#local vNorm = <0,0,0>;
	#local boRight = true;

	#local fDist = rand(rsFootPrint)*fPaceLength*2 - fPaceLength;
	#while ( fDist < 20 )
	
		//#local vPos = sSpline(fDist);
		
		//direction of footprint.
		//#local vDir = sSpline(fDist+0.1);
		#local vDir = vnormalize(sSpline(fDist+0.1) - sSpline(fDist));
		
		#local fAngle = degrees( asin( vDir.x ) );
		
		//position on ground
		#local vPos = trace( oSnow, sSpline(fDist) + 1000*y, -y, vNorm );
		
		//orientation to match ground
		#local vTilt = <degrees(vNorm.z), 0, -degrees(vNorm.x)>; //I can't be arsed to solve the exact maths for this, the ground's fairly flat anyway so just use small angle formula (theta = sin(theta))
		
		object {
			#if ( boRight )
				oFootprintRight
			#else
				oFootprintLeft
			#end

			//a little irregularity in the step
			//this is in terms of footprint texture, i.e. 1*x=width, 1*z=length, 1*y=depth
			translate 2*<0.2,0.3,0.5>*(<rand(rsFootPrint),rand(rsFootPrint),rand(rsFootPrint)>-0.5)
			
			scale vFootprintScale//*70
			rotate <0,fAngle,0>
			rotate vTilt
			translate vPos
		}

		#local boRight = !boRight;		
	
		#local fDist = fDist + fPaceLength;
	#end //while
	
#end

#declare sFootprints1 =
	spline {
		cubic_spline
		-1, <gvWardrobeInnerHalfDim.x/2,0,-1>
		0, <gvWardrobeInnerHalfDim.x/2,0,0>
		20, <12,0,16>
		21, <12+1,0,16+1>
		
	}

#declare sFootprints2 =
	spline {
		cubic_spline
		-1, <gvWardrobeInnerHalfDim.x/2,0,-1>
		0, <gvWardrobeInnerHalfDim.x/2,0,0>
		20, <3,0,20>
		21, <3,0,21>
	}

#declare sFootprints3 =
	spline {
		cubic_spline
		-1, <gvWardrobeInnerHalfDim.x/2,0,-1>
		0, <gvWardrobeInnerHalfDim.x/2,0,0>
		4, <0,0,4>
		18, <-3,0,16.3>
		20, <-2,0,18>
		21, <-2+1,0,18+1>
	}


#declare oSnowyGround =
	difference {
		merge {
			intersection {
				//ground
				object { oSnow }
				//clip to wardrobe hole
				intersection {
					merge {
						plane { -z, -(gvWardrobeHalfDim.z + gfWardrobeWallGap + 0.11) }
						object { oHoleU translate <0,-1,0> scale <1,10,1> }
					}
					plane { -z, -gvWardrobeHalfDim.z }//0 }
				}
			}
			#if ( boSnowSpray )
				intersection {
					//snow drift
					object { oSnowSpray }
					//clip to inside of wardrobe and narnia
					merge {
						plane { -z, -(gvWardrobeHalfDim.z + gfWardrobeWallGap + 0.11) }
						object { oHoleU translate <0,-1,0> scale <1,10,1> }
						box { -gvWardrobeInnerHalfDim, gvWardrobeInnerHalfDim }
					}
				}
			#end
		}
		merge {
			m_FootPrintsSpline( sFootprints1 )
			m_FootPrintsSpline( sFootprints2 )
			m_FootPrintsSpline( sFootprints3 )
		}

		pigment { rgb <1,1,1.1> }
		finish { diffuse 1 }
	}

//end of oSnowyGround




//the whole thing

#declare oNarnia =

	#local rsTreeMoo = seed(381);
	#local rsTreePos = seed(117);
	#local rsDistTreeMoo = seed(5330);
	#local rsDistTreePos = seed(335);

	union {
	
		#local nTree = 2;
		#while ( nTree > 0 )
			object {
				#if (boFastTrees) 
					oLoTree
				#else
//					#if ( nTree = 4 | nTree = 10)
					  //tree is in frame, use hi-res
						oHiTree
//					#else
//						oLoTree
//					#end
				#end //if bofasttrees else
				
				#local vPos = <rand(rsTreePos)*2-1,0,rand(rsTreePos)*2-1>*1;
//				#local vPos = trace( oSnow, vPos + 1000*y, -y );
	
				//pos within area
				scale 1 + <0.2,0.2,0.2>*(<rand(rsTreeMoo),rand(rsTreeMoo),rand(rsTreeMoo)> - 0.5)
				rotate <0,rand(rsTreeMoo)*360,0>
//				translate vPos
				
				//pos of area within world
				rotate <0,30,0>
				#local vPos = vrotate( vPos, <0,30,0> );
//				translate <-2,0,9>
				#local vPos = vPos + <1,0,7>;

				#local vNorm = <0,0,0>;
				#local vPos = trace( oSnow, vPos + 1000*y, -y, vNorm );
			
				#if ( vlength(vNorm) > 0 )				
					translate vPos
				#else
					#warning "couldn't place tree\n"
					translate -1000*y
				#end

			}
			#local nTree = nTree - 1;
		#end //while
		
		//distant trees
		#local nTree = 50;
		#while ( nTree > 0 )

			object {
				oLoTree
				
				#local vPos = <rand(rsDistTreePos)*2-1,0,rand(rsDistTreePos)*2-1>*<10,0,17>;
//				#local vPos = trace( oSnow, vPos + 1000*y, -y );
	
				//pos within area			
				scale 1 + <0.2,0.2,0.2>*(<rand(rsDistTreeMoo),rand(rsDistTreeMoo),rand(rsDistTreeMoo)> - 0.5)
				rotate <0,rand(rsDistTreeMoo)*360,0>
//				translate vPos
				
				//pos of area within world
				rotate <0,0,0>
				#local vPos = vrotate( vPos, <0,0,0> );
//				translate <2,0,12>
				#local vPos = vPos + <1,0,22>;

				#local vNorm = <0,0,0>;
				#local vPos = trace( oSnow, vPos + 1000*y, -y, vNorm );
			
				#if ( vlength(vNorm) > 0 )				
					translate vPos
				#else
					#warning "couldn't place tree\n"
					translate -1000*y
				#end
			}

			#local nTree = nTree - 1;
		#end //while
		
		object { oSnowyGround }
		
	}
//end of oNarnia





//the scene

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z*0.8
	
	location <0.15,1.18+0.1,-1.7>
	look_at <0.15,1.18,0>

	//crack debug cam 
	//location <1,gvRoomDim.y - 0.01,gvWardrobeHalfDim.z + gfWardrobeWallGap - 0.01>
	//look_at <0,gvRoomDim.y,gvWardrobeHalfDim.z + gfWardrobeWallGap>
	
	//location <0,1,0>
	//look_at <0,0,2>

#if (boFocalBlur)
  aperture 0.04           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 40//16        // number of rays per pixel for sampling
  focal_point <0.13,1.18,gvWardrobeInnerHalfDim.z/2>    // point that is in focus <X,Y,Z>
  confidence 0.99           // [0...1] when to move on while sampling (smaller is less accurate)
  variance 1/255            // [0...1] how precise to calculate (smaller is more accurate)
#end
}


#declare fEdge = 0.5;

sky_sphere{
	pigment {
		gradient z
		scale 2
		translate -1
		
		pigment_map {
			[fEdge
				#declare fSkyBright = 1;//3; 
				//real world
				gradient y
				//scale 2
				//translate -y
				pigment_map {
					[0.0 rgb <0.3,0.15,0.05>]
					[0.4 rgb <0.3,0.15,0.05>]
					[0.5 rgb fSkyBright]
					[1.0 rgb <0.5,0.5,1>*fSkyBright]
				}
			]
			[fEdge
				//narnia
				gradient y
				//scale 2
				//translate -y
				pigment_map {
					[0.0 rgb 0.9]
					[0.5 rgb <0.85,0.86,0.88>]
					[0.5 rgb 1]
					[1.0 rgb <0.65,0.7,0.75>]//<0.3,0.7,1>]
				}
			]
		} //pigment_map
	} //pigment
} //sky_sphere

/*light_source {
	<gfWindowSide*(gvRoomHalfDim.x+0.1), gvRoomHalfDim.y + 0.5,0> //gvRoomHalfDim.y + 0.25,0>
	rgb fBmod*1
	
	area_light x*1.2, y*0.5, 8, 8
}*/


//sun through window
light_source {
	<gfWindowSide*3,2,-1>*10000
//	rgb 0.7//
	rgb <1.05,0.95,0.9>//summer evening sunshine
			*1.8// *fBmod*1.4// *0.7//
}

object { oWardrobe }


difference {
	object { oRoom }
	object { oHole }
}
//okay... WHAT? if ANY object is put in after the room the error appears!!!



//spacer between wardrobe and wall
intersection {
	difference {
		object { oHole translate <0,0,-0.03> }
		object { oHole }
	}
	plane { z, gvWardrobeHalfDim.z + gfWardrobeWallGap }
	plane { -z, -gvWardrobeHalfDim.z }

}


//edge between the worlds
object{
	oBackPlane

	hollow on

	clipped_by {
		object { oHoleU inverse }
	}
	
	pigment { rgb 0 }
	finish { reflection 1 }
}



//object { oCoatHanger translate <0.13,1.18,-2> }

//narnia sun
light_source {
//	<2,3,1>*10000
//	move more z less x, so shadows not parallel to real sun! it looks very confusing.
	<1,3,2>*10000
	rgb 0.2//0.7
}

object { oNarnia }


/*
light_source {
	<-2,1,-3>
	rgb 0.3//0.7
}

*/