#if (POV35) 
#else
#version unofficial MegaPov 0.7;
#end



#declare NumDrops=20;
#declare DropSizeStream=seed(911);
#declare DropPlacement=seed(61348);

#declare lamppaint_h = texture {
	pigment {
		color rgb <.5,.5,.5>
	}
	normal {
		agate .2
		agate_turb 0.5
	}
	scale .01
}

#declare water_h = texture {
	pigment {colour rgbf<.9, .9, 1, .9>}
	finish {reflection .3
		diffuse .1
		specular .5
		roughness .0001}
}

	

#declare lampglass_h = 
/*texture {
	pigment {
		bozo
		color_map {
			[0.0 color rgbf <1,.6,.6,1>]
			[0.3 color rgbf <.7,1,.6,1>]
			[0.6 color rgbf <.8.6,1,1>]
			[0.8 color rgbf <.6,1,.6,1>]
		}
	}
	finish {
		diffuse .1
	}

}*/
texture {
	pigment {
		color rgbf <.89, .89, .9, .9>
	}
	finish {
		reflection .15
		diffuse .1
	}

}
texture {
	pigment {
		bozo
		turbulence .5
		colour_map {
			[0.0 rgbf 1]
			[0.2 rgbf <1,1,1,.8>]
			[0.22 rgbf 1]
			[0.25 rgbf <1,1,1,.9>]
			[0.3 rgbf 1]
			[0.5 rgbf 1]
			[0.6 rgbf <1,1,1,.8>]
			[0.63 rgbf 1]
			[0.7 rgbf <1,1,1,.9>]
			[0.75 rgbf 1]
		}
	}
	finish {
		reflection .0
		diffuse .0
		specular .0
//		roughness .1
		ambient .2
	}
	scale .02

}



#declare lampcolour_h= rgb <1,.75,.65>;

#declare farlamp_h= union {
light_source
{
  
  0*x // light's position (translated below)
  color lampcolour_h * 2.2 // light's color
#if (AREALAMP)  
  area_light
  <-2,-2,-2>, <2,2,2>,
  4,4
  circular
  orient
#end
  looks_like {
  	sphere {
  		<0,0,0>
  		2
  		pigment {color lampcolour_h}
  		finish {ambient 50}
  	}
  }
//  fade_distance 350*SCALEFACTOR
//  fade_power 2
  fade_distance 180*SCALEFACTOR
  fade_power 1.2
  translate <0, 8, 0>
  media_attenuation on
  	
}
#if (MEDIA)
sphere {
	<0,0,0>
	1
	pigment {colour rgbf <1,1,1,1>}
	interior {
		media {
			emission .00035
//			scattering { 2, rgb .000015}
			intervals 1
  			samples 5
  			method 3
  			density {
  				spherical
//  				density_map 
  			}	
		}
	}
	hollow
	scale 100
	translate <0,8,0>
}
#end
union {
	box {
		<3,0,3>
		<2.2,15,2.2>
	}
	box {
		<-3,0,-3>
		<-2.2,15,-2.2>
	}
	box {
		<3,0,-3>
		<2.2,15,-2.2>
	}
	box {
		<-3,0,3>
		<-2.2,15,2.2>
	}

	cylinder {
		<0,14.5,0>
		<0,15.5,0>
		5
	}

	intersection {
		sphere {
			<0,0,0>
			5
		}
		box {
			<30,0,30>
			<-30,-30,-30>
		}
	}
	cylinder {
		<0,-200, 0>
		<0,-3,0>
		2
	}
	sphere {
		<0,-100,0>
		4
	}
	cylinder {
		<0,-150,0>
		<0,-100,0>
		4
	}
	
	texture {lamppaint_h}
}
	union { 
		box {
		<2.5, -1, 2.5>
		<2.7, 15.1, -2.5>
		}
		box {
		<-2.5, -1, 2.5>
		<-2.7, 15.1, -2.5>
		}
		box {
		<2.5, -1, 2.5>
		<-2.5, 15.1, 2.7>
		}
		box {
		<2.5, -1, -2.5>
		<-2.5, 15.1, -2.7>
		}
		difference {
#declare GlassCase = sphere {
				<0,15.5,0>
				4.5
			}
			object {GlassCase}
			sphere {
				<0,15.5,0>
				4.3
			}
			box {
				<-10,15,-10>
				<10,-30,10>
			}
		}
}

	texture {lampglass_h}
	      interior {
#if (REFRACTION) ior 1.45 #end
      }

	no_shadow
}       		


#declare nearlamp_h = union {
light_source
{
  
  0*x // light's position (translated below)
  color lampcolour_h * 2 // light's color
#if (AREALAMP)  area_light <-2,-2,-2>, <2,2,2>,3,3
  circular
  orient
#end
  looks_like {
  	sphere {
  		<0,0,0>
  		2
  		pigment {color lampcolour_h}
  		finish {ambient 50}
  	}
  }
//  fade_distance 350*SCALEFACTOR
//  fade_power 2
  fade_distance 180*SCALEFACTOR
  fade_power 1.2
  translate <0, 8, 0>
  media_attenuation on
  	
}
union {
	box {
		<3,0,3>
		<2.2,15,2.2>
	}
	box {
		<-3,0,-3>
		<-2.2,15,-2.2>
	}
	box {
		<3,0,-3>
		<2.2,15,-2.2>
	}
	box {
		<-3,0,3>
		<-2.2,15,2.2>
	}

	cylinder {
		<0,14.5,0>
		<0,15.5,0>
		5
	}

	intersection {
		sphere {
			<0,0,0>
			5
		}
		box {
			<30,0,30>
			<-30,-30,-30>
		}
	}
	cylinder {
		<0,-200, 0>
		<0,-3,0>
		2
	}
	sphere {
		<0,-100,0>
		4
	}
	cylinder {
		<0,-150,0>
		<0,-100,0>
		4
	}
	
	texture {lamppaint_h}
}
	union { 
		box {
		<2.5, -1, 2.5>
		<2.7, 15.1, -2.5>
		}
		box {
		<-2.5, -1, 2.5>
		<-2.7, 15.1, -2.5>
		}
		box {
		<2.5, -1, 2.5>
		<-2.5, 15.1, 2.7>
		}
		box {
		<2.5, -1, -2.5>
		<-2.5, 15.1, -2.7>
		}
		difference {
#declare GlassCase = sphere {
				<0,15.5,0>
				4.5
			}
			object {GlassCase}
			sphere {
				<0,15.5,0>
				4.3
			}
			box {
				<-10,15,-10>
				<10,-30,10>
			}
		}
		
#debug "One high quality lamp, coming up...\n"

#declare DropCount=0;

difference { union {

#while (DropCount<NumDrops)

#declare DropX=rand(DropPlacement)*9-4.5;
#declare DropZ=rand(DropPlacement)*9-4.5;

#declare DropletTraceStart=<0,30,0>+<DropX,0,DropZ>;
#declare CircleTest=<1,1,1>;
#declare DropletPosition=trace(GlassCase,DropletTraceStart, -y, CircleTest);

#if ((CircleTest.x=0)&(CircleTest.y=0)&(CircleTest.z=0))
#else

sphere {
	<0,0,0>
	#declare SizeOfDrop=Rand_Normal(.1,.02,DropSizeStream);
	SizeOfDrop
	texture {water_h}
	interior {#if (REFRACTION) ior 1.33 #end}
	translate DropletPosition + <0,-SizeOfDrop/8,0>
	no_shadow
}

#declare DropCount = DropCount + 1;

#end

#end
}
	object {
		GlassCase
	}

}

	texture {lampglass_h}
	      interior {
#if (REFRACTION) ior 1.45 #end
      }

	no_shadow
}       }