/**************************************************************
            ==================================
            Star Wars - The POV-Ray Collection
            ==================================

A-WING.INC - 3D model description file for use with the
Persistence of Vision Ray-Tracer, v3.0
* Converted to POV-Ray 3.1 by John Dickson

POV-Ray code copyright (c) 1998 Howard Day

This model is provided for personal use only. Any use of this
model for commercial gain or profit is strictly forbidden -
please see the accompanying README.TXT and Conditions of Use
before using or distributing this model.

'Star Wars' and all associated images, designs and trademarks,
(including the designs of the vehicles and objects depicted in
the Star Wars POV-Ray Collection, except where otherwise
stated) are copyright (c) 1997 Lucasfilm Ltd.

**************************************************************/


#declare SmoothScale = <1,.9875,1>;

#ifdef (SquadColour)
#else
#declare SquadColour = colour rgb <1,0,0>
#end
#declare SquadColour = SquadColour*.75;
#declare AW_SeatTex =
texture {
  pigment
  {
color rgb <.3,.2,.1>
  }
  finish {
    ambient 0.2
    diffuse 1
    phong 0
  }
}

#declare AW_HeadsUpTex  =
texture {
pigment {
image_map{
gif "cocctrls.gif"
interpolate 2
}
}
finish {
ambient 1
diffuse 0
}
scale < 8.25, 4, 1 >
rotate <0,0,0>
translate <-4.125,0,0>
}

#declare AW_WhiteGunTex =
texture {
  pigment
  {
color rgb .9
  }
  finish {
    ambient .1
    diffuse 1
    phong 0
  }
}

#declare AW_BlackConcussionMissleTubeTex =
texture {
  pigment
  {
color rgb 0
  }
  finish {
    ambient 0
    diffuse 0
    phong 0
  }
}



#declare AW_RedGunTex =
texture {
  pigment
  {
color rgb <.5,0,0>
  }
  finish {
    ambient .1
    diffuse 1
    phong 0
  }
}



#declare AW_EngineTex =
texture {
  pigment
  {  color rgb <1,1,1>*2
  }
  finish {
    ambient 1
      }

}


#declare AW_EngineFlareTex =
texture {
  pigment
  { gradient y
color_map {
[0 color rgbt <1,1,0,1>]
[1 color rgbt <1,1,0,1>]
}
  }
  finish {
    ambient 1
    diffuse 0
      }

}

#declare AWTailTex1 =
texture {
pigment {
image_map{
gif "awblue2.gif"
interpolate 2
}
}
finish {
ambient .1
diffuse 1
phong .25
phong_size 20
metallic
}
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.25,.25,.125>*5
}

#declare AW_SquadTex =
texture 
{
  pigment { SquadColour*.75 }
  finish 
  {
    ambient .1
    diffuse 1
    phong .25
    phong_size 20
    metallic
  }
}
texture 
{
  pigment 
  {
    bozo
    color_map 
    {
      [0 color rgbt <.25,.25,.25,.25>]
      [.5 color rgbt <.25,.25,.25,1>]
      [1 color rgbt <.25,.25,.25,1>]
    }
  }
  scale <.06125,.25,.25>*2
}

#declare AW_SquadTex2 =
texture {
pigment {
color (SquadColour*.75 + <.75,.75,.75>)*.5
}

finish {
ambient .1
diffuse 1
phong .25
phong_size 20
metallic
}
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.06125,.25,.25>*2
}

#declare AW_Tex2 =
texture {
    material_map {
      gif "AWTex2a.gif"
      interpolate 2
texture {
AWTailTex1
}
texture {
AW_SquadTex
}
texture {
AW_SquadTex2
}
}
scale <40,32.5,1>
rotate <0,-90,0>
translate <0,-14,26>
}

#declare AW_Tex3 =
texture {
  pigment
  {
color rgb .375
  }
  finish {
    ambient .1
    diffuse 1
    phong .125
  }
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.25,.25,.5>*3
}
#declare AW_Tex5 =
texture {
  pigment
  {
color rgb .25
  }
  finish {
    ambient 0.2
    diffuse 1
    phong .25
  }
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.25,.25,.5>*3
}
#declare AW_ScreenTex = texture {
        pigment {colour rgbt <0.25, 0.25, 0.36,.5>}
finish {diffuse .5 phong 1 phong_size 100 specular 0.7 roughness 0.01}
}
#declare AW_Tex6 =
texture {
  pigment
  {
color rgb .125
  }
  finish {
    ambient .1
    diffuse 1
    phong .5
  }
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.25,.25,.5>*3
}
#declare AWHeadTex1 =
texture {
pigment {
image_map{
gif "awbluetp.gif"
interpolate 2
}
}

finish {
ambient .1
diffuse 1
phong .25
phong_size 20
metallic
}
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.06125,.25,.25>*3
}


#declare AW_Tex1 =
texture {
    material_map {
      gif "AWTex1a.gif"
      interpolate 2
texture {
AWHeadTex1
}
texture {
AW_SquadTex
}
texture {
AW_SquadTex2
}
texture {
AWHeadTex1
}
}
scale <50,68,1>
rotate <90,0,0>
translate <-25,0,-22.5>
scale <1,1,1>
}

#declare AWHeadTex2 =
texture {
pigment {
image_map{
gif "awbluebt.gif"
interpolate 2
}
}
finish {
ambient .1
diffuse 1
phong .25
phong_size 20
metallic
}
}
texture {
pigment { bozo
color_map {
[0 color rgbt <.25,.25,.25,.25>]
[.5 color rgbt <.25,.25,.25,1>]
[1 color rgbt <.25,.25,.25,1>]
}
}
scale <.125,.25,.5>
}

#declare AW_Tex4 =
texture {

    material_map {
      gif "AWTex3a.gif"
      interpolate 2
texture {
AWHeadTex2
}
texture {
AW_SquadTex
}
texture {
AW_SquadTex2
}
texture {
AWHeadTex2
}
}
scale <50,68,1>
rotate <90,0,0>
translate <-25,0,-22.5>
scale <1,1,1>
}

#declare AWingMainBody =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 22, 0.625, 16 >
               translate < -11, 5.375, 29.5 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 21.992, 0.625, 16 >
               rotate < 0, 0, 180 >
               translate < 10.996, -5.375, 29.5 >

               texture
               {
                  AW_Tex4

               }
            }
         }
scale SmoothScale
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: BiCubic Bezier Patch
                  // Name: NoName
                  object
                  {
                     bicubic_patch
                     {
                        type 1
                        flatness 0.01
                        u_steps 4
                        v_steps 4
                        < 8.9, -0.25, -22.137 > < 8.9, 5.9605e-08, -22.137 > < 8.9, 5.9605e-08, -22.137 > < 8.9, 0.25, -22.137 >
                        < 8.9, -2.5, -2.1129 > < 12.05, -1.2, 3.7032 > < 12.05, 1.2, 3.7032 > < 8.9, 2.5, -2.1129 >
                        < 8.9, -6, 22.275 > < 27.8, -5, 12.843 > < 27.8, 5, 12.843 > < 8.9, 6, 22.275 >
                        < 8.9, -6, 22.275 > < 27.8, -5, 22.275 > < 27.8, 5, 22.275 > < 8.9, 6, 22.275 >
                     }
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 15.08, 7.225, 6 >
                           rotate < 90, 0, 0 >
                           translate < 8, 5.9605e-08, 22.275 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 3.5, 18, 8.075 >
                           rotate < 0, 0, 90 >
                           translate < 25.55, 5.9605e-08, 31.2 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 0.9, 17 >
                           rotate < 0, 0, -90 >
                           translate < 8.9, 5.9605e-08, 27.8 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 14.85, 13.175, 5.5 >
                           rotate < 90, 0, 0 >
                           translate < 8, 5.9605e-08, 22.7 >
                        }
                     }
scale SmoothScale
                  }
               }
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: BiCubic Bezier Patch
                  // Name: NoName
                  object
                  {
                     bicubic_patch
                     {
                        type 1
                        flatness 0.01
                        u_steps 4
                        v_steps 4
                        < -8.9, -0.25, -22.137 > < -8.9, -2.6724e-06, -22.137 > < -8.9, -2.6724e-06, -22.137 > < -8.9, 0.25, -22.137 >
                        < -8.9, -2.5, -2.1129 > < -12.05, -1.2, 3.7032 > < -12.05, 1.2, 3.7032 > < -8.9, 2.5, -2.1129 >
                        < -8.9, -6, 22.275 > < -27.8, -5, 12.843 > < -27.8, 5, 12.843 > < -8.9, 6, 22.275 >
                        < -8.9, -6, 22.275 > < -27.8, -5, 22.275 > < -27.8, 5, 22.275 > < -8.9, 6, 22.275 >
                     }
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < -15.08, -7.225, -6 >
                           rotate < -90, 0, 0 >
                           translate < -8, 5.9605e-08, 22.275 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < -3.5, -18, -8.075 >
                           rotate < -180, -4.1826e-06, -90 >
                           translate < -25.55, 2.8134e-06, 31.2 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < -20, -0.9, -17 >
                           rotate < -180, 4.1826e-06, 90 >
                           translate < -8.9, 2.4637e-06, 27.8 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < -14.85, -13.175, -5.5 >
                           rotate < -90, 0, 0 >
                           translate < -8, 1.9392e-06, 22.7 >
                        }
                     }
scale SmoothScale
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 17.787, 23, 44.5 >
                     translate < -8.8935, -11, -22.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 60.125, 0.998, 38.999 >
                     rotate < 172.56, 0, 0 >
                     translate < 0, 4.5, 11.225 >
scale SmoothScale
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < -60.125, -0.998, -40.176 >
                     rotate < -172.56, 0, 0 >
                     translate < 0, -4.5, 11.225 >

                     texture
                     {
                        AW_Tex4

                     }
scale SmoothScale
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.004, 5.981, 25.494 >
                     rotate < -9.593, 0, 180 >
                     translate < 1.002, 1, -25 >

                     texture
                     {
                        AW_Tex4

                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.004, 5.981, 25.317 >
                     rotate < -9.5931, 0, 0 >
                     translate < -1.002, -1, -25 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 4.25, 20, 16.5 >
                           translate < 0, -0.25, 21.85 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < -58.592, 0, 0 >
                           translate < 0, 4.75, 21.1 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < 29.334, 0, 0 >
                           translate < 0, 2, 8.35 >
                        }
                     }
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 17.75, 0.625, 7.225 >
               rotate < 0, 0, -180 >
               translate < 8.875, -5.375, 22.275 >

               texture
               {
                  AW_Tex4

               }
scale SmoothScale
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 17.75, 0.625, 7.225 >
               translate < -8.875, 5.375, 22.275 >
scale SmoothScale
            }
                  // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.5, 0.457, 3.74 >
                     rotate < -4.598, 0, 0 >
                     translate < 1.5, 2.25, -5.775 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < -90, 45, -180 >
                     translate < 2.5, 0, -2.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < -90, -45, 180 >
                     translate < 3.25, -1.0588e-22, -2.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 90, -45, 0 >
                     translate < 3.75, -6.6174e-23, -5.5 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 0.75, 3, 0.25 >
               translate < 3.75, 0, -3.75 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 0.75, 3, 0.25 >
               translate < 3.75, 0, -5 >
            }
         }
translate <0,-.25,0>
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < -2.5, -0.457, -3.74 >
                     rotate < 175.4, 0, 0 >
                     translate < -1.5, 2.25, -5.775 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < -20, -1, -20 >
                     rotate < 90, -45, -180 >
                     translate < -2.5, 1.967e-07, -2.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < -20, -1, -20 >
                     rotate < 90, 45, 180 >
                     translate < -3.25, 2.1856e-07, -2.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < -20, -1, -20 >
                     rotate < -90, 45, 4.9783e-06 >
                     translate < -3.75, 4.8083e-07, -5.5 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -0.75, -3, -0.25 >
               rotate < -180, 0, 0 >
               translate < -3.75, 3.2784e-07, -3.75 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -0.75, -3, -0.25 >
               rotate < -180, 0, 0 >
               translate < -3.75, 4.3711e-07, -5 >
            }
         }
translate <0,-.25,0>
      }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 1 }

                     scale < 0.14516, 0.499, 0.186 >
                     rotate < 79.634, 0, 0 >
                     translate < 0, 4.25, 14.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     translate < 0, 3.5, 14.25 >
                  }
               }

               texture
               {
                  AW_Tex6

               }
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 4.675, 5.9634, 18.458 >
                           // --- Shear YZ --- (not correct)
                           rotate < -22.5, 0, 0 >
                           scale < 1, 0.999128, 1 >
                           rotate < 22.6203, 0, 0 >
                           // ----------------
                           rotate < -7.3016, 0, 0 >
                           translate < 0, 5, 21 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 17, 1, 17 >
                           rotate < -90, 0, 0 >
                           translate < 0, 5, 21 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 17, 0.85, 20 >
                           translate < 0, 2.875, 15 >
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Sphere
                              // Name: NoName
                              object
                              {
                                 sphere { < 0, 0, 0 >, 1 }

                                 scale < 4.5375, 5.9634, 18.458 >
                                 // --- Shear YZ --- (not correct)
                                 rotate < -22.5, 0, 0 >
                                 scale < 1, 0.999128, 1 >
                                 rotate < 22.6203, 0, 0 >
                                 // ----------------
                                 rotate < -7.3016, 0, 0 >
                                 translate < 0, 4.75, 21.25 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 16.5, 1, 17 >
                                 rotate < -90, 0, 0 >
                                 translate < 0, 4.75, 21.25 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 16.5, 0.85, 20 >
                                 translate < 0, 2.625, 15.25 >
                              }
                           }

                           texture
                           {
                              AW_ScreenTex
                              scale < 0.825, 0.85, 1 >
                              translate < 0, 4.75, 21.25 >
                           }
                        }
                     }

                     texture
                     {
                        AW_ScreenTex
                        scale < 0.85, 0.85, 1 >
                        translate < 0, 5, 21 >
                     }
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cone
                        // Name: NoName
                        object
                        {
                           cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

                           scale < 4.675, 23, 5.95 >
                           rotate < 90, 0, 0 >
                           translate < 0, 5, 21 >
                        }
                        // Object type: Cone
                        // Name: NoName
                        object
                        {
                           cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                           scale < 4.25, 30, 5.95 >
                           rotate < 90, 0, 0 >
                           translate < 0, 4.575, 21.5 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 17, 0.85, 20 >
                           translate < 0, 4.575, 35 >
                        }
                     }
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 5.6375, 6.1383, 18.921 >
                     // --- Shear YZ --- (not correct)
                     rotate < -22.5, 0, 0 >
                     scale < 1, 0.999174, 1 >
                     rotate < 22.614, 0, 0 >
                     // ----------------
                     rotate < -7.2706, 0, 0 >
                     translate < 0, 5, 21 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.5, 1.025, 17.5 >
                     rotate < -120.59, 0, 0 >
                     translate < 0, 5, 5.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.5, 0.875, 20.5 >
                     translate < 0, 2.8125, 14.85 >
                  }
// Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 5.6375, 6.1383, 18.921 >
                     // --- Shear YZ --- (not correct)
                     rotate < -22.5, 0, 0 >
                     scale < 1, 0.999174, 1 >
                     rotate < 22.614, 0, 0 >
                     // ----------------
                     rotate < -7.2706, 0, 0 >
                     translate < 0, 5, 21 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.5, 1.025, 17.5 >
                     rotate < -120.59, 0, 0 >
                     translate < 0, 5, 5.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.5, 0.875, 20.5 >
                     translate < 0, 2.8125, 14.85 >
                  }
               }
scale <.9,.75,.75,>
//translate <0,-.25,.25>
            }

               }

               texture
               {
                  AW_Tex6

               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 1, 2, 11 >
                     translate < 0, 10, 27 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 90, 0, 0 >
                     translate < 0, 10, 27 >
                  }
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 1, 2, 2 >
               translate < 0, 10, 27 >
            }
         }
scale <1,1,1>
      }
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.5, 1, 1.75 >
                     translate < 1, 3.75, 9.25 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 1, 3, 7 >
                           translate < -0.5, -0.5, 8 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < -118.96, 0, 0 >
                           translate < 0, 2, 13.25 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.5, 1, 1.75 >
                     translate < -1.5, 3.75, 9.25 >
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.5, 1, 1.75 >
                     translate < 0.25, 3.75, 9.25 >
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.5, 1, 1.75 >
                     translate < -0.75, 3.75, 9.25 >
                  }
               }

               texture
               {
                  AW_Tex3
                  translate < 0, 2, 14 >
               }
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.84281, 4, 1.5238 >
                     rotate < 90, 0, 90 >
                     translate < -2.2857, -6.143e-15, 19 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.84281, 4.7619, 4 >
                     rotate < -180, 0, 90 >
                     translate < -2.2857, -9.5115e-15, 19 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.84281, 4, 1.5238 >
                     rotate < 90, 0, 90 >
                     translate < 2.4762, 4.7679e-15, 19 >
                  }
               }

               texture
               {
                  AW_SeatTex
                  scale < 0.042141, 0.28571, 0.19048 >
                  rotate < 90, 0, 90 >
                  translate < -2.9274e-22, -1.4596e-23, 19 >
               }
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.6, 2.002, 1.1429 >
                     rotate < 90, 62.768, 90 >
                     translate < -1.7143, 2.75, 19.5 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.6, 3.5714, 2.002 >
                     rotate < -180, 62.768, 90 >
                     translate < -1.7143, 2.75, 19.5 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.6, 2.002, 1.1429 >
                     rotate < 90, 62.768, 90 >
                     translate < 1.8571, 2.75, 19.5 >
                  }
               }

               texture
               {
                  AW_SeatTex
                  scale < 0.03, 0.143, 0.14286 >
                  rotate < 90, 62.768, 90 >
                  translate < -3.6134e-22, 2.75, 19.5 >
               }
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.6, 1.4, 0.8 >
                     rotate < 90, 89.333, 90 >
                     translate < -1.2, 6, 20.75 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.6, 2.5, 1.4 >
                     rotate < -180, 89.333, 90 >
                     translate < -1.2, 6, 20.75 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 0.6, 1.4, 0.8 >
                     rotate < 90, 89.333, 90 >
                     translate < 1.3, 6, 20.75 >
                  }
               }

               texture
               {
                  AW_SeatTex
                  scale < 0.03, 0.1, 0.1 >
                  rotate < 90, 89.333, 90 >
                  translate < 2.1811e-22, 6, 20.75 >
               }
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 8.54, 4.2, 9.884 >
               rotate < -11.31, 0, 0 >
               translate < -4.27, -0.65, 4.95 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 8.4, 4.2, 1.05 >
               translate < -4.2, 1.1, 13.7 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 8.25, 4, 1.5 >
               translate < -4.125, 1.25, 13.625 >

               texture
               {
                  AW_HeadsUpTex
                  translate < 0, 1.25, 0 >
                  scale <-1,1,1>
               }
            }
            texture {AW_Tex3}
translate <0,0,0>
         }
      }

#declare XW_Suit = texture {
  pigment {colour rgb <1,0.45,0>}
  normal {bumps 0.3 scale <0.02, 0.1, 0.02>}
}

//#declare XW_Pilot =
object {
  union {
    object {
      difference {
        object {
          union {
            object {sphere {<0,1.05,0>, 0.25}}
            object {cylinder {<-0.05, 1.05, 0>, <0.05, 1.05, 0>, 0.265}}
            object {cylinder {<-0.01, 1.05, 0>, <0.01, 1.05, 0>, 0.2651} pigment {colour rgb <1,0,0>}}
          }
        }
        object {plane {<0,1.05,0.2>, 0} translate <0,0.9,0>}
        object {cylinder {<-1,0,0.3>, <1,0,0.3>, 0.25} scale <1,0.4,1> translate <0,1.05,0>}
      }
      pigment {colour rgb 1}
    }
    object {
      sphere {<0,1.05,0>, 0.23}
      texture {
        pigment {colour rgb 0.15}
        finish {specular 0.7 roughness 0.01 reflection 0.5}
      }
    }
    object {cylinder {<0,0.7,0.2>, <0,0.2,0.15>, 0.01} texture {pigment {colour rgb 0.15}}}
    object {
      intersection {
        object {torus {0.2, 0.01} rotate <0,0,90> translate <0,0.7,0>}
        object {box {<-1, 0.7, 0>, <1, 0.9, 1>}}
      }
      texture {pigment {colour rgb 0.15}}
    }
    object {
      union {
        object {sphere {<0,0,0>, 0.2} scale <2,1,1> translate <0,0.7,0>}
        object {cone {<0,0.2,0>, 0.15, <0,0.7,0>, 0.2} scale <1.5, 1, 1>}
        object {sphere {<0,0.2,0>, 0.15} scale <1.5, 1, 1>}
      }
      texture {XW_Suit}
    }
    #declare XW_PilotHalf = object {
      union {
        object {cone {<-0.3, 0.7, 0>, 0.1, <-0.45, 0.4, 0.25>, 0.08}}
        object {sphere {<-0.45, 0.4, 0.25>, 0.08}}
        object {cone {<-0.45, 0.4, 0.25>, 0.08, <-0.3, 0.4, 0.6>, 0.06}}
        object {cone {<-0.17, 0.15, 0>, 0.15, <-0.25, 0.05, 0.5>, 0.12}}
        object {sphere {<-0.25, 0.05, 0.5>, 0.12}}
        object {cone {<-0.25, 0.05, 0.5>, 0.12, <-0.25, -0.05, 1>, 0.08}}
        object {sphere {<-0.3, 0.4, 0.6>, 0.06} texture {pigment {colour rgb 1}}}
        object {sphere {<-0.27, 0.4, 0.63>, 0.06} texture {pigment {colour rgb 0}}}
      }
      texture {XW_Suit}
    }
    object {XW_PilotHalf scale <1,1,1>}
    object {XW_PilotHalf scale <-1,1,1>}
  }
rotate 180*y
scale 6
translate <0,0,19>
}
object {
light_source
{
   < 0, 4, 14>
   color rgb < 0, .5, 1 >
   fade_distance 7*.1
   fade_power 2
}
}
}
}



      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 11.038, 0.75 >
               rotate < 90, 0, 0 >
               translate < 26, 0, 20.108 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.5, 1.4717, 0.5 >
               rotate < 90, 0, 0 >
               translate < 26, 0, 30.41 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 0.36792, 0.75 >
               rotate < 90, 0, 0 >
               translate < 26, 0, 31.882 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.5, 6.6226, 0.5 >
               rotate < 90, 0, 0 >
               translate < 26, 3.5744e-22, 14.222 >
              texture {AW_WhiteGunTex}
            }
difference {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 1.4717, 0.75 >
               rotate < 90, 0, 0 >
               translate < 26, 0, 12.75 >
           texture {AW_RedGunTex}
            }
                        // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.7, 1.4717, 0.7 >
               rotate < 90, 0, 0 >
               translate < 26, 0, 12 >
           texture {AW_Tex6}
            }
            }

            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.25, 9.1981, 0.25 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 20.292 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.2, 2.0236, 0.2 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 29.675 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.1, 3.6792, 0.1 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 27.835 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.4, 0.18396, 0.4 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 30.042 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.15, 2.9434, 0.15 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 17.533 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.4, 0.18396, 0.4 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 30.962 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.25, 0.73585, 0.25 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 16.797 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.013, 0.009566, 0.013 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 21.948 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.013, 0.009566, 0.013 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 22.132 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.013, 0.009566, 0.013 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 22.316 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.013, 0.009566, 0.013 >
               rotate < 90, 0, 0 >
               translate < 26, 1.25, 22.5 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 8.25, 9, 7.25 >
               translate < 7, -4.5, 21 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.5, 26, 0.5 >
               rotate < 90, 90, 0 >
               translate < 5.294e-23, 0, 26 >
            }
         }

         texture
         {
            AW_Tex3
            scale < 1, 1, 0.73585 >
            translate < 26, 0.5, 22.5 >
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.75, -11.038, -0.75 >
               rotate < -90, 0, 0 >
               translate < -26, 0, 20.108 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.5, -1.4717, -0.5 >
               rotate < -90, 0, 0 >
               translate < -26, 0, 30.41 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.75, -0.36792, -0.75 >
               rotate < -90, 0, 0 >
               translate < -26, 0, 31.882 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.5, -6.6226, -0.5 >
               rotate < -90, 0, 0 >
               translate < -26, 3.5744e-22, 14.222 >
            texture {AW_WhiteGunTex}
            }
difference {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.75, -1.4717, -0.75 >
               rotate < -90, 0, 0 >
               translate < -26, 0, 12.75 >
           texture {AW_RedGunTex}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.7, -1.4717, -0.7 >
               rotate < -90, 0, 0 >
               translate < -26, 0, 12 >
           texture {AW_Tex6}
            }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.25, -9.1981, -0.25 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 20.292 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.2, -2.0236, -0.2 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 29.675 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.1, -3.6792, -0.1 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 27.835 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.4, -0.18396, -0.4 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 30.042 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.15, -2.9434, -0.15 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 17.533 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.4, -0.18396, -0.4 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 30.962 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.25, -0.73585, -0.25 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 16.797 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < -0.013, -0.009566, -0.013 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 21.948 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < -0.013, -0.009566, -0.013 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 22.132 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < -0.013, -0.009566, -0.013 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 22.316 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < -0.013, -0.009566, -0.013 >
               rotate < -90, 0, 0 >
               translate < -26, 1.25, 22.5 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -8.25, -9, -7.25 >
               rotate < 180, 0, 0 >
               translate < -7, -4.5, 21 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < -0.5, -26, -0.5 >
               rotate < -90, -90, 0 >
               translate < -5.294e-23, 0, 26 >
            }
         }

         texture
         {
            AW_Tex3
            scale < -1, -1, -0.73585 >
            rotate < 180, 0, 0 >
            translate < -26, 0.5, 22.5 >
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.375, 4.25, 5 >
                     translate < -0.1875, 6, 40.5 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 15, 20, 20 >
                           translate < -7.5, 6.75, 42.25 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 15, 1, 20 >
                           rotate < 45, 0, 0 >
                           translate < 0, 8.25, 43.75 >
                        }
                     }
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.05, 0.5, 0.05 >
               rotate < 90, 0, 0 >
               translate < 0, 8.5, 38 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.375, 4.25, 5 >
                     translate < -1.1875, 6, 40.5 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 15, 20, 20 >
                           translate < -8.5, 6.75, 42.25 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 15, 1, 20 >
                           rotate < 45, 0, 0 >
                           translate < -1, 8.25, 43.75 >
                        }
                     }
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.375, 4.25, 5 >
                     translate < 0.8125, 6, 40.5 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 15, 20, 20 >
                           translate < -6.5, 6.75, 42.25 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 15, 1, 20 >
                           rotate < 45, 0, 0 >
                           translate < 1, 8.25, 43.75 >
                        }
                     }
                  }
               }
            }
         }
texture {AW_Tex6}
      }



// Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Cylinder
                              // Name: NoName
                              object
                              {
                                 cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                                 scale < 5.25, 14, 1.5 >
                                 rotate < 90, 0, 0 >
                                 translate < 0, 1.5, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < -180, 0, 0 >
                                 translate < 0, 1.5, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Torus
                              // Name: NoName
                              object
                              {
                                 torus { 30, 10 }

                                 scale < 0.17813, 1.4, 0.1 >
                                 rotate < 90, 0, 0 >
                                 translate < 0, 1.5, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 translate < 0, 1.5, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Torus
                              // Name: NoName
                              object
                              {
                                 torus { 30, 10 }

                                 scale < 0.17813, 1.4, 0.05 >
                                 rotate < 90, 0, 0 >
                                 translate < 0, 1.5, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < -180, 0, 0 >
                                 translate < 0.375, 1.5, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Cylinder
                              // Name: NoName
                              object
                              {
                                 cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                                 scale < 5.25, 14, 3 >
                                 rotate < 90, 0, 0 >
                                 translate < 0, 1.5, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 translate < 0, 1.5, 38.457 >
                              }
                           }
                        }
                     }
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 12, 1.6, 16 >
                     rotate < 90, 0, 0 >
                     translate < 0, 2, 39.457 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 10.435, 0.907, 11.027 >
                     rotate < -116.7, 0, 0 >
                     translate < 0, 2.9998, 49.457 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.087, 20, 2 >
                     rotate < 90, 0, 0 >
                     translate < 2.6087, 2.5, 38.457 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.087, 20, 2 >
                     rotate < 90, 0, 0 >
                     translate < -2.6087, 2.5, 38.457 >
                  }
               }

               texture
               {
                  AW_Tex3
                  scale < 0.375, 0.5, 1 >
                  translate < 0, 2, 38.457 >
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Cylinder
                              // Name: NoName
                              object
                              {
                                 cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                                 scale < 5.25, 14, 1.5 >
                                 rotate < 90, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < -180, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Torus
                              // Name: NoName
                              object
                              {
                                 torus { 30, 10 }

                                 scale < 0.17813, 1.4, 0.1 >
                                 rotate < 90, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < 0, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Torus
                              // Name: NoName
                              object
                              {
                                 torus { 30, 10 }

                                 scale < 0.17813, 1.4, 0.05 >
                                 rotate < 90, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < -180, 0, 180 >
                                 translate < -0.375, -2, 38.457 >
                              }
                           }
                        }
                        // Object type: Difference
                        // Name: 'and not'
                        object
                        {
                           difference
                           {
                              // Object type: Cylinder
                              // Name: NoName
                              object
                              {
                                 cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                                 scale < 5.25, 14, 3 >
                                 rotate < 90, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                              // Object type: Disc
                              // Name: NoName
                              object
                              {
                                 disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                                 scale < 7.5, 0.5, 20 >
                                 rotate < 0, 0, 180 >
                                 translate < 4.3711e-08, -2, 38.457 >
                              }
                           }
                        }
                     }
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 12, 1.6, 16 >
                     rotate < 90, 0, 180 >
                     translate < 0, -2.5, 39.457 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 10.435, 0.907, 11.027 >
                     rotate < -116.7, 0, 180 >
                     translate < -8.7403e-08, -3.4998, 49.457 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.087, 20, 2 >
                     rotate < 90, 0, 180 >
                     translate < -2.6087, -3, 38.457 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.087, 20, 2 >
                     rotate < 90, 0, 180 >
                     translate < 2.6087, -3, 38.457 >
                  }
               }

               texture
               {
                  AW_Tex3
                  scale < 0.375, 0.5, 1 >
                  rotate < 0, 0, 180 >
                  translate < 0, -2.5, 38.457 >
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 18, 11, 12 >
               translate < -9, -5.5, 28.5 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 18, 1, 16.5 >
               translate < -9, 4.5, 28.5 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 18, 1, 16.5 >
               translate < -9, -5.5, 28.5 >
            }
         }

         texture
         {
            AW_Tex5
            translate < 0, -0.5, 38.5 >
         }
      }
union {
       // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 8.25, 1.5, 40 >
                     translate < 10.75, -0.75, -20 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.25, 40, 0.75 >
                     rotate < 90, 0, 0 >
                     translate < 10.75, 3.7341e-22, -20 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.5, 40, 0.75 >
                     rotate < 90, 0, 0 >
                     translate < 19, 1.5028e-22, -20 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 9.5942, 20, 33.365 >
               rotate < 0, 18.994, 0 >
               translate < 22.5, -10, -5.5 >
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 8.25, 1.5, 40 >
                     rotate < 0, 0, -180 >
                     translate < -10.75, 0.75, -20 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.25, 40, 0.75 >
                     rotate < 90, 0, -180 >
                     translate < -10.75, -9.3979e-07, -20 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 0.5, 40, 0.75 >
                     rotate < 90, 0, -180 >
                     translate < -19, -1.661e-06, -20 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 9.5942, 20, 33.365 >
               rotate < 1.2074e-06, 18.994, -180 >
               translate < -22.5, 10, -5.5 >
            }
         }
      }
texture {AW_BlackConcussionMissleTubeTex}
}




#declare EngineBurn =
//union
//{
  union
  {
// Secondary AW_Engine Glow
    object 
    {
      sphere {<0,0,0>, 0.65}
      texture 
      {
        pigment {colour rgbt <1,1,1,1>}
      }
      interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }

        //  spherical_mapping     ZEJ
        //  linear
        //  color_map 
        //  {
        //              [0 colour rgbt <1,1,0,1>]
        //              [1 colour rgbt <1,1,0,.25>]
        //  }
          samples 10,10
        }
      }
      hollow
      no_shadow
      scale <4.5,4.5,7.5>
      translate <0,0,0>
    }
    // Secondary AW_Engine Glow
    object {
      sphere {<0,0,0>, 0.65}
      texture {
        pigment {colour rgbt <1,1,1,1>}
      }
      interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }
        //  spherical_mapping     ZEJ
        //  linear       
        //  color_map 
        //  {
        //              [0 colour rgbt <1,1,0,1>]
        //              [1 colour rgbt <1,1,0,.25>]
        //  }
          samples 10,10
        }
      }
      hollow
      no_shadow
      scale <3.5,3.5,14>*2
      translate <0,0,10>
    }
    // Secondary AW_Engine Glow
    object {
      sphere {<0,0,0>, 0.65}
      texture {
        pigment {colour rgbt <1,1,1,1>}
      }
      interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }
        //  spherical_mapping     ZEJ
        //  linear
        //  color_map 
        //  {
        //              [0 colour rgbt <1,1,0,1>]
        //              [1 colour rgbt <1,1,0,.25>]
        //  }
          samples 10,10
        }
      }
      hollow
      no_shadow
      scale <6,6,7>*2
      translate <0,0,7.5>
    }
    // Inner engine glow
    object {
      sphere {<0,0,0>, 1}
      texture 
      {
        pigment {color rgbt <1,1,1,1>}
      }
      interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }
        //  spherical_mapping     ZEJ
        //  linear
        //  color_map 
        //  {
        //              [0 colour rgbt <1,1,0,1>]
        //              [1 colour rgbt <1,1,0,.25>]
        //  }
          samples 10,10
        }
      }
      scale <5,5,2.5>
      hollow
      no_shadow
      translate <0,0,0>
    }
//  }

  scale 1
  translate <0,0,0>
}


#include "awing2.inc"
object
{
  AWingEngine
  translate <-12.5,0,-7>
}
object
{
  AWingEngine
  translate <-12.5,0,-7> rotate 180*x scale -1
}
   }
   texture
   {
      AW_Tex1
   }
}
#declare LandingGear =
union {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 0.25, 11.469, 0.25 >
               rotate < 34.992, 0, 11.31 >
               translate < 10.363, -9.3155, 4 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 0.5, 9.5, 0.5 >
               rotate < 8.4913, 0, 11.31 >
               translate < 10.363, -9.3155, 3 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 1, 1, 2.25 >
               rotate < 0, 0, 11.31 >
               translate < 9.9218, -9.6587, 2.25 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 0.25, 2.7475, 0.25 >
               rotate < -59.297, 0, 11.31 >
               translate < 9.7257, -6.1286, 6.25 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 3.75, 0.5, 6 >
               translate < 8.5, -9.75, 4.7684e-07 >
texture {AW_Tex6}
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.25, -11.469, -0.25 >
               rotate < -145.01, 0, -11.31 >
               translate < -10.863, -9.3155, 4 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.5, -9.5, -0.5 >
               rotate < -171.51, 0, -11.31 >
               translate < -10.863, -9.3155, 3 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -1, -1, -2.25 >
               rotate < -180, 0, -11.31 >
               translate < -10.422, -9.6587, 2.25 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.25, -2.7475, -0.25 >
               rotate < 120.7, 0, -11.31 >
               translate < -10.226, -6.1286, 6.25 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -3.75, -0.5, -6 >
               rotate < -180, 0, -6.8302e-05 >
               translate < -9, -9.75, -3.5898e-07 >
texture {AW_Tex6}
           }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.25, -11.469, -0.25 >
               rotate < 34.992, 0, 180 >
               translate < -1.7764e-15, -9.5, 41 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.5, -9.5, -0.5 >
               rotate < 8.4913, 0, 180 >
               translate < -1.7764e-15, -9.5, 42 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -1, -1, -2.25 >
               rotate < 4.9783e-06, 0, 180 >
               translate < -0.5, -9.75, 42.75 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < -0.25, -2.7475, -0.25 >
               rotate < -59.297, 0, 180 >
               translate < -1.7764e-15, -6.25, 38.75 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < -3.75, -0.5, -6 >
               rotate < 1.5032e-05, 0, 180 >
               translate < -1.75, -9.75, 45 >
texture {AW_Tex6}
            }
         }
      }
texture {AW_Tex3}
      }

#declare AWing =
union {
object {AWingMainBody}
object {EngineBurn translate <-12.5,0,44>}
object {EngineBurn translate <12.5,0,44>}
object {
light_source
{
   < 12.5, 0, 45>
   color rgb < 1, .9, 0.5 >
   fade_distance 2.5
   fade_power 2
}
}
object {
light_source
{
   < -12.5, 0, 45>
   color rgb < 1, .9, 0.5 >
   fade_distance 2.5
   fade_power 2
}
}
translate <0,0,-27.5>
scale .1
scale .875
}


#declare AWingL =
union {
object {AWingMainBody}
object {LandingGear}
translate <0,9.75,-27.5>
scale .1

}

