// ****************************************** TREES *******************************************

#declare foregroundtreex=.657;
#declare foregroundtreez=.450;
#declare foretreepos=trace(ground_h, <foregroundtreex*(hfx2_h-hfx1_h)+hfx1_h,hfy2_h,foregroundtreez*(hfz2_h-hfz1_h)+hfz1_h>, <0,-1,0>)+<0,0,0>;

//FROM INCLUDE FILE
//-----------------------------------------
// Automn leaf (bad...)
//-----------------------------------------
//#declare colLeaf_1=rgb <0.7,1,0.2>*0.8; // greenish 
//#declare colLeaf_2=rgb <1,0.7,0.2>*0.8; // yellow
//#declare colLeaf_3=rgb <1,0.2,0.1>*0.8; // red
//#declare SortOfReddish=rgb <1,0.4,0.15>*0.8; // redish
#declare colLeaf_1=rgb <0.7,1,0.2>*0.4; // greenish 
#declare colLeaf_2=rgb <1,0.7,0.2>*0.4; // yellow
#declare colLeaf_3=rgb <1,0.2,0.1>*0.4; // red
#declare SortOfReddish=rgb <1,0.4,0.15>*0.4; // redish
#declare txtLeaf_5=texture{
	pigment{
		agate
		color_map{
			[0.0 color SortOfReddish]
			[0.3 color colLeaf_2]
			[0.7 color colLeaf_2]
			[1.0 color SortOfReddish]
		}
	}
        finish{
        	//ambient 0.1
        	diffuse .7
        	specular 0.3 roughness 0.01
        }
        normal {
        	bumps
        	scale .01
        }
        scale 1//0
}
#declare FallenLeafTexture=texture{
	pigment{
		agate
		turbulence .1
		color_map{
			[0.0 color SortOfReddish]
			[0.3 color colLeaf_2]
			[0.44 color colLeaf_2]
			[0.45 colour rgbf 1]
			[0.55 colour rgbf 1]
			[0.56 color colLeaf_2]
//			[0.7 color colLeaf_2]
			[0.84 color colLeaf_2]
			[0.85 color rgbf 1]
			[0.95 color rgbf 1]
			[0.96 color SortOfReddish]
//			[1.0 color SortOfReddish]
		}
	}
        finish{
        	//ambient 0.1
        	diffuse .4
        	specular 0.05 roughness 0.1
        }
        normal {
        	bumps
        	scale .1
        }
        scale 1//0
}

#declare Leaf= object {
	#include "gtleaf7.inc"
        texture {txtLeaf_5} // apply tree texture  regardless of the tree structure
}
#declare FallenLeaf= object {
	#include "gtleaf7.inc"
        texture {FallenLeafTexture} // apply tree texture  regardless of the tree structure
}

#if (TREES)

#declare foregroundtree1= union {
	object {
		#include "gttree7.inc"
	        texture {txtTree_3}
	}
	object {
		#include "gtfoliage7.inc"
	}
}



#declare Leaf= object {
	#include "level6-leaf.inc"
        texture {txtLeaf_5} // apply tree texture  regardless of the tree structure
 }
#declare Fallen2=object {Leaf}

#declare originaltree1= union {
	object {
		#include "level6-tree.inc"
	        texture {txtTree_3}
	}
	object {
		#include "level6-foliage.inc"
	}
}

#declare colLeaf_1=rgb <1.0,0.9,0.0>*0.4; // greenish 
#declare colLeaf_2=rgb <1.0,0.7,0.2>*0.4; // yellow

#declare txtLeaf_5=texture{
	pigment{
		agate
		color_map{
			[0.0 color colLeaf_1]
			[0.3 color colLeaf_2]
			[0.7 color colLeaf_2]
			[1.0 color colLeaf_1]
		}
	}
        finish{
        	//ambient 0.1
        	diffuse .6
        	specular 0.2 roughness 0.01
        }
        normal {
        	bumps
        	scale .02
        }
        scale 1//0
}

#declare Leaf= object {
	#include "tree3leaf.inc"
        texture {txtLeaf_5} // apply tree texture  regardless of the tree structure
 }

#declare originaltree2= union {
	object {
		#include "tree3tree.inc"
	        texture {txtTree_3}
	}
	object {
		#include "tree3foliage.inc"
	}
}


object {
#if (QUICKTREES)
		sphere {
			<0,0,0>
			5
		}
#else
		object {
			foregroundtree1
		}
#end
	#debug concat("Tree is at <",str(foretreepos.x,3,3),",",str(foretreepos.y,3,3),",",str(foretreepos.z,3,3),">\n")
	scale 6
	translate foretreepos + <0,0,0>
        texture {txtTree_3}
}


#declare treesinforest=4;

//#declare TreeRotate=seed(26783);
#declare TreeRotate=seed(23114);

#declare foresttreesx=array[treesinforest]
#declare foresttreesz=array[treesinforest]
#declare treescale=array[treesinforest]
#declare treerotate=array[treesinforest]

#declare foresttreesx[0]=-700;
//#declare foresttreesz[0]=100;
#declare foresttreesz[0]=0;
#declare treescale[0]=.8;
#declare treerotate[0]=137;

#declare foresttreesx[1]=-700;
#declare foresttreesz[1]=-600;
#declare treescale[1]=.65;
#declare treerotate[1]=0;

#declare foresttreesx[2]=-1000;	
#declare foresttreesz[2]=-500;
#declare treescale[2]=.65;
#declare treerotate[2]=137;

#declare foresttreesx[3]=-740;
#declare foresttreesz[3]=-250;
#declare treescale[3]=.55;
#declare treerotate[3]=237;


#declare counttrees=0;

#while (counttrees<treesinforest)

object {
#if (QUICKTREES)
	sphere {
		<0,0,0>
		5
	}
#else
#switch (counttrees)
#case (0)
object {
		originaltree1
	}
#break
#case (1)
object {
		originaltree1
	}
#break
#case (2)
object {
		originaltree2
	}
#break
#case (3)
object {
		originaltree2
	}
#end
#end

#if ((foresttreesx[counttrees]>-750)&(foresttreesz[counttrees]>-750))
	#declare DiscPos=trace(discbelow, <foresttreesx[counttrees],1000,foresttreesz[counttrees]>, <0,-1,0>)+<0,0,0>;
	#declare treepos=trace(ground_h, <foresttreesx[counttrees],1000,foresttreesz[counttrees]>, <0,-1,0>)+<0,0,0>;
		#if (DiscPos.y>treepos.y)
		#declare treepos=DiscPos;
		#debug "(next one on disc)\n"
		#end
#else
	#declare DiscPos=trace(discbelow, <foresttreesx[counttrees],1000,foresttreesz[counttrees]>, <0,-1,0>)+<0,0,0>;
	#declare treepos=trace(hillbehind, <foresttreesx[counttrees],1000,foresttreesz[counttrees]>, <0,-1,0>)+<0,0,0>;
		#if (DiscPos.y>treepos.y)
		#declare treepos=DiscPos;
		#debug "(next one on disc)\n"
		#end
#end
	#debug concat("Tree is at <",str(treepos.x,3,3),",",str(treepos.y,3,3),",",str(treepos.z,3,3),">\n")
	rotate y*treerotate[counttrees]
	scale 6*treescale[counttrees]
	translate treepos
}

#declare counttrees=counttrees+1;
#end

#declare QUICKTREES=0;

#if (QUICKTREES) 
object {
	sphere {
		<0,0,0>
		10
	}
#else
object {
	originaltree1
#end
//	rotate y*145
	scale 4.6
//	translate <-2300,0,-2350>
//	translate <-2250,0,-2420>
	translate <-2430,0,-2700>
}

#end //TREES

#declare QUICKTREES=0; // Draw trees on small world

// ************LEAVES************
#if (FALLENLEAVES)

#declare LeafCount=0;
#declare NumLeaves=60;

#declare LeafFallRadius=200;

#declare LeafSizeStream=seed(6783);

#declare LeafRotateStream=seed(124);
//#declare LeafRotateStream=seed(125);

//#declare LeafPlacement=seed(101);
//#declare LeafPlacement=seed(1812);
//#declare LeafPlacement=seed(1571);
#declare LeafPlacement=seed(15715);


union {

#while (LeafCount<NumLeaves)

#declare LeafX=(Rand_Normal(0,LeafFallRadius,LeafPlacement));
#declare LeafZ=(Rand_Normal(0,LeafFallRadius,LeafPlacement));
#declare SizeOfLeaf=Rand_Normal(1,.2,LeafSizeStream);

#declare LeafTraceStart=foretreepos+<LeafX,1000,LeafZ>;
#declare LeafPosition=trace(ground_h,LeafTraceStart, -y);

/*sphere {
	<0,0,0>
	5
	texture {pigment {colour Red}}
	translate LeafPosition //+ <0,-SizeOfDrop/8,0>
}*/
object {
	FallenLeaf
	scale 7*SizeOfLeaf
	rotate y*(rand(LeafRotateStream)*360)+y*40
	translate LeafPosition + y*8//+ <0,-SizeOfDrop/8,0>
}

	

#declare LeafCount = LeafCount + 1;

#end 
}

// *** SECOND LOT OF LEAVES (FOREST) ***

#declare LeafCount=0;
#declare NumLeaves=500;
#declare LeafFallRadius=300;

//#declare LeafSizeStream=seed(6783);

//#declare LeafRotateStream=seed(124);
//#declare LeafRotateStream=seed(125);

//#declare LeafPlacement=seed(101);
//#declare LeafPlacement=seed(1812);
//#declare LeafPlacement=seed(1571);
//#declare LeafPlacement=seed(15715);

#if (TREES)
#declare LeafCentre=<foresttreesx[3],0,foresttreesz[3]>;
#else
#declare LeafCentre=<-740,0,-250>;
#end


union {

#while (LeafCount<NumLeaves)

#declare LeafX=(Rand_Normal(0,LeafFallRadius,LeafPlacement));
#declare LeafZ=(Rand_Normal(0,LeafFallRadius,LeafPlacement));
#declare SizeOfLeaf=Rand_Normal(1,.2,LeafSizeStream);

#declare LeafTraceStart=LeafCentre+<LeafX,1000,LeafZ>;

#if ((LeafTraceStart.x<-750)|(LeafTraceStart.z<-750))
#declare LeafPosition=trace(hillbehind,LeafTraceStart, -y);
#declare DiscPos=trace(discbelow,LeafTraceStart, -y);
#if (DiscPos.y>LeafPosition.y)
#declare LeafPosition=DiscPos;
//#debug "(next one on disc)\n"
#end
//#debug "Put it on hill behind\n"
#else
#declare DiscPos=trace(discbelow,LeafTraceStart, -y);
#declare LeafPosition=trace(ground_h,LeafTraceStart, -y);
#if (DiscPos.y>LeafPosition.y)
#declare LeafPosition=DiscPos;
//#debug "(next one on disc)\n"
#end
//#debug "Put it on main hill\n"
#end

/*sphere {
	<0,0,0>
	5
	texture {pigment {colour Red}}
	translate LeafPosition //+ <0,-SizeOfDrop/8,0>
}*/
object {
	FallenLeaf
	scale 7*SizeOfLeaf
	rotate y*(rand(LeafRotateStream)*360)+y*40
	translate LeafPosition + y*8//+ <0,-SizeOfDrop/8,0>
}

	

#declare LeafCount = LeafCount + 1;

#end 
}


// ******END LEAVES********
#end
