
#include "colors.inc"         
#include "functions.inc"
#include "stars.inc"    
#include "stones.inc" 
#include "woods.inc"

/* Chris Becker aka Topher (c) 2002 */

// the camera
camera {
 location <6,6,16> 

 look_at <0,0,0>


}
camera {
 location <6,6,16> 
 look_at <0,0,0>
}


#declare cam_loc=<6,6,16>;     
#declare lookat=<0,0,0>;
#declare sky_vect = y;
 global_settings {

     max_trace_level 40
  }

     

#declare FullQuality=1; 
#declare AreaLights=1;  

light_source {<-5.4,16,10>   Gold*.25+White*.75    
#ifdef (AreaLights)
  area_light <3, 0, 0>, <0, 0, 3>, 10, 10
  adaptive 1
    jitter  
#end 

}

// background
background {White}   


// room
#ifdef (FullQuality) 

box {<-23,-46,-23>,<23,100,23> pigment{White} normal{agate 0.1 scale <1,4,1>} rotate<0,45,0> inverse } 

#else
box {<-23,-46,-23>,<23,100,23> pigment{White} rotate<0,45,0> inverse } 
#end 


// functions for some of the textures and isosurfaces
 #declare fn_granite=function {
    pigment {
      granite
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  }   
  
 #declare fn_bumps=function {
    pigment {
     bumps
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  }
  
#declare fn_agate=function {
    pigment {
     agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  }         
  
#declare fn_wood=function{
  pigment {
  wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>*3
    rotate <5, -45, 5>
    translate -x*2
    color_map {
        [0 color rgb 0]
        [.4 color rgb 0] 
        [.6 color rgb 1]
        [1 color rgb 1]
      }
    } 
    }

#declare fn_wood2=function{
  pigment {
  wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>*3
    rotate <5, -45, 5>
    translate -x*2
    color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    } 
    } 
    
    #declare fn_agate=function{
  pigment {
  granite 
    rotate <5, -45, 5>
    translate -x*2    
    scale .25
    color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    } 
    }  
    
#declare fn_points1=function{
        pigment{
        granite
        color_map {
        [0 color rgb 0]
        [.7 color rgb 0]
        [1 color rgb 1]
      }
      }
      }

#declare fn_points2=function{
        pigment{
        bumps
        color_map {
        [0 color rgb 0]
        [.7 color rgb 0]
        [1 color rgb 1]
      }
      }
      }
        
    
// table 
 
#ifdef (FullQuality)
isosurface{function{f_rounded_box(x,y,z, .2, 1, 1, 1)+fn_granite(x,y,z*3).gray*.02}  scale<10,1,10> translate<0,-3,0> rotate <0,45,0>//pigment{White}    
 pigment {  

  wood  
   turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>*3
    rotate <5, -45, 5>
    translate -x*2  
    scale .5
  } 
            
    normal {  
     
  function{
  fn_wood(x,y,z).gray+fn_agate(x,y,z*4).gray*.2 

  }  scale .5

    }       

    }
#else
box{<-10,-1,-10>,<10,1,10> pigment {Brown} translate<0,-3,0>rotate <0,45,0>}       
#end     

// blue planet  
union {
union {
#ifdef (FullQuality)
isosurface{function { f_sphere(x, y, z, 4)-fn_granite(x/2, y/2, z/2).gray*0.02} contained_by{sphere {<0,0,0>,5}} pigment {rgb<0,0,.8>}}
isosurface{function { f_sphere(x, y, z, 3.93)-fn_bumps(x, y, z).gray*.1-fn_granite(x/2, y/2, z/2).gray*.05} accuracy 0.0001 contained_by{sphere {<0,0,0>,5}} 
pigment {  granite  scale 2.5  color_map {
        [0 color rgb <235./255.,191./255.,148./255.>]
        [1 color rgb <.2,.35,0>]
        }} }         
  
sphere {<0,0,0>,4.05 pigment {  agate scale 5 color_map{ 
         [0 color rgbt <1,1,1,0>]
         [.5 color rgbt <1,1,1,.8>] 
         [1 color rgbt <1,1,1,1>]    }     }
         normal { function {f_agate(x/1.5,y/1.5,z/1.5)}} rotate<95,31,63>  }
         
#else
sphere {<0,0,0>,4 pigment{Blue}}   

#end
translate <0,.8,0> 
} 
            
// glass over planet
sphere{<0,0,0>,4.5 pigment{rgbt<1,1,1,.9>} translate <0,.4,0>}   

// stand 
#ifdef (FullQuality)   
union {
lathe {
  cubic_spline
  7,
  <0,0>,<0,0>, <2, .001>, <2.3, -.2>, <2.1, -.3>, <2.3, -.4>,<0, -.5>
  
                                                           
         pigment {Gold} 
  translate<0,-1.75,0> 
  scale <2,1,2> 
        finish {phong 1.0 #ifdef (FullQuality) reflection .7 #end } 
       } 
      finish {phong 1.0 #ifdef (FullQuality) reflection .7 #end } 
  
    } 
   #end 
 
translate<3,0,-3> 
} 



// second trophy
union {
#ifdef (FullQuality)
lathe { 

  cubic_spline
  11,
  <0,-2>,<0,-2>, <.1, -2>,<.2, -1.7>,<.05, -1.5>, <.3, 0>,<.5,1>, <.3, 2>, <1, 3.5>,<0, 3.5>,<0,3.7>
  
                                                           
         pigment {Gold} 
        finish {phong 1.0 #ifdef (FullQuality) reflection .5 #end } 
       }   
            
       // green red white thing 
       sphere{<0,6.01,0>,1.41 pigment {Red} normal {granite 1.0}}
       isosurface{function { f_sphere(x, y, z, .7)-fn_points1(x*5, y*5, z*5).gray*.2-fn_granite(x/3,y/3,z/3).gray*.01} max_gradient 2 scale <2,2,2> translate <0,6.01,0> pigment {Green} normal {granite 1.0} }
       isosurface{function { f_sphere(x, y, z, .7)-fn_points2(x*5, y*5, z*5).gray*.2-fn_granite(x/3,y/3,z/3).gray*.01} max_gradient 2 scale <2,2,2> translate <0,6.01,0> pigment {White} normal {granite 1.0}}
       #else
       sphere{<0,6.01,0>,1.41 pigment {Red}} 
       #end
       translate <-10,0,0>
       }  


// gas planet
union {    
#ifdef (FullQuality)
union {     
#declare i=0; 
#declare S1=seed(10);
#while (i<=30)
sphere{ <0,0,0>,1.5-(i*.03333)
       pigment {
          wood
            turbulence <0.1, 0.5, 1>
            octaves 5
            lambda 3.25
            scale <0.15, .5, 1>*3
            rotate <5, 0, 95>
            translate -x*2  
            
            color_map {
                [0 color Tan  transmit 0]   
                [.5 color Gray75  transmit 1]
                [1 color Gray75  transmit 1]     
        
      } }
      rotate <rand(S1)*5,rand(S1)*5,rand(S1)*90>  
     // no_shadow
    }
     #declare i=i+1;
     #end // while 
    
    }        

     
   
// glass
sphere { <0,0,0>,1.7 pigment{rgbt<1,1,1,.9>}}   
// stand 
   
#declare i=0;   
#while (i<8)
 sphere_sweep { b_spline  6 <1.1,-3.8,0>,.05,<1.1,-3.8,0>,.05,<1,-4.1,0>,.1,<.0,-2.5,0>,.1,<1,-1.5,0>,.1,<1,-1.5,0>,.17 pigment {White} finish{phong 1.0} rotate<0,45*i,0> normal {wrinkles 1.0} texture{T_Grnt4}}  
 #declare i=i+1;
#end // while        

#else                                                                
sphere { <0,0,0>,1.5 pigment {Tan}}   
#end   

translate <-5,2,0>
} 
 
// world slice 
#declare Slice = intersection {   
  box{<-1,-1,-1>,<.02,1,.02> } 
  isosurface{function { f_sphere(x, y, z, 1)-fn_granite(x*5,y*5,z*5).gray*.1}}
  } 

union {  
#ifdef ( FullQuality )
union {
 object {Slice pigment {granite color_map { [0 Tan][1 White]} } }    
 object {Slice pigment {granite color_map { [0 Brown transmit 1][1 Brown transmit 0]}}translate <.01,0,.01>scale .99 finish {reflection .3}}   
 object {Slice pigment {granite color_map { [.2 Yellow transmit 1][1 Yellow transmit 0]} } translate <.01,0,.01> scale .7 finish {reflection .3}}
 object {Slice pigment {wood scale .3333 color_map { [0 Red*4 transmit .6][1 Red*4 transmit 0]} } translate <.02,0,.02> scale .5 finish {reflection .3}}
intersection {   
  box{<-1,-1,-1>,<.02,1,.02> } 
  isosurface{function { f_sphere(x, y, z, .5)-fn_bumps(x*5,y*5,z*5).gray*1} pigment {color_map { [0 Red*2 transmit 0][1 Red*2 transmit 0]} } translate <.03,0,.03> scale .8 }
   finish {reflection .3}     
  } 
  
  intersection {   
  box{<-1,-1,-1>,<.02,1,.02> } 
  isosurface{function { f_sphere(x, y, z, .1)-fn_granite(x,y,z).gray*1.5}}
  scale .4 
  pigment {granite color_map {[0 Red*1.5][1 Orange*1.5]} scale .1 } translate <.05,0,.05> 
  finish {reflection .3}
  }     
  
}  

// world slice stand 
union {
#declare S1=seed(3);
#declare k=0;
#while (k<5)
 #declare i=0;   
 #while (i<5-k)
  #declare j=0;
  #while (j<5-k)
   sphere {<i/5.,k/5.,j/5.>,.15 pigment {color<rand(S1),rand(S1),rand(S1)>} finish {phong 1.0 reflection .3}}
   #declare j=j+1;
  #end // while j
  #declare i=i+1;
 #end // while i    
 #declare k=k+1;
#end // while k    
translate <-.5,-1.9,-.5> 
}   



#else 

intersection {   
  box{<-1,-1,-1>,<.02,1,.02> } 
  sphere {<0,0,0>,1}
  pigment {Tan}
  }
#end
  


 
rotate <0,-60,0>
translate <8,0,4>
}


// mechanical planet 

union {  
#ifdef (FullQuality)
intersection{

difference
{
 isosurface{function { f_sphere(x, y, z, .5)-fn_granite(x,y,z).gray*.4} pigment {White} scale 2}   
 sphere {<0,0,0>,1.25 pigment {Green*10} }
}
sphere {<0,0,0>,1.4 pigment {bumps scale .01 color_map {[0,rgb 0][.5,rgb 0][1 green 2]}} }

}       
sphere {<0,0,0>,.5 pigment {bumps scale .3333 color_map {[0 Green*10][1 color<0,7,1>]}} no_shadow}          
#else
sphere {<0,0,0>,1.4 pigment {DarkGreen}}
#end
translate <-7,0,4.5>  
}                   

// light for mechanical planet shadow
#ifdef (FullQuality)
light_source { <-7,.5,4.5> Green*3 spotlight radius 100 falloff 3 point_at <-7,-3,4.5>}   
#end

// snow shaker thing
union {    
#ifdef (FullQuality)
union {
lathe { 

  cubic_spline
  10,
  <0,0>,<2,0>,<1.9,0>, <1.9, .05>,<1.8, .1>,<1.8, .2>,<1.7, .25>,<1.7, .3>,<1.6, .35>,<1.6, .4> 
  texture {T_Wood1}
  }  
  sphere {<0,0,0>,1.9 scale<1,.0001,1> pigment {Black}}                        
  } 
  
  // glass
  sphere {<0,.4/.25,0>,1.65 pigment {rgbf 1} finish {phong 1.0 ior 1.3 reflection .15 caustics 1.0} scale <1,.25,1>} 
  
  // planet  
  sphere {<0,.4/.25,0>,1 pigment {bumps color_map{[0 Black][1 Red*2]} scale .5} scale <1,.25,1> normal {agate 1.0}}
  
  #declare i=0;
  #declare S1=seed(11); 
  #while (i<10000)
   #declare X=rand(S1)*.8-.4;
   #declare Y=rand(S1)*.8-.4;
   #declare Z=rand(S1)*.8-.4;
   #if (X*X+Y*Y+Z*Z<.35*.35)
    #sphere {<X*4,(Y+.4)/.25,Z*4>,.01 pigment {White} scale <1,.25,1> }
   #end // if
   #declare i=i+1;
  #end // while i
  
  #else
  sphere {<0,.4/.25,0>,1 pigment {red .5} scale <1,.25,1>}    
  #end     
  
  translate <-5,-2,40>      
   scale <.25,1,.25>  
   
  }
   
#declare flare_brightness = .75;  // we must reset flare_brightness
#declare light_rad = .25;

#declare flare_size = 1;

#declare Can = object {
union {
difference {
cylinder {<0,-1.999,0>,<0,-1,0>,.5    pigment{Gray} finish {reflection .15} normal{agate .5 scale <1,4,1>} } 
cylinder {<0,-1.9,0>,<0,0,0>,.45    pigment{ Gray} finish {reflection .15} }      
torus {.475,.015 pigment {Gray} finish {reflection .15} translate<0,-1,0>}
}
sphere_sweep { b_spline
6 
<.5,-1.2,0>,.1,<.5,-1.2,0>,.01,<.6,-1.7,.6>,.01,<-.6,-1.7,.6>,.01,<-.5,-1.2,0>,.01,<-.5,-1.2,0>,.1

 pigment {Gray} finish {reflection .15 phong 1.0}
}  
 
} 
} 


#ifdef (FullQuality)

// cans 
// water 
union {
object {Can}
cylinder {<0,-1.9,0>,<0,-1.2,0>,.4499 pigment {White transmit .9} finish {phong 1.0 reflection .5} normal{bumps 1.0 scale .5} interior{ior 1.1 caustics 1.}}

// brush
sphere_sweep {linear_spline 2 <.5,-.3,.5>,.02,<0,-2,0>,.001 pigment {Black} finish{phong 1.0}}

torus {.5,.07 pigment {White transmit .9} normal{bumps 1.0 scale .1} interior{ior 1.1} finish{ phong 1 reflection .15} translate <0,-2,0>}
 translate <5,0,5>  
 rotate <0,15,0>
}

// fire 
union {
object {Can}
cylinder {<0,-1.9,0>,<0,-1.25,0>,.4499 pigment {granite scale .333 color_map {[0 Red*2][1 Orange*2]}} finish {phong 1.0 reflection .5} normal{bumps 1.0 scale .5} }
sphere_sweep { linear_spline 2 <0,-1,.5>,.09,<0,-1.7,.5>,.03  pigment {granite scale .333 color_map {[0 Red*2][1 Orange*2]}} finish {phong 1.0 reflection .5} normal{bumps 1.0 scale .5} }    
sphere_sweep { linear_spline 2 <-.5,-1,0>,.07,<-.5,-1.2,0>,.01  pigment {granite scale .333 color_map {[0 Red*2][1 Orange*2]}} finish {phong 1.0 reflection .5} normal{bumps 1.0 scale .5}}
rotate <0,-35,0>
translate <6.3,0,5.3>
}

// earth 
union {
object {Can}
cylinder {<0,-1.9,0>,<0,-1.2,0>,.4499 pigment {granite scale .333 color_map {[0 Brown][1 Tan]}}  normal{agate 1.0 scale .5} }

sphere_sweep { linear_spline 2 <0,-1,.5>,.1,<0,-1.9,.5>,.03 pigment {granite scale .333 color_map {[0 Brown][1 Tan]}} normal{agate 1.0 scale .5}  }

rotate <0,46,0>
translate <6.3,0,6.8> 
}


// air 
union {
object {Can}
cylinder {<0,-1.9,0>,<0,-1.1,0>,.4499 pigment {agate scale .333 color_map {[0 White][1 transmit 1]}} normal {bumps 1.0 scale .5}  }
rotate <0,137,0>
translate <5.3,0,6.1>
}

#else
cylinder {<0,-1.999,0>,<0,-1,0>,.5    pigment{Gray} translate <5,0,5>}    
cylinder {<0,-1.999,0>,<0,-1,0>,.5    pigment{Gray} translate <6.3,0,5.3>}
cylinder {<0,-1.999,0>,<0,-1,0>,.5    pigment{Gray} translate <6.3,0,6.8> } 
cylinder {<0,-1.999,0>,<0,-1,0>,.5    pigment{Gray} translate <5.3,0,6.1>} 
#end

// in progress
#ifdef(FullQuality)
 #declare Blob_threshold=0.01;   
 union{
 isosurface{function{(1+Blob_threshold)
      -Blob_threshold^(max(f_rounded_box(x,y,z, .01, 1, 1, 1),-f_sphere(x+1,y-1,z-1,1.7)-f_agate(x,y,z)*.2)-f_crackle(x,y,z)*.3-f_granite(x,y,z)*.03)
      -Blob_threshold^f_sphere(x,y,z,.7)} max_gradient 4 contained_by {box{-2,2}}   

   texture{T_Grnt2}}
 
 // paint
isosurface{function{ f_sphere(x,y,z,.6)-f_bumps(x*5,y*5,z*5)*.3 } contained_by {box{-2,2}} max_gradient 2 pigment {granite scale .333 color_map {[0 Red*2][1 Orange*2]}}}

 translate <1.75,-1,7> 
   }

// chunk 
isosurface{function{max(f_rounded_box(x,y,z, .01, 1, 1, 1),-f_sphere(x-1,y-1,z+1,3.3)-f_agate(x,y,z)*.2)-f_crackle(x,y,z)*.3-f_granite(x,y,z)*.03} contained_by {box{-1.3,1.3}}   
rotate<90,160,0> translate <-1,-1,8> texture{T_Grnt2} } 
 
 
// spill
isosurface{function{ f_sphere(x,y,z,.01)-f_bumps(x*4,y*4,z*4)} pigment {granite scale .333 color_map {[0 Brown][1 Tan]}} normal{agate 1.0 scale .5} translate <6.0,-200,7.3> scale <1,.01,1>}  


#else
box{<-1,-1,-1>,<1,1,1> pigment {Tan}  translate <1.75,-1,7>}
#end






#declare ShakerOutside= 
lathe {
cubic_spline
 5
<0,.25>,<0,1>,<.3,1>,<.4,0>,<0,0>   

}



#declare Shaker = difference{

object {ShakerOutside}

// cuts on outside
sphere {<0,.5/3,.3>,.15  scale <1,3,1>}
sphere {<0,.5/3,-.3>,.15  scale <1,3,1>}
sphere {<.3,.5/3,0>,.15 scale <1,3,1>}
sphere {<-.3,.5/3,0>,.15  scale <1,3,1>}


}

// green shaker
union {   
#ifdef (FullQuality)
object{ Shaker
 pigment {White transmit .9}
interior{ior 1.3 caustics 1.0}
finish {phong 1.0 reflection .15} 
}

object {ShakerOutside 
pigment {granite color_map{[0 Green][1 Yellow]}}
scale <.6,.8,.6>
}

// top
difference {
lathe { 
6
<.3,1>,<.2,1.1>,<.1,1.05>,<.2,1.075>,<.25,1.2>,<0,1.25>  
}


cylinder {<.06,2,.06>,<.06,-3,.06>.03} 
cylinder {<.06,2,-.06>,<.06,-3,-.06>.03} 
cylinder {<-.06,2,-.06>,<-.06,-3,-.06>.03}  
cylinder {<-.06,2,.06>,<-.06,-3,.06>.03} 
pigment {Gray} 
finish {phong 1.0 reflection .15} 
}

#else
cylinder {<0,0,0>,<0,1,0>,.35 pigment {Green}}  
#end

translate <-2,-2,2>
}

// brown shaker
union {
#ifdef (FullQuality)
object{ Shaker
 pigment {White transmit .9}
interior{ior 1.3 caustics 1.0}
finish {phong 1.0 reflection .15} 
}

object {ShakerOutside 
pigment {granite color_map{[0 Brown][1 Tan]}}
scale <.6,.8,.6>
}

// top
difference {
lathe { 
6
<.3,1>,<.2,1.1>,<.1,1.05>,<.2,1.075>,<.25,1.2>,<0,1.25>  
}


cylinder {<.06,2,.06>,<.06,-3,.06>.03} 
cylinder {<.06,2,-.06>,<.06,-3,-.06>.03} 
cylinder {<-.06,2,-.06>,<-.06,-3,-.06>.03}  
cylinder {<-.06,2,.06>,<-.06,-3,.06>.03} 
pigment {Gray} 
finish {phong 1.0 reflection .15} 
}
#else
cylinder {<0,0,0>,<0,1,0>,.35 pigment {Brown}}  
#end
translate <-2.91,-2,2.04>
}  


// picture on right
union { 
#ifdef (FullQuality)
box {<0,0,0>,<1,1,1> pigment { image_map { jpeg "EowPainting.jpg" } }  normal {granite .50 scale .1} finish {phong 0.5}}

intersection {     
blob { 
threshold .65
sphere {<0,1,0>,.1 1}
sphere {<1,1,0>,.1 1}
cylinder {<0,1,0>,<1,1,0>,.06 1}
cylinder {<1,1,0>,<1,0,0>,.06 1}
cylinder {<1,0,0>,<0,0,0>,.06 1}
cylinder {<0,0,0>,<0,1,0>,.06 1}
}
box {<0,0,-1>,<1,1,1> inverse}
pigment {Gold}
finish {phong 1.0 reflection .15}
normal {agate 0.3 scale .1}  
}


#else
box {<0,0,0>,<1,1,1> pigment { Brown }}
#end


scale <10,5,5>*2 rotate <0,-135,0> translate <-5,0,-27>  
}

// picture on left
union { 
#ifdef (FullQuality)
box {<0,0,0>,<1,1,1> pigment { image_map { jpeg "trees.jpg" } }  normal {granite .50 scale .1} finish {phong 0.5}}

intersection {     
blob { 
threshold .65
sphere {<0,1,1>,.1 1}
sphere {<1,1,1>,.1 1}
cylinder {<0,1,1>,<1,1,1>,.06 1}
cylinder {<1,1,1>,<1,0,1>,.06 1}
cylinder {<1,0,1>,<0,0,1>,.06 1}
cylinder {<0,0,1>,<0,1,1>,.06 1}
}
box {<0,0,-2>,<1,1,2> inverse}
pigment {Tan}
finish {phong 1.0 reflection .15}
normal {agate 0.3 scale .1}  
}


#else
box {<0,0,0>,<1,1,1> pigment { Brown }}
#end


scale <10,5,5>*2 rotate <0,-45,0> translate <10,0,-35> 
}
// saw
 
 union {  
 #ifdef (FullQuality)
    union {
    intersection {
    torus  {4,.15  rotate <90,0,0>}
    box{<0,0,-18>,<-18,18,18>} 
    
     
    
    }
              
    
    sphere {<-4,0,0>,.15} 
    sphere {<0,4,0>,.15}    
    texture {T_Wood1} 
    
    }
    #declare i=1;
    #while (i<30)
     
     cone {<-cos(i/30*pi/2)*1.7*2,sin(i/30*pi/2)*1.7*2,0>,0,<-cos(i/30*pi/2)*4,sin(i/30*pi/2)*4,0>,.1 pigment {Silver}}
     
     #declare i=i+1;
    #end    
     
     #else
     intersection {
     torus  {4,.15  rotate <90,0,0>}
     box{<0,0,-18>,<-18,18,18>} 
     pigment {Tan}
     }
     #end
    
    rotate <90,14,0>
     translate <-1.,-1.9,3.5>
     } 
   
   // sander
   union { 
difference { 
intersection {
 sphere {<0,0,0>,1 }
 box {<0,0,0>,<1,1,-1> }
 pigment {White}
 normal {bumps .25 scale .5} 
 finish {reflection .5}
 }
 sphere {<0,0,0>,.8 pigment {Tan} normal {agate 1.0 scale .1}}    

 }          
 union {
 cylinder {<1,1,-1>,<.5,.5,-.5>,.1}
 sphere { <1,1,-1>,.2 }     
 texture {T_Wood1} 
 finish {phong .5}
 }       
 rotate <0,53,0>
 rotate <-48,0,0>
  translate <-2,-1.35,6.0>
 }
 
 
 union { 
 sphere_sweep {linear_spline 2 <0,1,0>,.3,<0,0,0>,.2 texture {T_Wood1 rotate <45,45,45>}}  
 difference {
 cylinder {<0,0,0>,<0,-.5,0>,.2 pigment {White}  finish {reflection .5}} 
 sphere {<.1*2,-.6/3,.1*2>,.2 pigment {White} scale <.5,3,.5>  finish {reflection .5}}
 sphere {<.1*2,-.6/3,-.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}
 sphere {<-.1*2,-.6/3,-.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}  
 sphere {<-.1*2,-.6/3,.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}   
 
  sphere {<.1*2,-.6/3,0>,.1 pigment {White} scale <.5,3,.5>  finish {reflection .5}}
 sphere {<-.1*2,-.6/3,0>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}
 sphere {<0,-.6/3,-.1*2>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}  
 sphere {<0,-.6/3,.1*2>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}

 }         
 rotate<-85,16.7,0>

 translate <-3,-1.75,9>
}


// can top water
union {
torus {.5,.02 pigment{Gray} pigment{Gray} finish {reflection .15} normal{agate .5 scale <4,1,1>} } 
disc {<0,0,0>,<0,1,0>,.5 pigment{Gray} pigment{Gray} finish {reflection .15} normal{agate .5 scale <4,1,1>} } 
disc {<0,.001,0>,<0,1,0>,.4 pigment{image_map{jpeg "water.jpg" } rotate<90,90,0> translate<.5,.5,.5>} normal{agate 1.0} finish{phong 1.0}}
rotate<42,40,48> 
translate<5,-1.72,7>
}

// can top fire
union {
torus {.5,.02 pigment{Gray} pigment{Gray} finish {reflection .15} normal{agate .5 scale <4,1,1>} } 
disc {<0,0,0>,<0,1,0>,.5 pigment{Gray} pigment{Gray} finish {reflection .15} normal{agate .5 scale <4,1,1>} } 
disc {<0,.001,0>,<0,1,0>,.4 pigment{image_map{jpeg "fire.jpg" } rotate<90,90,0> translate<.5,.5,.5>} normal{agate 1.0} finish{phong 1.0}}
rotate<0,32.3,0>
translate<7.5,-1.999,5.5>
}