// Persistence of Vision Ray Tracer Scene Description File
// File: icicle.inc
// Vers: 3.5
// Desc: Basic Scene Example
// Date: 04/30/02
// Auth: Jeff M. Thomas
//

#version 3.5;

#macro MakeIcicleBumps( Rand )
  #ifdef (fn_ice)
    #undef fn_ice
  #end
  #declare fn_ice=function
  {
    pigment
    {
      //granite
      bumps
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
      scale .1
    }
   }
#end // MakeIcicleBumps

#macro MakeIcicle( Rand, Length, Width )
  #ifdef (Icicle)
    #undef Icicle
  #end
  #declare Icicle=
    difference
    {
      isosurface 
      {
        MakeIcicleBumps( Rand )
      	function  { f_piriform(x,y,z, 0.7)+(fn_ice(x,y,z).gray*.025) }
      		//P0= Field Strength
      	contained_by { box { <-0, -0.4, -0.4>, <1, 0.4, 0.4> } }
      	max_gradient 0.9
      	//texture { pigment{ White } }
      	no_shadow
      	//scale 10  rotate y*-20  translate x*-4
      }
      box{ <.8, -0.4, -0.4>, <1, 0.4, 0.4> }
     	rotate <0,0,90>
     	//texture { T_Glass4 }
     	//material { texture { pigment { color rgbf <0.62, 0.89, 0.97, 1> } finish { F_Glass9 } } interior { I_Glass fade_color Col_Blue_01 } }
     	//material { texture { pigment { color rgbf <0.72, 0.92, 0.97, 0> } finish { F_Glass9 } } interior { I_Glass fade_color Col_Blue_01 } }
     	//texture { T_Glass4 }
     	texture
     	{
     	  pigment{rgbf <0.5,0.5,1,0>}
     	  //finish { F_Glass4 }
     	}
    	scale <Width,Length,Width>
/*     	material 
     	{ 
     	  texture { pigment { color rgbf <0.82, 0.82, 0.97, .7> } }
     	  interior { I_Glass fade_color Col_Blue_01 }
     	}
*/
      translate <0,-1,0>
    }
#end // MakeIcicle

//MakeIcicle( 2, 2, .6 )
//object{ Icicle }