// Persistence of Vision Ray Tracer Scene Description File
// File: lamp.inc
// Vers: 3.5
// Desc: A Brass Lamp
// Date: 04/30/02
// Auth: Jeff M. Thomas
//


#macro BrassLamp( GLASS, LIGHT )
  #local Lamptexture=
      texture // a rusty iron
      { 
        pigment
        {
          P_Copper2   
        }
        finish
        {
          F_MetalA
        } 
      }
  
  #local TopSize = .675;    
  #declare Top=
      prism 
      {
        conic_sweep
        linear_spline
        1, // height 1
        0, // height 2
        5, // the number of points making up the shape...
        <TopSize,TopSize>,<-TopSize,TopSize>,<-TopSize,-TopSize>,<TopSize,-TopSize>,<TopSize,TopSize>
        rotate <180,0,0>
        scale <1,.5,1>
        texture{ Lamptexture }
      }
  
  #macro difBox()
    box
    {
      <-.1,-.51,-1.5>,<.1,.51,1.5>
    }
  #end
  
  #macro HoleMaker()
    #local HoleSpacing = .08;
    #declare Holes=
      union
      {
        cylinder
        {
          <0,0,-.75>,<0,0,.75>,.02
        }
        cylinder
        {
          <0,HoleSpacing,-.75>,<0,HoleSpacing,.75>,.02
        }
        cylinder
        {
          <0,-HoleSpacing,-.75>,<0,-HoleSpacing,.75>,.02
        }
        cylinder
        {
          <HoleSpacing,0,-.75>,<HoleSpacing,0,.75>,.02
        }
        cylinder
        {
          <-HoleSpacing,0,-.75>,<-HoleSpacing,0,.75>,.02
        }
        texture
        {
          Lamptexture
        }
      }
  #end
  #declare BLamp=
  union
  {
  #if (GLASS)
    difference
    {
      cylinder
      {
        <0,.5,0>,<0,-.5,0>,.5
      }
      cylinder
      {
        <0,.51,0>,<0,-.51,0>,.49
      }
      texture
      { 
        T_Glass4 
        normal
        { 
          agate
          //agate
          //agate_turb 0.1
          //warp { turbulence .5 octaves 6 lambda .5 omega .5 }
          //scale<.1,.05,.1>
          scale<1,.25,1> 
        }
      }
    }
  #end
    difference
    {
      cylinder
      {
        <0,.5,0>,<0,-.5,0>,.515
      }
      cylinder
      {
        <0,.51,0>,<0,-.51,0>,.509
      }
      object
      {
        difBox()
        translate<-.20,0,0>
      }
      object
      {
        difBox()
        translate<.20,0,0>
      }
      object
      {
        difBox()
        rotate y*90
        translate<0,0,-.20>
      }
      object
      {
        difBox()
        rotate y*90
        translate<0,0,.20>
      }
  
      texture
      {
        Lamptexture
      }
    }
    union  // base
    {
      cone
      {
        <0,-.95,0>, .65, <0,-.5,0>, .55
      }
      cone
      {
        <0,-.5,0>, .25, <0,-.2,0>, .06
      }
      torus
      {
        .65,.025
        translate <.0,-.95,0>
      }
      torus
      {
        .55,.015
        translate <.0,-.5,0>
      }
      texture
      {
        Lamptexture
      }
    }
    //top
    union
    {
      difference
      {
        object
        { 
          Top
          translate <0,1,0>
        }
        object
        { 
          Top
          scale .99
          translate <0,.99,0>
        }
        HoleMaker()
        object
        {
          Holes
          translate <0,.7,0>
        }
        object
        {
          Holes
          rotate <0,90,0>
          translate <0,.7,0>
        }
      }
      sphere
      {
        <0,1,0>,.075
        texture
        {
          Lamptexture
        }
      }
      torus
      {
        .1,.01
        texture
        {
          Lamptexture
        }
        rotate x*90
        translate<0,1.1,0>
      }
      translate <0,-.05,0>
    }
    #if (LIGHT)
      //sphere
      //{                 
      //  <0,-.075,0>, .075
      //  pigment{ Yellow }
      //}
      light_source{
        0, color (<0.5, 0.35, 0.1>)
        fade_distance .8
        fade_power 1.75
        photons { reflection off refraction off } 
        //area_light
        //<0, 0, 0> <0, 0.2, 0>
        //6, 1
        //adaptive 2
        //jitter
      }
    #end
    //translate <0,.5,0>
    //rotate x*90
  }
#end // macro BrassLamp


//#local GlassRandom = seed(2442);
/*
#local xSize = 1;
#local xWidth = .05;
#local Varience = .015;
#local ySize = 1;
#declare Lamptexture1=
    texture // a rusty iron
    { 
      pigment
      {   
        granite
        color_map 
        {
          [0.0 rgb <.0,.0,.0>]
          [0.45 rgb <.005,.005,.005>]
          [0.6 rgb <.005,.0051,.0051>]
          [0.8 rgb <.005,.0,.0>]
          [1 rgb <.005,.002,.0>]
        }
      } 
      scale .3
      finish{ ambient 0.2 diffuse 0.6 } 
      normal { wrinkles 1 scale 0.5 }
    }

#macro OldGlass(Random)
  #local iCount = 0;
  #local GlassRandom = seed(Random);
  #declare OGlass=
    merge
    {
      #while (iCount < ySize)
        torus
        {
          ((Varience-(rand(GlassRandom)*Varience))+xSize),((Varience-(rand(GlassRandom)*Varience))+xWidth)
          translate<0,(ySize/2)-iCount,0>
        }                                
        #local iCount = iCount + .005;
      #end
      pigment{ DimGray }
      texture
      { 
        pigment{ rgbf<0.8, 0.8, 0.2, 1> }
        finish
        {
          specular 0.7
          roughness 0.001
          diffuse 0
          reflection
          {
            0.2, 1.0
            fresnel on
          }
          conserve_energy
        }
      }
    
    }
#end // OldGlass 

OldGlass(2442)
object{ OGlass scale .5 }
*/
