// winter IRTC 04/2002

#version unofficial megapov 0.72;
     
#declare Use_Rad=on;
#declare Use_Snow=on;
#declare Use_Iso=on;
#declare Use_Penguin=off;
#declare Use_Snowplane=on;
#declare Nb_Snowplane=10;

global_settings {
	max_trace_level (2*Nb_Snowplane+5)
}

#if (Use_Rad)
global_settings {
	radiosity {
		brightness 1.5
		count 300
		recursion_limit 1
		error_bound 0.01
		pretrace_start 0.1
		pretrace_end 0.01
		always_sample off
		samples{quality 6 area_light off}
		max_sample 2
	}
}

sky_sphere{pigment{gradient y color_map{[0 rgb 2][0.5 rgb 1.2][0.1 rgb 1.1]}}}

#default{texture{finish{ambient 0 diffuse 1}}}

#else

light_source{100000*y, rgb 1.7
	area_light 50000*x, 50000*z,5,5
	jitter  adaptive 2 //orient circular
	rotate -x*20 rotate z*20
}

light_source{10000*x, rgb .2 shadowless rotate y*10 rotate z*10}

#default{texture{finish{ambient .1 diffuse .9}}}

#end


#local CamPos=<400,200,-800>;
#local CamLook=<-150,100,0>;

#local Norm=vnormalize(CamPos*<1,0,1>-CamLook*<1,0,1>);
#local Dist=2*vlength(CamPos*<1,0,1>-CamLook*<1,0,1>);

#if (Use_Snowplane)

#include "reorient.mcr"
#local i=1;
#local stp=seed(1342);
#while(i<=10)
	//polygon	{4, <-1000,-10,0>, <1000,-10,0>, <1000,1000,0>, <-1000,1000,0>
	box{<-1000,-10,-.01>,<1000,1000,.01>
		hollow no_shadow no_reflection
		texture{
			pigment{granite scale 3 color_map{[.45 rgbf 1][.55 rgb 1]}}
			finish{ambient 1 diffuse 0}
			translate i*200*z
			scale <1,2,1>
			rotate 15*(2*rand(stp)-1)*z
		}
		Reorient(-z, Norm)
		translate CamPos*<1,0,1>-Norm*Dist*i/Nb_Snowplane
	}
	#local i=i+1;
#end

#end


fog{
	fog_type 2
	distance 400
	rgb 1
	fog_offset 100
	fog_alt 250
	up -z
	turbulence 5
	turb_depth 5
}


camera{
	location <400,200,-800>
	up 4*y/3
	right x
	angle 25
	look_at <-150,100,0>
}





//==========================
// mur
//==========================

#local PigRoche=pigment{image_map{sys "020roche"}}
#local NormRoche=normal{bump_map{sys "020roche"}bump_size 1.5}

#local Hf1 = height_field {
	pattern 1000,1000{
		average
		pigment_map{[1 granite scale .2/1000][1 PigRoche scale 0.4 rotate x*90]}
		
	}
	rotate -x*90
	scale <1000,1000,2>
}

//==========================
// gouttiere
//==========================
#declare TexGout=texture{
	pigment{
		pigment_pattern{wrinkles scale 5 color_map{[.3 rgb 0][.7 rgb 1]}}
		pigment_map{
			[0 image_map{tga "030metal" map_type 2} scale <1,20*pi,1>]
			[1 image_map{tga "030metal" map_type 2} scale <1,20*pi,1> rotate y*180 translate 20*y]
		}
	}
	normal{bumps 1.5 scale 3}
	finish{brilliance 2}
}

#declare DemiCercle=union{
	intersection{
		difference{
			union{
				cylinder{-1.5*y, 1.5*y, 8}
				box{<-9,-1.5,0>,<9,1.5,.6>}
				cylinder{<-9,0,0>,<-9,0,.6>, 1 scale <1,1.5,1>}
				cylinder{< 9,0,0>,< 9,0,.6>, 1 scale <1,1.5,1>}
			}
			cylinder{-1.51*y, 1.51*y, 7.3}
		}
		box{<-10.01,-1.52,.03>,<10,1.52,8.1>}
	}
}
#declare Cercle=union{
	object{DemiCercle texture{pigment{image_map{tga "056metal" map_type 2}scale <1,5,1>} translate 5*z}}
	object{DemiCercle texture{pigment{image_map{tga "056metal" map_type 2}scale <1,5,1>} translate <0,10,5>} scale <1,1,-1>}
	union{
		cylinder{<8.9,0,-.35>,<8.9,0,.65>, .4}
		cylinder{<-8.9,0,-.35>,<-8.9,0,.65>, .4}
		cylinder{<0,0,7.5>, <0,0,10>, .4}
		texture{pigment{image_map{tga "056metal"} scale 5}}
	}
	rotate -y*90
}

#declare Gouttiere1=union{
	cylinder{0*y, 141*y, 7}
	cone{140*y, 7, 150*y, 8}
	cylinder{150*y, 155*y, 8}
	torus{8, .5 translate 155*y}
	object{Cercle translate 40*y}
	object{Cercle translate 110*y}
}
#declare Gouttiere = union{
	object{Gouttiere1 texture{TexGout}rotate x*2}
	object{Gouttiere1 texture{TexGout translate 200*y}
		rotate -2*x translate <0,150,150*sin(radians(2))>
	}
	object{Gouttiere1 texture{TexGout translate 400*y} translate 300*y}
}
#undef Gouttiere1
#undef Cercle
#undef DemiCercle


//==========================
// plaques de rue
//==========================

/*
#declare Vis=difference{
	cylinder{}
}

#declare Plaque1=union{
	superellipsoid{<.5,.1> scale <20,15,1>
		texture{
			pigment{}
		}
	}
	// 4 vis
}
*/

//==========================
// maison
//==========================

#declare Maison1=union{
	#local TexMur1=texture{pigment{rgb <.99,.97,.85>}finish{brilliance .9}}
	#local TexMur2=texture{pigment{PigRoche}normal{NormRoche}warp{turbulence .4 lambda 1 octaves 2}}
	#local TexMur=texture{ average texture_map{[1 TexMur1][2 TexMur2]} scale 400}

	union{
		object{Hf1 translate -1000*x+z texture{TexMur}}
		object{Hf1 texture{TexMur} rotate -90*y translate -x}
	}

	// pierres en coin
	#local F_Round=function{"superellipsoid",<.02,.02>}
	#local sti=seed(1342);
	#local i=0;
	#local ht=10;
	#local Tex=texture{
		pigment{
			granite scale 2
			color_map{
				[0 color rgb <0.694,0.508,0.605>]
				[.2 color rgb <0.694,0.567,0.431>]
				[.4 color rgb <0.605,0.699,0.500>]
				[.6 color rgb <0.551,0.412,0.249>]
				[.8 color rgb <0.786,0.571,0.441>]
				[1 color rgb <0.704,0.820,0.669>]
			}
		}
	}
	#while(i<15)
		#if (mod(i,2)=0)
			object{
				#if (Use_Iso)
				isosurface{
					#local Dep1=500*rand(sti);
					#local Dep2=500*rand(sti);
					#local Dep3=500*rand(sti);
					function{F_Round(x/22,y/10,z/22)-.05*noise3d(Dep1+x/3, Dep2+y/3, Dep1+z/3)-.01*noise3d(x*10, y*10, z*10)}
					sign -1
					contained_by{box{<-22,-10,-22>,<22,10,22>}}
					//eval
					max_gradient 0.3
				}
				translate <-20,10,20>
				#else
				box{<-40,.5,-1>,<1,19.5,40>
					pigment{rgb .9}finish{brilliance .9}
				}
				#end
				translate ht*y
				texture{Tex}
			}
			#local ht=ht+20;
		#else
			object{
				#if (Use_Iso)
				isosurface{
					#local Dep1=500*rand(sti);
					#local Dep2=500*rand(sti);
					#local Dep3=500*rand(sti);
					function{F_Round(x/12,y/15,z/12)-.05*noise3d(Dep1+x/3, Dep2+y/3, Dep1+z/3)-.01*noise3d(x*10, y*10, z*10)}
					sign -1
					contained_by{box{<-12,-15,-12>,<12,15,12>}}
					//eval
					max_gradient 0.3
				}
				translate <-10,15,10>
				#else
				box{<-20,.5,-1>,<1,29.5,20>}
				#end
				translate ht*y
				texture{Tex}
			}
			#local ht=ht+30;
		#end
		#local i=i+1;
	#end
}

#declare Maison2=box{< 1000,0,0>,<4000,1000, 3000> pigment{rgb .8}finish{brilliance .9}}
#declare Maison3=box{<-3000,0,-1000>,<0,1000, -4000> pigment{rgb .8}finish{brilliance .9}}
#declare Maison4=box{< 1000,0,-1000>,<4000,1000, -4000> pigment{rgb .8}finish{brilliance .9}}


#declare Trottoir=union{
	#local i=0;
	#local St1=seed(1342);
	#local St2=seed(13421);
	#while(i<10)
		#if(i<5)
		box{<-75,-2,-75>,<75,0,75> rotate .2*x*rand(St1) rotate .2*z*rand(St2) translate <75,10,75+i*150>}
		box{<-75,-2,-75>,<75,0,75> rotate .2*x*rand(St1) rotate .2*z*rand(St2) translate <225,10,75+i*150>}
		#end
		box{<-75,-2,-75>,<75,0,75> rotate .2*x*rand(St1) rotate .2*z*rand(St2) translate <-75-i*150,10,-75>}
		box{<-75,-2,-75>,<75,0,75> rotate .2*x*rand(St1) rotate .2*z*rand(St2) translate <-75-i*150,10,-225>}
		#local i=i+1;
	#end
	union{
		box{<-75,-2,-75>,<75,0,75> rotate .5*x*rand(St1) rotate .5*z*rand(St2) translate <75,10,-75>}
		box{<-75,-2,-75>,<75,0,75> rotate .5*x*rand(St1) rotate .5*z*rand(St2) translate <75,10,-225>}
		box{<-75,-2,-75>,<75,0,75> rotate .5*x*rand(St1) rotate .5*z*rand(St2) translate <225,10,-75>}
		box{<-75,-2,-75>,<75,0,75> rotate .5*x*rand(St1) rotate .5*z*rand(St2) translate <225,10,-225>}
	}
	union{
		box{<-3000,0,-305>,<300,8.5, 1>}
		box{<-1,0,0>,<300,8.5, 3000>}
		cylinder{0, 8.5*y, 300}
		pigment{rgb .5}
	}
	#local BordTrottoir=union{
		box{<-49.7,0,0>,<49.7,10,-8>}
		box{<-49.7,0,0>,<49.7,6,-10>}
		cylinder{<-49.7,0,0>,<49.7,0,0>,2 scale <1,2,1> translate <0,6,-8>}
	}
	#local i=0;
	#while(i<15)
		object{BordTrottoir rotate .2*y*rand(St1) rotate .2*z*rand(St2) translate <250-i*100,0,-300>
			texture{pigment{granite scale .3 color_map{[0 rgb .4][1 rgb .9]}}}
		}
		#local i=i+1;
	#end
	pigment{rgb .6}
}


plane{y,0
	texture{
		pigment{rgb .2}
		normal{agate 2 scale .1}
		finish{phong 1 phong_size 10 specular 1 roughness .01 }
	}
}


#declare Neige = height_field{
	png "Neige"
	smooth
	translate -.5*x-.5*z
	scale <1000,20,1000>
	translate -310*z+10*x
	texture{
		pigment{rgb 1}
		normal{granite .5 scale .1}
		finish{brilliance 0.8 phong 1 phong_size 3 specular 1 roughness .1}
	}
}

object{Neige}

object{Maison1}
object{Gouttiere translate <8,20,30>}
object{Maison2}
object{Maison3}
object{Maison4}
object{Trottoir}


#undef Maison1
#undef Maison2
#undef Maison3
#undef Maison4
#undef Trottoir
#undef Neige
#undef Gouttiere

//==========================
// banc
//==========================
#include "banc.inc"

object{Banc rotate y*90 scale <-1,1,1> translate <-100,10,-150>}

//==========================
// Poteau
//==========================

#include "poteau.inc"

object{ArretBus translate <90,10, -250>}

//==========================
// neige sur banc
//==========================
#if (Use_Snow)

#include "reorient.mcr"

#local stn = seed(3628);

#local PPat = pigment {
	wrinkles
	scale 20
	color_map {[0 rgb 0][1 rgb 1]}
}

#debug "\nit starts snowing !!!\n"

blob {

#local coin1 = min_extent(Banc);
#local coin2 = max_extent(Banc);

#local incx = 0.6/2;
#local incz = 0.9/2;
	threshold 0.01
#local i=coin1.x;
#while (i<coin2.x)

	#local j=coin1.z;
	#while (j<coin2.z)

		#local Start = <i+incx*rand(stn), 500, j+incz*rand(stn)>;
		#local coef1=vlength(eval_pigment(PPat, Start));
		#if (coef1 > 0.60)

			#local Norm = <0,0,0>;
			#local Intersect = trace (Banc, Start, -y, Norm);
			
			#if (((Norm.x!=0) | (Norm.y!=0) | (Norm.z!=0)) & (Intersect.y < coin2.y))
				#if (abs(vdot(Norm, y))>(.30+.2*vlength(eval_pigment(PPat, Start*10))))
					sphere {
						#local coef=eval_pigment(PPat, Intersect*40);
						0, 1.5, strength 1 scale <(.6+.4*coef.x), (.3+.7*coef.x)*coef1, (.7+.3*coef.x)>*(1+2*coef.x)
						#if (vdot(Norm, y)<1.0)
						Reorient(y, Norm)
						#end
						translate Intersect
					}
				#end
			#end
		#end

		#local j=j+incz;
	#end
	#local i=i+incx;

#end
	texture {
		pigment { color rgb 1 }
		normal { granite .8 scale .2 }
		finish { brilliance .5 specular .5 roughness .001 }
	}
	rotate y*90 scale <-1,1,1> translate <-100,10,-150>
}

//==========================
// neige sur poteau
//==========================

blob {

#local coin1 = min_extent(ArretBus);
#local coin2 = max_extent(ArretBus);

#local incx = 0.6/2;
#local incz = 0.9/2;
	threshold 0.01
#local i=coin1.x;
#while (i<coin2.x)

	#local j=coin1.z;
	#while (j<coin2.z)

		#local Start = <i+incx*rand(stn), 500, j+incz*rand(stn)>;
		#local coef1=vlength(eval_pigment(PPat, Start));
		#if (coef1 > 0.70)

			#local Norm = <0,0,0>;
			#local Intersect = trace (ArretBus, Start, -y, Norm);
			
			#if (((Norm.x!=0) | (Norm.y!=0) | (Norm.z!=0)) & (Intersect.y < coin2.y))
				#if (abs(vdot(Norm, y))>(.30+.2*vlength(eval_pigment(PPat, Start*10))))
					sphere {
						#local coef=eval_pigment(PPat, Intersect*40);
						0, 1.5, strength 1 scale <(.6+.4*coef.x), (.3+.7*coef.x)*coef1, (.7+.3*coef.x)>*(1+2*coef.x)
						#if (vdot(Norm, y)<1.0)
						Reorient(y, Norm)
						#end
						translate Intersect
					}
				#end
			#end
		#end

		#local j=j+incz;
	#end
	#local i=i+incx;

#end
	texture {
		pigment { color rgb 1 }
		normal { granite .8 scale .2 }
		finish { brilliance .5 specular .5 roughness .001 }
	}
	 translate <90,10, -250>
}



#debug "\nit stops snowing !!!\n"

#end

#undef ObjectBlob
#undef Banc
#undef ArretBus


//==========================
// pingouins
//==========================

#if (Use_Penguin)

#include "pingouin.pov"

object{ Pingouin
	translate OBJuvPOVminY*y
	scale 120/(OBJuvPOVmaxY-OBJuvPOVminY)
	rotate -y*10
	translate <50, 10, -270>
}

#include "penguin2.pov"

object{ Penguin2
	translate OBJuvPOVminY*y
	scale 115/(OBJuvPOVmaxY-OBJuvPOVminY)
	rotate -y*75
	translate <-240, 10, -120>
}

object{ Penguin2
	scale <-1,1,1>
	translate OBJuvPOVminY*y
	scale 123/(OBJuvPOVmaxY-OBJuvPOVminY)
	rotate -y*165
	translate <70, 10, -60>
}

#undef Pingouin
#undef Penguin2

#end


