#version unofficial megapov 0.72;

// poteau arret de bus

#local LargPot = 20;

#local Temp = (1-sqrt(2)/2);

#local Trans1 = transform{
		matrix< 1,0,0,
				0,1,-7/40,
				0,0,1,
				0,0,0>
}
#local Trans2 = transform{
		matrix< 1,0,0,
				0,1,7/40,
				0,0,1,
				0,0,0>
}


#declare Arret1 = union {
	cylinder{<-LargPot, 0, -15>, <LargPot, 0,-15>, 2.5 translate <0,4*Temp,4*Temp>}
	cylinder{<-LargPot,40, -15>, <LargPot,40,-15>, 2.5 translate <0,-4*Temp,4*Temp>}
	cylinder{<-LargPot, 0,  15>, <LargPot,0, 15>, 2.5  translate <0,4*Temp,-4*Temp>}
	cylinder{<-LargPot, 40, 15>, <LargPot,40,15>, 2.5  translate <0,-4*Temp,-4*Temp>}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,-7.01,-7.01>}
		translate <-LargPot, 4, -15+4>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,-7.01,-7.01>}
		translate <LargPot, 4, -15+4>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,-7.01,-7.01>}
		translate <-LargPot, 4, -15+4>
		scale <1,1,-1>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,-7.01,-7.01>}
		translate <LargPot, 4, -15+4>
		scale <1,1,-1>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,7.01,-7.01>}
		translate <-LargPot, 40-4, -15+4>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,7.01,-7.01>}
		translate <LargPot, 40-4, -15+4>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,7.01,-7.01>}
		translate <-LargPot, 40-4, -15+4>
		scale <1,1,-1>
	}
	intersection{
		torus{4,3 rotate z*90}
		box{<-3.01,0,0>,<3.01,7.01,-7.01>}
		translate <LargPot, 40-4, -15+4>
		scale <1,1,-1>
	}
	cylinder{<-LargPot,4,-15>, <-LargPot,40-4,-15>,3}
	cylinder{< LargPot,4,-15>, < LargPot,40-4,-15>,3}
	cylinder{<-LargPot,4, 15>, <-LargPot,40-4, 15>,3}
	cylinder{< LargPot,4, 15>, < LargPot,40-4, 15>,3}
	cylinder{<-LargPot,0,-15+4>, <-LargPot,0,15-4>,3}
	cylinder{< LargPot,0,-15+4>, < LargPot,0,15-4>,3}
	cylinder{<-LargPot,40,-15+4>, <-LargPot,40,15-4>,3}
	cylinder{< LargPot,40,-15+4>, < LargPot,40,15-4>,3}
	texture{
		pigment{color rgb <0.282,0.149,0.016>*.7}
		normal{granite .3 scale .01}
		finish{brilliance 2 diffuse 1.5 reflection_min .1 reflection_max .6 reflection_falloff 2}
	}
}


#declare Arret2 = union{
	intersection {
		object{Arret1}
		box {<-LargPot-3.1,-3.1,-18.1>,< LargPot+3.1,43.1,8>}
		transform{Trans1}
/*
		matrix< 1,0,0,
				0,1,-5/40,
				0,0,1,
				0,0,0>
*/
	}
	intersection {
		object{Arret1}
		box {<-LargPot-3.1,-3.1,-8>,< LargPot+3.1,43.1,18.1>}
		transform{Trans2}
/*		matrix< 1,0,0,
				0,1,5/40,
				0,0,1,
				0,0,0>
*/	}
	// cotes verts
	union{
		box{<LargPot+.5,0,-14>,<LargPot-.5,40,10>
		transform{Trans1}
/*			matrix< 1,0,0,
				0,1,-5/40,
				0,0,1,
				0,0,0>
*/		}
		box{<LargPot+.5,0,-10>,<LargPot-.5,40,14>
		transform{Trans2}
/*			matrix< 1,0,0,
				0,1,5/40,
				0,0,1,
				0,0,0>
*/		}
		box{<-LargPot-.5,0,-14>,<-LargPot+.5,40,10>
		transform{Trans1}
/*			matrix< 1,0,0,
				0,1,-5/40,
				0,0,1,
				0,0,0>
*/		}
		box{<-LargPot-.5,0,-10>,<-LargPot-.5,40,14>
		transform{Trans2}
/*			matrix< 1,0,0,
				0,1,5/40,
				0,0,1,
				0,0,0>
*/		}
		texture{
			pigment{
				image_pattern{tga "num12" once}
				pigment_map{
					[.1 color rgb <0.404,0.820,0.698>]
					[.1 color rgb 1]
					[.4 color rgb 1]
					[.4 color rgb <0.831,0.294,0.161>]
					[.8 color rgb <0.831,0.294,0.161>]
					[.8 color rgb .1]
				}
				translate -.5*x-.5*y
				scale <25, 25, 1>
				rotate -y*90
				translate <0,20,0>
			}
			normal{granite .1 scale .01}
		}
	}
	// cotes bleus
	union {
		box{<-LargPot+1,0,-15.5>,<LargPot-1,40,-14.5>
		transform{Trans1}
/*			matrix< 1,0,0,
					0,1,-5/40,
					0,0,1,
					0,0,0>
*/		}
		box{<-LargPot+1,0,15.5>,<LargPot-1,40,14.5>
		transform{Trans2}
/*			matrix< 1,0,0,
					0,1,5/40,
					0,0,1,
					0,0,0>
*/		}
		texture{
			pigment{
				image_pattern{tga "station" once}
				pigment_map{
					[.5 color rgb <0.086,0.227,0.506>]
					[.5 color rgb 1]
				}
				translate -.5*x-.5*y
				scale <LargPot*1.6, 15, 1>
				translate <0,20,0>
			}
			normal{granite .1 scale .01}
		}
	}
}


#undef Arret1

#declare ArretBus=union{
	object{Arret2 translate 220*y}
	cylinder{0, 220*y, 4}
	box{<-LargPot+2,-.2,-14>, <LargPot-2, 0, 14> translate 220*y}
	box{<-LargPot+2,40.2,-14-7>, <LargPot-2, 40, 14+7> translate 220*y}
	texture{
		pigment{color rgb <0.282,0.149,0.016>*.7}
		normal{granite .3 scale .1}
		finish{brilliance 2 reflection_min .1 reflection_max .5 reflection_falloff 2}
	}
}

#undef Arret2

/*
background { color rgb <0, 0, 0> }

camera {
	location <56.405, 50.412, -48.412>*4
	angle 30	
	look_at <0,20,0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

object{Arret2}
*/
