#include "colors.inc"
#include "maketree.pov" 
#include "textures.inc"

//=========================================
// Camera & light
camera {
location <0, 20 , -100>
direction z
up y
right 4*x/3
look_at   <3,15,0> 
angle  50
}
light_source{ <0, 4 , -100> color White*0.8  shadowless}
light_source{<0,50,48> color White*.7 shadowless}
light_source{<-50,30,48> color White*.9}
//=========================================

//=========================================
//=========================================
// parametres generaux

//=========================================
// montagne
#declare Mounts = object{height_field{ gif "plasma3.gif" smooth} 
                          texture{ pigment { White } 
			  finish { ambient .7 diffuse .2 crand 0.05}  }}
			  
//=========================================
// chapeau			  
#declare hat_texture = texture { pigment {Gray95}
                                 finish {ambient .1 diffuse .1}} 
//=========================================
// coal
#declare coal = sphere {<0,0,0> .17 pigment { Gray90 } scale <1,1,.5>
  normal { bumps 1 scale 0.05 }}  				     			  
//=========================================
// Neige au sol
#declare neige101 = 
  object { blob {
   threshold 0.5
  component 1,.6,  <-2.5, .5,  0>   component 1,1    <2.5,  0,  -2>
  component 1,1,   <-2,   .4,  0>   component 1,1.3, <2,    0,  -2>
  component 1,1.2, <-1.5,  0,  0>   component 1,.8,  <1.2,  .3, -2>
  component 1,1.1, <0,     0,  0>   component 1,1.1, <0,    0,  -2>
  component 1,.8,  <1.2,  .3,  0>   component 1,1.2, <-1.5, 0,  -2>
  component 1,1.3, <2,     0,  0>   component 1,1,   <-2,   .4, -2>
  component 1,1    <2.5,   0,-.5>   component 1,2,   <-2.5, .5, -2>
  component 1,.8,  <1.,   .3, -1>   component 1,.8,  <1.2,  .3, .5>

 texture { pigment { White } finish { ambient .8 diffuse .3 crand 0.07}}}
 } 
#declare neigesol = 
union{
object { neige101 scale <10,0,10>}
object { neige101 scale <15,0,15> rotate <0,90,0> translate <10,0,-20>}
object { neige101 scale <15,0,10> rotate <0,-90,0> translate <20,0,0>}
object { neige101 scale <15,0,10> rotate <0,-180,0> translate <0,0,-60>}
}
//=========================================
// flamme
#declare flamme = union{
difference{sphere{0, 0.5} sphere{<0, -0.3, 0>, 0.35} hollow
        pigment{ rgbt 1}
        interior{ media{ emission rgbf <4, 1.5, 0, 0.2>
                         density{ cylindrical color_map{
                                  [0.3 rgb 1]
                                  [1 rgb <0.2, 0.2, 4>]}
                                  turbulence 0.3}}}
        scale<.7, 2.5, .7>
        translate <0, 0, 0>}                                                                                                                                  
difference{sphere{0, 0.5} sphere{<0, -0.3, 0>, 0.35} hollow
        pigment{ rgbt 1}
        interior{ media{ emission rgbf <4, 1.5, 0, 0.2>
                         density{ cylindrical color_map{
                                  [0.3 rgb 1]
                                  [1 rgb <0.2, 0.2, 4>]}
                                  turbulence 0.3}}}
        scale<.7, 2.5, .7>
        translate <.45, 0, 0>}
difference{sphere{0, 0.5} sphere{<0, -0.3, 0>, 0.35} hollow
        pigment{ rgbt 1}
        interior{ media{ emission rgbf <4, 1.5, 0, 0.2>
                         density{ cylindrical color_map{
                                  [0.3 rgb 1]
                                  [1 rgb <0.2, 0.2, 4>]}
                                  turbulence 0.15}}}
        scale<.7, 2.5, .7>
        translate <.23, .3, 0>}
}


//=========================================
// bonhomme de neige
#declare SnowMan = union {
//body
sphere { <0, 1.9, 0> 2  scale <1,.9,1> }
object { object { coal translate <0,0,-2> }
                       rotate x*30 translate y*1.9 }
object { object { coal translate <0,0,-2> }
                       rotate x*10 translate y*1.9 }
sphere { <0,  4.4,  0> 1.2 scale <1,.9,1> }
object { object { coal translate <0,0,-1.2> } rotate x*30
                       translate y*4.4 scale <1,.9,1> }
object { object { coal translate <0,0,-1.2> }rotate x*0
                       translate y*4.4 scale <1,.9,1> }
object { torus {1.5,.3} scale <1,.6,1> rotate x*90 translate <0,3.2,0> }
//head
sphere { <0, 5.7, 0> .8 }
object { object { coal scale <.7,.7,.3> translate <0,0,-.8> }
                       rotate <20,20,0> translate y*5.7 }
object { object { coal scale <.7,.7,.3> translate <0,0,-.8> }
                       rotate <20,-20,0> translate y*5.7 }
object { object { coal scale .2 translate <0,0,-.8> }
                       rotate <-27,-20,0> translate y*5.7 }
object { object { coal scale .2 translate <0,0,-.8> }
                       rotate <-29,-10,0> translate y*5.7 }
object { object { coal scale .2 translate <0,0,-.8> }
                       rotate <-30, 0, 0> translate y*5.7 }
object { object { coal scale .2 translate <0,0,-.8> }
                       rotate <-29, 10,0> translate y*5.7 }
object { object { coal scale .2 translate <0,0,-.8> }
                       rotate <-27, 20,0> translate y*5.7 }
//hat with snow ellipsoids
disc { <0,6.3,0> <0,1,.1> 1 texture { hat_texture }}
object { sphere {<0,0,0> .95 } clipped_by { plane{-y,0} }
         scale <1,.15,1> rotate x*10 translate y*6.3 }
cylinder { <0,6.3,0><0,7.0,.07> .6 texture { hat_texture }}
object { sphere{<0,0,0> .59 } scale <1,.15,1> rotate x*10 translate y*7 }
//nose
cone { <0,  5.7,-.7> .15 <0,5.4,-1.3> 0  pigment { Red }}

 pigment { color White} finish { ambient .7 diffuse.3 reflection 1}
 normal { bumps 0.6 scale 0.2 }
 }
 

//=========================================
//-----------------------------------------
// texture du tronc
#declare mar=rgb <.4,0.25,0.0>;
#declare tronc_1=texture{pigment{radial turbulence 0.3 color_map{[0 color White][0.1 color mar*1.1][0.3 color <1,1,1>][0.4 color <1,1,1>][0.8 color mar] [1 color mar*.9]}}       
finish{ambient 0.1 crand 0.4}}  
 
//=========================================
// parametres de la macro MakeTree
//-----------------------------------------
#declare dofile=false;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree1.inc" // file name for tree
#declare fvname="gtfoliage1.inc" // file name for foliage
#declare ffname="gtleaf1.inc" // file name for leaf
#declare txtTree=texture{tronc_1} // texture de tronc enneige

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=1684;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// parametres sur la structure de l'arbre     
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=7;      // recursion level
#declare nseg0=15;       // initial number of branch segments (decreases of one at each level)
#declare nb=4;          // max number of branches per level
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=25;        // longueur initial de la branche
#declare rb0=2;         // rayon initial de la branche
#declare ab0=35;        // angle entre le tronc et la 1 branche
#declare qlb=0.67;       // branch length decrease ratio (1=constant length)
#declare qrb=0.59;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.88;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=1; // probability of branch apparition 
#declare jb=0.6;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.25;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // proba brindille sur le tronc

#declare v0=<0,.9,0>;    // direction initiale du tronc
#declare pos0=<-31.8,-1,-24>;  // position initial du tronc

//-----------------------------------------
// parameters de force
//-----------------------------------------
#declare vpush=<0,-1,0>;// direction de la force (vent, gravite) <0,-1,0> = gravite
#declare fpush=0.3;       // intensite de la force
#declare aboveground=2; // hauteur min des branches 
#declare belowsky=140;  // hauteur max des branches 

//-----------------------------------------
// parametre des racines
//-----------------------------------------
#declare rootproba=0;   // probabilite d'avoir une racine
#declare nroot=5;      // nb de racines
#declare vroot=<1,0,0>; // direction initial des racines 
#declare yroot=<0,0.5,0>;   // position initial des racines

//-----------------------------------------
// parametres sur la position des feuilles
//-----------------------------------------
#declare leafproba=0;   // probabilite de feuille 
#declare leaflevel=3;   // niveau ou les feuille apparaissent 
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.1;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// parametres sur la structure des feuilles
//-----------------------------------------
#declare lsize=0.3;     // taille de la feuille
#declare seg=7;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=1.5;         // longueur des feuilles
#declare wl=1.5;         // largeur des feuilles 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=2;          // longueur des tiges (0=pas de tiges)
#declare ws=0.12;       // largeur des tiges
#declare as=10;         // stalk bending angle : the stalk bends forward


//=========================================
//=========================================
//fin des parametres
//======================================
//fog
fog {fog_type 1    // Constant
 distance 10
color <.8,.8,.8,0,0.7>}



//=========================================
// arbre


object{
      /*  #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        }
        
        #end */             
        MakeTree()
}

//======================================
//neige au sol

object {neigesol}
object {neigesol scale <5,0,5> translate <0,0,-100> rotate <0,180,0>}
plane  {y,-0.09 texture {pigment {color rgb <1,1,1>}
       finish {ambient .8 diffuse .2 crand .05}}}
      

//======================================
//ciel
sky_sphere
{ 
  pigment
  {
    gradient y turbulence .9
    color_map { 
    	[0.0 color rgb <.8,.8,.8>]
    	[0.075 color rgb <.8,.8,.8>]
    	[0.275 color rgb <1,1,1>] 
	[0.5 color rgb<.8,.8,.8>]
	[.92 color rgb<.8,.8,.8>]
	[1 color rgb<.8,.8,.8>]

    }
    rotate x*19
    rotate y*-10 
    scale .5
  }
}
// bonhomme de neige
object { SnowMan scale 1.6 rotate y*320 translate <0,-.5,-23> }


//montagne
object{ Mounts translate <-.5,-.5,-.5>    
                rotate <0,20,0>                     
                scale <410,100,200>   
                translate <150,-15,165> 
} 
// feu de bois  
object { flamme scale 2 translate <4, 1.3, -27> finish {ambient 1}}
light_source {
   <4, 30, -40>
   color rgb <3, 1.5, 0>
   spotlight
   point_at <4, 0, -27>
   radius 180
   falloff 180
   tightness 100
}

cone{ < 4 ,.2 , -27 > .6                   
< 5 , .2 , -30 > .8                  
texture {tronc_1} } 
cone{ < 4 ,.2 , -27 > .6                   
< 7 , .2 , -27 > .8                  
texture {tronc_1} } 
cone{ < 4 ,.2 , -27 > .6                   
< 2 , .2 , -27 > .8                  
texture {tronc_1} } 
