#version 3.5;
                
global_settings {
        assumed_gamma 1
        max_trace_level 20
        noise_generator 2
}        

//_________________________________________________________________________________

#declare camlocation = <0,0.5,-10>;
#declare camlookat   = <0,2.2,0>;
#declare lightsource = <42,50,100>;

camera {ultra_wide_angle location camlocation right x*16/9 look_at camlookat angle 85}

light_source {
        camlocation, 
        0.1 
        shadowless
}
light_source {
        lightsource,
        <1,0.836*0.836,0.567*0.567>*2.4 
        area_light <0.5,0,0> <0,0.5,0> 3,3 adaptive 0 jitter circular orient         
} 

//_________________________________________________________________________________
        
#declare ftname = "frost2d.inc"
#warning concat (ftname," frost2d file creation start\n")
#fopen filehandle ftname write

#declare frosted_Min = <-11.217499,-153.474274,-37.996140>;
#declare frosted_Max = <33.652115,-125.270081,151.581512>;

#declare ice = 
sphere {
       0 0.3 scale <0.3,0.3,0.7>*2
       texture {
                pigment {color rgbft <1*1.5,0.836*1.5,0.567*1.5,0.1,0.7>}
                normal {wrinkles 1 scale 0.01}
                finish {ambient 0.025 diffuse 0.4 specular 40 metallic}
       }
       interior {ior 1.59}
       double_illuminate          
}

#include "frost2c.inc"

#declare frosted =
union {
        object {#include "plant1b.inc"}
        object {abf}
}

#local rfac = 97698*2;
#local randx = seed(60410+rfac*3);  
#local randy = seed(30195+rfac*565);
#local randz = seed(27419+rfac*9);
#local randx1 = seed(60410+rfac*4);  
#local randy1 = seed(30195+rfac*465);
#local randz1 = seed(27419+rfac*8);
#local randx2 = seed(60410+rfac*3);  
#local randy2 = seed(30195+rfac*365);
#local randz2 = seed(27419+rfac*7);

#declare Count = 0;
#while (Count < 16200)
        #declare start_point = <rand(randx)-0.5,rand(randy)-0.5,rand(randz)-0.5>*400; 
        #declare end_point = <       
                rand(randx1)*(frosted_Max.x-frosted_Min.x)+frosted_Min.x,
                rand(randy1)*(frosted_Max.y-frosted_Min.y)+frosted_Min.y,
                rand(randz1)*(frosted_Max.z-frosted_Min.z)+frosted_Min.z>;
        #declare Inter = trace(frosted,start_point,end_point-start_point,end_point);
        #if (end_point.x != 0|end_point.y != 0|end_point.z != 0)
                #declare frosted =
                union {
                        object {frosted}
                        #declare rand_rot2 = <rand(randx2)-0.5,rand(randy2)-0.5,rand(randz2)-0.5>*30;
                        #declare rand_rot = end_point-start_point*360;
                        object {ice rotate rand_rot translate Inter}
                }
                #declare Count = Count+1;
                #debug concat(str(Count,0,0),"\n")
                #write (filehandle,"object {ice rotate <",rand_rot.x+rand_rot2.x,",",rand_rot.y+rand_rot2.y,",",rand_rot.z+rand_rot2.z,"> translate <",Inter.x,",",Inter.y,",",Inter.z,">} // ",Count,"\n")
        #end 
        
#end

object {
        frosted
        translate y*129
        rotate x*-85
        translate y*37.99614
        scale 0.02
        rotate z*-15
        translate <-1.7,-1.5,-8.5>
}
