/*
   ----------------         Winter - IRTC Competition           ------------------------ 
   ----------------                frosted.pov                  ------------------------
   ----------------               3o.April 2001                 ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.5;
                
global_settings {
        assumed_gamma 1
        max_trace_level 20
        noise_generator 2
}        

//_________________________________________________________________________________

#declare camlocation = <0,0.5,-10>;
#declare camlookat   = <0,2.2,0>;
#declare lightsource = <42,50,100>;

camera {ultra_wide_angle location camlocation right x*16/9 look_at camlookat angle 85}

light_source {
        camlocation, 
        0.1 
        shadowless
}
light_source {
        lightsource,
        <1,0.836*0.836,0.567*0.567>*2.4 
        area_light <0.5,0,0> <0,0.5,0> 3,3 adaptive 0 jitter circular orient         
} 

sky_sphere {
        pigment {
                gradient y 
                color_map {
                        [0 rgb <1,0.25,0>]
                        [1 rgb <1,0.6,0.15>]
                }
        }
        translate y*-0.1
}

//_________________________________________________________________________________

//      definitions
#declare atmosphere1   = 1;
#declare atmosphere2   = 1; 
#declare sun           = 1;  

#declare ground1       = 1; 
#declare water1        = 1;
#declare main1         = 1; 
#declare vegetation1   = 1;


//      atmosphere
#if (atmosphere1 = 1)

#macro container (P1,Rad1,Ran1,E1)

#local abc = seed(Ran1);
#local R1 = (rand(abc)*360);
#local R2 = (rand(abc)*360);
#local R3 = (rand(abc)*360);
sphere {
        <0,0,0>,3 
        pigment {color rgbf <1,1,1,1>}
	interior {
  	        media {
    	  	        emission E1*0.006
      			density {
        			spherical
        			poly_wave 0.5
	        		turbulence 1
    	    		        color_map {
        	  		        [0   color rgb 0.000*<1,0.3+0.2,0.25+0.2>]
          			        [0.1 color rgb 0.110*<1,0.2+0.2,0.2+0.2>]
					[0.2 color rgb 0.165*<1,0.3+0.2,0.2+0.2>]
					[0.4 color rgb 0.130*<1,0.2+0.2,0.2+0.2>]
					[0.6 color rgb 0.165*<1,0.25+0.2,0.2+0.2>]
          			        [0.9 color rgb 0.265*<1,0.3+0.2,0.35+0.2>]
					[1   color rgb 0.336*<1,0.1+0.2,0.2+0.2>]					
    	    		        }
				rotate <R1,R2,R3>
	      		}
    		}
  	}
	scale Rad1*40
	translate P1
	hollow
}
#end

container (<0,20-15,40-27>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,20,13,1)
container (<10,20-15,30-27>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,20,31,1)
container (<-10,15-15,30-27>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,15,11,0.5)
container (<-2,5-15,7-27>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,10,101,0.5)

#macro container2 (P1,Rad1,Ran1,E1)

#local abc = seed(Ran1);
#local R1 = (rand(abc) * 360);
#local R2 = (rand(abc) * 360);
#local R3 = (rand(abc) * 360);
sphere {
        <0,0,0>,3 
        pigment {color rgbf <1,1,1,1>}
	interior {
	        
	        media {
	                absorption rgb 0.01*<0.5,0.75,1>
      			density {
        			spherical
        			poly_wave 0.5
	        		turbulence 1
    	    		        color_map {
        	  		        
        	  		        [0   color rgb 0.0]
          			        [0.1 color rgb 0.2]
					[0.2 color rgb 0.0]
					[0.4 color rgb 0.2]
					[0.6 color rgb 0.0]
          			        [0.9 color rgb 0.2]
					[1   color rgb 0.0]
    	    		        }
				rotate <R1,R2,R3>*1.534
				scale 2*1.3
	      		}	                       
	        }
  	}
	scale Rad1*30
	translate P1
	hollow
}
#end

container2 (<0,20-15+20,40-27-5>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,20,13,1)
container2 (<10,20-15+20,30-27-5>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,20,31,1)
container2 (<-10,15-15+20,30-27-5>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,15,11,0.5)
container2 (<-2,5-15+20,7-27-5>*40+<172.665,-370.546,2.110>+(<172.665,-370.546,2.110>-<320.087,219.961,106.195>)*-0.5,10,101,0.5)

#end 

#if (atmosphere2 = 1)

difference {
        sphere {<0,0,30> 0.44 translate <0,0,-30> scale <200,46,200> translate <0,0,30>}
        sphere {camlocation 0.4}
        hollow
        material {
                texture {      
                        pigment {rgbf 1}
                }
                interior {
                        media {
			        scattering {3,0.01}
                                density {
                                        bozo scale 0.1*<200,46,200> 
                                        density_map {
                                                [0.3 rgb 1.0]
                                                [0.7 rgb 0.4]
                                        }
                                }
                                density {planar scale 0.3*<200,46,200> turbulence 0.5}
                        }                        
                }
        }
}

#end

//      sun
#if (sun = 1)

sphere { 
        <0,0,0>,6 
        pigment {color rgbt 1}
        interior { 
                media { 
                        intervals 3 
                        samples 1,1
                        emission 1
                        density { 
                                spherical
                                density_map {
                                        [0   color rgb 0.0]
                                        [0.3 color rgb 0.1]
                                        [1   color rgb 1.0]
                                }
                                scale 4.99
                        }
                        density { 
                                bozo
                                density_map {
                                        [0   color rgb 0.00]
                                        [0.7 color rgb 0.01]
                                        [1   color rgb 1.00]
                                }
                                scale 0.5
                                warp {turbulence 0.6 omega 0.8}
                                color_map {
                                        [0   color rgb <0.05,0,0>]
                                        [0.1 color rgb <0.5,0,0>]
                                        [1   color rgb <1,0.25,0>]
                                }
                        }
                }
                media {
                        intervals 3
                        samples 1,1
                        emission 1
                        density { 
                                spherical
                                density_map {
                                        [0   color rgb 0.0]
                                        [0.1 color rgb 0.2]
                                        [0.3 color rgb 0.5]
                                        [1   color rgb 1.0]
                                }
                                scale 5.8
                        }
                        density { 
                                bozo
                                density_map {
                                        [0     color rgb 0.00]
                                        [0.99  color rgb 0.01]
                                        [0.995 color rgb 1.00]
                                }
                                scale 0.5
                                warp {black_hole <0,0,0>,6 strength 3} 
                                warp {turbulence 0.2 omega 0.4} 
                                color_map {
                                        [0    color rgb <0.002,0,0>]
                                        [0.98 color rgb <0.02,0,0>]
                                        [0.99 color rgb <1,0,0>]
                                        [1    color rgb <2,1,0>]
                                }
                        }
                }
        }        
        hollow
        scale <2.8,2.8,1>
        translate (lightsource-camlocation)*1.1+camlocation
} 

#include "sunrays.inc" 

#end      

//____________________________________________________________________________________

//      ground
#if (ground1 = 1)

#declare ground_tex = 
texture {
        pigment {color rgb <0.3,0.27,0.2>}
}
texture {
        pigment { 
                granite 
                color_map {
                        [0    color rgb <0.945, 0.863, 0.396+0.15>/4]
                        [0.11 color rgbf<0.953, 0.678, 0.404+0.15, 0.086*4>/4]
                        [0.24 color rgbf<0.886, 0.651, 0.157+0.15, 0.329*4>/4]
                        [0.49 color rgb <0.910, 0.588, 0.220+0.15>/4]
                        [0.78 color rgbf<0.933, 0.784, 0.627, 0.196*4>/4]
                        [1    color rgbf<1.000, 1.000, 1.000, 0.996*4>/4]
                }
        }
}
texture {
        pigment { 
                granite 
                turbulence 0.49 
                color_map {
                        [0    color rgbf<0.549, 0.369, 0.024+0.15, 0.388*4>/4]
                        [0.20 color rgb <0.961, 0.773, 0.341+0.15>/4]
                        [0.52 color rgbf<0.655, 0.365, 0.086+0.15, 0.098*4>/4]
                        [0.75 color rgbf<0.918, 0.647, 0.349+0.15, 0.369*4>/4]
                        [1    color rgbf<0.439, 0.275, 0.027+0.15, 0.729*4>/4]
                }
                scale 0.5
        }
}

union {
        height_field { 
                png "hf_lake3" 
                        smooth         
                        translate -0.5
                        scale <80,5,80>
                        translate <0,-1.9,30>
        }                
        height_field { 
                png "hf_lake" 
                        smooth         
                        translate -0.5
                        scale <-80,5,80>
                        translate <-80,-1.9,30>
        }
        height_field {        
                png "hf_lake" 
                        smooth         
                        translate -0.5
                        scale <-80,5,80>
                        translate <80,-1.9,30>
        }
        height_field { 
                png "hf11" 
                        smooth         
                        translate -0.5
                        scale <480,20,240>
                        translate <0,7,190>
        }                                                                                                     
        texture {ground_tex scale 10}
        normal {granite 0.25 scale 10}
        finish {ambient 0.01 diffuse 0.7 phong 0.05 crand 0.5}
} 
#end

//      water
#if (water1 = 1)
plane {
        y,-3.5 
        hollow  
        material {
                texture {
                        pigment {color rgb 0.1} 
                        normal {
                                bozo 0.5 
                                warp {turbulence 0.5 omega 0.5 octaves 9 lambda 1.5} 
                                scale 20 
                                warp {turbulence 0.6 omega 0.6 octaves 5 lambda 2.25}
                                no_bump_scale 
                                scale 0.05
                        }
   
                        finish {
                                ambient 0
                                diffuse 0.2
                                reflection {0.03,0.92 fresnel on}
                                specular 1.5 roughness 0.0003  
                        }
                } 
                interior {ior 1.334}
        }       
}
#end

//____________________________________________________________________________________

//      vegetation
#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#if (main1 = 1)
        #include "tree1.inc"
        #include "frosted_dragonfly3.inc"
        #include "frosted_plant2.inc" 
        #include "frosted_grass2.inc" 
#end

#if (vegetation1 = 1)
        #include "bush1.inc"
        #include "veg1.inc"

        #include "bush2.inc"
        #include "veg2.inc"

        #include "bush3.inc"
        #include "veg3.inc"         

        #include "bush4.inc"
        #include "veg4.inc"     

        #include "tree2.inc"
        #include "veg5.inc" 

        #include "tree3b.inc"
        #include "veg6.inc"
        #include "veg17.inc"

        #include "tree4.inc"
        #include "veg7.inc"  

        #include "tree5.inc"
        #include "veg18.inc" 
        
        #include "moos.inc"
        #include "veg30.inc"
        #include "veg40.inc"

        #include "grass3.inc"
        #include "veg31.inc"
        #include "veg41.inc" 
        
        #include "grass4.inc"
        #include "veg32.inc" 
        
        #include "reed1.inc"
        #include "veg33.inc"

        #include "reed2.inc"
        #include "veg34.inc"                              
#end 