global_settings {noise_generator 2}        
        
#declare ftname = "veg33.inc"
#warning concat (ftname," veg33 file creation start\n")
#fopen filehandle ftname write

#declare amb = 0;

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#declare hfscalx = 80;
#declare hfscaly = 5;
#declare hfscalz = 80;

#declare hftranx = 0;
#declare hftrany = -1.9;
#declare hftranz = 30;

#include "reed1.inc" 

#declare PigTex   = function {pigment {bumps color_map {[0 rgb 0][1 rgb 1]} scale 4}}
#declare Pigmap1  = function {pigment {image_map {png "hf_lake3g"} rotate x*90 translate -0.5 scale <hfscalx,hfscaly,hfscalz>}}
#declare Land = height_field {png "hf_lake4" smooth translate -0.5 scale <hfscalx,hfscaly,hfscalz>}

#local rfac = 97698*2;
#local eR = seed(60410+rfac*3);  
#local eR2 = seed(30195+rfac*565);
#local eR3 = seed(27419+rfac*9);

#macro veg_macro (G1,G2,Gnum,Maxheight,DispObject,NormMaxAngle)

#local V = 0;

union
{
 #local GW = G2.x-G1.x;
 #local GD = G2.y-G1.y;
 #while(V < Gnum)
  #local X = rand(eR)*GW;
  #local Z = rand(eR)*GD;
  #local CMap = (Pigmap1(X,0,Z));
  #local CRota = (PigTex(X,0,Z));                      
    #if ((CMap.x*.3333+CMap.y*.3333+CMap.z*.3333) > 0.01)                                  
     #local ab = (1+rand(eR3))/1.5*0.55;
     #local ac = 360*(rand(eR)-0.5);//(CRota.x*360)+(rand(eR)*8-4);
     #local ad = 20*(rand(eR)-0.5);
     #local ae = 20*(rand(eR)-0.5);
     #local af = X+G1.x;
     #local ag = -1.6-ab*(rand(eR3)+0.5);
     #local ah = Z+G1.y;
     object {veg33
        scale ab
        rotate y*ac
        rotate z*ad
        rotate x*ae
        translate <af,ag,ah>
        //#debug concat("<",vstr(3,<X+G1.x,Inter.y,Z+G1.y>,",",5,3),"> "\n")
        #debug concat(str(V,0,0)," veg placed.\n")
        #write (filehandle,"object {veg33 scale ",ab," rotate y*",ac," rotate <",ad,",0,",ae,"> translate <",af+hftranx,",",ag+hftrany,",",ah+hftranz,"> } // ",V+1,"\n")
     }
   #else
    #local V = V-1; 
   #end
    #local V = V+1;
/*
    #if(mod(V,1)=0)
     #debug concat(str(V,0,0)," veg33 placed.\n")
    #end
*/
   #end     //NormTest
}
#end  

veg_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,30,hfscaly+hftrany+0.01,Land,360)
