// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
//#include "FINISH.INC"   // Some basic finishes
#include "GLASS.INC"    // Glass textures
//#include "METALS.INC"   // Metallic pigments, finishes, and textures
#include "SHAPES.INC"   // Standard objects from POV-Ray's earlier days
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak
#include "chair.inc"
#include "winter.inc"

/* #declare Fire = texture {               warp
  pigment {
    gradient y
    turbulence 0.20
    omega 0.80
    color_map {
      [0.00 color rgb <1.00, 1.00, 1.00>]
      [0.08 color rgbf <0.98, 1.00, 0.02, 0.08>]
      [0.29 color rgbf <1.00, 0.74, 0.01, 0.40>]
      [0.53 color rgbf <1.00, 0.16, 0.01, 0.67>]
      [0.79 color rgbf <1.00, 1.00, 1.00, 1.00>]
      [1.00 color rgbf <1.00, 1.00, 1.00, 1.00>]
    }
    scale <3.00, 7.50, 3.00>
  }
  finish {
    ambient 1.00
  }
  translate <0.00, -3.25, 0.00>
}  // */
 
 

camera
{
  location  <0.0 , 10.0 ,-18.0>
  look_at   <0.0 , 10.0 , 0.0>
}

light_source { <0,19,0>  color rgb .9  }         // */

plane { y 0
texture { T_Stone40 } finish {reflection 0}  normal { bumps 0.4 scale 0.6 }

}

object {   //walls
difference {
        box { <30, -1, 22 >, <-30, 25, 20> }  
        box { <10, 0, 19>, <-10, 11, 22.1>}
        } texture {pigment {White }} finish {ambient .5}}
box { <30, -1, -22 >, <-30, 25, -20> texture {pigment {White }}  finish {ambient .45}}  
box { <-32, -1, -20 >, <-30, 25, 20> texture {pigment {White }}finish {ambient .45}}  
box { <22, -1, -22 >, <20, 25, 20> texture {pigment {White }}finish {ambient .40}}  
box { <32, 25, -22 >, <-32, 26, 22> texture {pigment {White }}finish {ambient .50}}  

object {   //right fp side
union {
  difference {
        box { <8,0,17 >, < 12, 10, 32> }
        box { <9,2,16.9>, < 11, 13, 17.5> }
        }
        object { Tile translate <10,4.055,17.5>}
        object { Tile translate <10,8.045,17.5>}
texture { T_Stone14}} }
object {  
union {    //left fp side
  difference {
        box { <-8,0,17 >, < -12, 10, 32> }
        box { <-9,2,16.9>, < -11, 13, 17.5> }
        }
        object { Tile translate <-10,4.055,17.5>}
        object { Tile translate <-10,8.045,17.5>}
texture { T_Stone14}} }
object {         //top
difference {
        box { <-12,10,17 >, < 12, 13, 37>  }
        cylinder { <8,10,17.1>, <10.2,13,17.1> .15 }
        cylinder { <-8,10,17.1>, <-10.2,13,17.1> .15 }
        cylinder { <5,10,17.1>, <6.9,13,17.1> .15 }
        cylinder { <-5,10,17.1>, <-6.9,13,17.1> .15 }
        cylinder { <1.8,10,17.1>, <3.7,13,17.1> .15 }
        cylinder { <-1.8,10,17.1>, <-3.7,13,17.1> .15 }
        cylinder { <0,10,17.1>, <0.7,13,17.1> .15 }
        cylinder { <0,10,17.1>, <-0.7,13,17.1> .15 }
        cylinder { <0,9,23>, <0,20,23> 3}}
        texture {T_Stone14}}
        
box { <-13, 0, 34>,<13, 14, 35> texture{T_Stone14}}     //back wall
box {< 14, 0, 10>,<-14,1.3,30> texture{T_Stone14}}      //hearthstone

object {   // fire grate
union {
cylinder {<6,1.1,20>, < 5.8, 2.3, 22>, .2}      //rf leg
cylinder {<6,1.1,28>, < 5.8, 2.3, 26>, .2}      //rr leg
cylinder {<5.8,2.3,22>, < 5.8, 2.3, 26>, .2}    //f-b brace
cylinder {<-6,1.1,20>, < -5.8, 2.3, 22>, .2}    //lf leg
cylinder {<-6,1.1,28>, < -5.8, 2.3, 26>, .2}    //lr leg
cylinder {<-5.8,2.3,22>, < -5.8, 2.3, 26>, .2}  //f-b brace
cylinder {<5.8,3,18>, < 5.8, 2.3, 22>, .2}      //rf hook
cylinder {<-5.8,3,18>, < -5.8, 2.3, 22>, .2}    //lf hook
cylinder {<5.8,3,30>, < 5.8, 2.3, 26>, .2}      //rr hook
cylinder {<-5.8,3,30>, < -5.8, 2.3, 26>, .2}    //lr hook
cylinder {<3,3,18>, < 3, 2.3, 22>, .2}      //mf hook 1
cylinder {<-3,3,18>, < -3, 2.3, 22>, .2}    //mf hook 2
cylinder {<5.8,2.3,26>, < -5.8, 2.3, 26>, .2}       //l-r back brace  1
cylinder {<5.8,2.3,20>, < -5.8, 2.3, 20>, .2}       //l-r front brace 1
cylinder {<5.8,2.3,23>, < -5.8, 2.3, 23>, .2}       //l-r mid brace 1 
texture {pigment {Black} finish {phong .2}}
}}

box { <-13, 13, 15>, <13, 14, 20> texture {T_Wood8 rotate <0, 90, 0>}}  //mantel

difference{     //logs
        cylinder { <7, 5, 23>, <-1, 5, 23> 1 texture {T_Wood1 rotate <0,90,0>}  
        rotate <0,5,-10> translate < -2.85,0,0>}
        cylinder { <7, 4.2, 22>, <-1, 4.7, 22> 1 texture {Fire}
        rotate <0,5,-10> translate < -2.85,0,0>}
        }
difference {
        cylinder { <7, 5, 23>, <-1, 5, 23> 1.2 texture {T_Wood1 rotate <0,90,0>} 
        rotate <0,5,19> translate < -6.15,-1.8,2>}
cylinder { <7, 4.7, 23>, <-1, 4.2, 22> 1.3 texture {Fire} 
rotate <0,5,19> translate < -6.15,-1.8,2>}
}
cylinder { <7, 5, 23>, <-1, 5, 23> .51 texture {T_Wood1 rotate <0,90,0>} 
rotate <0,10,5> translate < -8.55,-2,-3>}       // */


blob {   //fire & coals
sphere {<1, 4, 22> 1.8, 1.7 }
sphere {<0, 4, 22> 2.4, 2.2 }
sphere {<-1, 4, 23> 1.9 ,1.7 }
sphere {<1.7, 4, 21> 1.8, 2 }
sphere {<2.7, 3.6, 22> 2, 1.7 }
sphere {<-1.7, 4, 21> 1.9, 1.7}
sphere {<-2.7, 3.8, 20> 1.9, 1.7 }
texture {Fire scale .20 }} //end blob
box {<4,1.31,22>, <4.2,1.4,22.1> texture {Fire scale .5}}
box {<5.5,1.31,22>, <5.7,1.4,22.1> texture {Fire scale .5}}
box {<-4,1.31,22>, <-4.2,1.4,22.1> texture {Fire scale .5}}
box {<-3,1.31,26>, <-3.2,1.4,26.1> texture {Fire scale .5}}
box {<4,1.31,22>, <4.2,1.4,22.1> texture {Fire scale .5}}
box {<-4,1.31,19>, <-4.2,1.4,19.1> texture {Fire scale .5}}
box {<1,1.31,24>, <1.2,1.4,24.1> texture {Fire scale .5}}
box {<0.1,1.31,19.5>, <0.5,1.5,19.6> texture {Fire scale .5}}
box {<4,1.31,22>, <4.2,1.4,22.1> texture {Fire scale .5}}
light_source { <-0.1,3.2,24> color Red}
light_source { <0.1,3.2,24> color Yellow}    // */ 

cylinder {<-11, 5, -10>,<-11,4,-10> 10 texture {T_Wood8  scale 2}} //table
union {
difference {   //cup
cylinder {<-3,5,-7>,<-3,6.2,-7> .7 pigment {SkyBlue}}
cylinder {<-3,5,-7>,<-3,6.3,-7> .6 pigment {SkyBlue}}}
cylinder {<-3,5,-7>,<-3,6,-7> .6 pigment {VeryDarkBrown}} //chocolate
torus { .2, .05  pigment {SkyBlue} rotate <90,0,0> scale <1,1.7,1> translate <-2.15,5.7,-7> }
cylinder {<-3.18,5.9,-6.6>,<-3.19,6.1,-6.7>,.1 pigment {White} finish {ambient 1}}
cylinder {<-3.4,5.9,-7>,<-3.42,6.1,-7.1>,.1 pigment {White} finish {ambient 1}}
cylinder {<-2.8,5.9,-7.2>,<-2.82,6.1,-7.3>,.1 pigment {White} finish {ambient 1}}
light_source    { 
<-6, 20, -7>     
  color White *1.5        // light's color
  spotlight               // this kind of light source
  point_at <-3, 5, -7>      // direction of spotlight
  radius 50                // hotspot (inner, in degrees)
  tightness 30            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 120               // intensity falloff radius (outer, in degrees)
}
object {     // steam
sphere {<0,0,0> 2 pigment {rgbf <1,1,1,1>}  interior {
media{
    emission 0.65
    scattering {1, 0.5}
    density { cylindrical //spherical
      color_map{
        [0.0 rgbf <0,0,0,1>]
        [0.25 rgb <0,0,0>]
        [0.28 rgb <.5,.5,.5>]
        [0.32 rgb <0,0,0>]
        [0.70 rgb <0,0,0>]
        [0.74 rgb <.55,.45,.45>]
        [0.84 rgb <0,0,0>]
        [1.0 rgbf <.41,.41,.41,1>]
      }
 turbulence <.6,.8,.6> 
 }
  }

 }
hollow on} 
scale .76 translate <-3,7.2,-7>}    
translate <-1,0,1>}
object {Tools scale .7 translate <11.8,1.3,12.5>}                    
object {Chair scale .3 rotate <0,-35,0> translate <-10,0,1.5> }

object {Candle translate <-8, 14, 17>} 
object {Candle translate <8, 14, 17>} 
object {Clock  scale .5 translate <0,14, 17>}