//rocks to go in the train carts
#declare nRockArraySize = 7;
#declare fRockBiggestRadius = 4;
#declare aoRocks = array[nRockArraySize];
#declare rsSpin = seed(17);

#declare nCreateLoop = 0;
#while ( nCreateLoop < nRockArraySize )

	#declare aoRocks[nCreateLoop] =
			intersection {
				box { -.5, .5 rotate 360*<rand(rsSpin),rand(rsSpin),rand(rsSpin)> }
				box { -.5, .5 rotate 360*<rand(rsSpin),rand(rsSpin),rand(rsSpin)> }
				scale 2*<1,2,1>
				texture {
					pigment {
						spotted
						poly_wave pow(2,2*rand(rsSpin) - 1)
						translate 70*rand(rsSpin)
						scale <.1,1,1>
						warp { turbulence .8 }
						scale 1
						rotate 360*<rand(rsSpin),rand(rsSpin),rand(rsSpin)>
						colour_map {
							[0	rgb <.1,.15,.05>+.7]//+(0.0+0.7*nCreateLoop/(nRockArraySize-1))]
							[1	rgb <.1,.3,.01>/2 + .41/3]//-(0.2*(1 - nCreateLoop/(nRockArraySize-1)))]
						}
					}
					finish {
						specular 0.7 roughness 0.06
					}
				}
			}//box

	#declare nCreateLoop = nCreateLoop + 1;
#end //while



//details on the train.
#declare nTrainDetailArraySize = 10;
#declare aoTrainDetails = array[nTrainDetailArraySize];

//aerial1
#declare aoTrainDetails[0] =
	merge {
		//along y
		cone { 0, 0.1, y, 0.06 }
		cone { y, 0.04, 3*y, 0.04 }
		cone { 3*y, 0.02, 5*y, 0.02 }
		torus { .14,.03 translate y*2 }
		torus { .09,.02 translate y*4 }
		
		scale .4
		
		pigment { rgb .2 }
		finish {
			specular 1
			roughness 0.2
			reflection .4
		}

		//rotate to be along z
		rotate <90,0,0>
	}
//make this object more common than others.
#declare aoTrainDetails[1] = aoTrainDetails[0]
#declare aoTrainDetails[2] = aoTrainDetails[0]
#declare aoTrainDetails[3] = aoTrainDetails[0]

//aerial2
#declare aoTrainDetails[4] =
	merge {
		//along y
		cylinder { 0, y, .01 }
		merge {
			cylinder { -x*.7, x*.7, .007 }
			cylinder { -x*.7-z*.5, -x*.7+z*.5, .004 }
			cylinder { -x*.4-z*.5, -x*.4+z*.5, .004 }
			cylinder { -x*.1-z*.5, -x*.1+z*.5, .004 }
			cylinder { x*.1-z*.5, x*.2+z*.5, .004 } //slightly skewed
			cylinder { x*.4-z*.5, x*.4+z*.5, .004 }
			cylinder { x*.7-z*.5, x*.7+z*.5, .004 }
			rotate <20,0,20>
			translate y
		}
		
		scale 1
		
		pigment { rgb 0 }
		finish {
			specular 1
			roughness 0.2
			reflection .2
		}
		
		//rotate to be along z
		rotate <90,0,0>
	}
//make this object more common than others.
#declare aoTrainDetails[5] = object{ aoTrainDetails[4] rotate 160*y }
#declare aoTrainDetails[6] = aoTrainDetails[0]


//hatch
#declare aoTrainDetails[7] =
	merge {
		difference {		
			cylinder { -z*.2, z*.2, .7 }
			cylinder { z*.2+y, z*.2-y, .08 }
		}
		cone { -z*.2, 1.32 z*.12, 1 }
		//hinges
		box { <-.9,.1,-.2>, <-.3,.2,.23> }
		box { <-.9,-.1,-.2>, <-.3,-.2,.23> }
		box { <.9,.1,-.2>, <.3,.2,.23> }
		box { <.9,-.1,-.2>, <.3,-.2,.23> }
		
		scale <.8,.8,1>
		translate -.08*z

		//no texture, will pick up surface colour.
	}
//hatch with ladder.
#declare aoTrainDetails[8] =
	merge {
		//built so z is facing out.
		object { aoTrainDetails[7] }
		//ladder
		merge {
			#local fLadLen = 2;
			cylinder { <-.6,-.7,.2>, <-.6,-.7,.2> - fLadLen*y, .07 }
			cylinder { <.6,-.7,.2>, <.6,-.7,.2> - fLadLen*y, .07 }
			intersection {
				torus { .14, .07 rotate 90*z }
				plane { -y, 0 } plane { -z, 0 }
				translate -.14*z
				translate <-.6,-.7,.2>
			}
			intersection {
				torus { .14, .07 rotate 90*z }
				plane { -y, 0 } plane { -z, 0 }
				translate -.14*z
				translate <.6,-.7,.2>
			}
			#local fStep = -.2;
			#while ( -fStep < fLadLen )
				cylinder { <-.6,-.7+fStep,.2>, <.6,-.7+fStep,.2>, .05 }
				#local fStep = fStep - .45;
			#end
		
			scale <.8,.8,1>
			translate -.08*z

			texture { tChainMetal }
		}
		
		//no texture, will pick up surface colour.
	}

#declare aoTrainDetails[9] = aoTrainDetails[0]


//train textures
#declare pTrainYellowMarks =
	pigment {
		object {
			m_TextBlock( "cs.TTF", "e", 1, 0, TEXT_ALIGN_SCALE, TEXT_ALIGN_SCALE )
			pigment { pWhitePaint }, pigment { pYellowPaint }
		}
		translate -.5
		scale .9
		translate .5
		warp { repeat x flip x }
		warp { repeat y flip y }
		warp { repeat z }
		scale 3
	}

#declare pTrainBlackMarks =
	pigment {
		object {
			m_TextBlock( "cs.TTF", "e", 1, 0, TEXT_ALIGN_SCALE, TEXT_ALIGN_SCALE )
			pigment { pWhitePaint }, pigment { pBlackPaint }
		}
		translate -.5
		scale .9
		translate .5
		warp { repeat x flip x }
		warp { repeat y flip y }
		warp { repeat z }
		scale 2
	}

#declare pTrainPatternZm =
	pigment {
		m_CellProbStart( 4, 1 )
		pigment_map {
			m_CellProb(.2, pTrainYellowMarks)
			m_CellProb(.2, pTrainBlackMarks)
			m_CellProb(-1, pWhitePaint)
		}
		translate .5
		scale <4,4,1000>
		translate 50
	}

//decals. text and symbols placed randomly over the surface.
#declare pTrainDecal_Numbers =
	pigment {
		object {
			merge {
				m_TextBlock( "asimov.ttf",	"4",	1, 0*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "asimov.ttf",	"6",	1, 1*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "asimov.ttf",	"5",	1, 2*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "asimov.ttf",	"7",	1, 3*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
			}
			rgbt 1, rgb <.7,.04,.0>
		}
		warp { repeat x*4 }
		warp { repeat y offset 1*x }
		warp { repeat z }
	}

#declare pTrainDecal_Symbols =
	pigment {
		object {
			merge {
				m_TextBlock( "lucon.ttf", "\n-+|",	1/2, 0*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", " +-+",		1/2, 1*y, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", "-|-",		1/2, 2*y, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", "\n|+-",	1/2, 3*y, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
			}
			rgbt 1, rgb <1,.7,.4>
		}
		warp { repeat y*4 }
		warp { repeat x offset y*3  }
		warp { repeat z }
	}

#declare pTrainDecal_Text =
	pigment {
		object {
			merge {
				m_TextBlock(
					"kabel.ttf",
					"Ben 4 Emma\nMiss you\nLove you\nNeed you\nWant you\n",
					<1,1,1>/16, 0,
					TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP
				)				
				m_TextBlock(
					"kabel.ttf",
					"Big hugs!\nwuffle\nkisses\nsnogs\nmoo\nme\n",
					<1,1,1>/16, 0,
					TEXT_ALIGN_RIGHT, TEXT_ALIGN_BOTTOM
				)
				m_TextBlock(
					"ariblk.ttf",
					"ATTENTION\n\ntek@evilsuperbrain.com\n4\nmoo@powerofmoo.com\n\nwww.evilsuperbrain.com\nwww.origami4you.com\n",
					<1,1,1>/13, x,
					TEXT_ALIGN_CENTRE, TEXT_ALIGN_CENTRE
				)
				m_TextBlock(
					"asimov.ttf",
					" - \n27375\n - \n",
					.2, x*2,
					TEXT_ALIGN_SCALE, TEXT_ALIGN_CENTRE
				)
			}
			rgbt 1, rgb .2
		}
		warp { repeat x*3 }
		warp { repeat y offset 7*x }
		warp { repeat z }//offset 7*x }
	}

#declare pTrainDecalsZm =
	pigment {
		m_CellProbStart(0,1)
		pigment_map {
			m_CellProb(.07, pTrainDecal_Numbers)
			m_CellProb(.18, pTrainDecal_Symbols)
			m_CellProb(.15, pTrainDecal_Text)
			m_CellProb(-1, rgbt 1)
		}
		translate .5
		scale 1+1000*z
	}

#declare pTrainDecals =
	pigment {
		m_pCubeMap( pTrainDecalsZm, 40, <1,1,1> )
	}

#declare tTrainDirtLayer =
	texture {
		pigment {
			cells
			scale 1.45
			pigment_map {
				[-.6	rgbt 1]
				[.6
					gradient y
					warp {
						turbulence .3
						//octaves 3
					}
					translate -.5
					scale <.1,2,.1>
					translate .5
					poly_wave 2
					colour_map {
						[0	rgbt 1]
						[1	rgb <2,1,0>/8 transmit 0 filter .4]//.3]
					}
					warp { repeat y offset z }
				]
			}
		}
		normal {
			nPanels
			scale 1.45
		}
	}

#declare tTrainFinishLayer =
	texture {
		pigment { rgbt 1 }
		//todo: drybrush pigment (if poss pull transmit trick to actually brighten underlying colour, i.e. multiply and add to)
		finish {
			reflection {
				.03, .07
				//falloff
				//exponent .1
			}
			conserve_energy
			specular 1
			roughness 0.004
		}
		normal {
			nPanels
			scale 1.45
		}
	}


#declare fRadius = .8;
#declare fTrackWidth = 1.3;
#declare vPos1 = <0,.8,3>;
#declare vPos2 = <0,.8,-3>;
#declare vPos3 = <0,2,0>;

#declare vDir1 = vnormalize(vPos2-vPos1);
#declare vDir2 = vnormalize(vPos3-vPos2);
#declare vDir3 = vnormalize(vPos1-vPos3);
#declare vNorm1 = vcross(vDir1,x);
#declare vNorm2 = vcross(vDir2,x);
#declare vNorm3 = vcross(vDir3,x);

/*
#macro m_oTrackTriangle( fWidth, fRadius )
	merge {
		cylinder {
			-fWidth*x + vPos1, fWidth*x + vPos1, fRadius
		}
		cylinder {
			-fWidth*x + vPos2, fWidth*x + vPos2 fRadius
		}
		cylinder {
			-fWidth*x + vPos3, fWidth*x + vPos3, fRadius
		}
		intersection {
			plane { -x, fWidth }
			plane { x, fWidth }
			plane {
				vNorm1, fRadius
				translate vPos1
			}
			plane {
				vNorm2, fRadius
				translate vPos2
			}
			plane {
				vNorm3, fRadius
				translate vPos3
			}
			merge {
				plane { -vDir1, 0 translate vPos1 }
				plane { vDir3, 0 translate vPos1 }
			}
			merge {
				plane { -vDir2, 0 translate vPos2 }
				plane { vDir1, 0 translate vPos2 }
			}
			merge {
				plane { -vDir3, 0 translate vPos3 }
				plane { vDir2, 0 translate vPos3 }
			}
		} //intersection
	} //merge
#end
	
//this train runs on caterpillar tracks! :)
#declare oTrack =
	union {
		//rubber bits
		difference {
			m_oTrackTriangle( .8, 1 )
			m_oTrackTriangle( .9, .9 )
			
			pigment { rgb 0.1 }
		}
		//metal bits
	}
*/

#macro m_oTrackLink(vA, vB)
/*	triangle
	{
		vPos1 + fTrackWidth*x/2, vPos1 - fTrackWidth*x/2, vPos2 + fTrackWidth*x/2
	} 
	triangle
	{
		vPos2 + fTrackWidth*x/2, vPos1 - fTrackWidth*x/2, vPos2 - fTrackWidth*x/2
	} */
	#local vX = fTrackWidth*x/2;
	#local vD = vB - vA;
	#local vP = vrotate( vD, x*90 )/8;
	//#local vA = vA + vD;
	//#local vB = vB + vD;
	
	#if ( vlength(vD) < 1.0 )
		triangle {
			vA + vX + vD + vP, vA + vP, vB + vX + vD
		}
		triangle {
			vB + vX + vD, vA + vP, vB
		}
		triangle {
			vA + vP, vA - vX + vD + vP, vB
		}
		triangle {
			vB, vA - vX + vD + vP, vB - vX + vD
		}
	#end
#end //macro

#declare oTrack =
	union {
		mesh {
			//1/ compute circumference
			//	= 1 circle + straight bits!
			//	straight lengths = dist between points
	
			#local fPanelLength = 0.4;
	
			#local fLength1 = vlength(vPos2-vPos1);
			#local fLength2 = vlength(vPos3-vPos2);
			#local fLength3 = vlength(vPos1-vPos3);
	
			#local fAng1 = acos(vdot(vNorm3,vNorm1));
			#local fAng2 = acos(vdot(vNorm1,vNorm2));
			#local fAng3 = acos(vdot(vNorm2,vNorm3));
			
			#if ( abs(fAng1 + fAng2 + fAng3 - 2*pi) > 0.01 )
				#error concat("angles do not sum to 2pi: ", str(fAng1,0,3), ", ", str(fAng2,0,3), ", ", str(fAng3,0,3), "\n")
			#end
			
			#local fCirc1 = fRadius*fAng1;
			#local fCirc2 = fRadius*fAng2;
			#local fCirc3 = fRadius*fAng3;
	
			#local fCircumference = fLength1 + fLength2 + fLength3;
			#local fCircumference = fCircumference + fRadius*2*pi;
			
			//2/ step round the shape creating a point (2d) for each circ/npoints distance travelled
			//3/ connect each pair of points by constructing a plate.
	
	/*		#while (nPoint < 3)
			
				vPos[nPoint]+vNorm[nPoint]*fRadius;
			
				vPos[mod(nPoint+2,3)]+vNorm[mod(nPoint+2,3)]*fRadius;
			
				do circle
	
				
				vPos[nPoint]+vNorm[nPoint]*fRadius;
	
				vPos[mod(nPoint+1,3)]+vNorm[nPoint]*fRadius;
	
				do line
			
				#local nPoint = nPoint + 1;
			#end*/
			
			#local nPoints = int(fCircumference / fPanelLength);
			
			#local fDist = 0;
			#while ( fDist <= fCircumference + (fCircumference / nPoints)/2 )
	
				#switch ( mod(fDist,fCircumference) )
					#range( 0, fLength1 )
						#local vPos = vPos1 + vDir1*fDist + vNorm1*fRadius;
						#break
					
					#range( fLength1, fLength1 + fCirc2 )
						#local fLocalDist = fDist - fLength1;
						#local vPos = vPos2 + fRadius*vrotate(vNorm1,x*degrees(fLocalDist/fRadius));
						#break
					
					#range( fLength1 + fCirc2, fLength1 + fCirc2 + fLength2 )
						#local fLocalDist = fDist - (fLength1 + fCirc2);
						#local vPos = vPos2 + vDir2*fLocalDist + vNorm2*fRadius;
						#break
					
					#range( fLength1 + fCirc2 + fLength2, fLength1 + fCirc2 + fLength2 + fCirc3 )
						#local fLocalDist = fDist - (fLength1 + fCirc2 + fLength2);
						#local vPos = vPos3 + fRadius*vrotate(vNorm2,x*degrees(fLocalDist/fRadius));
						#break
					
					#range( fLength1 + fCirc2 + fLength2 + fCirc3, fLength1 + fCirc2 + fLength2 + fCirc3 + fLength3 )
						#local fLocalDist = fDist - (fLength1 + fCirc2 + fLength2 + fCirc3);
						#local vPos = vPos3 + vDir3*fLocalDist + vNorm3*fRadius;
						#break
					
					#range( fLength1 + fCirc2 + fLength2 + fCirc3 + fLength3, fLength1 + fCirc2 + fLength2 + fCirc3 + fLength3 + fCirc1 )
						#local fLocalDist = fDist - (fLength1 + fCirc2 + fLength2 + fCirc3 + fLength3);
						#local vPos = vPos1 + fRadius*vrotate(vNorm3,x*degrees(fLocalDist/fRadius));
						#break
	
					#default
						#error "range error"
						#break
					
				#end
				
				#ifdef ( vLastPos )
					
					//create a link
					m_oTrackLink(vLastPos, vPos)
					
				#end
				
				#local vLastPos = vPos;
	
				#local fDist = fDist + (fCircumference / nPoints);
			#end
	
			texture {		
				pigment {
					rgb .45
				}
				finish {
					specular .8
					roughness .04
					reflection .1
				}
				normal {
					spotted
					scale <.05,.5,.5>
				}
			}
			texture {		
				pigment {
					spotted
					scale <.05,.5,.5>
					turbulence .2
					poly_wave 2
					colour_map {
						[0	rgbt <.2,.1,0,1>]
						[1	rgbt <.2,.1,0,0>]
					}
				}
				finish {
					specular .2
					roughness .01
				}
				normal {
					spotted
					scale <.05,.5,.5>
				}
			}
		} //mesh
		
		//wheels
		#local oWheel =
			merge {
				difference {
					cylinder { -fTrackWidth*x/2, fTrackWidth*x/2, fRadius }
					cone { -fTrackWidth*x*3/4, fRadius, -fTrackWidth*x/4, fRadius -.1 }
				}
				
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 }
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 rotate <60,0,0> }
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 rotate <120,0,0> }
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 rotate <180,0,0> }
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 rotate <240,0,0> }
				sphere { -fTrackWidth*x/4 + fRadius*y*.5, .05 rotate <300,0,0> }
				
				bounded_by { cylinder { -fTrackWidth*x/2, fTrackWidth*x/2, fRadius } }
			}
		
		union {
			object { oWheel translate vPos1 }
			object { oWheel translate vPos2 }
			object { oWheel translate vPos3 }

			texture {		
				pigment {
					rgb .45
				}
				finish {
					specular .8
					roughness .04
					reflection .1
				}
				normal {
					spotted
					scale <.05,.5,.5>
				}
			}
			texture {		
				pigment {
					spotted
					turbulence 7*<1,1,0>
					octaves 2
					scale <.05,.5,.5>
					poly_wave 2
					colour_map {
						[0	rgbt <.2,.1,0,1>]
						[1	rgbt <.2,.1,0,0>]
					}
				}
				finish {
					specular .2
					roughness .01
				}
				normal {
					spotted
					scale <.05,.5,.5>
				}
			}
		}
	}//union

//train engine

#declare vEngineHalfDim = <6,4,12>;

#declare oTrainEngineBase =
	merge {
		superellipsoid {
			<.4,.2> //y, xzplane circle 1 square 0
			scale vEngineHalfDim
		}
		sphere {
			0, 1
			scale <5.5, 2.5, 8>
			translate <0, 7.5, -2.5>
			translate -vEngineHalfDim.y*y
		}
	}

#declare pTrainEngineBase =
	pigment {
		m_pCubeMap( pTrainPatternZm, 50, <1,1,1> )
		/*m_CellProbStart( 1.5, <6,4,6>*.3 )
		pigment_map {
			m_CellProb(.1, pYellowPaint)
			m_CellProb(.1, pBlackPaint)
			m_CellProb(-1, pWhitePaint)
		}*/
	}

#declare tTrainEngine =
	texture {
		pigment { pTrainEngineBase }
		finish {
			brilliance 1
		}
		normal {
			nPanels
		}
	}
	texture {
		pigment {
			pTrainDecals
		}
		//todo: drybrush pigment (if poss pull transmit trick to actually brighten underlying colour, i.e. multiply and add to)
		//todo: MAKE INCLUDE AND OBJECTS WITH DIFF DETAILS!
		finish {
			reflection {
				.03, .07
				//falloff
				//exponent .1
			}
			specular 1
			roughness 0.004
		}
		normal {
			nPanels
		}
	}
	texture {
		tTrainDirtLayer
	}
	texture {
		tTrainFinishLayer
	}
	/*texture {
		//lights (also, could rand pos rows of lights, project flat onto obj cull if norm >45 from proj dir, difference lights from obj, texture on inner face (to get lit up) but not on frame.)
		pigment {
			slope { x }
			pigment_map {
				[.25	pWindows rotate 90*y translate 70]
				[.25	pWindows translate 4*8000*z ]
				[.75	pWindows translate 4*8000*z]
				[.75	pWindows rotate -90*y translate -80]
			}
		}
		finish { diffuse .5 ambient .5 }
	}*/

#declare oTrainEngine =
	union {
		object { oTrainEngineBase }
		m_ApplyDetails( oTrainEngineBase, 100, aoTrainDetails, nTrainDetailArraySize, 120, 17, 181 )//171 )
		texture {
			tTrainEngine
			translate -vEngineHalfDim.y*y
		}
		translate vEngineHalfDim.y*y
	}


//train cart.
//I called it cart because I wasn't sure how to spell carraige :)
#declare vCartHalfDim = <6,6,12>;
	
#declare oTrainCartBase =
	intersection {
		superellipsoid {
			<.4,.2> //y, xzplane circle 1 square 0
			scale vCartHalfDim
		}
		superellipsoid {
			<.4,.2> //y, xzplane circle 1 square 0
			scale vCartHalfDim - <.5,.5,.5>
			inverse
		}
		plane { y, 0 }
	}

#declare pTrainCartBase =
	pigment {
		m_pCubeMap( pTrainPatternZm, 100, <1,1,1> )
		/*m_CellProbStart( 1.5, <6,4,6>*.3 )
		pigment_map {
			m_CellProb(.1, pYellowPaint)
			m_CellProb(.1, pBlackPaint)
			m_CellProb(-1, pWhitePaint)
		}*/
	}

#declare tTrainCart =
	texture {
		pigment { pTrainCartBase }
		finish {
			brilliance 1
		}
		normal {
			nPanels
			scale 1.45
		}
	}
	texture {
		pigment {
			pTrainDecals
		}
		normal {
			nPanels
			scale 1.45
		}
	}
	//dirt layer
	texture {
		tTrainDirtLayer
	}
	texture {
		tTrainFinishLayer
	}
	/*texture {
		//lights (also, could rand pos rows of lights, project flat onto obj cull if norm >45 from proj dir, difference lights from obj, texture on inner face (to get lit up) but not on frame.)
		pigment {
			slope { x }
			pigment_map {
				[.25	pWindows rotate 90*y translate 70]
				[.25	pWindows translate 4*8000*z ]
				[.75	pWindows translate 4*8000*z]
				[.75	pWindows rotate -90*y translate -80]
			}
		}
		finish { diffuse .5 ambient .5 }
	}*/


#macro m_oTrainCart(nSeedDetail, nSeedPos)
	//move this outside the macro to improve parse times
	#declare oCacheObj = union { m_PileOfStuffInABox( vCartHalfDim*<1.8,1.8,1.8>, aoRocks, nRockArraySize, fRockBiggestRadius ) }

	union {
		m_ApplyDetails( oTrainCartBase, 100, aoTrainDetails, nTrainDetailArraySize, 120, nSeedDetail, nSeedPos )
		texture {
			tTrainCart
			translate -vCartHalfDim.y*y
		}
		translate vCartHalfDim.y*y
	}
/*	union {
		oCacheObj
	}*/
#end



/*
Train macro

parameters:
vAboveGround - Up vector multiplied by enough to ensure it's above ground, trace will be fired
							from spline point + vAboveGround, in direction of -vAboveGround.
*/
#macro m_oTrain( sSpline, oTerrain, vAboveGround, nCarts, nSeed )
	
	#local rsTrain = seed(nSeed);
	#local fHingeDistance = 1;

	union {

		/*#local nPoint = 0;
		#while ( nPoint < 20 )
		
			#local vPos = (sSpline( nPoint/20 ));
			
			sphere {
				vPos+8*y, 1
				pigment { pLoudStuff }
			}
			
			#local nPoint = nPoint + 1;
		#end*/

		#local vNorm = <0,0,0>;
		
		#local nCart = 0;
		#while ( nCart < nCarts )
		
		 	#if ( nCart = 0 )
		 		
		 		#local fHalfLength = vEngineHalfDim.z;
		 	
				#local vPos = (sSpline( 0 ));
				#local fOldPos = 0;
				
				//project to ground
				#local vPos = trace( oTerrain, vPos+vAboveGround, -vAboveGround, vNorm );
				
				#local vDir = vnormalize((sSpline(fOldPos-.1)) - (sSpline(fOldPos+.1)));
				
				#local vHingePoint = vPos-.1;
				
			#else
		 		
		 		#local fHalfLength = vCartHalfDim.z;
		 	
				//find point on spline the appropriate distance from the hinge point.
				#local fPos = 0; //start at end of spline
				#local fStep = 1;
				#while ( abs(fStep) > 0.001 )

					#if ( fPos <= fOldPos )
						#local fStep = abs(fStep/2);
						//#debug concat("fOldPos = ", str(fOldPos,0,3), "  fPos = ", str(fPos,0,3), "\n" )
					#else
						#local vPos = (sSpline( fPos ));

						//project to ground
						#local vPos = trace( oTerrain, vPos+vAboveGround, -vAboveGround, vNorm );
	
						//find which side of the intersection we're on (note: there are 2 intersections)					
						#local fDist = vlength(vPos - vHingePoint);
						#local fDist = fDist - (fHalfLength + fHingeDistance);
						
						//avoid flipping back on ourselves by checking previous position
						#if ( fDist < 0 )
							#local fStep = abs(fStep/2);
						#else
							#if ( fDist > 0 )
								#local fStep = -abs(fStep/2);
							#else
								#local fStep = 0;
							#end
						#end

						//#debug concat("fDist = ", str(fDist,0,3), "  fPos = ", str(fPos,0,3), "\n" )
					#end //if ( pos > oldpos )
					
					#local fPos = fPos + fStep;

				#end //while

				#local fOldPos = fPos;

				#local vDir = vnormalize( vHingePoint - vPos );

			#end

			#local vOldHingePoint = vHingePoint;
			#local vHingePoint = vPos - vDir * (fHalfLength + fHingeDistance);
			
			union {
				union {
				 	#if ( nCart = 0 )
				 	 	oTrainEngine
				 	#else
				 	 	m_oTrainCart( rand(rsTrain)*256, rand(rsTrain)*256 )
				 	#end
				}

				object {
					oTrack
					translate <vCartHalfDim.x,0,vCartHalfDim.z/2> + x*(fTrackWidth/2 + .1)
				}
				object {
					oTrack
					translate <-vCartHalfDim.x,0,vCartHalfDim.z/2> - x*(fTrackWidth/2 + .1)
				}
				object {
					oTrack
					translate <vCartHalfDim.x,0,-vCartHalfDim.z/2> + x*(fTrackWidth/2 + .1)
				}
				object {
					oTrack
					translate <-vCartHalfDim.x,0,-vCartHalfDim.z/2> - x*(fTrackWidth/2 + .1)
				}

				//correct for norm
				Reorient_Trans( z, <vDir.x,0,vDir.z> )
				Reorient_Trans( y, vNorm - vdot(vNorm,vDir) )
				
				translate vPos
			}
			
			//cylinder { vHingePoint, vPos, 1 pigment { pLoudStuff } }
			//cylinder { vOldHingePoint, vPos, 1 pigment { pLoudStuff } }
		
			#local nCart = nCart + 1;
		#end
		
	}
#end //train macro
