//foss style sci-fi picture
//by tek

//note to the irtc community:
//I sincerely apologise for any and all untidyness in this source, but it's 11:50pm
//on tuesday night, and the render still has about 8 hours to go (the deadline is at
//8am here in the uk). So I simply haven't the time to tidy this code.
//Not that I usually tidy the code for my entries, but it is exceptionally sprawling
//this time! :)
//
//And finally, I apologise if this code doesn't work "out of the box", I usually test
//that before submitting but my final render is still running so I can't! Sorry :)
//
//if you have any problems with this source mail me: tek@evilsuperbrain.com


//scene controls

#declare CAM_1				= 0;
#declare CAM_OVERSEER	= 1;
#declare CAM_LANDSCAPE= 2;
#declare CAM_2				= 3;
#declare CAM_3				= 4;
#declare CAM_AT_3			= 5;

#declare eCam = CAM_3;

#declare gfCam3Multiplier = 2;//3.5;

//includes

#include "functions.inc"
#include "rad_def.inc"
#include "transforms.inc"

#include "pile of stuff in a box.inc"
#include "tek-foss.inc"

//global set up

global_settings {
  assumed_gamma 1
	max_trace_level 8//20
	radiosity {
    //Rad_Settings(Radiosity_Default, on, on)
    //Rad_Settings(Radiosity_Debug, on, on)
    //Rad_Settings(Radiosity_Fast, on, off)
    //Rad_Settings(Radiosity_Normal, on, on)
    //Rad_Settings(Radiosity_2Bounce, on, on)
    //Rad_Settings(Radiosity_Final, on, on)

    Rad_Settings(Radiosity_OutdoorLQ, on, on)
    //Rad_Settings(Radiosity_OutdoorHQ, on, on)
    //Rad_Settings(Radiosity_OutdoorLight, on, on)
    //Rad_Settings(Radiosity_IndoorLQ, on, on)
    //Rad_Settings(Radiosity_IndoorHQ, on, on)
	}
	charset utf8
}

#default { pigment { rgb 1 } finish { diffuse 1 ambient 0 } }


//object includes	

#include "foss-train.inc"
#include "foss-ship.inc"


//objects

#declare pMountains =
	pigment {
		function {
			f_ridged_mf(x,y,z, .5,2,4,1,2,1)*.08
		}
		scale 500
		translate <-100,0,400>
		//poly_wave 3
		colour_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
/*	pigment {
		bozo
		poly_wave 3
		turbulence .5
		scale 500
		colour_map {
			[.1 rgb 0]
			[1 rgb 1]
		}
	}*/
/*	pigment {
		mandel 256
		rotate 90*x
		translate z/2
		scale 800
		rotate -30*y
		translate <200,0,200>
		poly_wave .3
		colour_map {
			[0 rgb 1]
			[1 rgb 0]
		}
	}*/

#declare f_Mountains =
	function {
		pigment { pMountains }
	}

#declare f_Crackle =
	function {
		pigment {
			crackle 
			//poly_wave 1/2
			cubic_wave
			colour_map {
				[0 rgb 0]
				[1 rgb 1]
			}
		}
	}
	
#declare oGround =
	union {
		isosurface {
			function {
				y
				- f_Mountains(x+15+20-y/2,0,z).red*300
			}
			max_gradient 1// 1.5
			contained_by { box { <-2000,.1,-500>, <2000,500,4000> } }

			pigment {
				rgb 1
			}
			finish {
				specular 1
				roughness 0.01
			}
			normal {
				bumps .3
				scale .05//.001
			}
		}
		isosurface {
			function {
				y+1
				- f_ridged_mf((x+100)/500,0,(z-400)/500, .5,2,4,1,2,1)*.08*300// *420
				+(1-f_Crackle(x/12,0,z/12).red)*6 //abs(sin(x/4)+sin(z/4)
			}
			max_gradient 3
			contained_by { box { <-2000,.1,0>, <2000,500,1000> } }
			
			pigment { pRockTwist }
		}
		plane { y, .1 }

		scale 3
		
		translate (3.5 - gfCam3Multiplier)*140*z
	}



//the scene

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z

	#switch ( eCam )
	
		#case (CAM_OVERSEER)
			direction	z*1.2
			location <-2,3,1>*100
			look_at <0,0,70>
			#break

		#case (CAM_LANDSCAPE)
			direction	z*5//1.2
			location <0,160,-230> + 300*z
			look_at <0,150,80> + 300*z
			#break

		#case (CAM_1)
			direction	z*1.2
			location y*4
			look_at <0,19,140>
			#break
			
		#case (CAM_2)
			direction	z*1
			location y*4 - 8*z
			look_at <0,19,140>
			#break

		#case (CAM_3)
			direction	z*gfCam3Multiplier*.75
			#local vPos = y*4 - 8*z + 140*z - z*140*gfCam3Multiplier;
			#local vTest = trace( oGround, vPos+1000*y, -y );
			#local vPos = <vPos.x,/*max(vPos.y,*/vTest.y+1/*)*/,vPos.z>;
			#declare vCamPos = vPos;
			location vPos
			look_at <20,19,140>
			
			normal {
				average
				normal_map {
					//[1 spotted 0]
					//[1 crackle .014 scale .01 poly_wave .1]//[1 crackle .01 scale .004 poly_wave .1]
					//[1 spotted .007 scale .004 ]
					[1 spotted .003 scale .025 ]
				}
			}
			
			aperture			.1
			blur_samples	32//16
			focal_point		vPos+30*z
			confidence		0.95
			variance			0.05
			#break

		#case (CAM_AT_3)
			#local vPos = y*4 - 8*z + 140*z - z*140*gfCam3Multiplier;
			#local vTest = trace( oGround, vPos+1000*y, -y );
			#local vPos = <vPos.x,/*max(vPos.y,*/vTest.y+1/*)*/,vPos.z>;
			#declare vCamPos = vPos;

			direction	z*4
			location vPos+<-1,0,3>*40
			look_at vPos+25*z-2*y
			#break

	#end //switch cam type
}


#declare f_PowerCurve =
	function(x,p) {
		select(x,pow(abs(x),p),-pow(abs(x),p))
	}

#declare f_LensEffect =
	function(x,f,p) {
		f_PowerCurve(select(x,x+f/8,x*1.1-f/16),p)
	}

#ifdef (vCamPos)

	sphere {
		0, 1
		
		hollow on
		
		pigment {
			//rgb .5 transmit 1.5
			//gradient y
			//scale 2
			//translate -y
			function {
				min(max(
					(
						f_LensEffect((cos(radians(20))*y - sin(radians(20))*x)*3,-min(0,(sin(x*450+2*sin(x*170)))),3)
						
					)/2 + .5
				,0),1)
			}
			colour_map {
				[0	rgb <.3,.5,.7>-.3 transmit 2]
				[.5	rgb .5 transmit 1.5]
				[1	rgb <.7,.6,.3> transmit 1.2]//1 //1.5
			}
			//rotate <0,0,180>
			//Reorient_Trans(z, <20,19,140> - vCamPos)
		}
		finish {
			crand .1
			//diffuse 0
			//ambient 1
		}
		
		translate vCamPos
	}

#end //ifdef campos

//cam 3 marker
#if (eCam != CAM_3)
	#local vPos = y*4 - 8*z + 140*z - z*140*gfCam3Multiplier;
	#local vTest = trace( oGround, vPos+1000*y, -y );
	#local vPos = <vPos.x,/*max(vPos.y,*/vTest.y+1/*)*/,vPos.z>;
	//sphere { vPos, 10 pigment { rgb <1,0,0> } }
#end


light_source {
	//<-1,3,-2>*10000
	<-2,2,-2>*10000
	//<3,1,2>*10000
	rgb 1
	area_light x*1000,y*1000,16,16 orient adaptive 1
}


sky_sphere {
	/*pigment {
		#local fPow = 2;//.5;	
		function {
			(
				select( y, -pow(abs(y),fPow), pow(abs(y),fPow) )
			)/2 + .5
		}
		colour_map {
			//[.4	rgb <5,3,1>/70]
			//[.5	rgb 1]
			[.2	rgb 1]
			[1	rgb <2,3,10>/20]
		}
	}*/
	pigment {
		#local fPow = .3;	
		function {
			(
				select( y, -pow(abs(y),fPow), pow(abs(y),fPow) )
			)/2 + .5
		}
		colour_map {
			[.4	rgb <5,3,1>/70]
			[.5	rgb 1]
			[1	rgb <2,3,10>/16]
			//[1	rgb <2,3,10>/40]
			/*[.0	rgb 1]
			[.75	rgb <2,3,10>/20]
			[1	rgb <2,3,10>/40]*/
		}
	}
	//cunning cloud trick
	pigment {
		wrinkles
		scale <0.7,0.3,0.7>/3
		translate 0.03*y
		poly_wave 4
		colour_map {
			[0.0 rgbt 1]// <1.2,.8,.8> transmit 1]
			[1.0 rgb 1]//<1.2,.8,.8> transmit 0]
		}
		//translate -0.2*y
	}
	pigment {
		wrinkles
		scale <0.7,0.3,0.7>/3
		poly_wave 4
		colour_map {
			[0.0 rgb .4 transmit 1]//.6*<.3,.32,.5> transmit 1]
			[1.0 rgb .4]//.6*<.3,.32,.5> transmit 0]
		}
		//translate -0.2*y
	}
}

fog {
	fog_type 1//2
	//fog_offset 0
	//fog_alt 60
	up y
	distance 500//400
	colour rgb .91 transmit .4//.2
	turbulence .1
}



//snow in the air...
#declare fFlakeRad = .1;//.2;//.1; //metres

#declare tFlake =
	texture {
		uv_mapping
		spherical
		poly_wave .5
		scale .7
		turbulence .5
		texture_map {
			[0
				pigment {
					rgb 1 transmit 1
				}
				finish {
					specular 0
					roughness 0.01
				}
			]
			[1
				pigment {
					rgb 1
				}
				finish {
					//specular 1
					//roughness 0.01
					diffuse 0
					ambient 1
				}
			]
		}
	}

#declare vFlakeBoxMax = <200,200,50>;
#declare vFlakeBoxMin = <-200,0,-140>;

#declare  oFlakes = 
	mesh {
	
		#local rsFlakes = seed (29);
		
		#local nFlake = 0;
		#local nFlakesNum = 100000;
		#while ( nFlake < nFlakesNum )
		
			#local vRot = 90*<pow(rand(rsFlakes)*2-1,2)+1,4*rand(rsFlakes),0>;
			#local vPos = <rand(rsFlakes),rand(rsFlakes),rand(rsFlakes)>*(vFlakeBoxMax - vFlakeBoxMin) + vFlakeBoxMin;
			
			triangle {
				vPos + vrotate(-z*2,vRot)*fFlakeRad,
				vPos + vrotate(z + x*sqrt(3),vRot)*fFlakeRad,
				vPos + vrotate(z - x*sqrt(3),vRot)*fFlakeRad
				uv_vectors -u*2, u + v*sqrt(3), u - v*sqrt(3)
				texture { tFlake }
			}

			#local nFlake = nFlake + 1;
			
			#if ( mod(nFlake,1000) = 0 )
				#debug concat("snowflake ", str(nFlake,0,0), "/", str(nFlakesNum,0,0), "\n")
			#end
		#end
		
		double_illuminate
		hollow on
		no_reflection
		no_shadow
	}
	

object { oFlakes }





object { oGround }
//plane { y, 0 }



object { oFullObject rotate 10*y translate <-30,7,0> translate vrotate(<-60,25,140>,2*y) }


#declare sTrain1 =
	spline {
		natural_spline
		-1, <12,1,60> * <1.2,1,1.5>
		0, <12,1,36> * <1.2,1,1.5>
		.33, <12,1,12> * <1.2,1,1.5>
		.66, <6,1,-8> * <1.2,1,1.5>
		1, <-15,1,-20> * <1.2,1,1.5>
		2, <-40,1,-28> * <1.2,1,1.5>
//		.66, <0,1,-8> * <1.2,1,1.5>
//		1, <-24,1,-20> * <1.2,1,1.5>
//		2, <-56,1,-28> * <1.2,1,1.5>
	}

//m_oTrain( sTrain1, oGround, 100*y, 3, 17 )


#declare sTrain2 =
	spline {
		natural_spline
/*		-1, <-100,0,200> 
		0, <-40,0,200>
		1, <160,0,160>
		1.3, <360,0,160>*/
		-.3, <-60,0,100> 
		0, <-60,0,180>
		1, <140,0,110>
		1.4, <160,0,200-370>
	}

m_oTrain( sTrain2, oGround, 100*y, 6, 12 )



#declare sTrain3 =
	spline {
		natural_spline
		/*-1, <-30,1,140*.0> + (3.5 - gfCam3Multiplier)*140*z
		0, <12,1,-140*1.5> + (3.5 - gfCam3Multiplier)*140*z
		1, <0,1,-140*3> + (3.5 - gfCam3Multiplier)*140*z
		2, <-80,1,-140*4> + (3.5 - gfCam3Multiplier)*140*z*/
		-1, <-30,1,140*.0> + (3.5 - gfCam3Multiplier)*140*z
		0, <40,1,-140*1.5> + (3.5 - gfCam3Multiplier)*140*z
		1, <0,1,-140*3> + (3.5 - gfCam3Multiplier)*140*z
		2, <80,1,-140*4> + (3.5 - gfCam3Multiplier)*140*z
		/*-.4, <-80,1,-140*1.0> + (3.5 - gfCam3Multiplier)*140*z
		0, <12,1,-140*1.5> + (3.5 - gfCam3Multiplier)*140*z
		//.5, <24,1,-140*2> + (3.5 - gfCam3Multiplier)*140*z
		1, <0,1,-140*3> + (3.5 - gfCam3Multiplier)*140*z
		1.4, <-50,1,-140*4> + (3.5 - gfCam3Multiplier)*140*z*/
	}

m_oTrain( sTrain3, oGround, 100*y, 8, 442 )



#declare sTrain4 =
	spline {
		natural_spline
		-.3, <-10,0,300> 
		0, <-10,0,180>
		1, <-10,0,-1000>
		1.4, <-10,0,-1200>
	}

//m_oTrain( sTrain4, oGround, 100*y, 20, 12 )


