/* Station De Ski (dameuse.inc)
Copyright (c) 2002 Cyrille Berger
http://www.cberger.net/ */

#declare verretransparant = texture {
#if(usetexture)
        pigment { rgbf<1.0, 1.0, 1.0, .7> }
        finish {
                specular 1
                roughness 0.001
                ambient 0
                diffuse 0.3
                reflection 0.2
        }
#else
        pigment { Blue }
#end
}
//------------------------------------------------- Roue ------------------------------------------------//
#declare roue = difference {
        merge {
                cylinder { <0,0,0>, <0,0,.4>, .2 } //Corps principal de la roue
                difference { //Extrmit arrondie de la roue, la jante quoi
                       sphere { <0,0,.4>, .4472 }
                        box { <-1,-1,0.0001>, <1,1,1> }
                }
        } 
       #declare i = 0;
        #while(i<8)
                cylinder { <0,.2,-.2>, <0,.2,.5>, .05 rotate <0,0,45*i> }
                #declare i=i+1;
        #end
        sphere { <0,0,-0.0472>, .06 texture { pigment { Gray80 } finish { metallic } } }
        pigment { Gray10 }
}
//-------------------------------------------- arcdechenille --------------------------------------------//
#declare arcdechenille = union {
        cylinder { <-2.0, 0.0, 0.0>, <-2.0, 0.0, 0.8>, 0.4 }
        cylinder { < 2.0, 0.0, 0.0>, < 2.0, 0.0, 0.8>, 0.4 }
        box { <-2.0,-0.4, 0.0>, < 2.0, 0.4, 0.8> }
}
//------------------------------------------------ Chassi -----------------------------------------------//
#declare chassi = union {
        #if(full)
                #declare i=0;
                #declare R1=seed(100);
                #while(i<6)
                        object { roue scale 2.0 rotate <0,180,180*rand(R1)> translate <2.0-i*.8, 0.0, 1.8> }
                        object { roue scale 2.0 rotate <0,0,180*rand(R1)> translate <2.0-i*.8, 0.0,-1.8> }
                        #declare i=i+1;
                #end
        #end
        difference {
                union {
                        box { <-2.2,-0.1,-1.3>, < 2.2, 0.6, 1.3> }
                        //#if(full)
                                cylinder { <-2.2,0.25,-1.3>, <-2.2,0.25, 1.3>, .35 }
                                cylinder { < 2.2,0.25,-1.3>, < 2.2,0.25, 1.3>, .35 }
                                cylinder { <-2.2,0.25, 1.3>, < 2.2,0.25, 1.3>, .35 }
                                cylinder { <-2.2,0.25,-1.3>, < 2.2,0.25,-1.3>, .35 }
                                sphere { <-2.2,0.25,-1.3>, .35 }
                                sphere { < 2.2,0.25,-1.3>, .35 }
                                sphere { <-2.2,0.25, 1.3>, .35 }
                                sphere { < 2.2,0.25, 1.3>, .35 }
                        //#end
                        pigment { Gray65 }
                        #if(usetexture) normal { bumps 0.6 scale .01 } #end
                }
                #if(full)
                        object { arcdechenille scale < 1.1,1.1, 1.2> translate < 0.0, 0.0, 0.79>
                                pigment { Black } }
                        object { arcdechenille scale < 1.1,1.1, 1.2> rotate <0,180,0>
                               translate < 0.0, 0.0,-0.79> pigment { Black } }
                #end
        }
        difference {
                union {
                        object { arcdechenille scale < 1.05,1.05, 1.35> translate < 0.0, 0.0, 0.8> }
                        object { arcdechenille scale < 1.05,1.05, 1.35> rotate <0,180,0>
                                translate < 0.0, 0.0,-0.8> }
                }
                #if(full)
                        object { arcdechenille scale < 1.0,1.0, 1.5> translate < 0.0, 0.0, 0.8> }
                        object { arcdechenille scale < 1.0,1.0, 1.5> rotate <0,180,0>
                                        translate < 0.0, 0.0,-0.8> }
                #end
                #if(usetexture)
                        pigment {
                                gradient x
                                color_map {
                                        [0.00 color Gray10]
                                        [0.70 color Gray10]
                                        [1.00 color Gray40]
                                } scale .1
                        }
                #else
                        pigment { Black }
                #end
        }
}
//------------------------------------------------ boite ------------------------------------------------//
#declare boite = difference {
        box { <-0.50, 0.0,-1.1>, < 1.0, 1.6, 1.10> }
        box { <-0.75,-1.0,-1.2>, <-2.0, 3.0, 1.20> rotate <0,0,-20> }
        box { <-1.00,-1.0,-3.0> ,< 1.5, 3.0,-1.23> rotate <10,0,0> }
        box { <-1.00,-1.0, 3.0> ,< 1.5, 3.0, 1.23> rotate <-10,0,0> }
}
//----------------------------------------------- Cabine ------------------------------------------------//
#declare cabine = merge {
        difference
        {
                object { boite
                        #if(usetexture) finish { phong 1 phong_size 10 } #end
                        pigment { Red } }
                #if(full)
                        object { boite scale .96 }
                        box { < 0.0, 0.9,-0.8>, <-2.0, 1.5, 0.8> }
                        box { < 0.1, 0.9,-1.1>, < 0.9, 1.5, 1.1> }
                        sphere { <-0.5, 0.5,-0.8>, .2 texture { T_Silver_3E } }
                        sphere { <-0.5, 0.5, 0.8>, .2 texture { T_Silver_3E } }
                        cylinder { < 0.2, 0.7,-1.1>, <0.4, 0.7,-1.1>, .01 pigment { Black } }
                        cylinder { < 0.2, 0.7, 1.1>, <0.4, 0.7, 1.1>, .01 pigment { Black } }
                #end
        }
        
        #if(full)
        //Radiateur
        cylinder { < 0.5, 0.2, 0.0>, < 0.5, 0.7, 0.0>, 1.1
                        texture { 
                                pigment { gradient z
                                        color_map {
                                                [0.0 color Black ]
                                                [0.5 color Gray40 ]
                                                [1.0 color Black ]
                                        }
                                        scale .1
                                }
                                finish { F_MetalA  }
                        }
                }
        //Phare
                #declare phare = difference {
                        sphere { <-0.3, 0.5, 0.0>, .3 }
                        sphere { <-0.3, 0.5, 0.0>, .2 }
                        texture {
                                pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
                                finish  {
                                        specular 1
                                        roughness 0.001
                                        ambient 0
                                        diffuse 0
                                        reflection 0.1
                                }
                        }
                        interior { ior 1.5 }
                }
                object { phare translate < 0.0, 0.0, 0.8> }
                object { phare translate < 0.0, 0.0,-0.8> }
                #if(uselumiere)
                        light_source { <-0.31, 0.5, 0.8> color White }
                        light_source { <-0.31, 0.5,-0.8> color White }
                #end
        //Vitres
                difference {
                        object { boite scale .99 }
                        object { boite scale .97 }
                        texture { verretransparant }
                        interior { ior 1.5 }
                }
                box { < 0.5, 0.0, 0.5>,< 0.7, 1.3, -0.5> pigment { Brown } }
        torus { .2, .02 rotate <0,0,-70> translate <-0.2, 0.9, 0.0>}
        #end
      
}

//---------------------------------- Dameur ----------------------------------//

#declare dameur = union {
        //Tambours
        union {
                cylinder { < 0.0, 0.3,-2.0>, < 0.0, 0.3, 2.0> 0.3} //Gros tambour
                cylinder { < 0.5, 0.1,-2.0>, < 0.5, 0.1, 2.0> 0.1} //Petit Tambour
                pigment { Yellow }
                        finish { phong 1 phong_size 10 }
        }
        //Attache
        union {
                cylinder { < 0.0, 0.3,-2.1>, < 0.0, 0.3, 2.1> 0.05 }//Gros tambour
                cylinder { < 0.5, 0.1,-2.1>, < 0.5, 0.1, 2.1> 0.05 }//Petit Tambour
                cylinder { < 0.0, 0.3,-2.1>, < 0.5, 0.1,-2.1> 0.05 }//entre les deux
                cylinder { < 0.5, 0.1, 2.1>, < 0.0, 0.3, 2.1> 0.05 }
                sphere { < 0.0, 0.3,-2.1>, 0.05 }
                sphere { < 0.5, 0.1,-2.1>, 0.05 }
                sphere { < 0.0, 0.3, 2.1>, 0.05 }
                sphere { < 0.5, 0.1, 2.1>, 0.05 }
                cylinder { < 0.4, 0.5,-2.1>, < 0.4, 0.5, 2.1> 0.05 }
                cylinder { < 0.4, 0.5, 2.1>, < 0.2, 0.2, 2.1> 0.05 }
                cylinder { < 0.4, 0.5,-2.1>, < 0.2, 0.2,-2.1> 0.05 }
                sphere { < 0.4, 0.5, 2.1>, 0.05 }
                sphere { < 0.4, 0.5,-2.1>, 0.05 }
                cylinder { < 0.4, 0.5, 0.0>, < 0.0, 0.9, 0.0> 0.05 }
                cylinder { < 0.4, 0.5, 2.1>, < 0.0, 0.9, 0.0> 0.05 }
                cylinder { < 0.4, 0.5,-2.1>, < 0.0, 0.9, 0.0> 0.05 }
                pigment { Gray20 } 
                finish { metallic }
        }
        //Planche rouge
        union {
                #declare i=0;
                #while(i<4)
                        box { <0.02,0,-1.02+i*1>, <0,1,-1.98+i*1> rotate <0,0,47> translate <1,0,0> }
                        #declare i=i+1;
                #end
                pigment { Red }
                finish { phong 1 phong_size 10 }
        }
}

//---------------------------------------------- chasseneige --------------------------------------------//

#declare chasseneige = union {
        //Raccord
        cylinder { < 0.0, 0.8,-0.5>, <-0.3, 0.6,-0.5>, .1 }
        cylinder { < 0.0, 0.8, 0.5>, <-0.3, 0.6, 0.5>, .1 }
        cylinder { <-0.3, 0.6,-1.0>, <-0.3, 0.6, 1.0>, .1 }        
        sphere { <-0.3, 0.6,-1.0>, .1 }
        sphere { <-0.3, 0.6, 1.0>, .1 }
        cylinder { <-0.3, 0.6, 1.0>, <-0.8, 0.6, 1.5>, .1 }
        sphere { <-0.8, 0.6, 1.5>, .1 }
        cylinder { <-0.3, 0.6,-1.0>, <-0.8, 0.6,-1.5>, .1 }
        sphere { <-0.8, 0.6,-1.5>, .1 }
        //Paneau bas
        box { <-0.05,-0.5,-0.4>, < 0.05, 0.5, 0.4>
                rotate <0,0,-30> rotate <0,-45,0> translate <-0.7,0.24, 1.1> }
        box { <-0.05,-0.5,-0.4>, < 0.05, 0.5, 0.4>
                rotate <0,0,-30> rotate <0, 45,0> translate <-0.7,0.24,-1.1> }
        box { <-0.05,-0.5,-0.7>, < 0.05, 0.5, 0.7>
                rotate <0,0,-30> translate <-0.55,0.24, 0.0> }
        //Paneau haut
        box { <-0.05,-0.25,-0.4>, < 0.05, 0.05, 0.4>
                rotate <0,0,30> rotate <0,-45,0> translate <-0.7,0.84, 1.1> }
        box { <-0.05,-0.25,-0.4>, < 0.05, 0.05, 0.4>
                rotate <0,0,30> rotate <0,45,0> translate <-0.7,0.84,-1.1> }
        box { <-0.05,-0.25,-0.7>, < 0.05, 0.05, 0.7>
                rotate <0,0,30> translate <-0.55,0.84, 0.0> }
        pigment { Gray30 }
        #if(usetexture) finish { phong 1 phong_size 10 } #end
}

//------------------------------------------------ Dameuse ----------------------------------------------//

#declare dameuse = union {
        object { chassi translate < 0.0, .42, 0.0> }
        object { cabine translate <-1.7, 1.0, 0.0> }
        #if(full)
                union { 
                //Bitognaux
                        cylinder { <-0.7, 1.0, 1.1>, <-0.7, 1.3, 1.1> .1 }//Avant
                        sphere { <-0.7, 1.3, 1.1>, .1 }
                        cylinder { <-0.7, 1.0,-1.1>, <-0.7, 1.3,-1.1> .1 }
                        sphere { <-0.7, 1.3,-1.1>, .1 }
                        cylinder { < 2.3, 0.7, 1.1>, < 2.0, 1.3, 1.1> .1 }//Arrire
                        sphere { < 2.0, 1.3, 1.1> .1 }
                        cylinder { < 2.3, 0.7,-1.1>, < 2.0, 1.3,-1.1> .1 }
                        sphere { < 2.0, 1.3,-1.1> .1 }
                //Partie latralle
                        cylinder { <-0.7, 1.3,-1.1>, < 2.0, 1.3,-1.1> .1 }
                        cylinder { <-0.7, 1.3, 1.1>, < 2.0, 1.3, 1.1> .1 }
                        box { <-0.7, 1.0,-1.2>, < 2.0, 1.3,-1.0> }
                        box { <-0.7, 1.0, 1.2>, < 2.0, 1.3, 1.0> }
                        box { < 2.1, 1.0,-1.2>, < 2.0, 1.2,-1.0> }
                        box { < 2.1, 1.0, 1.2>, < 2.0, 1.2, 1.0> }
                        pigment { Red }
                        #if(usetexture) finish { phong 1 phong_size 10 } #end
                }
                union { //Support jaune du rateau dameure
                        cylinder { < 2.0, 0.9, 0.0>, < 2.0, 1.1, 0.0>, .4 }
                        cylinder { < 2.0, 1.0, 0.0>, < 2.0, 1.4, 0.0>, .1 }
                        sphere { < 2.0, 1.4, 0.0>, .1 }
                        cylinder { < 2.0, 1.4, 0.0>, < 2.9, 1.2, 0.0> .1 }
                        sphere { < 2.9, 1.2, 0.0>, .1 }
                        cylinder { < 2.9, 0.9, 0.0>, < 2.9, 1.2, 0.0> .1 }
                        sphere { < 2.9, 0.9, 0.0>, .1 }
                        pigment { Yellow }
                        #if(usetexture) finish { phong 1 phong_size 10 } #end
                }
                object { dameur translate < 2.9, 0.0, 0.0> }
                object { chasseneige translate <-2.4, 0.0, 0.0> }
                union { //Neige
                        sphere { <-3.3,0,0>, 0.3 }
                        cylinder { <-3.1,-.1,-1.0>, <-3.2,.1,1.0>, 0.15 }
                        sphere { <-3.5,0,-1>, 0.15 }
                        sphere { <-3.6,0, 1>, 0.2 }
                        pigment { Neige }
                }
        #end
}