//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Curved ribon macro Ver 0.2r000906b include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
#macro Curve_write(File_name,Comment)
#ifndef(Tx0) #local Tx0=0; #end #ifndef(Tz0) #local Tz0=0; #end 
 #fopen Curve_data File_name write
 #write (Curve_data,Pmax,",\n")
 #local Si=0; #while(Si<Pmax)
  #write (Curve_data,Vp[Si].x,",",Vp[Si].y,",")
  #if(mod(Si+1,8)=0 & Si+1!=Pmax) #write (Curve_data,"\n") #end
 #local Si=Si+1; #end
 #write (Curve_data,"\n",Tx0,",",Tz0,",\n","\"",Comment,"\"",","," By S.Nishimura")
 #fclose Curve_data 
#end
//----------------------------------------------------------------------------------
#macro Curve_read(File_name)
 #fopen Curve_data File_name read
 #read (Curve_data,Pmax)
 #declare Vp=array[Pmax]
 #local Si=0; #while(Si<Pmax)
  #read (Curve_data,Pvx,Pvz) #declare Vp[Si]=<Pvx,Pvz>;
 #local Si=Si+1; #end
 #read (Curve_data,Tx0,Tz0)
 #fclose Curve_data 
#end
//**********************************************************************************
//sample parameters
/*
#local Pmax=1+2*6; #local Vp=array[Pmax]
//
#local Vp[0]=< -48, 32 >; #local Vp[1]=< -43, 40 >;
#local Vp[2]=< -38, 32 >; #local Vp[3]=< -33, 40 >;
#local Vp[4]=< -28, 32 >; #local Vp[5]=< -18, 27 >;
#local Vp[6]=< -28, 23 >; #local Vp[7]=< -33, 15 >;
#local Vp[8]=< -38, 23 >; #local Vp[9]=< -43, 15 >;
#local Vp[10]=< -48, 23 >; #local Vp[11]=< -58, 27 >;
#local Vp[12]=Vp[0];
Curve_write("Contact.dat.txt","Contact_ribon data")
//Curve_read("Contact.dat.txt")
#local Curveobj = union { Contact_ribon(6, 4, 8) pigment { color rgb 1 } rotate -90*x scale 3 }
object { Curveobj translate <84,-82.25,0> } object { Curveobj translate <144,-82.25,0> }
*/
//**********************************************************************************
#macro Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Oc=0;
 #if((Px1=Px2 & tan(pi/2)=Mx) | (Px1=Px2 & tan(pi*3/2)=Mx) | (Pz2-Pz1)=Mx*(Px2-Px1)) #local Oc=3; #end
 #if(Mx*(Pz2-Pz1)+(Px2-Px1)=0) #local Oc=3; #end
 #if(Oc=0) 
  #if(Mx=0) #local Mx=1e-12; #end
  #local A= 2*((Pz2-Pz1)-Mx*(Px2-Px1));
  #local B=-2*(Px2-Px1)*(Mx*Pz1+Px1);
  #local C=(pow(Px2,2)-pow(Px1,2))+(pow(Pz2,2)-pow(Pz1,2));
  #local Oz0=(B+C)/A; #local Ox0=Mx*(Pz1-Oz0)+Px1;
 #end
#end
//**********************************************************************************
#macro Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
// radius line
#local Mrc=(Px1-Ox0)*(Pz2-Pz1)-(Pz1-Oz0)*(Px2-Px1);
// vartical line
#local Mvc=(Px1-Ox0)*(Px2-Px1)+(Pz1-Oz0)*(Pz2-Pz1);
// circle & straight line chek
#local Ltype=3;
#if(Mrc!=0 & Mvc!=0) 
 // center point
 #local A=2*(Px2-Px1)*(Px1-Ox0)+2*(Pz2-Pz1)*(Pz1-Oz0);
 #local B=2*(Pz1-Pz2)*(Px1*Oz0-Pz1*Ox0);
 #local C=(Px1-Ox0)*(pow(Px1,2)-pow(Px2,2)+pow(Pz1,2)-pow(Pz2,2));
 #local Ox = (B-C)/A;                                 // center x
 #local Oz = ((Pz1-Oz0)/(Px1-Ox0))*(Ox-Px1)+Pz1;      // center z
 #local Tr=sqrt(pow(Px2-Ox,2)+pow(Pz2-Oz,2));         // radius r
 // clipping arc
 #local Ra1=degrees(atan2(Pz1-Oz,Px1-Ox));
 #local Ra2=degrees(atan2(Pz2-Oz,Px2-Ox));
 // counterclockwise & clockwise chek
 #local Mc=Px1-Ox; #local Ms=Pz1-Oz;
 #if(Mc!=0) #local Mtan=Ms/Mc; #else #local Mtan=tan(pi/2); #end
 #local Vxv=(pow(Mtan,2)*Px2+Mtan*(Pz1-Pz2)+Px1)/(pow(Mtan,2)+1);
 #local Vzv=(pow(Mtan,2)*Pz1+Mtan*(Px1-Px2)+Pz2)/(pow(Mtan,2)+1);
 #local Vs=Vzv-Pz1; #local Vc=-(Vxv-Px1);
 #if(Mc!=0)
  #if(Mc*Vs>0) #local Ltype=1; #end
  #if(Mc*Vs<0) #local Ltype=2; #end
 #else
  #if(Ms*Vc>0) #local Ltype=1; #end
  #if(Ms*Vc<0) #local Ltype=2; #end 
 #end
#end
// ribon type
#switch(Ltype)
 #case(1)
  cylinder { 0,Lw*y,Tr open //torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate -(Ra1+180)*y }
  clipped_by { plane { z, 0 } rotate -(Ra2)*y }
  translate < Ox, 0, Oz > }
 #break
 #case(2)
  cylinder { 0,Lw*y,Tr open //torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate -(Ra1)*y }
  clipped_by { plane { z, 0 } rotate -(Ra2+180)*y }
  translate < Ox, 0, Oz > }
 #break
 #case(3)
  //cylinder { < Px1, 0, Pz1 >,< Px2, 0, Pz2 >,Lw open }
  mesh {
   triangle { <Px1,0,Pz1>,<Px2, 0,Pz2>,<Px2,Lw,Pz2> }
   triangle { <Px1,0,Pz1>,<Px2,Lw,Pz2>,<Px1,Lw,Pz1> }
  }
  #local Ox=Ox0+(Px2-Px1);
  #local Oz=Oz0+(Pz2-Pz1);
 #break
#end
//
 #local Ox0=Ox;
 #local Oz0=Oz;
#end
//**********************************************************************************
//sample functions
/*
#macro Curve_function(Tp,Px,Pz,Func_type)
 #switch(Func_type)
 #case( 1) #local Px= Tp; #local Pz= 1/3*pow(Px,2)+Px-1; #break // x^2
 #case( 2) #local Px= Tp; #local Pz= 1/3*pow(Px,3); #break      // x^3
 #case( 3) #local Px= Tp; #local Pz= sin(Tp); #break // sin
 #case( 4) #local Px= Tp; #local Pz= cos(Tp); #break // cos
 #case( 5) #local Px= 3*cos(Tp); #local Pz= 2*sin(Tp); #break   // ellipse
 #case( 6) #local Px= Tp*cos(Tp); #local Pz= Tp*sin(Tp); #break // spiral

 #case(10) #local Px= (2+3*cos(Tp))*cos(Tp)-2; #local Pz= (1.5+3*cos(Tp))*sin(Tp); #break // carjioid
 #case(11) #local Px= 3*pow(cos(Tp),3); #local Pz= 2*pow(sin(Tp),3); #break // asteloid
 #case(12) #local Rr= sin(Tp/2); #local Px= 3*Rr*cos(Tp); #local Pz= 2*Rr*sin(Tp); #break // leafs

 #case(14) #local Px= Tp-sin(Tp); #local Pz= 1-cos(Tp); #break // cycloid
 #case(15) #local Px= 3*pow(0.99,6*Tp)*cos(Tp); #local Pz= 3*pow(0.99,6*Tp)*sin(Tp); #break // spiral
 #case(16) #local Px= Tp; #local Pz= 2*Px; #break  // 2x
 #case(17) #local Px= Tp; #local Pz= 0; #break     // z=0
 #case(18) #local Px= 0;  #local Pz= Tp; #break    // x=0
 #end
#end
*/
//**********************************************************************************
#macro Curved_ribon(Lw,V1,Mx,Func_type)
#local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
 Curve_function(Sp,Px,Pz,Func_type) #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Curve_function(Sp+Ap,Px,Pz,Func_type) #local Px2=Px; #local Pz2=Pz;
 #if(Sp=V1.x) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#end
//**********************************************************************************
//sample parameters (Lw:V1:<Sp,Ep,Ap>:Mx:Func_type)
/*
union { Curved_ribon(1,pi*<-1,1,1/12>,2/3*(-pi)+1,1) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/8>,pow(-pi,2),2) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/8>,cos(-pi),3) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/8>,-sin(-pi),4) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/8>,(-2/3)*(cos(-pi)/sin(-pi)),5) pigment { color rgb 1 } rotate -30*x scale 10 }
Curved_ribon(1,pi*<-1/2,2,1/4>,(sin(-pi/2)-pi/2*cos(-pi/2))/(cos(-pi/2)+pi/2*sin(-pi/2)),6)

union { Curved_ribon(1,pi*<-1,1,1/10>,tan(radians(90)),10) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/38>,tan(radians(0)),11) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-2,2,1/30>,tan(radians(180)),12) pigment { color rgb 1 } rotate -30*x scale 10 }

union { Curved_ribon(1,pi*<-3,3,1/32>,tan(radians(180)),14) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<0,8,1/4>,tan(radians(95)),15) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/2>,2,16) pigment { color rgb 1 } rotate -30*x scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/2>,0,17) pigment { color rgb 1 } scale 10 }
union { Curved_ribon(1,pi*<-1,1,1/2>,tan(radians(90)),18) pigment { color rgb 1 } rotate 30*y scale 10 }
*/
//**********************************************************************************
#macro Contact_curve_function(Tp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz)
 #local Px=(X0*pow(1-Tp,2)+(2+E1)*Xc*Tp*(1-Tp)+(1+E1+E2)*X1*pow(Tp,2))/(1+E1*Tp+E2*pow(Tp,2));
 #local Pz=(Z0*pow(1-Tp,2)+(2+E1)*Zc*Tp*(1-Tp)+(1+E1+E2)*Z1*pow(Tp,2))/(1+E1*Tp+E2*pow(Tp,2));
#end
//----------------------------------------------------------------------------------
#macro Contact_ribon(Lw,E1,E2)
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
#local Si=0; #while(Si<Pmax-2)
 #local X0=Vp[Si].x;   #local Z0=Vp[Si].y;
 #local Xc=Vp[Si+1].x; #local Zc=Vp[Si+1].y;
 #local X1=Vp[Si+2].x; #local Z1=Vp[Si+2].y; 
 // curve segment
 #local Sp=0; #local Ep=1; #local Ap=1/(10-1e-14);
 #if(Xc=X0) #local Mx=tan(pi/2); #else #local Mx=(Zc-Z0)/(Xc-X0); #end
 Contact_curve_function(Sp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz) #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Contact_curve_function(Sp+Ap,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz) #local Px2=Px; #local Pz2=Pz;
 #if(Sp=0) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#local Si=Si+2; #end
#end
//**********************************************************************************
//sample parameters (Lw:line width E1:E2:De=pow(E1,2)-4*E2)
/*
#local Pmax=1+2*8; #local Vp=array[Pmax]
// vector point
#local Vp[0]=< -10,-20 >; #local Vp[1]=< -20,-20 >;
#local Vp[2]=< -20,-10 >; #local Vp[3]=< -20,  0 >;
#local Vp[4]=< -20, 10 >; #local Vp[5]=< -20, 20 >;
#local Vp[6]=< -10, 20 >; #local Vp[7]=<   0, 20 >;
#local Vp[8]=<  10, 20 >; #local Vp[9]=<  20, 20 >;
#local Vp[10]=< 20, 10 >; #local Vp[11]=< 20,  0 >;
#local Vp[12]=< 20,-10 >; #local Vp[13]=< 20,-20 >;
#local Vp[14]=< 10,-20 >; #local Vp[15]=<  0,-20 >;
#local Vp[16]=Vp[0];
union { Contact_ribon(8, 4, 0) pigment { color rgb 1 } rotate -90*x scale 3 }
*/
//**********************************************************************************
#macro Trammel_function(Tp,Ll,Vl,Px,Pz)
 #local Px=Vl*cos(Tp); #local Pz=(Ll-Vl)*sin(Tp);
#end
//----------------------------------------------------------------------------------
#macro Trammel_ribon(Lw,V1,Ll,Vl)
#local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
#if(Vl=0) #local Mx=tan(pi/2); #else #local Mx=-(Ll-Vl)/Vl*cos(Sp)/sin(Sp); #end
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
 Trammel_function(Sp,Ll,Vl,Px,Pz)   #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Trammel_function(Sp+Ap,Ll,Vl,Px,Pz)#local Px2=Px; #local Pz2=Pz;
 #if(Sp=V1.x) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#end
//**********************************************************************************
//sample parameters (Lw:line width V1:<Sp,Ep,Ap> Ll:trammel length Vl:transfer point)
/*
#local Si=0; #while(Si<2+5)
 union { Trammel_ribon(2,pi*<-1,1,1/24>,3,Si/2) pigment { color rgb 1 } rotate -90*x scale 20 }
#local Si=Si+1; #end
*/
//**********************************************************************************