#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

#include "iceshelf1.inc"
#include "berg1.inc"
#include "niceberg.inc"
#include "clouds.inc"
#include "PenguinUV_g.inc"
#include "icefloe.inc"


#declare TRUE = 1
#declare FALSE = 0

#declare USE_PENGUINS = TRUE
#declare USE_SKY      = TRUE
#declare USE_WATER    = TRUE

/*
camera{
	location < 0, 1.15, -6.406 >
	up<0,1,0>
	right<800/600,0,0>
	look_at < 0, 2, 0 >
	angle 90
	}
*/

camera{
	location < 0.5, 2, -6 >
	up<0,1,0>
	right<800/600,0,0>
	look_at < 0, 2, 0 >
	angle 90
	}


#version unofficial MegaPov 0.7

background{ color Black }



// General sun 
light_source{<-100,1,500> color rgb<1,0.8,0.2> }
light_source{<100,1,500> color rgb<1,0.8,0.2> }
               
// Nice sunset tinting               
light_source{<0,3,200> color Red }


// Submarine glow
light_source{<0,-50,-100> rgb<0.25, 0.5, 1> }



global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	motion_blur 5,0.0500
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}


object
{
        NICE_BERG            
        
	pigment{ rgbf <1, 1, 1, 0.1> }
	finish{ reflection 0.05 ambient 0.05 }
	normal { granite 0.4 scale <3, 3, 3> }
	        
        rotate y*45
        translate <10, 0, 5>        
}


object
{
       BERG_1
       scale 2
       translate <-20, 0, 15>
       
	pigment{ rgbf <1, 1, 1, 0.1> }
	finish{ reflection 0.05 ambient 0.05 }
	normal { granite 0.1 scale <3, 3, 3> }       
}

object
{
       ICE_FLOE
       //scale 2
       rotate <0, 0, 0>
       translate <-1, -0.5, -2>
       
	pigment{ rgbf <1, 1, 1, 0.1> }
	finish{ reflection 0.05 ambient 0.05 }
	normal { granite 0.1 scale <3, 3, 3> }       
}


object
{
        ICE_SHELF                   
        
        rotate y*-70
        scale 10                            
        translate <-40, -6, 30>
        
	pigment{ rgbf <1, 1, 1, 0.01> }
	finish{ reflection 0.05 ambient 0.2 }
	normal { bumps 0.1 }               
	         
	// Remove awkward shadow cast on cloud 
	// by submarine glow         
	no_shadow
}


#if (USE_WATER = TRUE)
     
// Water    
plane
{
        <0,1,0>,0               
        
        pigment { rgbt <0, 0.3, 0.8, 0.9> }                   
        finish { conserve_energy reflection_type 1 reflection 0.5 }
        normal { granite 0.7 scale 10 }     
        
        interior            
        {           
           ior 1.33
           media { absorption rgb <0.2834, 0.0434, 0.0092> }
        } 
        
        hollow
}

#end


#if (USE_PENGUINS = TRUE)

//P-P-P-Penguin :-)
object{ 
P_mesh_obj           
rotate y*45
scale 0.05
translate <20,10,20> 
}

//P-P-P-Penguin :-)
object{ 
P_mesh_obj           
rotate y*100
scale 0.05
translate <-20,8,20> 
}


//P-P-P-Penguin :-)
/*
object{ 
P_mesh_obj           
rotate y*100
scale 0.04
translate <-2.5,6,-1> 
}
*/
#end



#if (USE_SKY = TRUE)

// Sky
sphere
{
        <0,0,0>,1000
        hollow
        
        pigment
        {            
                gradient y
                color_map
                {
                        [0.015  rgbt<1, 1, 0.7, 0.05>]
                        [0.04 rgbt<1, 0.75, 0.3, 0.1>]
                        [0.1  rgbt<1, 0.5, 0.5, 0.3>]
                        [0.25  rgbt<0.3, 0.3, 0.8, 0.3>]
                        [1    rgbt<0, 0, 0, 1>]
                }         
                                 
                scale 1000
        }       
        
        finish { Luminous }                                   
}


// Clouds
plane
{              
    <0, 1, 0>, 70
    texture { P_Cloud1 scale 20 translate <0, 0, 50> }
    hollow                           
} 

         
// Sun   
sphere
{
        <0,0,0>,1
                                
        pigment { color rgbt<1,1,1,1> }
        hollow
        
        interior                
        {
                media
                {         
                  emission 1
                  method 3
                  intervals 1
                  samples 5, 5
                  emission_type 2
                  emission_extinction 2
                  density {
                    spherical
                    color_map {
                      [ 0.0 rgbt <0, 0, 0, 1> ]
                      [ 0.1 rgbt <1.0, 1.0, 0.7, 0.8> ]
                      [ 0.5   rgb <1, 1, 0.8> ]                      
                    }
                    turbulence 0.03
                  }                      
                }
        }
 
        
        scale 60 
        translate <0, 10, 1100>
        
}          

#end