#version 3.5;

#macro Cylinder_Object(CStart, CVec, CWidth, CAng, CLev)
  #local cylLen  = 4 * ((rand(myRand) + 0.5)/CLev);
  #local cylTran = transform{
    rotate x*(2 * CAng * rand(myRand) - CAng)
    rotate y*(360 * rand(myRand))
    Reorient_Trans(y * 1, CVec)
    translate CStart
  }
  #declare segPosB = vtransform(y * cylLen, cylTran);
  #declare segVec = segPosB - CStart;
  cylinder{
    0, y * cylLen, CWidth, 1
    transform{cylTran}
  }
#end

#macro Make_Tree(TArraySize, TSeed, TBWidth, THt, TCutoff, TBranch, TAng, TLevs)

  #declare PosArray = array[TArraySize];
  #declare VecArray = array[TArraySize];
  #declare WidArray = array[TArraySize];
  #declare LevArray = array[TArraySize];
  #declare PosArray[0] = <0,0,0>;
  #declare VecArray[0] = <0,1,0>;
  #declare WidArray[0] = TBWidth;
  #declare LevArray[0] = 1;

  #declare checkCount = -1;
  #declare highCount  = 0;
  #declare myRand     = seed(TSeed);

  #declare Tree =
  blob{
    threshold 0.5
    #while (checkCount < highCount)
 
      #declare checkCount = checkCount + 1;
      #declare segPosA    = PosArray[checkCount];
      #declare segVec     = VecArray[checkCount];
      #declare segWidth   = WidArray[checkCount];
      #declare segLev     = LevArray[checkCount];
      #declare segPosB    = segPosA;
      #declare CarryOn    = true;

      #while(vlength(segPosB) < THt & segWidth > 0.05 & CarryOn)
        #declare segPosA = segPosB;
        Cylinder_Object(segPosA, segVec, segWidth, TAng, segLev)

        #declare randNum = rand(myRand);
        #if(randNum > 1 - ((segLev^2)/250) | (segPosB.y < TCutoff & segLev > 1))
          #declare CarryOn = false;
        #end
        #if (randNum < (TBranch/(segLev^0.25)) & segLev < TLevs & segPosB.y > TCutoff)
          #declare segWidth  = segWidth * 0.75;
          #declare highCount = highCount + 1;
          
          #declare PosArray[highCount] = segPosB;
          #declare VecArray[highCount] = segVec;
          #declare WidArray[highCount] = segWidth * 0.95;
          #declare LevArray[highCount] = segLev + 1;
        #end
      #end
    #end
  }
#end

#macro MakeWall(WallHi, WallStart, WallEnd, WallSeed)
  #declare Rand1 = seed(WallSeed);
  #declare BestY = 0;
  #declare Count = 0;
  #declare WallGround = object{Ground};
  #declare Building = true;
  #while(Building)
  
  #declare RX = (rand(Rand1)/2 + 0.75)*2;
  #declare RY = (rand(Rand1)/2 + 0.75)*2;
  #declare RZ = (rand(Rand1)/2 + 0.75)*2;
  #declare RF = (rand(Rand1)/1);
  #ifdef(fn_X)
    #undef fn_X
  #end 
  #declare fn_X = function(x,y,z) { sqrt(x^2 + y^2 + z^2) + f_noise3d(x*RX,y*RY,z*RZ)/(1.5+RF) - 1}
  #declare WallBrick = 
  isosurface {
    function {fn_X(x,y,z)}
    contained_by{sphere{0,2}}
    accuracy 0.001
    max_gradient 4
  }
  #declare XScale = rand(Rand1)*1/2 + 0.5;
  #declare YScale = rand(Rand1)*1/2 + 0.5; 
  #declare ZScale = rand(Rand1)*1/2 + 0.5;
  #declare Brick = object{
    WallBrick scale<XScale, YScale, ZScale>
    texture{
      pigment{
        granite scale 0.25 pigment_map{
          [0.0 Gray50]
          [0.5 Gray70]
          [1.0 Gray90]
        }
      }
      normal{granite}
    }
    texture{
      pigment{
        leopard turbulence 0.25 scale 0.2 pigment_map{
          [0.2 rgbf 1]
          [0.4 rgbf<0.55,0.55,0.30,0.85>]
          [0.6 rgbf<0.60,0.55,0.30,0.75>]
        }
      }
      normal{granite 1/2 scale 0.1}
    }
  }

  #declare BestY = 1000;
  #declare BestYG = -1000;
  #declare TraceX = WallStart;
  #while(TraceX <= WallEnd)
    #declare Start = <TraceX, 500, 0>; 
    #declare InterA = trace (WallGround, Start, <0, -1, 0>);
    #declare InterB = trace (Ground, Start, <0, -1, 0>);
    #if((InterA.y-InterB.y) < (BestY - BestYG))
        #declare BestX = InterA.x;
        #declare BestY = InterA.y;
        #declare BestYG = InterB.y;
      #end
      #if((InterA.y-InterB.y) > WallHi)
        #declare Building = false;
      #end
      #declare TraceX = TraceX + (2*XScale);
    #end
    #declare Count = Count + 1;
    #declare WallGround = union{
      object{WallGround}
      #declare YScale = YScale *((WallHi-(InterA.y-InterB.y))/(2*WallHi) + 0.50);
      #declare ZScale = ZScale * ((WallHi-(InterA.y-InterB.y))/(4*WallHi) + 0.75);
      object{Brick scale<1, YScale, ZScale> translate<BestX, BestY + YScale, 0>}
    }
    #ifdef(Wall)
      #declare Wall = union{
        object{Wall}
        object{Brick translate<BestX, BestY + YScale, 0>}
      }
    #else
      #declare Wall = object{Brick translate<BestX, BestY + YScale, 0>}
    #end
  #end
#end

#macro MakeSnow(TO,TB,BRS,TY,MY,XR,ZR,BR)
  #local BRand1 = seed(BRS);
  #local BCount1 = 1;
  #local Working = true;
  #while(Working)
    #if(BCount1 >= TB) #local Working = false; #end    
    #local XTrans = XR*rand(BRand1)-XR/2;
    #local ZTrans = ZR*rand(BRand1)-ZR/2;
    #local Norm = <0,0,0>;
    #local Inter = trace(TO, <XTrans+(TY/2), TY, ZTrans-(TY/4)>, <-TY/2,-TY,TY/4>, Norm);
    #local BlobTrans = Inter;
    #if(vlength(Norm)!=0 & Inter.y <= MY)
      sphere{
        0,BR,1
        scale<1,0.5,1>
        transform{Reorient_Trans(y, Norm)}
        translate BlobTrans
      }
      #local BCount1 = BCount1 + 1;
    #end
  #end
#end

#declare SnowTex =
texture{
  pigment{rgb <0.99,0.99,1>*3}
  finish{ambient 0.40 diffuse 0.8}
  normal{
    average
    normal_map{
      [dents 1/2 scale 1/50]
      [bozo 1 scale 4 turbulence 0.75]
    }
  }
}

#declare treeNorm =
  normal{
    average normal_map{
      [1.00 agate 3 scale 1]
      [1.00 crackle 6 scale 1/3]
      [1.00 dents 5]
    }
  }
  
#declare barkTexture =
texture{
  normal{treeNorm}
  pigment{bozo scale 2 turbulence 0.25
    pigment_map{
      [0 rgb<0.6,0.5,0.4>*1.75]
      [1 rgb<0.5,0.4,0.3>*1.75]
    }
  }
}
#declare mossTexture =
texture{
  normal{treeNorm}
  pigment{
    bozo scale 5 
    pigment_map{
      [0 rgb<0.35,0.4,0.1>*1.5]
      [1 rgb<0.2,0.4,0.1>*1.5]
    }
  }
}
#declare treeTexture =
texture{
  crackle turbulence 0.25 scale 2
  texture_map{
    [0.0 barkTexture]
    [1.0 mossTexture]
  }
}
