// Basket Definitions and Macro
//
#declare BasketCon1=union{
   #declare R1=1;
   #while (R1<=60)
       #declare ROY=rand(RS)*360;
       #declare RD=rand(RS)*.22;
       #declare ROD=rand(RS)*.025+.025;
       sphere{<0,0,0>ROD translate<RD,-.05+ROD,0> rotate<0,ROY,0>}
       #declare R1=R1+1;
   #end                
   #declare R1=1;
   #while (R1<=30)
       #declare ROY=rand(RS)*360;
       #declare RD=rand(RS)*.15;
       #declare ROD=rand(RS)*.025+.025;
       sphere{<0,0,0>ROD translate<RD,.025+ROD,0> rotate<0,ROY,0>}
       #declare R1=R1+1;
   #end             
   #declare R1=1;
   #while (R1<=15)
       #declare ROY=rand(RS)*360;
       #declare RD=rand(RS)*.1;
       #declare ROD=rand(RS)*.025+.025;
       sphere{<0,0,0>ROD translate<RD,.075+ROD,0> rotate<0,ROY,0>}
       #declare R1=R1+1;
   #end      
}     

#declare BasWeave=intersection{
  difference{
     torus{.05,.025}
     cylinder{<0,-.026,0><0,.026,0> .0255}
    translate<-.05,0,0>
  } 
//  torus{.35,.025 translate<-.35,0,0>}
  //cylinder{<-.3,-.025,0><-.3,.025,0> .3}
  box{<-.008,-.025,-.04><.058,.025,.04>}
}

#declare BasHandle=difference{
    torus{.2,.035 rotate<90,0,0>}
    box{<-2.11,-2.11,-.06><2.11,0,.06>} // carve off bottom
}
  
#declare Basket=union{
  torus{.54,.035 translate<0,1.25,0>}
  #declare R1=0;
  #while (R1<360)
    #declare R2=.65; //=.035;
    #while (R2<1.25)
      object{BasWeave scale<1,1,.75+(R2/1.25)/2> translate<.33+(.22*(R2/1.25)),R2-.035,0> rotate<0,R1,0>}
      object{BasWeave scale<1,1,.75+(R2/1.25)/2> translate<.34+(.22*(R2/1.25)),R2+.035,0> rotate<0,R1+6,0>}
      #declare R2=R2+.14;
    #end
    cylinder{<.45,.60,0><.55,1.25,0> .015 rotate<0,R1+6,0> texture{T_Wood3 scale .25 rotate<90,0,0>}} 
    cylinder{<.45,.60,0><.55,1.25,0> .015 rotate<0,R1,0> texture{T_Wood3 scale .25 rotate<90,0,0>}}
    torus{.035,.015 rotate<90,0,0> translate<.35,.60,0> rotate<0,R1,0>}
    torus{.035,.015 rotate<90,0,0> translate<.35,.60,0> rotate<0,R1+6,0>}  
    torus{.035,.015 rotate<90,0,0> translate<.54,1.25,0> rotate<0,R1,0>}
    torus{.035,.015 rotate<90,0,0> translate<.54,1.25,0> rotate<0,R1+6,0>}    
    #declare R1=R1+12;
  #end
  
  object{BasHandle rotate<25,0,0> translate<0,1.25,.505>}
  object{BasHandle rotate<-25,0,0> translate<0,1.25,-.505>}
//  difference{
//    cone{<0,0,0> .35 <0,1.25,0> .5}
//    cone{<0,.02,0> .03 <0,1.251,0> .45}
//  }
  torus{.43,.035 translate<0,.6,0>}
  cylinder{<0,.6,0><0,.605,0> .43} // bottom of basket
}
#declare BasketA=object{
  Basket  
  scale .5
  translate<0,-.6*.5,0> // rezero base
//  texture{T_Wood5 scale .25}
} 
#declare BasketA1=object{BasketA  texture{T_Wood1 scale .15}}
#declare BasketA2=object{BasketA  texture{T_Wood2 scale .15}}
#declare BasketA3=object{BasketA  texture{T_Wood3 scale .15}}
#declare BasketA4=object{BasketA  texture{T_Wood4 scale .15}}
#declare BasketA5=object{BasketA  texture{T_Wood5 scale .15}}
#declare BasketA6=object{BasketA  texture{T_Wood6 scale .15}}
#declare BasketA7=object{BasketA  texture{T_Wood7 scale .15}}
#declare BasketA8=object{BasketA  texture{T_Wood8 scale .15}}
#declare BasketA9=object{BasketA  texture{T_Wood9 scale .15}}

#declare BasketB=object{
  Basket  
  scale <.5,.65,.25>
  translate<0,-.6*.65,0> // rezero base
//  texture{T_Wood3 scale .25}
} 
#declare BasketB1=object{BasketB  texture{T_Wood1 scale .15}}
#declare BasketB2=object{BasketB  texture{T_Wood2 scale .15}}
#declare BasketB3=object{BasketB  texture{T_Wood3 scale .15}}
#declare BasketB4=object{BasketB  texture{T_Wood4 scale .15}}
#declare BasketB5=object{BasketB  texture{T_Wood5 scale .15}}
#declare BasketB6=object{BasketB  texture{T_Wood6 scale .15}}
#declare BasketB7=object{BasketB  texture{T_Wood7 scale .15}}
#declare BasketB8=object{BasketB  texture{T_Wood8 scale .15}}
#declare BasketB9=object{BasketB  texture{T_Wood9 scale .15}}
         
#declare BasketC=object{
  Basket  
  scale .25
  translate<0,-.6*.25,0> // rezero base
//  texture{T_Wood1 scale .15}
} 
#declare BasketC1=object{BasketC  texture{T_Wood1 scale .15}}
#declare BasketC2=object{BasketC  texture{T_Wood2 scale .15}}
#declare BasketC3=object{BasketC  texture{T_Wood3 scale .15}}
#declare BasketC4=object{BasketC  texture{T_Wood4 scale .15}}
#declare BasketC5=object{BasketC  texture{T_Wood5 scale .15}}
#declare BasketC6=object{BasketC  texture{T_Wood6 scale .15}}
#declare BasketC7=object{BasketC  texture{T_Wood7 scale .15}}
#declare BasketC8=object{BasketC  texture{T_Wood8 scale .15}}
#declare BasketC9=object{BasketC  texture{T_Wood9 scale .15}}
      
#declare BasketD=object{
  Basket  
  scale <.5,.8,.5>
  translate<0,-.6*.8,0> // rezero base
//  texture{T_Wood7 scale .15}
}
#declare BasketD1=object{BasketD  texture{T_Wood1 scale .15}}
#declare BasketD2=object{BasketD  texture{T_Wood2 scale .15}}
#declare BasketD3=object{BasketD  texture{T_Wood3 scale .15}}
#declare BasketD4=object{BasketD  texture{T_Wood4 scale .15}}
#declare BasketD5=object{BasketD  texture{T_Wood5 scale .15}}
#declare BasketD6=object{BasketD  texture{T_Wood6 scale .15}}
#declare BasketD7=object{BasketD  texture{T_Wood7 scale .15}}
#declare BasketD8=object{BasketD  texture{T_Wood8 scale .15}}
#declare BasketD9=object{BasketD  texture{T_Wood9 scale .15}}
                  
#declare BasketE=object{
  Basket  
  scale <.35,.5,.75>
  translate<0,-.6*.5,0> // rezero base
//  texture{T_Wood8 scale .15}
}
#declare BasketE1=object{BasketE  texture{T_Wood1 scale .15}}
#declare BasketE2=object{BasketE  texture{T_Wood2 scale .15}}
#declare BasketE3=object{BasketE  texture{T_Wood3 scale .15}}
#declare BasketE4=object{BasketE  texture{T_Wood4 scale .15}}
#declare BasketE5=object{BasketE  texture{T_Wood5 scale .15}}
#declare BasketE6=object{BasketE  texture{T_Wood6 scale .15}}
#declare BasketE7=object{BasketE  texture{T_Wood7 scale .15}}
#declare BasketE8=object{BasketE  texture{T_Wood8 scale .15}}
#declare BasketE9=object{BasketE  texture{T_Wood9 scale .15}}

#declare BasketF=object{
  Basket  
  scale .15
  translate<0,-.6*.15,0> // rezero base
//  texture{T_Wood1 scale .15}
}
#declare BasketF1=object{BasketF  texture{T_Wood1 scale .15}}
#declare BasketF2=object{BasketF  texture{T_Wood2 scale .15}}
#declare BasketF3=object{BasketF  texture{T_Wood3 scale .15}}
#declare BasketF4=object{BasketF  texture{T_Wood4 scale .15}}
#declare BasketF5=object{BasketF  texture{T_Wood5 scale .15}}
#declare BasketF6=object{BasketF  texture{T_Wood6 scale .15}}
#declare BasketF7=object{BasketF  texture{T_Wood7 scale .15}}
#declare BasketF8=object{BasketF  texture{T_Wood8 scale .15}}
#declare BasketF9=object{BasketF  texture{T_Wood9 scale .15}}
       
#macro GetBasket()
  #declare NumB=6*9;
  #declare BaS=int(rand(RS)*NumB+1);
     #switch(BaS)      
       #case (1) BasketA1 #break
       #case (2) BasketA2 #break
       #case (3) BasketA3 #break
       #case (4) BasketA4 #break
       #case (5) BasketA5 #break
       #case (6) BasketA6 #break
       #case (7) BasketA7 #break
       #case (8) BasketA8 #break
       #case (9) BasketA9 #break
       #case (10) BasketB1 #break
       #case (11) BasketB2 #break
       #case (12) BasketB3 #break
       #case (13) BasketB4 #break
       #case (14) BasketB5 #break
       #case (15) BasketB6 #break
       #case (16) BasketB7 #break
       #case (17) BasketB8 #break
       #case (18) BasketB9 #break
       #case (19) BasketC1 #break
       #case (20) BasketC2 #break
       #case (21) BasketC3 #break
       #case (22) BasketC4 #break
       #case (23) BasketC5 #break
       #case (24) BasketC6 #break
       #case (25) BasketC7 #break
       #case (26) BasketC8 #break
       #case (27) BasketC9 #break       
       #case (28) BasketD1 #break
       #case (29) BasketD2 #break
       #case (30) BasketD3 #break
       #case (31) BasketD4 #break
       #case (32) BasketD5 #break
       #case (33) BasketD6 #break
       #case (34) BasketD7 #break
       #case (35) BasketD8 #break
       #case (36) BasketD9 #break     
       #case (37) BasketE1 #break
       #case (38) BasketE2 #break
       #case (39) BasketE3 #break
       #case (40) BasketE4 #break
       #case (41) BasketE5 #break
       #case (42) BasketE6 #break
       #case (43) BasketE7 #break
       #case (44) BasketE8 #break
       #case (45) BasketE9 #break
       #case (46) BasketF1 #break
       #case (47) BasketF2 #break
       #case (48) BasketF3 #break
       #case (49) BasketF4 #break
       #case (50) BasketF5 #break
       #case (51) BasketF6 #break
       #case (52) BasketF7 #break
       #case (53) BasketF8 #break
       #case (54) BasketF9 #break
     #end //switch(BS)
#end // macro GetBasket()