// Cart Defs
// Robert J Becraft

#declare CartBranch=union{
  cone{<0,0,0>.035 <0,.1,.02> .036}
  sphere{<0,.1,.02> .0365}
  cone{<0,.1,.02> .036 <0,.25,-.02> .035}
  sphere{<0,.25,-.02> .0355}
  cone{<0,.25,-.02> .035 <.02,.35,.02> .03}
  sphere{<.02,.35,.02> .0305}
  cone{<.02,.35,.02> .03 <0,.5,0> .025}
 texture{T_Wood8 rotate<90,0,0> scale .25}
}

#declare CartWheel1=difference{
  cylinder{<0,0,-.035><0,0,.035> .5}
  cylinder{<0,0,-.04><0,0,.04> .4}
 texture{T_Wood8}
}

#declare CartWheelRim=difference{
  cylinder{<0,0,-.03505><0,0,.03505> .51}
  cylinder{<0,0,-.04><0,0,.04> .5}
 texture{pigment{color Gray60}}
}

#declare CartAxel=union{
  cone{<0,0,0>.14<0,0,.10> .12}
  cone{<0,0,0>.14<0,0,-.10> .12}
  cylinder{<0,0,-.12><0,0,.12> .10}
  cone{<0,0,-.2> .05 <0,0,0> .09}  
  cone{<0,0,.2> .05 <0,0,0> .09}
  #declare R1=0;
  #while (R1<360)
     cylinder{<0,0,0><0,.4,0> .025 texture{T_Wood8 rotate<90,0,0>} rotate<0,0,R1>}
     #declare R1=R1+30;
  #end
 texture{T_Wood8}
}
#declare Wheel=union{
  object{CartWheel1}
  object{CartWheelRim}
  object{CartAxel}
}
#declare RBS=seed(993);
#declare Cart1=union{
  object{Wheel translate<0,0,.75>}
  object{Wheel translate<0,0,-.75>}
  union{
    cylinder{<0,0,-1><0,0,1> .035}
    torus{.05,.01 rotate<90,0,0> translate<0,0,-.45>}
    torus{.05,.01 rotate<90,0,0> translate<0,0,-.25>}
    torus{.05,.01 rotate<90,0,0> translate<0,0,0>}
    torus{.05,.01 rotate<90,0,0> translate<0,0,.25>}
    torus{.05,.01 rotate<90,0,0> translate<0,0,.45>}                
   texture{pigment{color Gray60}}
  } 
  box{<-.05,.05,-.5><.05,.15,.5> texture{T_Wood8}} 
  
  union{  
    box{<-1,.10,-.425><.77,.175,-.475>}
    box{<-1,.10,-.225><.77,.175,-.275>}
    box{<-1,.10,-.025><.77,.175,.025>}
    box{<-1,.10,.225><.77,.175,.275>}
    box{<-1,.10,.425><.77,.175,.475>}  
    
    box{<-2.25,.10,-.4><0,.175,-.45> rotate<0,5,0>}
    box{<-2.25,.10,.4><0,.175,.45> rotate<0,-5,0>}
    
   texture{T_Wood8 rotate<0,90,0> scale .2}
  }
  union{
    #declare R1=-.98;
    #while (R1<.75)
      #declare ROY=rand(RBS)*4-2;
      #declare RY=rand(RBS)*.1-.05;
      box{<-.045,.175,-.55><.045,.2,.55> rotate<0,ROY,0> translate<R1,0,RY>}
      #declare R1=R1+.11;
    #end
   texture{T_Wood8 translate<.5,0,0> scale .2}
  }            
  union{
    #declare R1=-.925;
    #while (R1<.75)
      #declare ROY=rand(RBS)*360;
      #declare RYS=rand(RBS)*.1+1;
      object{CartBranch rotate<0,ROY,0> scale <1,RYS,1> translate<R1,.175,-.55>}
      #declare ROY=rand(RBS)*360;
      #declare RYS=rand(RBS)*.1+1;
      object{CartBranch rotate<0,ROY,0> scale <1,RYS,1> translate<R1,.175,.55>}
      #declare R1=R1+.4;
    #end
  }             
  union{
    #declare R1=-.725;
    #while (R1<.75)
      #declare RN=int(rand(RBS)*4+4);
      #declare RNC=1;
      #while (RNC<RN)
        #declare ROY=rand(RBS)*30-15;
        #declare ROZ=rand(RBS)*10-5;        
        #declare RYS=rand(RBS)*.1+1;
        #declare RXS=rand(RBS)*.1+1;
        cylinder{<-.2,0,0><.2,0,0> .015*RYS scale <RXS,1,1> rotate<0,ROY,ROZ>  translate<R1,.175+.5*RNC/6,-.55>}
        #declare RNC=RNC+1;
      #end 
      #declare RN=int(rand(RBS)*4+4);
      #declare RNC=1;
      #while (RNC<RN)
        #declare ROY=rand(RBS)*30-15;
        #declare ROZ=rand(RBS)*10-5;        
        #declare RXS=rand(RBS)*.1+1;
        cylinder{<-.2,0,0><.2,0,0> .015*RYS scale <RXS,1,1> rotate<0,ROY,ROZ>  translate<R1,.175+.5*RNC/6,.55>}
        #declare RNC=RNC+1;
      #end
      #declare R1=R1+.4;
    #end 
    texture{T_Wood8 rotate<0,90,0> scale .1} 
  }
  translate<0,.51,0> // raise to ground level
}