//EMAIL: castlewrks@aol.com
//NAME: Robert J Becraft
//TOPIC: Winter
//COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//TITLE: Winter's First Breath
//COUNTRY: USA
//WEBPAGE: http://user.aol.com/castlewrks
//         http://www.angelfire.com/md2/castlewrks
//RENDERER USED: POV 3.1g
//TOOLS USED: IView32 (JPG conversion), PSP (Adding copyright), POSER, UVMapper, OBJ2POV
//RENDER TIME:  8 hours 38 minutes, 102 Meg of memory
//HARDWARE USED: Pentium 433
//IMAGE DESCRIPTION:
//        
//As always, I tie this to my medieval D&D world...
//
//It is the winter solstice festival and market in a small town. Under the White and Gray towers in the town's central square, 
//shoppers are surprised by the winters first snow.  One of the younger ladies is very happy and twirls in the open space.
//
//DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//All of the buildings, booths, and booth objects were created in raw POV.
//Random loops are used for size, color and contents of the booths.  
//
//I'm especially proud of the baskets... they are composed of actual weaves and hold up very nicely to closeup tracing.
//
//All of the figures were built in POSER and generated as an image on a black background.  They are included as imagemaps on squares.
//
//The snow was created in Windows paint program with the aid of the spray feature.  White flakes were sprayed on a black background
//with the right density to give the intended effect.  If you look closely, you will find layers of snow, the ones farther back are
//restricted by the pel size of the image.
//
//When you include imagemaps where you are making the background invisible, you will need max_trace_level in the global_settings below
//to ensure that you don't get black patches where the ray stops penetrating multiple layers of imagemaps.
//               
//The final image was done with only one of each of the 4 lights on on the lampposts... the first attempt with the whole boat was
//shaping up to be about 80 hours worth of render time.
//
//Ding notice:  Poser is surprisingly lacking in winter medieval objects... so those ladies in the front of the image are only 
//slightly clothed, they are tough medieval wenches.  I probably spent more time surfing for more clothing than I did in making all the
//rest of the image.
//
#include "finish.inc"
#include "kolors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "Glass.inc"
#include "golds.inc"

 global_settings {
                  radiosity{
                            brightness 4      // 3.3 default
                            count 150            // 100 default 
                            distance_maximum 15 //0 default
                            error_bound .3      // .4 default
                            gray_threshold .7   // .5 default
                            low_error_factor .8 // .8 default
                            minimum_reuse .015  // .015 default
                            nearest_count 6     // 6 default
                            recursion_limit 2   // 1 default 
                           }
                    max_trace_level 25          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }

//#declare NoMist=off; // uncomment to turn off
//#declare NoSnow=off; // uncomment to turn off
//#declare NoBuildings=off; // uncomment to turn off
//#declare NoPeople=off; // uncomment to turn off
#declare Lighted=yes; // turns on lights
#declare NoSnowHF=off;  // not used.

#declare RS=seed(99); // Random seed

camera
{
  location <14,2.5,-19> up y right 4/3*x look_at<-5,3,10>   
}

#declare Block=1;

light_source {  <15,1000,-1000> color White }    
light_source {  <10,5,-20> color Wheat shadowless}

#ifndef(NoMist)
//------------------------------ Water Mist
#declare Mistpig=pigment{bumps 
              scale <15,45,15>
              rotate z*30 turbulence 2.75
              color_map{
                        [.25 rgbf<1 1 1 1>]
                        [.95 rgbf<1 1 1 .65>]
                       }
              }   
plane{y,.01 
      pigment{Mistpig}
      normal{bumps .001}
      finish{diffuse 1.3}
      hollow
     }

#ifndef(NoSnow)
#declare Snowx=box{<0,0,0><1,1,.001> hollow 
                    translate<-.5,0,0>  scale <75,50,1> 
                   texture{pigment{image_map { png "..\graphics\snow.png" transmit 0, 1.0} 
                                    }
                          scale <2,2,1>          
                          }                  
                   }
#declare Snowy=box{<0,0,0><1,1,.001> hollow 
                   translate<-.5,0,0>  scale <75,50,1>
                   texture{pigment{image_map { png "..\graphics\snow2.png" transmit 0, 1.0} 
                                  }
                           scale <2,2,1>
                           }                    
                   }       
//#declare Snowz=box{<0,0,0><1,1,.001> hollow 
//                   translate<-.5,0,0>  scale <75,50,1>
//                   texture{pigment{image_map { png "..\graphics\snow3.png" transmit 0, 1.0} 
//                                  }
//                           scale <5,5,1>
//                           }                    
//                   }                   

//object{Snowz rotate<0,-20,0>translate<0,0,-16>}
object{Snowy rotate<0,160,0> translate<0,0,-18.5>}
object{Snowx rotate<0,-20,0>translate<0,0,-14>}
//object{Snowx rotate<0,160,0> translate<0,0,-12>}
//object{Snowx rotate<0,-20,0>translate<0,0,-10>}
//object{Snowy rotate<0,160,0> translate<0,0,-8>}


//object{Snowx rotate<0,-20,0> translate<0,0,-5>}
//object{Snowx rotate<0,160,0> translate<0,0,5>}
#end //ifndef(NoSnow)
     
fog {                                                 // White ground fog
  distance 50
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 10
  fog_alt 4
  turbulence 11.0
  turb_depth 13.0
}
#end 

//#include "..\med\cloud.inc"

#declare T_WhiteCobbles = // for streets
   texture{brick texture{pigment{color Gray40}},texture{T_Grnt20 scale .5}
       brick_size <.15,.15,.15>
       mortar 0.025
}
#declare T_TanCobbles = // for streets
   texture{brick texture{pigment{color Tan}},texture{T_Grnt20 scale .5}
       brick_size <.17,.17,.17>
       mortar 0.025
}
#declare RoofText=texture{
            pigment {color SteelBlue  }
            normal { bumps 0.1  scale < .25, .25, .25 > }
    }

#include "..\med\brick.inc"

//-------------------------------------------------- Yellow Mixed Bricks

    #declare P_YellowBrickA = pigment { 
      bozo
      pigment_map {
        [0.00 colour Cornsilk1]
        [0.20 colour MediumWood ]
        [0.40 colour LightYellow3]
        [0.80 colour NewTan ]        
        [1.00 colour Cornsilk3]
      }
      scale 100
    }
 
    #declare P_YellowBrickB = pigment {P_YellowBrickA  warp { repeat x*8 offset <0,45,0> } }
    #declare P_YellowBrickC = pigment {P_YellowBrickB  warp { repeat y*3 offset <60,0,0> } }
   
    #declare P_Mortar = pigment {colour White }

    #declare P_YellowBrick = pigment {brick
        pigment { P_Mortar },
        pigment { P_YellowBrickC }
      mortar 0.35
    }    
        
    #declare T_YellowBrick = texture {
      pigment { P_YellowBrick }   //turbulence 0.075 }
    //  normal { granite 0.2 }
            normal{granite .85 
              turbulence .35} 
    //  rotate<0,45,0>
    scale .0825
    }      
#declare T_YellowStuccoBrick =
texture{T_YellowBrick }
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgbf <0.7969, 0.7969, 0.7969, .35>]
            [0.05 rgbf <0.8945, 0.8945, 0.8945 .25>]
        //   [0.1 rgbf <0.0117, 0.0117, 0.0117, .25>]
        //    [0.3 rgbf <0.1840, 0.3090, 0.1840, .25>]
            [0.2 rgbf <1.0, 1.0, 1.0  1.0 >] // clear
            [1.0 rgbf <1.0, 1.0, 1.0, 1.0 >] // clear
        }
    }
   scale <25,15,25>
}          
#declare T_ColiseumStucco =
texture{T_YellowBrick}
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb Gray80]
            [0.05 rgb Gray90]
        //   [0.1 rgbf <0.0117, 0.0117, 0.0117, .25>]
        //    [0.3 rgbf <0.1840, 0.3090, 0.1840, .25>]
            [0.2 rgbf <1.0, 1.0, 1.0  1.0 >] // clear
            [1.0 rgbf <1.0, 1.0, 1.0, 1.0 >] // clear
        }
    }
   scale <250,250,250>
}           
#declare T_LumpyStucco =
texture{T_YellowBrick }
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb Gray80]
            [0.05 rgb Gray90]
        //   [0.1 rgbf <0.0117, 0.0117, 0.0117, .25>]
        //    [0.3 rgbf <0.1840, 0.3090, 0.1840, .25>]
            [0.24 rgbf <1.0, 1.0, 1.0  1.0 >] // clear
            [1.0 rgbf <1.0, 1.0, 1.0, 1.0 >] // clear
        }
    }
   scale <5,5,5>
}                  
#declare GreenVine =
texture{T_YellowBrick scale .06}
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb Gray80]
            [0.05 rgb Gray90]
            [0.1 rgbf <0.0117, 0.0117, 0.0117, .25>]
            [0.3 rgbf <0.1840, 0.3090, 0.1840, .25>]
            [1.0 rgbf <1.0, 1.0, 1.00, 1.0 >] // clear
        }
    }
   scale <5,50,5>
}    
//----------------------------------------------------------------------

//---------------------------------------
// Ground layout
cylinder{<0,0,0><0,-.001,0> 75  
         // texture{pigment{color Gray20}}
          texture{T_WhiteCobbles }  
}
box{<8,0,-100><11,.001,200> rotate<0,-20,0> texture{T_TanCobbles rotate<0,5,0>}}   
box{<-8,0,-100><-11,.001,200> rotate<0,-20,0> texture{T_TanCobbles rotate<0,5,0>}}   
box{<-8,0,-100><-11,.001,200> rotate<0,40,0> texture{T_TanCobbles rotate<0,5,0>}} 
box{<-100,0,5><100,.001,8> rotate<0,20,0> texture{T_TanCobbles rotate<0,-5,0>}}
box{<-100,0,-5><100,.001,-8> rotate<0,20,0> texture{T_TanCobbles rotate<0,-5,0>}}

#declare Arch=difference{
  cylinder{<0,0,-.5><0,0,.5> 1.25} 
  cylinder{<0,0,-.51><0,0,.51> 1}
  #declare R1=-11.25;
  #while (R1<180)
     box{<-1.25,.01,-.51><1.25,-.01,.51> rotate<0,0,R1>}
     #declare R1=R1+22.5;
  #end
  box{<-1.26,-1.26,-.51><1.26,0,.51>} // chop off bottom
}
#declare Arch2=difference{
  cylinder{<0,0,-.2><0,0,.2> 1.25} 
  cylinder{<0,0,-.21><0,0,.21> 1}
  #declare R1=-11.25;
  #while (R1<180)
     box{<-1.25,.01,-.21><1.25,-.01,.21> rotate<0,0,R1>}
     #declare R1=R1+22.5;
  #end
  box{<-1.26,-1.26,-.51><1.26,0,.51>} // chop off bottom
}
#declare StarBlade=union{
  cylinder{<0,0,0><0,-1,0> .025  rotate<0,0,-35.5> translate<.15,.5,0>}
 // cylinder{<.3,.5,0><0,-.5,0> .03} 
}   
  
#declare Star1=union{
  torus{.55,.045 rotate<90,0,0>}
  torus{.5,.03 rotate<90,0,0>}
  object{StarBlade}
  object{StarBlade rotate<0,0,-71>}
  object{StarBlade rotate<0,0,71>}
  object{StarBlade rotate<0,0,-142>}
  object{StarBlade rotate<0,0,142>}
                                    
  rotate<0,0,17.75>                                    
}   
#declare ColC=difference{
   cylinder{<0,0,0><0,1.5,0> .25}
   #declare R1=0;
   #while (R1<360)
      cylinder{<0,0,0><0,1.5,0> .035 translate<.275,0,0> rotate<0,R1,0>}
      #declare R1=R1+15;
   #end
}
#declare ColScroll=union{
  cylinder{<0,2.35,-.35><0,2.35,.35> .2}
  union{
    torus{.18,.02 rotate<90,0,0> translate<0,2.35,-.35>}
    torus{.08,.02 rotate<90,0,0> translate<0,2.35,-.35>}
    torus{.18,.02 rotate<90,0,0> translate<0,2.35,.35>}
    torus{.08,.02 rotate<90,0,0> translate<0,2.35,.35>}                                              
   texture{T_Gold_5B}
  }
}  
#declare Col1=union{
  union{
    torus{.32,.03 translate<0,.125,0>}
    torus{.365,.03 translate<0,.025,0>}
   // torus{.315,.03 translate<0,.47,0>}
    torus{.25,.03 translate<0,.53,0>}
   texture{T_Gold_5B}
  }    
  cylinder{<0,0,0><0,.05,0>.37}
  cylinder{<0,0,0><0,.1,0>.35}
  cylinder{<0,.1,0><0,.5,0> .3}
  cylinder{<0,.47,0><0,.49,0> .325}
  //cylinder{<0,.23,0><0,.24,0> .375}
  object{ColC translate<0,.5,0>}
  cylinder{<0,2,0><0,2.5,0> .3}
  object{ColScroll translate<-.35,0,0>}
  object{ColScroll translate<.35,0,0>} 
  
  box{<-.33,2.35,-.33><.33,2.5,.33>}
  box{<-.7,2.5,-.6><.7,2.75,.6>}
  
//  cylinder{<-.35,2.35,-.35><-.35,2.35,.35> .2}
//  cylinder{<.35,2.35,-.35><.35,2.35,.35> .2}
}

#declare TowerStairs=union{
cylinder{<0,-.25,0><0,0,0> 8.7 texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}
cylinder{<0,-.25,0><0,-.01,0> 8.751 texture{T_Stone12 scale .5}}
cylinder{<0,-.05,0><0,-.01,0> 8.85 texture{T_Stone8}}
torus{8.85,.025 translate<0,-.02,0> texture{T_Stone8}}

cylinder{<0,-.5,0><0,-.25,0> 8.95 texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}
cylinder{<0,-.5,0><0,-.2499950,0> 9.01 texture{T_Stone12 scale .5}}
cylinder{<0,-.3,0><0,-.25,0> 9.1 texture{T_Stone8}}
torus{9.1,.025 translate<0,-.25-.025,0> texture{T_Stone8}}   

cylinder{<0,-.75,0><0,-.5,0> 9.2 texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}
cylinder{<0,-.75,0><0,-.49999,0> 9.251 texture{T_Stone12 scale .5}}
cylinder{<0,-.55,0><0,-.5,0> 9.35 texture{T_Stone8}}
torus{9.35,.025 translate<0,-.525,0> texture{T_Stone8}}
}
#declare EagleWing=union{
   #declare Count=0;
   #while (Count<110)
     sphere{<0,0,0>.05 translate<0,.04,0> scale <.25,4.3+(Count/20),.5>  rotate<Count,0,0> texture{Bright_Bronze}}
     #declare Count=Count+5;
   #end
}
#declare EagleTail=union{
   #declare Count=-50;
   #while (Count<=50)
     sphere{<0,0,0>.05 scale <.25,3,.5> translate<0,-.12,0> rotate<Count,0,0> texture{Bright_Bronze}}
     #declare Count=Count+5;
   #end
}
#declare Eagle=union{
  object{EagleTail rotate<30,0,0> translate<-.10,-.5,0> rotate<0,90,0>}
  object{EagleWing rotate<0,0,200> rotate<0,80,0> rotate<0,-110,0> translate<-.13,.10,0>}
  object{EagleWing rotate<0,0,200> rotate<0,-80,0> rotate<0,110,0> translate<.13,.10,0>}
  difference{
    sphere{<0,0,0> .12 scale <1,5,1> texture{Bright_Bronze}}  // body
    torus{.15,.08 translate<0,.2,0> texture{Bright_Bronze}}
    box{<-.16,.25,-.16><.16,.80,.16>}  // take off top part
  }
  sphere{<0,.3,0> .1 scale<1,1.1,1> texture{Bright_Bronze}}  // head
  difference{
    sphere{<0,.25,0> .08 scale<.35,1,1> translate<0,0,-.05> texture{Bright_Bronze}}  // nose
    cylinder{<-.3,.2,0><.3,.2,0> .09 translate<0,0,-.05> texture{Bright_Bronze}}
    translate<0,.05,0>
  }
  sphere{<0,0,0> .017 translate<-.04,.37,-.09> texture{Bright_Bronze}}  // eyes
  sphere{<0,0,0> .017 translate< .04,.37,-.09> texture{Bright_Bronze}}
}
#declare TowerFpole=union{
  torus{.5,.05}
  torus{.5,.05 translate<0,1,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<.5,0,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<-.5,0,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<0,0,.5>}
  cylinder{<0,-2,0><0,1,0> .05 translate<0,0,-.5>}
  
  cylinder{<0,0,0><0,3,-3> .08}
  sphere{<0,3,-3> .15}
  object{Eagle rotate<-45,0,0> translate<0,3.2,-3>}
 texture{Bright_Bronze}
}
#declare CapDorm=union{
  difference{
    cylinder{<0,0,0><1.2,0,0> .5}
    cylinder{<0,0,0><1.3,0,0> .45}
   texture{Bright_Bronze}
  }
  cylinder{<0,0,0><1.1,0,0> .45 texture{T_Stone8}}
  rotate<0,90,0>
}
#declare TRoof=union{  
//  union{
   cone{<0,0,0>2.8 <0,2.5,0> 0 }
   cone{<0,0,0>1.5   <0,5,0> 0 }
   #declare R1=0;
   #while (R1<=180)
     triangle{<0,0,-2.87><0,0,2.87><0,2.57,0> rotate<0,R1,0>}
     triangle{<0,0,-1.57><0,0,1.57><0,5.07,0> rotate<0,R1,0>}    
     #declare R1=R1+22.5;
   #end                               
   
     object{CapDorm translate<0,.5,-1.15>}
   
   object{TowerFpole translate<0,5,0>}
    
   texture{Bright_Bronze}
  }
//l  #declare R1=0;
//  #while (R1<360)
//     object{CapDorm translate<2.5,14,0> rotate<0,R1,0>}
//     #declare R1=R1+45;
//  #end

//  object{T1b translate<0,2,0>}
//}

#macro DefWinA(PaintText,StoneText,WallText)

#declare Window=union{
  box{<-.25,.1,-.02><-.2,1.45,.02>}
  box{<.2,.1,-.02><.25,1.45,.02>}
  box{<-.01,.1,-.01><.01,1.45,.01>}
  
  box{<-.25,.1,-.02><.25,.15,.02>}
  box{<-.25,1.4,-.02><.25,1.45,.02>} 
  
  box{<-.25,.73,-.02><.25,.75,.02>}
  box{<-.25,.39,-.01><.25,.41,.01>}
  box{<-.25,1.09,-.01><.25,1.11,.01>}
 texture{PaintText}
}
  
#declare WinAInsert=union{  
   difference{       // framing
     cylinder{<0,0,-.03><0,0,.03>.851}
     cylinder{<0,0,-.04><0,0,.04>.8}
     box{<-1.1,-1.1,-.04><1.1,.3,.04>}
     translate<0,1,0>
   }                
   difference{       // solid insert
     cylinder{<0,0,-.02><0,0,.02>.851}
 //    cylinder{<0,0,-.03><0,0,.03>.8}
     box{<-1.1,-1.1,-.03><1.1,.45,.03>}
     translate<0,1,0>
   }
   box{<-.65,0,-.03><-.5,1.45,.03>} // verticals   
   box{<.5,0,-.03><.65,1.45,.03>}       
   box{<-.025,0,-.03><.025,1.45,.03>}
   
   box{<-.52,0,-.04><-.5,1.45,.04>} // frame
   box{<.5,0,-.04><.52,1.45,.04>}       
   box{<-.025,0,-.04><-.005,1.45,.04>}      
   box{<.025,0,-.04><.005,1.45,.04>}      
        

   object{Window translate<-.265,0,0>}
   object{Window translate<.265,0,0>}
  
  texture{WallText}
  normal{granite .4 scale<.5,.5,.5> turbulence .15} 
                   
}
#declare WinAOrnament=union{
  cylinder{<0,0,-.07><0,0,.07> .1}
  torus{.09,.01 rotate<90,0,0> translate<0,0,-.07>}
  torus{.09,.01 rotate<90,0,0> translate<0,0,.07>}
  torus{.05,.01 rotate<90,0,0> translate<0,0,-.07>}
  torus{.05,.01 rotate<90,0,0> translate<0,0,.07>}
  torus{.02,.01 rotate<90,0,0> translate<0,0,-.07>}
  torus{.02,.01 rotate<90,0,0> translate<0,0,.07>}
}      

#declare WinA1=union{
   difference{
     cylinder{<0,0,-.06><0,0,.06>1}
     cylinder{<0,0,-.07><0,0,.07>.8}
     box{<-1.1,-1.1,-.07><1.1,.56,.07>}
     translate<0,1,0>
   }                
   difference{
     cylinder{<0,0,-.07><0,0,.07>1}
     cylinder{<0,0,-.08><0,0,.08>.85}
     box{<-1.1,-1.1,-.08><1.1,.56,.08>}
     translate<0,1,0>
   }
   difference{
     cylinder{<0,0,-.095><0,0,.095>1}
     cylinder{<0,0,-.10><0,0,.10>.95}
     box{<-1.1,-1.1,-.10><1.1,.56,.10>}
     translate<0,1,0>
   }      

   difference{
     box{<-.9,1.43,-.09><-.75,1.6,.09>}
     box{<-.85,1.4,-.091><-.74,1.55,.091>}
   }
   difference{
     box{<.9,1.43,-.09><.75,1.6,.09>}
     box{<.85,1.4,-.091><.74,1.55,.091>}
   }
   
   box{<-.9,1.45,-.06><-.55,1.6,.06>}
   box{<.9,1.45,-.06><.55,1.6,.06>}
   
   box{<-.8,0,-.03><-.63,1.45,.03>} // verticals
   cylinder{<-.73,0.1,-.03><-.73,1.45,-.03> .035}       
   cylinder{<-.73,0.1,.03><-.73,1.45,.03> .035}   
   box{<.63,0,-.03><.8,1.45,.03>}   
   cylinder{<.73,0.1,-.03><.73,1.45,-.03> .035}       
   cylinder{<.73,0.1,.03><.73,1.45,.03> .035}      
   
   box{<-.85,.05,-.08><.85,.1,.08>} // lintel
   cylinder{<-.85,.075,-.08><.85,.075,-.08> .025}   
   cylinder{<-.85,.075,.08><.85,.075,.08> .025}   
   box{<-.8,.05,-.055><.8,-.035,.055>}
   box{<-.75,-.2,-.03><.75,-.025,.03>}

   object{WinAOrnament translate<-.77,-.05,0>}  
   object{WinAOrnament translate<0,-.05,0>}   
   object{WinAOrnament translate<.77,-.05,0>}
   
   union{
     torus{.125,.015 rotate<90,0,0> translate<0,1.625,-.03>} 
     torus{.05,.015 rotate<90,0,0> translate<0,1.625,-.03>}
     torus{.125,.015 rotate<90,0,0> translate<0,1.625.03>}   
     torus{.05,.015 rotate<90,0,0> translate<0,1.625.03>}
    texture{PaintText}
   }
   
   difference{
     box{<-.1,.5,-.1><.1,.75,.1>}
     box{<-.08,.45,-.11><.1,.9,.11> rotate<0,0,15> }
     box{<-.1,.45,-.11><.08,.9,.11> rotate<0,0,-15> }
    translate<0,1.28,0>      
   }            
}

#declare WinA=union{
  object{WinA1 texture{StoneText scale .05}}  
  object{WinAInsert}
}

#end // macro DefWinA


#declare PT=texture{pigment{color White}}
#declare ST=texture{T_Stone8 scale .3}
#declare WT=texture{pigment{color SandyBrown}} 

DefWinA(PT,ST,WT)

#declare TowerA=union{
  object{TRoof translate<0,4.35,0>}
  object{WinA translate<0,1,-2.45>}
  difference{
    cylinder{<0,0,0><0,4,0> 2.5 }
    box{<-.5,.8,-2.51><.5,2.75,-2>}
    cylinder{<0,.5,0><0,3.5,0> 2.3}
   texture{T_WhiteBrick scale .0625}
   normal{granite .65  turbulence .35}
  }
  cylinder{<0,4,0><0,4.25,0> 2.7 texture{T_Stone8 scale .25}}
  cylinder{<0,4.25,0><0,4.35,0> 2.8 texture{T_Stone8 scale .2}}
}         
#declare TowerB=union{  // TowerA w/o roof
//  object{TRoof translate<0,4.35,0>}
  object{WinA translate<0,1,-2.45>}
  difference{
    cylinder{<0,0,0><0,4,0> 2.5 }
    box{<-.5,.8,-2.51><.5,2.75,-2>}
    cylinder{<0,.5,0><0,3.5,0> 2.3}
   texture{T_WhiteBrick scale .0625}
   normal{granite .65  turbulence .35}
  }
  cylinder{<0,4,0><0,4.25,0> 2.7 texture{T_Stone8 scale .25}}
  cylinder{<0,4.25,0><0,4.35,0> 2.8 texture{T_Stone8 scale .2}}
}
#declare Floor1=union{
  cylinder{<0,0,0><0,0.25,0> 8.75 texture{T_Stone8 scale .25}}
  torus{8.75,.125 translate<0,0.125,0> texture{T_Stone8 scale .25}}
  cylinder{<0,0.25,0><0,0.5,0> 9 texture{T_Stone8 scale .25}}
}
#declare Balcony=union{
// 2nd floor Balcony
#declare R1=11.25;
#while (R1<360)
   object{Col1 translate<0,5.5,8.35> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+11.25;
#end

object{Floor1 translate<0,5.25+2.75,0>}

union{
   torus{8.35,.025 translate<0,5.9,0>}
   torus{8.35,.025 translate<0,6.3,0>}
  texture{T_Gold_5A}
}
}// end Balcony
 
//------------------------------------ WHITE TOWER
#declare WhiteTower=union{
object{TowerStairs}

cylinder{<0,0,0><0,4,0> 5 texture{T_RedBrick scale .0325}
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
}
cylinder{<0,0,0><0,.25,0> 5.25 texture{T_WhiteBrick scale .0625}}
cylinder{<0,3,0><0,28,0> 4.8 texture{T_WhiteBrick scale .0625}
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
}

difference{
   cylinder{<0,2.5,0><0,5,0> 8.5}
   cylinder{<0,2.4,0><0,5.1,0> 7.5}
   #declare R1=0;
   #while (R1<180)
      cylinder{<-9,2.5,0><9,2.5,0> 1 rotate<0,R1,0>}
      #declare R1=R1+22.5;
   #end
 texture{T_WhiteBrick scale .0625
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
 }
} // difference


object{Floor1 translate<0,5,0>}

#declare R1=11.25;
#while (R1<360)
   object{Col1 translate<0,0,8> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+22.5;
#end
#declare R1=0;
#while (R1<360)
   object{Star1 translate<0,2.75,8.5> rotate<0,R1,0> texture{T_Gold_5A}}
   object{Arch translate<0,2.5,8.025> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+22.5;
#end

// 4th floor 
#declare R1=11.25;
#while (R1<360)
   object{TowerA translate<0,5.5+2.75+2.75,-6.35> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+30;
#end

object{Balcony}
object{Balcony translate<0,2.75+.25,0>} 
}

//-------------------------------------- GRAY TOWER

#declare TowerTop=union{
  difference{
    union{
      cylinder{<0,1,0><0,5,0> 6}      
      cylinder{<0,.75,0><0,1,0> 5.90}
      cylinder{<0,.5,0><0,.75,0> 5.75}
      cylinder{<0,.25,0><0,.5,0> 5.5}
      cylinder{<0,0,0><0,.25,0> 5}
    }
    #declare R1=0;
    #while (R1<360)
       cylinder{<-6.1,0,0><6.1,0,0> 1 rotate<0,R1,0>}
       #declare R1=R1+22.5;
    #end                
    #declare R1=0;
    #while (R1<360)
       box{<-.5,4,-6.1><.5,5.1,6.1> rotate<0,R1,0>}
       #declare R1=R1+15;
    #end    
 texture{T_LumpyStucco}}
}

#declare GrayTower=union{
object{TowerStairs}

cylinder{<0,0,0><0,4,0> 5 texture{T_RedBrick scale .0325}
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
}
cylinder{<0,0,0><0,.25,0> 5.25 texture{T_TanBrick scale .0625}}
cylinder{<0,3,0><0,28,0> 4.8 texture{T_TanBrick scale .0625}
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
}

difference{
   cylinder{<0,2.5,0><0,5,0> 8.5}
   cylinder{<0,2.4,0><0,5.1,0> 7.5}
   #declare R1=0;
   #while (R1<180)
      cylinder{<-9,2.5,0><9,2.5,0> 1 rotate<0,R1,0>}
      #declare R1=R1+22.5;
   #end
 texture{T_TanBrick scale .0625
         normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
 }
} // difference

object{Floor1 translate<0,5,0>}

#declare R1=11.25;
#while (R1<360)
   object{Col1 translate<0,0,8> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+22.5;
#end
#declare R1=0;
#while (R1<360)
   object{Star1 translate<0,2.75,8.5> rotate<0,R1,0> texture{T_Gold_5A}}
   object{Arch translate<0,2.5,8.025> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+22.5;
#end

// 4th floor 
#declare R1=11.25;
#while (R1<360)
   object{TowerA translate<0,5.5+2.75+2.75+3,-6.35> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   object{TowerB translate<0,5.5+2.75+1.5,-6.35> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   object{TowerB translate<0,5.5,-6.35> rotate<0,R1,0> texture{T_Stone8 scale .25}}
   #declare R1=R1+22.5;
#end

object{TowerTop translate<0,27,0>}

//object{Balcony translate<0,2.75+.25,0>} 
}

#declare WindowFrame=union{
 box{<-.05,-.05,-.35><.05,1.5,-.3>}
 box{<-.05,-.05,.3><.05,1.5,.35>}  
 
 box{<-.04,-.05,-.28><.04,1.5,-.3>}
 box{<-.04,-.05,.3><.04,1.5,.28>}   
 box{<-.04,-.05,-.10><.04,1.5,-.15>}
 box{<-.04,-.05,.10><.04,1.5,.15>}
  
 box{<-.06,-.05,-.35><.06,.05,.35>}
 box{<-.05,1.45,-.35><.05,1.55,.35>}
 
 box{<-.04,1.15,-.35><.04,1.2,.35>} 
 box{<-.04,.77,-.35><.04,.82,.35>} 
 box{<-.04,.35,-.35><.04,.4,.35>} 
}
#declare Dormer=union{
   difference{
     box{<-2,-.50,-.5><2,1.5,.5>}
     box{<-2.1,0,-.35><2.1,1.5,.35> texture{pigment{color Black}}} // window
   }                              
   object{WindowFrame translate<-1.97,0,0> texture{pigment{color White}}}
   
   triangle{<-2,1.5,-.5><-2,1.5,.5><-2,3,0>}
   
   union{
     triangle{<-2,1.5,-.5><2,1.5,-.5><-2,3,0>}
     triangle{<2,1.5,-.5><-2,3,0><2,3,0>}      
     triangle{<-2,1.5,.5><2,1.5,.5><-2,3,0>}
     triangle{<2,1.5,.5><-2,3,0><2,3,0>}     
     texture{RoofText}
   }
  texture{T_WhiteBrick scale .0325}   
}
#declare MarketMoulding=union{ 
  box{<-8.6,0,-20.1><10.1,0.25,20.1> texture{T_Stone8 scale .25}}
  box{<-8.7,0.25,-20.2><10.2,0.35,20.2> texture{T_Stone8 scale .21 rotate<0,45,0>}}
}  
#declare MarketStairs=union{
  box{<-11,0,-22><10,.25,22> texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}
  box{<-10,.25,-21><10,.5,21> texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}
  box{<-9,.5,-20><10,.75,20> texture{checker texture{T_Stone18},texture{T_Stone12} scale .5 rotate<0,45,0>}}

  box{<-11.01,0,-22.01><10.01,.24,22.01> texture{T_Stone8 scale .25}}
  box{<-10.01,.25,-21.01><10.01,.49,21.01> texture{T_Stone8 scale .25}}
  box{<-9.01,.5,-20.01><10.01,.74,20.01> texture{T_Stone8 scale .15 }}
}  
#declare MarketBase=union{    
  object{MarketStairs}
  difference{
     box{<-8.5,.75,-20><8.5,10,20>}
     #declare R1=-18;
     #while (R1<=18)
        box{<-8.6,.7,R1-1><8.6,2,R1+1>}
        cylinder{<-8.6,2,R1><8.6,2,R1> 1}
        
        box{<-8.6,5,R1-.5><8.6,6.5,R1+.5>}
        box{<-8.6,8,R1-.5><8.6,9.5,R1+.5>}
       // box{<-8.6,11,R1-.5><10,12.5,R1+.5>}
        
        #declare R1=R1+3;
     #end                      
     #declare R1=-6.5;
     #while (R1<=6.5)
        box{<R1-1,.7,-20.1><R1+1,2,20.1>}
        cylinder{<R1,2,-20.1><R1,2,20.1> 1}
        #declare R1=R1+2.5;
     #end
    texture{T_WhiteBrick scale .0625}
  } // difference
     #declare R1=-18;
     #while (R1<=18)
        object{WinA rotate<0,90,0> translate<-8.6,5,R1>}
        object{WinA rotate<0,90,0> translate<-8.6,8,R1>} 
        object{Arch2 rotate<0,90,0> translate<-8.43,2,R1> texture{T_Stone8 scale .25}}
        object{Dormer translate<-6,11,R1>}
       //object{WinA rotate<0,90,0> translate<-8.6,11,R1>}        
        #declare R1=R1+3;
     #end                    
     #declare R1=-6.5;
     #while (R1<=6.5)
        object{Arch2 translate<R1,2,-20.1> texture{T_Stone8 scale .25}}
        object{WinA translate<R1,5,-20>}
        object{WinA translate<R1,8,-20>}
        #declare R1=R1+3;
     #end
  object{MarketMoulding translate<0,4,0>}
  object{MarketMoulding translate<0,7,0>}  
  object{MarketMoulding translate<0,10,0>}
  
  // roofline
  
  union{
     triangle{<-8.7,10.35,-20.2><-8.7,10.35,20.2><0,15,16>}
     triangle{<-8.7,10.35,-20.2><0,15,16><0,15,-16>}     
     triangle{<-8.7,10.35,-20.2><8.7,10.35,-20.2><0,15,-16>}
     
     triangle{<8.7,10.35,-20.2><8.7,10.35,20.2><0,15,16>}
     triangle{<8.7,10.35,-20.2><0,15,16><0,15,-16>}
     triangle{<-8.7,10.35,20.2><8.7,10.35,20.2><0,15,16>}          
    texture{RoofText}
  }
     
  
//  box{<-8.6,4,-20.1><10.1,4.25,20.1> texture{T_Stone8 scale .25}}
//  box{<-8.7,4.25,-20.2><10.2,4.35,20.2> texture{T_Stone8 scale .21 rotate<0,45,0>}}
  
}
#declare Water=texture{
                pigment { color rgb< 0.0, 0.1, 0.2 > }
                normal { bumps 0.2  scale < .15, 0.15, 0.15 > }
                finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
              }    
#declare Fountain=union{
  difference{
     cylinder{<0,0,0><0,1,0> 3}
     cylinder{<0,0,0><0,1.1,0> 2.75}
  }
  difference{  // rim
     cylinder{<0,1,0><0,1.1,0> 3.1}
     cylinder{<0,.9,0><0,1.11,0> 2.65}
    texture{T_Stone8 scale .1}
  }
  difference{  // rim II
     cylinder{<0,1.1,0><0,1.15,0> 3.15}
     cylinder{<0,1,0><0,1.151,0> 2.6}  
    texture{T_Stone8 scale .2}
  }
  cylinder{<0,.75,0><0,.76,0> 2.75 texture{Water}}

  cylinder{<0,0,0><0,.25,0> 4.5 texture{T_Stone12 scale .2}}
  cylinder{<0,.23,0><0,.249,0> 4.55 texture{T_Stone8 scale .1}}
  torus{4.55,.01 translate<0,.24,0> texture{T_Stone8 scale .1}}
  cylinder{<0,.25,0><0,.5,0> 4 texture{T_Stone12 scale .2}}
  cylinder{<0,.48,0><0,.499,0> 4.05 texture{T_Stone8 scale .1}}
  torus{4.05,.01 translate<0,.49,0> texture{T_Stone8 scale .1}}
  
  cone{<0,0,0>.75<0,3,0> .5 texture{T_Stone8 scale .25}}
  cylinder{<0,2.8,0><0,3,0> .6 texture{T_Stone8 scale .2}}
  cylinder{<0,3,0><0,3.45,0> .65 texture{T_Stone8 scale .15}}
  #declare R1=0;
  #while (R1<360)
    torus{.075,.02 rotate<90,0,0> translate<0,3.15,-.65> rotate<0,R1,0>texture{T_Stone8 scale .2}}
    sphere{<0,2.8,.55> .05 rotate<0,R1,0>texture{T_Stone8 scale .2}}
    #declare R1=R1+20;
  #end
  difference{
       union{
          sphere{<0,4,0> 1}
          cylinder{<0,3.9,0><0,3.95,0> 1.2}
       }
       sphere{<0,4,0> .8}
       box{<-1.1,4,-1.1><1.1,5.1,1.1>}
      texture{T_Stone8 scale .2}
  } 
  cylinder{<0,3.85,0><0,3.86,0> .8 texture{Water}}
  
  cylinder{<0,4,0><0,5,0> .025 texture{Bright_Bronze}}
  sphere{<0,5,0> .35 texture{T_Stone9 scale .2}}
  
   
 texture{T_WhiteBrick scale .0325}  
}  

//------------------------------------------------ BOOTH STUFF
#declare Barrel=union{
   cylinder{<0,-.25,0><0,.25,0>.4 texture{pigment{color Tan}}}
   cone{<0,-.25,0>.4<0,-.5,0>.33 texture{pigment{color Tan}}}
   cone{<0,.25,0>.4<0,.5,0>.33 texture{pigment{color Tan}}}
   cylinder{<0,.47,0><0,.499,0>,.34 texture{pigment{color Brown}}}
   cylinder{<0,-.47,0><0,-.499,0>,.34 texture{pigment{color Brown}}}
   cylinder{<0,-.25,0><0,-.28,0>,.41 texture{pigment{color Brown}}}
   cylinder{<0,.25,0><0,.28,0>,.41 texture{pigment{color Brown}}}
}
#declare BarrelSmall=object{Barrel scale .5}


//#declare Basket=difference{
//   cone{<0,0,0>,.25 <0,.5,0>,.35 texture{pigment{color Wheat}}}
//   cone{<0,.04,0>,.24 <0,.51,0>,.34 texture{pigment{color Wheat}}}
//}
#include "..\med\baskets.inc"

#declare Box1=union{
//   box{<-.5,0,-.25><.5,.25,.25> texture{pigment{color Tan}}}

   box{<-.48,.02,-.23><-.47,.23,.23> texture{T_Wood13}}
   box{<.48,.02,-.23><.47,.23,.23> texture{T_Wood13}}            

   #declare C1=-.25;
   #while (C1<=.21) 
     box{<-.5,0,C1><.5,.02,C1+.09> texture{T_Wood13 rotate<0,90,0> scale .5}}   
     box{<-.5,.23,C1><.5,.25,C1+.09> texture{T_Wood13 rotate<0,89,0> scale .5}}
     #declare C1=C1+.1;
   #end
   #declare C1=.03;
   #while (C1<=.18) 
     box{<-.5,C1,-.23><.5,C1+.09,-.251> texture{T_Wood13 rotate<0,-89,0> scale .5}}   
     box{<-.5,C1,.23><.5,C1+.09,.251> texture{T_Wood13 rotate<0,90,0> scale .5}}
     #declare C1=C1+.1;
   #end
         
   box{<-.4,0,-.27><-.35,.27,.27> texture{T_Wood13}}
   box{<.35,0,-.27><.4,.27,.27> texture{T_Wood13}}
}
#declare Box2=union{  // chicken crate-like
//   box{<-.5,0,-.25><.5,.25,.25> texture{pigment{color Tan}}}

   box{<-.48,.02,-.23><-.47,.23,.23> texture{T_Wood8}}
   box{<.48,.02,-.23><.47,.23,.23> texture{T_Wood8}}            

   #declare C1=-.25;
   #while (C1<=.21) 
     box{<-.5,0,C1><.5,.02,C1+.03> texture{T_Wood8 rotate<0,90,0> scale .5}}   
     box{<-.5,.23,C1><.5,.25,C1+.03> texture{T_Wood8 rotate<0,90,0> scale .5}}
     #declare C1=C1+.1;
   #end
   #declare C1=0;
   #while (C1<=.21) 
     box{<-.5,C1,-.23><.5,C1+.03,-.251> texture{T_Wood8 rotate<0,90,0> scale .5}}   
     box{<-.5,C1,.23><.5,C1+.03,.251> texture{T_Wood8 rotate<0,90,0> scale .5}}
     #declare C1=C1+.08;
   #end
         
   box{<-.4,0,-.27><-.35,.27,.27> texture{T_Wood8}}
   box{<.35,0,-.27><.4,.27,.27> texture{T_Wood8}}
}
#declare Veggies1=union{
   #declare R1=0;
   #while (R1<300)
      #declare Rx1=rand(RS)*.2+.05;
      #declare Ry1=rand(RS)*.2+.05;
      #declare Rz1=rand(RS)*.2+.05;     
      #declare Rx2=rand(RS)*.2+.05;
      #declare Ry2=rand(RS)*.2+.05;
      #declare Rz2=rand(RS)*.2+.05;     
      #declare Rx3=rand(RS)*.2+.05;
      #declare Ry3=rand(RS)*.2+.05;
      #declare Rz3=rand(RS)*.2+.05;
      #declare Rx=rand(RS)*2-1;
      #declare Rz=rand(RS)*.5-.25;
      #declare Ry=rand(RS)*.05;      
      triangle{<Rx1,Ry1,Rz1><Rx2,Ry2,Rz2><Rx3,Ry3,Rz3> translate<Rz,Ry,Rx>}
      #declare R1=R1+1;
   #end
  texture{pigment{color ForestGreen}}
}
#declare Veggies2=union{
   #declare R1=0;
   #while (R1<300)
      #declare Rx1=rand(RS)*.2+.05;
      #declare Ry1=rand(RS)*.2+.05;
      #declare Rz1=rand(RS)*.4+.05;     
      #declare Rx2=rand(RS)*.2+.05;
      #declare Ry2=rand(RS)*.2+.05;
      #declare Rz2=rand(RS)*.4+.05;     
      #declare Rx3=rand(RS)*.2+.05;
      #declare Ry3=rand(RS)*.2+.05;
      #declare Rz3=rand(RS)*.4+.05;
      #declare Rx=rand(RS)*2-1;
      #declare Rz=rand(RS)*.5-.25;
      #declare Ry=rand(RS)*.05;      
      triangle{<Rx1,Ry1,Rz1><Rx2,Ry2,Rz2><Rx3,Ry3,Rz3> translate<Rz,Ry,Rx>}
      #declare R1=R1+1;
   #end
  texture{pigment{color Khaki}}
}            
#declare Veggies3=union{
   #declare R1=0;
   #while (R1<150)
      #declare Rx1=rand(RS)*.2+.05;
      #declare Ry1=rand(RS)*.2+.05;
      #declare Rz1=rand(RS)*.4+.05;     
      #declare RD=rand(RS)*.1+.1;
      #declare Rx=rand(RS)*2-1;
      #declare Rz=rand(RS)*.5-.25;
      #declare Ry=rand(RS)*.05;      
      sphere{<Rx1,Ry1,Rz1> RD translate<Rz,Ry,Rx>}
      #declare R1=R1+1;
   #end
  texture{pigment{color Orange}}
}                                                         
#declare Veggies4=union{
   #declare R1=0;
   #while (R1<100)
      #declare Rx1=rand(RS)*.2+.05;
      #declare Ry1=rand(RS)*.2+.05;
      #declare Rz1=rand(RS)*.4+.05;     
      #declare RD=rand(RS)*.05+.05;
      #declare Rx=rand(RS)*2-1;
      #declare Rz=rand(RS)*.4-.2;
      #declare Ry=rand(RS)*.05;      
      sphere{<Rx1,Ry1,Rz1> RD translate<Rz,Ry,Rx>}
      #declare R1=R1+1;
   #end
  texture{pigment{color Tan}}
}                  
#declare Fish1=union{
   #declare R1=-1;
   #while (R1<1)
      #declare RL=rand(RS)*.2+.2;
      #declare Sc=rand(RS)*.2+1;
      #declare Ry=rand(RS)*.025;
      #declare ROX=rand(RS)*180;
      #declare RC=int(rand(RS)*6+1);
      union{
        sphere{<0,0,0>,RL scale <1,.12,.08>}
        triangle{<RL,0,0><RL+.1,.1,0><RL+.1,-.1,0>} // tail
        sphere{<0,0,0>,.0071 translate<-RL/2,.06,-.02*(RL/.4)> texture{pigment{color Black}}} //eye
        sphere{<0,0,0>,.0071 translate<-RL/2,.06,.02*(RL/.4)> texture{pigment{color Black}}}  // eye
       texture{pigment{color 
              #switch (RC)
                #case (1) Gray #break
                #case (2) Gray10 #break
                #case (3) Gray20 #break
                #case (4) Gray30 #break
                #case (5) Gray40 #break
                #case (6) Gray50 #break
              #end
              }}
       rotate<ROX,-90,0>
       translate<R1,.07+Ry,0>
      }
      #declare R1=R1+.05;
   #end // while
} 
                        
//----------------------------------------------------------BOOTHS
#declare BH=3;
#declare FrameEnd=union{
   box{<-.035,0,-.035><.035,BH,.035> texture{T_Wood8 scale .2} rotate<-45,0,0>  translate<0,0,1.5>}
   box{<-.035,0,-.035><.035,BH/2,.035> texture{T_Wood8 scale .2} rotate<45,0,0>}
   box{<-.035,BH-.1,-.035><.035,BH-.01,-.55> texture{T_Wood8 scale .2} rotate<-45,0,0> translate<0,0,1.5>}
}

#declare BoothCover=union{
   triangle{<-.9,0,.035><.9,.1,.035><.9,BH+.01,.035>}
   triangle{<-.9,0,.035><.9,BH+.01,.035><-.9,BH+.01,.035>}
   
   triangle{<-.9,BH+.01,.035><.9,BH+.01,.035><.9,BH+.01,-.54>}
   triangle{<-.9,BH+.01,.035><.9,BH+.01,-.54><-.9,BH+.01,-.54>}
   
   triangle{<.9,BH+.01,-.54><-.9,BH+.01,-.54><-.85,BH-.1,-.55>}
   triangle{<.9,BH+.01,-.54><-.85,BH-.1,-.55><.9,BH-.13,-.56>}
}   

#declare Booth=union{
  object{FrameEnd translate<1,0,0>}
  object{FrameEnd translate<-1,0,0>}

  union{  
    cylinder{<-1,BH-.05,0><1,BH-.05,0>.035 texture{T_Wood8 rotate<0,90,0> scale .2}}
    cylinder{<-1,BH-.05,-.5><1,BH-.05,-.5>.035 texture{T_Wood8 rotate<0,90,0> scale .2}}
    box{<-1,BH/2,-.023><1,BH/2+.1,.023> texture{T_Wood8 scale .2}}   
    box{<-1,0,-.023><1,.1,.023> texture{T_Wood8 scale .2}}
    rotate<-45,0,0> translate<0,0,1.5>
  } 
}

#declare SawHorseA=union{
   box{<-.02,0,-.02><.02,-.75,.02> texture{T_Wood8 scale .1} rotate<-20,0,0>}
   box{<-.02,0,-.02><.02,-.75,.02> texture{T_Wood8 scale .1} rotate<20,0,0>}
   box{<-.04,-.4,-.2><-.02,-.5,.2> texture{T_Wood8 scale .1}}
   box{<.02,-.4,-.2><.04,-.5,.2> texture{T_Wood8 scale .1}}
   translate<0,.75,0>
}
#declare SawHorse=union{  
   box{<-.28,.62,-.02><.285,.75,.02> texture{T_Wood8 scale .2} }
   object{SawHorseA translate<.25,-.03,0>}
   object{SawHorseA translate<-.25,-.03,0>}
}
#declare SawHorseTop=union{
  box{<-.85,.75,-.2><.9,.78,.2> texture{T_Wood7 rotate<0,90,0> translate<0,0,.2> scale .15} translate<0,0,.21>}
  box{<-.85,.75,-.2><.9,.78,.2> texture{T_Wood7 rotate<0,90,0> scale .1} translate<0,0,-.21>}
}       
#macro PickColor()
  #declare RC=int(rand(RS)*24+1);
  #switch (RC)
    #case (1)  color AliceBlue  #break
    #case (2)  color AntiqueWhite  #break
    #case (3)  color Tan  #break
    #case (4)  color SteelBlue  #break
    #case (5)  color Bisque  #break
    #case (6)  color Gray10  #break
    #case (7)  color Gray50  #break
    #case (8)  color Gray80  #break
    #case (9)  color Bone  #break                            
    #case (10) color ForestGreen  #break    
    #case (11) color DarkBlue  #break    
    #case (12) color DarkOliveGreen  #break    
    #case (13) color Goldenrod  #break     
    #case (14) color Khaki  #break    
    #case (15) color Maroon  #break    
    #case (16) color Wheat  #break    
    #case (17) color Moccasin  #break    
    #case (18) color RichBlue  #break    
    #case (19) color PaleGoldenrod  #break    
    #case (20) color Red  #break
    #case (21) gradient x color_map{
           [0.0 color Blue]
           [0.1 color Red]
           [0.2 color Blue]
           [0.3 color Red]
           [0.4 color Blue]
           [0.5 color Red]
           [0.6 color Blue]
           [0.7 color Red]
           [0.8 color Blue]
           [0.9 color Red]
           [1.0 color Blue]
           }
           #break              
    #case (22) gradient x color_map{
           [0.0 color Wheat]
           [0.3 color Wheat]
           [0.4 color Red]
           [0.5 color Red]
           [0.6 color Wheat]
           [0.8 color Wheat]
           [0.9 color Red]
           [1.0 color Red]
           }
           #break                  
    #case (23) gradient x color_map{
           [0.0 color Red]
           [0.3 color Red]
           [0.4 color Yellow]
           [0.5 color Yellow]
           [0.6 color Red]
           [0.8 color Red]
           [0.9 color Yellow]
           [1.0 color Yellow]
           }
           #break                          
    #case (24) gradient x color_map{
           [0.0 color Wheat]
           [0.1 color Wheat]
           [0.2 color Tan]
           [0.5 color Tan]
           [0.6 color Wheat]
           [0.8 color Wheat]
           [0.9 color Tan]
           [1.0 color Tan]
           }
           #break                          
    #else Black #break
  #end // switch
#end // macro PickColor

#macro FillBooth()
  #declare RC=int(rand(RS)*13);
  #switch (RC)
    #case (0) 
       object{Fish1 rotate<0,0,0> translate<0,.78,-1>}
    #break           
    #case (1) 
       object{Box2 rotate<0,80,0> translate<.5,.78,-1>}
       object{Box2 rotate<0,95,0> translate<-.5,.78,-1>}
    #break         
    #case (2) 
       object{BarrelSmall rotate<0,80,0> translate<.5,.78+.25,-1>}
       object{BarrelSmall rotate<0,95,0> translate<-.5,.78+.25,-1>}
    #break
    #case (3) 
       object{Box1 rotate<0,80,0> translate<.5,.78,-1>}
       object{Box1 rotate<0,95,0> translate<-.5,.78,-1>}
    #break
    #case (4) 
       object{Box2 rotate<0,95,0> translate<-.5,.78,-1>}
    #break 
    #case (5) 
       object{BarrelSmall rotate<0,80,0> translate<.5,.78+.25,-1>}
       object{BarrelSmall rotate<0,95,0> translate<0,.78+.25,-1.1>}
       object{BarrelSmall rotate<0,95,0> translate<-.5,.78+.25,-1>}
    #break
    #case (6) 
       object{Box2 rotate<0,90,0> translate<.5,.78,-1>}
       object{Box2 rotate<0,70,0> translate<-.5,.78,-1>}
       object{Box2 rotate<0,10,0> translate<0,0,-2>}
       object{Box2 rotate<0,-10,0> translate<0,.25,-2>}
    #break
    #case (7) 
       object{BasketA1 rotate<0,80,0> translate<.6,0,-1.5>}
       object{BasketA2 rotate<0,95,0> translate<-.45,0,-1.5>}
    #break
    #case (8) 
       object{GetBasket() rotate<0,80,0> translate<.5,.78+.25,-1>}
       object{GetBasket() rotate<0,95,0> translate<0,.78+.25,-1.1>}
       object{GetBasket() rotate<0,25,0> translate<-.5,.78+.25,-1>}
    #break    
    #case (9) 
       object{Veggies1 rotate<0,80,0> translate<.5,.78,-1>}
    #break  
    #case (10) 
       object{Veggies2 rotate<0,80,0> translate<.5,.78,-1>}
    #break 
    #case (11) 
       object{Veggies3 rotate<0,80,0> translate<.5,.78,-1>}
    #break
    #case (12) 
       object{Veggies4 rotate<0,80,0> translate<.5,.78,-1>}
    #break                                                                                    
  #end // switch
#end // macro FillBooth()
  

#macro BoothCombo(X1X,Y1Y,Z1Z,ROY,BSC)
union{
    object{Booth scale BSC}

    object{BoothCover texture{pigment{PickColor()} normal{bozo .5 scale <.1,.2,.1> turbulence .5}
                             } rotate<-45,0,0> translate<0,0,1.5> scale BSC}
                     
    object{SawHorse rotate<0,90,0> translate<-.6,0,-1>}
    object{SawHorse rotate<0,85,0> translate<.7,0,-.970>}
    object{SawHorseTop translate<0,0,-1>}
    FillBooth()
  rotate<0,ROY,0>
  translate<X1X,Y1Y,Z1Z>
}
#end // macro BoothCombo


#macro MakeBooths(Lgth,Xseed,Rotf)
    #declare R1=-Lgth;
    #declare RS=seed(Xseed);
    #while (R1<Lgth)
      #declare ROY=rand(RS)*(2*Rotf)-Rotf;
      #declare RZ=rand(RS)*.25;
      #declare BSC=rand(RS)*.2+1;  
      BoothCombo(R1,0,RZ,ROY,BSC)
      #declare R1=R1+2+rand(RS)*.2+.3;
    #end
#end //macro MakeBooths   
       
//-------------- LIGHTS ------------------------------------------ 
#declare Rusty_Aluminum =
//texture{Brushed_Aluminum}
texture{pigment{color SeaGreen}}
texture { 
    pigment {
        bozo
        color_map {
            [0.0 rgbf <0.8100, 0.7100,0.2300, .1>]
            [0.35 rgbf <0.89, 0.51, 0.28, .4  >]
            [0.45 rgbf <0.70, 0.13, 0.00, .65 >]
            [0.5 rgbf <0.69, 0.41, 0.08, .2  >]
            [0.56 rgbf <0.49, 0.31, 0.28, .9  >]
            [0.89 rgbf <0.89, 0.51, 0.28, .4  >]
            [1.0 rgb <0,0,0>]
        }
    }
    finish { ambient 0.2 diffuse 0.4 }
  scale .015
}
#declare Lamp_Bracket=union{
   difference{
      cylinder{<0,0,-.02><0,0,.02> .3}
      cylinder{<0,0,-.021><0,0,.021> .25}
      box{<-3.1,0,-.021><0,3.1,.021>}
   }
   box{<.3,-3,-.075><.45,.35,.075> texture{T_Wood13 scale .05 rotate<90,0,0>}}
   difference{
      cylinder{<0,0,-.02><0,0,.02> .15}
      cylinder{<0,0,-.021><0,0,.021> .1}
     translate<.15,-.45,0>
   }
   difference{
      cylinder{<0,0,-.02><0,0,.02> .15}
      cylinder{<0,0,-.021><0,0,.021> .1}
     translate<-.4,0,0>
   }   
   difference{
      cylinder{<0,0,-.02><0,0,.02> .2}
      cylinder{<0,0,-.021><0,0,.021> .15}
      box{<-.21,-.21,-.021><.21,.05,.021>}
     translate<.15,.2,0>
   }
}
#declare Lampa=union{
   difference{
      sphere{<0,0,0>.11}
      box{<-.12,-.12,-.12><.12,0,.12>}
   }
   torus{.11,.005}
   torus{.11,.005 translate<0,.012,0>}
   torus{.025,.005 rotate<0,0,90> translate<0,.1,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,10,0> translate<0,.145,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,-10,0> translate<0,.19,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,11,0> translate<0,.235,0>}   
      
   difference{
      cylinder{<0,0,0><0,.025,0> .1}
      cylinder{<0,-.001,0><0,.03,0> .095}
     translate<0,-.1,0>
   }   
  
   difference{
      cylinder{<0,0,0><0,.025,0> .1}
      cylinder{<0,-.001,0><0,.03,0> .095}
     translate<0,-.2,0>
   }   
   
   difference{
      cylinder{<0,0,0><0,.025,0> .1}
      cylinder{<0,.001,0><0,.03,0> .095}
     translate<0,-.3,0>
   }
   
   #declare R1=0;
   #while (R1<360)
      box{<.1,-.3,-.005><.11,0,.005> rotate<0,R1,0>}
      #declare R1=R1+30;
   #end 
   

}
              
#declare Lamp=union{
   object{Lampa}              
   #ifdef (Lighted)
      sphere{<0,-.2,0> .025 texture{pigment{color Yellow}} finish{ambient 5.0}}   
      light_source {  <0,-.15,0> color Orange fade_power 4 fade_distance 5 }
   #end 
}

#declare Lamp_Fix=union{
  object{Lamp_Bracket texture{Bright_Bronze}}   
  object{Lamp translate<-.4,-.4,0> texture{pigment{color Gold }}} //Bright_Bronze}}
}

#declare CrossX=union{
  box{<-.75,3.84,-.02><.75,3.99,.02>} // crosspiece 
  
  torus{.25,.02 rotate<90,0,0> translate<-.36,3.6,0>}
  torus{.25,.02 rotate<90,0,0> translate<.36,3.6,0>}   
  torus{.075,.019 rotate<90,0,0> translate<-.66,3.75,0>}
  torus{.075,.019 rotate<90,0,0> translate<.66,3.75,0>}      
  torus{.078,.019 rotate<90,0,0> translate<-.825,3.9,0>}
  torus{.078,.019 rotate<90,0,0> translate<.825,3.9,0>}
  
  sphere{<-.6,3.93,0>.045}
  sphere{<-.45,3.93,0>.045}  
  sphere{<-.3,3.93,0>.045}
  sphere{<.3,3.93,0>.045}
  sphere{<.45,3.93,0>.045}  
  sphere{<.6,3.93,0>.045}
      
}  
    

#declare LampPost=union{
  torus{.225,.06}
  cone{<0,0,0> .225 <0,.9,0> .18}
  cone{<0,.9,0> .15 <0,4.2,0> .105}
  cylinder{<0,.89,0> <0,.97,0> .19}  
  cylinder{<0,3.9,0> <0,3.96,0> .112}
  sphere{<0,4.26,0> .114}
  torus{.114,.015 translate<0,4.26,0>}
  sphere{<0,4.26+.114+.03,0> .036}  // top
 
  object{CrossX}
  object{CrossX rotate<0,90,0>}
 
  #declare R1=0;
  #while (R1<360)
     sphere{<0,3.9,.105> .03 rotate<0,R1,0>}
     cylinder{<0,.9,.15><0,3.9,.105> .03 rotate<0,R1,0>}
     sphere{<0,.93,.186> .03 rotate<0,R1,0>}  
     sphere{<0,.06,.225> .06 rotate<0,R1,0>}
     #declare R1=R1+22.5;
  #end 
  
  union{
    object{Lampa translate<.825,3.505,0>}    
    object{Lampa translate<-.825,3.505,0>}
    object{Lampa translate<0,3.505,.825>}
    object{Lamp translate<0,3.505,-.825>}      
   texture{Bright_Bronze}
  }
 
 texture{Rusty_Aluminum} 
 //texture{pigment{color SeaGreen}} 
}

//---------------------- end Lights -------------------------


// objects ************************************  
// objects ************************************
// objects ************************************
// objects ************************************

// Lights ======================
object{LampPost rotate<0,180,0> translate<10,0,-11>} 
//object{Lamp_Fix translate<6,0,0>}
//object{LampPost translate<-6,0,0>}
//object{LampPost translate<-6,0,-5>}

union{
  object{LampPost translate<12,0,-15>}
  object{LampPost translate<12,0,-10>}
  object{LampPost translate<12,0,-5>}
  object{LampPost translate<12,0,0>}
  object{LampPost translate<12,0,5>}
  object{LampPost translate<12,0,10>}
  object{LampPost translate<12,0,15>}
 rotate<0,-20,0>
}
union{
  object{LampPost rotate<0,180,0> translate<-8,0,-15>}
  object{LampPost rotate<0,180,0> translate<-8,0,-10>}
  object{LampPost rotate<0,180,0> translate<-8,0,-5>}
  object{LampPost rotate<0,180,0> translate<-8,0,0>}
  object{LampPost rotate<0,180,0> translate<-8,0,5>}
  object{LampPost rotate<0,180,0> translate<-8,0,10>}
  object{LampPost rotate<0,180,0> translate<-8,0,15>}
 rotate<0,-20,0>
}          

object{Fountain}
object{MarketBase rotate<0,-20,0> translate<20,0,15>} 
object{WhiteTower translate<-20,.75,0>}
object{GrayTower translate<0,.75,50>}
                                       
// bases only for placement                                       
//object{MarketStairs rotate<0,-20,0> translate<20,0,15>}
//object{TowerStairs translate<-20,.75,0>}
//object{TowerStairs translate<-10,.75,30>}

union{
  union{MakeBooths(10,282,5) rotate<0,-90,0> translate<6,0,0>}
  union{MakeBooths(12,222,5) rotate<0,90,0> translate<11,0,0>}  
 rotate<0,-20,0>
}
union{
  union{MakeBooths(6,232,5) rotate<0,180,0> translate<0,0,12>}
  union{MakeBooths(6,272,5) rotate<0,0,0> translate<1,0,17>}  
 rotate<0,-25,0>
}
union{   
  union{MakeBooths(7,321,5) rotate<0,0,0> translate<5,0,-7>}
  union{MakeBooths(8,138,5) rotate<0,180,0> translate<4.4,0,-11>}
 rotate<0,25,0>
}

//---------------------------------------------------------------------------------------------------
#ifndef(NoBuildings)   

#declare RS=seed(3293);
#declare R1=seed(3293);
#include "maintree.inc"
#include "mainpart.inc"          // doors/windows etc.
#include "build1b.inc"            // new version of mainbldg                                

// Center Post
//cylinder{<0,0,0><0,100,0>,.5 texture{pigment{color Red}}}

//------------------------------------
// Inputs: I= X-dimension of block
//         J= Z-dimension of block
//         R2=initialized seed
//         OZ=lower left-hand corner Z-coordinate
//         OX=lower left-hand corner X-coordinate
//         OY=elevation of block
//         SP_Level=the large this value, the lighter the density of booths
//         Streets=1 to generate streets, =0 no streets
//         North=1 to generate street on north side of block
//         South=1 
//         East=1
//         West=1
//
// Default:
#declare Streets=1;
#declare SP_Level=1;

//-------------
  #declare R2=seed(261);
  #declare OY=0;
  #declare OZ=40;
  #declare OX=-60;
  #declare I=40;
  #declare J=120;
  #declare North=1;
  #declare South=1;
  #declare East=1;
  #declare West=1;
  #include "citybl1b.inc"
  
//  #declare R2=seed(614);
//  #declare OY=0;
//  #declare OZ=40;
//  #declare OX=0;
//  #declare I=80;
//  #declare J=40;
//  #declare North=1;
//  #declare South=1;
//  #declare East=1;
//  #declare West=1;
//  #include "citybl1b.inc"

//  #declare R2=seed(146);
//  #declare OY=0;
//  #declare OZ=80;
//  #declare OX=0;
//  #declare I=40;
//  #declare J=40;
//  #declare North=1;
//  #declare South=1;
//  #declare East=1;
//  #declare West=1;
//  #include "citybl1b.inc"    

//  #declare R2=seed(246);
//  #declare OY=0;
//  #declare OZ=80;
//  #declare OX=-40;
//  #declare I=40;
//  #declare J=40;
//  #declare North=1;
//  #declare South=1;
//  #declare East=1;
//  #declare West=1;
//  #include "citybl1b.inc"  
  
#end // ifndef(NoBuildings)    


#ifndef(NoSnowHF)
union{
object {
                height_field { png  "../graphics/snowh2.png" water_level .1}
                texture{pigment{color Gray90}} //image_map { gif "..\graphics\natfl014.gif"} scale .01 rotate<90,0,0>}}
               // normal{granite .85 turbulence .35}
                rotate<0,0,0>
                scale <3, .05, 3 >   translate < -1.5, 0, -1.5 >
                translate<0,0,5>  // place it where it belongs 
  }   
 object {
                height_field { png  "../graphics/snowh2.png" water_level .1}
                texture{pigment{color Gray90}} //image_map { gif "..\graphics\natfl014.gif"} scale .01 rotate<90,0,0>}}
               // normal{granite .85 turbulence .35}
                rotate<0,0,0>
                scale <3, .05, 3 >   translate < -1.5, 0, -1.5 >
                translate<0,0,2.5>  // place it where it belongs 
  }   
 object {
                height_field { png  "../graphics/snowh2.png" water_level .1}
                texture{pigment{color Gray90}} //image_map { gif "..\graphics\natfl014.gif"} scale .01 rotate<90,0,0>}}
               // normal{granite .85 turbulence .35}
                rotate<0,0,0>
                scale <3, .05, 3 >   translate < -1.5, 0, -1.5 >
               // translate<0,-1.45,-30.5>  // place it where it belongs 
  }   
 object {
                height_field { png  "../graphics/snowh2.png" water_level .1}
                texture{pigment{color Gray90}} //image_map { gif "..\graphics\natfl014.gif"} scale .01 rotate<90,0,0>}}
               // normal{granite .85 turbulence .35}
                rotate<0,0,0>
                scale <3, .05, 3 >   translate < -1.5, 0, -1.5 >
                translate<0,0,-2.5>  // place it where it belongs 
  }      
 object {
                height_field { png  "../graphics/snowh2.png" water_level .1}
                texture{pigment{color Gray90}} //image_map { gif "..\graphics\natfl014.gif"} scale .01 rotate<90,0,0>}}
               // normal{granite .85 turbulence .35}
                rotate<0,0,0>
                scale <3, .05, 3 >   translate < -1.5, 0, -1.5 >
                translate<0,0,-5>  // place it where it belongs 
  }    
  
  rotate<0,45,0>
  translate<11.5,0,-14>
}
#end // ifndef(NoSnowHF)

#ifndef(NoPeople)
#declare Man1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\Man1.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}
#declare Man2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\Man2.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}                          
#declare Mate1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\Sailors\Mate1.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}     
#declare Mate2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\Sailors\Mate2.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}
#declare Captain1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\Sailors\Captain1.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}
#declare Knight1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\Knights\Knight1.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }} 
#declare Knight2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\Knights\Knight2.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }} 
                                                              
#declare Woman1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman1.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}          
#declare Woman2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman2.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}         
#declare Woman3=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman3.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}    
#declare Woman4=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman4.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}    
#declare Woman6=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman6.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}    
#declare Woman7=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { png "..\graphics\MedievalGeneral\woman7.png" transmit 0, 1.0} 
               }}
               scale <1.7,2,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,-.025,0>
               }}                                                                      
  object{Woman1 rotate<0,-35,0> translate<11,0,-12>} 
  object{Woman4 rotate<0,-35,0> translate<10.5,0,-14>}  
  object{Knight2 rotate<0,-25,0> translate<12,0,-9.75>}  
  object{Captain1 rotate<0,-25,0> translate<10.5,0,-7>}
  object{Mate1 rotate<0,-25,0> translate<10.5,0,-5>}
  object{Woman1 rotate<0,-25,0> translate<10.25,0,-3>}
  object{Knight1 rotate<0,-25,0> translate<11,0,-6>}
  object{Mate1 rotate<0,-25,0> translate<7.5,0,-3>}
  object{Woman7 rotate<0,-25,0> translate<8,0,-1>}
  object{Knight1 rotate<0,-25,0> translate<7.75,0,0>} 
  
  object{Woman2 rotate<0,-35,0> translate<8,0,-12>} 
  object{Woman6 rotate<0,-35,0> translate<7,0,-11.75>}     
  object{Man1 rotate<0,-35,0> translate<6,0,-13>} 
  object{Knight1 rotate<0,-35,0> translate<5.5,0,-13.75>}    

//**************************************

#end //ifndef(NoPeople)

#include "../med/cart.inc"

union{
   object{Cart1}
   object{BasketA1 rotate<0,20,0> translate<0,.75,0>}
   object{BasketCon1 translate<0,1.1,0> texture{pigment{color Salmon1}}}
   object{BasketB1 translate<.5,.75,.5>}  
   object{BasketCon1 scale<1,1.25,.5> translate<.5,1.1,.5> texture{pigment{color Khaki}}}
   object{BasketC1 translate<-.5,.75,-.2>}
   object{BasketC2 rotate<20,0,0> translate<-.5,.85,-.2>}  
  rotate<0,0,16> rotate<0,-60,0> translate<9,0,-15>
}
union{   
   object{BasketA3 rotate<0,-30,0> translate<.5,0,-.5>} 
   object{BasketCon1 rotate<0,90,0> translate<.5,.25,-.5> texture{pigment{color Salmon3}}} 
   object{BasketD2 rotate<0,30,0> translate<1.05,0,-.5>} 
   object{BasketCon1 rotate<0,90,0> translate<1.05,.4,-.5> texture{pigment{color Orange}}}      
   object{BasketD5 rotate<0,70,0> translate<1,0,.1>}   
   object{BasketCon1 rotate<0,90,0> translate<1,.5,.1> texture{pigment{color OrangeRed5}}}    
  rotate<0,-60,0> translate<9,0,-15>
}     
object{Cart1  rotate<0,0,16> rotate<0,180,0> translate<14,0,-9>}