//Dreamlands: Scene for IRTC, topic dreaming
//Scene created by George Akritides

global_settings {//adding standard radiosity
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 0.5
      normal on
      adc_bailout 0.01/2
    }
  }              


#include "glass.inc"
#include "colors.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
#include "shapes.inc"
#include "functions.inc"
#include "stones1.inc"

//standard camera
camera {
        location <1,2,1.9>
        look_at <-.5,1.5,-1>        
        }
//a light source instead of setting ambient colour to objects (shadowless)        
light_source {<0,1.0,0> rgb 0.7 shadowless }

//a light source to reflect off the pyramid   
light_source {<10,20,-40> rgb 1 
   fade_distance 30
   fade_power 3.5
   }   

   
//the liquid landscape
#declare sea=isosurface{
                function { y-f_noise3d(x, y, z)*2 }
                open
                max_gradient 4
                contained_by {sphere {<0,0,0>,5}}
                material {
                        texture {
                                pigment {colour rgbt <0.5, 0.5, 1, 0.8>}
                                finish {ambient 0.0 diffuse 0.0 reflection {0.2, 0.9 fresnel on} specular 0.4 roughness 0.003}
                                normal {function {f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)} 0.8
                                scale 0.13}    
                        }
                        interior {ior 1.5}
                }                
                scale <14,1,14>
                translate -2.5*y
                }
               
//the black-grey sky sphere                        
sky_sphere {    
    pigment {
      bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
      color_map {
          [0.0 0.1 color rgb <0.5, 0.5, 0.95> color rgb <0.5, 0.5, 0.85>]
          [0.1 0.5 color rgb <0.5, 0.5, 0.85> color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]}      
      scale <0.5, 0.2, 0.5>}    
  }
                

//creating the bed               
#declare matress=object {Round_Box(<-1.95,0.3,-1.04>, <-0.04,0.47,-1.95>, 0.02, 0)
                pigment {Wheat} normal {wrinkles turbulence 1}}
#declare cover=intersection{blob{//the cotton quilt
                                cylinder {<0,0,0>,<1,0,0>,1,1 scale <1,0.3,0.67>}
                                cylinder {<0,0,0>,<0.6,0,0>,0.47,0.8 scale 1.2*z}
                                sphere {<0.6,0,0>,0.35,0.8}
                                cylinder {<0.9,0,0>,<1.1,0,0>,0.35,0.8 scale <1,1.2,0.5> translate 0.1*z}
                                cylinder {<0.9,0,0>,<1.1,0,0>,0.35,0.8 scale <1,1.2,0.5> translate -0.1*z}
                                cylinder {<1.2,0,0.1>,<1.5,0.25,0.1>,0.07,0.8}
                                sphere {<1.4,0.1,0.1>,0.2,0.8}
                                cylinder {<1.2,0,-0.1>,<1.5,0.25,-0.1>,0.07,0.8}
                                sphere {<1.4,0.1,-0.1>,0.2,0.8}
                                #declare c=0.27;
                                #while (c<=1.6)
                                cylinder {<c,0,0.43>,<c,0,-0.43>,0.16,0.8 scale 1.52*y translate 0.09*y}                                                              
                                #declare c=c+0.4;
                                #end
                                #declare c=0.27;
                                #while (c<=1.2)
                                cylinder {<c+0.2,0,0.43>,<c+0.2,0,-0.43>,0.16,0.8 scale 1.12*y translate 0.11*y}
                                cylinder {<c+0.3,0,0.43>,<c+0.3,0,-0.43>,0.16,0.8 scale 1.02*y translate 0.11*y}
                                cylinder {<c+0.1,0,0.43>,<c+0.1,0,-0.43>,0.16,0.8 scale 1.02*y translate 0.11*y}
                                #declare c=c+0.4;
                                #end
                                cylinder {<1.56,0,0.43>,<1.56,0,-0.43>,0.16,0.8 scale 1.52*y}
                                threshold 0.2
                                translate <-1.6,0.3,-1.495>
                                }
                        box{<0.4,-1,-2.5>,<-1.6,2,-0.5>}
                        }                                                                                
declare cover2=intersection{//the sheet
                object {cover translate <1,-0.15,1.495> scale <1.01,1.05,1.05> translate <-1,0.15,-1.495>}
                box {<-1.61,0.1,-2.65>,<-1.41,1,-0.35>}
                pigment {White}
                normal {wrinkles}
                }                                
#declare bed=union{
        box{<-1.99,0.001,-1.99>,<-1.89,0.3,-1.89>}//bed's foot
        box{<-1.99,0.001,-1.1>,<-1.89,0.3,-1>}//>>
        box{<-0.1,0.001,-1.1>,<0,0.3,-1>}//>>
        box{<-0.1,0.001,-1.99>,<0,0.3,-1.89>}//>>
        difference {//main four planks
                box{<-1.99,0.29,-1>,<0,0.4,-1.99>}
                box{<-1.95,0.28,-1.04>,<-0.04,0.41,-1.95>}
        }                
        difference{
                intersection{
                        box{<-1.99,0.39,-1.99>,<-1.95,.9,-1>}
                        cylinder {<-1.999,0.39,-1.495>,<-1.941,0.39,-1.495>,.495}
                        }
                cylinder {<-1.999,0.9,-1.495>,<-1.941,0.9,-1.495>,.2}
                cylinder {<-1.941,0.39,-1.495>,<-1.97,0.39,-1.495>,.31}
        }                                        
        object {matress}
        object {cover pigment {checker pigment {Wheat}, pigment {Tan} scale 0.1}
                normal {quilted scale 0.1}}
        object {cover2}                                  
                                
        texture {T_Wood3}
}        


//creating the stool for the lamp
#declare stool=union{
        torus {0.12,0.03 translate <-1.8,0.5,-.8>}
        cylinder {<-1.8,0.47,-.8>,<-1.8,0.53,-.8>,0.12}
        cylinder {<-1.9,0.001,-.9>,<-1.88,0.5,-.88>,0.015}
        cylinder {<-1.9,0.001,-.7>,<-1.88,0.5,-.72>,0.015}
        cylinder {<-1.7,0.001,-.9>,<-1.72,0.5,-.88>,0.015}
        cylinder {<-1.7,0.001,-.7>,<-1.72,0.5,-.72>,0.015}
        texture {T_Wood3}                        
}


//creating the metalic cover for the lamp
#declare outerlamp=mesh {
                triangle{<0.061,-0.061,0>,<0.061,-0.061,-0.061>,<0.061,0,-0.061>}
                triangle{<0.061,0.061,0>,<0.061,0.061,-0.061>,<0.061,0,-0.061>}
                triangle{<0.061,0.061,0>,<0.061,0.061,0.061>,<0.061,0,0.061>}
                triangle{<0.061,-0.061,0>,<0.061,-0.061,0.061>,<0.061,0,0.061>}
                
                translate 0.06*y
                texture{T_Chrome_3C}
        }

//the lamp besides the bed
#declare lamp=union{        
        object {outerlamp}                
        object {outerlamp rotate 90*y}
        object {outerlamp rotate 180*y}
        object {outerlamp rotate 270*y}
        box{<-0.061,0.12,-0.061>,<0.061,0.122,0.061> texture {T_Chrome_3C}}
        
        light_source {<0,0.06,0>, rgb <0.9,0.9,0.2> 
                looks_like{
                        box{<-0.06,-0.06,-0.06>,<0.06,0.06,0.06> 
                        pigment {rgbt <0.9,0.9,0.2,0>} finish {ambient 1}
                        }
                }

                fade_distance 0.3
                fade_power 1.5
                media_attenuation on 
        }
        
}

//the pillow for the bed
#declare pillow=object{
                Round_Box(<-0.1,-0.03,-0.3>, <0.1,0.03,0.3>, 0.07, 0)}
                 
                
//the hair for the head
#declare hair=isosurface{function{
        f_sphere(x,y,z, 4)
        -f_noise3d(x,y/2,z)
        }
        max_gradient 2
        contained_by {box{-5,5}}
        scale <0.1,0.05,0.05>
        scale 0.5
        pigment {colour Brown}
        }

#declare skin=texture{pigment {Flesh}}                                                  
#declare eye=union{//the eyes for the head, now lids are shut
                sphere {<-0.005,0,0>,0.016 texture {skin}}
                disc{<0.,0.002,0>,<0.33,1,0>,0.0167 pigment {Black}}
                scale 1.5
                }                
//the head
#declare head=union{union{blob{
                  sphere {<0.02,0.1,0>, 0.098,0.8  scale 0.8*z}
                  sphere {<0,0,0>, 0.04,0.8  scale <0.9,0.8,1> rotate 40*z translate <0.046,0.06,0>}//jaw
                  sphere {<0,0,0>,0.0253,-0.6 scale 0.5*y translate <0.055,0.062,0>}//mouth gap
                  cylinder {<0.063,0,-0.02>,<0.068,0,0>,0.01,0.6 translate 0.132*y}//frydia
                  cylinder {<0.063,0,0.02>,<0.068,0,0>,0.01,0.6 translate 0.132*y}//frydia
                  cylinder {<0.1,0.1,0>,<0.085,0.12,0>,0.013,1 scale 0.9}//nose
                  sphere {<0.095,0.1,0.008>,0.009,0.8 scale 0.9}//nostrils
                  sphere {<0.095,0.1,-0.008>,0.009,0.8 scale 0.9}
                  sphere {<0.106,0.09,0.008>,0.007,-0.8 scale 0.9}
                  sphere {<0.106,0.09,-0.008>,0.007,-0.8 scale 0.9}
                  sphere {<0,0,0>,0.012, -0.7 scale 0.65*y translate <0.07,0.12,0.012>}//eye gap
                  sphere {<0,0,0>,0.012, -0.7 scale 0.65*y translate <0.07,0.12,-0.012>}
                  sphere {<0,0,0>,0.005, 0.7 translate <0.07,0.12,0.022>}
                  sphere {<0,0,0>,0.005, 0.7 translate <0.07,0.12,-0.022>}
                  sphere {<0.05,0.05,0.025>,0.025,-0.2}//jawsides
                  sphere {<0.05,0.05,-0.025>,0.025,-0.2}
                  sphere {<0.05,0.04,0>,0.02,-0.2}
                  sphere {<0.06,0.09,0.02>,0.025,-0.05}
                  sphere {<0.06,0.09,-0.02>,0.025,-0.05}
                  sphere {<0.04,0.09,0.03>,0.035,-0.1}
                  sphere {<0.04,0.09,-0.03>,0.035,-0.1}
                  sphere {<0.06,0.1,0.018>,0.02,0.8}//cheeks
                  sphere {<0.06,0.1,-0.018>,0.02,0.8}
                  sphere {<0,0,0>,0.02,0.8 scale <0.7,0,0.2> translate <0.02,0.11,0.05>}//ears
                  sphere {<0,0,0>,0.02,0.8 scale <0.7,0,0.2> translate <0.02,0.11,-0.05>}
                  sphere {<0,0,0>,0.015,-0.8 scale <0.7,0,0.2> translate <0.02,0.11,0.054>}//ears
                  sphere {<0,0,0>,0.015,-0.8 scale <0.7,0,0.2> translate <0.02,0.11,-0.054>}                  
                  cylinder {<0,0,0>,<0,-0.12,0>,0.05,0.8 translate 0.1*y}//neck                                                                                                                     
                  threshold 0.25
                  texture {skin}}                                  
                  sphere_sweep {//frydia
                        cubic_spline
                        5,
                        <0.059,0.121,-0.04>,0.002
                        <0.071,0.131,-0.025>,0.005
                        <0.073,0.133,-0.015>,0.006
                        <0.076,0.131,-0.005>,0.007
                        <0.075,0.121,0>,0.002
                        pigment {colour Brown}
                        }
                  sphere_sweep {
                        cubic_spline
                        5,
                        <0.059,0.121,0.04>,0.002
                        <0.071,0.131,0.025>,0.005
                        <0.073,0.133,0.015>,0.006
                        <0.076,0.131,0.005>,0.007
                        <0.075,0.121,0>,0.002
                        pigment {colour Brown}
                        }                                                                                     
                  translate -0.1*y
                  scale 1.5
                  translate 0.1*y                  
                  }                      
                  object {eye translate <0.101,0.1295,0.023>}
                  object {eye  translate <0.101,0.1295,-0.023>}
                  object {hair rotate 50*z scale 0.8*y translate <-0.07,0.1,0>}
                  scale 1.15
                
                }


//the three snakes
#declare snake=union{
        sphere_sweep{
                b_spline
                12,
                <-1.4,0.01,0.5>,0.01
                <-1,0.02,0.5>,0.02                                
                <-0.8,0.03,0>,0.03
                <-0.5,0.04,-0.5>,0.04
                <-0.2,0.04,0>,0.04
                <0.2,0.04,0.5>,0.04
                <0.5,0.05,0>,0.05
                <0.8,0.05,-0.5>,0.05
                <1,0.05,0>,0.05
                <0.7,0.5,0>,0.05
                <0.5,1,0>,0.05
                <1,0.9,0>,0.05
                }
        sphere {<0,0,0>,0.1 scale <1,0.6,0.8> translate <0.65,0.9,0>}
        sphere {<0.65,0.94,0.05>,0.025 pigment {rgb 0.1}}
        sphere {<0.65,0.94,-0.05>,0.025 pigment {rgb 0.1}}
        cone {<0.7,0.9,0.05>,0.02,<0.7,0.8,0.05>,0.005 pigment {rgb 1}}
        cone {<0.7,0.9,-0.05>,0.02,<0.7,0.8,-0.05>,0.005 pigment {rgb 1}}                
                pigment {ForestGreen}
                normal {quilted scale 0.1}
                finish {specular 0.5 reflection 0.15 diffuse 0.5}                
                }

//the one flying snake                
#declare flyingsnake=union{
        sphere_sweep{
                b_spline
                10,                              
                <-0.3,-2.03,0>,0.01
                <0.5,-1.94,-0.5>,0.02
                <0.6,-1.64,0>,0.03
                <0.6,-1.4,0.5>,0.04
                <0.5,-0.8,0>,0.04
                <0.8,-0.5,-0.5>,0.05
                <0.6,0.05,0>,0.05
                <0.7,0.5,0>,0.05//
                <0.5,1,0>,0.05//
                <1,0.9,0>,0.05
                }
#declare lwing=union{
                cylinder {<0,0,0>,<0,0.1,0.7>,0.025}
                sphere {<0,0.1,0.7>,0.026}
                cone {<0,0.1,0.7>,0.025,<-0.125,-0.5,0.3>,0.001}
                cone {<0,0.1,0.7>,0.025,<-0.22,-0.7,0.7>,0.001}
                cone {<0,0.1,0.7>,0.025,<0,-0.5,1.1>,0.001}
                mesh {
                triangle {<0,0.1,0.7>,<-0.1,-0.4,0.3>,<-0.2,-0.6,0.7>}
                triangle {<0,0.1,0.7>,<-0.2,-0.6,0.7>,<0,-0.5,1.1>}
                triangle {<0,0,0>,<0,0.1,0.7>,<-0.1,-0.4,0.3>}
                triangle {<0,0,0>,<-0.1,-0.4,0.3>,<0,-0.4,0>}
                pigment {SeaGreen}
                normal {wrinkles scale 0.5}                        
                finish {specular 0.5 reflection 0.15 diffuse 0.5}}
                }
#declare rwing=union{
                cylinder {<0,0,0>,<0,0.1,-0.7>,0.025}
                sphere {<0,0.1,-0.7>,0.026}
                cone {<0,0.1,-0.7>,0.025,<-0.125,-0.5,-0.3>,0.001}
                cone {<0,0.1,-0.7>,0.025,<-0.22,-0.7,-0.7>,0.001}
                cone {<0,0.1,-0.7>,0.025,<0,-0.5,-1.1>,0.001}
                mesh {
                triangle {<0,0.1,-0.7>,<-0.1,-0.4,-0.3>,<-0.2,-0.6,-0.7>}
                triangle {<0,0.1,-0.7>,<-0.2,-0.6,-0.7>,<0,-0.5,-1.1>}
                triangle {<0,0,0>,<0,0.1,-0.7>,<-0.1,-0.4,-0.3>}
                triangle {<0,0,0>,<-0.1,-0.4,-0.3>,<0,-0.4,0>}
                pigment {SeaGreen}
                normal {wrinkles scale 0.5}                        
                finish {specular 0.5 reflection 0.15 diffuse 0.5}}
                }        
        object {lwing        
        translate <0.65,0.5,0>                
        pigment {LightBlue}               
        normal {quilted scale 0.1}
        finish {specular 0.5 reflection 0.15 diffuse 0.5}          
        }
        object {rwing        
        translate <0.7,0.5,0>                
        pigment {LightBlue}                
        normal {quilted scale 0.1}
        finish {specular 0.5 reflection 0.15 diffuse 0.5}  
        }
        sphere {<0,0,0>,0.1 scale <1,0.6,0.8> translate <0.65,0.9,0>}
        sphere {<0.65,0.94,0.05>,0.025 pigment {rgb 0.1}}
        sphere {<0.65,0.94,-0.05>,0.025 pigment {rgb 0.1}}
        cone {<0.7,0.9,0.05>,0.02,<0.7,0.8,0.05>,0.005 pigment {rgb 1}}
        cone {<0.7,0.9,-0.05>,0.02,<0.7,0.8,-0.05>,0.005 pigment {rgb 1}}                
                pigment {LightBlue}
                normal {quilted scale 0.1}
                finish {specular 0.5 reflection 0.15 diffuse 0.5}                
                }
//the coloured petals for the flowers                                
#declare petal=
        bicubic_patch{
                type 1
                flatness 0.01
                u_steps 3
                v_steps 3
                <-1.5,-7.5,0>, <-.5,-12.5,0>,<.5,-12.5,0>, <1.5,-7.5,0>,
                <-7.5,-2.5,0>,<-2.5,-2.5,-5>,<2.5,-2.5,-5>,<7.5,-2.5,0>, 
                <-7.5,2.5,0>,<-2.5,2.5,-5>,<2.5,2.5,-5>,<7.5,2.5,0>,
                <-5,7.5,0>,<-2.5,12,0>,<2.5,12,0>,<5,7.5,0>
                scale 0.04
                pigment {Light_Purple}
                normal {bumps bump_size 1. scale 0.3 frequency 0.5 turbulence 1}
                }

//the leaves for the plants and flowers                
#declare petal2=
        bicubic_patch{
                type 1
                flatness 0.01
                u_steps 3
                v_steps 3
                <-1.5,-7.5,0>, <-.5,-12.5,0>,<.5,-12.5,0>, <1.5,-7.5,0>,
                <-7.5,-2.5,0>,<-2.5,-2.5,-5>,<2.5,-2.5,-5>,<7.5,-2.5,0>, 
                <-7.5,2.5,0>,<-2.5,2.5,-5>,<2.5,2.5,-5>,<7.5,2.5,0>,
                <-5,7.5,0>,<-2.5,12,0>,<2.5,12,0>,<5,7.5,0>
                scale <0.06,0.06,0.035>
                pigment {Green}
                normal {wrinkles bump_size 1.5 scale 0.5 turbulence 2}
                }
//the flowers                                
#declare flower=union{
                #declare s=0;
                #while (s<360)
                object {petal rotate -90*y rotate -60*z translate 0.5*x rotate s*y }                
                #declare s=s+60;
                #end
                #declare s1=0;
                #while (s1<360)
                object {petal2 rotate -90*y rotate -90*z translate <0.5,-0.2,0> rotate s1*y }
                #declare s1=s1+90;
                #end
                light_source{<0,0,0>, Yellow looks_like{
                sphere {<0,0,0>,0.25 scale 0.5*y translate -.2*y pigment {Orange} normal {granite scale 0.1}
                finish {ambient 0.5}}                }
                        fade_distance 1 fade_power 2 media_attenuation on 
                }
                normal {wrinkles}
                finish {phong 0.5 reflection 0.1 ambient 0.25}
                }

//creating the dream above the sleeper                
#declare dream=union{
sphere {<0,0,0>,0.8 material {M_Glass3} pigment {Col_Glass_Bluish} translate <-1,2,-1>}
#include "dragon.inc"
object {dragon scale 0.1 rotate <-10,45,-30> translate <-1,2.1,-1>}
#declare lands=isosurface{function{y+3-f_ridge(x/2,0,z, 0.5, 0.5, 0.2, 0.3, 0.4, 0)}                
                max_gradient 4
                contained_by {sphere {<0,0,0>,7.9}}
                scale 0.1
                translate <-1,2,-1>
                pigment {wrinkles colour_map{[0.2 rgb 0.7][0.5 Tan][0.7 Green][0.8 rgb 0.7]}}
                normal {bumps}                
                }
object {lands}
light_source{<0,0,0>, rgb 0.3 looks_like{
sphere {<0,0,0>,0.2 pigment {LightBlue} normal {bumps}}}
fade_distance 0.8
fade_power 2 
translate <-1.2,2.3,-0.9>} 
translate <1,-2,1>
rotate 20*x
translate <-1,2,-1>
finish {ambient 0.65}
}

//creating the liquid pyramid           
#declare pyramid=union{
        polygon {4 <-12,-5,-12>,<-12,-5,12>,<12,-5,12>,<12,-5,-12>}
        triangle {<-12,-5,-12>,<-12,-5,12>,<0,15,0>}
        triangle {<-12,-5,-12>,<12,-5,-12>,<0,15,0>}
        triangle {<12,-5,12>,<-12,-5,12>,<0,15,0>}
        triangle {<12,-5,12>,<12,-5,-12>,<0,15,0>}
        material {
                        texture {
                                pigment {colour rgbt <0.5, 0.5, 1, 0.8>}
                                finish {ambient 0.0 diffuse 0.0 reflection {0.2, 0.9 fresnel on} specular 0.4 roughness 0.003}
                                normal {function {f_noise3d(x,y,z)} 0.8 }    
                        }
                        interior {ior 1.1}
                }
        
        
        }                
        
                
           
//the two green plants
#declare plant=union{
                isosurface{
                        function{
                                f_helix1(x,y,z, 2, 4, 0.04, 0.2, 1, 1.2, 0)
                                }
                        max_gradient 4
                        contained_by {box{-3,1.5}}
                        }
                        sphere {<0,0,0>,0.18 scale <2,0.5,2> translate <0,1.4,0>}
                        #declare s1=0;
                        #while (s1<360)
                        object {petal2 scale 0.5 rotate -90*y rotate -60*z translate <0.5,1.5,0> rotate s1*y }
                        #declare s1=s1+45;
                        #end
                        pigment {rgb <0.5,0.78,0.5>}
                        normal {bumps turbulence .5}
                        finish {phong 0.4 ambient 0.2 reflection 0.2}
                        }
//the mountain range far in the distance                        
#declare mountain=isosurface{
                        function{
                              f_spikes_2d(x,2*y,z, 10, 2, 2, 0.1)-f_noise3d(x,y,z)*2                         
                        }
                        open
                        max_gradient 20
                        contained_by {sphere {<0,0,0>,10}}
                        pigment {wrinkles colour_map {[0.0 GreenYellow][0.1 Tan][0.5 Gray][0.7 CadetBlue][1.0 DarkSlateGray]} turbulence 0.5}
                        normal {agate}
                        finish {phong 0.6 diffuse 0.5 ambient 0.3 reflection 0.3}
                        }
//creating the flying fish                        
#declare fishlike=union{
                blob{
                        sphere {<0,0,0>,0.2,1 scale 2*x translate <1.2,-0.15,0> pigment {BlueViolet} normal {quilted scale <2,0.2,2>} finish {reflection 0.35}}   
                        sphere {<0,0,0>,0.2,1 scale 2*z translate <1,0.1,0> pigment {Red} normal {wrinkles scale 0.1} finish {reflection 0.4}}
                        cylinder {<-1,0,0>,<1,0,0>,0.5,0.8 scale 0.5*z translate -0.1*y}
                        sphere {<0,0,0>,1,0.8 scale 0.1*z pigment {Aquamarine} normal {quilted scale <0.1,2,0.1>} finish {reflection 0.35}}
                        sphere {<0,0,0>,0.4,0.8 scale 0.5*z translate -x}
                        sphere {<0,0,0>,0.6,0.8 scale 0.3*z translate -1.4*x}
                        //sphere {<0,0,0>,0.6,0.8 scale <1,0.2,0.5> translate -1.4*x pigment {Aquamarine} normal {quilted scale <0.1,0.1,2>} finish {reflection 0.35}}
                        sphere {<0,0,0>,0.6,0.8 scale <2,0.4,0.2> rotate -40*z translate <-1.4,0.3,0> pigment {LightBlue} normal {wrinkles scale 0.1} finish {reflection 0.35}}
                        sphere {<0,0,0>,0.6,0.8 scale <2,0.4,0.2> rotate 40*z translate <-1.4,-0.3,0> pigment {LightBlue} normal {wrinkles scale 0.1} finish {reflection 0.35}}
                        sphere {<0,0,0>,0.8,0.9 scale <0.5,0.2,1> rotate -40*y rotate <20,0,0> translate <-0.2,-0.1,0.3> pigment {LightBlue} normal {wrinkles scale 0.1} finish {reflection 0.35}}
                        sphere {<0,0,0>,0.8,0.9 scale <0.5,0.2,1> rotate 40*y rotate <-20,0,0> translate <-0.2,-0.1,-0.3> pigment {LightBlue} normal {wrinkles scale 0.1} finish {reflection 0.35}}
                
                        threshold 0.25
                }               
                pigment {colour SeaGreen}
                normal {quilted scale 0.2 rotate 45*z}
                finish {reflection 0.35}
                }
                
//adding all of these to the scene                
object {pyramid scale 0.5 rotate 35*y translate <-1,0,-40>}                
object {fishlike rotate -10*y   translate <-11,5.3,-7>  }
object {fishlike rotate 10*y  rotate -15*z  translate <-9,3.8,-5.7>  }                                         
object {mountain rotate 20*y scale <1.5,1.2,1> translate <-40,-2,-30>  }                                                       
object {plant rotate -5*x translate <-16,-0.5,-12> }                                                        
object {plant rotate 10*z translate <-12,0,-7> }   
object {dream}                                                                                             
object {flower rotate 0 translate <-2,-1,-14>  }
object {flower rotate 0 translate <-4,-1,-9>  }
object {flower rotate 0 translate <-5,-1,-15>  }
object {sea} 
object {snake rotate 180*y translate <0.5,-1.8,-4>  }                                
object {snake translate <-6,-1.9,-3>  }
object {snake rotate 90*y translate <-2.5,-1.8,-1.5>  }
object {flyingsnake rotate <0,220,20> translate <0.5,2,-5> }
object {bed translate 0.05*z  }
object {stool}
object {lamp translate <-1.8,0.53,-.8> }
object {pillow  scale 0.8*y translate <-1.85,0.5,-1.495> pigment {White} normal {wrinkles turbulence 2} }
object {head rotate 60*z translate <-1.65,0.52,-1.495> }