#declare RENDER_MAIN=1;
#declare FINAL_HQ=1;
#declare LIGHT_HQ=1;

#include "room.inc"
#include "vr_tank.inc"
#include "vr_comp.inc"
#include "bot1.inc"
#include "hologram.inc"
#include "rad_def.inc"
#default { pigment { color rgb 1 } }

global_settings {
  assumed_gamma 2.2
  radiosity { Rad_Settings(Radiosity_IndoorHQ, true, true)}
  photons {spacing 0.05 media 100000 autostop 0}
  max_trace_level 20
}

camera {                    

  location  <4, 1.8, -8.0>
  look_at   <3.8, .35, 4>
  angle 26
}

light_source {  <4, 2.4, 4>  color Green*.12 fade_distance 2.85 fade_power 75 media_interaction on photons { reflection on refraction on }}
light_source {  <4, .4, 4>  color Green*.12 
  area_light
  <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  circular            // make the shape of the light circular
  orient              // orient light
  media_interaction on photons { reflection on refraction on }
}


object{ ROOM }
object { bot1 scale .25 rotate -y*70 translate <5.6,0.45,3.5> } object { bot2 scale .25 translate <5.3,0.45,8.5> } object { bot3 scale .25 rotate -y*25 translate <5,0.45,9.3> } object { bot4 scale .25 rotate y*190 translate <3.7,0.45,8.7> }
object { VR_TANK(45,on) scale .9 translate <3.3, 0, 7> } object { VR_TANK(45,off) scale .9 translate <2.0, 0, 5.5> } object { VR_TANK(90,off) scale .9 translate <2.0, 0, 3.5>}
object { HOLO translate <4,0,4> }
object { laser }
object { VR_COMP(on ) rotate y*45 translate <5.55,0,6.9> } object { VR_COMP(off) rotate y*45 translate <4.825,0,6.9> } object { VR_COMP(off) rotate y*45 translate <4.1,0,6.9> }
object { pipes }

