#include "math.inc"
#include "glass.inc"
#include "metals.inc"
#include "colors.inc"

#macro VR_COMP(ON)
union {
 union {
  box {0,<.1,.2,.1> translate <0,.2,-.25>}
  #if(ON)
   #local ONOFF=Green;
  #else 
   #local ONOFF=Red;
  #end 
  union {
   box { 0,<.1,.005,.1> }
   box { 0,<.1,.005,.1>  translate -y*.025 }
   texture { pigment { color ONOFF} finish {ambient 1 diffuse 1 }} 
   translate <0,.2,-.26>
  }   
  superellipsoid { <1, .1> rotate x*90 translate y scale <.25,50/200,.25>}
  superellipsoid { <1, .2> rotate x*90 translate y scale <.25,10/200,.25> translate y*.52}
  superellipsoid { <1, .2> rotate x*90 translate y scale <.25,10/200,.25> translate y*.64}
  superellipsoid { <1, .2> rotate x*90 translate y scale <.25,10/200,.25> translate y*.76}
  torus{ .28, .03 } 
  superellipsoid { <1, .2> rotate x*90 scale <.3,1/20,.3>} 
  superellipsoid { <1, .2> rotate x*90 translate y scale <15/200,10/200,15/200> translate <.32,-.05,0>}
  superellipsoid { <1, .2> rotate x*90 translate y scale <15/200,10/200,15/200> translate <.28,-.05,.15>}
  superellipsoid { <1, .2> rotate x*90 translate y scale <15/200,10/200,15/200> translate <.28,-.05,-.15>}
  texture {
   function { x*sin(y)*sin(y)+cos(z) }
    texture_map {
     [0  pigment {color White} finish { ambient .35 specular 0.05}  ]
     [1  pigment {color Black} finish { ambient .2 specular 0.005} ]
    }
    scale .2
  } 
 }
 union {
  torus{ .25, .015 translate y*.038 }
  cylinder { 0, y*.07, .07 translate x*.21}
  cylinder { 0, y*.07, .07 translate -x*.21}
  cylinder { 0, y*.07, .07 translate z*.21}
  cylinder { 0, y*.07, .07 translate -z*.21}
  texture { T_Silver_2A pigment { color White}}
 }  
union {
 #local HI=1.2; 
 #local VRTRANSMIT=.80;
 #local VRTRANSMIToff=1.25; //.98
#if (ON)           
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.32,-.05,0>    pigment { color Col_Yellow_04 filter .9 transmit VRTRANSMIT} hollow}
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.28,-.05,.15>  pigment { color Col_Blue_02       filter .9 transmit VRTRANSMIT} hollow}
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.28,-.05,-.15> pigment { color Col_Red_02        filter .9 transmit VRTRANSMIT} hollow}
#else 
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.32,-.05,0>    pigment { color rgb .5  transmit VRTRANSMIToff}}
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.28,-.05,.15>  pigment { color rgb .5  transmit VRTRANSMIToff}}
 merge { cylinder { 0,HI*y,.06} sphere {HI*y,.06} translate <.28,-.05,-.15> pigment { color rgb .5  transmit VRTRANSMIToff}}
#end
 texture { finish   { F_Glass2 } }
 interior { I_Glass2 ior 1.362}
 photons {target reflection on refraction on}
 }
}
#end

#declare pipes = union {
 cylinder { 0,x*5.55,.03 translate <0,.1,7.94> }
 cylinder { 0,x*4.825,.03 translate <0,.15,7.94> }
 cylinder { 0,x*4.1,.03 translate <0,.2,7.94> }
 pigment { color White*1.5 }
 finish {phong 0.9 phong_size 150 }
} 

