// Submitted IRTC scene file
// "gradient.pov"
// (C) 2002 Peter Hertel http://hertel.no/peter
// Feel free to use this scene file to learn, copy only referring to me as author.

// Topic : Dreaming
// Image : gradient.jpg
// Title : Gradient - Alien invasion

// Files included in this zip file:
// gradient.pov - scene control and camera
// gradient.obj.inc - object file
// gradient_paper.png - paper image map (small version)
// gradient.txt - included IRTC text file

// Files not included:
// hand_flat.inc hand_write.inc hand_mat.inc (hand meshes)

// Hope you enjoy!

// Scene made to be rendered in 4/1 widescreen only
// Command line examples below

// +w400 +h100
// +w600 +h150
// +w800 +h200
// +w1024 +h256
// +w1600 +h400
// +w3200 +h800

//simple macro to control which objects to render
#macro Obj(Fi,F1,M1,L1,SF1,SM1,SL1,WI,LT)
    #declare F = Fi;
    #declare First_Room = F1;
    #declare Middle_Room = M1;
    #declare Last_Room = L1;
    #declare Stuff_First_Room = SF1;
        #if(SM1=0)
            #declare Stuff_Middle_Room = 0;
            #declare Hand = 0;
        #end
        #if(SM1=1)
            #declare Stuff_Middle_Room = 1;
            #declare Hand = 0;
        #end
        #if(SM1=2)
            #declare Stuff_Middle_Room = 1;
            #declare Hand = 1;
        #end
    #declare Stuff_Last_Room = SL1;
        #if(WI=0)
            #declare ISO_Water = 0;
            #declare ISO_Water_Detail = 0;
        #end
        #if(WI=1)
            #declare ISO_Water = 1;
            #declare ISO_Water_Detail = 0;
        #end
        #if(WI=2)
            #declare ISO_Water = 0;
            #declare ISO_Water_Detail = 1;
        #end
        #if(WI=3)
            #declare ISO_Water = 1;
            #declare ISO_Water_Detail = 1;
        #end
    #declare Light_Type=LT;
#end

/*
Obj(Finish,Room1,Room2,Room3,Obj1,Obj2,Obj3,WaterDetail,Lights)

Finish on/off,
Rooms on/off
Objects on/off (Obj2 0=off 1=on 2=on+hands)
Water 0/1/2/3 (0=off-detail 1=on-detail 2=off+detail 3=on+detail)
Lights 0/1/2/3/4 (0=plain 1=fade 2=area4x4adapt0 3=area5x5adapt1 4=area9x9adapt2)
*/                      

//Here you are able to control the objects in the scene, details above.
//Note: Hand meshes not included. Setting Obj2 to 2 won't help.

Obj(0, 1,1,1, 1,1,1, 0,1)//Low quality, no finish, water or area lights.
//Obj(1, 1,1,1, 1,1,1, 3,4)//Full quality (look mommy! no hands :)

#include "woods.inc"
#include "shapes.inc"
#include "textures.inc"
#include "gradient.obj.inc"

//Toggels the lights in each room, from left to right
Lights(1,1,1)

camera {
location <0,20,-30>*5 right x*8 up y*2 look_at <0,15,0> angle 55
}

//tune this down if the image is to dark
global_settings{assumed_gamma 4}