#include "tuien.inc"
#include "brugcolors.inc"
#include "pyloon.inc"

camera {
 up y*1
 right x*1.7808695651
 location <-10,35,60>
 look_at <0,25,0>
}

light_source { <50,100,50> rgb 1 }

#local Monitor = union {
  #local Bird = box {
    <0,0,-.1>,<1,1,-.101> pigment { image_map { tga "veugel.tga" } }
  }
  #local Frame = union {
    box { <0,0,0>,<1,1,0.001>  pigment { image_map { tga "screenshot.tga" } rotate y*180 translate x*1 }  finish { ambient .9 } translate x*-.5 scale <40,30,1> }
    box { <-20,0,1>,<-23,30,-2> }
    box { <20,0,1>,<23,30,-2> }
    box { <-23,0,1>,<23,-5,-2> }
    box { <-23,30,1>,<23,33,-2> }
  }
  object { Bird scale 30 translate y*30 }
  object { Frame translate y*10}
  box { <-10,0,-5>,<10,1,5> }
  cylinder { 0,<0,5,0>,5 scale <1,1,.5>}
  sphere { 0,5 scale <1,.5,.5> translate y*5 }
  pigment { rgb 1 }
}

#local GT_city = union {
  box {
    <0,0,0>,<1,1,0.001> pigment { image_map { tga "gt_city.tga" } rotate y*180 translate x*1 } finish { ambient .3 } 
  } 
  #local tn = .01 ;
  box { <0,0,0>,<1,-tn,tn> }
  box { <0,1,0>,<1,1+tn,tn> }
  box { <0,-tn,0>,<-tn,1+tn,tn> }
  box { <1,-tn,0>,<1+tn,1+tn,tn> } 
  pigment { rgb <0,.5,0> }
  finish { metallic 1 }
}

#local Book = union {
  box { <0,0,0>,<1,1,1> pigment { image_map { tga "book.tga" } rotate y*180 translate x*1 } rotate x*-90 scale <20,1,30> }
  cylinder { <20,.5,0>,<20,.5,-30>,.7 open pigment { gradient z
      pigment_map {
        [0 color rgbt 0]
        [.5 color rgbt 0]
        [.5 color rgbt 1]
        [1 color rgbt 1]
      }
    }
  }
}

#local ErasmusBrug = union {
  object { Obj_Total_Tuien }
  object { Obj_Total_Pyloon }
  object { Obj_Total_Achterligger }
}

object { ErasmusBrug scale .25 rotate y*180 translate <60,0,-20> }
object { Book rotate y*-30 translate <15,0,10> }
object { Monitor rotate y*10 translate x*-20 }
object { GT_city scale <1,1.3333,1> scale 30 translate <20,20,-30> }
plane { y,0 pigment { rgb <1,.95,.8> } }
plane { z,-30 pigment { rgb <1,.95,.8> } }










