#include "rand.inc"

#local PintPos=<25.0, -13.5, 0.0>;

#if (WriteFroth)
#fopen FrothFile "thewholefroth.dat" write
#debug "Opened file for write\n"
#else
#fopen FrothFile "thewholefroth.dat" read
#debug "Opened file for read\n"
#end

#declare InPintText= texture {
		pigment {colour rgb 1 filter .75}
		finish {specular 1 roughness .0005 diffuse 1.0 ambient .8}
	}


#declare BubbleText=texture {
	pigment {
		colour rgb <1,1,1> filter .74
	}
         finish {
            ambient 0.5//.8
            phong 1.0
            phong_size 100.0
            diffuse .8//1.4
         }
}

#local MakeLayer1=on;
#local MakeLayer2=off;
#local MakeLayer3=off;
#local MakeBand=on;
#local MakeInPint=on;

#local Layer1Number=15000;
#local Layer1Rand=seed(1976);
#local Layer1SizeRand=seed(26);
#local Layer1Size=.08;
#local StandDev=.15;

#local InPintNumber=150;
#local InPintRand=seed(2001);
#local InPintSizeRand=seed(2010);
//#local InPintSize=.08;
#local InPintSize=.05;

#local BandNumber=15000;
#local BandRand=seed(2001);
#local BandSizeRand=seed(2010);
#local BandSize=.02;
#local BandStandDev=.35;

/* Very good band 
#local BandNumber=15000;
#local BandRand=seed(2001);
#local BandSizeRand=seed(2010);
#local BandSize=.02;
#local BandStandDev=.35;
*/

#local bubblecount=0;
//#local beerrad=4.146;
//#local beerrad=4.000;
#local beerrad=4.3;


#local HowManyBubbles=0;
#if (!WriteFroth)
#declare Froth = union {
#local BUBPOS=<0,0,1>;
#local BUBSIZE=0;
#while (defined(FrothFile))
#read (FrothFile,BUBPOS,BUBSIZE)
//#read (FrothFile,BUBSIZE)
//#debug concat("Pos=<",str(BUBPOS.x,2,2),",",str(BUBPOS.y,2,2),",",str(BUBPOS.z,2,2),">,",str(BUBSIZE,2,2),"\n")

sphere {
	0,BUBSIZE
	translate BUBPOS
}
#local HowManyBubbles=HowManyBubbles+1;

#end

#debug concat("Read in ", str(HowManyBubbles,2,0), " bubbles, to make the creamy head (mmm)\n")

	texture {
		BubbleText
	}
}

#else

#declare Froth=union {

#if (MakeLayer1)
//************************************************************************************* Layer 1
#debug "Parsing Layer1\n"

#while (bubblecount<Layer1Number)
#if (bubblecount/1000=floor(bubblecount/1000))
#debug concat("Done ",str(bubblecount,4,0)," out of ",str(Layer1Number,4,0),"\n")
#end

#local BubbleRad=Rand_Normal(beerrad,beerrad*StandDev,Layer1Rand);
#local BubbleTheta=rand(Layer1Rand)*360;

#local BubbleX=BubbleRad*cos(radians(BubbleTheta));
#local BubbleY=BubbleRad*sin(radians(BubbleTheta));

//#local BubbleX=(rand(randbubble)-.5)*8.3;
//#local BubbleY=(rand(randbubble)-.5)*8.3;

#local tracestart=<BubbleX,BubbleY,100>;
#local traceend=trace(beer, tracestart ,-z);

//#if (traceend.z=0) #debug "---" #end
//#debug concat("tracestart=", str(tracestart.x, 3,3), ", ", str(tracestart.y, 3,3), ", ", str(tracestart.z, 3,3), "\n")
//#debug concat("radius, angle=", str(BubbleRad, 3,3), ", ", str(BubbleTheta, 3,3), "\n")


//#debug concat("traceend=", str(traceend.x, 3,3), ", ", str(traceend.y, 3,3), ", ", str(traceend.z, 3,3), "\n")
#if ((traceend.z>13)&(!((BubbleRad>beerrad)|(BubbleRad<0))))

#local BubbleSize=Rand_Normal(Layer1Size,Layer1Size/2,Layer1SizeRand);
#write (FrothFile,traceend," , ",BubbleSize,", \n")
sphere {
	0,BubbleSize
	translate traceend
}
#local bubblecount=bubblecount+1;
#end
#end

/*translate PintPos
}*/


/*#declare CurrentPint=union {
	object {beer}
	object {Layer1}
}*/

#end

#local bubblecount=0;

#if (MakeBand)
// ************************************ Band round glass
#debug "Parsing Band\n"

#declare CurrentPint=union {
	object { beer }
	object { glass }
}

//#declare Band=union {

#while (bubblecount<BandNumber)
#if (bubblecount/1000=floor(bubblecount/1000))
#debug concat ("Done ",str(bubblecount,4,0)," out of ",str(BandNumber,4,0),"\n")
#end

#local BubbleHeight=Rand_Normal(0,BandStandDev,BandRand);
#if (BubbleHeight<0)
#declare BubbleHeight=-BubbleHeight;
#end
#local BubbleTheta=rand(BandRand)*360;

#local tracestart=<0,0,13.5+BubbleHeight>;
#local tracenormal=<cos(radians(BubbleTheta)),sin(radians(BubbleTheta)),0>;
#local traceend=trace(CurrentPint, tracestart ,tracenormal);

#if (traceend.z=0) #debug "---" #end

//#debug concat("tracestart=", str(tracestart.x, 3,3), ", ", str(tracestart.y, 3,3), ", ", str(tracestart.z, 3,3), "\n")
//#debug concat("angle=", str(BubbleTheta, 3,3), "\n")


//#debug concat("traceend=", str(traceend.x, 3,3), ", ", str(traceend.y, 3,3), ", ", str(traceend.z, 3,3), "\n")

#local BubbleSize=Rand_Normal(BandSize,BandSize/2,BandSizeRand);

#write (FrothFile,traceend," , ",BubbleSize,", \n")

sphere {
	0,BubbleSize
	translate traceend
}
#local bubblecount=bubblecount+1;
#end

//translate PintPos
//}

#end

#debug concat("traceend=", str(traceend.x, 3,3), ", ", str(traceend.y, 3,3), ", ", str(traceend.z, 3,3), "\n")

	texture {
		BubbleText
	}
}

#end

#local bubblecount=0;



#if (MakeInPint)

#debug "Parsing In Pint\n"

#declare InPint=union {

#while (bubblecount<InPintNumber)
#if (bubblecount/100=floor(bubblecount/100))
#debug concat ("Done ",str(bubblecount,4,0)," out of ",str(InPintNumber,4,0),"\n")
#end

#local BubbleHeight=rand(InPintRand)*13;
#local BubbleTheta=rand(InPintRand)*360;

#local tracestart=<0,0,.5+BubbleHeight>;
#local tracenormal=<cos(radians(BubbleTheta)),sin(radians(BubbleTheta)),-.1>;
#local traceend=trace(glass, tracestart ,tracenormal);

#if (traceend.z=0) #debug "---" #end

//#debug concat("tracestart=", str(tracestart.x, 3,3), ", ", str(tracestart.y, 3,3), ", ", str(tracestart.z, 3,3), "\n")
//#debug concat("angle=", str(BubbleTheta, 3,3), "\n")
//#debug concat("traceend=", str(traceend.x, 3,3), ", ", str(traceend.y, 3,3), ", ", str(traceend.z, 3,3), "\n")



#local BubbleSize=Rand_Normal(InPintSize,InPintSize/4,InPintSizeRand);

sphere {
	0,BubbleSize
	translate traceend
}
#local bubblecount=bubblecount+1;
#end

	texture {
		InPintText
	}
}

#end 

union {
	object {Froth}
	#if (MakeInPint)
	object {InPint}
	#end
	translate PintPos
	split_union on
}

//#if (defined(FrothFile))
//#fclose FrothFile
//#end