#macro Closet (OW,OH,IW,IH,FTex,DTex,HTex,Cent,Orient)
  #local mol_pc = 
    prism{
	cubic_spline
	-.5,.5,19,
	<0.864606,0.006176>,
	<1.019000,0.006176>,
	<1.080757,0.037055>,
	<1.080757,0.253206>,
	<1.019000,0.314964>,
	<0.988121,0.500236>,
	<0.988121,0.654630>,
	<0.988121,0.778145>,
	<0.957242,0.839903>,
	<0.957242,0.963418>,
	<0.926364,0.994297>,
	<0.833727,0.994297>,
	<0.833727,0.932539>,
	<0.833727,0.747267>,
	<0.833727,0.438479>,
	<0.833727,0.067933>,
	<0.864606,0.006176>,
	<1.019000,0.006176>,
	<1.080757,0.037055>
     }  

  #declare handle = 
  lathe{
  	cubic_spline
  	14,
	<0.000000,0.080325>,
	<0.114750,0.022950>,
	<0.401623,0.022950>,
	<0.401623,0.080325>,
	<0.344249,0.137699>,
	<0.172124,0.252449>,
	<0.401623,0.424573>,
	<0.458998,0.711447>,
	<0.286874,0.940946>,
	<0.000000,0.998321>,
	<0.000000,0.883571>,
	<0.000000,0.080325>,
	<0.114750,0.022950>,
	<0.401623,0.022950>
  }

  #local mol= object{ mol_pc scale <(OH-IH)/2,1,(OH-IH)/2> rotate -90*x rotate 90*y rotate 180*z translate <0,(OH-IH)/2,2.1> }
  #local frame= 
    union{
      box{ <-.5,0,0> <.5,.5,20> translate .008*y}
      object{ mol }
    } 
       
  #local fortyfive_20eg_cut= box{ <0,0,1> <20,20,-6> rotate -45*z }
  
  #local frame_top= 
    difference{
      object{ frame scale <OW,1,1> translate ((IH)+.02)*y }
      object{ fortyfive_20eg_cut rotate 180*z translate <-IW/2,IH+.02,0> }
      object{ fortyfive_20eg_cut translate <IW/2,IH+.02,0> }
    }
          
  #local frame_right= 
    difference {
      object{ frame rotate -90*z scale <1,OH,1> translate <((IW/2)+.02),OH/2,0> }
      object{ fortyfive_20eg_cut rotate -90*z translate <IW/2+.02,-IH,0> } 
      object{ fortyfive_20eg_cut rotate 90*z translate <IW/2+.02,IH,0> } 
    }

  #local frame_left= object{ frame_right scale <-1,1,1> }
  
  #local frame_t= 
    union{
      object{ frame_top }
      object{ frame_right }
      object{ frame_left } 
    }

  #local s1 = seed( 94380948 );
  #local r1 = rand( s1 );
  #local r2 = rand( s1 );
  #local r3 = rand( s1 );
  #local r4 = rand( s1 );

  union{   
    object{ frame_t texture { FTex } }
    box{ <-IW/2+.4,.5,0> <-IW/4-.1,IH-.5,1> texture { DTex translate 10*r1 } }
    box{ <-IW/4+.1,.5,0> <-.1,IH-.5,1> texture { DTex translate 10*r2 } }
    box{ <.1,IH-.5,0> <+IW/4-.1,.5,1> texture { DTex translate 10*r3 } }
    box{ <IW/4+.1,.5,0> <IW/2-.4,IH-.5,1> texture { DTex translate 10*r4 } }
    object{ handle scale 1.5 rotate -90*x texture{ HTex } translate <-IW/8.4,IH/2.3,.1> }
    object{ handle scale 1.5 rotate -90*x texture{ HTex } translate <IW/8.4,IH/2.3,.1> }
    rotate Orient*y translate Cent+<0,-.2,0> 
    }
  
  
#end