#version unofficial MegaPov 0.7;

////////////// Room //////////////////

#declare room_width = 10*12;
#declare room_height = 8*12;
#declare room_depth = 16*12;
#declare window_origin = <-room_width/2,4.7*12,60>;
#declare window_width = 25;
#declare window_height = 33;
#declare roof = 1; #if (roof = 0) #declare rf_twk = 5; #else #declare rf_twk = 0; #end
#declare closet_width = 50;
#declare closet_height = 76;
#declare closet_origin = <room_width/2,0,35>;

union{
  difference{
    difference{
      union{
        box{ <-room_width/2-1,0-1,-room_depth/2-1> <room_width/2+1,room_height+1,room_depth/2+1> }
        box{ <-20,0,-closet_width/2-5> <20,closet_height+5,closet_width/2+5> translate closet_origin }
      }  
      box{ <-room_width/2,0-.5,-room_depth/2> <room_width/2,room_height+rf_twk,room_depth/2> }
    }
    union{
      box{ <-10,-window_height/2,-window_width/2> <10,window_height/2,window_width/2> translate window_origin }
      box{ <-20,0,-closet_width/2> <20,closet_height,closet_width/2> translate closet_origin }
    }
    texture{ wall_tex }
  }
  box{ <-room_width/2-10,-1,-room_depth/2-10> <room_width/2+10,.1,room_depth/2+10> texture{ floor_tex } }
  box{ <-room_width/2-10,room_height-.5,-room_depth/2-10> <room_width/2+10,room_height,room_depth/2+10> texture{ ceiling_tex } }
}

////////////// Arm //////////////////

#switch ( arm_obj )
  #case ( 1 )
    #include "arm_fine.inc"
    union{
      object{ arm texture{ scales }}
      object{ nails texture{ nail_tex }}
      scale -.3
      rotate -80*x
      rotate -90*y
      rotate 40*z
      //rotate 20*x
      translate <0,27,70>
    }
  #break
  #case ( -1 )
    #include "arm_coarse.inc"
    union{
      object{ arm texture{ scales }}
      object{ nails texture{ nail_tex }}
      scale -.3
      rotate -80*x
      rotate -90*y
      rotate 40*z
      //rotate 20*x
      translate <0,27,70>
    }
   #break  
   #case ( 0 )
   #break
#end

////////////// Bed //////////////////

#declare bed_pos = <-room_width/2+29,0,room_depth/2-43>;

#switch ( bed_obj )
  #case ( 1 )
    #include "bed_fine.inc"
    object{ bed_frame 
       translate bed_pos 
     }
  #break
  #case ( -1 )
    #include "bed_coarse.inc"
    object{ bed_frame 
       translate bed_pos 
     }  
  #break
  #case ( 0 )
  #break
#end

#if ( mattress_obj = 1 ) 
  #include "mattress.inc"
    object{ mattress 
       translate bed_pos+<0,0,4> 
       texture{ blank }
    }
#end

#switch ( comforter_obj )
  #case ( 1 )
    #include "comforter_fine.inc"
    #include "pillow.inc"
    object{ comforter 
       translate bed_pos 
       texture{ mblue }
     }
    object{ pillow 
       translate bed_pos 
       texture{ bwhite }
     }
  #break
  #case ( -1 )
    #include "comforter_coarse.inc"
    object{ comforter 
       translate bed_pos 
       texture{ blank }
     }  
  #break
  #case ( 0 )
  #break
#end

////////////// Window ////////////////// 

#include "window_macro.inc"
#if ( window_obj =! 0 )
  Window_Frame (window_width+4,window_height+4,window_width-2,window_height-2,5,ltbrown,clear,window_origin,-90)
#end


///////////// Night Light ////////////////



#declare nl_pos = <room_width/2-12,11,room_depth/2-.05>;

#switch ( nightlight_obj )
  #case ( 1 )
    #include "night_light.inc"
    object{ socket 
       translate nl_pos 
       texture{ blank }
     }
    object{ cover 
       translate nl_pos 
       texture{ nightlight }
       //no_shadow
     }
    light_source{ 
      nl_pos+<0,2.62,-.45> 
      color rgb .4*<1,.7,.6> 
      fade_distance 30 
      fade_power 2 
      media_interaction off 
      area_light <0,0,.3>, <0,.3,0>, 4, 4 adaptive 1 jitter
      }
  #break
  #case ( -1 )
    #declare night_light = box{ <-1,-2,-.65> <1,2,.5> texture{ nightlight } }
    light_source{ nl_pos color rgb .2*<1,1,.7> looks_like{ night_light } fade_distance 30 fade_power 2 media_interaction off }  
  #break
  #case ( 0 )
  #break
#end

////////////  Night Stand ///////////////

#if ( nightstand_obj =! 0 )
  #include "night_stand.inc"
  union{
    object{ night_stand texture{ walnut } }
    object{ night_stand_handles texture{ brushed_aluminum } }
    translate <10,0,room_depth/2-9.5> 
  }
#end

/////////////////////////////////////

#if ( closet_obj =! 0 )
  #include "closet_macro.inc"
  Closet (closet_width+2,closet_height+4,closet_width-2,closet_height-2,gwhite,walnut,brushed_aluminum,closet_origin,90)
#end

/////////// Posters ////////////////

#if ( poster_obj =! 0 )

#include "thumbtack.inc"

//F-16 CAD Poster
union{
  box{ 
    <-40/2,-40/2*.7,-.01> <40/2,40/2*.7,0>
    pigment{ color rgbt 1 }
    texture{
      pigment{
        image_map{
          png "poster_f16.png"
          map_type 0
          once
          interpolate 2
        }
      }
      finish{ diffuse .95 }
      translate <-.5,-.5,0>
      scale <30,30*.7,1>
    }
  }
  thumbtack (.8,<29/2,20/2,-2>,0,654)
  thumbtack (.8,<29/2,-20/2,-2>,0,524)
  thumbtack (.8,<-29/2,20/2,-2>,0,784)
  thumbtack (.8,<-29/2,-20/2,-2>,0,725)  
  translate <-30,60,room_depth/2>
}

//Car Poster
union{
  box{ 
    <-40/2,-40/2*.75,-.05> <40/2,40/2*.75,-.04>
    pigment{ color rgbt 1 }
    texture{
      pigment{
        image_map{
          png "poster_car.png"
          map_type 0
          once
          interpolate 2
        }
      }
      finish{ diffuse .95 }
      translate <-.5,-.5,0>
      scale <30,30*.7,1>
    }
  }
  thumbtack (.8,<29/2,20/2,-2>,0,374)
  thumbtack (.8,<29/2,-20/2,-2>,0,256)
  thumbtack (.8,<-29/2,20/2,-2>,0,973)
  thumbtack (.8,<-29/2,-20/2,-2>,0,164)  
  translate <25,55,room_depth/2>
}

//Monster Poster
union{
  box{ 
    <-40/2,-40/2*.75,-.05> <40/2,40/2*.75,-.04>
    pigment{ color rgbt 1 }
    texture{
      pigment{
        image_map{
          png "poster_monster.png"
          map_type 0
          once
          interpolate 2
        }
      }
      finish{ diffuse .95 }
      translate <-.5,-.5,0>
      scale <.64*30,30,1>
    }
  }
  thumbtack (.8,<18/2,28/2,-2>,0,314)
  thumbtack (.8,<18/2,-28/2,-2>,0,456)
  thumbtack (.8,<-18/2,28/2,-2>,0,13)
  thumbtack (.8,<-18/2,-28/2,-2>,0,128)  
  rotate 90*y
  translate <room_width/2,59,room_depth/2-18>
}


#end


///////////////// Telescope /////////////

#if ( tele_obj =! 0 )
  #include "telescope.inc"
  union{
   object{ tele_chrome texture{ brushed_aluminum } }
   object{ tele_fblack texture{ fblack } }
   object{ tele_white texture{ gwhite } }
   object{ tele_navy texture{ gnavy } }
  scale 1.3
  translate <27,0,75>
  }
#end


//////// Underbed Lights ///////////////

#if ( ubedlights_obj =! 0 )
  sphere{ <0,0,0>, 4 
    hollow
    texture{ bozo_ptrn }
    translate bed_pos+<8,7,0> 
  }
  light_source{ 
    <0,0,0> 
    color rgb <.95,0,0> 
    fade_distance 40 fade_power 2
    area_light <0,0,.3>, <0,2,0>, 4, 6 adaptive 1 jitter
    translate bed_pos+<8,7,0>
  }
#end

/////////////////// RC Car //////////////

#if ( car_obj =! 0)
  #include "rccar.inc"
  object{ car scale .9 rotate -120*y translate <31,0,45.5> }
#end
              
///////////// Soccer Ball ///////////////

#if ( soccer_obj =! 0 )
  #include "soccerball.inc"
  union{
    object{ soccerwhite texture{ wvinyl } }
    object{ soccerblack texture{ bvinyl } }
    sphere{ <0,5.25,0>, 5 texture{ bvinyl } }
    scale 9/10.2
    translate <27,0,78>
  }
#end

//////////// Biplane /////////////

#if ( bipe_obj =! 0 )
  #include "biplane.inc"
  union{
    object{ bipe_fuse texture{ blue_plastic }} 
    object{ bipe_wings texture{ yellow_plastic }}
    object{ bipe_prop texture{ red_plastic }}
    object{ bipe_wheels texture{ black_plastic }}
    object{ bipe_strings pigment{ color rgb .3 }}
    scale 1.2
    rotate 20*y
    translate <19,65,53> 
    }
#end

//////////// Alarm Clock ////////////////

#if ( aclock_obj =! 0 )
  #include "alarm_clock.inc"
  union{
    object{ ac_red texture{ clock_letters }}
    object{ ac_dark texture{ black_plastic }}
    object{ ac_glass texture{ clear }}
    object{ ac_case texture{ gwhite }}
    translate <10,0,room_depth/2-9.5>
  }
#end

/////////// Lego Castle /////////////////

#if ( castle_obj =! 0 )
  #include "lego_castle.inc"
  object{
    castle
    scale 1/13
    rotate 20*y
    translate <26,0,16>
  }
#end

/////////// Lego Bin /////////////////

#if ( bin_obj =! 0 )
  #include "lego_bin.inc"
  union{
    object{ lego_bin texture{ silver_plastic }}
    object{ lego_lid texture{ red_plastic } texture{ lego_bin_label rotate 90*x }}
    rotate 60*y
    translate <16,0,10>
  }
#end

/////////// Reading Lamp /////////////////

#if ( rlamp_obj =! 0 )
  #include "reading_lamp.inc"
  union{
    object{ r_lamp_black texture{ black_plastic } }
    object{ r_lamp_fwhite texture{ fwhite } }
    object{ r_lamp_gwhite texture{ gwhite } }
    scale 1.1
    rotate -15*z
    translate <-20,36.75,89.5>
  }
#end

/////////// Laundry Basket ///////////////

#if ( basket_obj =! 0 )
  #include "laundry_basket.inc"
  #include "laundry.inc"
  union{
    object{ laundry_basket texture{ blank } }
    object{ laundry1 texture{ misc_laundry2 } }
    object{ laundry2 texture{ red_plastic } }
    object{ laundry3 texture{ blue_plastic } }
    object{ laundry4 texture{ misc_laundry2 } }
    object{ laundry5 texture{ misc_laundry1 } }
    object{ laundry6 texture{ misc_laundry2 } }
    object{ laundry7 texture{ fwhite } }         //
    rotate 90*y scale <.9,1,.9>
    translate <48,.1,74.5>
  }
#end

/////////// Table Lamp ///////////////

#if ( tlamp_obj =! 0 )
  #include "table_lamp.inc"
  union{
    object{ tlamp_base texture{ brushed_aluminum } }
    object{ tlamp_shade texture{ fwhite } }
    translate <-1,0,room_depth/2-9.5>
  }
#end

/////////// Blinds ///////////////

#if ( blinds_obj =! 0 )
  #include "blinds.inc"
  union{
    object{ blinds_main texture{ g_l_blue } }
    object{ blinds_strings texture{ fblack } }
    scale <-1.4,1.4,1.4>
    rotate <0,90,0>
    translate <-58.5,39.5,60>
  }
#end

/////////// RC Trigger ///////////////

#if ( rctrig_obj =! 0 )
  #include "rctrigger.inc"
  union{
    object{ trigger texture{ black_plastic } }
    object{ trigger_ant texture{ chrome } }
    scale .7
    rotate <0,-70,0>
    translate <46,0,50>
  }
#end

/////////// Rubik ///////////////

#if ( rubik_obj =! 0 )
  #include "rubik.inc"
  object{ unsolved
    scale .4
    rotate <0,-70,0>
    translate <-13,0,21>
  }
#end

/////////// Teddy Bear ///////////////

#if ( teddy_obj =! 0 )
  #include "teddy.inc"
  union{
    object{ teddy_main texture{ dkbrown }}
    object{ teddy_paws texture{ ltbrown }}
    object{ teddy_nose texture{ fblack }}
    translate bed_pos
  }
#end

/////////// Kiddy Hand ///////////////

#if ( khand_obj =! 0 )
  #include "kiddy_hand.inc"
  object{ kiddy_hand texture{ flesh }
    translate bed_pos
  }
#end



