#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "woods.inc"

#declare scales =
texture{
  pigment{
    bozo
    turbulence .7
    octaves 6
    lambda 2
    omega .8
    pigment_map{
     [0.0 color rgb <1.00, 0, 0>]
     [0.02 color rgb <0.10, 0, 0>]
     [0.05 color rgb <0.90, 0, 0>]
     [1.0 color rgb <0.30, 0, 0>]
     }
    scale 3
    }
  finish{
    ambient 30
    diffuse .9
    phong .5
    phong_size 100
    reflection .05
    }
  normal {
    crackle .3
    slope_map {
      [0   <0, 1>]
      [0.2 <1, 1>]
      [0.2 <1,-1>]
      [1   <0,-1>]
    }
  } scale 6
}

#declare nail_tex =
texture{
  pigment{ color rgb <0.91373, 0.88627, 0.40392> }
  finish{ ambient 7 phong 1 phong_size 20 }
}

#declare floor_tex =
texture{
  pigment{ color rgb <0.98431, 0.98824, 0.86275> }
  finish{
    ambient .25
    diffuse .9
    }
  normal{ bumps .3 scale .2 }
}

#declare brushed_aluminum =
texture{
  pigment{ color rgb .8 }
  finish{ ambient .01 diffuse .5 metallic
          specular .3 roughness .5 reflection .5 }
}

#declare chrome =
texture{
  pigment{ color rgb 1.2 }     
  finish{ ambient .01 diffuse .01 metallic 
          specular .9 roughness .01 reflection .7 }
}

#declare blank =
texture{
  pigment{ color rgb <.8,.8,.85> }
  finish{
    ambient .25
    diffuse .5
    }
}

#declare clear =
texture{
  pigment{ color rgbf 1 }
  finish{ 
    #if ( window_obj = 1 ) reflection_blur .4 reflection_samples 30 #end 
    phong .9 
    phong_size 200 
  }
}

#declare nightlight =
texture{
  pigment{ color rgbf <1,1,.72,.3> }
  finish{ ambient 100 }
}

#declare gnavy =
texture{
  pigment{ color rgb <.2,.2,.25> }
  finish{ phong .7 phong_size 100 }
}

#declare gwhite =
texture{
  pigment{ color rgb 1 }
  finish{ phong 1 phong_size 30 }
}

#declare fwhite =
texture{
  pigment{ color rgb 1.1 }
}

#declare fblack =
texture{
  pigment{ color rgb .2 }
  finish{ phong .05 phong_size 10 }
}

#declare wall_tex =
texture{
  pigment{ color rgb <0.81176, 0.8902, 0.79216> }
  finish{ diffuse .6 phong .05 phong_size 5 }
}

#declare ceiling_tex =
texture{
  pigment{ color rgb 1 }
  finish{ diffuse .9 phong .05 phong_size 5 }
}

#declare ltbrown =
texture{
  pigment{ rgb 1.2*<0.63529, 0.52549, 0.41569> }
  finish{ diffuse .5 }
}

#declare walnut =
texture{
  T_Wood12
  finish{ diffuse .6 }
  scale 13 rotate 90*x
  }
  
#declare mblue =
texture{
  pigment{ rgb <0.58039, 0.59608, 0.67843> }
  finish{ diffuse .6 }
}

#declare bwhite =
texture{
  pigment{ rgb .95 }
  finish{ diffuse .9 }
}

#declare white_plastic =
texture{
  pigment{ color rgbt <.995,.995,1,.4> }
  finish{ ambient .4 diffuse .7 phong .1 phong_size 5 }
}

#declare bozo_ptrn =
texture{
  pigment{ 
    bozo
    color_map{
      [0.0 color rgbf 0 ]
      [0.4 color rgbf 0 ]
      [0.7 color rgbf 1 ]
      [1.0 color rgbf 1 ]
      }
  } scale .5
  rotate 50
}

#declare g_l_blue =
texture{
  pigment{ color rgb <0.30196, 0.3098, 0.61569> }
  finish{ ambient 35 diffuse 2 }
}


