// File: DNA.pov
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: DNA Strand From PDB file.

// The data file.
#include "dna.inc"
                 
// Speed rendering if not set already (not included if not set.)
#ifndef (_SPEED_RENDER)
#declare _SPEED_RENDER = 0;
#end

// If not included then set the camera.
// Settings are close to those of rjg-dream.pov
#ifndef (_INCLUDED)
camera {
   location    <0, 10, 55>
   up          y
   right       x / (3/2)
   look_at     <0, 5, 0>
   angle       35.7
   perspective
}
         
#declare _LIGHT_INT  = 1.5;    
#declare _NUM_LIGHTS = 16;
#declare _COUNT      = 0;
#while (_COUNT < _NUM_LIGHTS)

   light_source {
      <100, 70, 0>
      colour rgb < _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS>
      #if (_SPEED_RENDER = 1) 
      shadowless
      #end
      rotate <0, _COUNT * 360 / _NUM_LIGHTS, 0>
   }                            
   
   #declare _COUNT = _COUNT + 1;

#end
        
// background
background { 
   color rgb < 0, 0, 0 > 
}                
#end           

#declare _PROTON_COL_MULT = 15;

#macro ATOM_STUFF(_SIZE,_R,_G,_B)  
union { 
   sphere {
      <0, 0, 0>, _SIZE
      texture {
         pigment {
            color rgbt  <1, 1, 1, .05>
         }      
         finish {
            ambient     .1
            diffuse     1
            #if (_SPEED_RENDER = 0)
            phong       1.0
            phong_size  50.0
            specular    1
            roughness   0.01
            #end
         }     
      }
   }
   disc {
      0, y, _SIZE
      texture {
         pigment {
            #if (_SPEED_RENDER = 0)
            onion
            color_map {
               [ 0.0 rgbt <_R * _PROTON_COL_MULT, _G * _PROTON_COL_MULT, _B * _PROTON_COL_MULT, 0> ]
               [ 0.2 rgbt <_R * _PROTON_COL_MULT, _G * _PROTON_COL_MULT, _B * _PROTON_COL_MULT, .5> ]
               [ 0.9 rgbt <_R * _PROTON_COL_MULT, _G * _PROTON_COL_MULT, _B * _PROTON_COL_MULT, .99> ]
               [ 1.0 rgbt <_R * _PROTON_COL_MULT, _G * _PROTON_COL_MULT, _B * _PROTON_COL_MULT, 1> ]
            }
            #else
            color rgb <_R, _G, _B>
            #end
         }          
         finish {
            ambient     1
            diffuse     1 
         }     
      }
   }
}
#end                          

#declare H_ATOM_OBJECT = object { ATOM_STUFF(0.7,  1.0, 1.0, 0.5) }
#declare C_ATOM_OBJECT = object { ATOM_STUFF(0.9,  0.5, 0.5, 0.5) }
#declare N_ATOM_OBJECT = object { ATOM_STUFF(0.9, 1.0, 0.5, 0.5) }
#declare O_ATOM_OBJECT = object { ATOM_STUFF(0.9,  0.5, 0.5, 1.0) }
#declare P_ATOM_OBJECT = object { ATOM_STUFF(1.0,  0.5, 1.0, 0.5) }

/* The DNA strand */
#declare _DNA = union {
   DNA(H_ATOM_OBJECT, C_ATOM_OBJECT, N_ATOM_OBJECT, O_ATOM_OBJECT, P_ATOM_OBJECT)
   rotate <90, 0, 0>
}

#ifndef (_INCLUDED)                     
object {
   _DNA
   scale       <-1.5, 1.5, 0>
   translate   <0, 10, 0>
}                  
#end
