// GALAXY INCLUDE FILE: SAMPLE GALAXY OBJECTS
// ******************************************
// This scene shows all of the twenty galaxy objects created by
// Galaxy.obj.  They are grouped by row (Stars, Nebulae, Galaxies,
// Comets, and Meteors at the bottom), numbered from left to right
// (starting at 1).  For more information on using these objects,
// see Galaxy.txt
//
// Recommended resolution: 800 x 600 or larger, no anti-aliasing

// NARROW ANGLE CAMERA (TO PREVENT DISTORTION)
   camera {location <0, 0, 0> look_at <0, 0, 1> angle 24}

// COMMON GALAXY OPTIONS 
   #declare galaxy_colour1 = <1.3, 1.3, 1.5>;
   #declare galaxy_colour2 = <1.1, 1, .9>;
   #declare galaxy_colour3 = <1.2, 1.2, 1.05>;
   #declare galaxy_cluster_name = ""
   #declare galaxy_colour_colouration = .9;

// STARFIELD BACKGROUND
   #declare galaxy_seed = 7362511;
   #declare galaxy_bgstars = 8;
   #declare galaxy_bgnebula = false;
   #declare galaxy_nebula_sphere = false;
   #include "GALAXY.BG"    

   #declare galaxy_seed = 7362512;
   #declare star_type = 2;
   #declare star_scale = .75; // smaller numbers for higher resolutions.
   #include "GALAXY.SF"      
   
   #declare galaxy_seed = 7362513;
   #declare star_type = 1;
   #declare star_scale = .75; // smaller numbers for higher resolutions.
   #include "GALAXY.SF"      

   #declare galaxy_seed = 7362514;
   #declare star_type = 1;
   #declare star_scale = .75; // smaller numbers for higher resolutions.
   #include "GALAXY.SF"      

// STAR OBJECTS
/*   #declare galaxy_object_scale = .2;
   #declare C = 0; #while (C < 4)
      #declare galaxy_object_name = concat("Star", str(C + 1, 0, 0))
      #declare galaxy_object_position = <7, -10 + C * 4, 0>;
      #include "GALAXY.OBJ"
   #declare C = C + 1; #end*/

// NEBULAE OBJECTS
/*   #declare galaxy_object_scale = .15;
   #declare C = 0; #while (C < 6)
      #declare galaxy_object_name = concat("Nebula", str(C + 1, 0, 0))
      #declare galaxy_object_position = <3, -10 + C * 4, 0>;
      #include "GALAXY.OBJ"
   #declare C = C + 1; #end*/

// GALAXY OBJECTS
   #declare galaxy_colour1 = <1.3, 1.3, 1.5>;
   #declare galaxy_colour2 = <1.1, 1, .9>;
   #declare galaxy_colour3 = <1.2, 1.2, 1.05>;
   #declare galaxy_seed = 19720224
   #declare galaxy_object_rotate = 24;
   #declare galaxy_object_name = "Galaxy1"
   #declare galaxy_object_position = <0, 0, 0>;
   #include "GALAXY.OBJ"

   #declare galaxy_colour1 = <.5, 0, 0>;
   #declare galaxy_colour2 = <.0, .0, .5>;
   #declare galaxy_colour3 = <.3, .5, .3>;
   #declare galaxy_seed = 19720224;
   #declare galaxy_object_rotate = 24;
   #declare galaxy_object_name = "Galaxy1"
   #declare galaxy_object_position = <0, 0, 0>;
   #include "GALAXY.OBJ"

// COMET OBJECTS
/*   #declare C = 0; #while (C < 3)
      #declare galaxy_object_name = concat("Comet", str(C + 1, 0, 0))
      #declare galaxy_object_position = <-4.5, -11 + C * 4, 0>;
      #include "GALAXY.OBJ"
   #declare C = C + 1; #end*/

// METEOR OBJECTS
/*   #declare C = 0; #while (C < 2)
      #declare galaxy_object_name = concat("Meteor", str(C + 1, 0, 0))
      #declare galaxy_object_position = <-7.5, -11 + C * 4, 0>;
      #include "GALAXY.OBJ"
   #declare C = C + 1; #end*/
