// File: dither.inc
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: Dither pixel data from image.
                
// PIXEL macro to put down an object at 
// a given location.
#macro PIXEL(_X,_Y,_XSCALE,_YSCALE,_OBJECT)
object {  
  _OBJECT
  translate <_X * _XSCALE, _Y * _YSCALE, 0>
}
#end
                    
// BWIMAGE macro to take the pixel information
// and to put the objects at the black pixel locations.                     
#macro BWIMAGE(_ROW,_XSCALE,_YSCALE,_OBJECT)
#if (_ROW = 0)
PIXEL(     0,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,      0, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,      0, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 1)
PIXEL(     6,      1, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,      1, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,      1, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,      1, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,      1, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,      1, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 2)
PIXEL(    24,      2, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,      2, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,      2, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,      2, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,      2, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 3)
PIXEL(    13,      3, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,      3, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,      3, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,      3, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 4)
PIXEL(     2,      4, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,      4, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,      4, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,      4, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,      4, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 5)
PIXEL(     9,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,      5, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,      5, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 6)
PIXEL(     6,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,      6, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,      6, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 7)
PIXEL(    32,      7, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,      7, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,      7, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    49,      7, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,      7, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 8)
PIXEL(     2,      8, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,      8, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,      8, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,      8, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,      8, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 9)
PIXEL(    15,      9, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,      9, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,      9, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,      9, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,      9, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,      9, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 10)
PIXEL(     6,     10, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     10, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,     10, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     10, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     10, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     10, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 11)
PIXEL(     9,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     11, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     11, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 12)
PIXEL(     1,     12, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,     12, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     12, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     12, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 13)
PIXEL(    12,     13, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,     13, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     13, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     13, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     13, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 14)
PIXEL(     5,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     14, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     14, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 15)
PIXEL(    36,     15, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,     15, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     15, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,     15, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 16)
PIXEL(    47,     16, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,     16, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,     16, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     16, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 17)
PIXEL(     2,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     8,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     17, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     17, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 18)
PIXEL(    58,     18, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,     18, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     18, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     18, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 19)
PIXEL(    37,     19, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,     19, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     19, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     19, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     19, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,     19, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 20)
PIXEL(     5,     20, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     20, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     20, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 21)
PIXEL(     1,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     21, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     21, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 22)
PIXEL(     8,     22, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     22, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    19,     22, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,     22, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     22, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 23)
PIXEL(    30,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,     23, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,     23, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 24)
PIXEL(    34,     24, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,     24, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,     24, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     24, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     24, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     24, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 25)
PIXEL(     4,     25, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,     25, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,     25, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,     25, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     25, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    88,     25, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 26)
PIXEL(     1,     26, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     26, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     26, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     26, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,     26, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 27)
PIXEL(     7,     27, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,     27, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     27, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     27, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,     27, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 28)
PIXEL(    18,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     28, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     28, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 29)
PIXEL(     2,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     29, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,     29, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 30)
PIXEL(     9,     30, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,     30, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,     30, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     30, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,     30, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,     30, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 31)
PIXEL(    47,     31, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     31, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,     31, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 32)
PIXEL(     5,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     32, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    88,     32, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 33)
PIXEL(    28,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,     33, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,     33, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 34)
PIXEL(     2,     34, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     34, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     34, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    31,     34, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     34, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,     34, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 35)
PIXEL(    47,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     35, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,     35, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 36)
PIXEL(     8,     36, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,     36, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,     36, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     36, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     36, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 37)
PIXEL(     5,     37, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    14,     37, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     37, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     37, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     37, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,     37, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 38)
PIXEL(    29,     38, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     38, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,     38, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     38, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 39)
PIXEL(     1,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,     39, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     39, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 40)
PIXEL(    32,     40, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     40, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,     40, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    46,     40, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,     40, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,     40, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 41)
PIXEL(     6,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     41, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,     41, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 42)
PIXEL(     2,     42, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     42, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,     42, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     42, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 43)
PIXEL(    21,     43, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,     43, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     43, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,     43, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     43, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     43, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 44)
PIXEL(     9,     44, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     44, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,     44, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,     44, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,     44, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     44, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 45)
PIXEL(    13,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     45, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     45, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 46)
PIXEL(     4,     46, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,     46, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     46, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 47)
PIXEL(     0,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     47, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     47, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 48)
PIXEL(     7,     48, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,     48, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,     48, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     48, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,     48, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     48, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 49)
PIXEL(    11,     49, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     49, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     49, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     49, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 50)
PIXEL(    17,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     50, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     50, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 51)
PIXEL(     3,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    14,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     51, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     51, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 52)
PIXEL(     0,     52, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     52, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 53)
PIXEL(     6,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,     53, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,     53, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 54)
PIXEL(    15,     54, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,     54, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     54, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,     54, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,     54, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     54, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 55)
PIXEL(     1,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,     55, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,     55, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 56)
PIXEL(    11,     56, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,     56, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,     56, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,     56, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     56, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 57)
PIXEL(     4,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     57, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,     57, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 58)
PIXEL(    34,     58, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,     58, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     58, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,     58, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 59)
PIXEL(     7,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     59, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     59, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 60)
PIXEL(     0,     60, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     60, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     60, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     60, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,     60, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,     60, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 61)
PIXEL(    18,     61, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     61, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     61, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,     61, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 62)
PIXEL(     3,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    46,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     62, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     62, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 63)
PIXEL(     7,     63, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,     63, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     63, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,     63, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     63, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 64)
PIXEL(    11,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     64, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,     64, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 65)
PIXEL(    22,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,     65, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,     65, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 66)
PIXEL(     3,     66, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,     66, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,     66, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 67)
PIXEL(     7,     67, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,     67, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,     67, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     67, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 68)
PIXEL(    11,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,     68, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     68, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 69)
PIXEL(    25,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     69, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     69, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 70)
PIXEL(    22,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,     70, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     70, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 71)
PIXEL(     3,     71, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     7,     71, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     71, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     71, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 72)
PIXEL(    18,     72, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     72, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     72, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     72, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,     72, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 73)
PIXEL(    10,     73, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,     73, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,     73, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     73, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,     73, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     73, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 74)
PIXEL(    22,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,     74, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,     74, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 75)
PIXEL(     3,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     75, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,     75, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 76)
PIXEL(     7,     76, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,     76, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     76, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,     76, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     76, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 77)
PIXEL(    19,     77, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    42,     77, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     77, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     77, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     77, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 78)
PIXEL(    27,     78, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,     78, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,     78, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,     78, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 79)
PIXEL(     3,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     79, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,     79, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 80)
PIXEL(     7,     80, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     80, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,     80, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,     80, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     80, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 81)
PIXEL(    19,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    42,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     81, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     81, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 82)
PIXEL(    78,     82, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,     82, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 83)
PIXEL(     3,     83, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     83, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     83, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,     83, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     83, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 84)
PIXEL(     7,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,     84, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,     84, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 85)
PIXEL(    19,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    49,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     85, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     85, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 86)
PIXEL(    42,     86, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     86, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     86, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 87)
PIXEL(     3,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,     87, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,     87, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 88)
PIXEL(     7,     88, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     88, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,     88, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     88, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,     88, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,     88, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 89)
PIXEL(    21,     89, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,     89, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     89, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 90)
PIXEL(    17,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     90, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,     90, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 91)
PIXEL(     8,     91, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,     91, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,     91, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,     91, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,     91, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     91, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 92)
PIXEL(     3,     92, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,     92, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,     92, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,     92, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,     92, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 93)
PIXEL(    66,     93, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     93, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     93, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 94)
PIXEL(    19,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,     94, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,     94, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 95)
PIXEL(     4,     95, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     8,     95, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,     95, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,     95, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,     95, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 96)
PIXEL(    12,     96, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,     96, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,     96, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,     96, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 97)
PIXEL(    22,     97, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,     97, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,     97, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,     97, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,     97, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 98)
PIXEL(    30,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,     98, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,     98, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 99)
PIXEL(     1,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    14,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,     99, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,     99, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 100)
PIXEL(     5,    100, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    100, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    100, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 101)
PIXEL(    22,    101, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    101, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,    101, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    101, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,    101, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 102)
PIXEL(    10,    102, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    102, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    102, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    102, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    102, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 103)
PIXEL(     2,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    14,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,    103, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    103, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 104)
PIXEL(    57,    104, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    104, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    104, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 105)
PIXEL(     6,    105, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    105, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,    105, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 106)
PIXEL(    22,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,    106, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    106, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 107)
PIXEL(     1,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,    107, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    107, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 108)
PIXEL(    12,    108, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    108, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    108, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,    108, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    108, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,    108, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 109)
PIXEL(     4,    109, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    19,    109, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    109, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    109, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    109, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    109, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 110)
PIXEL(    31,    110, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    110, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    110, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 111)
PIXEL(     0,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    111, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,    111, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 112)
PIXEL(     7,    112, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,    112, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    112, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,    112, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    112, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    112, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 113)
PIXEL(    48,    113, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    113, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    113, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    113, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 114)
PIXEL(     3,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    31,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    114, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    114, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 115)
PIXEL(    10,    115, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,    115, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    115, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,    115, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    115, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 116)
PIXEL(     0,    116, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     6,    116, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,    116, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    116, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,    116, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    116, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 117)
PIXEL(    14,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    117, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    117, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 118)
PIXEL(    26,    118, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    46,    118, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,    118, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 119)
PIXEL(     2,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    119, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    119, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 120)
PIXEL(     6,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,    120, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    120, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 121)
PIXEL(    14,    121, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    121, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    121, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    121, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 122)
PIXEL(    26,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    122, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,    122, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 123)
PIXEL(     2,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    123, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    123, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 124)
PIXEL(     6,    124, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,    124, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    124, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    124, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    124, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 125)
PIXEL(    33,    125, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    125, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    125, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    125, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    125, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 126)
PIXEL(    13,    126, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    126, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,    126, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    51,    126, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,    126, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,    126, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 127)
PIXEL(     7,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    127, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,    127, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 128)
PIXEL(     1,    128, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    128, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,    128, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    128, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    128, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 129)
PIXEL(    16,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    129, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    129, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 130)
PIXEL(     3,    130, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    130, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    130, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    130, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 131)
PIXEL(    19,    131, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    131, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    131, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    131, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,    131, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 132)
PIXEL(    10,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,    132, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    132, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 133)
PIXEL(     6,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,    133, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    133, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 134)
PIXEL(    16,    134, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    134, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    134, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,    134, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    134, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 135)
PIXEL(     3,    135, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    135, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    135, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    135, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    135, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 136)
PIXEL(    25,    136, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    136, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    136, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    136, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 137)
PIXEL(     9,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    19,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    137, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    137, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 138)
PIXEL(     0,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     5,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    138, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    138, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 139)
PIXEL(    44,    139, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,    139, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    139, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 140)
PIXEL(    16,    140, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,    140, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,    140, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,    140, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    140, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    140, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 141)
PIXEL(     1,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    141, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    141, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 142)
PIXEL(     5,    142, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,    142, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,    142, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    142, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    142, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,    142, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 143)
PIXEL(    17,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    143, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,    143, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 144)
PIXEL(    21,    144, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    144, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,    144, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    144, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    144, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 145)
PIXEL(     1,    145, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,    145, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,    145, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    145, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    145, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 146)
PIXEL(     5,    146, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,    146, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    146, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    146, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    146, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    146, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 147)
PIXEL(    13,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    42,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    147, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    147, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 148)
PIXEL(    21,    148, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    148, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    148, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 149)
PIXEL(     6,    149, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,    149, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    149, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    149, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 150)
PIXEL(     1,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    46,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    150, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    150, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 151)
PIXEL(    14,    151, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    42,    151, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    151, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 152)
PIXEL(    18,    152, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    152, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,    152, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    152, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    152, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    152, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 153)
PIXEL(     2,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     6,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,    153, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    153, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 154)
PIXEL(    10,    154, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    154, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    154, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    154, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    88,    154, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 155)
PIXEL(    14,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    19,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    42,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    155, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,    155, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 156)
PIXEL(    34,    156, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    156, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    156, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 157)
PIXEL(     6,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    157, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    157, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 158)
PIXEL(     2,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    158, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    88,    158, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 159)
PIXEL(    16,    159, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    159, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    49,    159, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,    159, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 160)
PIXEL(    20,    160, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    34,    160, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,    160, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    73,    160, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    160, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    160, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 161)
PIXEL(     6,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    38,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,    161, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    84,    161, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 162)
PIXEL(    30,    162, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    162, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    58,    162, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    162, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 163)
PIXEL(     2,    163, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     9,    163, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    24,    163, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    163, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    88,    163, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,    163, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 164)
PIXEL(    17,    164, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,    164, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    164, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,    164, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    164, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 165)
PIXEL(    13,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    76,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,    165, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    165, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 166)
PIXEL(     5,    166, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    166, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    166, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    46,    166, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    166, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    99,    166, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 167)
PIXEL(     9,    167, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    22,    167, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,    167, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    92,    167, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 168)
PIXEL(     1,    168, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    16,    168, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    30,    168, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    168, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    168, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 169)
PIXEL(    26,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    169, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    95,    169, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 170)
PIXEL(     4,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    80,    170, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    170, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 171)
PIXEL(     8,    171, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    19,    171, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    49,    171, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    171, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    98,    171, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 172)
PIXEL(    23,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    54,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    62,    172, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    172, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 173)
PIXEL(    15,    173, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,    173, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    173, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 174)
PIXEL(     1,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(     5,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    174, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    174, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 175)
PIXEL(    11,    175, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,    175, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    49,    175, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    175, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,    175, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    175, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 176)
PIXEL(     8,    176, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    32,    176, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    41,    176, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    176, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 177)
PIXEL(    15,    177, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,    177, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    177, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    177, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,    177, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    177, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 178)
PIXEL(     0,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    23,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    45,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    59,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    178, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    178, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 179)
PIXEL(     4,    179, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,    179, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    179, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    37,    179, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    179, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    179, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 180)
PIXEL(     8,    180, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    12,    180, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    180, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    180, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    69,    180, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 181)
PIXEL(    20,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    25,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    40,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    72,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    181, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    91,    181, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 182)
PIXEL(     0,    182, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    29,    182, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    182, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    55,    182, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    182, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 183)
PIXEL(     4,    183, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,    183, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    33,    183, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    183, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    87,    183, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    183, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 184)
PIXEL(    11,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    21,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    26,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    36,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    184, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    184, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 185)
PIXEL(     7,    185, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    185, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    65,    185, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    68,    185, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    185, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 186)
PIXEL(    43,    186, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    50,    186, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    186, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    83,    186, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    186, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 187)
PIXEL(    22,    187, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    28,    187, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,    187, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    187, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 188)
PIXEL(     2,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    14,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    31,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    61,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    86,    188, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    188, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 189)
PIXEL(     5,    189, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    47,    189, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    189, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    79,    189, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 190)
PIXEL(    24,    190, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    190, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    64,    190, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    190, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    96,    190, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 191)
PIXEL(    39,    191, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,    191, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    75,    191, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    82,    191, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    191, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 192)
PIXEL(     7,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    17,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    27,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    31,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    53,    192, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    57,    192, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 193)
PIXEL(     0,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    10,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    13,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    20,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    193, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    93,    193, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 194)
PIXEL(     3,    194, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    43,    194, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    71,    194, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    78,    194, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 195)
PIXEL(    23,    195, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    67,    195, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    89,    195, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    97,    195, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 196)
PIXEL(    27,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    31,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    35,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    39,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    48,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    52,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    63,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    74,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    81,    196, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    94,    196, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 197)
PIXEL(     6,    197, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    11,    197, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    15,    197, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    44,    197, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    56,    197, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    85,    197, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 198)
PIXEL(     0,    198, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    18,    198, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    60,    198, _XSCALE, _YSCALE, _OBJECT)
#end
#if (_ROW = 199)
PIXEL(    21,    199, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    66,    199, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    70,    199, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    77,    199, _XSCALE, _YSCALE, _OBJECT)
PIXEL(    90,    199, _XSCALE, _YSCALE, _OBJECT)
#end
#end

