// File: dreamer.pov
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: The kid in the pjs
//
//       Most of this file was created from Hamapatch but edited for textures
//       And other things.

// Speed rendering if not set already (not included if not set.)
#ifndef (_SPEED_RENDER)
#declare _SPEED_RENDER = 0;
#end                                                            

// If not included then set the camera.
// Settings are close to those of rjg-dream.pov
#ifndef (_INCLUDED)
camera {
   location    <0, 10, 55>
   up          y
   right       x / (3/2)
   look_at     <0, 5, 0>
   angle       35.7
   perspective
}
                          
#declare _LIGHT_INT  = 1.5;
#declare _NUM_LIGHTS = 16;
#declare _COUNT      = 0;
#while (_COUNT < _NUM_LIGHTS)

   light_source {
      <100, 70, 0>
      colour rgb < _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS>
      #if (_SPEED_RENDER = 1) 
      shadowless
      #end
      rotate <0, _COUNT * 360 / _NUM_LIGHTS, 0>
   }                            
   
   #declare _COUNT = _COUNT + 1;

#end

global_settings{
	adc_bailout       0.0040
	ambient_light     rgb <255/255,255/255,255/255>
	assumed_gamma     2.200
	hf_gray_16        0
	irid_wavelength   rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level   10
	number_of_waves   10
	radiosity {
		brightness        3.300
		count             100
		distance_maximum  0.000
		error_bound       0.400
		gray_threshold    0.500
		low_error_factor  0.800
		minimum_reuse     0.0150
		nearest_count     6
		recursion_limit   1
	}
}               
#end

//pj
#declare _PJ = object {
   union {
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-1.117, 0.000, -0.958> <-1.042, -0.000, -1.429> <-0.394, -0.000, -1.350> <0.076, -0.000, -1.275> 
   		<-1.361, -0.076, -0.997> <-1.286, -0.076, -1.467> <-0.376, -0.090, -1.463> <0.094, -0.090, -1.388> 
   		<-0.337, -0.101, -0.838> <-0.313, -0.101, -0.988> <-0.313, -0.101, -0.988> <0.022, -0.101, -0.935> 
   		<-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.076, -0.000, -1.275> <0.346, -0.000, -1.233> <0.535, -0.000, -0.973> <0.492, 0.000, -0.703> 
   		<0.094, -0.090, -1.388> <0.364, -0.090, -1.346> <0.651, -0.097, -0.955> <0.608, -0.097, -0.686> 
   		<0.022, -0.101, -0.935> <0.174, -0.101, -0.911> <0.174, -0.101, -0.911> <0.150, -0.101, -0.761> 
   		<-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.492, 0.000, -0.703> <0.449, 0.000, -0.434> <0.189, 0.000, -0.245> <-0.080, 0.000, -0.288> 
   		<0.608, -0.097, -0.686> <0.566, -0.097, -0.416> <0.166, -0.079, -0.099> <-0.103, -0.079, -0.142> 
   		<0.150, -0.101, -0.761> <0.126, -0.101, -0.609> <0.126, -0.101, -0.609> <-0.026, -0.101, -0.633> 
   		<-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.080, 0.000, -0.288> <-0.551, 0.000, -0.362> <-1.191, 0.000, -0.487> <-1.117, 0.000, -0.958> 
   		<-0.103, -0.079, -0.142> <-0.574, -0.079, -0.216> <-1.435, -0.076, -0.526> <-1.361, -0.076, -0.997> 
   		<-0.026, -0.101, -0.633> <-0.361, -0.101, -0.686> <-0.361, -0.101, -0.686> <-0.337, -0.101, -0.838> 
   		<-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> <-0.001, -0.101, -0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-1.119, 0.000, 0.958> <-1.044, -0.000, 1.429> <-0.396, -0.000, 1.350> <0.074, -0.000, 1.275> 
   		<-1.373, -0.087, 0.944> <-1.299, -0.087, 1.415> <-0.378, -0.090, 1.463> <0.092, -0.090, 1.388> 
   		<-0.339, -0.101, 0.838> <-0.315, -0.101, 0.988> <-0.315, -0.101, 0.988> <0.020, -0.101, 0.935> 
   		<-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.074, -0.000, 1.275> <0.344, -0.000, 1.233> <0.533, -0.000, 0.973> <0.490, 0.000, 0.703> 
   		<0.092, -0.090, 1.388> <0.362, -0.090, 1.346> <0.444, -0.124, 0.988> <0.401, -0.124, 0.718> 
   		<0.020, -0.101, 0.935> <0.172, -0.101, 0.911> <0.172, -0.101, 0.911> <0.148, -0.101, 0.761> 
   		<-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.490, 0.000, 0.703> <0.447, 0.000, 0.434> <0.187, 0.000, 0.245> <-0.082, 0.000, 0.288> 
   		<0.401, -0.124, 0.718> <0.358, -0.124, 0.449> <0.164, -0.079, 0.099> <-0.105, -0.079, 0.142> 
   		<0.148, -0.101, 0.761> <0.124, -0.101, 0.609> <0.124, -0.101, 0.609> <-0.027, -0.101, 0.633> 
   		<-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.082, 0.000, 0.288> <-0.553, 0.000, 0.362> <-1.193, 0.000, 0.487> <-1.119, 0.000, 0.958> 
   		<-0.105, -0.079, 0.142> <-0.576, -0.079, 0.216> <-1.448, -0.087, 0.474> <-1.373, -0.087, 0.944> 
   		<-0.027, -0.101, 0.633> <-0.363, -0.101, 0.686> <-0.363, -0.101, 0.686> <-0.339, -0.101, 0.838> 
   		<-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> <-0.003, -0.101, 0.785> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.815, 1.869, 0.901> <0.999, 1.869, 0.684> <1.130, 1.869, 0.291> <1.130, 1.869, 0.007> 
   		<0.704, 1.852, 0.750> <0.889, 1.852, 0.534> <1.130, 1.869, 0.528> <1.130, 1.869, 0.244> 
   		<0.512, 2.316, 0.450> <0.698, 2.238, 0.325> <0.698, 2.238, 0.325> <0.697, 2.052, 0.297> 
   		<0.512, 2.131, 0.421> <0.512, 2.131, 0.421> <0.512, 2.131, 0.421> <0.512, 2.131, 0.421> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<1.130, 1.869, 0.007> <1.130, 1.869, -0.278> <0.999, 1.869, -0.671> <0.815, 1.869, -0.887> 
   		<1.131, 1.869, -0.232> <1.131, 1.869, -0.516> <0.889, 1.852, -0.524> <0.705, 1.852, -0.740> 
   		<0.699, 2.052, -0.293> <0.781, 1.890, -0.393> <0.781, 1.890, -0.393> <0.596, 1.969, -0.521> 
   		<0.514, 2.131, -0.421> <0.514, 2.131, -0.421> <0.514, 2.131, -0.421> <0.514, 2.131, -0.421> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.707, 1.869, -0.887> <-0.891, 1.869, -0.671> <-1.022, 1.869, -0.278> <-1.022, 1.869, 0.007> 
   		<-0.616, 1.835, -0.795> <-0.800, 1.835, -0.578> <-1.022, 1.869, -0.529> <-1.022, 1.869, -0.244> 
   		<-0.571, 1.800, -0.695> <-0.745, 1.748, -0.521> <-0.745, 1.748, -0.521> <-0.617, 1.991, -0.399> 
   		<-0.444, 2.044, -0.573> <-0.444, 2.044, -0.573> <-0.444, 2.044, -0.573> <-0.444, 2.044, -0.573> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-1.022, 1.869, 0.007> <-1.022, 1.869, 0.291> <-0.891, 1.869, 0.684> <-0.707, 1.869, 0.901> 
   		<-1.023, 1.869, 0.255> <-1.023, 1.869, 0.539> <-0.800, 1.835, 0.588> <-0.616, 1.835, 0.805> 
   		<-0.619, 1.991, 0.403> <-0.631, 2.127, 0.406> <-0.631, 2.127, 0.406> <-0.458, 2.180, 0.576> 
   		<-0.446, 2.044, 0.573> <-0.446, 2.044, 0.573> <-0.446, 2.044, 0.573> <-0.446, 2.044, 0.573> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.175, 2.614, -1.453> <-0.172, 2.635, -1.557> <-0.039, 2.673, -1.573> <0.068, 2.672, -1.573> 
   		<-0.150, 2.524, -1.472> <-0.146, 2.545, -1.577> <-0.040, 2.573, -1.576> <0.066, 2.572, -1.576> 
   		<-0.048, 2.394, -1.391> <-0.042, 2.478, -1.445> <-0.042, 2.478, -1.445> <0.054, 2.477, -1.445> 
   		<0.048, 2.393, -1.391> <0.048, 2.393, -1.391> <0.048, 2.393, -1.391> <0.048, 2.393, -1.391> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 2.672, -1.573> <0.165, 2.671, -1.573> <0.284, 2.629, -1.548> <0.281, 2.609, -1.453> 
   		<0.066, 2.572, -1.576> <0.164, 2.571, -1.576> <0.251, 2.540, -1.569> <0.248, 2.520, -1.473> 
   		<0.054, 2.477, -1.445> <0.151, 2.476, -1.445> <0.151, 2.476, -1.445> <0.145, 2.392, -1.391> 
   		<0.048, 2.393, -1.391> <0.048, 2.393, -1.391> <0.048, 2.393, -1.391> <0.048, 2.393, -1.391> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.852, 3.415, 0.189> <-0.991, 3.420, 0.204> <-1.093, 3.322, 0.231> <-1.125, 3.191, 0.265> 
   		<-0.893, 3.361, 0.104> <-1.032, 3.365, 0.119> <-1.127, 3.286, 0.142> <-1.159, 3.154, 0.176> 
   		<-0.922, 3.235, -0.046> <-0.975, 3.253, 0.039> <-0.975, 3.253, 0.039> <-1.000, 3.150, 0.066> 
   		<-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-1.125, 3.191, 0.265> <-1.150, 3.088, 0.292> <-1.070, 2.968, 0.318> <-0.961, 2.965, 0.306> 
   		<-1.159, 3.154, 0.176> <-1.184, 3.052, 0.202> <-1.129, 2.956, 0.226> <-1.021, 2.952, 0.214> 
   		<-1.000, 3.150, 0.066> <-1.025, 3.046, 0.093> <-1.025, 3.046, 0.093> <-0.972, 3.028, 0.007> 
   		<-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> <-0.947, 3.132, -0.020> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.076, -0.000, -1.275> <0.346, -0.000, -1.233> <0.535, -0.000, -0.973> <0.492, 0.000, -0.703> 
   		<0.100, 0.060, -1.425> <0.369, 0.060, -1.382> <0.658, -0.059, -0.952> <0.615, -0.059, -0.682> 
   		<0.213, 0.331, -1.177> <0.340, 0.313, -1.157> <0.502, 0.329, -0.831> <0.477, 0.329, -0.704> 
   		<0.196, 0.439, -1.070> <0.323, 0.420, -1.050> <0.453, 0.495, -0.839> <0.429, 0.495, -0.712> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.492, 0.000, -0.703> <0.449, 0.000, -0.434> <0.189, 0.000, -0.245> <-0.080, 0.000, -0.288> 
   		<0.615, -0.059, -0.682> <0.572, -0.059, -0.412> <0.173, 0.045, -0.142> <-0.096, 0.045, -0.185> 
   		<0.477, 0.329, -0.704> <0.451, 0.329, -0.565> <0.194, 0.273, -0.303> <0.056, 0.293, -0.325> 
   		<0.429, 0.495, -0.712> <0.402, 0.495, -0.573> <0.208, 0.418, -0.390> <0.070, 0.439, -0.413> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.080, 0.000, -0.288> <-0.551, 0.000, -0.362> <-1.191, 0.000, -0.487> <-1.117, 0.000, -0.958> 
   		<-0.104, -0.042, -0.137> <-0.575, -0.042, -0.211> <-1.521, -0.063, -0.540> <-1.447, -0.063, -1.010> 
   		<-0.211, 0.340, -0.357> <-0.229, 0.424, -0.432> <-0.980, 0.885, -0.836> <-0.958, 0.891, -0.933> 
   		<-0.235, 0.452, -0.457> <-0.253, 0.536, -0.532> <-0.227, 0.582, -0.717> <-0.205, 0.588, -0.814> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.138, 0.459, -1.139> <-0.169, 0.521, -1.057> <-0.188, 0.593, -0.888> <-0.205, 0.588, -0.814> 
   		<-0.067, 0.316, -1.329> <-0.098, 0.377, -1.247> <-0.941, 0.896, -1.007> <-0.958, 0.891, -0.933> 
   		<0.097, -0.055, -1.406> <-0.374, -0.055, -1.480> <-1.372, -0.063, -1.481> <-1.447, -0.063, -1.010> 
   		<0.076, -0.000, -1.275> <-0.394, -0.000, -1.350> <-1.042, -0.000, -1.429> <-1.117, 0.000, -0.958> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.138, 0.459, -1.139> <-0.169, 0.521, -1.057> <-0.188, 0.593, -0.888> <-0.205, 0.588, -0.814> 
   		<-0.067, 0.316, -1.329> <-0.098, 0.377, -1.247> <-0.160, 0.593, -1.035> <-0.177, 0.588, -0.961> 
   		<0.097, -0.055, -1.406> <0.121, 0.006, -1.555> <0.067, 0.353, -1.201> <0.050, 0.460, -1.094> 
   		<0.076, -0.000, -1.275> <0.100, 0.060, -1.425> <0.213, 0.331, -1.177> <0.196, 0.439, -1.070> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.429, 0.495, -0.712> <0.453, 0.495, -0.839> <0.323, 0.420, -1.050> <0.196, 0.439, -1.070> 
   		<0.558, 0.369, -0.691> <0.582, 0.369, -0.818> <0.344, 0.346, -1.184> <0.218, 0.365, -1.204> 
   		<0.689, 0.218, -0.672> <0.751, 0.194, -1.048> <0.572, 0.107, -1.218> <0.220, 0.243, -1.274> 
   		<0.812, 0.263, -0.653> <0.873, 0.239, -1.028> <0.602, 0.194, -1.407> <0.250, 0.330, -1.463> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.196, 0.439, -1.070> <0.050, 0.460, -1.094> <-0.177, 0.588, -0.961> <-0.205, 0.588, -0.814> 
   		<0.213, 0.331, -1.177> <0.067, 0.353, -1.201> <-0.930, 0.891, -1.080> <-0.958, 0.891, -0.933> 
   		<0.100, 0.060, -1.425> <-0.371, 0.060, -1.499> <-1.372, -0.063, -1.481> <-1.447, -0.063, -1.010> 
   		<0.076, -0.000, -1.275> <-0.394, -0.000, -1.350> <-1.042, -0.000, -1.429> <-1.117, 0.000, -0.958> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.205, 0.588, -0.814> <-0.234, 0.588, -0.664> <-0.079, 0.461, -0.437> <0.070, 0.439, -0.413> 
   		<-0.958, 0.891, -0.933> <-0.987, 0.891, -0.783> <-0.093, 0.315, -0.349> <0.056, 0.293, -0.325> 
   		<-1.447, -0.063, -1.010> <-1.521, -0.063, -0.540> <-0.567, 0.045, -0.259> <-0.096, 0.045, -0.185> 
   		<-1.117, 0.000, -0.958> <-1.191, 0.000, -0.487> <-0.551, 0.000, -0.362> <-0.080, 0.000, -0.288> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.205, 0.588, -0.814> <-0.234, 0.588, -0.664> <-0.079, 0.461, -0.437> <0.070, 0.439, -0.413> 
   		<-0.227, 0.582, -0.717> <-0.256, 0.582, -0.567> <-0.093, 0.315, -0.349> <0.056, 0.293, -0.325> 
   		<-0.253, 0.536, -0.532> <-0.229, 0.424, -0.432> <-0.120, 0.003, -0.034> <-0.096, 0.045, -0.185> 
   		<-0.235, 0.452, -0.457> <-0.211, 0.340, -0.357> <-0.104, -0.042, -0.137> <-0.080, 0.000, -0.288> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.070, 0.439, -0.413> <0.208, 0.418, -0.390> <0.402, 0.495, -0.573> <0.429, 0.495, -0.712> 
   		<0.053, 0.361, -0.307> <0.191, 0.341, -0.285> <0.531, 0.369, -0.553> <0.558, 0.369, -0.691> 
   		<0.040, 0.335, -0.185> <0.397, 0.197, -0.128> <0.627, 0.242, -0.291> <0.689, 0.218, -0.672> 
   		<0.020, 0.420, -0.057> <0.377, 0.282, -0.001> <0.750, 0.287, -0.271> <0.812, 0.263, -0.653> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.610, 0.813, -0.878> <-0.539, 0.785, -1.314> <-0.159, 0.488, -1.528> <0.250, 0.330, -1.463> 
   		<-0.588, 0.676, -0.900> <-0.517, 0.648, -1.336> <-0.189, 0.401, -1.339> <0.220, 0.243, -1.274> 
   		<-0.355, 0.651, -0.837> <-0.326, 0.651, -0.984> <0.071, 0.386, -1.228> <0.218, 0.365, -1.204> 
   		<-0.205, 0.588, -0.814> <-0.177, 0.588, -0.961> <0.050, 0.460, -1.094> <0.196, 0.439, -1.070> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.250, 0.330, -1.463> <0.602, 0.194, -1.407> <0.873, 0.239, -1.028> <0.812, 0.263, -0.653> 
   		<0.295, 0.462, -1.749> <0.647, 0.326, -1.693> <1.125, 0.332, -0.989> <1.063, 0.356, -0.613> 
   		<0.263, 1.547, -1.198> <0.503, 1.569, -1.160> <0.643, 1.570, -0.729> <0.603, 1.578, -0.488> 
   		<0.167, 2.034, -0.942> <0.407, 2.056, -0.904> <0.554, 2.123, -0.662> <0.514, 2.131, -0.421> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.020, 0.420, -0.057> <-0.374, 0.572, -0.120> <-0.679, 0.840, -0.457> <-0.610, 0.813, -0.878> 
   		<0.040, 0.335, -0.185> <-0.354, 0.487, -0.247> <-0.657, 0.703, -0.480> <-0.588, 0.676, -0.900> 
   		<0.053, 0.361, -0.307> <-0.096, 0.383, -0.331> <-0.383, 0.651, -0.687> <-0.355, 0.651, -0.837> 
   		<0.070, 0.439, -0.413> <-0.079, 0.461, -0.437> <-0.234, 0.588, -0.664> <-0.205, 0.588, -0.814> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.444, 2.044, -0.573> <-0.398, 2.035, -0.844> <-0.104, 2.009, -0.985> <0.167, 2.034, -0.942> 
   		<-0.504, 1.684, -0.685> <-0.459, 1.675, -0.957> <-0.008, 1.523, -1.241> <0.263, 1.547, -1.198> 
   		<-0.672, 1.187, -0.816> <-0.600, 1.159, -1.252> <-0.113, 0.620, -1.814> <0.295, 0.462, -1.749> 
   		<-0.610, 0.813, -0.878> <-0.539, 0.785, -1.314> <-0.159, 0.488, -1.528> <0.250, 0.330, -1.463> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.167, 2.034, -0.942> <0.407, 2.056, -0.904> <0.554, 2.123, -0.662> <0.514, 2.131, -0.421> 
   		<0.139, 1.841, -1.101> <0.380, 1.863, -1.063> <0.637, 1.961, -0.762> <0.596, 1.969, -0.521> 
   		<0.082, 1.833, -1.155> <0.336, 1.833, -1.155> <0.540, 1.852, -0.934> <0.705, 1.852, -0.740> 
   		<0.054, 1.869, -1.258> <0.308, 1.869, -1.258> <0.650, 1.869, -1.081> <0.815, 1.869, -0.887> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.514, 2.131, -0.421> <0.477, 2.138, -0.202> <0.248, 2.081, -0.084> <0.030, 2.061, -0.119> 
   		<0.603, 1.578, -0.488> <0.567, 1.585, -0.269> <0.257, 1.589, -0.102> <0.039, 1.569, -0.137> 
   		<1.063, 0.356, -0.613> <1.001, 0.380, -0.231> <0.348, 0.404, 0.182> <-0.009, 0.542, 0.125> 
   		<0.812, 0.263, -0.653> <0.750, 0.287, -0.271> <0.377, 0.282, -0.001> <0.020, 0.420, -0.057> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.030, 2.061, -0.119> <-0.219, 2.039, -0.158> <-0.485, 2.052, -0.323> <-0.444, 2.044, -0.573> 
   		<0.029, 2.105, -0.117> <-0.220, 2.083, -0.157> <-0.659, 2.000, -0.149> <-0.617, 1.991, -0.399> 
   		<-0.009, 1.986, -0.044> <-0.315, 1.986, -0.044> <-0.720, 1.817, -0.246> <-1.022, 1.869, -0.244> 
   		<-0.009, 1.986, 0.000> <-0.315, 1.986, 0.000> <-0.721, 1.817, 0.005> <-1.022, 1.869, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.030, 2.061, -0.119> <-0.219, 2.039, -0.158> <-0.485, 2.052, -0.323> <-0.444, 2.044, -0.573> 
   		<0.039, 1.569, -0.137> <-0.210, 1.546, -0.176> <-0.546, 1.692, -0.435> <-0.504, 1.684, -0.685> 
   		<-0.009, 0.542, 0.125> <-0.403, 0.695, 0.063> <-0.740, 1.214, -0.395> <-0.672, 1.187, -0.816> 
   		<0.020, 0.420, -0.057> <-0.374, 0.572, -0.120> <-0.679, 0.840, -0.457> <-0.610, 0.813, -0.878> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.042, 2.193, 1.412> <0.338, 2.193, 1.412> <0.740, 2.193, 1.220> <0.938, 2.193, 1.000> 
   		<0.044, 2.698, 1.306> <0.339, 2.698, 1.306> <0.668, 2.699, 1.145> <0.866, 2.699, 0.925> 
   		<0.153, 3.338, 1.017> <0.314, 3.338, 1.017> <0.494, 3.328, 0.881> <0.595, 3.328, 0.754> 
   		<0.060, 3.821, 0.862> <0.221, 3.821, 0.862> <0.437, 3.821, 0.739> <0.537, 3.821, 0.612> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.938, 2.193, 1.000> <1.151, 2.193, 0.764> <1.309, 2.193, 0.325> <1.309, 2.193, 0.007> 
   		<0.866, 2.699, 0.925> <1.079, 2.699, 0.689> <1.206, 2.701, 0.325> <1.206, 2.701, 0.007> 
   		<0.595, 3.328, 0.754> <0.713, 3.328, 0.604> <0.879, 3.323, 0.200> <0.879, 3.323, 0.009> 
   		<0.537, 3.821, 0.612> <0.655, 3.821, 0.462> <0.735, 3.821, 0.198> <0.735, 3.821, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<1.309, 2.193, 0.007> <1.309, 2.193, -0.311> <1.151, 2.193, -0.750> <0.938, 2.193, -0.987> 
   		<1.206, 2.701, 0.007> <1.206, 2.701, -0.311> <1.079, 2.699, -0.675> <0.866, 2.699, -0.911> 
   		<0.879, 3.323, 0.009> <0.879, 3.323, -0.182> <0.713, 3.325, -0.581> <0.594, 3.325, -0.731> 
   		<0.735, 3.821, 0.007> <0.735, 3.821, -0.184> <0.655, 3.821, -0.447> <0.537, 3.821, -0.597> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.938, 2.193, -0.987> <0.740, 2.193, -1.206> <0.338, 2.193, -1.398> <0.042, 2.193, -1.398> 
   		<0.953, 2.087, -1.002> <0.755, 2.087, -1.222> <0.338, 2.089, -1.420> <0.042, 2.089, -1.420> 
   		<0.880, 1.878, -0.973> <0.715, 1.878, -1.167> <0.281, 1.903, -1.355> <0.028, 1.903, -1.355> 
   		<0.815, 1.869, -0.887> <0.650, 1.869, -1.081> <0.308, 1.869, -1.258> <0.054, 1.869, -1.258> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.938, 2.193, -0.987> <0.740, 2.193, -1.206> <0.338, 2.193, -1.398> <0.042, 2.193, -1.398> 
   		<0.866, 2.699, -0.911> <0.668, 2.699, -1.131> <0.339, 2.698, -1.292> <0.044, 2.698, -1.292> 
   		<0.594, 3.325, -0.731> <0.494, 3.325, -0.858> <0.215, 3.329, -1.004> <0.053, 3.329, -1.004> 
   		<0.537, 3.821, -0.597> <0.437, 3.821, -0.724> <0.221, 3.821, -0.848> <0.060, 3.821, -0.848> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.042, 2.193, -1.398> <-0.253, 2.193, -1.398> <-0.655, 2.193, -1.206> <-0.853, 2.193, -0.987> 
   		<0.042, 2.089, -1.420> <-0.253, 2.089, -1.420> <-0.671, 2.085, -1.222> <-0.869, 2.085, -1.003> 
   		<0.028, 1.903, -1.355> <-0.226, 1.903, -1.355> <-0.618, 1.896, -1.157> <-0.782, 1.896, -0.964> 
   		<0.054, 1.869, -1.258> <-0.200, 1.869, -1.258> <-0.542, 1.869, -1.081> <-0.707, 1.869, -0.887> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.853, 2.193, -0.987> <-1.066, 2.193, -0.750> <-1.224, 2.193, -0.311> <-1.224, 2.193, 0.007> 
   		<-0.869, 2.085, -1.003> <-1.082, 2.085, -0.766> <-1.247, 2.081, -0.311> <-1.247, 2.081, 0.007> 
   		<-0.782, 1.896, -0.964> <-0.967, 1.896, -0.747> <-1.135, 1.888, -0.277> <-1.135, 1.888, 0.007> 
   		<-0.707, 1.869, -0.887> <-0.891, 1.869, -0.671> <-1.022, 1.869, -0.278> <-1.022, 1.869, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-1.224, 2.193, 0.007> <-1.224, 2.193, 0.325> <-1.066, 2.193, 0.764> <-0.853, 2.193, 1.000> 
   		<-1.247, 2.081, 0.007> <-1.247, 2.081, 0.325> <-1.082, 2.085, 0.780> <-0.869, 2.085, 1.016> 
   		<-1.135, 1.888, 0.007> <-1.135, 1.888, 0.292> <-0.965, 1.896, 0.762> <-0.781, 1.896, 0.978> 
   		<-1.022, 1.869, 0.007> <-1.022, 1.869, 0.291> <-0.891, 1.869, 0.684> <-0.707, 1.869, 0.901> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.853, 2.193, 1.000> <-0.655, 2.193, 1.220> <-0.253, 2.193, 1.412> <0.042, 2.193, 1.412> 
   		<-0.869, 2.085, 1.016> <-0.671, 2.085, 1.236> <-0.253, 2.089, 1.433> <0.042, 2.089, 1.433> 
   		<-0.781, 1.896, 0.978> <-0.617, 1.896, 1.172> <-0.225, 1.902, 1.369> <0.029, 1.902, 1.369> 
   		<-0.707, 1.869, 0.901> <-0.542, 1.869, 1.094> <-0.200, 1.869, 1.271> <0.054, 1.869, 1.271> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.074, -0.000, 1.275> <0.344, -0.000, 1.233> <0.533, -0.000, 0.973> <0.490, 0.000, 0.703> 
   		<0.098, 0.060, 1.425> <0.367, 0.060, 1.382> <0.620, 0.121, 0.958> <0.577, 0.121, 0.688> 
   		<0.211, 0.331, 1.177> <0.338, 0.313, 1.157> <0.336, 0.401, 0.857> <0.312, 0.401, 0.730> 
   		<0.194, 0.439, 1.070> <0.321, 0.420, 1.050> <0.451, 0.495, 0.839> <0.427, 0.495, 0.712> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.490, 0.000, 0.703> <0.447, 0.000, 0.434> <0.187, 0.000, 0.245> <-0.082, 0.000, 0.288> 
   		<0.577, 0.121, 0.688> <0.534, 0.121, 0.419> <0.171, 0.045, 0.142> <-0.098, 0.045, 0.185> 
   		<0.312, 0.401, 0.730> <0.285, 0.401, 0.591> <0.192, 0.273, 0.303> <0.054, 0.293, 0.325> 
   		<0.427, 0.495, 0.712> <0.400, 0.495, 0.573> <0.206, 0.418, 0.390> <0.068, 0.439, 0.412> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.082, 0.000, 0.288> <-0.553, 0.000, 0.362> <-1.193, 0.000, 0.487> <-1.119, 0.000, 0.958> 
   		<-0.106, -0.042, 0.137> <-0.577, -0.042, 0.211> <-1.498, 0.009, 0.500> <-1.423, 0.009, 0.971> 
   		<-0.213, 0.340, 0.357> <-0.231, 0.424, 0.432> <-1.047, 0.749, 0.745> <-1.025, 0.755, 0.841> 
   		<-0.237, 0.452, 0.457> <-0.255, 0.536, 0.532> <-0.229, 0.582, 0.717> <-0.207, 0.588, 0.814> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.082, 0.000, 0.288> <-0.553, 0.000, 0.362> <-1.193, 0.000, 0.487> <-1.119, 0.000, 0.958> 
   		<-0.098, 0.045, 0.185> <-0.569, 0.045, 0.259> <-1.498, 0.009, 0.500> <-1.423, 0.009, 0.971> 
   		<0.054, 0.293, 0.325> <-0.095, 0.315, 0.349> <-1.054, 0.755, 0.691> <-1.025, 0.755, 0.841> 
   		<0.068, 0.439, 0.412> <-0.081, 0.461, 0.436> <-0.236, 0.588, 0.664> <-0.207, 0.588, 0.814> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.140, 0.459, 1.139> <-0.171, 0.521, 1.057> <-0.190, 0.593, 0.888> <-0.207, 0.588, 0.814> 
   		<-0.069, 0.316, 1.329> <-0.100, 0.377, 1.247> <-1.008, 0.760, 0.915> <-1.025, 0.755, 0.841> 
   		<0.095, -0.055, 1.406> <-0.376, -0.055, 1.480> <-1.348, 0.009, 1.442> <-1.423, 0.009, 0.971> 
   		<0.074, -0.000, 1.275> <-0.396, -0.000, 1.350> <-1.044, -0.000, 1.429> <-1.119, 0.000, 0.958> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.140, 0.459, 1.139> <-0.171, 0.521, 1.057> <-0.190, 0.593, 0.888> <-0.207, 0.588, 0.814> 
   		<-0.069, 0.316, 1.329> <-0.100, 0.377, 1.247> <-0.162, 0.593, 1.035> <-0.179, 0.588, 0.961> 
   		<0.095, -0.055, 1.406> <0.119, 0.006, 1.555> <0.065, 0.353, 1.201> <0.048, 0.460, 1.094> 
   		<0.074, -0.000, 1.275> <0.098, 0.060, 1.425> <0.211, 0.331, 1.177> <0.194, 0.439, 1.070> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.237, 0.452, 0.457> <-0.213, 0.340, 0.357> <-0.106, -0.042, 0.137> <-0.082, 0.000, 0.288> 
   		<-0.255, 0.536, 0.532> <-0.231, 0.424, 0.432> <-0.122, 0.003, 0.034> <-0.098, 0.045, 0.185> 
   		<-0.229, 0.582, 0.717> <-0.258, 0.582, 0.567> <-0.095, 0.315, 0.349> <0.054, 0.293, 0.325> 
   		<-0.207, 0.588, 0.814> <-0.236, 0.588, 0.664> <-0.081, 0.461, 0.436> <0.068, 0.439, 0.412> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.427, 0.495, 0.712> <0.451, 0.495, 0.839> <0.321, 0.420, 1.050> <0.194, 0.439, 1.070> 
   		<0.531, 0.581, 0.695> <0.555, 0.581, 0.822> <0.342, 0.346, 1.184> <0.216, 0.365, 1.204> 
   		<0.803, 0.130, 0.676> <0.864, 0.106, 1.052> <0.570, 0.107, 1.218> <0.218, 0.243, 1.274> 
   		<0.810, 0.263, 0.652> <0.871, 0.239, 1.028> <0.600, 0.194, 1.407> <0.248, 0.330, 1.463> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.194, 0.439, 1.070> <0.048, 0.460, 1.094> <-0.179, 0.588, 0.961> <-0.207, 0.588, 0.814> 
   		<0.211, 0.331, 1.177> <0.065, 0.353, 1.201> <-0.997, 0.755, 0.988> <-1.025, 0.755, 0.841> 
   		<0.098, 0.060, 1.425> <-0.373, 0.060, 1.499> <-1.348, 0.009, 1.442> <-1.423, 0.009, 0.971> 
   		<0.074, -0.000, 1.275> <-0.396, -0.000, 1.350> <-1.044, -0.000, 1.429> <-1.119, 0.000, 0.958> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.207, 0.588, 0.814> <-0.236, 0.588, 0.664> <-0.081, 0.461, 0.436> <0.068, 0.439, 0.412> 
   		<-0.353, 0.638, 0.802> <-0.382, 0.638, 0.652> <-0.098, 0.383, 0.331> <0.051, 0.361, 0.307> 
   		<-0.590, 0.676, 0.900> <-0.659, 0.703, 0.480> <-0.356, 0.487, 0.247> <0.038, 0.335, 0.185> 
   		<-0.612, 0.813, 0.878> <-0.681, 0.840, 0.457> <-0.376, 0.572, 0.120> <0.018, 0.420, 0.057> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 0.439, 0.412> <0.206, 0.418, 0.390> <0.400, 0.495, 0.573> <0.427, 0.495, 0.712> 
   		<0.051, 0.361, 0.307> <0.189, 0.341, 0.285> <0.504, 0.581, 0.557> <0.531, 0.581, 0.695> 
   		<0.038, 0.335, 0.185> <0.396, 0.197, 0.128> <0.741, 0.154, 0.295> <0.803, 0.130, 0.676> 
   		<0.018, 0.420, 0.057> <0.375, 0.282, 0.001> <0.748, 0.287, 0.271> <0.810, 0.263, 0.652> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.612, 0.813, 0.878> <-0.541, 0.785, 1.314> <-0.161, 0.488, 1.528> <0.248, 0.330, 1.463> 
   		<-0.590, 0.676, 0.900> <-0.519, 0.648, 1.336> <-0.191, 0.401, 1.339> <0.218, 0.243, 1.274> 
   		<-0.353, 0.638, 0.802> <-0.325, 0.638, 0.949> <0.069, 0.386, 1.227> <0.216, 0.365, 1.204> 
   		<-0.207, 0.588, 0.814> <-0.179, 0.588, 0.961> <0.048, 0.460, 1.094> <0.194, 0.439, 1.070> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.248, 0.330, 1.463> <0.600, 0.194, 1.407> <0.871, 0.239, 1.028> <0.810, 0.263, 0.652> 
   		<0.293, 0.462, 1.749> <0.645, 0.326, 1.693> <0.901, 0.801, 0.928> <0.839, 0.825, 0.553> 
   		<0.262, 1.557, 1.147> <0.502, 1.578, 1.109> <0.550, 1.558, 0.574> <0.510, 1.566, 0.334> 
   		<0.165, 2.034, 0.942> <0.405, 2.056, 0.904> <0.552, 2.123, 0.662> <0.512, 2.131, 0.421> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.810, 0.263, 0.652> <0.748, 0.287, 0.271> <0.375, 0.282, 0.001> <0.018, 0.420, 0.057> 
   		<0.839, 0.825, 0.553> <0.777, 0.850, 0.171> <0.346, 0.404, -0.182> <-0.011, 0.542, -0.125> 
   		<0.510, 1.566, 0.334> <0.473, 1.573, 0.115> <0.255, 1.589, 0.102> <0.037, 1.569, 0.137> 
   		<0.512, 2.131, 0.421> <0.475, 2.138, 0.202> <0.246, 2.081, 0.084> <0.028, 2.061, 0.119> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.446, 2.044, 0.573> <-0.400, 2.035, 0.844> <-0.106, 2.009, 0.984> <0.165, 2.034, 0.942> 
   		<-0.411, 1.662, 0.564> <-0.366, 1.653, 0.836> <-0.009, 1.532, 1.190> <0.262, 1.557, 1.147> 
   		<-0.674, 1.187, 0.816> <-0.602, 1.159, 1.252> <-0.115, 0.620, 1.814> <0.293, 0.462, 1.749> 
   		<-0.612, 0.813, 0.878> <-0.541, 0.785, 1.314> <-0.161, 0.488, 1.528> <0.248, 0.330, 1.463> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.165, 2.034, 0.942> <0.405, 2.056, 0.904> <0.552, 2.123, 0.662> <0.512, 2.131, 0.421> 
   		<0.134, 1.882, 1.084> <0.374, 1.904, 1.046> <0.552, 2.308, 0.690> <0.512, 2.316, 0.450> 
   		<0.082, 1.833, 1.165> <0.336, 1.833, 1.165> <0.540, 1.852, 0.944> <0.704, 1.852, 0.750> 
   		<0.054, 1.869, 1.271> <0.308, 1.869, 1.271> <0.650, 1.869, 1.094> <0.815, 1.869, 0.901> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.512, 2.131, 0.421> <0.475, 2.138, 0.202> <0.246, 2.081, 0.084> <0.028, 2.061, 0.119> 
   		<0.697, 2.052, 0.297> <0.661, 2.059, 0.078> <0.245, 2.125, 0.082> <0.027, 2.105, 0.117> 
   		<1.130, 1.869, 0.244> <0.790, 1.815, 0.242> <0.334, 1.986, 0.044> <-0.009, 1.986, 0.044> 
   		<1.130, 1.869, 0.007> <0.791, 1.815, 0.005> <0.335, 1.986, 0.000> <-0.009, 1.986, 0.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.028, 2.061, 0.119> <-0.221, 2.039, 0.158> <-0.487, 2.052, 0.323> <-0.446, 2.044, 0.573> 
   		<0.037, 1.569, 0.137> <-0.213, 1.546, 0.176> <-0.453, 1.670, 0.315> <-0.411, 1.662, 0.564> 
   		<-0.011, 0.542, -0.125> <-0.405, 0.695, -0.063> <-0.742, 1.214, 0.395> <-0.674, 1.187, 0.816> 
   		<0.018, 0.420, 0.057> <-0.376, 0.572, 0.120> <-0.681, 0.840, 0.457> <-0.612, 0.813, 0.878> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.054, 1.869, 1.271> <0.308, 1.869, 1.271> <0.650, 1.869, 1.094> <0.815, 1.869, 0.901> 
   		<0.029, 1.902, 1.369> <0.282, 1.902, 1.369> <0.714, 1.878, 1.181> <0.879, 1.878, 0.988> 
   		<0.042, 2.089, 1.433> <0.338, 2.089, 1.433> <0.755, 2.087, 1.235> <0.953, 2.087, 1.016> 
   		<0.042, 2.193, 1.412> <0.338, 2.193, 1.412> <0.740, 2.193, 1.220> <0.938, 2.193, 1.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.815, 1.869, 0.901> <0.999, 1.869, 0.684> <1.130, 1.869, 0.291> <1.130, 1.869, 0.007> 
   		<0.879, 1.878, 0.988> <1.063, 1.878, 0.771> <1.240, 1.886, 0.292> <1.240, 1.886, 0.007> 
   		<0.953, 2.087, 1.016> <1.166, 2.087, 0.779> <1.331, 2.084, 0.325> <1.331, 2.084, 0.007> 
   		<0.938, 2.193, 1.000> <1.151, 2.193, 0.764> <1.309, 2.193, 0.325> <1.309, 2.193, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<1.130, 1.869, 0.007> <1.130, 1.869, -0.278> <0.999, 1.869, -0.671> <0.815, 1.869, -0.887> 
   		<1.240, 1.886, 0.007> <1.240, 1.886, -0.277> <1.064, 1.878, -0.757> <0.880, 1.878, -0.973> 
   		<1.331, 2.084, 0.007> <1.331, 2.084, -0.311> <1.166, 2.087, -0.766> <0.953, 2.087, -1.002> 
   		<1.309, 2.193, 0.007> <1.309, 2.193, -0.311> <1.151, 2.193, -0.750> <0.938, 2.193, -0.987> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.054, 1.869, -1.258> <-0.200, 1.869, -1.258> <-0.542, 1.869, -1.081> <-0.707, 1.869, -0.887> 
   		<0.082, 1.833, -1.155> <-0.172, 1.833, -1.155> <-0.451, 1.835, -0.988> <-0.616, 1.835, -0.795> 
   		<0.139, 1.841, -1.101> <-0.132, 1.816, -1.144> <-0.526, 1.791, -0.966> <-0.571, 1.800, -0.695> 
   		<0.167, 2.034, -0.942> <-0.104, 2.009, -0.985> <-0.398, 2.035, -0.844> <-0.444, 2.044, -0.573> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.707, 1.869, 0.901> <-0.542, 1.869, 1.094> <-0.200, 1.869, 1.271> <0.054, 1.869, 1.271> 
   		<-0.616, 1.835, 0.805> <-0.451, 1.835, 0.998> <-0.172, 1.833, 1.165> <0.082, 1.833, 1.165> 
   		<-0.458, 2.180, 0.576> <-0.413, 2.171, 0.847> <-0.137, 1.858, 1.127> <0.134, 1.882, 1.084> 
   		<-0.446, 2.044, 0.573> <-0.400, 2.035, 0.844> <-0.106, 2.009, 0.984> <0.165, 2.034, 0.942> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, 0.862> <0.031, 3.966, 0.816> <-0.084, 3.478, 1.106> <-0.190, 3.398, 1.026> 
   		<0.347, 3.821, 0.862> <0.319, 3.966, 0.816> <-0.038, 3.425, 1.147> <-0.145, 3.345, 1.067> 
   		<0.566, 4.062, 0.777> <0.346, 3.794, 0.992> <0.200, 3.524, 1.244> <-0.099, 3.256, 1.169> 
   		<0.568, 4.335, 0.689> <0.348, 4.067, 0.904> <0.147, 3.571, 1.284> <-0.152, 3.302, 1.209> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.190, 3.398, 1.026> <-0.398, 3.239, 0.869> <-0.605, 3.245, 0.467> <-0.783, 3.180, 0.228> 
   		<-0.145, 3.345, 1.067> <-0.353, 3.186, 0.910> <-0.631, 3.140, 0.494> <-0.809, 3.074, 0.255> 
   		<-0.099, 3.256, 1.169> <-0.376, 3.009, 1.100> <-0.647, 3.005, 0.608> <-0.850, 2.961, 0.293> 
   		<-0.152, 3.302, 1.209> <-0.429, 3.055, 1.140> <-0.758, 3.009, 0.621> <-0.961, 2.965, 0.306> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.042, 2.193, -1.398> <0.044, 2.698, -1.292> <0.053, 3.329, -1.004> <0.060, 3.821, -0.848> 
   		<-0.253, 2.193, -1.398> <-0.252, 2.698, -1.292> <-0.108, 3.329, -1.004> <-0.102, 3.821, -0.848> 
   		<-0.655, 2.193, -1.206> <-0.580, 2.701, -1.131> <-0.394, 3.327, -0.862> <-0.318, 3.821, -0.724> 
   		<-0.853, 2.193, -0.987> <-0.778, 2.701, -0.911> <-0.494, 3.327, -0.735> <-0.418, 3.821, -0.597> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, -0.848> <0.061, 3.905, -0.821> <0.060, 3.634, -0.936> <0.060, 3.551, -0.967> 
   		<0.345, 3.821, -0.848> <0.346, 3.905, -0.821> <0.227, 3.622, -0.934> <0.227, 3.540, -0.966> 
   		<0.566, 4.062, -0.773> <0.506, 3.853, -0.957> <0.498, 3.705, -0.861> <0.456, 3.447, -0.975> 
   		<0.568, 4.335, -0.689> <0.508, 4.126, -0.873> <0.502, 3.760, -1.020> <0.459, 3.502, -1.134> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.551, -0.967> <0.060, 3.273, -1.072> <0.060, 2.897, -1.201> <0.060, 2.617, -1.301> 
   		<0.227, 3.540, -0.966> <0.227, 3.261, -1.071> <0.163, 2.896, -1.201> <0.163, 2.616, -1.301> 
   		<0.456, 3.447, -0.975> <0.412, 3.186, -1.091> <0.376, 2.854, -1.290> <0.278, 2.589, -1.351> 
   		<0.459, 3.502, -1.134> <0.416, 3.240, -1.250> <0.380, 2.874, -1.391> <0.281, 2.609, -1.453> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.030, 2.061, -0.119> <0.029, 2.105, -0.117> <-0.009, 1.986, -0.044> <-0.009, 1.986, 0.000> 
   		<0.248, 2.081, -0.084> <0.247, 2.125, -0.082> <0.335, 1.986, -0.044> <0.335, 1.986, 0.000> 
   		<0.477, 2.138, -0.202> <0.662, 2.059, -0.074> <0.792, 1.815, -0.233> <0.791, 1.815, 0.005> 
   		<0.514, 2.131, -0.421> <0.699, 2.052, -0.293> <1.131, 1.869, -0.232> <1.130, 1.869, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.446, 2.044, 0.573> <-0.619, 1.991, 0.403> <-1.023, 1.869, 0.255> <-1.022, 1.869, 0.007> 
   		<-0.487, 2.052, 0.323> <-0.660, 2.000, 0.153> <-0.721, 1.817, 0.253> <-0.721, 1.817, 0.005> 
   		<-0.221, 2.039, 0.158> <-0.222, 2.082, 0.156> <-0.315, 1.986, 0.044> <-0.315, 1.986, 0.000> 
   		<0.028, 2.061, 0.119> <0.027, 2.105, 0.117> <-0.009, 1.986, 0.044> <-0.009, 1.986, 0.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, -0.848> <0.221, 3.821, -0.848> <0.437, 3.821, -0.724> <0.537, 3.821, -0.597> 
   		<0.345, 3.821, -0.848> <0.507, 3.821, -0.848> <0.418, 3.980, -0.681> <0.519, 3.980, -0.554> 
   		<0.566, 4.062, -0.773> <0.585, 4.129, -0.714> <0.750, 4.182, -0.534> <0.768, 4.175, -0.445> 
   		<0.568, 4.335, -0.689> <0.587, 4.402, -0.630> <0.675, 4.327, -0.501> <0.692, 4.320, -0.412> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.537, 3.821, -0.597> <0.655, 3.821, -0.447> <0.735, 3.821, -0.184> <0.735, 3.821, 0.007> 
   		<0.519, 3.980, -0.554> <0.637, 3.980, -0.404> <0.696, 3.955, -0.184> <0.696, 3.955, 0.007> 
   		<0.768, 4.175, -0.445> <0.791, 4.166, -0.323> <0.742, 4.149, -0.123> <0.741, 4.150, 0.001> 
   		<0.692, 4.320, -0.412> <0.716, 4.311, -0.291> <0.704, 4.284, -0.124> <0.704, 4.285, 0.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.735, 3.821, 0.007> <0.735, 3.821, 0.198> <0.655, 3.821, 0.462> <0.537, 3.821, 0.612> 
   		<0.696, 3.955, 0.007> <0.696, 3.955, 0.198> <0.636, 3.985, 0.415> <0.518, 3.985, 0.564> 
   		<0.741, 4.150, 0.001> <0.741, 4.151, 0.117> <0.788, 4.169, 0.307> <0.766, 4.177, 0.421> 
   		<0.704, 4.285, 0.000> <0.703, 4.286, 0.116> <0.711, 4.318, 0.271> <0.688, 4.327, 0.385> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.537, 3.821, 0.612> <0.437, 3.821, 0.739> <0.221, 3.821, 0.862> <0.060, 3.821, 0.862> 
   		<0.518, 3.985, 0.564> <0.417, 3.985, 0.691> <0.508, 3.821, 0.862> <0.347, 3.821, 0.862> 
   		<0.766, 4.177, 0.421> <0.747, 4.184, 0.517> <0.618, 4.126, 0.725> <0.566, 4.062, 0.777> 
   		<0.688, 4.327, 0.385> <0.669, 4.334, 0.481> <0.621, 4.400, 0.637> <0.568, 4.335, 0.689> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, 0.862> <-0.102, 3.821, 0.862> <-0.318, 3.821, 0.739> <-0.418, 3.821, 0.612> 
   		<0.153, 3.338, 1.017> <-0.009, 3.338, 1.017> <-0.390, 3.328, 0.884> <-0.491, 3.328, 0.757> 
   		<0.044, 2.698, 1.306> <-0.252, 2.698, 1.306> <-0.580, 2.701, 1.144> <-0.778, 2.701, 0.925> 
   		<0.042, 2.193, 1.412> <-0.253, 2.193, 1.412> <-0.655, 2.193, 1.220> <-0.853, 2.193, 1.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.418, 3.821, 0.612> <-0.536, 3.821, 0.462> <-0.616, 3.821, 0.198> <-0.616, 3.821, 0.007> 
   		<-0.491, 3.328, 0.757> <-0.609, 3.328, 0.607> <-0.771, 3.323, 0.204> <-0.771, 3.323, 0.013> 
   		<-0.778, 2.701, 0.925> <-0.991, 2.701, 0.689> <-1.118, 2.703, 0.325> <-1.118, 2.703, 0.007> 
   		<-0.853, 2.193, 1.000> <-1.066, 2.193, 0.764> <-1.224, 2.193, 0.325> <-1.224, 2.193, 0.007> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.616, 3.821, 0.007> <-0.616, 3.821, -0.184> <-0.536, 3.821, -0.447> <-0.418, 3.821, -0.597> 
   		<-0.771, 3.323, 0.013> <-0.771, 3.323, -0.178> <-0.613, 3.327, -0.585> <-0.494, 3.327, -0.735> 
   		<-1.118, 2.703, 0.007> <-1.118, 2.703, -0.311> <-0.991, 2.701, -0.675> <-0.778, 2.701, -0.911> 
   		<-1.224, 2.193, 0.007> <-1.224, 2.193, -0.311> <-1.066, 2.193, -0.750> <-0.853, 2.193, -0.987> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.432, 4.335, -0.689> <-0.430, 4.596, -0.608> <-0.205, 4.813, -0.542> <0.068, 4.813, -0.542> 
   		<-0.364, 4.150, -0.880> <-0.361, 4.411, -0.800> <-0.199, 4.822, -1.105> <0.074, 4.822, -1.105> 
   		<-0.311, 3.803, -1.031> <-0.308, 3.855, -1.183> <-0.092, 4.067, -1.164> <0.068, 4.055, -1.162> 
   		<-0.274, 3.554, -1.141> <-0.270, 3.606, -1.293> <-0.092, 3.692, -1.344> <0.068, 3.680, -1.343> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 4.813, -0.542> <0.341, 4.813, -0.542> <0.570, 4.596, -0.608> <0.568, 4.335, -0.689> 
   		<0.067, 4.813, -0.492> <0.340, 4.813, -0.492> <0.589, 4.663, -0.549> <0.587, 4.402, -0.630> 
   		<0.020, 4.735, -0.351> <0.255, 4.747, -0.351> <0.568, 4.531, -0.455> <0.675, 4.327, -0.501> 
   		<0.046, 4.764, -0.383> <0.281, 4.776, -0.384> <0.586, 4.525, -0.366> <0.692, 4.320, -0.412> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, -0.848> <-0.222, 3.821, -0.848> <-0.434, 4.066, -0.771> <-0.432, 4.335, -0.689> 
   		<0.061, 3.905, -0.821> <-0.221, 3.905, -0.821> <-0.366, 3.881, -0.963> <-0.364, 4.150, -0.880> 
   		<0.060, 3.634, -0.936> <-0.085, 3.644, -0.938> <-0.314, 3.756, -0.893> <-0.311, 3.803, -1.031> 
   		<0.060, 3.551, -0.967> <-0.085, 3.562, -0.969> <-0.277, 3.507, -1.004> <-0.274, 3.554, -1.141> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.432, 4.335, 0.689> <-0.430, 4.595, 0.605> <-0.205, 4.813, 0.542> <0.068, 4.813, 0.542> 
   		<-0.437, 4.408, 0.622> <-0.435, 4.668, 0.539> <-0.191, 4.814, 0.494> <0.082, 4.814, 0.494> 
   		<-0.524, 4.292, 0.481> <-0.424, 4.494, 0.432> <-0.212, 4.725, 0.354> <0.018, 4.735, 0.353> 
   		<-0.546, 4.274, 0.386> <-0.446, 4.476, 0.337> <-0.184, 4.754, 0.384> <0.046, 4.764, 0.383> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 4.813, 0.542> <0.341, 4.813, 0.542> <0.570, 4.595, 0.605> <0.568, 4.335, 0.689> 
   		<-0.082, 4.807, 1.054> <0.191, 4.807, 1.054> <0.350, 4.327, 0.821> <0.348, 4.067, 0.904> 
   		<-0.216, 3.997, 1.301> <-0.114, 3.877, 1.393> <0.028, 3.675, 1.374> <0.147, 3.571, 1.284> 
   		<-0.474, 3.646, 1.241> <-0.372, 3.527, 1.333> <-0.271, 3.407, 1.299> <-0.152, 3.302, 1.209> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.821, 0.862> <-0.223, 3.821, 0.862> <-0.434, 4.066, 0.775> <-0.432, 4.335, 0.689> 
   		<-0.102, 3.821, 0.862> <-0.385, 3.821, 0.862> <-0.439, 4.139, 0.709> <-0.437, 4.408, 0.622> 
   		<-0.318, 3.821, 0.739> <-0.296, 3.969, 0.695> <-0.591, 4.155, 0.514> <-0.524, 4.292, 0.481> 
   		<-0.418, 3.821, 0.612> <-0.396, 3.969, 0.568> <-0.613, 4.137, 0.419> <-0.546, 4.274, 0.386> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.356, 4.691, 0.000> <-0.356, 4.691, 0.216> <-0.167, 4.725, 0.383> <0.046, 4.764, 0.383> 
   		<-0.371, 4.528, -0.002> <-0.371, 4.528, 0.214> <-0.397, 4.716, 0.384> <-0.184, 4.754, 0.384> 
   		<-0.551, 4.358, -0.018> <-0.553, 4.361, 0.106> <-0.474, 4.454, 0.219> <-0.446, 4.476, 0.337> 
   		<-0.598, 4.201, -0.017> <-0.599, 4.203, 0.107> <-0.574, 4.251, 0.268> <-0.546, 4.274, 0.386> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.046, 4.764, 0.383> <0.259, 4.803, 0.383> <0.449, 4.837, 0.216> <0.449, 4.837, 0.000> 
   		<0.111, 4.832, 0.452> <0.324, 4.870, 0.452> <0.446, 4.827, 0.488> <0.446, 4.827, 0.272> 
   		<0.152, 4.851, 0.658> <0.232, 5.015, 0.701> <0.760, 5.052, 0.537> <0.816, 5.212, 0.456> 
   		<0.202, 4.953, 0.685> <0.282, 5.117, 0.728> <0.364, 5.370, 0.666> <0.420, 5.530, 0.585> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.046, 4.764, -0.383> <-0.167, 4.725, -0.383> <-0.356, 4.691, -0.216> <-0.356, 4.691, 0.000> 
   		<-0.184, 4.752, -0.383> <-0.397, 4.714, -0.383> <-0.371, 4.528, -0.219> <-0.371, 4.528, -0.002> 
   		<-0.434, 4.461, -0.365> <-0.462, 4.438, -0.249> <-0.549, 4.356, -0.139> <-0.551, 4.358, -0.018> 
   		<-0.534, 4.258, -0.411> <-0.562, 4.235, -0.295> <-0.596, 4.199, -0.138> <-0.598, 4.201, -0.017> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.046, 4.764, -0.383> <-0.167, 4.725, -0.383> <-0.356, 4.691, -0.216> <-0.356, 4.691, 0.000> 
   		<-0.101, 4.752, -0.399> <-0.314, 4.713, -0.399> <-0.350, 4.759, -0.215> <-0.350, 4.759, 0.001> 
   		<-0.333, 4.634, -0.448> <-0.382, 4.618, -0.323> <-0.542, 4.756, -0.142> <-0.542, 4.756, -0.007> 
   		<-0.445, 4.724, -0.436> <-0.494, 4.708, -0.312> <-0.539, 4.824, -0.143> <-0.540, 4.824, -0.008> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.534, 5.708, -0.008> <-0.533, 5.708, 0.034> <-0.475, 5.641, 0.043> <-0.447, 5.635, 0.074> 
   		<-0.621, 5.470, -0.012> <-0.620, 5.470, 0.030> <-0.550, 5.508, 0.023> <-0.522, 5.503, 0.054> 
   		<0.029, 5.760, -0.002> <0.034, 5.760, 0.016> <0.021, 5.728, 0.034> <0.027, 5.721, 0.049> 
   		<0.271, 5.782, 0.001> <0.275, 5.782, 0.018> <0.224, 5.765, 0.023> <0.231, 5.757, 0.038> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.447, 5.635, 0.074> <-0.334, 5.613, 0.200> <-0.105, 5.747, 0.398> <-0.076, 5.616, 0.503> 
   		<-0.522, 5.503, 0.054> <-0.410, 5.480, 0.180> <-0.029, 5.745, 0.249> <0.001, 5.614, 0.353> 
   		<0.027, 5.721, 0.049> <0.086, 5.648, 0.185> <0.299, 5.689, 0.387> <0.310, 5.555, 0.483> 
   		<0.231, 5.757, 0.038> <0.290, 5.684, 0.174> <0.465, 5.662, 0.379> <0.476, 5.529, 0.475> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.076, 5.616, 0.503> <-0.037, 5.441, 0.642> <-0.198, 5.115, 0.677> <-0.285, 4.906, 0.658> 
   		<0.001, 5.614, 0.353> <0.039, 5.439, 0.493> <-0.063, 5.131, 0.565> <-0.150, 4.922, 0.546> 
   		<0.310, 5.555, 0.483> <0.323, 5.407, 0.589> <0.230, 5.089, 0.657> <0.122, 4.946, 0.623> 
   		<0.476, 5.529, 0.475> <0.488, 5.381, 0.581> <0.404, 5.107, 0.642> <0.296, 4.964, 0.608> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.285, 4.906, 0.658> <-0.324, 4.812, 0.649> <-0.411, 4.735, 0.515> <-0.447, 4.724, 0.421> 
   		<-0.397, 4.892, 0.751> <-0.436, 4.798, 0.742> <-0.287, 4.630, 0.531> <-0.323, 4.618, 0.436> 
   		<0.056, 4.939, 0.677> <0.006, 4.837, 0.650> <0.072, 4.921, 0.418> <0.007, 4.854, 0.349> 
   		<0.202, 4.953, 0.685> <0.152, 4.851, 0.658> <0.111, 4.832, 0.452> <0.046, 4.764, 0.383> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.447, 4.724, 0.421> <-0.495, 4.708, 0.296> <-0.540, 4.824, 0.127> <-0.540, 4.824, -0.008> 
   		<-0.323, 4.618, 0.436> <-0.371, 4.602, 0.311> <-0.542, 4.756, 0.128> <-0.542, 4.756, -0.007> 
   		<0.007, 4.854, 0.349> <-0.206, 4.815, 0.349> <-0.350, 4.759, 0.217> <-0.350, 4.759, 0.001> 
   		<0.046, 4.764, 0.383> <-0.167, 4.725, 0.383> <-0.356, 4.691, 0.216> <-0.356, 4.691, 0.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.540, 4.824, -0.008> <-0.539, 4.824, -0.143> <-0.494, 4.708, -0.312> <-0.445, 4.724, -0.436> 
   		<-0.536, 4.946, -0.009> <-0.535, 4.946, -0.144> <-0.588, 4.783, -0.302> <-0.539, 4.798, -0.427> 
   		<-0.277, 4.774, -0.004> <-0.277, 4.775, -0.087> <-0.246, 4.747, -0.255> <-0.196, 4.769, -0.318> 
   		<-0.164, 4.753, -0.002> <-0.164, 4.754, -0.086> <-0.139, 4.767, -0.204> <-0.089, 4.789, -0.268> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.445, 4.724, -0.436> <-0.408, 4.735, -0.531> <-0.318, 4.812, -0.665> <-0.279, 4.906, -0.673> 
   		<-0.539, 4.798, -0.427> <-0.501, 4.810, -0.522> <-0.188, 4.816, -0.543> <-0.148, 4.910, -0.552> 
   		<-0.196, 4.769, -0.318> <-0.097, 4.814, -0.445> <0.033, 4.819, -0.598> <0.133, 4.947, -0.629> 
   		<-0.089, 4.789, -0.268> <0.010, 4.833, -0.394> <0.210, 4.836, -0.579> <0.310, 4.965, -0.610> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.279, 4.906, -0.673> <-0.192, 5.114, -0.693> <-0.032, 5.442, -0.658> <-0.073, 5.616, -0.518> 
   		<-0.386, 4.902, -0.773> <-0.299, 5.111, -0.792> <-0.077, 5.488, -0.797> <-0.118, 5.662, -0.658> 
   		<0.058, 4.945, -0.699> <0.141, 5.120, -0.746> <0.254, 5.494, -0.727> <0.314, 5.664, -0.643> 
   		<0.202, 4.962, -0.710> <0.285, 5.136, -0.757> <0.371, 5.404, -0.685> <0.431, 5.574, -0.601> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.073, 5.616, -0.518> <-0.104, 5.747, -0.413> <-0.338, 5.612, -0.216> <-0.451, 5.635, -0.090> 
   		<-0.023, 5.565, -0.364> <-0.054, 5.696, -0.258> <-0.369, 5.503, -0.167> <-0.483, 5.526, -0.041> 
   		<0.316, 5.550, -0.464> <0.299, 5.679, -0.371> <0.072, 5.644, -0.187> <0.011, 5.719, -0.060> 
   		<0.482, 5.521, -0.440> <0.466, 5.651, -0.348> <0.271, 5.680, -0.174> <0.210, 5.755, -0.046> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.451, 5.635, -0.090> <-0.479, 5.641, -0.060> <-0.535, 5.708, -0.049> <-0.534, 5.708, -0.008> 
   		<-0.483, 5.526, -0.041> <-0.510, 5.531, -0.011> <-0.622, 5.470, -0.053> <-0.621, 5.470, -0.012> 
   		<0.011, 5.719, -0.060> <0.002, 5.731, -0.040> <0.023, 5.759, -0.026> <0.029, 5.760, -0.002> 
   		<0.210, 5.755, -0.046> <0.200, 5.766, -0.027> <0.265, 5.781, -0.023> <0.271, 5.782, 0.001> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.447, 5.635, 0.074> <-0.254, 5.976, 0.126> <0.212, 5.980, 0.268> <0.481, 5.761, 0.277> 
   		<-0.475, 5.641, 0.043> <-0.282, 5.982, 0.095> <0.221, 6.017, 0.197> <0.490, 5.798, 0.207> 
   		<-0.533, 5.708, 0.034> <-0.454, 5.924, 0.038> <0.245, 6.103, 0.099> <0.495, 5.831, 0.100> 
   		<-0.534, 5.708, -0.008> <-0.455, 5.924, -0.004> <0.245, 6.103, 0.019> <0.495, 5.831, 0.019> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.451, 5.635, -0.090> <-0.348, 5.997, -0.251> <0.300, 5.968, -0.289> <0.482, 5.760, -0.316> 
   		<-0.338, 5.612, -0.216> <-0.234, 5.974, -0.377> <0.290, 5.929, -0.384> <0.472, 5.721, -0.411> 
   		<-0.104, 5.747, -0.413> <-0.149, 5.793, -0.553> <0.345, 5.753, -0.600> <0.462, 5.662, -0.557> 
   		<-0.073, 5.616, -0.518> <-0.118, 5.662, -0.658> <0.314, 5.664, -0.643> <0.431, 5.574, -0.601> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.534, 5.708, -0.008> <-0.455, 5.924, -0.004> <0.245, 6.103, 0.019> <0.495, 5.831, 0.019> 
   		<-0.535, 5.708, -0.049> <-0.456, 5.924, -0.045> <0.245, 6.103, -0.084> <0.495, 5.831, -0.083> 
   		<-0.479, 5.641, -0.060> <-0.376, 6.002, -0.220> <0.310, 6.007, -0.194> <0.491, 5.799, -0.221> 
   		<-0.451, 5.635, -0.090> <-0.348, 5.997, -0.251> <0.300, 5.968, -0.289> <0.482, 5.760, -0.316> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.495, 5.831, 0.019> <0.999, 5.281, 0.021> <0.591, 5.119, 0.011> <0.449, 4.837, 0.000> 
   		<0.495, 5.831, 0.100> <0.999, 5.281, 0.101> <0.589, 5.109, 0.283> <0.446, 4.827, 0.272> 
   		<0.490, 5.798, 0.207> <0.477, 5.744, 0.309> <0.850, 5.312, 0.406> <0.816, 5.212, 0.456> 
   		<0.481, 5.761, 0.277> <0.467, 5.706, 0.379> <0.454, 5.630, 0.534> <0.420, 5.530, 0.585> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.495, 5.831, 0.019> <0.999, 5.281, 0.021> <0.591, 5.119, 0.011> <0.449, 4.837, 0.000> 
   		<0.495, 5.831, -0.083> <1.000, 5.281, -0.082> <0.594, 5.130, -0.274> <0.452, 4.848, -0.285> 
   		<0.491, 5.799, -0.221> <0.482, 5.760, -0.316> <0.839, 5.372, -0.419> <0.808, 5.284, -0.462> 
   		<0.482, 5.760, -0.316> <0.472, 5.721, -0.411> <0.462, 5.662, -0.557> <0.431, 5.574, -0.601> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.449, 4.837, 0.000> <0.421, 4.782, -0.002> <0.654, 4.460, -0.001> <0.704, 4.285, 0.000> 
   		<0.449, 4.837, 0.216> <0.421, 4.782, 0.214> <0.654, 4.461, 0.115> <0.703, 4.286, 0.116> 
   		<0.259, 4.803, 0.383> <0.492, 4.813, 0.383> <0.606, 4.521, 0.222> <0.711, 4.318, 0.271> 
   		<0.046, 4.764, 0.383> <0.279, 4.774, 0.383> <0.583, 4.529, 0.336> <0.688, 4.327, 0.385> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.616, 3.821, 0.007> <-0.582, 3.930, 0.006> <-0.630, 4.091, -0.016> <-0.598, 4.201, -0.017> 
   		<-0.616, 3.821, -0.184> <-0.582, 3.930, -0.185> <-0.629, 4.089, -0.137> <-0.596, 4.199, -0.138> 
   		<-0.536, 3.821, -0.447> <-0.515, 3.961, -0.408> <-0.626, 4.106, -0.325> <-0.562, 4.235, -0.295> 
   		<-0.418, 3.821, -0.597> <-0.396, 3.961, -0.558> <-0.598, 4.129, -0.440> <-0.534, 4.258, -0.411> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.540, 4.824, -0.008> <-0.536, 4.946, -0.009> <-0.277, 4.774, -0.004> <-0.164, 4.753, -0.002> 
   		<-0.540, 4.824, 0.127> <-0.536, 4.946, 0.126> <-0.276, 4.774, 0.089> <-0.164, 4.753, 0.091> 
   		<-0.495, 4.708, 0.296> <-0.583, 4.783, 0.285> <-0.249, 4.742, 0.262> <-0.141, 4.761, 0.225> 
   		<-0.447, 4.724, 0.421> <-0.535, 4.798, 0.410> <-0.195, 4.767, 0.334> <-0.087, 4.786, 0.297> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.447, 4.724, 0.421> <-0.535, 4.798, 0.410> <-0.195, 4.767, 0.334> <-0.087, 4.786, 0.297> 
   		<-0.411, 4.735, 0.515> <-0.498, 4.810, 0.504> <-0.104, 4.809, 0.455> <0.005, 4.827, 0.418> 
   		<-0.324, 4.812, 0.649> <-0.189, 4.828, 0.538> <0.029, 4.823, 0.593> <0.203, 4.841, 0.578> 
   		<-0.285, 4.906, 0.658> <-0.150, 4.922, 0.546> <0.122, 4.946, 0.623> <0.296, 4.964, 0.608> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.279, 4.906, -0.673> <-0.386, 4.902, -0.773> <0.058, 4.945, -0.699> <0.202, 4.962, -0.710> 
   		<-0.318, 4.812, -0.665> <-0.425, 4.808, -0.764> <0.006, 4.836, -0.670> <0.151, 4.853, -0.681> 
   		<-0.408, 4.735, -0.531> <-0.296, 4.645, -0.543> <-0.038, 4.822, -0.479> <0.110, 4.834, -0.463> 
   		<-0.445, 4.724, -0.436> <-0.333, 4.634, -0.448> <-0.101, 4.752, -0.399> <0.046, 4.764, -0.383> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.285, 4.906, 0.658> <-0.397, 4.892, 0.751> <0.056, 4.939, 0.677> <0.202, 4.953, 0.685> 
   		<-0.198, 5.115, 0.677> <-0.311, 5.101, 0.770> <0.136, 5.103, 0.720> <0.282, 5.117, 0.728> 
   		<-0.037, 5.441, 0.642> <-0.107, 5.443, 0.778> <0.249, 5.463, 0.703> <0.364, 5.370, 0.666> 
   		<-0.076, 5.616, 0.503> <-0.146, 5.618, 0.639> <0.304, 5.623, 0.622> <0.420, 5.530, 0.585> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.076, 5.616, 0.503> <-0.146, 5.618, 0.639> <0.304, 5.623, 0.622> <0.420, 5.530, 0.585> 
   		<-0.105, 5.747, 0.398> <-0.175, 5.748, 0.534> <0.338, 5.723, 0.572> <0.454, 5.630, 0.534> 
   		<-0.334, 5.613, 0.200> <-0.141, 5.954, 0.252> <0.198, 5.925, 0.370> <0.467, 5.706, 0.379> 
   		<-0.447, 5.635, 0.074> <-0.254, 5.976, 0.126> <0.212, 5.980, 0.268> <0.481, 5.761, 0.277> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.449, 4.837, 0.000> <0.452, 4.848, -0.285> <0.808, 5.284, -0.462> <0.431, 5.574, -0.601> 
   		<0.449, 4.837, -0.216> <0.452, 4.848, -0.501> <0.748, 5.113, -0.546> <0.371, 5.404, -0.685> 
   		<0.259, 4.803, -0.383> <0.323, 4.873, -0.463> <0.233, 5.028, -0.728> <0.285, 5.136, -0.757> 
   		<0.046, 4.764, -0.383> <0.110, 4.834, -0.463> <0.151, 4.853, -0.681> <0.202, 4.962, -0.710> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.073, 5.616, -0.518> <-0.023, 5.565, -0.364> <0.316, 5.550, -0.464> <0.482, 5.521, -0.440> 
   		<-0.032, 5.442, -0.658> <0.018, 5.391, -0.503> <0.334, 5.402, -0.569> <0.501, 5.374, -0.545> 
   		<-0.192, 5.114, -0.693> <-0.061, 5.119, -0.571> <0.243, 5.088, -0.662> <0.420, 5.106, -0.643> 
   		<-0.279, 4.906, -0.673> <-0.148, 4.910, -0.552> <0.133, 4.947, -0.629> <0.310, 4.965, -0.610> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.418, 3.821, 0.612> <-0.396, 3.969, 0.568> <-0.613, 4.137, 0.419> <-0.546, 4.274, 0.386> 
   		<-0.536, 3.821, 0.462> <-0.514, 3.969, 0.418> <-0.641, 4.114, 0.301> <-0.574, 4.251, 0.268> 
   		<-0.616, 3.821, 0.198> <-0.582, 3.930, 0.197> <-0.632, 4.094, 0.108> <-0.599, 4.203, 0.107> 
   		<-0.616, 3.821, 0.007> <-0.582, 3.930, 0.006> <-0.630, 4.091, -0.016> <-0.598, 4.201, -0.017> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.046, 4.764, 0.383> <0.279, 4.774, 0.383> <0.583, 4.529, 0.336> <0.688, 4.327, 0.385> 
   		<0.018, 4.735, 0.353> <0.251, 4.745, 0.353> <0.564, 4.536, 0.432> <0.669, 4.334, 0.481> 
   		<0.082, 4.814, 0.494> <0.355, 4.814, 0.494> <0.623, 4.659, 0.553> <0.621, 4.400, 0.637> 
   		<0.068, 4.813, 0.542> <0.341, 4.813, 0.542> <0.570, 4.595, 0.605> <0.568, 4.335, 0.689> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.418, 3.821, -0.597> <-0.396, 3.961, -0.558> <-0.598, 4.129, -0.440> <-0.534, 4.258, -0.411> 
   		<-0.318, 3.821, -0.724> <-0.296, 3.961, -0.685> <-0.576, 4.147, -0.527> <-0.512, 4.276, -0.498> 
   		<-0.102, 3.821, -0.848> <-0.384, 3.821, -0.848> <-0.457, 4.128, -0.707> <-0.455, 4.397, -0.625> 
   		<0.060, 3.821, -0.848> <-0.222, 3.821, -0.848> <-0.434, 4.066, -0.771> <-0.432, 4.335, -0.689> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.534, 4.258, -0.411> <-0.434, 4.461, -0.365> <-0.184, 4.752, -0.383> <0.046, 4.764, -0.383> 
   		<-0.512, 4.276, -0.498> <-0.412, 4.479, -0.452> <-0.210, 4.724, -0.351> <0.020, 4.735, -0.351> 
   		<-0.455, 4.397, -0.625> <-0.453, 4.658, -0.544> <-0.205, 4.813, -0.492> <0.067, 4.813, -0.492> 
   		<-0.432, 4.335, -0.689> <-0.430, 4.596, -0.608> <-0.205, 4.813, -0.542> <0.068, 4.813, -0.542> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.046, 4.764, -0.383> <0.281, 4.776, -0.384> <0.586, 4.525, -0.366> <0.692, 4.320, -0.412> 
   		<0.259, 4.803, -0.383> <0.494, 4.815, -0.384> <0.610, 4.516, -0.244> <0.716, 4.311, -0.291> 
   		<0.449, 4.837, -0.216> <0.421, 4.782, -0.219> <0.655, 4.459, -0.125> <0.704, 4.284, -0.124> 
   		<0.449, 4.837, 0.000> <0.421, 4.782, -0.002> <0.654, 4.460, -0.001> <0.704, 4.285, 0.000> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.274, 3.554, -1.141> <-0.270, 3.606, -1.293> <-0.092, 3.692, -1.344> <0.068, 3.680, -1.343> 
   		<-0.233, 3.284, -1.261> <-0.230, 3.336, -1.413> <-0.092, 3.412, -1.479> <0.068, 3.401, -1.477> 
   		<-0.253, 2.896, -1.392> <-0.250, 2.917, -1.497> <-0.034, 2.983, -1.561> <0.073, 2.982, -1.561> 
   		<-0.175, 2.614, -1.453> <-0.172, 2.635, -1.557> <-0.039, 2.673, -1.573> <0.068, 2.672, -1.573> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 3.680, -1.343> <0.252, 3.667, -1.341> <0.463, 3.562, -1.308> <0.459, 3.502, -1.134> 
   		<0.068, 4.055, -1.162> <0.252, 4.042, -1.160> <0.506, 3.820, -1.194> <0.502, 3.760, -1.020> 
   		<0.074, 4.822, -1.105> <0.347, 4.822, -1.105> <0.511, 4.387, -0.793> <0.508, 4.126, -0.873> 
   		<0.068, 4.813, -0.542> <0.341, 4.813, -0.542> <0.570, 4.596, -0.608> <0.568, 4.335, -0.689> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 3.551, -0.967> <-0.085, 3.562, -0.969> <-0.277, 3.507, -1.004> <-0.274, 3.554, -1.141> 
   		<0.060, 3.273, -1.072> <-0.085, 3.283, -1.074> <-0.236, 3.237, -1.124> <-0.233, 3.284, -1.261> 
   		<0.060, 2.897, -1.201> <-0.048, 2.898, -1.201> <-0.256, 2.875, -1.287> <-0.253, 2.896, -1.392> 
   		<0.060, 2.617, -1.301> <-0.048, 2.618, -1.301> <-0.178, 2.593, -1.347> <-0.175, 2.614, -1.453> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.068, 2.672, -1.573> <0.165, 2.671, -1.573> <0.284, 2.629, -1.548> <0.281, 2.609, -1.453> 
   		<0.073, 2.982, -1.561> <0.170, 2.981, -1.561> <0.383, 2.894, -1.487> <0.380, 2.874, -1.391> 
   		<0.068, 3.401, -1.477> <0.252, 3.388, -1.475> <0.420, 3.300, -1.424> <0.416, 3.240, -1.250> 
   		<0.068, 3.680, -1.343> <0.252, 3.667, -1.341> <0.463, 3.562, -1.308> <0.459, 3.502, -1.134> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.060, 2.617, -1.301> <-0.048, 2.618, -1.301> <-0.178, 2.593, -1.347> <-0.175, 2.614, -1.453> 
   		<0.163, 2.616, -1.301> <0.055, 2.617, -1.301> <-0.153, 2.502, -1.367> <-0.150, 2.524, -1.472> 
   		<0.278, 2.589, -1.351> <0.245, 2.500, -1.372> <0.049, 2.393, -1.391> <-0.048, 2.394, -1.391> 
   		<0.281, 2.609, -1.453> <0.248, 2.520, -1.473> <0.145, 2.392, -1.391> <0.048, 2.393, -1.391> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.507, 3.719, 0.889> <-0.598, 3.798, 0.957> <-0.552, 3.738, 1.171> <-0.474, 3.646, 1.241> 
   		<-0.434, 3.878, 0.975> <-0.525, 3.958, 1.044> <-0.294, 4.088, 1.230> <-0.216, 3.997, 1.301> 
   		<-0.422, 4.190, 0.820> <-0.420, 4.450, 0.736> <-0.355, 4.807, 1.054> <-0.082, 4.807, 1.054> 
   		<-0.432, 4.335, 0.689> <-0.430, 4.595, 0.605> <-0.205, 4.813, 0.542> <0.068, 4.813, 0.542> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.474, 3.646, 1.241> <-0.372, 3.527, 1.333> <-0.271, 3.407, 1.299> <-0.152, 3.302, 1.209> 
   		<-0.696, 3.345, 1.190> <-0.594, 3.225, 1.282> <-0.548, 3.159, 1.230> <-0.429, 3.055, 1.140> 
   		<-1.001, 3.325, 0.596> <-1.026, 3.223, 0.622> <-0.866, 3.012, 0.633> <-0.758, 3.009, 0.621> 
   		<-1.125, 3.191, 0.265> <-1.150, 3.088, 0.292> <-1.070, 2.968, 0.318> <-0.961, 2.965, 0.306> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.190, 3.398, 1.026> <-0.292, 3.517, 0.934> <-0.388, 3.615, 0.798> <-0.507, 3.719, 0.889> 
   		<-0.084, 3.478, 1.106> <-0.186, 3.598, 1.014> <-0.315, 3.774, 0.885> <-0.434, 3.878, 0.975> 
   		<0.031, 3.966, 0.816> <-0.251, 3.966, 0.816> <-0.424, 3.921, 0.906> <-0.422, 4.190, 0.820> 
   		<0.060, 3.821, 0.862> <-0.223, 3.821, 0.862> <-0.434, 4.066, 0.775> <-0.432, 4.335, 0.689> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.852, 3.415, 0.189> <-0.991, 3.420, 0.204> <-1.093, 3.322, 0.231> <-1.125, 3.191, 0.265> 
   		<-0.758, 3.542, 0.384> <-0.896, 3.546, 0.400> <-0.970, 3.457, 0.562> <-1.001, 3.325, 0.596> 
   		<-0.600, 3.514, 0.777> <-0.692, 3.594, 0.846> <-0.774, 3.437, 1.119> <-0.696, 3.345, 1.190> 
   		<-0.507, 3.719, 0.889> <-0.598, 3.798, 0.957> <-0.552, 3.738, 1.171> <-0.474, 3.646, 1.241> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.961, 2.965, 0.306> <-0.850, 2.961, 0.293> <-0.809, 3.074, 0.255> <-0.783, 3.180, 0.228> 
   		<-1.021, 2.952, 0.214> <-0.910, 2.948, 0.202> <-0.787, 3.165, 0.231> <-0.761, 3.270, 0.204> 
   		<-0.972, 3.028, 0.007> <-0.947, 3.132, -0.020> <-0.798, 3.357, 0.093> <-0.757, 3.412, 0.178> 
   		<-0.947, 3.132, -0.020> <-0.922, 3.235, -0.046> <-0.893, 3.361, 0.104> <-0.852, 3.415, 0.189> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.783, 3.180, 0.228> <-0.761, 3.270, 0.204> <-0.757, 3.412, 0.178> <-0.852, 3.415, 0.189> 
   		<-0.605, 3.245, 0.467> <-0.583, 3.335, 0.444> <-0.662, 3.539, 0.374> <-0.758, 3.542, 0.384> 
   		<-0.398, 3.239, 0.869> <-0.500, 3.359, 0.777> <-0.481, 3.410, 0.687> <-0.600, 3.514, 0.777> 
   		<-0.190, 3.398, 1.026> <-0.292, 3.517, 0.934> <-0.388, 3.615, 0.798> <-0.507, 3.719, 0.889> 
   	}
   }
}

//pj_eye_1
#declare _PJ_EYE_1 = object {
   union{
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.061, 5.869, -0.354> <-0.066, 5.907, -0.379> <0.004, 5.907, -0.380> <0.050, 5.910, -0.382> 
   		<-0.061, 5.832, -0.410> <-0.066, 5.871, -0.436> <0.004, 5.879, -0.423> <0.050, 5.882, -0.426> 
   		<-0.011, 5.801, -0.465> <-0.016, 5.844, -0.494> <-0.016, 5.844, -0.494> <0.050, 5.849, -0.497> 
   		<0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.061, 5.869, -0.354> <-0.066, 5.907, -0.379> <0.004, 5.907, -0.380> <0.050, 5.910, -0.382> 
   		<-0.061, 5.905, -0.297> <-0.066, 5.944, -0.323> <0.004, 5.935, -0.336> <0.050, 5.939, -0.338> 
   		<-0.011, 5.943, -0.246> <-0.017, 5.987, -0.276> <-0.017, 5.987, -0.276> <0.050, 5.992, -0.279> 
   		<0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.050, 5.910, -0.382> <0.098, 5.914, -0.384> <0.167, 5.925, -0.391> <0.172, 5.886, -0.365> 
   		<0.050, 5.939, -0.338> <0.098, 5.942, -0.340> <0.167, 5.962, -0.335> <0.172, 5.922, -0.309> 
   		<0.050, 5.992, -0.279> <0.117, 5.997, -0.282> <0.117, 5.997, -0.282> <0.122, 5.953, -0.253> 
   		<0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.050, 5.910, -0.382> <0.098, 5.914, -0.384> <0.167, 5.925, -0.391> <0.172, 5.886, -0.365> 
   		<0.050, 5.882, -0.426> <0.098, 5.885, -0.428> <0.167, 5.889, -0.447> <0.172, 5.849, -0.421> 
   		<0.050, 5.849, -0.497> <0.117, 5.854, -0.500> <0.117, 5.854, -0.500> <0.122, 5.811, -0.472> 
   		<0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.172, 5.886, -0.365> <0.177, 5.844, -0.337> <0.111, 5.830, -0.329> <0.061, 5.826, -0.326> 
   		<0.172, 5.922, -0.309> <0.177, 5.881, -0.281> <0.111, 5.860, -0.282> <0.061, 5.856, -0.280> 
   		<0.122, 5.953, -0.253> <0.128, 5.908, -0.222> <0.128, 5.908, -0.222> <0.061, 5.903, -0.219> 
   		<0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.172, 5.886, -0.365> <0.177, 5.844, -0.337> <0.111, 5.830, -0.329> <0.061, 5.826, -0.326> 
   		<0.172, 5.849, -0.421> <0.177, 5.808, -0.393> <0.111, 5.800, -0.375> <0.061, 5.796, -0.372> 
   		<0.122, 5.811, -0.472> <0.128, 5.765, -0.441> <0.128, 5.765, -0.441> <0.061, 5.761, -0.438> 
   		<0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.061, 5.826, -0.326> <0.011, 5.823, -0.324> <-0.056, 5.827, -0.326> <-0.061, 5.869, -0.354> 
   		<0.061, 5.796, -0.372> <0.011, 5.793, -0.370> <-0.056, 5.791, -0.382> <-0.061, 5.832, -0.410> 
   		<0.061, 5.761, -0.438> <-0.005, 5.756, -0.435> <-0.005, 5.756, -0.435> <-0.011, 5.801, -0.465> 
   		<0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> <0.056, 5.806, -0.469> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.061, 5.826, -0.326> <0.011, 5.823, -0.324> <-0.056, 5.827, -0.326> <-0.061, 5.869, -0.354> 
   		<0.061, 5.856, -0.280> <0.011, 5.853, -0.278> <-0.056, 5.863, -0.270> <-0.061, 5.905, -0.297> 
   		<0.061, 5.903, -0.219> <-0.005, 5.898, -0.216> <-0.005, 5.898, -0.216> <-0.011, 5.943, -0.246> 
   		<0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> <0.056, 5.948, -0.250> 
   	}
   }
}

//pj_eye_2
#declare _PJ_EYE_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.061, 5.835, 0.348> <-0.066, 5.874, 0.374> <0.004, 5.873, 0.374> <0.050, 5.877, 0.376> 
		<-0.061, 5.799, 0.404> <-0.066, 5.837, 0.430> <0.004, 5.845, 0.418> <0.050, 5.849, 0.420> 
		<-0.011, 5.768, 0.460> <-0.016, 5.811, 0.488> <-0.016, 5.811, 0.488> <0.050, 5.815, 0.492> 
		<0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.061, 5.835, 0.348> <-0.066, 5.874, 0.374> <0.004, 5.873, 0.374> <0.050, 5.877, 0.376> 
		<-0.061, 5.872, 0.292> <-0.066, 5.910, 0.317> <0.004, 5.902, 0.330> <0.050, 5.906, 0.332> 
		<-0.011, 5.910, 0.241> <-0.017, 5.954, 0.270> <-0.017, 5.954, 0.270> <0.050, 5.959, 0.273> 
		<0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.050, 5.877, 0.376> <0.098, 5.880, 0.379> <0.167, 5.892, 0.385> <0.172, 5.852, 0.359> 
		<0.050, 5.906, 0.332> <0.098, 5.909, 0.334> <0.167, 5.928, 0.329> <0.172, 5.889, 0.303> 
		<0.050, 5.959, 0.273> <0.117, 5.963, 0.276> <0.117, 5.963, 0.276> <0.122, 5.920, 0.247> 
		<0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.050, 5.877, 0.376> <0.098, 5.880, 0.379> <0.167, 5.892, 0.385> <0.172, 5.852, 0.359> 
		<0.050, 5.849, 0.420> <0.098, 5.852, 0.422> <0.167, 5.855, 0.442> <0.172, 5.816, 0.415> 
		<0.050, 5.815, 0.492> <0.117, 5.820, 0.495> <0.117, 5.820, 0.495> <0.122, 5.778, 0.466> 
		<0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.172, 5.852, 0.359> <0.177, 5.811, 0.331> <0.111, 5.797, 0.323> <0.061, 5.793, 0.320> 
		<0.172, 5.889, 0.303> <0.177, 5.847, 0.275> <0.111, 5.827, 0.277> <0.061, 5.823, 0.274> 
		<0.122, 5.920, 0.247> <0.128, 5.874, 0.217> <0.128, 5.874, 0.217> <0.061, 5.869, 0.213> 
		<0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.172, 5.852, 0.359> <0.177, 5.811, 0.331> <0.111, 5.797, 0.323> <0.061, 5.793, 0.320> 
		<0.172, 5.816, 0.415> <0.177, 5.774, 0.387> <0.111, 5.767, 0.369> <0.061, 5.763, 0.367> 
		<0.122, 5.778, 0.466> <0.128, 5.732, 0.436> <0.128, 5.732, 0.436> <0.061, 5.727, 0.432> 
		<0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.061, 5.793, 0.320> <0.011, 5.789, 0.318> <-0.056, 5.794, 0.320> <-0.061, 5.835, 0.348> 
		<0.061, 5.763, 0.367> <0.011, 5.759, 0.364> <-0.056, 5.757, 0.376> <-0.061, 5.799, 0.404> 
		<0.061, 5.727, 0.432> <-0.005, 5.722, 0.429> <-0.005, 5.722, 0.429> <-0.011, 5.768, 0.460> 
		<0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> <0.056, 5.773, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.061, 5.793, 0.320> <0.011, 5.789, 0.318> <-0.056, 5.794, 0.320> <-0.061, 5.835, 0.348> 
		<0.061, 5.823, 0.274> <0.011, 5.819, 0.272> <-0.056, 5.830, 0.264> <-0.061, 5.872, 0.292> 
		<0.061, 5.869, 0.213> <-0.005, 5.865, 0.210> <-0.005, 5.865, 0.210> <-0.011, 5.910, 0.241> 
		<0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> <0.056, 5.915, 0.244> 
	}
}
}

//pj_ear_center_1
#declare _PJ_EAR_CENTER_1 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 5.888, -0.490> <0.408, 5.972, -0.520> <0.457, 6.080, -0.560> <0.546, 6.056, -0.551> 
		<0.382, 5.857, -0.577> <0.408, 5.940, -0.607> <0.457, 6.040, -0.670> <0.546, 6.016, -0.661> 
		<0.397, 5.810, -0.692> <0.430, 5.916, -0.730> <0.430, 5.916, -0.730> <0.518, 5.892, -0.722> 
		<0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 5.888, -0.490> <0.408, 5.972, -0.520> <0.457, 6.080, -0.560> <0.546, 6.056, -0.551> 
		<0.382, 5.920, -0.403> <0.408, 6.004, -0.433> <0.457, 6.120, -0.450> <0.546, 6.096, -0.441> 
		<0.397, 5.958, -0.285> <0.430, 6.064, -0.323> <0.430, 6.064, -0.323> <0.518, 6.040, -0.315> 
		<0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.546, 6.056, -0.551> <0.635, 6.032, -0.542> <0.616, 5.916, -0.500> <0.590, 5.832, -0.470> 
		<0.546, 6.096, -0.441> <0.635, 6.072, -0.432> <0.616, 5.947, -0.413> <0.590, 5.864, -0.383> 
		<0.518, 6.040, -0.315> <0.607, 6.016, -0.306> <0.607, 6.016, -0.306> <0.575, 5.910, -0.268> 
		<0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.546, 6.056, -0.551> <0.635, 6.032, -0.542> <0.616, 5.916, -0.500> <0.590, 5.832, -0.470> 
		<0.546, 6.016, -0.661> <0.635, 5.992, -0.652> <0.616, 5.884, -0.587> <0.590, 5.801, -0.556> 
		<0.518, 5.892, -0.722> <0.607, 5.868, -0.713> <0.607, 5.868, -0.713> <0.575, 5.762, -0.674> 
		<0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 5.832, -0.470> <0.565, 5.749, -0.439> <0.515, 5.641, -0.400> <0.427, 5.665, -0.409> 
		<0.590, 5.864, -0.383> <0.565, 5.780, -0.352> <0.515, 5.681, -0.290> <0.427, 5.705, -0.299> 
		<0.575, 5.910, -0.268> <0.543, 5.805, -0.229> <0.543, 5.805, -0.229> <0.454, 5.829, -0.238> 
		<0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 5.832, -0.470> <0.565, 5.749, -0.439> <0.515, 5.641, -0.400> <0.427, 5.665, -0.409> 
		<0.590, 5.801, -0.556> <0.565, 5.717, -0.526> <0.515, 5.601, -0.510> <0.427, 5.625, -0.518> 
		<0.575, 5.762, -0.674> <0.543, 5.657, -0.636> <0.543, 5.657, -0.636> <0.454, 5.681, -0.645> 
		<0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 5.665, -0.409> <0.338, 5.689, -0.417> <0.357, 5.805, -0.460> <0.382, 5.888, -0.490> 
		<0.427, 5.625, -0.518> <0.338, 5.649, -0.527> <0.357, 5.773, -0.546> <0.382, 5.857, -0.577> 
		<0.454, 5.681, -0.645> <0.365, 5.705, -0.653> <0.365, 5.705, -0.653> <0.397, 5.810, -0.692> 
		<0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> <0.486, 5.786, -0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 5.665, -0.409> <0.338, 5.689, -0.417> <0.357, 5.805, -0.460> <0.382, 5.888, -0.490> 
		<0.427, 5.705, -0.299> <0.338, 5.729, -0.307> <0.357, 5.836, -0.373> <0.382, 5.920, -0.403> 
		<0.454, 5.829, -0.238> <0.365, 5.853, -0.247> <0.365, 5.853, -0.247> <0.397, 5.958, -0.285> 
		<0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> <0.486, 5.934, -0.276> 
	}
}
}

//pj_ear_center_2
#declare _PJ_EAR_CENTER_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 5.888, 0.490> <0.408, 5.972, 0.520> <0.457, 6.080, 0.560> <0.546, 6.056, 0.551> 
		<0.382, 5.857, 0.577> <0.408, 5.940, 0.607> <0.457, 6.040, 0.670> <0.546, 6.016, 0.661> 
		<0.397, 5.810, 0.692> <0.430, 5.916, 0.730> <0.430, 5.916, 0.730> <0.518, 5.892, 0.722> 
		<0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 5.888, 0.490> <0.408, 5.972, 0.520> <0.457, 6.080, 0.560> <0.546, 6.056, 0.551> 
		<0.382, 5.920, 0.403> <0.408, 6.004, 0.433> <0.457, 6.120, 0.450> <0.546, 6.096, 0.441> 
		<0.397, 5.958, 0.285> <0.430, 6.064, 0.323> <0.430, 6.064, 0.323> <0.518, 6.040, 0.315> 
		<0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.546, 6.056, 0.551> <0.635, 6.032, 0.542> <0.616, 5.916, 0.500> <0.590, 5.832, 0.470> 
		<0.546, 6.096, 0.441> <0.635, 6.072, 0.432> <0.616, 5.947, 0.413> <0.590, 5.864, 0.383> 
		<0.518, 6.040, 0.315> <0.607, 6.016, 0.306> <0.607, 6.016, 0.306> <0.575, 5.910, 0.268> 
		<0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.546, 6.056, 0.551> <0.635, 6.032, 0.542> <0.616, 5.916, 0.500> <0.590, 5.832, 0.470> 
		<0.546, 6.016, 0.661> <0.635, 5.992, 0.652> <0.616, 5.884, 0.587> <0.590, 5.801, 0.556> 
		<0.518, 5.892, 0.722> <0.607, 5.868, 0.713> <0.607, 5.868, 0.713> <0.575, 5.762, 0.674> 
		<0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 5.832, 0.470> <0.565, 5.749, 0.439> <0.515, 5.641, 0.400> <0.427, 5.665, 0.409> 
		<0.590, 5.864, 0.383> <0.565, 5.780, 0.352> <0.515, 5.681, 0.290> <0.427, 5.705, 0.299> 
		<0.575, 5.910, 0.268> <0.543, 5.805, 0.229> <0.543, 5.805, 0.229> <0.454, 5.829, 0.238> 
		<0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 5.832, 0.470> <0.565, 5.749, 0.439> <0.515, 5.641, 0.400> <0.427, 5.665, 0.409> 
		<0.590, 5.801, 0.556> <0.565, 5.717, 0.526> <0.515, 5.601, 0.510> <0.427, 5.625, 0.518> 
		<0.575, 5.762, 0.674> <0.543, 5.657, 0.636> <0.543, 5.657, 0.636> <0.454, 5.681, 0.645> 
		<0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 5.665, 0.409> <0.338, 5.689, 0.417> <0.357, 5.805, 0.460> <0.382, 5.888, 0.490> 
		<0.427, 5.625, 0.518> <0.338, 5.649, 0.527> <0.357, 5.773, 0.546> <0.382, 5.857, 0.577> 
		<0.454, 5.681, 0.645> <0.365, 5.705, 0.653> <0.365, 5.705, 0.653> <0.397, 5.810, 0.692> 
		<0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> <0.486, 5.786, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 5.665, 0.409> <0.338, 5.689, 0.417> <0.357, 5.805, 0.460> <0.382, 5.888, 0.490> 
		<0.427, 5.705, 0.299> <0.338, 5.729, 0.307> <0.357, 5.836, 0.373> <0.382, 5.920, 0.403> 
		<0.454, 5.829, 0.238> <0.365, 5.853, 0.247> <0.365, 5.853, 0.247> <0.397, 5.958, 0.285> 
		<0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> <0.486, 5.934, 0.276> 
	}
}
}

//pj_ear_1
#declare _PJ_EAR_1 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 5.856, -0.470> <0.540, 5.962, -0.511> <0.427, 6.171, -0.591> <0.541, 6.143, -0.580> 
		<0.509, 5.813, -0.580> <0.540, 5.920, -0.621> <0.427, 6.112, -0.745> <0.541, 6.084, -0.734> 
		<0.348, 5.787, -0.770> <0.391, 5.935, -0.827> <0.391, 5.935, -0.827> <0.505, 5.907, -0.817> 
		<0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 5.856, -0.470> <0.540, 5.962, -0.511> <0.427, 6.171, -0.591> <0.541, 6.143, -0.580> 
		<0.509, 5.898, -0.360> <0.540, 6.004, -0.401> <0.427, 6.230, -0.437> <0.541, 6.202, -0.427> 
		<0.348, 6.005, -0.201> <0.391, 6.154, -0.258> <0.391, 6.154, -0.258> <0.505, 6.126, -0.247> 
		<0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.541, 6.143, -0.580> <0.667, 6.111, -0.568> <0.643, 5.948, -0.506> <0.609, 5.831, -0.461> 
		<0.541, 6.202, -0.427> <0.667, 6.170, -0.414> <0.643, 5.995, -0.384> <0.609, 5.878, -0.339> 
		<0.505, 6.126, -0.247> <0.630, 6.094, -0.235> <0.630, 6.094, -0.235> <0.588, 5.945, -0.178> 
		<0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.541, 6.143, -0.580> <0.667, 6.111, -0.568> <0.643, 5.948, -0.506> <0.609, 5.831, -0.461> 
		<0.541, 6.084, -0.734> <0.667, 6.052, -0.722> <0.643, 5.902, -0.627> <0.609, 5.784, -0.582> 
		<0.505, 5.907, -0.817> <0.630, 5.875, -0.804> <0.630, 5.875, -0.804> <0.588, 5.727, -0.747> 
		<0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.609, 5.831, -0.461> <0.575, 5.713, -0.416> <0.509, 5.561, -0.357> <0.383, 5.593, -0.369> 
		<0.609, 5.878, -0.339> <0.575, 5.760, -0.294> <0.509, 5.620, -0.203> <0.383, 5.652, -0.215> 
		<0.588, 5.945, -0.178> <0.545, 5.797, -0.121> <0.545, 5.797, -0.121> <0.419, 5.828, -0.133> 
		<0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.609, 5.831, -0.461> <0.575, 5.713, -0.416> <0.509, 5.561, -0.357> <0.383, 5.593, -0.369> 
		<0.609, 5.784, -0.582> <0.575, 5.667, -0.537> <0.509, 5.502, -0.511> <0.383, 5.534, -0.523> 
		<0.588, 5.727, -0.747> <0.545, 5.578, -0.690> <0.545, 5.578, -0.690> <0.419, 5.610, -0.702> 
		<0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.383, 5.593, -0.369> <0.269, 5.621, -0.380> <0.479, 5.749, -0.429> <0.509, 5.856, -0.470> 
		<0.383, 5.534, -0.523> <0.269, 5.562, -0.534> <0.479, 5.707, -0.540> <0.509, 5.813, -0.580> 
		<0.419, 5.610, -0.702> <0.305, 5.638, -0.713> <0.305, 5.638, -0.713> <0.348, 5.787, -0.770> 
		<0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> <0.462, 5.758, -0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.383, 5.593, -0.369> <0.269, 5.621, -0.380> <0.479, 5.749, -0.429> <0.509, 5.856, -0.470> 
		<0.383, 5.652, -0.215> <0.269, 5.680, -0.226> <0.479, 5.792, -0.319> <0.509, 5.898, -0.360> 
		<0.419, 5.828, -0.133> <0.305, 5.857, -0.144> <0.305, 5.857, -0.144> <0.348, 6.005, -0.201> 
		<0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> <0.462, 5.977, -0.190> 
	}
}
}

//pj_ear_2
#declare _PJ_EAR_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 5.856, 0.470> <0.540, 5.962, 0.511> <0.427, 6.171, 0.591> <0.541, 6.143, 0.580> 
		<0.509, 5.813, 0.580> <0.540, 5.920, 0.621> <0.427, 6.112, 0.745> <0.541, 6.084, 0.734> 
		<0.348, 5.787, 0.770> <0.391, 5.935, 0.827> <0.391, 5.935, 0.827> <0.505, 5.907, 0.817> 
		<0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 5.856, 0.470> <0.540, 5.962, 0.511> <0.427, 6.171, 0.591> <0.541, 6.143, 0.580> 
		<0.509, 5.898, 0.360> <0.540, 6.004, 0.401> <0.427, 6.230, 0.437> <0.541, 6.202, 0.427> 
		<0.348, 6.005, 0.201> <0.391, 6.154, 0.258> <0.391, 6.154, 0.258> <0.505, 6.126, 0.247> 
		<0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.541, 6.143, 0.580> <0.667, 6.111, 0.568> <0.643, 5.948, 0.506> <0.609, 5.831, 0.461> 
		<0.541, 6.202, 0.427> <0.667, 6.170, 0.414> <0.643, 5.995, 0.384> <0.609, 5.878, 0.339> 
		<0.505, 6.126, 0.247> <0.630, 6.094, 0.235> <0.630, 6.094, 0.235> <0.588, 5.945, 0.178> 
		<0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.541, 6.143, 0.580> <0.667, 6.111, 0.568> <0.643, 5.948, 0.506> <0.609, 5.831, 0.461> 
		<0.541, 6.084, 0.734> <0.667, 6.052, 0.722> <0.643, 5.902, 0.627> <0.609, 5.784, 0.582> 
		<0.505, 5.907, 0.817> <0.630, 5.875, 0.804> <0.630, 5.875, 0.804> <0.588, 5.727, 0.747> 
		<0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.609, 5.831, 0.461> <0.575, 5.713, 0.416> <0.509, 5.561, 0.357> <0.383, 5.593, 0.369> 
		<0.609, 5.878, 0.339> <0.575, 5.760, 0.294> <0.509, 5.620, 0.203> <0.383, 5.652, 0.215> 
		<0.588, 5.945, 0.178> <0.545, 5.797, 0.121> <0.545, 5.797, 0.121> <0.419, 5.828, 0.133> 
		<0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.609, 5.831, 0.461> <0.575, 5.713, 0.416> <0.509, 5.561, 0.357> <0.383, 5.593, 0.369> 
		<0.609, 5.784, 0.582> <0.575, 5.667, 0.537> <0.509, 5.502, 0.511> <0.383, 5.534, 0.523> 
		<0.588, 5.727, 0.747> <0.545, 5.578, 0.690> <0.545, 5.578, 0.690> <0.419, 5.610, 0.702> 
		<0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.383, 5.593, 0.369> <0.269, 5.621, 0.380> <0.479, 5.749, 0.429> <0.509, 5.856, 0.470> 
		<0.383, 5.534, 0.523> <0.269, 5.562, 0.534> <0.479, 5.707, 0.540> <0.509, 5.813, 0.580> 
		<0.419, 5.610, 0.702> <0.305, 5.638, 0.713> <0.305, 5.638, 0.713> <0.348, 5.787, 0.770> 
		<0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> <0.462, 5.758, 0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.383, 5.593, 0.369> <0.269, 5.621, 0.380> <0.479, 5.749, 0.429> <0.509, 5.856, 0.470> 
		<0.383, 5.652, 0.215> <0.269, 5.680, 0.226> <0.479, 5.792, 0.319> <0.509, 5.898, 0.360> 
		<0.419, 5.828, 0.133> <0.305, 5.857, 0.144> <0.305, 5.857, 0.144> <0.348, 6.005, 0.201> 
		<0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> <0.462, 5.977, 0.190> 
	}
}
}

//pj_nose
#declare _PJ_NOSE = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 5.716, 0.000> <-0.579, 5.751, 0.000> <-0.530, 5.799, 0.000> <-0.497, 5.835, 0.000> 
		<-0.544, 5.716, -0.052> <-0.579, 5.751, -0.052> <-0.530, 5.799, -0.034> <-0.497, 5.835, -0.034> 
		<-0.505, 5.761, -0.078> <-0.529, 5.785, -0.078> <-0.529, 5.785, -0.078> <-0.494, 5.824, -0.078> 
		<-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.544, 5.716, 0.000> <-0.579, 5.751, 0.000> <-0.530, 5.799, 0.000> <-0.497, 5.835, 0.000> 
		<-0.544, 5.716, 0.052> <-0.579, 5.751, 0.052> <-0.530, 5.799, 0.034> <-0.497, 5.835, 0.034> 
		<-0.505, 5.761, 0.078> <-0.529, 5.785, 0.078> <-0.529, 5.785, 0.078> <-0.494, 5.824, 0.078> 
		<-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.497, 5.835, 0.000> <-0.482, 5.851, 0.000> <-0.454, 5.848, 0.000> <-0.439, 5.832, 0.000> 
		<-0.497, 5.835, 0.034> <-0.482, 5.851, 0.034> <-0.454, 5.848, 0.034> <-0.439, 5.832, 0.034> 
		<-0.494, 5.824, 0.078> <-0.471, 5.849, 0.078> <-0.471, 5.849, 0.078> <-0.447, 5.824, 0.078> 
		<-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.497, 5.835, 0.000> <-0.482, 5.851, 0.000> <-0.454, 5.848, 0.000> <-0.439, 5.832, 0.000> 
		<-0.497, 5.835, -0.034> <-0.482, 5.851, -0.034> <-0.454, 5.848, -0.034> <-0.439, 5.832, -0.034> 
		<-0.494, 5.824, -0.078> <-0.471, 5.849, -0.078> <-0.471, 5.849, -0.078> <-0.447, 5.824, -0.078> 
		<-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.439, 5.832, 0.000> <-0.412, 5.805, 0.000> <-0.377, 5.767, 0.000> <-0.402, 5.738, 0.000> 
		<-0.439, 5.832, 0.034> <-0.412, 5.805, 0.034> <-0.377, 5.767, 0.046> <-0.402, 5.738, 0.046> 
		<-0.447, 5.824, 0.078> <-0.415, 5.792, 0.078> <-0.415, 5.792, 0.078> <-0.438, 5.766, 0.078> 
		<-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.439, 5.832, 0.000> <-0.412, 5.805, 0.000> <-0.377, 5.767, 0.000> <-0.402, 5.738, 0.000> 
		<-0.439, 5.832, -0.034> <-0.412, 5.805, -0.034> <-0.377, 5.767, -0.046> <-0.402, 5.738, -0.046> 
		<-0.447, 5.824, -0.078> <-0.415, 5.792, -0.078> <-0.415, 5.792, -0.078> <-0.438, 5.766, -0.078> 
		<-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.402, 5.738, 0.000> <-0.439, 5.698, 0.000> <-0.506, 5.677, 0.000> <-0.544, 5.716, 0.000> 
		<-0.402, 5.738, -0.046> <-0.439, 5.698, -0.046> <-0.506, 5.677, -0.052> <-0.544, 5.716, -0.052> 
		<-0.438, 5.766, -0.078> <-0.473, 5.728, -0.078> <-0.473, 5.728, -0.078> <-0.505, 5.761, -0.078> 
		<-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> <-0.470, 5.799, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.402, 5.738, 0.000> <-0.439, 5.698, 0.000> <-0.506, 5.677, 0.000> <-0.544, 5.716, 0.000> 
		<-0.402, 5.738, 0.046> <-0.439, 5.698, 0.046> <-0.506, 5.677, 0.052> <-0.544, 5.716, 0.052> 
		<-0.438, 5.766, 0.078> <-0.473, 5.728, 0.078> <-0.473, 5.728, 0.078> <-0.505, 5.761, 0.078> 
		<-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> <-0.470, 5.799, 0.078> 
	}
}
}

//face_anime
#declare _FACE_ANIME = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 4.963, 0.000> <-0.338, 4.955, 0.000> <-0.327, 4.948, 0.000> <-0.320, 4.942, 0.000> 
		<-0.341, 4.963, 0.033> <-0.338, 4.955, 0.033> <-0.327, 4.948, 0.031> <-0.320, 4.942, 0.031> 
		<-0.312, 4.944, 0.070> <-0.317, 4.946, 0.040> <-0.317, 4.946, 0.040> <-0.308, 4.938, 0.071> 
		<-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 4.963, 0.000> <-0.338, 4.955, 0.000> <-0.327, 4.948, 0.000> <-0.320, 4.942, 0.000> 
		<-0.341, 4.963, -0.033> <-0.338, 4.955, -0.033> <-0.327, 4.948, -0.031> <-0.320, 4.942, -0.031> 
		<-0.312, 4.944, -0.070> <-0.317, 4.946, -0.040> <-0.317, 4.946, -0.040> <-0.308, 4.938, -0.071> 
		<-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 4.942, 0.000> <-0.328, 4.935, 0.000> <-0.334, 4.922, 0.000> <-0.339, 4.913, 0.000> 
		<-0.320, 4.942, 0.031> <-0.328, 4.935, 0.031> <-0.334, 4.922, 0.033> <-0.339, 4.913, 0.033> 
		<-0.308, 4.938, 0.071> <-0.319, 4.931, 0.040> <-0.319, 4.931, 0.040> <-0.314, 4.930, 0.071> 
		<-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 4.942, 0.000> <-0.328, 4.935, 0.000> <-0.334, 4.922, 0.000> <-0.339, 4.913, 0.000> 
		<-0.320, 4.942, -0.031> <-0.328, 4.935, -0.031> <-0.334, 4.922, -0.033> <-0.339, 4.913, -0.033> 
		<-0.308, 4.938, -0.071> <-0.319, 4.931, -0.040> <-0.319, 4.931, -0.040> <-0.314, 4.930, -0.071> 
		<-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> <-0.303, 4.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 4.942, 0.000> <-0.320, 4.942, -0.031> <-0.308, 4.938, -0.071> <-0.303, 4.937, -0.101> 
		<-0.320, 4.942, 0.031> <-0.320, 4.942, 0.000> <-0.288, 4.952, -0.015> <-0.283, 4.950, -0.045> 
		<-0.308, 4.938, 0.071> <-0.288, 4.952, 0.015> <-0.288, 4.952, 0.015> <-0.283, 4.950, 0.045> 
		<-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.339, 4.913, 0.000> <-0.339, 4.913, -0.033> <-0.314, 4.930, -0.071> <-0.303, 4.937, -0.101> 
		<-0.339, 4.913, 0.033> <-0.339, 4.913, 0.000> <-0.303, 4.926, -0.011> <-0.293, 4.933, -0.041> 
		<-0.314, 4.930, 0.071> <-0.303, 4.926, 0.011> <-0.303, 4.926, 0.011> <-0.293, 4.933, 0.041> 
		<-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 4.928, 0.316> <-0.037, 4.910, 0.297> <-0.040, 4.893, 0.266> <-0.042, 4.879, 0.244> 
		<-0.070, 4.919, 0.306> <-0.073, 4.901, 0.287> <-0.074, 4.898, 0.278> <-0.076, 4.885, 0.255> 
		<-0.122, 4.907, 0.300> <-0.090, 4.896, 0.288> <-0.090, 4.896, 0.288> <-0.123, 4.887, 0.270> 
		<-0.156, 4.898, 0.283> <-0.156, 4.898, 0.283> <-0.156, 4.898, 0.283> <-0.156, 4.898, 0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 4.879, -0.244> <-0.040, 4.893, -0.266> <-0.037, 4.910, -0.297> <-0.034, 4.928, -0.316> 
		<-0.076, 4.885, -0.255> <-0.074, 4.898, -0.278> <-0.073, 4.901, -0.287> <-0.070, 4.919, -0.306> 
		<-0.123, 4.887, -0.270> <-0.090, 4.896, -0.288> <-0.090, 4.896, -0.288> <-0.122, 4.907, -0.300> 
		<-0.156, 4.898, -0.283> <-0.156, 4.898, -0.283> <-0.156, 4.898, -0.283> <-0.156, 4.898, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 4.963, 0.000> <-0.341, 4.963, -0.033> <-0.312, 4.944, -0.070> <-0.303, 4.937, -0.101> 
		<-0.341, 4.963, 0.033> <-0.341, 4.963, 0.000> <-0.302, 4.940, -0.010> <-0.293, 4.933, -0.041> 
		<-0.312, 4.944, 0.070> <-0.302, 4.940, 0.010> <-0.302, 4.940, 0.010> <-0.293, 4.933, 0.041> 
		<-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.328, 5.069, 0.071> <-0.345, 5.068, 0.044> <-0.411, 5.068, 0.022> <-0.410, 5.068, 0.000> 
		<-0.332, 5.053, 0.050> <-0.349, 5.053, 0.022> <-0.401, 5.041, 0.022> <-0.401, 5.041, -0.000> 
		<-0.341, 5.017, 0.027> <-0.362, 5.031, 0.027> <-0.362, 5.031, 0.027> <-0.362, 5.031, 0.000> 
		<-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.410, 5.068, 0.000> <-0.410, 5.068, -0.032> <-0.345, 5.068, -0.044> <-0.328, 5.069, -0.071> 
		<-0.401, 5.041, -0.000> <-0.401, 5.041, -0.032> <-0.349, 5.053, -0.022> <-0.332, 5.053, -0.050> 
		<-0.362, 5.031, 0.000> <-0.362, 5.031, -0.026> <-0.362, 5.031, -0.026> <-0.341, 5.017, -0.027> 
		<-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> <-0.341, 5.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.410, 5.068, 0.000> <-0.410, 5.068, -0.032> <-0.345, 5.068, -0.044> <-0.328, 5.069, -0.071> 
		<-0.411, 5.068, 0.022> <-0.410, 5.068, -0.009> <-0.339, 5.093, -0.009> <-0.321, 5.093, -0.037> 
		<-0.345, 5.068, 0.044> <-0.339, 5.093, 0.009> <-0.339, 5.093, 0.009> <-0.321, 5.093, 0.037> 
		<-0.328, 5.069, 0.071> <-0.328, 5.069, 0.071> <-0.328, 5.069, 0.071> <-0.328, 5.069, 0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.341, 5.017, 0.000> <-0.341, 5.001, 0.000> <-0.345, 4.979, 0.000> <-0.341, 4.963, 0.000> 
		<-0.341, 5.017, 0.027> <-0.341, 5.001, 0.027> <-0.345, 4.979, 0.033> <-0.341, 4.963, 0.033> 
		<-0.332, 5.053, 0.050> <-0.327, 4.999, 0.055> <-0.318, 4.984, 0.064> <-0.312, 4.944, 0.070> 
		<-0.328, 5.069, 0.071> <-0.323, 5.014, 0.076> <-0.309, 4.977, 0.095> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.339, 4.913, 0.000> <-0.319, 4.899, 0.000> <-0.325, 4.857, -0.000> <-0.309, 4.839, 0.000> 
		<-0.339, 4.913, 0.033> <-0.319, 4.899, 0.033> <-0.325, 4.857, 0.031> <-0.309, 4.839, 0.031> 
		<-0.314, 4.930, 0.071> <-0.310, 4.906, 0.074> <-0.317, 4.870, 0.077> <-0.304, 4.850, 0.072> 
		<-0.303, 4.937, 0.101> <-0.299, 4.913, 0.105> <-0.310, 4.876, 0.107> <-0.297, 4.857, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, 4.839, 0.000> <-0.294, 4.821, 0.000> <-0.266, 4.800, 0.001> <-0.243, 4.798, 0.001> 
		<-0.309, 4.839, 0.031> <-0.294, 4.821, 0.031> <-0.266, 4.800, 0.023> <-0.243, 4.798, 0.023> 
		<-0.304, 4.850, 0.072> <-0.286, 4.825, 0.065> <-0.252, 4.806, 0.049> <-0.221, 4.802, 0.047> 
		<-0.297, 4.857, 0.102> <-0.279, 4.832, 0.095> <-0.243, 4.811, 0.068> <-0.211, 4.807, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 4.798, 0.001> <-0.187, 4.792, 0.001> <-0.113, 4.808, 0.000> <-0.057, 4.813, 0.000> 
		<-0.243, 4.798, 0.023> <-0.187, 4.792, 0.023> <-0.113, 4.808, 0.027> <-0.057, 4.813, 0.027> 
		<-0.221, 4.802, 0.047> <-0.173, 4.796, 0.044> <-0.101, 4.815, 0.056> <-0.054, 4.821, 0.062> 
		<-0.211, 4.807, 0.066> <-0.163, 4.801, 0.064> <-0.100, 4.821, 0.082> <-0.052, 4.827, 0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 4.879, 0.244> <-0.064, 4.874, 0.231> <-0.096, 4.867, 0.218> <-0.115, 4.860, 0.203> 
		<-0.076, 4.885, 0.255> <-0.098, 4.879, 0.243> <-0.132, 4.871, 0.221> <-0.152, 4.864, 0.205> 
		<-0.123, 4.887, 0.270> <-0.152, 4.880, 0.255> <-0.180, 4.866, 0.231> <-0.203, 4.862, 0.207> 
		<-0.156, 4.898, 0.283> <-0.185, 4.891, 0.268> <-0.215, 4.879, 0.235> <-0.237, 4.874, 0.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 4.860, 0.203> <-0.136, 4.853, 0.187> <-0.160, 4.841, 0.161> <-0.175, 4.832, 0.139> 
		<-0.152, 4.864, 0.205> <-0.173, 4.857, 0.189> <-0.191, 4.843, 0.156> <-0.207, 4.835, 0.134> 
		<-0.203, 4.862, 0.207> <-0.216, 4.859, 0.193> <-0.238, 4.857, 0.171> <-0.247, 4.855, 0.155> 
		<-0.237, 4.874, 0.210> <-0.250, 4.872, 0.196> <-0.263, 4.877, 0.173> <-0.272, 4.874, 0.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 4.832, 0.139> <-0.189, 4.824, 0.119> <-0.200, 4.813, 0.089> <-0.211, 4.807, 0.066> 
		<-0.207, 4.835, 0.134> <-0.221, 4.827, 0.114> <-0.232, 4.817, 0.090> <-0.243, 4.811, 0.068> 
		<-0.247, 4.855, 0.155> <-0.256, 4.852, 0.138> <-0.275, 4.836, 0.113> <-0.279, 4.832, 0.095> 
		<-0.272, 4.874, 0.156> <-0.281, 4.872, 0.140> <-0.292, 4.861, 0.120> <-0.297, 4.857, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 4.798, 0.001> <-0.243, 4.798, -0.022> <-0.221, 4.802, -0.047> <-0.211, 4.807, -0.066> 
		<-0.266, 4.800, 0.001> <-0.266, 4.800, -0.022> <-0.252, 4.806, -0.048> <-0.243, 4.811, -0.068> 
		<-0.294, 4.821, 0.000> <-0.294, 4.821, -0.031> <-0.286, 4.825, -0.065> <-0.279, 4.832, -0.095> 
		<-0.309, 4.839, 0.000> <-0.309, 4.839, -0.031> <-0.304, 4.850, -0.072> <-0.297, 4.857, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 4.807, -0.066> <-0.200, 4.813, -0.089> <-0.189, 4.824, -0.119> <-0.175, 4.832, -0.139> 
		<-0.243, 4.811, -0.068> <-0.232, 4.816, -0.090> <-0.221, 4.827, -0.114> <-0.207, 4.835, -0.134> 
		<-0.279, 4.832, -0.095> <-0.275, 4.836, -0.113> <-0.256, 4.852, -0.138> <-0.247, 4.855, -0.155> 
		<-0.297, 4.857, -0.102> <-0.292, 4.861, -0.120> <-0.281, 4.872, -0.140> <-0.272, 4.874, -0.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 4.832, -0.139> <-0.160, 4.841, -0.161> <-0.136, 4.853, -0.187> <-0.115, 4.860, -0.203> 
		<-0.207, 4.835, -0.134> <-0.191, 4.843, -0.156> <-0.173, 4.857, -0.189> <-0.152, 4.864, -0.205> 
		<-0.247, 4.855, -0.155> <-0.238, 4.857, -0.171> <-0.216, 4.859, -0.193> <-0.203, 4.862, -0.207> 
		<-0.272, 4.874, -0.156> <-0.263, 4.877, -0.173> <-0.250, 4.872, -0.196> <-0.237, 4.874, -0.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 4.860, -0.203> <-0.096, 4.867, -0.218> <-0.064, 4.874, -0.231> <-0.042, 4.879, -0.244> 
		<-0.152, 4.864, -0.205> <-0.132, 4.871, -0.221> <-0.098, 4.879, -0.243> <-0.076, 4.885, -0.255> 
		<-0.203, 4.862, -0.207> <-0.180, 4.866, -0.231> <-0.152, 4.880, -0.255> <-0.123, 4.887, -0.270> 
		<-0.237, 4.874, -0.210> <-0.215, 4.879, -0.235> <-0.185, 4.891, -0.268> <-0.156, 4.898, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 4.860, -0.203> <-0.096, 4.867, -0.218> <-0.064, 4.874, -0.231> <-0.042, 4.879, -0.244> 
		<-0.136, 4.853, -0.187> <-0.117, 4.860, -0.202> <-0.066, 4.865, -0.216> <-0.044, 4.870, -0.228> 
		<-0.160, 4.841, -0.161> <-0.119, 4.837, -0.167> <-0.084, 4.853, -0.192> <-0.046, 4.860, -0.207> 
		<-0.175, 4.832, -0.139> <-0.134, 4.829, -0.146> <-0.085, 4.848, -0.175> <-0.047, 4.854, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 5.030, 0.401> <-0.023, 4.998, 0.378> <-0.029, 4.955, 0.345> <-0.034, 4.928, 0.316> 
		<-0.054, 5.034, 0.403> <-0.060, 5.002, 0.380> <-0.057, 4.971, 0.362> <-0.062, 4.943, 0.334> 
		<-0.104, 5.040, 0.411> <-0.103, 5.019, 0.405> <-0.119, 4.970, 0.367> <-0.106, 4.955, 0.356> 
		<-0.141, 5.044, 0.407> <-0.140, 5.023, 0.401> <-0.141, 4.993, 0.386> <-0.128, 4.979, 0.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 4.879, 0.244> <-0.044, 4.870, 0.228> <-0.046, 4.860, 0.207> <-0.047, 4.854, 0.190> 
		<-0.064, 4.874, 0.231> <-0.066, 4.865, 0.216> <-0.084, 4.853, 0.192> <-0.085, 4.848, 0.175> 
		<-0.096, 4.867, 0.218> <-0.117, 4.860, 0.202> <-0.119, 4.837, 0.167> <-0.134, 4.829, 0.146> 
		<-0.115, 4.860, 0.203> <-0.136, 4.853, 0.187> <-0.160, 4.841, 0.161> <-0.175, 4.832, 0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, 4.854, 0.190> <-0.049, 4.844, 0.161> <-0.051, 4.834, 0.120> <-0.052, 4.827, 0.089> 
		<-0.085, 4.848, 0.175> <-0.087, 4.837, 0.145> <-0.098, 4.828, 0.113> <-0.100, 4.821, 0.082> 
		<-0.134, 4.829, 0.146> <-0.148, 4.821, 0.126> <-0.152, 4.807, 0.086> <-0.163, 4.801, 0.064> 
		<-0.175, 4.832, 0.139> <-0.189, 4.824, 0.119> <-0.200, 4.813, 0.089> <-0.211, 4.807, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.057, 4.813, 0.000> <-0.057, 4.813, -0.027> <-0.054, 4.821, -0.062> <-0.052, 4.827, -0.089> 
		<-0.113, 4.808, 0.000> <-0.113, 4.808, -0.027> <-0.101, 4.815, -0.056> <-0.100, 4.821, -0.082> 
		<-0.187, 4.792, 0.001> <-0.187, 4.792, -0.022> <-0.173, 4.796, -0.044> <-0.163, 4.801, -0.064> 
		<-0.243, 4.798, 0.001> <-0.243, 4.798, -0.022> <-0.221, 4.802, -0.047> <-0.211, 4.807, -0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.052, 4.827, -0.089> <-0.051, 4.834, -0.120> <-0.049, 4.844, -0.161> <-0.047, 4.854, -0.190> 
		<-0.100, 4.821, -0.082> <-0.098, 4.828, -0.113> <-0.087, 4.837, -0.145> <-0.085, 4.848, -0.175> 
		<-0.163, 4.801, -0.064> <-0.152, 4.807, -0.086> <-0.148, 4.821, -0.126> <-0.134, 4.829, -0.146> 
		<-0.211, 4.807, -0.066> <-0.200, 4.813, -0.089> <-0.189, 4.824, -0.119> <-0.175, 4.832, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 4.928, -0.316> <-0.029, 4.955, -0.345> <-0.023, 4.998, -0.378> <-0.017, 5.030, -0.401> 
		<-0.062, 4.943, -0.334> <-0.057, 4.971, -0.362> <-0.060, 5.002, -0.380> <-0.054, 5.034, -0.403> 
		<-0.106, 4.955, -0.356> <-0.119, 4.970, -0.367> <-0.103, 5.019, -0.405> <-0.104, 5.040, -0.411> 
		<-0.128, 4.979, -0.374> <-0.141, 4.993, -0.386> <-0.140, 5.023, -0.401> <-0.141, 5.044, -0.407> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 5.030, -0.401> <-0.013, 5.050, -0.416> <-0.008, 5.079, -0.435> <-0.001, 5.103, -0.443> 
		<-0.054, 5.034, -0.403> <-0.050, 5.055, -0.418> <-0.047, 5.082, -0.425> <-0.041, 5.105, -0.433> 
		<-0.104, 5.040, -0.411> <-0.104, 5.060, -0.416> <-0.095, 5.089, -0.422> <-0.095, 5.109, -0.424> 
		<-0.141, 5.044, -0.407> <-0.141, 5.064, -0.412> <-0.133, 5.091, -0.407> <-0.132, 5.111, -0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 5.103, -0.443> <0.006, 5.129, -0.453> <0.018, 5.166, -0.457> <0.027, 5.194, -0.462> 
		<-0.041, 5.105, -0.433> <-0.034, 5.132, -0.443> <-0.030, 5.177, -0.448> <-0.022, 5.205, -0.453> 
		<-0.095, 5.109, -0.424> <-0.094, 5.145, -0.430> <-0.095, 5.178, -0.439> <-0.089, 5.214, -0.446> 
		<-0.132, 5.111, -0.409> <-0.131, 5.147, -0.414> <-0.141, 5.195, -0.426> <-0.135, 5.230, -0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 5.194, -0.462> <0.035, 5.221, -0.467> <0.047, 5.257, -0.472> <0.056, 5.285, -0.476> 
		<-0.022, 5.205, -0.453> <-0.013, 5.232, -0.458> <0.003, 5.281, -0.468> <0.012, 5.308, -0.472> 
		<-0.089, 5.214, -0.446> <-0.083, 5.255, -0.455> <-0.072, 5.304, -0.473> <-0.050, 5.340, -0.479> 
		<-0.135, 5.230, -0.434> <-0.129, 5.272, -0.442> <-0.113, 5.327, -0.457> <-0.091, 5.364, -0.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.056, 5.285, -0.476> <0.064, 5.311, -0.480> <0.076, 5.346, -0.485> <0.084, 5.372, -0.489> 
		<0.012, 5.308, -0.472> <0.020, 5.335, -0.476> <0.053, 5.373, -0.479> <0.062, 5.399, -0.483> 
		<-0.050, 5.340, -0.479> <-0.027, 5.376, -0.484> <-0.004, 5.405, -0.482> <0.027, 5.435, -0.483> 
		<-0.091, 5.364, -0.462> <-0.068, 5.399, -0.467> <-0.020, 5.432, -0.466> <0.010, 5.462, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 5.645, -0.080> <-0.129, 5.598, -0.078> <-0.201, 5.542, -0.074> <-0.241, 5.488, -0.072> 
		<-0.084, 5.647, -0.056> <-0.132, 5.599, -0.054> <-0.202, 5.543, -0.053> <-0.242, 5.489, -0.051> 
		<-0.097, 5.650, -0.025> <-0.142, 5.601, -0.025> <-0.211, 5.543, -0.022> <-0.247, 5.488, -0.022> 
		<-0.097, 5.650, -0.001> <-0.142, 5.601, -0.001> <-0.211, 5.543, -0.001> <-0.247, 5.488, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.241, 5.488, -0.072> <-0.265, 5.456, -0.071> <-0.279, 5.403, -0.068> <-0.286, 5.365, -0.067> 
		<-0.242, 5.489, -0.051> <-0.265, 5.457, -0.049> <-0.280, 5.403, -0.047> <-0.287, 5.365, -0.047> 
		<-0.247, 5.488, -0.022> <-0.270, 5.455, -0.022> <-0.281, 5.400, -0.028> <-0.290, 5.361, -0.028> 
		<-0.247, 5.488, -0.001> <-0.270, 5.455, -0.000> <-0.281, 5.400, 0.000> <-0.290, 5.361, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.286, 5.365, -0.067> <-0.300, 5.296, -0.067> <-0.284, 5.205, -0.078> <-0.311, 5.132, -0.070> 
		<-0.287, 5.365, -0.047> <-0.301, 5.296, -0.047> <-0.290, 5.208, -0.058> <-0.317, 5.136, -0.050> 
		<-0.290, 5.361, -0.028> <-0.305, 5.296, -0.029> <-0.302, 5.204, -0.022> <-0.327, 5.142, -0.022> 
		<-0.290, 5.361, 0.000> <-0.305, 5.296, -0.000> <-0.302, 5.204, -0.001> <-0.327, 5.142, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.311, 5.132, -0.070> <-0.315, 5.120, -0.069> <-0.328, 5.078, -0.071> <-0.328, 5.069, -0.071> 
		<-0.317, 5.136, -0.050> <-0.321, 5.123, -0.048> <-0.346, 5.077, -0.043> <-0.345, 5.068, -0.044> 
		<-0.327, 5.142, -0.022> <-0.340, 5.111, -0.022> <-0.341, 5.094, -0.032> <-0.410, 5.068, -0.032> 
		<-0.327, 5.142, -0.001> <-0.340, 5.111, -0.001> <-0.341, 5.094, -0.001> <-0.410, 5.068, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.328, 5.069, -0.071> <-0.323, 5.014, -0.076> <-0.309, 4.977, -0.095> <-0.303, 4.937, -0.101> 
		<-0.332, 5.053, -0.050> <-0.327, 4.999, -0.055> <-0.318, 4.984, -0.064> <-0.312, 4.944, -0.070> 
		<-0.341, 5.017, -0.027> <-0.341, 5.001, -0.027> <-0.345, 4.979, -0.033> <-0.341, 4.963, -0.033> 
		<-0.341, 5.017, 0.000> <-0.341, 5.001, 0.000> <-0.345, 4.979, 0.000> <-0.341, 4.963, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.303, 4.937, -0.101> <-0.299, 4.913, -0.105> <-0.310, 4.876, -0.107> <-0.297, 4.857, -0.102> 
		<-0.314, 4.930, -0.071> <-0.310, 4.906, -0.074> <-0.317, 4.870, -0.077> <-0.304, 4.850, -0.072> 
		<-0.339, 4.913, -0.033> <-0.319, 4.899, -0.033> <-0.325, 4.857, -0.031> <-0.309, 4.839, -0.031> 
		<-0.339, 4.913, 0.000> <-0.319, 4.899, 0.000> <-0.325, 4.857, -0.000> <-0.309, 4.839, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 5.636, -0.198> <-0.120, 5.589, -0.195> <-0.201, 5.534, -0.200> <-0.245, 5.479, -0.188> 
		<-0.071, 5.645, -0.163> <-0.125, 5.598, -0.161> <-0.206, 5.541, -0.166> <-0.250, 5.486, -0.154> 
		<-0.075, 5.643, -0.115> <-0.123, 5.595, -0.113> <-0.201, 5.540, -0.109> <-0.241, 5.486, -0.107> 
		<-0.080, 5.645, -0.080> <-0.129, 5.598, -0.078> <-0.201, 5.542, -0.074> <-0.241, 5.488, -0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 5.479, -0.188> <-0.270, 5.448, -0.181> <-0.288, 5.401, -0.140> <-0.285, 5.360, -0.139> 
		<-0.250, 5.486, -0.154> <-0.275, 5.455, -0.148> <-0.291, 5.406, -0.119> <-0.289, 5.365, -0.118> 
		<-0.241, 5.486, -0.107> <-0.264, 5.454, -0.105> <-0.278, 5.403, -0.089> <-0.286, 5.365, -0.089> 
		<-0.241, 5.488, -0.072> <-0.265, 5.456, -0.071> <-0.279, 5.403, -0.068> <-0.286, 5.365, -0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.285, 5.360, -0.139> <-0.272, 5.161, -0.134> <-0.274, 5.152, -0.137> <-0.287, 5.117, -0.139> 
		<-0.289, 5.365, -0.118> <-0.275, 5.165, -0.113> <-0.280, 5.154, -0.116> <-0.292, 5.119, -0.118> 
		<-0.286, 5.365, -0.089> <-0.299, 5.296, -0.089> <-0.277, 5.201, -0.099> <-0.305, 5.128, -0.091> 
		<-0.286, 5.365, -0.067> <-0.300, 5.296, -0.067> <-0.284, 5.205, -0.078> <-0.311, 5.132, -0.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.287, 5.117, -0.139> <-0.293, 5.099, -0.140> <-0.300, 5.104, -0.158> <-0.309, 5.071, -0.157> 
		<-0.292, 5.119, -0.118> <-0.299, 5.101, -0.119> <-0.305, 5.104, -0.132> <-0.314, 5.070, -0.131> 
		<-0.305, 5.128, -0.091> <-0.309, 5.116, -0.090> <-0.314, 5.078, -0.093> <-0.314, 5.069, -0.093> 
		<-0.311, 5.132, -0.070> <-0.315, 5.120, -0.069> <-0.328, 5.078, -0.071> <-0.328, 5.069, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, 5.071, -0.157> <-0.322, 5.026, -0.156> <-0.306, 4.971, -0.147> <-0.298, 4.929, -0.146> 
		<-0.314, 5.070, -0.131> <-0.327, 5.026, -0.130> <-0.307, 4.972, -0.133> <-0.299, 4.930, -0.133> 
		<-0.314, 5.069, -0.093> <-0.309, 5.014, -0.098> <-0.305, 4.974, -0.108> <-0.299, 4.934, -0.114> 
		<-0.328, 5.069, -0.071> <-0.323, 5.014, -0.076> <-0.309, 4.977, -0.095> <-0.303, 4.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.298, 4.929, -0.146> <-0.294, 4.911, -0.146> <-0.286, 4.886, -0.157> <-0.272, 4.874, -0.156> 
		<-0.299, 4.930, -0.133> <-0.295, 4.912, -0.133> <-0.295, 4.883, -0.141> <-0.281, 4.872, -0.140> 
		<-0.299, 4.934, -0.114> <-0.296, 4.910, -0.118> <-0.306, 4.880, -0.125> <-0.292, 4.861, -0.120> 
		<-0.303, 4.937, -0.101> <-0.299, 4.913, -0.105> <-0.310, 4.876, -0.107> <-0.297, 4.857, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 5.571, -0.373> <-0.086, 5.528, -0.374> <-0.158, 5.479, -0.372> <-0.195, 5.427, -0.376> 
		<-0.052, 5.601, -0.326> <-0.099, 5.558, -0.327> <-0.186, 5.500, -0.323> <-0.222, 5.448, -0.326> 
		<-0.058, 5.622, -0.252> <-0.112, 5.575, -0.249> <-0.192, 5.523, -0.258> <-0.236, 5.468, -0.247> 
		<-0.066, 5.636, -0.198> <-0.120, 5.589, -0.195> <-0.201, 5.534, -0.200> <-0.245, 5.479, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.195, 5.427, -0.376> <-0.219, 5.392, -0.378> <-0.244, 5.347, -0.393> <-0.235, 5.290, -0.391> 
		<-0.222, 5.448, -0.326> <-0.247, 5.413, -0.329> <-0.278, 5.376, -0.327> <-0.269, 5.319, -0.325> 
		<-0.236, 5.468, -0.247> <-0.261, 5.436, -0.240> <-0.276, 5.383, -0.217> <-0.273, 5.342, -0.216> 
		<-0.245, 5.479, -0.188> <-0.270, 5.448, -0.181> <-0.288, 5.401, -0.140> <-0.285, 5.360, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 5.113, -0.352> <-0.235, 5.092, -0.350> <-0.265, 5.075, -0.380> <-0.265, 5.054, -0.375> 
		<-0.253, 5.114, -0.326> <-0.256, 5.093, -0.324> <-0.290, 5.080, -0.356> <-0.290, 5.059, -0.352> 
		<-0.257, 5.112, -0.278> <-0.274, 5.085, -0.282> <-0.276, 5.081, -0.304> <-0.285, 5.067, -0.299> 
		<-0.265, 5.113, -0.246> <-0.282, 5.086, -0.249> <-0.283, 5.083, -0.270> <-0.291, 5.069, -0.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.054, -0.375> <-0.265, 5.016, -0.367> <-0.252, 4.972, -0.334> <-0.232, 4.943, -0.317> 
		<-0.290, 5.059, -0.352> <-0.290, 5.020, -0.344> <-0.277, 4.964, -0.311> <-0.257, 4.935, -0.294> 
		<-0.285, 5.067, -0.299> <-0.298, 5.044, -0.292> <-0.293, 4.971, -0.264> <-0.281, 4.929, -0.252> 
		<-0.291, 5.069, -0.266> <-0.305, 5.046, -0.258> <-0.305, 4.968, -0.232> <-0.294, 4.926, -0.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 4.943, -0.317> <-0.217, 4.922, -0.304> <-0.181, 4.907, -0.292> <-0.156, 4.898, -0.283> 
		<-0.257, 4.935, -0.294> <-0.242, 4.914, -0.281> <-0.210, 4.899, -0.277> <-0.185, 4.891, -0.268> 
		<-0.281, 4.929, -0.252> <-0.275, 4.907, -0.246> <-0.237, 4.887, -0.237> <-0.215, 4.879, -0.235> 
		<-0.294, 4.926, -0.220> <-0.288, 4.904, -0.214> <-0.259, 4.882, -0.212> <-0.237, 4.874, -0.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.010, 5.462, -0.467> <-0.020, 5.432, -0.466> <-0.068, 5.399, -0.467> <-0.091, 5.364, -0.462> 
		<-0.012, 5.497, -0.447> <-0.042, 5.467, -0.445> <-0.105, 5.420, -0.453> <-0.128, 5.385, -0.447> 
		<-0.028, 5.547, -0.410> <-0.075, 5.504, -0.411> <-0.138, 5.464, -0.409> <-0.174, 5.412, -0.412> 
		<-0.039, 5.571, -0.373> <-0.086, 5.528, -0.374> <-0.158, 5.479, -0.372> <-0.195, 5.427, -0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.091, 5.364, -0.462> <-0.113, 5.327, -0.457> <-0.129, 5.272, -0.442> <-0.135, 5.230, -0.434> 
		<-0.128, 5.385, -0.447> <-0.150, 5.348, -0.442> <-0.162, 5.284, -0.433> <-0.169, 5.243, -0.425> 
		<-0.174, 5.412, -0.412> <-0.199, 5.376, -0.415> <-0.228, 5.334, -0.424> <-0.220, 5.276, -0.422> 
		<-0.195, 5.427, -0.376> <-0.219, 5.392, -0.378> <-0.244, 5.347, -0.393> <-0.235, 5.290, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.135, 5.230, -0.434> <-0.141, 5.195, -0.426> <-0.131, 5.147, -0.414> <-0.132, 5.111, -0.409> 
		<-0.169, 5.243, -0.425> <-0.175, 5.207, -0.417> <-0.164, 5.148, -0.402> <-0.165, 5.112, -0.397> 
		<-0.220, 5.276, -0.422> <-0.212, 5.223, -0.421> <-0.204, 5.167, -0.382> <-0.210, 5.113, -0.378> 
		<-0.235, 5.290, -0.391> <-0.227, 5.236, -0.390> <-0.225, 5.167, -0.355> <-0.232, 5.113, -0.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.132, 5.111, -0.409> <-0.133, 5.091, -0.407> <-0.141, 5.064, -0.412> <-0.141, 5.044, -0.407> 
		<-0.165, 5.112, -0.397> <-0.165, 5.092, -0.394> <-0.180, 5.067, -0.408> <-0.179, 5.048, -0.403> 
		<-0.210, 5.113, -0.378> <-0.213, 5.092, -0.377> <-0.237, 5.071, -0.406> <-0.237, 5.050, -0.402> 
		<-0.232, 5.113, -0.352> <-0.235, 5.092, -0.350> <-0.265, 5.075, -0.380> <-0.265, 5.054, -0.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, 5.044, -0.407> <-0.140, 5.023, -0.401> <-0.141, 4.993, -0.386> <-0.128, 4.979, -0.374> 
		<-0.179, 5.048, -0.403> <-0.178, 5.026, -0.397> <-0.172, 4.982, -0.368> <-0.159, 4.968, -0.357> 
		<-0.237, 5.050, -0.402> <-0.237, 5.012, -0.394> <-0.225, 4.980, -0.358> <-0.205, 4.952, -0.341> 
		<-0.265, 5.054, -0.375> <-0.265, 5.016, -0.367> <-0.252, 4.972, -0.334> <-0.232, 4.943, -0.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 4.979, -0.374> <-0.106, 4.955, -0.356> <-0.062, 4.943, -0.334> <-0.034, 4.928, -0.316> 
		<-0.159, 4.968, -0.357> <-0.138, 4.945, -0.339> <-0.099, 4.934, -0.323> <-0.070, 4.919, -0.306> 
		<-0.205, 4.952, -0.341> <-0.191, 4.931, -0.329> <-0.147, 4.916, -0.310> <-0.122, 4.907, -0.300> 
		<-0.232, 4.943, -0.317> <-0.217, 4.922, -0.304> <-0.181, 4.907, -0.292> <-0.156, 4.898, -0.283> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 4.979, 0.374> <-0.159, 4.968, 0.357> <-0.205, 4.952, 0.341> <-0.232, 4.943, 0.317> 
		<-0.141, 4.993, 0.386> <-0.172, 4.982, 0.368> <-0.225, 4.980, 0.358> <-0.252, 4.972, 0.334> 
		<-0.140, 5.023, 0.401> <-0.178, 5.026, 0.397> <-0.237, 5.012, 0.394> <-0.265, 5.016, 0.367> 
		<-0.141, 5.044, 0.407> <-0.179, 5.048, 0.403> <-0.237, 5.050, 0.402> <-0.265, 5.054, 0.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 4.943, 0.317> <-0.257, 4.935, 0.294> <-0.281, 4.929, 0.252> <-0.294, 4.926, 0.220> 
		<-0.252, 4.972, 0.334> <-0.277, 4.964, 0.311> <-0.293, 4.971, 0.264> <-0.305, 4.968, 0.232> 
		<-0.265, 5.016, 0.367> <-0.290, 5.020, 0.344> <-0.298, 5.044, 0.292> <-0.305, 5.046, 0.258> 
		<-0.265, 5.054, 0.375> <-0.290, 5.059, 0.352> <-0.285, 5.067, 0.299> <-0.291, 5.069, 0.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.294, 4.926, 0.220> <-0.302, 4.924, 0.199> <-0.296, 4.927, 0.168> <-0.298, 4.929, 0.146> 
		<-0.305, 4.968, 0.232> <-0.313, 4.966, 0.211> <-0.304, 4.969, 0.169> <-0.306, 4.971, 0.147> 
		<-0.305, 5.046, 0.258> <-0.312, 5.049, 0.226> <-0.316, 5.026, 0.188> <-0.322, 5.026, 0.156> 
		<-0.291, 5.069, 0.266> <-0.298, 5.071, 0.233> <-0.303, 5.071, 0.189> <-0.309, 5.071, 0.157> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.298, 4.929, 0.146> <-0.299, 4.930, 0.133> <-0.299, 4.934, 0.114> <-0.303, 4.937, 0.101> 
		<-0.306, 4.971, 0.147> <-0.307, 4.972, 0.133> <-0.305, 4.974, 0.108> <-0.309, 4.977, 0.095> 
		<-0.322, 5.026, 0.156> <-0.327, 5.026, 0.130> <-0.309, 5.014, 0.098> <-0.323, 5.014, 0.076> 
		<-0.309, 5.071, 0.157> <-0.314, 5.070, 0.131> <-0.314, 5.069, 0.093> <-0.328, 5.069, 0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.298, 4.929, -0.146> <-0.296, 4.927, -0.168> <-0.302, 4.924, -0.199> <-0.294, 4.926, -0.220> 
		<-0.306, 4.971, -0.147> <-0.304, 4.969, -0.169> <-0.313, 4.966, -0.211> <-0.305, 4.968, -0.232> 
		<-0.322, 5.026, -0.156> <-0.316, 5.026, -0.188> <-0.312, 5.049, -0.226> <-0.305, 5.046, -0.258> 
		<-0.309, 5.071, -0.157> <-0.303, 5.071, -0.189> <-0.298, 5.071, -0.233> <-0.291, 5.069, -0.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.113, -0.246> <-0.282, 5.086, -0.249> <-0.283, 5.083, -0.270> <-0.291, 5.069, -0.266> 
		<-0.273, 5.113, -0.214> <-0.290, 5.086, -0.218> <-0.289, 5.086, -0.238> <-0.298, 5.071, -0.233> 
		<-0.278, 5.113, -0.171> <-0.285, 5.095, -0.172> <-0.294, 5.104, -0.190> <-0.303, 5.071, -0.189> 
		<-0.287, 5.117, -0.139> <-0.293, 5.099, -0.140> <-0.300, 5.104, -0.158> <-0.309, 5.071, -0.157> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.294, 4.926, -0.220> <-0.288, 4.904, -0.214> <-0.259, 4.882, -0.212> <-0.237, 4.874, -0.210> 
		<-0.302, 4.924, -0.199> <-0.296, 4.903, -0.193> <-0.272, 4.880, -0.198> <-0.250, 4.872, -0.196> 
		<-0.296, 4.927, -0.168> <-0.293, 4.909, -0.168> <-0.277, 4.888, -0.174> <-0.263, 4.877, -0.173> 
		<-0.298, 4.929, -0.146> <-0.294, 4.911, -0.146> <-0.286, 4.886, -0.157> <-0.272, 4.874, -0.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 4.928, 0.316> <-0.070, 4.919, 0.306> <-0.122, 4.907, 0.300> <-0.156, 4.898, 0.283> 
		<-0.062, 4.943, 0.334> <-0.099, 4.934, 0.323> <-0.147, 4.916, 0.310> <-0.181, 4.907, 0.292> 
		<-0.106, 4.955, 0.356> <-0.138, 4.945, 0.339> <-0.191, 4.931, 0.329> <-0.217, 4.922, 0.304> 
		<-0.128, 4.979, 0.374> <-0.159, 4.968, 0.357> <-0.205, 4.952, 0.341> <-0.232, 4.943, 0.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.156, 4.898, 0.283> <-0.185, 4.891, 0.268> <-0.215, 4.879, 0.235> <-0.237, 4.874, 0.210> 
		<-0.181, 4.907, 0.292> <-0.210, 4.899, 0.277> <-0.237, 4.887, 0.237> <-0.259, 4.882, 0.212> 
		<-0.217, 4.922, 0.304> <-0.242, 4.914, 0.281> <-0.275, 4.907, 0.246> <-0.288, 4.904, 0.214> 
		<-0.232, 4.943, 0.317> <-0.257, 4.935, 0.294> <-0.281, 4.929, 0.252> <-0.294, 4.926, 0.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.237, 4.874, 0.210> <-0.250, 4.872, 0.196> <-0.263, 4.877, 0.173> <-0.272, 4.874, 0.156> 
		<-0.259, 4.882, 0.212> <-0.272, 4.880, 0.198> <-0.277, 4.888, 0.174> <-0.286, 4.886, 0.157> 
		<-0.288, 4.904, 0.214> <-0.296, 4.903, 0.193> <-0.293, 4.909, 0.168> <-0.294, 4.911, 0.146> 
		<-0.294, 4.926, 0.220> <-0.302, 4.924, 0.199> <-0.296, 4.927, 0.168> <-0.298, 4.929, 0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.272, 4.874, 0.156> <-0.281, 4.872, 0.140> <-0.292, 4.861, 0.120> <-0.297, 4.857, 0.102> 
		<-0.286, 4.886, 0.157> <-0.295, 4.883, 0.141> <-0.306, 4.880, 0.125> <-0.310, 4.876, 0.107> 
		<-0.294, 4.911, 0.146> <-0.295, 4.912, 0.133> <-0.296, 4.910, 0.118> <-0.299, 4.913, 0.105> 
		<-0.298, 4.929, 0.146> <-0.299, 4.930, 0.133> <-0.299, 4.934, 0.114> <-0.303, 4.937, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 5.030, 0.401> <-0.054, 5.034, 0.403> <-0.104, 5.040, 0.411> <-0.141, 5.044, 0.407> 
		<-0.013, 5.050, 0.416> <-0.050, 5.055, 0.418> <-0.104, 5.060, 0.416> <-0.141, 5.064, 0.412> 
		<-0.008, 5.079, 0.435> <-0.047, 5.082, 0.425> <-0.095, 5.089, 0.422> <-0.133, 5.091, 0.407> 
		<-0.001, 5.103, 0.443> <-0.041, 5.105, 0.433> <-0.095, 5.109, 0.424> <-0.132, 5.111, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, 5.044, 0.407> <-0.179, 5.048, 0.403> <-0.237, 5.050, 0.402> <-0.265, 5.054, 0.375> 
		<-0.141, 5.064, 0.412> <-0.180, 5.067, 0.408> <-0.237, 5.071, 0.406> <-0.265, 5.075, 0.380> 
		<-0.133, 5.091, 0.407> <-0.165, 5.092, 0.394> <-0.213, 5.092, 0.377> <-0.235, 5.092, 0.350> 
		<-0.132, 5.111, 0.409> <-0.165, 5.112, 0.397> <-0.210, 5.113, 0.378> <-0.232, 5.113, 0.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.054, 0.375> <-0.290, 5.059, 0.352> <-0.285, 5.067, 0.299> <-0.291, 5.069, 0.266> 
		<-0.265, 5.075, 0.380> <-0.290, 5.080, 0.356> <-0.276, 5.081, 0.304> <-0.283, 5.083, 0.270> 
		<-0.235, 5.092, 0.350> <-0.256, 5.093, 0.324> <-0.274, 5.085, 0.282> <-0.282, 5.086, 0.249> 
		<-0.232, 5.113, 0.352> <-0.253, 5.114, 0.326> <-0.257, 5.112, 0.278> <-0.265, 5.113, 0.246> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.291, 5.069, 0.266> <-0.298, 5.071, 0.233> <-0.303, 5.071, 0.189> <-0.309, 5.071, 0.157> 
		<-0.283, 5.083, 0.270> <-0.289, 5.086, 0.238> <-0.294, 5.104, 0.190> <-0.300, 5.104, 0.158> 
		<-0.282, 5.086, 0.249> <-0.290, 5.086, 0.218> <-0.285, 5.095, 0.172> <-0.293, 5.099, 0.140> 
		<-0.265, 5.113, 0.246> <-0.273, 5.113, 0.214> <-0.278, 5.113, 0.171> <-0.287, 5.117, 0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, 5.071, 0.157> <-0.314, 5.070, 0.131> <-0.314, 5.069, 0.093> <-0.328, 5.069, 0.071> 
		<-0.300, 5.104, 0.158> <-0.305, 5.104, 0.132> <-0.314, 5.078, 0.093> <-0.328, 5.078, 0.071> 
		<-0.293, 5.099, 0.140> <-0.299, 5.101, 0.119> <-0.309, 5.116, 0.090> <-0.315, 5.120, 0.069> 
		<-0.287, 5.117, 0.139> <-0.292, 5.119, 0.118> <-0.305, 5.128, 0.091> <-0.311, 5.132, 0.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.328, 5.069, 0.071> <-0.345, 5.068, 0.044> <-0.411, 5.068, 0.022> <-0.410, 5.068, 0.000> 
		<-0.328, 5.078, 0.071> <-0.346, 5.077, 0.043> <-0.341, 5.094, 0.022> <-0.341, 5.094, -0.001> 
		<-0.315, 5.120, 0.069> <-0.321, 5.123, 0.048> <-0.340, 5.111, 0.021> <-0.340, 5.111, -0.001> 
		<-0.311, 5.132, 0.070> <-0.317, 5.136, 0.049> <-0.327, 5.142, 0.021> <-0.327, 5.142, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 5.194, 0.462> <-0.022, 5.205, 0.453> <-0.089, 5.214, 0.446> <-0.135, 5.230, 0.434> 
		<0.035, 5.221, 0.467> <-0.013, 5.232, 0.458> <-0.083, 5.255, 0.455> <-0.129, 5.272, 0.442> 
		<0.047, 5.257, 0.472> <0.003, 5.281, 0.468> <-0.072, 5.304, 0.473> <-0.113, 5.327, 0.457> 
		<0.056, 5.285, 0.476> <0.012, 5.308, 0.472> <-0.050, 5.340, 0.479> <-0.091, 5.364, 0.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.135, 5.230, 0.434> <-0.169, 5.243, 0.425> <-0.220, 5.276, 0.422> <-0.235, 5.290, 0.391> 
		<-0.129, 5.272, 0.442> <-0.162, 5.284, 0.433> <-0.228, 5.334, 0.424> <-0.244, 5.347, 0.393> 
		<-0.113, 5.327, 0.457> <-0.150, 5.348, 0.442> <-0.199, 5.376, 0.415> <-0.219, 5.392, 0.378> 
		<-0.091, 5.364, 0.462> <-0.128, 5.385, 0.447> <-0.174, 5.412, 0.412> <-0.195, 5.427, 0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.290, 0.391> <-0.269, 5.319, 0.325> <-0.273, 5.342, 0.216> <-0.285, 5.360, 0.139> 
		<-0.244, 5.347, 0.393> <-0.278, 5.376, 0.327> <-0.276, 5.383, 0.217> <-0.288, 5.401, 0.140> 
		<-0.219, 5.392, 0.378> <-0.247, 5.413, 0.329> <-0.261, 5.436, 0.240> <-0.270, 5.448, 0.181> 
		<-0.195, 5.427, 0.376> <-0.222, 5.448, 0.326> <-0.236, 5.468, 0.247> <-0.245, 5.479, 0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.285, 5.360, 0.139> <-0.289, 5.365, 0.118> <-0.286, 5.365, 0.089> <-0.286, 5.365, 0.067> 
		<-0.288, 5.401, 0.140> <-0.291, 5.406, 0.119> <-0.278, 5.403, 0.089> <-0.279, 5.403, 0.068> 
		<-0.270, 5.448, 0.181> <-0.275, 5.455, 0.148> <-0.264, 5.454, 0.105> <-0.265, 5.456, 0.071> 
		<-0.245, 5.479, 0.188> <-0.250, 5.486, 0.154> <-0.241, 5.486, 0.107> <-0.241, 5.488, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.286, 5.365, 0.067> <-0.287, 5.365, 0.047> <-0.289, 5.361, 0.023> <-0.290, 5.361, 0.000> 
		<-0.279, 5.403, 0.068> <-0.280, 5.403, 0.047> <-0.280, 5.400, 0.023> <-0.281, 5.400, 0.000> 
		<-0.265, 5.456, 0.071> <-0.265, 5.457, 0.049> <-0.270, 5.455, 0.021> <-0.270, 5.455, -0.000> 
		<-0.241, 5.488, 0.072> <-0.242, 5.489, 0.050> <-0.247, 5.488, 0.021> <-0.247, 5.488, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 5.650, -0.001> <-0.142, 5.601, -0.001> <-0.211, 5.543, -0.001> <-0.247, 5.488, -0.001> 
		<-0.097, 5.650, 0.024> <-0.142, 5.601, 0.024> <-0.211, 5.543, 0.021> <-0.247, 5.488, 0.021> 
		<-0.084, 5.647, 0.055> <-0.132, 5.599, 0.053> <-0.202, 5.543, 0.053> <-0.242, 5.489, 0.050> 
		<-0.080, 5.645, 0.080> <-0.129, 5.598, 0.078> <-0.201, 5.542, 0.074> <-0.241, 5.488, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.290, 5.361, 0.000> <-0.305, 5.296, -0.000> <-0.302, 5.204, -0.001> <-0.327, 5.142, -0.001> 
		<-0.289, 5.361, 0.023> <-0.304, 5.296, 0.023> <-0.302, 5.204, 0.021> <-0.327, 5.142, 0.021> 
		<-0.287, 5.365, 0.047> <-0.301, 5.296, 0.047> <-0.290, 5.208, 0.057> <-0.317, 5.136, 0.049> 
		<-0.286, 5.365, 0.067> <-0.300, 5.296, 0.067> <-0.284, 5.205, 0.078> <-0.311, 5.132, 0.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.287, 5.117, -0.139> <-0.276, 5.132, -0.155> <-0.239, 5.131, -0.147> <-0.219, 5.137, -0.151> 
		<-0.274, 5.152, -0.137> <-0.263, 5.167, -0.153> <-0.236, 5.188, -0.150> <-0.216, 5.194, -0.154> 
		<-0.272, 5.161, -0.134> <-0.261, 5.133, -0.152> <-0.234, 5.280, -0.152> <-0.211, 5.270, -0.158> 
		<-0.285, 5.360, -0.139> <-0.275, 5.332, -0.157> <-0.231, 5.337, -0.155> <-0.208, 5.327, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 5.113, -0.352> <-0.219, 5.134, -0.335> <-0.185, 5.127, -0.338> <-0.165, 5.133, -0.332> 
		<-0.225, 5.167, -0.355> <-0.212, 5.187, -0.338> <-0.184, 5.168, -0.347> <-0.164, 5.174, -0.341> 
		<-0.227, 5.236, -0.390> <-0.219, 5.220, -0.367> <-0.185, 5.235, -0.361> <-0.163, 5.228, -0.352> 
		<-0.235, 5.290, -0.391> <-0.227, 5.273, -0.369> <-0.184, 5.275, -0.370> <-0.162, 5.269, -0.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 5.113, -0.352> <-0.219, 5.134, -0.335> <-0.185, 5.127, -0.338> <-0.165, 5.133, -0.332> 
		<-0.253, 5.114, -0.326> <-0.240, 5.134, -0.309> <-0.193, 5.127, -0.310> <-0.172, 5.132, -0.304> 
		<-0.257, 5.112, -0.278> <-0.242, 5.128, -0.293> <-0.204, 5.125, -0.269> <-0.182, 5.131, -0.267> 
		<-0.265, 5.113, -0.246> <-0.250, 5.129, -0.260> <-0.213, 5.126, -0.241> <-0.190, 5.131, -0.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.113, -0.246> <-0.250, 5.129, -0.260> <-0.213, 5.126, -0.241> <-0.190, 5.131, -0.239> 
		<-0.273, 5.113, -0.214> <-0.258, 5.129, -0.229> <-0.221, 5.126, -0.214> <-0.198, 5.132, -0.213> 
		<-0.278, 5.113, -0.171> <-0.268, 5.129, -0.187> <-0.231, 5.129, -0.174> <-0.210, 5.135, -0.177> 
		<-0.287, 5.117, -0.139> <-0.276, 5.132, -0.155> <-0.239, 5.131, -0.147> <-0.219, 5.137, -0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.290, -0.391> <-0.227, 5.273, -0.369> <-0.184, 5.275, -0.370> <-0.162, 5.269, -0.361> 
		<-0.269, 5.319, -0.325> <-0.261, 5.302, -0.302> <-0.198, 5.293, -0.310> <-0.175, 5.287, -0.301> 
		<-0.273, 5.342, -0.216> <-0.262, 5.314, -0.234> <-0.217, 5.320, -0.215> <-0.194, 5.310, -0.221> 
		<-0.285, 5.360, -0.139> <-0.275, 5.332, -0.157> <-0.231, 5.337, -0.155> <-0.208, 5.327, -0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.056, 5.285, 0.476> <0.012, 5.308, 0.472> <-0.050, 5.340, 0.479> <-0.091, 5.364, 0.462> 
		<0.064, 5.311, 0.480> <0.020, 5.335, 0.476> <-0.027, 5.376, 0.484> <-0.068, 5.399, 0.467> 
		<0.076, 5.346, 0.485> <0.053, 5.373, 0.479> <-0.004, 5.405, 0.482> <-0.020, 5.432, 0.466> 
		<0.084, 5.372, 0.489> <0.062, 5.399, 0.483> <0.027, 5.435, 0.483> <0.010, 5.462, 0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.091, 5.364, 0.462> <-0.128, 5.385, 0.447> <-0.174, 5.412, 0.412> <-0.195, 5.427, 0.376> 
		<-0.068, 5.399, 0.467> <-0.105, 5.420, 0.453> <-0.138, 5.464, 0.409> <-0.158, 5.479, 0.372> 
		<-0.020, 5.432, 0.466> <-0.042, 5.467, 0.445> <-0.075, 5.504, 0.411> <-0.086, 5.528, 0.374> 
		<0.010, 5.462, 0.467> <-0.012, 5.497, 0.447> <-0.028, 5.547, 0.410> <-0.039, 5.571, 0.373> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.195, 5.427, 0.376> <-0.222, 5.448, 0.326> <-0.236, 5.468, 0.247> <-0.245, 5.479, 0.188> 
		<-0.158, 5.479, 0.372> <-0.186, 5.500, 0.323> <-0.192, 5.523, 0.258> <-0.201, 5.534, 0.200> 
		<-0.086, 5.528, 0.374> <-0.099, 5.558, 0.327> <-0.112, 5.575, 0.249> <-0.120, 5.589, 0.195> 
		<-0.039, 5.571, 0.373> <-0.052, 5.601, 0.326> <-0.058, 5.622, 0.252> <-0.066, 5.636, 0.198> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 5.479, 0.188> <-0.250, 5.486, 0.154> <-0.241, 5.486, 0.107> <-0.241, 5.488, 0.072> 
		<-0.201, 5.534, 0.200> <-0.206, 5.541, 0.166> <-0.201, 5.540, 0.109> <-0.201, 5.542, 0.074> 
		<-0.120, 5.589, 0.195> <-0.125, 5.598, 0.161> <-0.123, 5.595, 0.113> <-0.129, 5.598, 0.078> 
		<-0.066, 5.636, 0.198> <-0.071, 5.645, 0.163> <-0.075, 5.643, 0.115> <-0.080, 5.645, 0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.286, 5.365, 0.067> <-0.300, 5.296, 0.067> <-0.284, 5.205, 0.078> <-0.311, 5.132, 0.070> 
		<-0.286, 5.365, 0.089> <-0.299, 5.296, 0.089> <-0.278, 5.201, 0.099> <-0.305, 5.128, 0.091> 
		<-0.289, 5.365, 0.118> <-0.275, 5.165, 0.113> <-0.280, 5.154, 0.116> <-0.292, 5.119, 0.118> 
		<-0.285, 5.360, 0.139> <-0.272, 5.161, 0.134> <-0.274, 5.152, 0.137> <-0.287, 5.117, 0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.290, 0.391> <-0.227, 5.236, 0.390> <-0.225, 5.167, 0.355> <-0.232, 5.113, 0.352> 
		<-0.220, 5.276, 0.422> <-0.212, 5.223, 0.421> <-0.204, 5.167, 0.382> <-0.210, 5.113, 0.378> 
		<-0.169, 5.243, 0.425> <-0.175, 5.207, 0.417> <-0.164, 5.148, 0.402> <-0.165, 5.112, 0.397> 
		<-0.135, 5.230, 0.434> <-0.141, 5.195, 0.426> <-0.131, 5.147, 0.414> <-0.132, 5.111, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.135, 5.230, 0.434> <-0.141, 5.195, 0.426> <-0.131, 5.147, 0.414> <-0.132, 5.111, 0.409> 
		<-0.089, 5.214, 0.446> <-0.095, 5.178, 0.439> <-0.094, 5.145, 0.430> <-0.095, 5.109, 0.424> 
		<-0.022, 5.205, 0.453> <-0.030, 5.177, 0.448> <-0.034, 5.132, 0.443> <-0.041, 5.105, 0.433> 
		<0.027, 5.194, 0.462> <0.018, 5.166, 0.457> <0.006, 5.129, 0.453> <-0.001, 5.103, 0.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.287, 5.117, 0.139> <-0.276, 5.132, 0.155> <-0.239, 5.131, 0.147> <-0.219, 5.137, 0.151> 
		<-0.274, 5.152, 0.137> <-0.263, 5.167, 0.153> <-0.236, 5.188, 0.150> <-0.216, 5.194, 0.154> 
		<-0.272, 5.161, 0.134> <-0.261, 5.132, 0.152> <-0.234, 5.280, 0.152> <-0.211, 5.270, 0.158> 
		<-0.285, 5.360, 0.139> <-0.275, 5.331, 0.157> <-0.231, 5.337, 0.155> <-0.208, 5.327, 0.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 5.113, 0.352> <-0.224, 5.138, 0.335> <-0.185, 5.127, 0.338> <-0.165, 5.133, 0.332> 
		<-0.225, 5.167, 0.355> <-0.217, 5.192, 0.338> <-0.184, 5.168, 0.347> <-0.164, 5.174, 0.341> 
		<-0.227, 5.236, 0.390> <-0.218, 5.216, 0.367> <-0.185, 5.235, 0.361> <-0.163, 5.228, 0.352> 
		<-0.235, 5.290, 0.391> <-0.226, 5.270, 0.369> <-0.184, 5.275, 0.370> <-0.162, 5.269, 0.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 5.113, 0.352> <-0.224, 5.138, 0.335> <-0.185, 5.127, 0.338> <-0.165, 5.133, 0.332> 
		<-0.253, 5.114, 0.326> <-0.245, 5.138, 0.309> <-0.193, 5.127, 0.310> <-0.172, 5.132, 0.304> 
		<-0.257, 5.112, 0.278> <-0.247, 5.131, 0.276> <-0.204, 5.125, 0.269> <-0.182, 5.131, 0.267> 
		<-0.265, 5.113, 0.246> <-0.255, 5.132, 0.243> <-0.213, 5.126, 0.241> <-0.190, 5.131, 0.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.113, 0.246> <-0.255, 5.132, 0.243> <-0.213, 5.126, 0.241> <-0.190, 5.131, 0.239> 
		<-0.273, 5.113, 0.214> <-0.263, 5.132, 0.212> <-0.221, 5.126, 0.214> <-0.198, 5.132, 0.213> 
		<-0.278, 5.113, 0.171> <-0.268, 5.129, 0.187> <-0.231, 5.129, 0.174> <-0.210, 5.135, 0.177> 
		<-0.287, 5.117, 0.139> <-0.276, 5.132, 0.155> <-0.239, 5.131, 0.147> <-0.219, 5.137, 0.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.290, 0.391> <-0.226, 5.270, 0.369> <-0.184, 5.275, 0.370> <-0.162, 5.269, 0.361> 
		<-0.269, 5.319, 0.325> <-0.260, 5.299, 0.302> <-0.198, 5.293, 0.310> <-0.175, 5.287, 0.301> 
		<-0.273, 5.342, 0.216> <-0.262, 5.313, 0.234> <-0.217, 5.320, 0.215> <-0.194, 5.310, 0.221> 
		<-0.285, 5.360, 0.139> <-0.275, 5.331, 0.157> <-0.231, 5.337, 0.155> <-0.208, 5.327, 0.161> 
	}
}
}

//eye_anime_1
#declare _EYE_ANIME_1 = object {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.264, 5.380, -0.125> <-0.277, 5.298, -0.111> <-0.270, 5.183, -0.122> <-0.266, 5.098, -0.122> 
		<-0.256, 5.361, -0.212> <-0.269, 5.278, -0.197> <-0.255, 5.183, -0.194> <-0.251, 5.098, -0.193> 
		<-0.243, 5.332, -0.329> <-0.241, 5.271, -0.323> <-0.222, 5.153, -0.304> <-0.224, 5.093, -0.288> 
		<-0.214, 5.300, -0.407> <-0.211, 5.239, -0.401> <-0.207, 5.159, -0.375> <-0.208, 5.100, -0.359> 
	}
}

//eye_anime_2
#declare _EYE_ANIME_2 = object {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.264, 5.380, 0.125> <-0.277, 5.298, 0.111> <-0.270, 5.183, 0.122> <-0.266, 5.098, 0.122> 
		<-0.256, 5.361, 0.212> <-0.269, 5.278, 0.197> <-0.255, 5.183, 0.194> <-0.251, 5.098, 0.193> 
		<-0.243, 5.332, 0.329> <-0.241, 5.271, 0.323> <-0.222, 5.153, 0.304> <-0.224, 5.093, 0.288> 
		<-0.214, 5.300, 0.407> <-0.211, 5.239, 0.401> <-0.207, 5.159, 0.375> <-0.208, 5.100, 0.359> 
	}
}

//eye_lash_1
#declare _EYE_LASH_1 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.121, -0.354> <-0.225, 5.118, -0.354> <-0.222, 5.114, -0.347> <-0.223, 5.113, -0.344> 
		<-0.220, 5.127, -0.354> <-0.222, 5.123, -0.354> <-0.239, 5.113, -0.359> <-0.240, 5.113, -0.355> 
		<-0.209, 5.135, -0.352> <-0.228, 5.128, -0.364> <-0.235, 5.116, -0.366> <-0.250, 5.107, -0.382> 
		<-0.210, 5.136, -0.345> <-0.229, 5.128, -0.358> <-0.246, 5.113, -0.382> <-0.261, 5.104, -0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.113, -0.344> <-0.232, 5.111, -0.312> <-0.245, 5.113, -0.271> <-0.254, 5.113, -0.239> 
		<-0.240, 5.113, -0.355> <-0.248, 5.111, -0.324> <-0.251, 5.114, -0.271> <-0.259, 5.115, -0.240> 
		<-0.250, 5.107, -0.382> <-0.249, 5.112, -0.334> <-0.262, 5.116, -0.286> <-0.275, 5.116, -0.240> 
		<-0.261, 5.104, -0.398> <-0.260, 5.109, -0.351> <-0.259, 5.121, -0.286> <-0.272, 5.121, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.254, 5.113, -0.239> <-0.261, 5.114, -0.212> <-0.270, 5.113, -0.176> <-0.276, 5.116, -0.148> 
		<-0.259, 5.115, -0.240> <-0.267, 5.115, -0.212> <-0.287, 5.108, -0.167> <-0.294, 5.112, -0.139> 
		<-0.275, 5.116, -0.240> <-0.286, 5.116, -0.202> <-0.296, 5.114, -0.164> <-0.320, 5.108, -0.134> 
		<-0.272, 5.121, -0.240> <-0.283, 5.121, -0.202> <-0.314, 5.110, -0.158> <-0.338, 5.104, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 5.116, -0.148> <-0.277, 5.117, -0.144> <-0.279, 5.123, -0.139> <-0.276, 5.126, -0.139> 
		<-0.294, 5.112, -0.139> <-0.294, 5.112, -0.135> <-0.275, 5.128, -0.139> <-0.273, 5.132, -0.139> 
		<-0.320, 5.108, -0.134> <-0.297, 5.118, -0.140> <-0.288, 5.129, -0.134> <-0.265, 5.138, -0.143> 
		<-0.338, 5.104, -0.128> <-0.316, 5.114, -0.134> <-0.286, 5.129, -0.140> <-0.263, 5.138, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.263, 5.138, -0.148> <-0.286, 5.129, -0.140> <-0.316, 5.114, -0.134> <-0.338, 5.104, -0.128> 
		<-0.254, 5.140, -0.175> <-0.276, 5.131, -0.166> <-0.292, 5.121, -0.164> <-0.314, 5.110, -0.158> 
		<-0.248, 5.135, -0.212> <-0.258, 5.132, -0.212> <-0.278, 5.130, -0.202> <-0.283, 5.121, -0.202> 
		<-0.241, 5.134, -0.239> <-0.251, 5.132, -0.239> <-0.267, 5.130, -0.240> <-0.272, 5.121, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.241, 5.134, -0.239> <-0.251, 5.132, -0.239> <-0.267, 5.130, -0.240> <-0.272, 5.121, -0.240> 
		<-0.232, 5.134, -0.271> <-0.242, 5.131, -0.271> <-0.254, 5.130, -0.286> <-0.259, 5.121, -0.286> 
		<-0.215, 5.139, -0.313> <-0.234, 5.132, -0.326> <-0.245, 5.119, -0.335> <-0.260, 5.109, -0.351> 
		<-0.210, 5.136, -0.345> <-0.229, 5.128, -0.358> <-0.246, 5.113, -0.382> <-0.261, 5.104, -0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.256, -0.399> <-0.220, 5.243, -0.394> <-0.208, 5.219, -0.380> <-0.209, 5.223, -0.366> 
		<-0.225, 5.265, -0.401> <-0.222, 5.251, -0.397> <-0.253, 5.231, -0.403> <-0.254, 5.235, -0.389> 
		<-0.221, 5.280, -0.394> <-0.242, 5.275, -0.410> <-0.234, 5.268, -0.411> <-0.246, 5.269, -0.435> 
		<-0.223, 5.284, -0.386> <-0.243, 5.279, -0.402> <-0.250, 5.287, -0.441> <-0.261, 5.288, -0.464> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 5.223, -0.366> <-0.218, 5.274, -0.366> <-0.225, 5.283, -0.304> <-0.234, 5.291, -0.270> 
		<-0.254, 5.235, -0.389> <-0.263, 5.286, -0.389> <-0.239, 5.287, -0.305> <-0.247, 5.295, -0.271> 
		<-0.246, 5.269, -0.435> <-0.234, 5.262, -0.364> <-0.257, 5.278, -0.368> <-0.264, 5.305, -0.274> 
		<-0.261, 5.288, -0.464> <-0.250, 5.282, -0.394> <-0.264, 5.290, -0.368> <-0.272, 5.317, -0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.234, 5.291, -0.270> <-0.243, 5.300, -0.235> <-0.258, 5.340, -0.157> <-0.265, 5.277, -0.151> 
		<-0.247, 5.295, -0.271> <-0.256, 5.304, -0.236> <-0.303, 5.351, -0.141> <-0.309, 5.288, -0.134> 
		<-0.264, 5.305, -0.274> <-0.271, 5.329, -0.191> <-0.275, 5.316, -0.157> <-0.316, 5.352, -0.120> 
		<-0.272, 5.317, -0.274> <-0.279, 5.340, -0.191> <-0.297, 5.348, -0.144> <-0.338, 5.384, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.277, -0.151> <-0.269, 5.281, -0.135> <-0.274, 5.309, -0.128> <-0.276, 5.326, -0.124> 
		<-0.309, 5.288, -0.134> <-0.314, 5.292, -0.118> <-0.275, 5.318, -0.126> <-0.278, 5.334, -0.123> 
		<-0.316, 5.352, -0.120> <-0.298, 5.343, -0.128> <-0.295, 5.352, -0.113> <-0.278, 5.353, -0.126> 
		<-0.338, 5.384, -0.107> <-0.320, 5.375, -0.115> <-0.294, 5.352, -0.121> <-0.276, 5.353, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 5.353, -0.135> <-0.294, 5.352, -0.121> <-0.320, 5.375, -0.115> <-0.338, 5.384, -0.107> 
		<-0.270, 5.351, -0.177> <-0.288, 5.350, -0.163> <-0.279, 5.338, -0.152> <-0.297, 5.348, -0.144> 
		<-0.262, 5.331, -0.230> <-0.268, 5.329, -0.230> <-0.282, 5.345, -0.191> <-0.279, 5.340, -0.191> 
		<-0.254, 5.320, -0.270> <-0.259, 5.318, -0.270> <-0.276, 5.321, -0.274> <-0.272, 5.317, -0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.254, 5.320, -0.270> <-0.259, 5.318, -0.270> <-0.276, 5.321, -0.274> <-0.272, 5.317, -0.274> 
		<-0.246, 5.310, -0.306> <-0.252, 5.308, -0.306> <-0.268, 5.295, -0.368> <-0.264, 5.290, -0.368> 
		<-0.231, 5.300, -0.353> <-0.251, 5.296, -0.369> <-0.238, 5.280, -0.370> <-0.250, 5.282, -0.394> 
		<-0.223, 5.284, -0.386> <-0.243, 5.279, -0.402> <-0.250, 5.287, -0.441> <-0.261, 5.288, -0.464> 
	}
}
}

//eye_lash_2
#declare _EYE_LASH_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.121, 0.354> <-0.225, 5.118, 0.354> <-0.222, 5.114, 0.347> <-0.223, 5.113, 0.344> 
		<-0.220, 5.127, 0.354> <-0.222, 5.123, 0.354> <-0.239, 5.113, 0.359> <-0.240, 5.113, 0.355> 
		<-0.209, 5.135, 0.352> <-0.228, 5.128, 0.364> <-0.235, 5.116, 0.366> <-0.250, 5.107, 0.382> 
		<-0.210, 5.136, 0.345> <-0.229, 5.128, 0.358> <-0.246, 5.113, 0.382> <-0.261, 5.104, 0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.113, 0.344> <-0.232, 5.111, 0.312> <-0.245, 5.113, 0.271> <-0.254, 5.113, 0.239> 
		<-0.240, 5.113, 0.355> <-0.248, 5.111, 0.324> <-0.251, 5.114, 0.271> <-0.259, 5.115, 0.240> 
		<-0.250, 5.107, 0.382> <-0.249, 5.112, 0.334> <-0.262, 5.116, 0.286> <-0.275, 5.116, 0.240> 
		<-0.261, 5.104, 0.398> <-0.260, 5.109, 0.351> <-0.259, 5.121, 0.286> <-0.272, 5.121, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.254, 5.113, 0.239> <-0.261, 5.114, 0.212> <-0.270, 5.113, 0.176> <-0.276, 5.116, 0.148> 
		<-0.259, 5.115, 0.240> <-0.267, 5.115, 0.212> <-0.287, 5.108, 0.167> <-0.294, 5.112, 0.139> 
		<-0.275, 5.116, 0.240> <-0.286, 5.116, 0.202> <-0.296, 5.114, 0.164> <-0.320, 5.108, 0.134> 
		<-0.272, 5.121, 0.240> <-0.283, 5.121, 0.202> <-0.314, 5.110, 0.158> <-0.338, 5.104, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 5.116, 0.148> <-0.277, 5.117, 0.144> <-0.279, 5.123, 0.139> <-0.276, 5.126, 0.139> 
		<-0.294, 5.112, 0.139> <-0.294, 5.112, 0.135> <-0.275, 5.128, 0.139> <-0.273, 5.132, 0.139> 
		<-0.320, 5.108, 0.134> <-0.297, 5.118, 0.140> <-0.288, 5.129, 0.134> <-0.265, 5.138, 0.143> 
		<-0.338, 5.104, 0.128> <-0.316, 5.114, 0.134> <-0.286, 5.129, 0.140> <-0.263, 5.138, 0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.263, 5.138, 0.148> <-0.286, 5.129, 0.140> <-0.316, 5.114, 0.134> <-0.338, 5.104, 0.128> 
		<-0.254, 5.140, 0.175> <-0.276, 5.131, 0.166> <-0.292, 5.121, 0.164> <-0.314, 5.110, 0.158> 
		<-0.248, 5.135, 0.212> <-0.258, 5.132, 0.212> <-0.278, 5.130, 0.202> <-0.283, 5.121, 0.202> 
		<-0.241, 5.134, 0.239> <-0.251, 5.132, 0.239> <-0.267, 5.130, 0.240> <-0.272, 5.121, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.241, 5.134, 0.239> <-0.251, 5.132, 0.239> <-0.267, 5.130, 0.240> <-0.272, 5.121, 0.240> 
		<-0.232, 5.134, 0.271> <-0.242, 5.131, 0.271> <-0.254, 5.130, 0.286> <-0.259, 5.121, 0.286> 
		<-0.215, 5.139, 0.313> <-0.234, 5.132, 0.326> <-0.245, 5.119, 0.335> <-0.260, 5.109, 0.351> 
		<-0.210, 5.136, 0.345> <-0.229, 5.128, 0.358> <-0.246, 5.113, 0.382> <-0.261, 5.104, 0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 5.256, 0.399> <-0.220, 5.243, 0.394> <-0.208, 5.219, 0.380> <-0.209, 5.223, 0.366> 
		<-0.225, 5.265, 0.401> <-0.222, 5.251, 0.397> <-0.253, 5.231, 0.403> <-0.254, 5.235, 0.389> 
		<-0.221, 5.280, 0.394> <-0.242, 5.275, 0.410> <-0.234, 5.268, 0.411> <-0.246, 5.269, 0.435> 
		<-0.223, 5.284, 0.386> <-0.243, 5.279, 0.402> <-0.250, 5.287, 0.441> <-0.261, 5.288, 0.464> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 5.223, 0.366> <-0.218, 5.274, 0.366> <-0.225, 5.283, 0.304> <-0.234, 5.291, 0.270> 
		<-0.254, 5.235, 0.389> <-0.263, 5.286, 0.389> <-0.239, 5.287, 0.305> <-0.247, 5.295, 0.271> 
		<-0.246, 5.269, 0.435> <-0.234, 5.262, 0.364> <-0.257, 5.278, 0.368> <-0.264, 5.305, 0.274> 
		<-0.261, 5.288, 0.464> <-0.250, 5.282, 0.394> <-0.264, 5.290, 0.368> <-0.272, 5.317, 0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.234, 5.291, 0.270> <-0.243, 5.300, 0.235> <-0.258, 5.340, 0.157> <-0.265, 5.277, 0.151> 
		<-0.247, 5.295, 0.271> <-0.256, 5.304, 0.236> <-0.303, 5.351, 0.141> <-0.309, 5.288, 0.134> 
		<-0.264, 5.305, 0.274> <-0.271, 5.329, 0.191> <-0.275, 5.316, 0.157> <-0.316, 5.352, 0.120> 
		<-0.272, 5.317, 0.274> <-0.279, 5.340, 0.191> <-0.297, 5.348, 0.144> <-0.338, 5.384, 0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.277, 0.151> <-0.269, 5.281, 0.135> <-0.274, 5.309, 0.128> <-0.276, 5.326, 0.124> 
		<-0.309, 5.288, 0.134> <-0.314, 5.292, 0.118> <-0.275, 5.318, 0.126> <-0.278, 5.334, 0.123> 
		<-0.316, 5.352, 0.120> <-0.298, 5.343, 0.128> <-0.295, 5.352, 0.113> <-0.278, 5.353, 0.126> 
		<-0.338, 5.384, 0.107> <-0.320, 5.375, 0.115> <-0.294, 5.352, 0.121> <-0.276, 5.353, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 5.353, 0.135> <-0.294, 5.352, 0.121> <-0.320, 5.375, 0.115> <-0.338, 5.384, 0.107> 
		<-0.270, 5.351, 0.177> <-0.288, 5.350, 0.163> <-0.279, 5.338, 0.152> <-0.297, 5.348, 0.144> 
		<-0.262, 5.331, 0.230> <-0.268, 5.329, 0.230> <-0.282, 5.345, 0.191> <-0.279, 5.340, 0.191> 
		<-0.254, 5.320, 0.270> <-0.259, 5.318, 0.270> <-0.276, 5.321, 0.274> <-0.272, 5.317, 0.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.254, 5.320, 0.270> <-0.259, 5.318, 0.270> <-0.276, 5.321, 0.274> <-0.272, 5.317, 0.274> 
		<-0.246, 5.310, 0.306> <-0.252, 5.308, 0.306> <-0.268, 5.295, 0.368> <-0.264, 5.290, 0.368> 
		<-0.231, 5.300, 0.353> <-0.251, 5.296, 0.369> <-0.238, 5.280, 0.370> <-0.250, 5.282, 0.394> 
		<-0.223, 5.284, 0.386> <-0.243, 5.279, 0.402> <-0.250, 5.287, 0.441> <-0.261, 5.288, 0.464> 
	}
}
}


//brow_1
#declare _BROW_1 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 5.401, -0.101> <-0.270, 5.374, -0.107> <-0.267, 5.420, -0.167> <-0.265, 5.413, -0.194> 
		<-0.261, 5.431, -0.094> <-0.265, 5.404, -0.100> <-0.278, 5.432, -0.172> <-0.275, 5.425, -0.199> 
		<-0.259, 5.468, -0.151> <-0.291, 5.457, -0.158> <-0.291, 5.457, -0.158> <-0.287, 5.454, -0.189> 
		<-0.256, 5.466, -0.182> <-0.256, 5.466, -0.182> <-0.256, 5.466, -0.182> <-0.256, 5.466, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 5.332, -0.375> <-0.240, 5.327, -0.386> <-0.222, 5.308, -0.407> <-0.220, 5.320, -0.407> 
		<-0.252, 5.336, -0.384> <-0.250, 5.331, -0.395> <-0.219, 5.328, -0.407> <-0.217, 5.340, -0.408> 
		<-0.261, 5.369, -0.397> <-0.259, 5.358, -0.414> <-0.259, 5.358, -0.414> <-0.233, 5.367, -0.393> 
		<-0.235, 5.378, -0.376> <-0.235, 5.378, -0.376> <-0.235, 5.378, -0.376> <-0.235, 5.378, -0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.156, 5.307, -0.411> <-0.158, 5.284, -0.413> <-0.186, 5.312, -0.365> <-0.189, 5.319, -0.344> 
		<-0.151, 5.340, -0.408> <-0.154, 5.318, -0.410> <-0.172, 5.325, -0.357> <-0.175, 5.332, -0.335> 
		<-0.177, 5.371, -0.366> <-0.165, 5.355, -0.358> <-0.165, 5.355, -0.358> <-0.168, 5.373, -0.329> 
		<-0.180, 5.389, -0.337> <-0.180, 5.389, -0.337> <-0.180, 5.389, -0.337> <-0.180, 5.389, -0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.413, -0.194> <-0.260, 5.398, -0.252> <-0.254, 5.355, -0.321> <-0.242, 5.332, -0.375> 
		<-0.275, 5.425, -0.199> <-0.270, 5.410, -0.257> <-0.264, 5.360, -0.331> <-0.252, 5.336, -0.384> 
		<-0.287, 5.454, -0.189> <-0.280, 5.449, -0.253> <-0.270, 5.404, -0.343> <-0.261, 5.369, -0.397> 
		<-0.256, 5.466, -0.182> <-0.249, 5.461, -0.246> <-0.244, 5.413, -0.323> <-0.235, 5.378, -0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.378, -0.376> <-0.244, 5.413, -0.323> <-0.249, 5.461, -0.246> <-0.256, 5.466, -0.182> 
		<-0.213, 5.386, -0.359> <-0.222, 5.421, -0.306> <-0.220, 5.471, -0.239> <-0.227, 5.476, -0.176> 
		<-0.197, 5.385, -0.349> <-0.201, 5.415, -0.302> <-0.201, 5.461, -0.226> <-0.203, 5.462, -0.170> 
		<-0.180, 5.389, -0.337> <-0.185, 5.418, -0.290> <-0.178, 5.459, -0.221> <-0.180, 5.460, -0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.413, -0.194> <-0.248, 5.395, -0.187> <-0.213, 5.400, -0.166> <-0.191, 5.394, -0.154> 
		<-0.260, 5.398, -0.252> <-0.243, 5.380, -0.245> <-0.214, 5.383, -0.225> <-0.192, 5.377, -0.213> 
		<-0.254, 5.355, -0.321> <-0.234, 5.347, -0.302> <-0.213, 5.343, -0.296> <-0.197, 5.339, -0.287> 
		<-0.242, 5.332, -0.375> <-0.223, 5.324, -0.356> <-0.205, 5.323, -0.353> <-0.189, 5.319, -0.344> 
	}
}
}

//brow_2
#declare _BROW_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 5.401, 0.101> <-0.270, 5.374, 0.107> <-0.267, 5.420, 0.167> <-0.265, 5.413, 0.194> 
		<-0.261, 5.431, 0.094> <-0.265, 5.404, 0.100> <-0.278, 5.432, 0.172> <-0.275, 5.425, 0.199> 
		<-0.259, 5.468, 0.151> <-0.291, 5.457, 0.158> <-0.291, 5.457, 0.158> <-0.287, 5.454, 0.189> 
		<-0.256, 5.466, 0.182> <-0.256, 5.466, 0.182> <-0.256, 5.466, 0.182> <-0.256, 5.466, 0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 5.332, 0.375> <-0.240, 5.327, 0.386> <-0.222, 5.308, 0.407> <-0.220, 5.320, 0.407> 
		<-0.252, 5.336, 0.384> <-0.250, 5.331, 0.395> <-0.219, 5.328, 0.407> <-0.217, 5.340, 0.408> 
		<-0.261, 5.369, 0.397> <-0.259, 5.358, 0.414> <-0.259, 5.358, 0.414> <-0.233, 5.367, 0.393> 
		<-0.235, 5.378, 0.376> <-0.235, 5.378, 0.376> <-0.235, 5.378, 0.376> <-0.235, 5.378, 0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.156, 5.307, 0.411> <-0.158, 5.284, 0.413> <-0.186, 5.312, 0.365> <-0.189, 5.319, 0.344> 
		<-0.151, 5.340, 0.408> <-0.154, 5.318, 0.410> <-0.172, 5.325, 0.357> <-0.175, 5.332, 0.335> 
		<-0.177, 5.371, 0.366> <-0.165, 5.355, 0.358> <-0.165, 5.355, 0.358> <-0.168, 5.373, 0.329> 
		<-0.180, 5.389, 0.337> <-0.180, 5.389, 0.337> <-0.180, 5.389, 0.337> <-0.180, 5.389, 0.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.413, 0.194> <-0.260, 5.398, 0.252> <-0.254, 5.355, 0.321> <-0.242, 5.332, 0.375> 
		<-0.275, 5.425, 0.199> <-0.270, 5.410, 0.257> <-0.264, 5.360, 0.331> <-0.252, 5.336, 0.384> 
		<-0.287, 5.454, 0.189> <-0.280, 5.449, 0.253> <-0.270, 5.404, 0.343> <-0.261, 5.369, 0.397> 
		<-0.256, 5.466, 0.182> <-0.249, 5.461, 0.246> <-0.244, 5.413, 0.323> <-0.235, 5.378, 0.376> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 5.378, 0.376> <-0.244, 5.413, 0.323> <-0.249, 5.461, 0.246> <-0.256, 5.466, 0.182> 
		<-0.213, 5.386, 0.359> <-0.222, 5.421, 0.306> <-0.220, 5.471, 0.239> <-0.227, 5.476, 0.176> 
		<-0.197, 5.385, 0.349> <-0.201, 5.415, 0.302> <-0.201, 5.461, 0.226> <-0.203, 5.462, 0.170> 
		<-0.180, 5.389, 0.337> <-0.185, 5.418, 0.290> <-0.178, 5.459, 0.221> <-0.180, 5.460, 0.165> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 5.413, 0.194> <-0.248, 5.395, 0.187> <-0.213, 5.400, 0.166> <-0.191, 5.394, 0.154> 
		<-0.260, 5.398, 0.252> <-0.243, 5.380, 0.245> <-0.214, 5.383, 0.225> <-0.192, 5.377, 0.213> 
		<-0.254, 5.355, 0.321> <-0.234, 5.347, 0.302> <-0.213, 5.343, 0.296> <-0.197, 5.339, 0.287> 
		<-0.242, 5.332, 0.375> <-0.223, 5.324, 0.356> <-0.205, 5.323, 0.353> <-0.189, 5.319, 0.344> 
	}
}
}

//claw_r
#declare _CLAW_1 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.257, 2.515, -1.454> <0.257, 2.515, -1.421> <0.231, 2.515, -1.392> <0.198, 2.515, -1.392> 
		<0.258, 2.568, -1.454> <0.258, 2.568, -1.421> <0.231, 2.568, -1.405> <0.198, 2.568, -1.405> 
		<0.228, 2.640, -1.454> <0.228, 2.640, -1.444> <0.208, 2.640, -1.422> <0.198, 2.640, -1.422> 
		<0.216, 2.694, -1.454> <0.216, 2.694, -1.444> <0.208, 2.694, -1.435> <0.198, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.198, 2.515, -1.392> <0.165, 2.515, -1.392> <0.138, 2.515, -1.421> <0.138, 2.515, -1.454> 
		<0.198, 2.443, -1.392> <0.165, 2.443, -1.392> <0.139, 2.417, -1.421> <0.139, 2.417, -1.454> 
		<0.198, 2.348, -1.391> <0.198, 2.348, -1.391> <0.180, 2.348, -1.410> <0.180, 2.348, -1.410> 
		<0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.138, 2.515, -1.454> <0.138, 2.515, -1.487> <0.165, 2.515, -1.516> <0.198, 2.515, -1.516> 
		<0.139, 2.417, -1.454> <0.139, 2.417, -1.487> <0.163, 2.377, -1.507> <0.196, 2.377, -1.507> 
		<0.180, 2.348, -1.410> <0.180, 2.348, -1.410> <0.198, 2.348, -1.429> <0.198, 2.348, -1.429> 
		<0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.198, 2.515, -1.516> <0.231, 2.515, -1.516> <0.257, 2.515, -1.487> <0.257, 2.515, -1.454> 
		<0.196, 2.377, -1.507> <0.229, 2.377, -1.507> <0.257, 2.412, -1.487> <0.257, 2.412, -1.454> 
		<0.198, 2.348, -1.429> <0.198, 2.348, -1.429> <0.216, 2.348, -1.410> <0.216, 2.348, -1.410> 
		<0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> <0.198, 2.277, -1.391> 
		<0.216, 2.348, -1.410> <0.216, 2.348, -1.410> <0.198, 2.348, -1.391> <0.198, 2.348, -1.391> 
		<0.257, 2.412, -1.454> <0.257, 2.412, -1.421> <0.231, 2.443, -1.392> <0.198, 2.443, -1.392> 
		<0.257, 2.515, -1.454> <0.257, 2.515, -1.421> <0.231, 2.515, -1.392> <0.198, 2.515, -1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.257, 2.515, -1.454> <0.258, 2.568, -1.454> <0.228, 2.640, -1.454> <0.216, 2.694, -1.454> 
		<0.257, 2.515, -1.487> <0.258, 2.568, -1.487> <0.228, 2.640, -1.464> <0.216, 2.694, -1.464> 
		<0.231, 2.515, -1.516> <0.232, 2.568, -1.519> <0.208, 2.640, -1.485> <0.208, 2.694, -1.472> 
		<0.198, 2.515, -1.516> <0.199, 2.568, -1.519> <0.198, 2.640, -1.485> <0.198, 2.694, -1.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.138, 2.515, -1.454> <0.138, 2.568, -1.454> <0.168, 2.640, -1.454> <0.180, 2.694, -1.454> 
		<0.138, 2.515, -1.421> <0.138, 2.568, -1.421> <0.168, 2.640, -1.444> <0.180, 2.694, -1.444> 
		<0.165, 2.515, -1.392> <0.165, 2.568, -1.405> <0.188, 2.640, -1.422> <0.188, 2.694, -1.435> 
		<0.198, 2.515, -1.392> <0.198, 2.568, -1.405> <0.198, 2.640, -1.422> <0.198, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.198, 2.515, -1.516> <0.199, 2.568, -1.519> <0.198, 2.640, -1.485> <0.198, 2.694, -1.472> 
		<0.165, 2.515, -1.516> <0.165, 2.568, -1.519> <0.188, 2.640, -1.485> <0.188, 2.694, -1.472> 
		<0.138, 2.515, -1.487> <0.138, 2.568, -1.487> <0.168, 2.640, -1.464> <0.180, 2.694, -1.464> 
		<0.138, 2.515, -1.454> <0.138, 2.568, -1.454> <0.168, 2.640, -1.454> <0.180, 2.694, -1.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.109, 2.515, -1.454> <0.109, 2.515, -1.421> <0.083, 2.515, -1.392> <0.049, 2.515, -1.392> 
		<0.109, 2.568, -1.454> <0.109, 2.568, -1.421> <0.083, 2.568, -1.405> <0.049, 2.568, -1.405> 
		<0.080, 2.640, -1.454> <0.080, 2.640, -1.444> <0.059, 2.640, -1.422> <0.049, 2.640, -1.422> 
		<0.067, 2.694, -1.454> <0.067, 2.694, -1.444> <0.059, 2.694, -1.435> <0.049, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.049, 2.515, -1.392> <0.016, 2.515, -1.392> <-0.010, 2.515, -1.421> <-0.010, 2.515, -1.454> 
		<0.049, 2.443, -1.392> <0.016, 2.443, -1.392> <-0.009, 2.417, -1.421> <-0.009, 2.417, -1.454> 
		<0.049, 2.348, -1.391> <0.049, 2.348, -1.391> <0.032, 2.348, -1.410> <0.032, 2.348, -1.410> 
		<0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, 2.515, -1.454> <-0.010, 2.515, -1.487> <0.016, 2.515, -1.516> <0.049, 2.515, -1.516> 
		<-0.009, 2.417, -1.454> <-0.009, 2.417, -1.487> <0.014, 2.377, -1.507> <0.047, 2.377, -1.507> 
		<0.032, 2.348, -1.410> <0.032, 2.348, -1.410> <0.049, 2.348, -1.429> <0.049, 2.348, -1.429> 
		<0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.049, 2.515, -1.516> <0.083, 2.515, -1.516> <0.109, 2.515, -1.487> <0.109, 2.515, -1.454> 
		<0.047, 2.377, -1.507> <0.081, 2.377, -1.507> <0.108, 2.412, -1.487> <0.108, 2.412, -1.454> 
		<0.049, 2.348, -1.429> <0.049, 2.348, -1.429> <0.067, 2.348, -1.410> <0.067, 2.348, -1.410> 
		<0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> <0.049, 2.277, -1.391> 
		<0.067, 2.348, -1.410> <0.067, 2.348, -1.410> <0.049, 2.348, -1.391> <0.049, 2.348, -1.391> 
		<0.108, 2.412, -1.454> <0.108, 2.412, -1.421> <0.083, 2.443, -1.392> <0.049, 2.443, -1.392> 
		<0.109, 2.515, -1.454> <0.109, 2.515, -1.421> <0.083, 2.515, -1.392> <0.049, 2.515, -1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.109, 2.515, -1.454> <0.109, 2.568, -1.454> <0.080, 2.640, -1.454> <0.067, 2.694, -1.454> 
		<0.109, 2.515, -1.487> <0.109, 2.568, -1.487> <0.080, 2.640, -1.464> <0.067, 2.694, -1.464> 
		<0.083, 2.515, -1.516> <0.083, 2.568, -1.519> <0.059, 2.640, -1.485> <0.059, 2.694, -1.472> 
		<0.049, 2.515, -1.516> <0.050, 2.568, -1.519> <0.049, 2.640, -1.485> <0.049, 2.694, -1.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, 2.515, -1.454> <-0.010, 2.568, -1.454> <0.019, 2.640, -1.454> <0.032, 2.694, -1.454> 
		<-0.010, 2.515, -1.421> <-0.010, 2.568, -1.421> <0.019, 2.640, -1.444> <0.032, 2.694, -1.444> 
		<0.016, 2.515, -1.392> <0.016, 2.568, -1.405> <0.040, 2.640, -1.422> <0.040, 2.694, -1.435> 
		<0.049, 2.515, -1.392> <0.049, 2.568, -1.405> <0.049, 2.640, -1.422> <0.049, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.049, 2.515, -1.516> <0.050, 2.568, -1.519> <0.049, 2.640, -1.485> <0.049, 2.694, -1.472> 
		<0.016, 2.515, -1.516> <0.017, 2.568, -1.519> <0.040, 2.640, -1.485> <0.040, 2.694, -1.472> 
		<-0.010, 2.515, -1.487> <-0.010, 2.568, -1.487> <0.019, 2.640, -1.464> <0.032, 2.694, -1.464> 
		<-0.010, 2.515, -1.454> <-0.010, 2.568, -1.454> <0.019, 2.640, -1.454> <0.032, 2.694, -1.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 2.515, -1.454> <-0.039, 2.515, -1.421> <-0.066, 2.515, -1.392> <-0.099, 2.515, -1.392> 
		<-0.039, 2.568, -1.454> <-0.039, 2.568, -1.421> <-0.066, 2.568, -1.405> <-0.099, 2.568, -1.405> 
		<-0.069, 2.640, -1.454> <-0.069, 2.640, -1.444> <-0.089, 2.640, -1.422> <-0.099, 2.640, -1.422> 
		<-0.081, 2.694, -1.454> <-0.081, 2.694, -1.444> <-0.089, 2.694, -1.435> <-0.099, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.099, 2.515, -1.392> <-0.132, 2.515, -1.392> <-0.158, 2.515, -1.421> <-0.158, 2.515, -1.454> 
		<-0.099, 2.443, -1.392> <-0.132, 2.443, -1.392> <-0.158, 2.417, -1.421> <-0.158, 2.417, -1.454> 
		<-0.099, 2.348, -1.391> <-0.099, 2.348, -1.391> <-0.117, 2.348, -1.410> <-0.117, 2.348, -1.410> 
		<-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.158, 2.515, -1.454> <-0.158, 2.515, -1.487> <-0.132, 2.515, -1.516> <-0.099, 2.515, -1.516> 
		<-0.158, 2.417, -1.454> <-0.158, 2.417, -1.487> <-0.134, 2.377, -1.507> <-0.101, 2.377, -1.507> 
		<-0.117, 2.348, -1.410> <-0.117, 2.348, -1.410> <-0.099, 2.348, -1.429> <-0.099, 2.348, -1.429> 
		<-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.099, 2.515, -1.516> <-0.066, 2.515, -1.516> <-0.039, 2.515, -1.487> <-0.039, 2.515, -1.454> 
		<-0.101, 2.377, -1.507> <-0.068, 2.377, -1.507> <-0.040, 2.412, -1.487> <-0.040, 2.412, -1.454> 
		<-0.099, 2.348, -1.429> <-0.099, 2.348, -1.429> <-0.081, 2.348, -1.410> <-0.081, 2.348, -1.410> 
		<-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> <-0.099, 2.277, -1.391> 
		<-0.081, 2.348, -1.410> <-0.081, 2.348, -1.410> <-0.099, 2.348, -1.391> <-0.099, 2.348, -1.391> 
		<-0.040, 2.412, -1.454> <-0.040, 2.412, -1.421> <-0.066, 2.443, -1.392> <-0.099, 2.443, -1.392> 
		<-0.039, 2.515, -1.454> <-0.039, 2.515, -1.421> <-0.066, 2.515, -1.392> <-0.099, 2.515, -1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 2.515, -1.454> <-0.039, 2.568, -1.454> <-0.069, 2.640, -1.454> <-0.081, 2.694, -1.454> 
		<-0.039, 2.515, -1.487> <-0.039, 2.568, -1.487> <-0.069, 2.640, -1.464> <-0.081, 2.694, -1.464> 
		<-0.066, 2.515, -1.516> <-0.065, 2.568, -1.519> <-0.089, 2.640, -1.485> <-0.089, 2.694, -1.472> 
		<-0.099, 2.515, -1.516> <-0.098, 2.568, -1.519> <-0.099, 2.640, -1.485> <-0.099, 2.694, -1.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.158, 2.515, -1.454> <-0.159, 2.568, -1.454> <-0.129, 2.640, -1.454> <-0.117, 2.694, -1.454> 
		<-0.158, 2.515, -1.421> <-0.159, 2.568, -1.421> <-0.129, 2.640, -1.444> <-0.117, 2.694, -1.444> 
		<-0.132, 2.515, -1.392> <-0.132, 2.568, -1.405> <-0.109, 2.640, -1.422> <-0.109, 2.694, -1.435> 
		<-0.099, 2.515, -1.392> <-0.099, 2.568, -1.405> <-0.099, 2.640, -1.422> <-0.099, 2.694, -1.435> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.099, 2.515, -1.516> <-0.098, 2.568, -1.519> <-0.099, 2.640, -1.485> <-0.099, 2.694, -1.472> 
		<-0.132, 2.515, -1.516> <-0.131, 2.568, -1.519> <-0.109, 2.640, -1.485> <-0.109, 2.694, -1.472> 
		<-0.158, 2.515, -1.487> <-0.159, 2.568, -1.487> <-0.129, 2.640, -1.464> <-0.117, 2.694, -1.464> 
		<-0.158, 2.515, -1.454> <-0.159, 2.568, -1.454> <-0.129, 2.640, -1.454> <-0.117, 2.694, -1.454> 
	}
}
}

//claw_l
#declare _CLAW_2 = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.038, 2.959, 0.154> <-1.070, 2.967, 0.154> <-1.092, 2.998, 0.148> <-1.084, 3.030, 0.140> 
		<-1.035, 2.971, 0.206> <-1.067, 2.979, 0.206> <-1.076, 3.008, 0.200> <-1.068, 3.039, 0.192> 
		<-1.023, 3.015, 0.268> <-1.033, 3.018, 0.268> <-1.049, 3.042, 0.264> <-1.047, 3.052, 0.261> 
		<-1.017, 3.040, 0.317> <-1.026, 3.042, 0.317> <-1.033, 3.052, 0.316> <-1.031, 3.061, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.084, 3.030, 0.140> <-1.076, 3.061, 0.132> <-1.042, 3.079, 0.125> <-1.010, 3.071, 0.125> 
		<-1.089, 3.013, 0.071> <-1.081, 3.044, 0.063> <-1.048, 3.055, 0.031> <-1.016, 3.047, 0.031> 
		<-1.095, 2.991, -0.022> <-1.095, 2.991, -0.022> <-1.073, 3.003, -0.026> <-1.073, 3.003, -0.026> 
		<-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 3.071, 0.125> <-0.978, 3.063, 0.125> <-0.956, 3.031, 0.131> <-0.964, 3.000, 0.139> 
		<-1.016, 3.047, 0.031> <-0.984, 3.039, 0.031> <-0.972, 3.003, -0.003> <-0.980, 2.971, 0.005> 
		<-1.073, 3.003, -0.026> <-1.073, 3.003, -0.026> <-1.059, 2.982, -0.022> <-1.059, 2.982, -0.022> 
		<-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.964, 3.000, 0.139> <-0.972, 2.968, 0.147> <-1.006, 2.951, 0.154> <-1.038, 2.959, 0.154> 
		<-0.980, 2.971, 0.005> <-0.988, 2.940, 0.013> <-1.012, 2.927, 0.054> <-1.044, 2.935, 0.055> 
		<-1.059, 2.982, -0.022> <-1.059, 2.982, -0.022> <-1.081, 2.970, -0.017> <-1.081, 2.970, -0.017> 
		<-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> <-1.099, 2.974, -0.091> 
		<-1.081, 2.970, -0.017> <-1.081, 2.970, -0.017> <-1.095, 2.991, -0.022> <-1.095, 2.991, -0.022> 
		<-1.044, 2.935, 0.055> <-1.076, 2.943, 0.055> <-1.096, 2.982, 0.079> <-1.089, 3.013, 0.071> 
		<-1.038, 2.959, 0.154> <-1.070, 2.967, 0.154> <-1.092, 2.998, 0.148> <-1.084, 3.030, 0.140> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.038, 2.959, 0.154> <-1.035, 2.971, 0.206> <-1.023, 3.015, 0.268> <-1.017, 3.040, 0.317> 
		<-1.006, 2.951, 0.154> <-1.002, 2.963, 0.206> <-1.013, 3.013, 0.268> <-1.007, 3.037, 0.317> 
		<-0.972, 2.968, 0.147> <-0.965, 2.979, 0.199> <-0.988, 3.027, 0.263> <-0.997, 3.043, 0.315> 
		<-0.964, 3.000, 0.139> <-0.957, 3.011, 0.191> <-0.985, 3.036, 0.261> <-0.995, 3.052, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 3.071, 0.125> <-1.007, 3.083, 0.177> <-1.009, 3.072, 0.254> <-1.008, 3.073, 0.309> 
		<-1.042, 3.079, 0.125> <-1.039, 3.092, 0.177> <-1.019, 3.075, 0.254> <-1.018, 3.076, 0.309> 
		<-1.076, 3.061, 0.132> <-1.060, 3.070, 0.184> <-1.044, 3.061, 0.259> <-1.028, 3.070, 0.311> 
		<-1.084, 3.030, 0.140> <-1.068, 3.039, 0.192> <-1.047, 3.052, 0.261> <-1.031, 3.061, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.964, 3.000, 0.139> <-0.957, 3.011, 0.191> <-0.985, 3.036, 0.261> <-0.995, 3.052, 0.313> 
		<-0.956, 3.031, 0.131> <-0.950, 3.042, 0.183> <-0.983, 3.046, 0.259> <-0.992, 3.061, 0.311> 
		<-0.978, 3.063, 0.125> <-0.974, 3.075, 0.177> <-0.999, 3.070, 0.254> <-0.999, 3.071, 0.309> 
		<-1.010, 3.071, 0.125> <-1.007, 3.083, 0.177> <-1.009, 3.072, 0.254> <-1.008, 3.073, 0.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.003, 3.098, 0.118> <-1.035, 3.106, 0.118> <-1.057, 3.138, 0.112> <-1.049, 3.169, 0.104> 
		<-1.000, 3.111, 0.170> <-1.032, 3.119, 0.170> <-1.041, 3.148, 0.164> <-1.033, 3.179, 0.156> 
		<-0.988, 3.155, 0.232> <-0.998, 3.157, 0.233> <-1.014, 3.182, 0.228> <-1.012, 3.191, 0.225> 
		<-0.982, 3.179, 0.282> <-0.992, 3.182, 0.282> <-0.998, 3.191, 0.280> <-0.996, 3.201, 0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.049, 3.169, 0.104> <-1.041, 3.201, 0.096> <-1.007, 3.218, 0.089> <-0.975, 3.210, 0.089> 
		<-1.054, 3.153, 0.035> <-1.046, 3.184, 0.027> <-1.014, 3.195, -0.005> <-0.981, 3.187, -0.005> 
		<-1.060, 3.131, -0.058> <-1.060, 3.131, -0.058> <-1.038, 3.143, -0.062> <-1.038, 3.143, -0.062> 
		<-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.975, 3.210, 0.089> <-0.943, 3.202, 0.089> <-0.921, 3.171, 0.095> <-0.929, 3.139, 0.103> 
		<-0.981, 3.187, -0.005> <-0.949, 3.179, -0.005> <-0.938, 3.142, -0.039> <-0.945, 3.111, -0.031> 
		<-1.038, 3.143, -0.062> <-1.038, 3.143, -0.062> <-1.024, 3.122, -0.058> <-1.024, 3.122, -0.058> 
		<-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.929, 3.139, 0.103> <-0.937, 3.108, 0.111> <-0.971, 3.090, 0.118> <-1.003, 3.098, 0.118> 
		<-0.945, 3.111, -0.031> <-0.953, 3.080, -0.023> <-0.977, 3.067, 0.019> <-1.009, 3.075, 0.019> 
		<-1.024, 3.122, -0.058> <-1.024, 3.122, -0.058> <-1.046, 3.109, -0.053> <-1.046, 3.109, -0.053> 
		<-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> <-1.065, 3.114, -0.127> 
		<-1.046, 3.109, -0.053> <-1.046, 3.109, -0.053> <-1.060, 3.131, -0.058> <-1.060, 3.131, -0.058> 
		<-1.009, 3.075, 0.019> <-1.041, 3.083, 0.019> <-1.062, 3.122, 0.043> <-1.054, 3.153, 0.035> 
		<-1.003, 3.098, 0.118> <-1.035, 3.106, 0.118> <-1.057, 3.138, 0.112> <-1.049, 3.169, 0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.003, 3.098, 0.118> <-1.000, 3.111, 0.170> <-0.988, 3.155, 0.232> <-0.982, 3.179, 0.282> 
		<-0.971, 3.090, 0.118> <-0.968, 3.103, 0.170> <-0.979, 3.153, 0.232> <-0.972, 3.177, 0.281> 
		<-0.937, 3.108, 0.111> <-0.930, 3.119, 0.164> <-0.953, 3.167, 0.227> <-0.962, 3.182, 0.280> 
		<-0.929, 3.139, 0.103> <-0.923, 3.150, 0.156> <-0.951, 3.176, 0.225> <-0.960, 3.192, 0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.975, 3.210, 0.089> <-0.972, 3.223, 0.141> <-0.974, 3.212, 0.218> <-0.974, 3.213, 0.273> 
		<-1.007, 3.218, 0.089> <-1.004, 3.231, 0.141> <-0.984, 3.215, 0.218> <-0.983, 3.215, 0.273> 
		<-1.041, 3.201, 0.096> <-1.025, 3.210, 0.148> <-1.010, 3.201, 0.223> <-0.994, 3.210, 0.275> 
		<-1.049, 3.169, 0.104> <-1.033, 3.179, 0.156> <-1.012, 3.191, 0.225> <-0.996, 3.201, 0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.929, 3.139, 0.103> <-0.923, 3.150, 0.156> <-0.951, 3.176, 0.225> <-0.960, 3.192, 0.277> 
		<-0.921, 3.171, 0.095> <-0.915, 3.182, 0.148> <-0.948, 3.185, 0.223> <-0.958, 3.201, 0.275> 
		<-0.943, 3.202, 0.089> <-0.940, 3.215, 0.141> <-0.965, 3.210, 0.218> <-0.964, 3.211, 0.273> 
		<-0.975, 3.210, 0.089> <-0.972, 3.223, 0.141> <-0.974, 3.212, 0.218> <-0.974, 3.213, 0.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.968, 3.238, 0.082> <-1.000, 3.246, 0.082> <-1.022, 3.278, 0.076> <-1.014, 3.309, 0.068> 
		<-0.965, 3.250, 0.134> <-0.997, 3.258, 0.134> <-1.006, 3.287, 0.128> <-0.998, 3.318, 0.120> 
		<-0.954, 3.295, 0.197> <-0.963, 3.297, 0.197> <-0.980, 3.322, 0.192> <-0.977, 3.331, 0.189> 
		<-0.947, 3.319, 0.246> <-0.957, 3.321, 0.246> <-0.964, 3.331, 0.244> <-0.961, 3.340, 0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.014, 3.309, 0.068> <-1.007, 3.340, 0.060> <-0.973, 3.358, 0.054> <-0.940, 3.350, 0.053> 
		<-1.019, 3.292, -0.001> <-1.011, 3.324, -0.009> <-0.979, 3.335, -0.041> <-0.947, 3.327, -0.041> 
		<-1.025, 3.270, -0.094> <-1.025, 3.270, -0.094> <-1.003, 3.283, -0.098> <-1.003, 3.283, -0.098> 
		<-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.940, 3.350, 0.053> <-0.908, 3.342, 0.053> <-0.887, 3.310, 0.059> <-0.894, 3.279, 0.068> 
		<-0.947, 3.327, -0.041> <-0.915, 3.319, -0.041> <-0.903, 3.282, -0.075> <-0.911, 3.251, -0.067> 
		<-1.003, 3.283, -0.098> <-1.003, 3.283, -0.098> <-0.989, 3.261, -0.094> <-0.989, 3.261, -0.094> 
		<-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, 3.279, 0.068> <-0.902, 3.248, 0.076> <-0.936, 3.230, 0.082> <-0.968, 3.238, 0.082> 
		<-0.911, 3.251, -0.067> <-0.918, 3.220, -0.059> <-0.942, 3.207, -0.017> <-0.975, 3.215, -0.017> 
		<-0.989, 3.261, -0.094> <-0.989, 3.261, -0.094> <-1.011, 3.249, -0.089> <-1.011, 3.249, -0.089> 
		<-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> <-1.030, 3.254, -0.163> 
		<-1.011, 3.249, -0.089> <-1.011, 3.249, -0.089> <-1.025, 3.270, -0.094> <-1.025, 3.270, -0.094> 
		<-0.975, 3.215, -0.017> <-1.007, 3.223, -0.017> <-1.027, 3.261, 0.007> <-1.019, 3.292, -0.001> 
		<-0.968, 3.238, 0.082> <-1.000, 3.246, 0.082> <-1.022, 3.278, 0.076> <-1.014, 3.309, 0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.968, 3.238, 0.082> <-0.965, 3.250, 0.134> <-0.954, 3.295, 0.197> <-0.947, 3.319, 0.246> 
		<-0.936, 3.230, 0.082> <-0.933, 3.242, 0.134> <-0.944, 3.292, 0.197> <-0.938, 3.317, 0.246> 
		<-0.902, 3.248, 0.076> <-0.896, 3.259, 0.128> <-0.918, 3.306, 0.192> <-0.927, 3.322, 0.244> 
		<-0.894, 3.279, 0.068> <-0.888, 3.290, 0.120> <-0.916, 3.316, 0.189> <-0.925, 3.331, 0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.940, 3.350, 0.053> <-0.937, 3.363, 0.105> <-0.939, 3.352, 0.182> <-0.939, 3.353, 0.237> 
		<-0.973, 3.358, 0.054> <-0.969, 3.371, 0.106> <-0.949, 3.354, 0.182> <-0.949, 3.355, 0.237> 
		<-1.007, 3.340, 0.060> <-0.991, 3.350, 0.112> <-0.975, 3.340, 0.187> <-0.959, 3.350, 0.239> 
		<-1.014, 3.309, 0.068> <-0.998, 3.318, 0.120> <-0.977, 3.331, 0.189> <-0.961, 3.340, 0.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, 3.279, 0.068> <-0.888, 3.290, 0.120> <-0.916, 3.316, 0.189> <-0.925, 3.331, 0.241> 
		<-0.887, 3.310, 0.059> <-0.880, 3.321, 0.112> <-0.914, 3.325, 0.187> <-0.923, 3.341, 0.239> 
		<-0.908, 3.342, 0.053> <-0.905, 3.355, 0.105> <-0.930, 3.349, 0.182> <-0.929, 3.350, 0.237> 
		<-0.940, 3.350, 0.053> <-0.937, 3.363, 0.105> <-0.939, 3.352, 0.182> <-0.939, 3.353, 0.237> 
	}
}
}

//pooki
#declare _POOKI = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.027, 3.764, 0.210> <-1.065, 3.887, 0.171> <-1.106, 4.024, 0.247> <-1.118, 4.061, 0.375> 
		<-0.909, 3.829, 0.202> <-0.947, 3.952, 0.163> <-0.989, 4.088, 0.238> <-1.000, 4.126, 0.367> 
		<-0.799, 3.869, 0.319> <-0.837, 3.992, 0.280> <-0.837, 3.992, 0.280> <-0.848, 4.029, 0.409> 
		<-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.027, 3.764, 0.210> <-1.065, 3.887, 0.171> <-1.106, 4.024, 0.247> <-1.118, 4.061, 0.375> 
		<-1.175, 3.684, 0.221> <-1.212, 3.806, 0.181> <-1.276, 3.931, 0.259> <-1.288, 3.968, 0.387> 
		<-1.332, 3.593, 0.402> <-1.387, 3.770, 0.345> <-1.387, 3.770, 0.345> <-1.394, 3.795, 0.428> 
		<-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.118, 4.061, 0.375> <-1.129, 4.099, 0.504> <-1.107, 4.026, 0.646> <-1.070, 3.903, 0.686> 
		<-1.288, 3.968, 0.387> <-1.299, 4.006, 0.516> <-1.255, 3.945, 0.657> <-1.217, 3.823, 0.696> 
		<-1.394, 3.795, 0.428> <-1.402, 3.822, 0.522> <-1.402, 3.822, 0.522> <-1.348, 3.644, 0.579> 
		<-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.118, 4.061, 0.375> <-1.129, 4.099, 0.504> <-1.107, 4.026, 0.646> <-1.070, 3.903, 0.686> 
		<-1.000, 4.126, 0.367> <-1.012, 4.163, 0.495> <-0.990, 4.091, 0.638> <-0.952, 3.968, 0.677> 
		<-0.848, 4.029, 0.409> <-0.860, 4.067, 0.537> <-0.860, 4.067, 0.537> <-0.822, 3.944, 0.576> 
		<-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.070, 3.903, 0.686> <-1.032, 3.781, 0.725> <-0.990, 3.644, 0.649> <-0.979, 3.607, 0.521> 
		<-1.217, 3.823, 0.696> <-1.180, 3.700, 0.735> <-1.112, 3.578, 0.658> <-1.100, 3.540, 0.529> 
		<-1.348, 3.644, 0.579> <-1.309, 3.518, 0.620> <-1.309, 3.518, 0.620> <-1.301, 3.490, 0.526> 
		<-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.070, 3.903, 0.686> <-1.032, 3.781, 0.725> <-0.990, 3.644, 0.649> <-0.979, 3.607, 0.521> 
		<-0.952, 3.968, 0.677> <-0.914, 3.845, 0.717> <-0.873, 3.709, 0.641> <-0.861, 3.671, 0.512> 
		<-0.822, 3.944, 0.576> <-0.785, 3.821, 0.616> <-0.785, 3.821, 0.616> <-0.773, 3.784, 0.487> 
		<-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.979, 3.607, 0.521> <-0.967, 3.569, 0.392> <-0.990, 3.642, 0.249> <-1.027, 3.764, 0.210> 
		<-0.861, 3.671, 0.512> <-0.850, 3.633, 0.384> <-0.872, 3.706, 0.241> <-0.909, 3.829, 0.202> 
		<-0.773, 3.784, 0.487> <-0.762, 3.746, 0.359> <-0.762, 3.746, 0.359> <-0.799, 3.869, 0.319> 
		<-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> <-0.811, 3.907, 0.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.979, 3.607, 0.521> <-0.967, 3.569, 0.392> <-0.990, 3.642, 0.249> <-1.027, 3.764, 0.210> 
		<-1.100, 3.540, 0.529> <-1.089, 3.503, 0.401> <-1.137, 3.561, 0.260> <-1.175, 3.684, 0.221> 
		<-1.301, 3.490, 0.526> <-1.293, 3.466, 0.442> <-1.293, 3.466, 0.442> <-1.332, 3.593, 0.402> 
		<-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> <-1.340, 3.617, 0.485> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.271, 3.552, -0.113> <-1.271, 3.668, -0.113> <-1.180, 3.767, -0.152> <-1.073, 3.767, -0.197> 
		<-1.305, 3.553, -0.195> <-1.305, 3.669, -0.195> <-1.214, 3.767, -0.232> <-1.107, 3.767, -0.278> 
		<-1.188, 3.555, -0.242> <-1.188, 3.643, -0.242> <-1.188, 3.643, -0.242> <-1.107, 3.643, -0.277> 
		<-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.271, 3.552, -0.113> <-1.271, 3.668, -0.113> <-1.180, 3.767, -0.152> <-1.073, 3.767, -0.197> 
		<-1.160, 3.551, 0.148> <-1.160, 3.667, 0.148> <-1.069, 3.766, 0.110> <-0.962, 3.766, 0.064> 
		<-0.884, 3.553, 0.496> <-0.884, 3.709, 0.497> <-0.884, 3.709, 0.497> <-0.795, 3.708, 0.459> 
		<-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.073, 3.767, -0.197> <-0.967, 3.767, -0.243> <-0.876, 3.668, -0.281> <-0.876, 3.552, -0.281> 
		<-0.962, 3.766, 0.064> <-0.856, 3.766, 0.019> <-0.765, 3.667, -0.020> <-0.765, 3.551, -0.020> 
		<-0.795, 3.708, 0.459> <-0.678, 3.707, 0.409> <-0.678, 3.707, 0.409> <-0.678, 3.551, 0.409> 
		<-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.073, 3.767, -0.197> <-0.967, 3.767, -0.243> <-0.876, 3.668, -0.281> <-0.876, 3.552, -0.281> 
		<-1.107, 3.767, -0.278> <-1.001, 3.767, -0.323> <-0.910, 3.669, -0.363> <-0.910, 3.553, -0.363> 
		<-1.107, 3.643, -0.277> <-1.026, 3.643, -0.311> <-1.026, 3.643, -0.311> <-1.026, 3.555, -0.311> 
		<-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.876, 3.552, -0.281> <-0.876, 3.436, -0.281> <-0.967, 3.338, -0.243> <-1.073, 3.338, -0.197> 
		<-0.765, 3.551, -0.020> <-0.765, 3.435, -0.020> <-0.856, 3.336, 0.019> <-0.962, 3.336, 0.064> 
		<-0.678, 3.551, 0.409> <-0.678, 3.422, 0.408> <-0.678, 3.422, 0.408> <-0.795, 3.424, 0.458> 
		<-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.876, 3.552, -0.281> <-0.876, 3.436, -0.281> <-0.967, 3.338, -0.243> <-1.073, 3.338, -0.197> 
		<-0.910, 3.553, -0.363> <-0.910, 3.437, -0.363> <-1.002, 3.338, -0.325> <-1.108, 3.338, -0.280> 
		<-1.026, 3.555, -0.311> <-1.026, 3.466, -0.311> <-1.026, 3.466, -0.311> <-1.107, 3.466, -0.277> 
		<-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.073, 3.338, -0.197> <-1.180, 3.338, -0.152> <-1.271, 3.436, -0.113> <-1.271, 3.552, -0.113> 
		<-1.108, 3.338, -0.280> <-1.215, 3.338, -0.234> <-1.305, 3.437, -0.195> <-1.305, 3.553, -0.195> 
		<-1.107, 3.466, -0.277> <-1.188, 3.466, -0.242> <-1.188, 3.466, -0.242> <-1.188, 3.555, -0.242> 
		<-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> <-1.107, 3.555, -0.277> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.073, 3.338, -0.197> <-1.180, 3.338, -0.152> <-1.271, 3.436, -0.113> <-1.271, 3.552, -0.113> 
		<-0.962, 3.336, 0.064> <-1.069, 3.336, 0.110> <-1.160, 3.435, 0.148> <-1.160, 3.551, 0.148> 
		<-0.795, 3.424, 0.458> <-0.885, 3.425, 0.496> <-0.885, 3.425, 0.496> <-0.884, 3.553, 0.496> 
		<-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> <-0.795, 3.552, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.879, 3.960, 1.156> <-0.893, 4.060, 1.098> <-0.988, 4.110, 1.010> <-1.087, 4.070, 0.964> 
		<-0.924, 3.994, 1.224> <-0.938, 4.094, 1.166> <-1.033, 4.144, 1.077> <-1.132, 4.104, 1.032> 
		<-1.031, 3.952, 1.172> <-1.041, 4.027, 1.128> <-1.041, 4.027, 1.128> <-1.117, 3.997, 1.093> 
		<-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.879, 3.960, 1.156> <-0.893, 4.060, 1.098> <-0.988, 4.110, 1.010> <-1.087, 4.070, 0.964> 
		<-0.735, 3.850, 0.938> <-0.748, 3.950, 0.879> <-0.844, 4.000, 0.791> <-0.943, 3.960, 0.746> 
		<-0.617, 3.648, 0.560> <-0.635, 3.781, 0.482> <-0.635, 3.781, 0.482> <-0.718, 3.747, 0.444> 
		<-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 4.070, 0.964> <-1.186, 4.030, 0.919> <-1.259, 3.912, 0.930> <-1.245, 3.812, 0.988> 
		<-0.943, 3.960, 0.746> <-1.041, 3.920, 0.700> <-1.114, 3.802, 0.711> <-1.101, 3.702, 0.769> 
		<-0.718, 3.747, 0.444> <-0.826, 3.702, 0.395> <-0.826, 3.702, 0.395> <-0.808, 3.569, 0.474> 
		<-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 4.070, 0.964> <-1.186, 4.030, 0.919> <-1.259, 3.912, 0.930> <-1.245, 3.812, 0.988> 
		<-1.132, 4.104, 1.032> <-1.231, 4.064, 0.986> <-1.304, 3.946, 0.998> <-1.290, 3.846, 1.056> 
		<-1.117, 3.997, 1.093> <-1.192, 3.966, 1.059> <-1.192, 3.966, 1.059> <-1.182, 3.891, 1.103> 
		<-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.245, 3.812, 0.988> <-1.232, 3.713, 1.046> <-1.136, 3.662, 1.134> <-1.037, 3.702, 1.180> 
		<-1.101, 3.702, 0.769> <-1.087, 3.603, 0.828> <-0.992, 3.552, 0.916> <-0.893, 3.592, 0.961> 
		<-0.808, 3.569, 0.474> <-0.794, 3.459, 0.539> <-0.794, 3.459, 0.539> <-0.685, 3.504, 0.588> 
		<-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.245, 3.812, 0.988> <-1.232, 3.713, 1.046> <-1.136, 3.662, 1.134> <-1.037, 3.702, 1.180> 
		<-1.290, 3.846, 1.056> <-1.277, 3.747, 1.114> <-1.182, 3.697, 1.203> <-1.083, 3.737, 1.249> 
		<-1.182, 3.891, 1.103> <-1.172, 3.815, 1.148> <-1.172, 3.815, 1.148> <-1.096, 3.845, 1.182> 
		<-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.037, 3.702, 1.180> <-0.939, 3.742, 1.225> <-0.866, 3.861, 1.214> <-0.879, 3.960, 1.156> 
		<-1.083, 3.737, 1.249> <-0.984, 3.777, 1.294> <-0.911, 3.895, 1.282> <-0.924, 3.994, 1.224> 
		<-1.096, 3.845, 1.182> <-1.021, 3.876, 1.217> <-1.021, 3.876, 1.217> <-1.031, 3.952, 1.172> 
		<-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> <-1.107, 3.922, 1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.037, 3.702, 1.180> <-0.939, 3.742, 1.225> <-0.866, 3.861, 1.214> <-0.879, 3.960, 1.156> 
		<-0.893, 3.592, 0.961> <-0.794, 3.632, 1.007> <-0.721, 3.751, 0.996> <-0.735, 3.850, 0.938> 
		<-0.685, 3.504, 0.588> <-0.603, 3.538, 0.625> <-0.603, 3.538, 0.625> <-0.617, 3.648, 0.560> 
		<-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> <-0.700, 3.614, 0.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.463, 2.816, 0.479> <-1.441, 2.814, 0.365> <-1.364, 2.735, 0.280> <-1.294, 2.643, 0.294> 
		<-1.531, 2.761, 0.466> <-1.510, 2.760, 0.352> <-1.432, 2.681, 0.267> <-1.362, 2.590, 0.282> 
		<-1.453, 2.663, 0.479> <-1.437, 2.662, 0.393> <-1.437, 2.662, 0.393> <-1.384, 2.592, 0.404> 
		<-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.463, 2.816, 0.479> <-1.441, 2.814, 0.365> <-1.364, 2.735, 0.280> <-1.294, 2.643, 0.294> 
		<-1.242, 2.990, 0.519> <-1.220, 2.988, 0.405> <-1.143, 2.909, 0.320> <-1.073, 2.818, 0.334> 
		<-0.838, 3.160, 0.590> <-0.809, 3.158, 0.437> <-0.809, 3.158, 0.437> <-0.751, 3.081, 0.450> 
		<-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.294, 2.643, 0.294> <-1.224, 2.552, 0.308> <-1.183, 2.475, 0.418> <-1.205, 2.477, 0.532> 
		<-1.073, 2.818, 0.334> <-1.004, 2.726, 0.349> <-0.962, 2.650, 0.458> <-0.984, 2.651, 0.572> 
		<-0.751, 3.081, 0.450> <-0.674, 2.981, 0.467> <-0.674, 2.981, 0.467> <-0.704, 2.983, 0.620> 
		<-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.294, 2.643, 0.294> <-1.224, 2.552, 0.308> <-1.183, 2.475, 0.418> <-1.205, 2.477, 0.532> 
		<-1.362, 2.590, 0.282> <-1.292, 2.498, 0.296> <-1.252, 2.421, 0.405> <-1.273, 2.422, 0.519> 
		<-1.384, 2.592, 0.404> <-1.331, 2.522, 0.415> <-1.331, 2.522, 0.415> <-1.347, 2.523, 0.501> 
		<-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.205, 2.477, 0.532> <-1.226, 2.478, 0.646> <-1.303, 2.558, 0.730> <-1.373, 2.649, 0.716> 
		<-0.984, 2.651, 0.572> <-1.005, 2.653, 0.686> <-1.083, 2.732, 0.771> <-1.152, 2.823, 0.756> 
		<-0.704, 2.983, 0.620> <-0.728, 2.984, 0.746> <-0.728, 2.984, 0.746> <-0.804, 3.085, 0.729> 
		<-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.205, 2.477, 0.532> <-1.226, 2.478, 0.646> <-1.303, 2.558, 0.730> <-1.373, 2.649, 0.716> 
		<-1.273, 2.422, 0.519> <-1.295, 2.424, 0.633> <-1.373, 2.503, 0.718> <-1.443, 2.594, 0.703> 
		<-1.347, 2.523, 0.501> <-1.364, 2.524, 0.589> <-1.364, 2.524, 0.589> <-1.417, 2.594, 0.578> 
		<-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.373, 2.649, 0.716> <-1.443, 2.741, 0.702> <-1.484, 2.817, 0.592> <-1.463, 2.816, 0.479> 
		<-1.443, 2.594, 0.703> <-1.512, 2.686, 0.689> <-1.553, 2.763, 0.580> <-1.531, 2.761, 0.466> 
		<-1.417, 2.594, 0.578> <-1.470, 2.664, 0.567> <-1.470, 2.664, 0.567> <-1.453, 2.663, 0.479> 
		<-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> <-1.400, 2.593, 0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.373, 2.649, 0.716> <-1.443, 2.741, 0.702> <-1.484, 2.817, 0.592> <-1.463, 2.816, 0.479> 
		<-1.152, 2.823, 0.756> <-1.222, 2.915, 0.742> <-1.263, 2.992, 0.633> <-1.242, 2.990, 0.519> 
		<-0.804, 3.085, 0.729> <-0.862, 3.161, 0.716> <-0.862, 3.161, 0.716> <-0.838, 3.160, 0.590> 
		<-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> <-0.780, 3.083, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.274, 2.847, 1.035> <-1.277, 2.750, 0.972> <-1.197, 2.636, 0.963> <-1.100, 2.600, 1.014> 
		<-1.322, 2.808, 1.098> <-1.325, 2.711, 1.036> <-1.244, 2.597, 1.025> <-1.147, 2.561, 1.076> 
		<-1.214, 2.767, 1.151> <-1.217, 2.694, 1.104> <-1.217, 2.694, 1.104> <-1.143, 2.666, 1.143> 
		<-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.274, 2.847, 1.035> <-1.277, 2.750, 0.972> <-1.197, 2.636, 0.963> <-1.100, 2.600, 1.014> 
		<-1.120, 2.974, 0.832> <-1.123, 2.876, 0.770> <-1.043, 2.763, 0.760> <-0.946, 2.726, 0.811> 
		<-0.790, 3.124, 0.577> <-0.794, 2.994, 0.492> <-0.794, 2.994, 0.492> <-0.712, 2.964, 0.535> 
		<-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.100, 2.600, 1.014> <-1.002, 2.563, 1.065> <-0.916, 2.615, 1.162> <-0.913, 2.713, 1.225> 
		<-0.946, 2.726, 0.811> <-0.848, 2.690, 0.862> <-0.763, 2.742, 0.959> <-0.759, 2.839, 1.022> 
		<-0.712, 2.964, 0.535> <-0.605, 2.925, 0.592> <-0.605, 2.925, 0.592> <-0.601, 3.056, 0.677> 
		<-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.100, 2.600, 1.014> <-1.002, 2.563, 1.065> <-0.916, 2.615, 1.162> <-0.913, 2.713, 1.225> 
		<-1.147, 2.561, 1.076> <-1.049, 2.524, 1.127> <-0.964, 2.576, 1.225> <-0.961, 2.674, 1.288> 
		<-1.143, 2.666, 1.143> <-1.068, 2.638, 1.182> <-1.068, 2.638, 1.182> <-1.066, 2.712, 1.229> 
		<-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.913, 2.713, 1.225> <-0.910, 2.810, 1.288> <-0.990, 2.924, 1.297> <-1.087, 2.961, 1.246> 
		<-0.759, 2.839, 1.022> <-0.756, 2.937, 1.085> <-0.836, 3.051, 1.095> <-0.933, 3.087, 1.043> 
		<-0.601, 3.056, 0.677> <-0.598, 3.164, 0.747> <-0.598, 3.164, 0.747> <-0.705, 3.203, 0.690> 
		<-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.913, 2.713, 1.225> <-0.910, 2.810, 1.288> <-0.990, 2.924, 1.297> <-1.087, 2.961, 1.246> 
		<-0.961, 2.674, 1.288> <-0.957, 2.771, 1.351> <-1.038, 2.884, 1.361> <-1.135, 2.921, 1.310> 
		<-1.066, 2.712, 1.229> <-1.063, 2.787, 1.278> <-1.063, 2.787, 1.278> <-1.138, 2.815, 1.239> 
		<-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 2.961, 1.246> <-1.185, 2.997, 1.195> <-1.270, 2.945, 1.098> <-1.274, 2.847, 1.035> 
		<-1.135, 2.921, 1.310> <-1.233, 2.957, 1.259> <-1.318, 2.906, 1.161> <-1.322, 2.808, 1.098> 
		<-1.138, 2.815, 1.239> <-1.212, 2.842, 1.200> <-1.212, 2.842, 1.200> <-1.214, 2.767, 1.151> 
		<-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> <-1.140, 2.739, 1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 2.961, 1.246> <-1.185, 2.997, 1.195> <-1.270, 2.945, 1.098> <-1.274, 2.847, 1.035> 
		<-0.933, 3.087, 1.043> <-1.031, 3.123, 0.992> <-1.117, 3.071, 0.895> <-1.120, 2.974, 0.832> 
		<-0.705, 3.203, 0.690> <-0.786, 3.232, 0.647> <-0.786, 3.232, 0.647> <-0.790, 3.124, 0.577> 
		<-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> <-0.708, 3.095, 0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.765, 3.069, 0.442> <-0.903, 3.298, 0.442> <-1.067, 3.626, 0.442> <-0.839, 3.764, 0.442> 
		<-0.765, 3.069, 0.283> <-0.903, 3.298, 0.283> <-1.067, 3.626, 0.175> <-0.839, 3.764, 0.175> 
		<-0.649, 3.139, 0.147> <-0.786, 3.368, 0.147> <-0.786, 3.368, 0.147> <-0.650, 3.450, 0.147> 
		<-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.765, 3.069, 0.442> <-0.903, 3.298, 0.442> <-1.067, 3.626, 0.442> <-0.839, 3.764, 0.442> 
		<-0.765, 3.069, 0.602> <-0.903, 3.298, 0.602> <-1.067, 3.626, 0.709> <-0.839, 3.764, 0.709> 
		<-0.649, 3.139, 0.737> <-0.786, 3.368, 0.737> <-0.786, 3.368, 0.737> <-0.650, 3.450, 0.737> 
		<-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.839, 3.764, 0.442> <-0.610, 3.901, 0.442> <-0.397, 3.602, 0.442> <-0.259, 3.373, 0.442> 
		<-0.839, 3.764, 0.709> <-0.610, 3.901, 0.709> <-0.397, 3.602, 0.602> <-0.259, 3.373, 0.602> 
		<-0.650, 3.450, 0.737> <-0.513, 3.532, 0.737> <-0.513, 3.532, 0.737> <-0.376, 3.303, 0.737> 
		<-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.839, 3.764, 0.442> <-0.610, 3.901, 0.442> <-0.397, 3.602, 0.442> <-0.259, 3.373, 0.442> 
		<-0.839, 3.764, 0.175> <-0.610, 3.901, 0.175> <-0.397, 3.602, 0.283> <-0.259, 3.373, 0.283> 
		<-0.650, 3.450, 0.147> <-0.513, 3.532, 0.147> <-0.513, 3.532, 0.147> <-0.376, 3.303, 0.147> 
		<-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.259, 3.373, 0.442> <-0.168, 3.220, 0.442> <-0.175, 3.004, 0.442> <-0.327, 2.913, 0.442> 
		<-0.259, 3.373, 0.602> <-0.168, 3.220, 0.602> <-0.175, 3.004, 0.620> <-0.327, 2.913, 0.620> 
		<-0.376, 3.303, 0.737> <-0.284, 3.151, 0.737> <-0.284, 3.151, 0.737> <-0.421, 3.069, 0.737> 
		<-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.259, 3.373, 0.442> <-0.168, 3.220, 0.442> <-0.175, 3.004, 0.442> <-0.327, 2.913, 0.442> 
		<-0.259, 3.373, 0.283> <-0.168, 3.220, 0.283> <-0.175, 3.004, 0.265> <-0.327, 2.913, 0.265> 
		<-0.376, 3.303, 0.147> <-0.284, 3.151, 0.147> <-0.284, 3.151, 0.147> <-0.421, 3.069, 0.147> 
		<-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.327, 2.913, 0.442> <-0.480, 2.821, 0.442> <-0.674, 2.917, 0.442> <-0.765, 3.069, 0.442> 
		<-0.327, 2.913, 0.265> <-0.480, 2.821, 0.265> <-0.674, 2.917, 0.283> <-0.765, 3.069, 0.283> 
		<-0.421, 3.069, 0.147> <-0.557, 2.986, 0.147> <-0.557, 2.986, 0.147> <-0.649, 3.139, 0.147> 
		<-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> <-0.512, 3.221, 0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.327, 2.913, 0.442> <-0.480, 2.821, 0.442> <-0.674, 2.917, 0.442> <-0.765, 3.069, 0.442> 
		<-0.327, 2.913, 0.620> <-0.480, 2.821, 0.620> <-0.674, 2.917, 0.602> <-0.765, 3.069, 0.602> 
		<-0.421, 3.069, 0.737> <-0.557, 2.986, 0.737> <-0.557, 2.986, 0.737> <-0.649, 3.139, 0.737> 
		<-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> <-0.512, 3.221, 0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 3.990, 0.220> <-1.126, 4.044, 0.220> <-1.122, 4.119, 0.220> <-1.068, 4.119, 0.220> 
		<-1.126, 3.990, 0.167> <-1.126, 4.044, 0.167> <-1.122, 4.119, 0.151> <-1.068, 4.119, 0.151> 
		<-1.122, 3.990, 0.092> <-1.122, 4.060, 0.092> <-1.122, 4.060, 0.092> <-1.068, 4.060, 0.092> 
		<-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 3.990, 0.220> <-1.126, 4.044, 0.220> <-1.122, 4.119, 0.220> <-1.068, 4.119, 0.220> 
		<-1.126, 3.990, 0.274> <-1.126, 4.044, 0.274> <-1.122, 4.119, 0.290> <-1.068, 4.119, 0.290> 
		<-1.122, 3.990, 0.349> <-1.122, 4.060, 0.349> <-1.122, 4.060, 0.349> <-1.068, 4.060, 0.349> 
		<-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 4.119, 0.220> <-1.015, 4.119, 0.220> <-1.011, 4.044, 0.220> <-1.011, 3.990, 0.220> 
		<-1.068, 4.119, 0.290> <-1.015, 4.119, 0.290> <-1.011, 4.044, 0.274> <-1.011, 3.990, 0.274> 
		<-1.068, 4.060, 0.349> <-1.015, 4.060, 0.349> <-1.015, 4.060, 0.349> <-1.015, 3.990, 0.349> 
		<-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 4.119, 0.220> <-1.015, 4.119, 0.220> <-1.011, 4.044, 0.220> <-1.011, 3.990, 0.220> 
		<-1.068, 4.119, 0.151> <-1.015, 4.119, 0.151> <-1.011, 4.044, 0.167> <-1.011, 3.990, 0.167> 
		<-1.068, 4.060, 0.092> <-1.015, 4.060, 0.092> <-1.015, 4.060, 0.092> <-1.015, 3.990, 0.092> 
		<-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.011, 3.990, 0.220> <-1.011, 3.937, 0.220> <-1.015, 3.862, 0.220> <-1.068, 3.862, 0.220> 
		<-1.011, 3.990, 0.274> <-1.011, 3.937, 0.274> <-1.015, 3.862, 0.290> <-1.068, 3.862, 0.290> 
		<-1.015, 3.990, 0.349> <-1.015, 3.921, 0.349> <-1.015, 3.921, 0.349> <-1.068, 3.921, 0.349> 
		<-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.011, 3.990, 0.220> <-1.011, 3.937, 0.220> <-1.015, 3.862, 0.220> <-1.068, 3.862, 0.220> 
		<-1.011, 3.990, 0.167> <-1.011, 3.937, 0.167> <-1.015, 3.862, 0.151> <-1.068, 3.862, 0.151> 
		<-1.015, 3.990, 0.092> <-1.015, 3.921, 0.092> <-1.015, 3.921, 0.092> <-1.068, 3.921, 0.092> 
		<-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 3.862, 0.220> <-1.122, 3.862, 0.220> <-1.126, 3.937, 0.220> <-1.126, 3.990, 0.220> 
		<-1.068, 3.862, 0.151> <-1.122, 3.862, 0.151> <-1.126, 3.937, 0.167> <-1.126, 3.990, 0.167> 
		<-1.068, 3.921, 0.092> <-1.122, 3.921, 0.092> <-1.122, 3.921, 0.092> <-1.122, 3.990, 0.092> 
		<-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> <-1.068, 3.990, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 3.862, 0.220> <-1.122, 3.862, 0.220> <-1.126, 3.937, 0.220> <-1.126, 3.990, 0.220> 
		<-1.068, 3.862, 0.290> <-1.122, 3.862, 0.290> <-1.126, 3.937, 0.274> <-1.126, 3.990, 0.274> 
		<-1.068, 3.921, 0.349> <-1.122, 3.921, 0.349> <-1.122, 3.921, 0.349> <-1.122, 3.990, 0.349> 
		<-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> <-1.068, 3.990, 0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 4.090, 0.547> <-1.126, 4.143, 0.547> <-1.122, 4.218, 0.547> <-1.068, 4.218, 0.547> 
		<-1.126, 4.090, 0.494> <-1.126, 4.143, 0.494> <-1.122, 4.218, 0.478> <-1.068, 4.218, 0.478> 
		<-1.122, 4.090, 0.419> <-1.122, 4.159, 0.419> <-1.122, 4.159, 0.419> <-1.068, 4.159, 0.419> 
		<-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 4.090, 0.547> <-1.126, 4.143, 0.547> <-1.122, 4.218, 0.547> <-1.068, 4.218, 0.547> 
		<-1.126, 4.090, 0.601> <-1.126, 4.143, 0.601> <-1.122, 4.218, 0.617> <-1.068, 4.218, 0.617> 
		<-1.122, 4.090, 0.676> <-1.122, 4.159, 0.676> <-1.122, 4.159, 0.676> <-1.068, 4.159, 0.676> 
		<-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 4.218, 0.547> <-1.015, 4.218, 0.547> <-1.011, 4.143, 0.547> <-1.011, 4.090, 0.547> 
		<-1.068, 4.218, 0.617> <-1.015, 4.218, 0.617> <-1.011, 4.143, 0.601> <-1.011, 4.090, 0.601> 
		<-1.068, 4.159, 0.676> <-1.015, 4.159, 0.676> <-1.015, 4.159, 0.676> <-1.015, 4.090, 0.676> 
		<-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 4.218, 0.547> <-1.015, 4.218, 0.547> <-1.011, 4.143, 0.547> <-1.011, 4.090, 0.547> 
		<-1.068, 4.218, 0.478> <-1.015, 4.218, 0.478> <-1.011, 4.143, 0.494> <-1.011, 4.090, 0.494> 
		<-1.068, 4.159, 0.419> <-1.015, 4.159, 0.419> <-1.015, 4.159, 0.419> <-1.015, 4.090, 0.419> 
		<-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.011, 4.090, 0.547> <-1.011, 4.036, 0.547> <-1.015, 3.961, 0.547> <-1.068, 3.961, 0.547> 
		<-1.011, 4.090, 0.601> <-1.011, 4.036, 0.601> <-1.015, 3.961, 0.617> <-1.068, 3.961, 0.617> 
		<-1.015, 4.090, 0.676> <-1.015, 4.020, 0.676> <-1.015, 4.020, 0.676> <-1.068, 4.020, 0.676> 
		<-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.011, 4.090, 0.547> <-1.011, 4.036, 0.547> <-1.015, 3.961, 0.547> <-1.068, 3.961, 0.547> 
		<-1.011, 4.090, 0.494> <-1.011, 4.036, 0.494> <-1.015, 3.961, 0.478> <-1.068, 3.961, 0.478> 
		<-1.015, 4.090, 0.419> <-1.015, 4.020, 0.419> <-1.015, 4.020, 0.419> <-1.068, 4.020, 0.419> 
		<-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 3.961, 0.547> <-1.122, 3.961, 0.547> <-1.126, 4.036, 0.547> <-1.126, 4.090, 0.547> 
		<-1.068, 3.961, 0.478> <-1.122, 3.961, 0.478> <-1.126, 4.036, 0.494> <-1.126, 4.090, 0.494> 
		<-1.068, 4.020, 0.419> <-1.122, 4.020, 0.419> <-1.122, 4.020, 0.419> <-1.122, 4.090, 0.419> 
		<-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> <-1.068, 4.090, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, 3.961, 0.547> <-1.122, 3.961, 0.547> <-1.126, 4.036, 0.547> <-1.126, 4.090, 0.547> 
		<-1.068, 3.961, 0.617> <-1.122, 3.961, 0.617> <-1.126, 4.036, 0.601> <-1.126, 4.090, 0.601> 
		<-1.068, 4.020, 0.676> <-1.122, 4.020, 0.676> <-1.122, 4.020, 0.676> <-1.122, 4.090, 0.676> 
		<-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> <-1.068, 4.090, 0.676> 
	}
}
}

//pooki_eye_nose
#declare _POOKI_EYE_NOSE = object {
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.376, 3.650, 0.484> <-1.376, 3.669, 0.484> <-1.374, 3.697, 0.484> <-1.355, 3.697, 0.484> 
		<-1.376, 3.650, 0.463> <-1.376, 3.669, 0.463> <-1.374, 3.697, 0.458> <-1.355, 3.697, 0.458> 
		<-1.375, 3.650, 0.434> <-1.375, 3.676, 0.434> <-1.375, 3.676, 0.434> <-1.355, 3.676, 0.434> 
		<-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.376, 3.650, 0.484> <-1.376, 3.669, 0.484> <-1.374, 3.697, 0.484> <-1.355, 3.697, 0.484> 
		<-1.376, 3.650, 0.505> <-1.376, 3.669, 0.505> <-1.374, 3.697, 0.510> <-1.355, 3.697, 0.510> 
		<-1.375, 3.650, 0.534> <-1.375, 3.676, 0.534> <-1.375, 3.676, 0.534> <-1.355, 3.676, 0.534> 
		<-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.355, 3.697, 0.484> <-1.335, 3.697, 0.484> <-1.333, 3.669, 0.484> <-1.333, 3.650, 0.484> 
		<-1.355, 3.697, 0.510> <-1.335, 3.697, 0.510> <-1.333, 3.669, 0.505> <-1.333, 3.650, 0.505> 
		<-1.355, 3.676, 0.534> <-1.334, 3.676, 0.534> <-1.334, 3.676, 0.534> <-1.334, 3.650, 0.534> 
		<-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.355, 3.697, 0.484> <-1.335, 3.697, 0.484> <-1.333, 3.669, 0.484> <-1.333, 3.650, 0.484> 
		<-1.355, 3.697, 0.458> <-1.335, 3.697, 0.458> <-1.333, 3.669, 0.463> <-1.333, 3.650, 0.463> 
		<-1.355, 3.676, 0.434> <-1.334, 3.676, 0.434> <-1.334, 3.676, 0.434> <-1.334, 3.650, 0.434> 
		<-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.333, 3.650, 0.484> <-1.333, 3.630, 0.484> <-1.335, 3.603, 0.484> <-1.355, 3.603, 0.484> 
		<-1.333, 3.650, 0.505> <-1.333, 3.630, 0.505> <-1.335, 3.603, 0.510> <-1.355, 3.603, 0.510> 
		<-1.334, 3.650, 0.534> <-1.334, 3.624, 0.534> <-1.334, 3.624, 0.534> <-1.355, 3.624, 0.534> 
		<-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.333, 3.650, 0.484> <-1.333, 3.630, 0.484> <-1.335, 3.603, 0.484> <-1.355, 3.603, 0.484> 
		<-1.333, 3.650, 0.463> <-1.333, 3.630, 0.463> <-1.335, 3.603, 0.458> <-1.355, 3.603, 0.458> 
		<-1.334, 3.650, 0.434> <-1.334, 3.624, 0.434> <-1.334, 3.624, 0.434> <-1.355, 3.624, 0.434> 
		<-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.355, 3.603, 0.484> <-1.374, 3.603, 0.484> <-1.376, 3.630, 0.484> <-1.376, 3.650, 0.484> 
		<-1.355, 3.603, 0.458> <-1.374, 3.603, 0.458> <-1.376, 3.630, 0.463> <-1.376, 3.650, 0.463> 
		<-1.355, 3.624, 0.434> <-1.375, 3.624, 0.434> <-1.375, 3.624, 0.434> <-1.375, 3.650, 0.434> 
		<-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> <-1.355, 3.650, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.355, 3.603, 0.484> <-1.374, 3.603, 0.484> <-1.376, 3.630, 0.484> <-1.376, 3.650, 0.484> 
		<-1.355, 3.603, 0.510> <-1.374, 3.603, 0.510> <-1.376, 3.630, 0.505> <-1.376, 3.650, 0.505> 
		<-1.355, 3.624, 0.534> <-1.375, 3.624, 0.534> <-1.375, 3.624, 0.534> <-1.375, 3.650, 0.534> 
		<-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> <-1.355, 3.650, 0.534> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.304, 3.775, 0.321> <-1.333, 3.784, 0.307> <-1.323, 3.829, 0.312> <-1.315, 3.861, 0.316> 
		<-1.285, 3.775, 0.283> <-1.313, 3.784, 0.269> <-1.308, 3.829, 0.282> <-1.300, 3.861, 0.286> 
		<-1.259, 3.810, 0.255> <-1.288, 3.819, 0.241> <-1.288, 3.819, 0.241> <-1.277, 3.860, 0.246> 
		<-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.304, 3.775, 0.321> <-1.333, 3.784, 0.307> <-1.323, 3.829, 0.312> <-1.315, 3.861, 0.316> 
		<-1.324, 3.775, 0.360> <-1.352, 3.784, 0.345> <-1.338, 3.829, 0.342> <-1.330, 3.861, 0.346> 
		<-1.332, 3.810, 0.397> <-1.360, 3.819, 0.382> <-1.360, 3.819, 0.382> <-1.349, 3.860, 0.388> 
		<-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.315, 3.861, 0.316> <-1.307, 3.893, 0.320> <-1.294, 3.937, 0.327> <-1.265, 3.928, 0.341> 
		<-1.330, 3.861, 0.346> <-1.322, 3.893, 0.350> <-1.313, 3.937, 0.365> <-1.285, 3.928, 0.380> 
		<-1.349, 3.860, 0.388> <-1.339, 3.902, 0.393> <-1.339, 3.902, 0.393> <-1.311, 3.892, 0.408> 
		<-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.315, 3.861, 0.316> <-1.307, 3.893, 0.320> <-1.294, 3.937, 0.327> <-1.265, 3.928, 0.341> 
		<-1.300, 3.861, 0.286> <-1.292, 3.893, 0.291> <-1.274, 3.937, 0.289> <-1.246, 3.928, 0.303> 
		<-1.277, 3.860, 0.246> <-1.267, 3.902, 0.251> <-1.267, 3.902, 0.251> <-1.238, 3.892, 0.266> 
		<-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.265, 3.928, 0.341> <-1.237, 3.918, 0.356> <-1.247, 3.873, 0.351> <-1.255, 3.841, 0.347> 
		<-1.285, 3.928, 0.380> <-1.256, 3.918, 0.394> <-1.262, 3.873, 0.380> <-1.270, 3.841, 0.376> 
		<-1.311, 3.892, 0.408> <-1.282, 3.883, 0.422> <-1.282, 3.883, 0.422> <-1.293, 3.842, 0.417> 
		<-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.265, 3.928, 0.341> <-1.237, 3.918, 0.356> <-1.247, 3.873, 0.351> <-1.255, 3.841, 0.347> 
		<-1.246, 3.928, 0.303> <-1.217, 3.918, 0.318> <-1.232, 3.873, 0.321> <-1.240, 3.841, 0.317> 
		<-1.238, 3.892, 0.266> <-1.210, 3.883, 0.280> <-1.210, 3.883, 0.280> <-1.220, 3.842, 0.275> 
		<-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.255, 3.841, 0.347> <-1.263, 3.810, 0.342> <-1.276, 3.766, 0.336> <-1.304, 3.775, 0.321> 
		<-1.240, 3.841, 0.317> <-1.248, 3.810, 0.313> <-1.257, 3.766, 0.298> <-1.285, 3.775, 0.283> 
		<-1.220, 3.842, 0.275> <-1.231, 3.801, 0.270> <-1.231, 3.801, 0.270> <-1.259, 3.810, 0.255> 
		<-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> <-1.249, 3.851, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.255, 3.841, 0.347> <-1.263, 3.810, 0.342> <-1.276, 3.766, 0.336> <-1.304, 3.775, 0.321> 
		<-1.270, 3.841, 0.376> <-1.278, 3.810, 0.372> <-1.296, 3.766, 0.374> <-1.324, 3.775, 0.360> 
		<-1.293, 3.842, 0.417> <-1.303, 3.801, 0.411> <-1.303, 3.801, 0.411> <-1.332, 3.810, 0.397> 
		<-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> <-1.321, 3.851, 0.402> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.304, 3.803, 0.576> <-1.333, 3.812, 0.590> <-1.323, 3.857, 0.585> <-1.315, 3.889, 0.581> 
		<-1.324, 3.803, 0.538> <-1.352, 3.812, 0.552> <-1.338, 3.857, 0.556> <-1.330, 3.889, 0.552> 
		<-1.332, 3.838, 0.500> <-1.360, 3.847, 0.515> <-1.360, 3.847, 0.515> <-1.349, 3.889, 0.510> 
		<-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.304, 3.803, 0.576> <-1.333, 3.812, 0.590> <-1.323, 3.857, 0.585> <-1.315, 3.889, 0.581> 
		<-1.285, 3.803, 0.614> <-1.313, 3.812, 0.629> <-1.308, 3.857, 0.615> <-1.300, 3.889, 0.611> 
		<-1.259, 3.838, 0.642> <-1.288, 3.847, 0.657> <-1.288, 3.847, 0.657> <-1.277, 3.889, 0.651> 
		<-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.315, 3.889, 0.581> <-1.307, 3.921, 0.577> <-1.294, 3.965, 0.571> <-1.265, 3.956, 0.556> 
		<-1.300, 3.889, 0.611> <-1.292, 3.921, 0.607> <-1.274, 3.965, 0.609> <-1.246, 3.956, 0.594> 
		<-1.277, 3.889, 0.651> <-1.267, 3.930, 0.646> <-1.267, 3.930, 0.646> <-1.238, 3.921, 0.631> 
		<-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.315, 3.889, 0.581> <-1.307, 3.921, 0.577> <-1.294, 3.965, 0.571> <-1.265, 3.956, 0.556> 
		<-1.330, 3.889, 0.552> <-1.322, 3.921, 0.548> <-1.313, 3.965, 0.532> <-1.285, 3.956, 0.518> 
		<-1.349, 3.889, 0.510> <-1.339, 3.930, 0.504> <-1.339, 3.930, 0.504> <-1.311, 3.921, 0.490> 
		<-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.265, 3.956, 0.556> <-1.237, 3.947, 0.542> <-1.247, 3.902, 0.547> <-1.255, 3.870, 0.551> 
		<-1.246, 3.956, 0.594> <-1.217, 3.947, 0.580> <-1.232, 3.902, 0.576> <-1.240, 3.870, 0.580> 
		<-1.238, 3.921, 0.631> <-1.210, 3.912, 0.617> <-1.210, 3.912, 0.617> <-1.220, 3.870, 0.622> 
		<-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.265, 3.956, 0.556> <-1.237, 3.947, 0.542> <-1.247, 3.902, 0.547> <-1.255, 3.870, 0.551> 
		<-1.285, 3.956, 0.518> <-1.256, 3.947, 0.503> <-1.262, 3.902, 0.517> <-1.270, 3.870, 0.521> 
		<-1.311, 3.921, 0.490> <-1.282, 3.912, 0.475> <-1.282, 3.912, 0.475> <-1.293, 3.870, 0.481> 
		<-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.255, 3.870, 0.551> <-1.263, 3.838, 0.555> <-1.276, 3.794, 0.561> <-1.304, 3.803, 0.576> 
		<-1.270, 3.870, 0.521> <-1.278, 3.838, 0.525> <-1.296, 3.794, 0.523> <-1.324, 3.803, 0.538> 
		<-1.293, 3.870, 0.481> <-1.303, 3.829, 0.486> <-1.303, 3.829, 0.486> <-1.332, 3.838, 0.500> 
		<-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> <-1.321, 3.880, 0.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.255, 3.870, 0.551> <-1.263, 3.838, 0.555> <-1.276, 3.794, 0.561> <-1.304, 3.803, 0.576> 
		<-1.240, 3.870, 0.580> <-1.248, 3.838, 0.584> <-1.257, 3.794, 0.600> <-1.285, 3.803, 0.614> 
		<-1.220, 3.870, 0.622> <-1.231, 3.829, 0.628> <-1.231, 3.829, 0.628> <-1.259, 3.838, 0.642> 
		<-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> <-1.249, 3.880, 0.637> 
	}
}
}
   
#declare _DREAMER = union {
/*
** PJ's
*/      
union { 
   object {
      _PJ 
   }
   object { 
      _PJ_EAR_1 
   }
   object { 
      _PJ_EAR_2 
   }          
   #if (_SPEED_RENDER = 0) 
   texture {
      pigment {
         color rgb <0.706115, 0.643586, 0.387218>
      }      
      normal {
         bumps       , 0.2
         scale       0.025
      }             
      finish {
         ambient     0.0
         diffuse     1.0
         reflection  0.075
         crand       0.15
      }
   }   
   #else
   texture {
      pigment {
         color rgb <0.706115, 0.643586, 0.387218>
      }      
      finish {
         ambient     0.0
         diffuse     1.0
      }
   }   
   #end
} 
/* PJ ear insides */
#if (_SPEED_RENDER = 0)
union {
   object {
      _PJ_EAR_CENTER_1
   }
   object {
      _PJ_EAR_CENTER_2 
   }                
   texture {
      pigment {
         color rgb <0.840092, 0.806069, 0.666575>
      }      
      normal {
         bumps       , 0.2
         scale       0.025
      }             
      finish {
         ambient     0.0
         diffuse     1.0
         reflection  0.075
         crand       0.15
      }
   }             
}
union {
   object { _PJ_EYE_1 }
   object { _PJ_EYE_2 }
   object { _PJ_NOSE }
   texture {
      pigment {
         color rgb <0, 0, 0>
      }
      finish {
         ambient     0.3
         diffuse     0.5
         phong       0.7
         phong_size  20.0
      }
   }
}
union {
   object { _CLAW_1 }
   object { _CLAW_2 }
   texture {
      pigment {
         color rgb <0., 0., 0.>
      }      
      normal {
         bumps       , 0.2
         scale       0.025
      }             
      finish {
         ambient     0.0
         diffuse     1.0
         reflection  0.075
         crand       0.15
      }
   }             
}
#end

/*
** The kids face.
*/
union {
   object {
      _FACE_ANIME 
      texture {      
         pigment {
            color rgb <1.0, 0.75, 0.7>
         }                      
         #if (_SPEED_RENDER = 0)
         normal {
            bumps       , 1.0
            bump_size   0.1
            scale       0.0005
         }      
         finish {
            ambient     0.0
            //diffuse     0.85
            diffuse     1
            phong       0.2
            phong_size  100.0
            specular    0.2
            roughness   0.04
            reflection  0.025
            irid {
               0.15
               thickness   0.1
               turbulence  <2.0, 2.0, 2.0>               
            }
            crand       0.01
         }
         #else
         finish {
            ambient     0.0
            //diffuse     0.85
            diffuse     1.0
         }
         #end
      }              
   }
   object {
      _EYE_ANIME_1 
      texture {      
         pigment {
            image_map {
               png         "eye.png"
               interpolate 2
            }
            rotate <0, 90, 0>
            scale  <.25, .3, .25>
            translate <0, 0, .129>
         }      
         #if (_SPEED_RENDER = 0)
         finish {
            ambient     0.0
            diffuse     1.0
            phong       1.0
            phong_size  46.873333
            roughness   0.01
            reflection  0.514133
            irid {
               0.15
               thickness   0.1
               turbulence  <1.0, 1.0, 1.0>               
            }
         }
         #else
         finish {
            ambient     0.0
            diffuse     1.0
         }
         #end      
      }
   }
   object {
      _EYE_ANIME_2 
      texture {      
         pigment {
            image_map {
               png         "eye.png"
               interpolate 2
            }
            rotate <0, -90, 0>
            scale  <.25, .3, .25>
            translate <0, 0, -.129>
         }      
         #if (_SPEED_RENDER = 0)
         finish {
            ambient     0.0
            diffuse     1.0
            phong       1.0
            phong_size  46.873333
            roughness   0.01
            reflection  0.514133
            irid {
               0.15
               thickness   0.1
               turbulence  <1.0, 1.0, 1.0>               
            }
         }
         #else
         finish {
            ambient     0.0
            diffuse     1.0
         }
         #end      
      }
   }
   object { 
      _EYE_LASH_1       
      texture {      
         pigment {
            color rgb <0.0, 0.0, 0.0>
         }      
         #if (_SPEED_RENDER = 0)
         normal {
            radial      , 1
            bump_size   .5
            frequency   300
         }      
         finish {
            ambient     0.0047
            phong       1.0
            phong_size  100.0
            specular    1
            roughness   0.1
         }   
         #else
         finish {
            ambient     0.0047
         }   
         #end
      }    
   }
   object {
      _EYE_LASH_2 
      texture {      
         pigment {
            color rgb <0.0, 0.0, 0.0>
         }      
         #if (_SPEED_RENDER = 0)
         normal {
            radial      , 1
            bump_size   .5
            frequency   300
         }      
         finish {
            ambient     0.0047
            phong       1.0
            phong_size  100.0
            specular    1
            roughness   0.1
         }   
         #else
         finish {
            ambient     0.0047
         }   
         #end
      }    
   }
   object {          
      _BROW_1 
      texture {      
         pigment {
            color rgb <0.76, 0.453764, 0.330752>
         }      
         #if (_SPEED_RENDER = 0)
         normal {
            leopard , .5
            scale     <2.0, 0.002, 2>
         }      
         finish {
            ambient     0.0047
            phong       1.0
            phong_size  100.0
            specular    .1
            roughness   0.1
         }   
         #else
         finish {
            ambient     0.0047
         }   
         #end
      }
   }
   object {
      _BROW_2 
      texture {      
         pigment {
            color rgb <0.76, 0.453764, 0.330752>
         }      
         #if (_SPEED_RENDER = 0)
         normal {
            leopard , .5
            scale     <2.0, 0.002, 2>
         }      
         finish {
            ambient     0.0047
            phong       1.0
            phong_size  100.0
            specular    .1
            roughness   0.1
         }   
         #else
         finish {
            ambient     0.0047
         }   
         #end
      }
   }
   rotate <0, -45, 0>
}

#if (_SPEED_RENDER = 0)
object {
   _POOKI 
   texture {
      pigment {
         color rgb <1.0, 1.0, 1.0>
      }
      normal {
         leopard ,   0.1
         bump_size   0.1
         scale       0.001
      }      
      finish {
         ambient     0.0
         diffuse     1.0
         specular    0.2
         roughness   0.5
      }
   }
}
object { 
   _POOKI_EYE_NOSE 
   texture {
      pigment {
         color rgb <0, 0, 0>
      }
      finish {
         ambient     0.3
         diffuse     0.5
         phong       0.7
         phong_size  20.0
      }
   }
}
#end

}

#ifndef (_INCLUDED)
object {
   _DREAMER
   rotate      <0, 180-35, 0>  
   scale       3                
   translate   <0, -6, 5>
}                
#end